/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.calltree.editor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Vector;

import com.freescale.sa.ui.calltree.utils.EdgeRec;

public final class CallStackRec {
	public long funcId = (long) 0;
	public BigInteger callSiteId = BigInteger.ZERO;

	public CallStackRec() {
	} // ctor

	public CallStackRec(long _funcId, BigInteger _callSiteId) {
		funcId = _funcId;
		callSiteId = _callSiteId;
	} // ctor

	public static Vector<CallStackRec> getMaxCallStack(Collection<EdgeRec> allElements) {

		Vector<CallStackRec> tempElements = new Vector<CallStackRec>();

		for (EdgeRec edge : allElements) {
			if (edge.isInMaxCallStack.equals("true")) { //$NON-NLS-1$
				tempElements.add(new CallStackRec(edge.calleeId, edge.callSite));
			}
		}

		return tempElements;
	}

	public static Vector<CallStackRec> getMaxSizeStack(Collection<EdgeRec> allElements) {

		Vector<CallStackRec> tempElements = new Vector<CallStackRec>();

		for (EdgeRec edge : allElements) {
			if (edge.isInMaxSizeStack.equals("true")) { //$NON-NLS-1$
				tempElements.add(new CallStackRec(edge.calleeId, edge.callSite));
			}
		}

		return tempElements;
	}

} // class CallStackRec
