/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui.wizard;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.wizards.exportWizard.AExportSourcesWizard;

/**
 * Wizard used for exporting sources of the Peripherals tool.
 * @author Juraj Ondruska
 */
public class PeriphsExportSourcesWizard extends AExportSourcesWizard {

	/**
	 * Constructor.
	 */
	public PeriphsExportSourcesWizard() {
		super(UtilsText.safeString(Messages.get().PeriphsExportSourcesWizard_Title), "periphs_sources", SwToolsProduct.PRODUCT_ID_PERIPHERALS_TOOL); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.wizards.exportWizard.AExportWizard#generateFiles()
	 */
	@Override
	public GenerationResult generateFiles() {
		return GenerationResult.fail("This wizard should use another method."); //$NON-NLS-1$
		//@see generateCoreFiles()
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.wizards.exportWizard.AExportSourcesWizard#generateCoreFiles(com.nxp.swtools.provider.configuration.storage.common.StorageCore, com.nxp.swtools.provider.configuration.storage.ProcessorCore, java.lang.String)
	 */
	@Override
	protected GenerationResult generateCoreFiles(@NonNull ProcessorCore coreInfo, @NonNull String destination) {
		Controller controller = Controller.getInstance();
		controller.refreshIfChangeInOtherTool();
		GenerationResult result = controller.waitAndGetGenerationResult(coreInfo.getID());
		return result;
	}

}
