/**
 * Copyright 2018 NXP NXP                 
 * Created: 11. 1. 2018
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import java.util.List;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.model.config.IChild;

/**
 * Class, where are stored SettingConfigs and a header name of settings configuration
 * @author Marek Ciz
 */
public class TabularHorizontalItem {

	/** Setting Configs of current IChild */
	private @NonNull List<@NonNull IChild> childConfig;
	/** Header name that are displayed in table */
	private @NonNull String headerName;
	
	/**
	 * Constructor.
	 * @param headerName header name of settings configuration
	 * @param childConfig Setting Config of current IChild
	 */
	public TabularHorizontalItem(@NonNull String headerName, @NonNull List<@NonNull IChild> childConfig) {
		this.headerName = headerName;
		this.childConfig = childConfig;
	}
	
	/**
	 * @return String header name of settings configuration
	 */
	@NonNull String getHeaderName() {
		return headerName;
	}
	
	/**
	 * @return list of child configs 
	 */
	@NonNull List<@NonNull IChild> getChildConfigs() {
		return childConfig;
	}
}
