/**
* Copyright 2018 NXP
* Created: Feb 8, 2018
*/
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType;
import com.nxp.swtools.utils.TestIDs;
import com.nxp.swtools.utils.resources.IToolsImages;
import com.nxp.swtools.utils.resources.ToolsImages;

/**
 * A pushbutton for item menus in {@link ArrayControl} 
 * @author Viktar Paklonski
 */
public class ArrayControlItemMenuButton implements IArrayControlItemMenuControl {
	/** instance owner */
	protected final @NonNull AArrayControlStandard owner;
	/** pushbutton for menu display */
	protected final @NonNull Button button;
	/** pop-up menu */
	protected final @NonNull ArrayControlItemMenu menu;
	/** setting control for which the menu is shown */
	protected final @Nullable IChildControl selectedSettingHint;

	/**
	 * Prepares menu button for the specified widget.
	 * @param owner of the instance
	 * @param contentComposite to create content in
	 * @param setting control
	 */
	public ArrayControlItemMenuButton(@NonNull AArrayControlStandard owner, @NonNull Composite contentComposite, @NonNull IChildControl setting) {
		this.owner = owner;
		this.selectedSettingHint = setting;
		button = new Button(contentComposite, SWT.PUSH);
		button.setLayoutData(new GridDataComponents(SWT.CENTER, SWT.CENTER, false, false));
		button.setImage(ToolsImages.getImage(IToolsImages.ICON_ARRAY_MENU));
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				final Rectangle bounds = button.getBounds();
				assert bounds != null;
				final Control parent = button.getParent();
				assert parent != null;
				final Display display = button.getDisplay();
				assert display != null;
				menu.showUnder(bounds, parent, display);
			}
		});
		String testId = TestIDs.PERIPHS_ARRAY_ITEM_PROPERTIES_BUTTON + UtilsText.UNDERSCORE + setting.getChild().getId();
		SWTFactoryProxy.INSTANCE.setTestId(button, testId);
		updateButton(UpdateType.NORMAL);
		menu = new ArrayControlItemMenu(owner, this, button);
	}

	@Override
	public void dispose() {
		// NB: reverse creation order
		menu.dispose();
		button.dispose();
	}

	/**
	 * @return {@link #button}
	 */
	public @NonNull Button getButton() {
		return button;
	}

	@Override
	public @NonNull Menu getMenu() {
		return menu.getMenu();
	}

	@Override
	public @Nullable IChildControl getSelectedItemHint() {
		return selectedSettingHint;
	}

	@Override
	public void update(@Nullable UpdateType updateType) {
		menu.update(updateType);
		updateButton(updateType);
	}

	/**
	 * Refreshes menu button availability.
	 * @param updateType or {@code null} if update type is unknown
	 */
	private void updateButton(@Nullable UpdateType updateType) {
		final boolean allowed = (updateType != UpdateType.FORCE_DISABLE);
		button.setEnabled(allowed && (owner.isUiArrayReorderSpecified() || !owner.isUiArrayFixedSpecified()));
	}
}
