/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.config.SetConfig;

/**
 * Class representing control of a set setting configuration.
 * @author Juraj Ondruska
 */
public class SetControl extends ChildProvidableControlBase {

	/**
	 * @param childProvidable to create control for
	 * @param controllerWrapper containing the generic controller
	 */
	public SetControl(@NonNull SetConfig childProvidable, @NonNull IControllerWrapper controllerWrapper) {
		super(childProvidable, controllerWrapper);
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		final Composite contentCompositeLoc = createComposite(composite, ComponentSettingView.SET_COLS); 
		for (IChildControl childControl : children) {
			childControl.create(contentCompositeLoc, 1);
		}
		return (contentCompositeLoc == composite) ? null : contentCompositeLoc;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		final Control label = super.createLabelControl(composite);
		if (label != null) {
			createErrorDecoration(label, SWT.LEFT | SWT.TOP);
		}
		return label;
	}

}
