/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import com.nxp.swtools.common.ui.utils.swt.widgets.ReadOnlyText;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.config.ScalarConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;

/**
 * Class representing control of a scalar setting configuration. This class is intended for extension. Methods
 * {@link #createMainControl(Composite)} and
 * {@link #updateMainContent(Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)} should be overridden.
 * This implementation uses {@link ReadOnlyText} as an editor.
 * @author Juraj Ondruska
 */
public class ScalarControl extends ChildControlBase {
	/** Key for input used as control data */
	protected static final @NonNull String KEY_INPUT = "input"; //$NON-NLS-1$
	/** Key for viewer used as control data */
	protected static final @NonNull String KEY_VIEWER = "viewer"; //$NON-NLS-1$
	/** Key for listener used as control data */
	protected static final @NonNull String KEY_LISTENER = "listener"; //$NON-NLS-1$

	/**
	 * @param child to create control for
	 * @param controllerWrapper containing the generic controller
	 */
	public ScalarControl(@NonNull ScalarConfig child, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controllerWrapper);
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		ReadOnlyText text = new ReadOnlyText(composite, SWT.NONE);
		createErrorDecoration(text, SWT.TOP | SWT.LEFT);
		text.setBackground(composite.getBackground());
		text.setText(child.getUiName());
		addScrollListener(text, composite);
		return text;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, @NonNull UpdateType updateType) {
		if (contentControl instanceof ReadOnlyText) {
			((ReadOnlyText) contentControl).setText(child.getValue().toString());
			updateErrorDecoration(contentControl);
		}
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#getChild()
	 */
	@Override
	public @NonNull ScalarConfig getChild() {
		return (ScalarConfig) child;
	}
	
	/**
	 * Change value in the model.
	 * @param newVal to set
	 */
	protected void changeModelValue(@NonNull String newVal) {
		Control mainControlLoc = mainControl;
		assert (mainControlLoc != null);
		ProgressUtils.run((m) -> {
			controllerWrapper.getController().setValue(getChild(), newVal, mainControlLoc);
		});
	}
	
}
