/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.config.ScalarConfig;

/**
 * Class representing control of a check-box setting configuration.
 * @author Juraj Ondruska
 */
public class ScalarCheckboxControl extends ScalarControl {

	/**
	 * @param child to create control for
	 * @param controllerWrapper containing the generic controller
	 */
	public ScalarCheckboxControl(@NonNull ScalarConfig child, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controllerWrapper);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#create(org.eclipse.swt.widgets.Composite, int)
	 */
	@Override
	public void create(@NonNull Composite composite, int colSpan) {
		super.create(composite, colSpan);
		// make checkbox react only when clicked directly on it - don't react when clicked on an empty space next to a checkbox
		if (mainControl != null) {
			mainControl.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false, colSpan - 1, 1));
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ScalarControl#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		Button button = new Button(composite, SWT.CHECK);
		button.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				changeModelValue(UtilsText.safeString(Boolean.toString(button.getSelection())));
			}
		});
		createErrorDecoration(button, SWT.LEFT | SWT.TOP);
		return button;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, UpdateType updateType) {
		if (updateType != UpdateType.PROBLEM_DECORATION) {
			 ((Button) contentControl).setSelection(Boolean.parseBoolean(child.getValue().toString()));
		}
		updateErrorDecoration(contentControl);
	}
}
