/**
 * Copyright 2017 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Logger;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Text;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;

/**
 * Adapter used for adjusting focus listener to a text-modify listener. This listener is usable only for {@link Text} widget.
 * @author Juraj Ondruska
 */
public abstract class ModifyTextFocusListenerAdapter implements FocusListener {
	/** Logger of the class */
	private static final @NonNull Logger LOGGER = LogManager.getLogger(ModifyTextFocusListenerAdapter.class);
	/** The lastly used text */
	private @Nullable String lastText;
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
	 */
	@Override
	public final void focusLost(FocusEvent e) {
		if (e.widget instanceof Text) {
			String currentText = ((Text) e.widget).getText();
			if (!Objects.equals(lastText, currentText)) {
				textModified();
			}
		} else {
			String message = MessageFormat.format("The {0} is intended for usage with {1}, but it was used with {2}", //$NON-NLS-1$
					getClass().getSimpleName(), Text.class.getSimpleName(), e.widget.getClass().getSimpleName());
			LOGGER.severe(message);
		}
	}
	
	/**
	 * Called on focus-out only when text was changed.
	 */
	protected abstract void textModified();
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.FocusListener#focusGained(org.eclipse.swt.events.FocusEvent)
	 */
	@Override
	public final void focusGained(FocusEvent e) {
		if (e.widget instanceof Text) {
			lastText = UtilsText.safeString(((Text) e.widget).getText());
		} else {
			String message = MessageFormat.format("The {0} is intended for usage with {1}, but it was used with {2}", //$NON-NLS-1$
					getClass().getSimpleName(), Text.class.getSimpleName(), e.widget.getClass().getSimpleName());
			LOGGER.severe(message);
		}
	}
}
