/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.widgets.Composite;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.model.config.IChild;

/**
 * Interface representing control of a setting configuration.
 * @author Juraj Ondruska
 */
public interface IChildControl {

	/**
	 * Create content.
	 * @param composite to create content in
	 * @param colSpan column span to use
	 */
	public void create(@NonNull Composite composite, int colSpan);

	/**
	 * Dispose control.
	 */
	public void dispose();

	/**
	 * @return {@code true} if {@link #dispose()} has been called, {@code false} otherwise
	 */
	public boolean isDisposed();
	
	/**
	 * Update control.
	 * @param updateType type of the update to perform
	 */
	public void update(@NonNull UpdateType updateType);

	/**
	 * @return setting configuration for which the control is created
	 */
	public @NonNull IChild getChild();

	/**
	 * @return composite with created content
	 */
	public @Nullable Composite getContent();
	
	/**
	 * @return UI options of child
	 */
	public @NonNull ControlOptions getControlOptions();

	/**
	 * Type of an update.
	 * @author Juraj Ondruska
	 */
	public static enum UpdateType {
		/** Ordinary update */
		NORMAL,
		/** Force disabling */
		FORCE_DISABLE,
		/** Update the problem decoration */
		PROBLEM_DECORATION
	}
	
}
