/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;

/**
 * Class used for providing proper input to a Component Setting View. 
 * @author Juraj Ondruska
 */
public class ComponentSettingViewInput {
	/** Component which should be edited */
	private @NonNull String component;
	/** Component type */
	private @NonNull String componentType;
	/** Whether configuring global component configSet */
	private final boolean globalConfig;
	
	
	/**
	 * Constructor.
	 * @param componentType type of a component to be edited
	 * @param component to be edited
	 * @param globalConfig whether configuring global component configSet
	 */
	public ComponentSettingViewInput(@NonNull String componentType, @NonNull String component, boolean globalConfig) {
		this.component = component;
		this.componentType = componentType;
		this.globalConfig = globalConfig;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + component.hashCode();
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ComponentSettingViewInput other = (ComponentSettingViewInput) obj;
		if (!component.equals(other.component))
			return false;
		return true;
	}

	/**
	 * @return {@code true} if configuring global component configSet, {@code false} otherwise
	 */
	public boolean isGlobalConfig() {
		return globalConfig;
	}

	/**
	 * @return the component
	 */
	public @NonNull String getComponent() {
		return component;
	}

	/**
	 * @param component the component to set
	 */
	public void setComponent(@NonNull String component) {
		this.component = component;
	}

	/**
	 * @return the componentType
	 */
	public @NonNull String getComponentType() {
		return componentType;
	}

	/**
	 * @param componentType the componentType to set
	 */
	public void setComponentType(@NonNull String componentType) {
		this.componentType = componentType;
	}
	
}
