/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import java.util.Objects;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlInternalFactory;
import com.nxp.swtools.periphs.model.config.ArrayConfig;

/**
 * Class representing control of an array setting configuration.
 * @author Juraj Ondruska
 * @author Tomas Rudolf - nxf31690
 */
public class ArrayControl extends ChildProvidableControlBase {
	/** The delegate control */
	@NonNull private AArrayControlInternal delegate;

	/**
	 * @param childProvidable to create control for
	 * @param controllerWrapper containing the generic controller
	 */
	public ArrayControl(@NonNull ArrayConfig childProvidable, @NonNull IControllerWrapper controllerWrapper) {
		super(childProvidable, controllerWrapper);
		this.delegate = ArrayControlInternalFactory.create(childProvidable, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#create(org.eclipse.swt.widgets.Composite, int, boolean)
	 */
	@Override
	public void create(@NonNull Composite composite, int colSpan) {
		delegate.create(composite, colSpan);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		// This is never called as create is passed to delegate
		return null;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		// This is never called as create is passed to delegate
		return null;
	}

    /* (non-Javadoc)
     * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
     */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, @NonNull UpdateType updateType) {
		// This is never called as update is passed to delegate
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#update(com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	public void update(@NonNull UpdateType updateType) {
		delegate.update(updateType);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildProvidableControlBase#getChild()
	 */
	@Override
	public @NonNull ArrayConfig getChild() {
		return (ArrayConfig) child;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildProvidableControlBase#dispose()
	 */
	@Override
	public void dispose() {
		delegate.dispose();
		super.dispose();
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#getControlOptions()
	 */
	@Override
	public @NonNull ControlOptions getControlOptions() {
		if (!Objects.isNull(delegate)) { // required because this method is called in super(), before delegate is initialized
			return delegate.getControlOptions();
		}
		// at the time when delegate is not yet initialized, it is ok to use controlOptions of this ArrayControl instead,
		// because it equals to controlOptions created later for delegate
		return controlOptions;
	}
}
