/**
 * Copyright 2018 NXP
 */
package com.nxp.swtools.periphs.gui.utils;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

/**
 * {@link GC} utilities.
 * @author Juraj Ondruska
 */
public class GcUtils {

	/**
	 * Get width of the M character.
	 * @param control with the font
	 * @param estimated whether to use the faster approach with estimation instead of computing the 'M' width via {@link GC}
	 * @return width of the M character
	 */
	public static int getEmWidth(Control control, boolean estimated) {
		int emWidth = 0;
		final FontData[] fontData = control.getFont().getFontData();
		if (estimated && fontData.length > 0) {
			// try the faster estimate approach
			int height = (fontData[0].getHeight() * control.getDisplay().getDPI().y) / 72;
			emWidth = (height * 6) / 7;
		} else {
			// try the slower exact approach
			GC gc = new GC(control);
			emWidth = gc.getCharWidth('M');
			gc.dispose();
		}
		return emWidth;
	}
	
}
