/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui.perspective;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.periphs.gui.view.ComponentsView;
import com.nxp.swtools.periphs.gui.view.DefaultComponentSettingsView;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.periphs.gui.view.PeripheralsView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.utils.TestIDs;
import com.nxp.swtools.utils.logging.UserLogView;
import com.nxp.swtools.utils.perspective.ToolsBasePerspective;
import com.nxp.swtools.utils.sources.SourcesView;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;

/**
 * Class representing perspective of a Peripherals tool
 * @author Juraj Ondruska
 */
public class PeripheralsPerspective extends ToolsBasePerspective {
	/** ID of the perspective */
	public static final String ID = "com.nxp.swtools.periphs.gui.perspective"; //$NON-NLS-1$
	/** ID of internal debug view. Used in placeholder */
	private static final String DEBUG_VIEW_ID = "com.nxp.swtools.periphs.internal_development.view.DebugView"; //$NON-NLS-1$
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.perspective.ToolsBasePerspective#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);
		final String editorFolderId = "editorFolder"; //$NON-NLS-1$
		final String mainFolderId = "mainFolder"; //$NON-NLS-1$
		final String sharedFolderId = "sharedFolder"; //$NON-NLS-1$
		layout.setEditorAreaVisible(false);
		String editorArea = layout.getEditorArea();
		IFolderLayout mainFolder = layout.createFolder(mainFolderId, IPageLayout.LEFT, 0.20f, editorArea); 
		mainFolder.addView(PeripheralsView.ID);
		mainFolder.addView(ComponentsView.ID);
		IFolderLayout sharedFolder = layout.createFolder(sharedFolderId, IPageLayout.RIGHT, 0.68f, editorArea); 
		sharedFolder.addView(TestIDs.DASHBOARD_VIEW_ID); //this should be visible by default, if new configuration is created so user can esily switch to different tool
		sharedFolder.addView(SourcesView.ID);
		sharedFolder.addPlaceholder(DocumentationView.ID + ":*"); //$NON-NLS-1$
		sharedFolder.addPlaceholder(DEBUG_VIEW_ID);
		layout.addView(ValidationEngineFactory.VIEW_ID, IPageLayout.BOTTOM, 0.75f, sharedFolderId);
		addCheatSheetViewPlaceholder(layout);
		addConsoleViewPlaceholder(layout);
		IFolderLayout editorFolder = layout.createFolder(editorFolderId, IPageLayout.RIGHT, 0.5f, editorArea); 
		editorFolder.addView(DefaultComponentSettingsView.ID);
		editorFolder.addPlaceholder(ComponentSettingView.ID + ":*"); //$NON-NLS-1$
		if (Rap.isActive()) {
			// one window can hold multiple view, each view being represented by a tab
			// it can happen that RAP will hide the tab of the first added view, if there is not enough space to show all tabs
			// but the content of the hidden tab is still visible in the window
			// workaround -> select some other (i.e. not the first one) view to make it active
			UIJobHelper.runNowOrInJob(() -> PerspectivesHelper.showView(ComponentsView.ID), "Selecting Components View", null); //$NON-NLS-1$
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.perspective.ToolsBasePerspective#getDefinedViewIDs()
	 */
	@Override
	public List<String> getDefinedViewIDs() {
		return CollectionsUtils.unmodifiableList(new ArrayList<String>() {
			/** serialVersionUID */
			private static final long serialVersionUID = 1L;
			{
				add(PeripheralsView.ID);
				add(ComponentsView.ID);
				add(SourcesView.ID);
				add(UserLogView.ID);
				add(ValidationEngineFactory.VIEW_ID);
				if (!Rap.isActive()) {
					add(TestIDs.DASHBOARD_VIEW_ID);
				}
			}
		});
	}
}
