/**
 * Copyright 2018 NXP               
 * Created: 8. 2. 2018
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.utils.command.ResetToProcessorDefaultsDialog;

/**
 * Handler for reset to processor defaults command (reset currently active/edited function, properties remain)
 * @author Marek Ciz
 */
public class ResetToProcessorDefaultHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		FunctionalGroup functionalGroup = Controller.getInstance().getFunctionalGroup();
		Display display = Display.getCurrent();
		assert display != null;
		int result = ResetToProcessorDefaultsDialog.open(display.getActiveShell(), functionalGroup.getName());
		if (result == IDialogConstants.OK_ID) {
			// delete all components
			Controller.getInstance().resetToProcessorDefault(functionalGroup);
		}
		return null;
	}
}
