/**
 * Copyright 2018 NXP               
 * Created: 8. 2. 2018
 */
package com.nxp.swtools.periphs.gui.handler;

import java.util.List;
import java.util.logging.Logger;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.command.BoardResetDialog;

/**
 * Handler for reset board command
 * @author Marek Ciz
 *
 */
public class ResetToBoardDefaultHandler extends AbstractHandler {

	/** Logger of the class */
	private static final Logger LOGGER = LogManager.getLogger(ResetToBoardDefaultHandler.class);
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		FunctionalGroup changedFuncGroup = Controller.getInstance().getFunctionalGroup();
		Shell parentShell = ShellProvider.getAnyShellParent();
		IMcu mcu = Controller.getInstance().getMcu();
		String boardOrKit = (mcu.getBoard() != null) ? mcu.getBoard() : mcu.getKit();
		ISharedConfiguration sharedConfigurationLoc = ConfigurationUtils.loadBoardConfiguration(boardOrKit, mcu.getSdkVersion());
		if (sharedConfigurationLoc != null) {
			StoragePeriphsTool periphs = sharedConfigurationLoc.getTools().getPeripherals();
			if (periphs != null) {
				List<StoragePeriphsFuncGroup> functions = periphs.getFuncGroups();
				List<String> funcNames = functions.stream().map(f -> f.getConfigurationName()).collect(CollectorsUtils.toList());
				BoardResetDialog dialog = new BoardResetDialog(parentShell, funcNames, changedFuncGroup.getName());
				if (dialog.open() == IDialogConstants.OK_ID) {
					Controller.getInstance().resetToStorageFuncGroup(functions, UtilsText.safeString(dialog.getSelectedConfiguration()), changedFuncGroup.getStorageFuncGroup());
				}
			} else {
				LOGGER.severe("Can't load storage functional group to reset board defaults"); //$NON-NLS-1$
			}
		} else {
			LOGGER.severe("Unable to load shared configuration to reset board defaults"); //$NON-NLS-1$
		}
		return null;
	}
}
