 /**
 * Copyright 2019 NXP
 * Created: Jan 30, 2019
 */
package com.nxp.swtools.periphs.gui.controller;

import com.nxp.swtools.periphs.controller.APeriphController;

/**
 * Abstract class used to pass down parametrized controllers to products
 * @author Rares-Mihai Gafton nxf38680
 *
 */
public abstract class AControllerWrapper implements IControllerWrapper {
	/** Controller object used for event handling in tools */
	protected APeriphController controller;
	/** Controller object used for event handling while interacting with GUI in tools */
	protected APeriphGUIController guiController;
	
	/**
	 * Constructor
	 * @param controller
	 * @param guiController
	 */
	public AControllerWrapper(APeriphController controller, APeriphGUIController guiController) {
		super();
		this.controller = controller;
		this.guiController = guiController;
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.common.utils.controller.IControllerWrapper#getController()
	 */
	@Override
	public APeriphController getController() {
		return controller;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.common.utils.controller.IControllerWrapper#getGUIController()
	 */
	@Override
	public APeriphGUIController getGUIController() {
		return guiController;
	}
}
