/**
 * Copyright 2017-2018 NXP
 * Created: Sep 18, 2017
 */
package com.nxp.swtools.periphs.gui;

import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.tools.ITool;

/**
 * Implementation of {@link ITool} for Peripherals tool 
 * @author Marek Trmac
 */
public class PeripheralsTool implements ITool {

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#getToolId()
	 */
	@Override
	public String getToolId() {
		return SwToolsProduct.PRODUCT_ID_PERIPHERALS_TOOL;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#isProcessorSupported(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean isProcessorSupported(ISharedConfiguration configuration) {
		return Controller.getInstance().isMcuSupported(configuration.getCommonConfig());
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#isUpdated(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean isUpdated(ISharedConfiguration configuration) {
		return !Controller.getInstance().isCodeDirty();
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#waitForUpdated(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean waitUntilUpdated(ISharedConfiguration configuration) {
		final Controller controller = Controller.getInstance();
		controller.refreshIfChangeInOtherTool();
		return controller.waitUntilRegenerated();
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#createStorageTool(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public StorageTool createStorageTool(ISharedConfiguration sharedConfig) {
		assert (sharedConfig.getTools().getPeripherals() == null);
		final StoragePeriphsTool result = new StoragePeriphsTool();
		return result; 
	}

}
