/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.perspective.PeripheralsPerspective;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;

/**
 * Class implementing startup of the peripherals tool
 * @author Juraj Ondruska
 */
public class PeripheralsStartup implements IStartup {
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IStartup#earlyStartup()
	 */
	@Override
	public void earlyStartup() {
		Controller.getInstance();
		if (!SWToolsProperties.isHeadlessOn()) {
			// add listener to refresh everything when switched to peripherals tool
			PerspectiveAdapter perspectiveListener = new PerspectiveAdapter() {
				/* (non-Javadoc)
				 * @see org.eclipse.ui.PerspectiveAdapter#perspectiveActivated(org.eclipse.ui.IWorkbenchPage, org.eclipse.ui.IPerspectiveDescriptor)
				 */
				@Override
				public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
					if (perspective.getId().equals(PeripheralsPerspective.ID)) {
						// refresh when perspective switches
						Controller.getInstance().softRefresh(); // use only soft refresh because full refresh would drop all the model objects and re-create them, see MCUXCON-2882
					}
				}

				@Override
				public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
					if (perspective.getId().equals(PeripheralsPerspective.ID)) {
						if (changeId.equals(IWorkbenchPage.CHANGE_RESET)) {
							ComponentSettingViewHelper.getInstance().setRemoveState(ComponentSettingViewHelper.REMOVE_DISABLED);
						}
						if (changeId.equals(IWorkbenchPage.CHANGE_RESET_COMPLETE)) {
							ComponentSettingViewHelper.getInstance().setRemoveState(ComponentSettingViewHelper.REMOVE_ENABLED);
							IViewPart viewPart = ComponentSettingViewHelper.getViewPart();
							if (viewPart == null) {
								// No active view
								return;
							}
							IViewSite viewSite = viewPart.getViewSite();
							if (viewSite == null) {
								return;
							}
						}
					}
				}
			};
			// Perspective listener
			IWorkbench workbench = PlatformUI.getWorkbench();
			ComponentSettingViewHelper.getInstance();
			workbench.getActiveWorkbenchWindow().addPerspectiveListener(perspectiveListener);
			// Workbench listener
			workbench.addWorkbenchListener( new IWorkbenchListener()
			{
				@SuppressWarnings({ "null", "unused" }) //customer reported exception where the viewHelper was null
				@Override
				public boolean preShutdown(@Nullable IWorkbench activeWorkbench, boolean forced) {
					// Do not allow editors to save that they were closed
					ComponentSettingViewHelper viewHelper = ComponentSettingViewHelper.getInstance();
					if (viewHelper != null) {
						viewHelper.switchRemoveState();
						viewHelper.saveEditors();
					} else {
						assert false : "Null ComponentSettingViewHelper.getInstance()";  //$NON-NLS-1$
					}
					return true;
				}
				@Override
				public void postShutdown(@Nullable IWorkbench activeWorkbench) {
					// Do nothing
				}
			});
		}
	}
}
