/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui;

import java.util.Locale;

import org.eclipse.osgi.util.NLS;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;

/**
 * Messages of the Peripherals tool
 * @author Juraj Ondruska
 */
//the entire package is @NonNullByDefault
@SuppressWarnings("javadoc")
public class Messages extends NLS {
	private static final String BUNDLE_NAME = "com.nxp.swtools.periphs.gui.messages"; //$NON-NLS-1$
	public String AArrayControlInternal_RemoveItemConfirmationQuestion = UtilsText.MISSING_MSG;
	public String AArrayControlInternal_RemoveItemTitle = UtilsText.MISSING_MSG;
	public String AddComponentDialog_Column_Category = UtilsText.MISSING_MSG;
	public String AddComponentDialog_Column_Name = UtilsText.MISSING_MSG;
	public String AddComponentDialog_Column_Version = UtilsText.MISSING_MSG;
	public String AddComponentDialog_Filter_ShowOnlyLatestComps = UtilsText.MISSING_MSG;
	public String AddComponentDialog_Filter_ShowOnlyCompsFromToolchainProject = UtilsText.MISSING_MSG;
	public String AddComponentDialog_LimitReached_Message = UtilsText.MISSING_MSG;
	public String AddComponentDialog_LimitReached_Title = UtilsText.MISSING_MSG;
	public String AddComponentDialog_NoAvailablePeripherals_Tooltip = UtilsText.MISSING_MSG;
	public String AddComponentDialog_ComponentPeripheralUnavailableForCore_Tooltip = UtilsText.MISSING_MSG;
	public String ArrayControl_Column_IndexTitle = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_MoveBottom = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_MoveDown = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_MoveTop = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_MoveUp = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_Remove = UtilsText.MISSING_MSG;
	public String ArrayControl_ItemMenu_SetAllItems = UtilsText.MISSING_MSG;
	public String ArrayControlMasterDetail_AddNewItem = UtilsText.MISSING_MSG;
	public String ChildControl_Copy = UtilsText.MISSING_MSG;
	public String ChildControl_Paste = UtilsText.MISSING_MSG;
	public String ChildControl_Paste_AsNewItem = UtilsText.MISSING_MSG;
	public String ComponentEditor_ComponentGlobalSettings = UtilsText.MISSING_MSG;
	public String ComponentEditor_GlobalConfigurationOf = UtilsText.MISSING_MSG;
	public String ComponentEditor_Mode = UtilsText.MISSING_MSG;
	public String ComponentEditor_ModeDescription = UtilsText.MISSING_MSG;
	public String ComponentEditor_Name = UtilsText.MISSING_MSG;
	public String ComponentEditor_NameNotUniqueError = UtilsText.MISSING_MSG;
	public String ComponentEditor_NameNotIdentifierError = UtilsText.MISSING_MSG;
	public String ComponentEditor_NameDescription = UtilsText.MISSING_MSG;
	public String ComponentEditor_Peripheral = UtilsText.MISSING_MSG;
	public String ComponentEditor_Peripherals = UtilsText.MISSING_MSG;
	public String ComponentEditor_PeripheralDescription = UtilsText.MISSING_MSG;
	public String ComponentMenuCreator_actionAddComponentInstance = UtilsText.MISSING_MSG;
	public String ComponentSettingView_ComponentHasNoGlobalConfigSet = UtilsText.MISSING_MSG;
	public String ComponentSettingView_Documentation = UtilsText.MISSING_MSG;
	public String ComponentSettingView_EnableDisableComponentInstance = UtilsText.MISSING_MSG;
	public String ComponentsView_CategoryAddButtonTooltip = UtilsText.MISSING_MSG;
	public String ComponentsView_CategoryOther_Description = UtilsText.MISSING_MSG;
	public String ComponentsView_CategoryOther_UiName = UtilsText.MISSING_MSG;
	public String ComponentsView_Column_Category = UtilsText.MISSING_MSG;
	public String ComponentsView_Column_ConfigurationComponent = UtilsText.MISSING_MSG;
	public String ComponentsView_ComponentPopUp_Documentation = UtilsText.MISSING_MSG;
	public String ComponentsView_ComponentPopUp_Remove = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentDialog_Message = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentDialog_RemovingLastInstance_Title = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentDialog_RemovingLastInstance_Message = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentInstancesDialog_Confirmation = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentInstancesDialog_Title = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentInstancesDialog_Message = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentInstancesDialog_OneInstance = UtilsText.MISSING_MSG;
	public String ComponentsView_RemoveComponentDialog_Cancel = UtilsText.MISSING_MSG;
	public String ComponentsView_SelectComponentDialog_OK = UtilsText.MISSING_MSG;
	public String ComponentsView_SelectComponentDialog_Title = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_EnabledState = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_DisabledState = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_MoveTo = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_CopyTo = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_EnableSlashDisable = UtilsText.MISSING_MSG;
	public String ComponentsView_Menu_Open = UtilsText.MISSING_MSG;
	public String ComponentsView_AddButtonTooltip = UtilsText.MISSING_MSG;
	public String ComponentsView_FilterTooltip = UtilsText.MISSING_MSG;
	public String ComponentsView_Tooltips_Component = UtilsText.MISSING_MSG;
	public String ComponentsView_Tooltips_Disabled = UtilsText.MISSING_MSG;
	public String ComponentsView_Tooltips_TypeId = UtilsText.MISSING_MSG;
	public String ComponentsView_Tooltips_SdkReferences = UtilsText.MISSING_MSG;
	public String ComponentsView_Tooltips_Status = UtilsText.MISSING_MSG;
	public String ConfigSetControl_ConfigSetComboDescription = UtilsText.MISSING_MSG;
	public String ConfigSetControl_ConfigSetComboTitle = UtilsText.MISSING_MSG;
	public String ConfigSetControl_QuickSelection_Custom = UtilsText.MISSING_MSG;
	public String ConfigurationState_Disabled = UtilsText.MISSING_MSG;
	public String DefaultComponentSettingsView_Label = UtilsText.MISSING_MSG;
	public String GenericPeripheralsResolverHandler_ActivatePeripheralsTool = UtilsText.MISSING_MSG;
	public String PeripheralInitResolveHandler_ConfigurePeripheral = UtilsText.MISSING_MSG;
	public String PeripheralInitResolveHandler_Enable_Instances = UtilsText.MISSING_MSG;
	public String PeripheralsStartup_ActivatePeripheralsQuestionMessage = UtilsText.MISSING_MSG;
	public String PeripheralsView_Dependency_RequiredBy = UtilsText.MISSING_MSG;
	public String PeripheralsView_DisabledComponentLabel = UtilsText.MISSING_MSG;
	public String PeripheralsView_FilterTooltip = UtilsText.MISSING_MSG;
	public String PeripheralsView_PeripheralColumn = UtilsText.MISSING_MSG;
	public String PeripheralsView_ShowOnlyUsedOrRequestedPeripherals = UtilsText.MISSING_MSG;
	public String PeripheralsView_UsedInColumn = UtilsText.MISSING_MSG;
	public String PeriphsExportSourcesWizard_Title = UtilsText.MISSING_MSG;
	public String PeriphsExportHTMLWizard_Title = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_CalledFromDefaultInit = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_Core = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_CoreTooltip = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_IdPrefix = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_IdPrefixTooltip = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_TitleFunctionalGroupProperties = UtilsText.MISSING_MSG;
	public String PeriphsFunctionalGroupDialog_TitleNewFunctionalGroup = UtilsText.MISSING_MSG;
	public String PeriphsImportSourcesWizard_SelectSources = UtilsText.MISSING_MSG;
	public String PeriphsImportSourcesWizard_Title = UtilsText.MISSING_MSG;
	public String PeriphsToolBarManager_GroupsNumReached_Message = UtilsText.MISSING_MSG;
	public String PeriphsToolBarManager_GroupsNumReached_Title = UtilsText.MISSING_MSG;
	public String PeriphsToolBarManager_RemoveGroupDialog_Message = UtilsText.MISSING_MSG;
	public String PeriphsToolBarManager_RemoveGroupDialog_Title = UtilsText.MISSING_MSG;
	public String RemoveDialog_Title = UtilsText.MISSING_MSG;
	public String RemoveDialog_Confirmation = UtilsText.MISSING_MSG;
	public String RemoveDialog_RemoveComponents = UtilsText.MISSING_MSG;
	public String RemoveDialog_RemoveComponentInstances = UtilsText.MISSING_MSG;
	public String RemoveDialog_From = UtilsText.MISSING_MSG;
	public String ScalarCopyControl_Button_Text = UtilsText.MISSING_MSG;

	/** Singleton representing this message class */
	private static final @Nullable Messages SWT_SINGLETON;

	static {
		NLS.initializeMessages(BUNDLE_NAME, Messages.class); // initialize resource bundle
		Locale locale = Locale.getDefault();
		assert (null != locale);
		SWT_SINGLETON = (Messages) SWTFactoryProxy.INSTANCE.createMessagesForSWT(BUNDLE_NAME, locale, Messages.class);
	}

	/**
	 * Default constructor
	 * This is singleton, do not use!
	 */
	public Messages() {
	}

	/**
	 * @return instance of the Messages class
	 */
	public static Messages get() {
		Messages res = (SWT_SINGLETON == null)
				? (Messages) SWTFactoryProxy.INSTANCE.getLocalizedMessages(BUNDLE_NAME, Messages.class) : SWT_SINGLETON;
				assert (res != null);
				return res;
	}



}
