package org.eclipse.cdt.embsysregview.ui.commands;

import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.utils.GUIUtils;
import org.eclipse.cdt.embsysregview.internal.utils.ImportRegisters;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ImportRegisterHandler extends AbstractHandler {
	private static final String EMBSYS_VIEW_ID = "org.eclipse.cdt.embsysregview.views.EmbSysRegView"; //$NON-NLS-1$
	private static final String EVENT_PARAMETER_ID = "org.eclipse.cdt.embsysregview.ui.commands.ImportRegister.ViewId"; //$NON-NLS-1$

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		String viewId = event.getParameter(getEventParameterId());
		IViewPart view = GUIUtils.getActivePage().findView(viewId);
		if (view != null) {
			ImportRegisters.importRegisterValues(view);
		}
		return null;
	}

	@Override
	public void setEnabled(Object context) {
		IViewPart view = GUIUtils.getActivePage().findView(getViewId());
		if (view != null) {
			IWorkbenchPartSite part = view.getSite();
			if (part != null) {
				ISelection selection = part.getSelectionProvider().getSelection();
				if (selection instanceof TreeSelection) {
					setBaseEnabled(((TreeSelection) selection).getFirstElement() instanceof TreeParent);
					return;
				}
				setBaseEnabled(false);
			}
		}
	}

	protected String getEventParameterId() {
		return EVENT_PARAMETER_ID;
	}

	protected String getViewId() {
		return EMBSYS_VIEW_ID;
	}

}
