package org.eclipse.cdt.embsysregview.ui.commands;

import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;

/**
 * 
 * */
public class CopyEmbSysRegisterClipboardHandler extends ACopyRegisterClipboardHandler {
    private static final String EMBSYS_VIEW_ID = "org.eclipse.cdt.embsysregview.views.EmbSysRegView"; //$NON-NLS-1$
    private static final String EVENT_PARAMETER_ID = "org.eclipse.cdt.embsysregview.ui.commands.CopyRegisterClipboard.ViewId"; //$NON-NLS-1$

    @Override
    protected String getEventParameterId() {
        return EVENT_PARAMETER_ID;
    }

    @Override
    protected String getViewId() {
        return EMBSYS_VIEW_ID;
    }

    @Override
    protected String getRegisterAsString(TreeRegister register) {
        return register.getName() + ":\t" + register.getPrintValue() + "\t@" //$NON-NLS-1$ //$NON-NLS-2$
                + Long.toHexString(register.getRegisterAddress()) + System.getProperty("line.separator"); //$NON-NLS-1$
    }

}