package org.eclipse.cdt.embsysregview.ui.commands;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.ui.view.ExportRegDialog;
import org.eclipse.cdt.embsysregview.internal.utils.ExportRegisters;
import org.eclipse.cdt.embsysregview.internal.utils.GUIUtils;
import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AExportRegisterHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		String viewId = event.getParameter(getEventParameterId());
		IViewPart view = GUIUtils.getActivePage().findView(viewId);

		if (view != null) {
			IWorkbenchPartSite part = view.getSite();
			if (part != null) {
				ISelection selection = part.getSelectionProvider().getSelection();
				if (selection != null && selection instanceof IStructuredSelection) {
					IStructuredSelection select = (IStructuredSelection) selection;
					ExportRegDialog dialog = new ExportRegDialog(null);
					dialog.create();
					if (dialog.open() == Window.OK) {
						String exportFileName = dialog.getFilename();
						boolean exportAllRegisters = dialog.selection();
						if (exportFileName == null || exportFileName.isEmpty()) {
							return null;
						}
						ExportRegisters.exportToFile(select, exportFileName, exportAllRegisters);
					}
				}
			}
		}
		return null;
	}

	@Override
	public void setEnabled(Object context) {
		IViewPart view = GUIUtils.getActivePage().findView(getViewId());
		if (view != null) {
			IWorkbenchPartSite part = view.getSite();
			if (part != null) {
				ISelection selection = part.getSelectionProvider().getSelection();
				if (selection instanceof TreeSelection) {
					setBaseEnabled(((TreeSelection) selection).getFirstElement() instanceof TreeParent);
					return;
				}
				setBaseEnabled(false);
			}
		}
	}

	protected abstract String getEventParameterId();

	protected abstract String getViewId();

}
