package org.eclipse.cdt.embsysregview.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeGroup;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.internal.utils.GUIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class ACopyRegisterClipboardHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = event.getParameter(getEventParameterId());
        IViewPart view = GUIUtils.getActivePage().findView(viewId);
        Clipboard cb = new Clipboard(Display.getDefault());
        if (view == null) {
        	return null;
        }
        IWorkbenchPartSite part = view.getSite();
        if (part == null) {
        	return null;
        }
        ISelection selection = part.getSelectionProvider().getSelection();
        List<TreeElement> registerList = new ArrayList<>();
        if (selection != null && selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection) selection).toArray()) {
                if (obj instanceof TreeGroup) {
                    registerList.addAll(addRegisterGroup((TreeParent) obj));
                } else if (obj instanceof TreeRegisterGroup) {
                    registerList.addAll(addRegisterGroup((TreeParent) obj));
                } else if (obj instanceof TreeRegister) {
                    registerList.add((TreeRegister) obj);
                } else if (obj instanceof TreeField) {
                    registerList.add(((TreeField) obj).getParent());
                } else {
                    // this selection is not supported
                    return null;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (TreeElement element : registerList) {
            if (element instanceof TreeRegisterGroup) {
                TreeRegisterGroup group = (TreeRegisterGroup) element;
                sb.append(group.getName());
                sb.append(System.getProperty("line.separator")); //$NON-NLS-1$
                Stream.of(group.getChildren()).forEach(r -> sb.append(registerToString(r)));
            } else if (element instanceof TreeRegister) {
                sb.append(registerToString(element));
            }
    
        }
        cb.setContents(new Object[] { sb.toString() }, new Transfer[] { TextTransfer.getInstance() });
    
        return null;
    }

    @Override
    public void setEnabled(Object context) {
        IViewPart view = GUIUtils.getActivePage().findView(getViewId());
        if (view == null) {
            return;
        }
        IWorkbenchPartSite part = view.getSite();
        if (part == null) {
            return;
        }
        ISelection selection = part.getSelectionProvider().getSelection();
        if (selection instanceof TreeSelection) {
            setBaseEnabled(((TreeSelection) selection).getFirstElement() instanceof TreeParent);
            return;
        }
        setBaseEnabled(false);
    }

    protected abstract String getEventParameterId();

    protected abstract String getViewId();

    protected abstract String getRegisterAsString(TreeRegister register);

    private List<TreeElement> addRegisterGroup(final TreeParent group) {
        return Arrays.asList(group.getChildren());
    }

    private String registerToString(final TreeElement element) {
        if (element instanceof TreeRegister) {
            TreeRegister register = (TreeRegister) element;
            return getRegisterAsString(register);
        }
        return element.getName();
    }

}
