package org.eclipse.cdt.embsysregview.properties;

import java.util.EventObject;
import java.util.Objects;
import java.util.Set;

import org.eclipse.core.resources.IProject;

/**
 *  
 * */
class ProjectPropertiesChangeEvent extends EventObject implements IProjectPropertiesChangeEvent {   
    /**
	 * for EventObject
	 */
	private static final long serialVersionUID = 6890830387353543185L;
    
	private transient Object oldValue;
    
	private transient Object newValue;
	
	private String propertyName;    

    private transient IProject project;

    private transient Set<Property> properties;

    /**
     * Creates a new property change event.
     *
     * @param project
     *            the project whose property has changed
     * @param property
     *            the property that has changed (must not be <code>null</code>)
     * @param oldValue
     *            the old value of the property, or <code>null</code> if none
     * @param newValue
     *            the new value of the property, or <code>null</code> if none
     */

    public ProjectPropertiesChangeEvent(IProject project, String propertyName, Object oldValue, Object newValue) {
        super(project);
        this.project = project;
        this.propertyName = Objects.requireNonNull(propertyName);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public ProjectPropertiesChangeEvent(IProject project, Set<Property> properties) {
        super(project);
        this.project = project;
        this.properties = Objects.requireNonNull(properties);
    }

    @Override
	public String getProperty() {
        return propertyName;
    }

    @Override
	public Object getOldValue() {
        return oldValue;
    }

    @Override
	public Object getNewValue() {
        return newValue;
    }

    @Override
	public IProject getProject() {
        return project;
    }

    @Override
    public Set<Property> getProperties() {
        return properties;
    }

}
