package org.eclipse.cdt.embsysregview.properties;

import java.util.Objects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;

/**
 * 
 * */
public class ProjectProperties {

    private static ProjectProperties instance;

    public static ProjectProperties getInstance() {
        final ProjectProperties localInstance = instance;
        synchronized (ProjectProperties.class) {
            if (localInstance == null) {
                instance = new ProjectProperties();
            }
        }
        return instance;
    }

    private ProjectProperties() {
    }

    ListenerList listeners = new ListenerList();

    public void addPropertyChangeListener(IProjectPropertyChangeListener listener) {
        listeners.add(listener);
    }

    public void removePropertyChangeListener(IProjectPropertyChangeListener listener) {
        listeners.remove(listener);
    }

    protected void firePropertyChangeEvent(IProject project, QualifiedName qualifiedName, Object oldValue, Object newValue) {
        firePropertiesChangeEvent(new ProjectPropertiesChangeEvent(project, Objects.requireNonNull(qualifiedName).getLocalName(), oldValue, newValue));
    }

    protected void firePropertiesChangeEvent(IProject project) {
        firePropertiesChangeEvent(new ProjectPropertiesChangeEvent(project, PropertiesHolder.getInstance(project).getPropertySet()));
    }

    private void firePropertiesChangeEvent(IProjectPropertiesChangeEvent event) {
        for (Object obj : listeners.getListeners()) {
            IProjectPropertyChangeListener l = (IProjectPropertyChangeListener) obj;
            SafeRunner.run(new ISafeRunnable() {
                @Override
				public void handleException(Throwable exception) {
                    // already being logged in SafeRunner#run()
                }

                @Override
				public void run() throws Exception {
                    l.propertyChanged(event);
                }
            });
        }
    }
    
}
