package org.eclipse.cdt.embsysregview.properties;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.eclipse.cdt.embsysregview.internal.IEmbSysChipInfo;

/**
 * Implements hardcoded table of chip->cores translation. 
 * */
public class DefaultChipInfo implements IEmbSysChipInfo {
	
	private enum e200
	{		
		Z0_H("e200z0h"),
		Z3_35("e200z335"),
		Z4_46N3("e200z446n3"),
		Z4_D("e200z4d"),
		Z7_60("e200z760"),
		Z2_10N3("e200z210n3"),
		Z4_201N3("e200z4201n3"),
		Z4_204N3("e200z4204n3"),
		Z4_251N3("e200z4251n3"),
		Z4_25N3("e200z425n3"),
		Z7_10N3("e200z710n3"),
		Z7_260N3("e200z7260n3"),
		Z7_59N3("e200z759n3"), 
		UNKNOWN("unknown");
		
		private final String coreType;
		
		private e200 (final String coreType){
			this.coreType = coreType;
		}
		
		private final String getCoreType() {
			return coreType;
		}
	}
	
	/**
	 *List of all supported PPC chips. 
	 * */
    @SuppressWarnings("serial")
	final static Map<String, Set<e200>> map = Collections.unmodifiableMap(new HashMap<String, Set<e200>>() {{    	
    	//D
		put("MPC5601D", EnumSet.of(e200.Z0_H));
    	put("MPC5602D", EnumSet.of(e200.Z0_H));
    	//B    	
    	put("MPC5602B", EnumSet.of(e200.Z0_H));
    	put("MPC5603B", EnumSet.of(e200.Z0_H));
    	put("MPC5604B", EnumSet.of(e200.Z0_H));
    	put("MPC5605B", EnumSet.of(e200.Z0_H));
    	put("MPC5606B", EnumSet.of(e200.Z0_H));
    	put("MPC5607B", EnumSet.of(e200.Z0_H));
    	//C
    	put("MPC5602C", EnumSet.of(e200.Z0_H));
    	put("MPC5603C", EnumSet.of(e200.Z0_H));
    	put("MPC5604C", EnumSet.of(e200.Z0_H));
    	//P
    	put("MPC5601P", EnumSet.of(e200.Z0_H));
    	put("MPC5602P", EnumSet.of(e200.Z0_H));    	    	
    	put("MPC5603P", EnumSet.of(e200.Z0_H));
    	put("MPC5604P", EnumSet.of(e200.Z0_H));
    	//E 
    	put("MPC5604E", EnumSet.of(e200.Z0_H));
    	//S    	    	
    	put("MPC5606S", EnumSet.of(e200.Z0_H));  	
    	    	    	
    	put("MPC5634M", EnumSet.of(e200.Z3_35));
    	
    	put("MPC5643L", EnumSet.of(e200.Z4_D));
    	// actually e200z448n3
    	put("MPC5644A", EnumSet.of(e200.Z4_46N3));
    	
    	put("MPC5644B", EnumSet.of(e200.Z4_D));
    	put("MPC5645B", EnumSet.of(e200.Z4_D));
    	put("MPC5646B", EnumSet.of(e200.Z4_D));
    	
    	put("MPC5644C", EnumSet.of(e200.Z0_H,e200.Z4_D));    	
    	put("MPC5645C", EnumSet.of(e200.Z0_H,e200.Z4_D));    	
    	put("MPC5646C", EnumSet.of(e200.Z0_H,e200.Z4_D));
    	
    	put("MPC5674F", EnumSet.of(e200.Z7_60));
    	
    	put("MPC5675K", EnumSet.of(e200.Z7_60));
    	
    	put("MPC5676R", EnumSet.of(e200.Z7_59N3));    	
    	// actualy with e200z424 core
    	put("MPC5744P", EnumSet.of(e200.Z4_251N3));
    	put("MPC5743P", EnumSet.of(e200.Z4_251N3));
    	put("MPC5742P", EnumSet.of(e200.Z4_251N3));
    	put("MPC5741P", EnumSet.of(e200.Z4_251N3));
    	//
    	put("MPC5746C", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5745C", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5744C", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5746B", EnumSet.of(e200.Z4_204N3));
    	put("MPC5745B", EnumSet.of(e200.Z4_204N3));
    	put("MPC5744B", EnumSet.of(e200.Z4_204N3));
    	//actualy with e200z424 as second core
    	put("MPC5746R", EnumSet.of(e200.Z4_25N3));
    	
    	put("MPC5748G", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5748C", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5747G", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5747C", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	put("MPC5746G", EnumSet.of(e200.Z2_10N3, e200.Z4_204N3));
    	//
    	put("MPC5775K", EnumSet.of(e200.Z4_201N3, e200.Z7_260N3));
    	
    	put("MPC5775B", EnumSet.of(e200.Z7_59N3));
    	put("MPC5775E", EnumSet.of(e200.Z7_59N3));
    	
    	put("MPC5777C", EnumSet.of(e200.Z7_59N3));
    	//actually with e200z425Bn3
    	put("MPC5777M", EnumSet.of(e200.Z7_10N3, e200.Z4_25N3));
    	//
    	put("S32R274", EnumSet.of(e200.Z7_260N3, e200.Z4_201N3));
    	put("S32R372", EnumSet.of(e200.Z7_260N3));    	
    }});
    	
	@Override
	public Set<String> getChipCores(String chipName) {
		return toStringSet(map.getOrDefault(chipName, EnumSet.of(e200.UNKNOWN)));		
	}
	
	private static Set<String> toStringSet(Set<e200> set) {	    
		return set.stream().map(e200::getCoreType).collect(Collectors.toSet());
	}
}
