/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.preferences;

import net.miginfocom.swt.MigLayout;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.PropertiesKeys;
import org.eclipse.cdt.embsysregview.core.SortingOrder;
import org.eclipse.cdt.embsysregview.core.SortingOrder.BitFieldSorter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * This class represents a preference page that is contributed to the
 * Preferences dialog. By subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows us to create a page
 * that is small and knows how to save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They are stored in the
 * preference store that belongs to the main plug-in class. That way,
 * preferences can be accessed directly via the preference store.
 */
public class PreferencePageEmbSysBehavior extends PreferencePage implements IWorkbenchPreferencePage {
    Button bitbuttons;
    Combo comboLength;
    Combo comboSort;
   //SortingOrder sortingOrder = new SortingOrder();
            
    public PreferencePageEmbSysBehavior() {
        super();
        this.noDefaultAndApplyButton();        
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    @Override
	public void init(IWorkbench workbench) {
    	setPreferenceStore(Activator.getDefault().getPreferenceStore());
        setDescription("How the EmbSysRegisters view should behave"); //$NON-NLS-1$
    }

    @Override
    public boolean performOk() {
        if (bitbuttons != null && comboLength != null) {
            IPreferenceStore store = getPreferenceStore();

            store.setValue(PropertiesKeys.BIT_BUTTONS_PREF, bitbuttons.getSelection()); //$NON-NLS-1$
            if (comboLength.getSelectionIndex() != -1) {
                store.setValue(PropertiesKeys.COMBO_LENGTH_PREF, Integer.valueOf(comboLength.getItem(comboLength.getSelectionIndex()))); //$NON-NLS-1$
            }
            
            int index = comboSort.getSelectionIndex();
            if (index != -1) {            	
            	SortingOrder.saveToPreference(index);
            }
            
        }       
        // there is no value that can be not ok
        return true;
    }

    private void restoreStoredSettings() {
        IPreferenceStore store = getPreferenceStore();

        boolean store_bitbuttons = store.getBoolean(PropertiesKeys.BIT_BUTTONS_PREF); //$NON-NLS-1$
        bitbuttons.setSelection(store_bitbuttons);

        int store_combolength = store.getInt(PropertiesKeys.COMBO_LENGTH_PREF); //$NON-NLS-1$
        comboLength.setText(String.valueOf(store_combolength));
        
       	comboSort.setText(SortingOrder.getFromPreference().getLabel());               
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new MigLayout("ins 1, gap 1"));

        bitbuttons = new Button(composite, SWT.CHECK);
        bitbuttons.setLayoutData("grow, span, wrap 15");
        bitbuttons.setText("Binary column Bit Buttons immediate effect"); //$NON-NLS-1$
        bitbuttons.setToolTipText("LONG DESCR..."); // TODO: fill out ... //$NON-NLS-1$
        bitbuttons.setSelection(false);        

        Label combolengthLabel = new Label(composite, SWT.NONE);
        combolengthLabel.setLayoutData("wrap");
        combolengthLabel.setText("Number of elements shown in drop down List (Interpretations in Hex Column)"); //$NON-NLS-1$
        comboLength = new Combo(composite, SWT.DROP_DOWN);
        comboLength.setLayoutData("hmin 0, wmin 0, wrap 15");
        comboLength.setVisibleItemCount(4);
        comboLength.add("5"); //$NON-NLS-1$
        comboLength.add("10"); //$NON-NLS-1$
        comboLength.add("15"); //$NON-NLS-1$
        comboLength.add("20"); //$NON-NLS-1$
        
        Label sortingLabel = new Label(composite, SWT.NONE);
        sortingLabel.setLayoutData("wrap");
        sortingLabel.setText("Bit fields sorting order"); //$NON-NLS-1$
        comboSort = new Combo(composite, SWT.DROP_DOWN);
        comboSort.setLayoutData("hmin 0, wmin 50, wrap 15");
        comboSort.setVisibleItemCount(3);        
        SortingOrder.getSortersMap().stream().map(BitFieldSorter::getLabel).forEach(comboSort::add);
        restoreStoredSettings();
        
        return composite;
    }
    
    /** */
	public static boolean getBitButtonPref() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		return store.getBoolean(PropertiesKeys.BIT_BUTTONS_PREF);
	}
    
	/** */
	public static int getComboLengthPref() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		return store.getInt(PropertiesKeys.COMBO_LENGTH_PREF);
	}
}
