package org.eclipse.cdt.embsysregview.internal.utils;

import java.util.function.Consumer;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GUIUtils {
	
	private GUIUtils() {}
	
    /**
     * Posts the specified runnable for execution by the UI thread. Nonblocking,
     * returns immediately.
     */

    public static void exec(Runnable runnable) {
        exec(getDisplay(), runnable, false);
    }

    public static void exec(Runnable runnable, boolean blocking) {
        exec(getDisplay(), runnable, blocking);
    }

    /**
     * Posts the specified runnable for execution by the UI thread. If blocking
     * is true, waits for completion, otherwise returns immediately.
     */
    private static void exec(Display display, Runnable runnable, boolean blocking) {
        if (display != null && runnable != null) {
        	Consumer<Runnable> exec = blocking ? display::syncExec : display::asyncExec;
        	exec.accept(runnable);
        }
    }

    /** Gets current SWT display. */
    public static Display getDisplay() {
        Display display = Display.getCurrent();
        return display == null ? Display.getDefault() : display;
    }

	public static IWorkbenchPage getActivePage() {
		return getActiveWorkbenchWindow().getActivePage();
	}

	private static IWorkbenchWindow getActiveWorkbenchWindow() {
		return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	}
	
	public static Shell getShell() {
		return getActiveWorkbenchWindow().getShell();
	}

}
