package org.eclipse.cdt.embsysregview.internal.utils;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ExportImportRegistersPathValidator {
    private static final IStatus INVALID_PATH_STATUS = new Status(IStatus.ERROR, Activator.PLUGIN_ID, NLS.bind(
            Messages.export_import_invalid_path_message, null));
    private static final IStatus SELECT_FILE_STATUS = new Status(IStatus.ERROR, Activator.PLUGIN_ID, NLS.bind(
            Messages.export_select_file_message, null));

    public static IStatus validateInputPath(String input) {
        if (input == null || input.isEmpty()) {
            return SELECT_FILE_STATUS;
        }
        try {
            Path inputPath = Paths.get(input);
            if (inputPath.getNameCount() == 0) {
                return INVALID_PATH_STATUS;
            } else {
                File inputPathFile = inputPath.toFile();
                int idx = input.lastIndexOf(File.separator);
                if (idx >= 0) {
                    if (!Paths.get(input.substring(0, idx)).toFile().exists()) {
                        return INVALID_PATH_STATUS;
                    } else {
                        return isDirectory(inputPathFile);
                    }
                } else {
                    return isDirectory(inputPathFile);
                }
            }
        } catch (InvalidPathException e) {
            return new Status(IStatus.ERROR, Activator.PLUGIN_ID, e.getMessage());
        }
    }

    private static IStatus isDirectory(File inputPathFile) {
        if (inputPathFile.isDirectory()) {
            return SELECT_FILE_STATUS;
        }
        return Status.OK_STATUS;
    }

}
