package org.eclipse.cdt.embsysregview.internal.utils;

import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory.IMemoryDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl.IContainerDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl.IContainerSuspendedDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl.IResumedDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl.IStartedDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl.ISuspendedDMEvent;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;

/**
 * DSF event listener class for the EmbSysRegView. This class will handle
 * different relevant DSF events and update the EmbSysRegView accordingly.
 */
public class EmbSysRegViewDsfEventListener {

    // --- members ---
    /** Automation class we're managing events for. */
    protected EmbSysRegEngine fEngine;

    // --- constructors/destructors ---
    /** Constructor */
    public EmbSysRegViewDsfEventListener(EmbSysRegEngine engine) {
        fEngine = engine;
    }

    // --- event handlers ---

	/** Invoked when a thread or process is suspended. */
	@DsfServiceEventHandler
	public void handleEvent(ISuspendedDMEvent event) {
		if (event instanceof IContainerSuspendedDMEvent) {
			IMemoryDMContext context = DMContexts.getAncestorOfType(event.getDMContext(), IMemoryDMContext.class);
			fEngine.getEmbSysRegUpdate(context, false);
		}
	}

    /** Invoked when a thread or process starts. */
    @DsfServiceEventHandler
    public void handleEvent(IStartedDMEvent event) {
        IDMContext context = event.getDMContext();
        if (context instanceof IContainerDMContext) {
            // We don't deal with processes
        } else if (context instanceof IMIExecutionDMContext) {
            // New thread added
            // fEngine.allowUseSession(true);
            fEngine.restoreSelections();
        }
    }

    /** Invoked when a thread or process starts. */
    @DsfServiceEventHandler
    public void handleEvent(IResumedDMEvent event) {
        if (event instanceof IContainerSuspendedDMEvent) {
            // We don't deal with processes
            // fEngine.allowUseSession(false);
        }
    }

}