package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.core.EmbSysRegCore;
import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSysBehavior;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;

/**
 * 
 * */
public class HexColumnEditingSupport extends EditingSupport {
	 private final EmbSysRegEngine engine;
	 private final ComboBoxViewerCellEditor comboCellEditor;
	 private final TextCellEditor textCellEditor;
	 /** marks element where editor opened */
	 private TreeElement currentEditedElement;
	 	 	
	 HexColumnEditingSupport (final TreeViewer viewer , 
			                  final ComboBoxViewerCellEditor comboEditor, 
			                  final TextCellEditor textEditor,
			                  final EmbSysRegEngine embSysEngine) {
	     super(viewer);
		 engine = embSysEngine;
	     comboCellEditor = comboEditor;
	     textCellEditor = textEditor;
	 }	 
         @Override
         protected boolean canEdit(Object element) {
             return EmbSysRegCore.checkEditRules(element);
         }
         
         @Override
         protected Object getValue(Object element) {
             if (element instanceof TreeField && ((TreeField) element).hasInterpretations()) {
                 // TODO: check if the Integer is for index in the combobox
                 return new Integer((int) ((TreeField) element).getValue()); // TODO:
                                                                             // what
                                                                             // to
                                                                             // do
                                                                             // on
                                                                             // large
                                                                             // bitfield
                                                                             // ?
             }
             if (element instanceof TreeField)
                 return Utils.longtoHexString(((TreeField) element).getValue(),
                         ((TreeField) element).getBitLength());

             if (element instanceof TreeRegister)
                 return Utils.longtoHexString(((TreeRegister) element).getValue(),
                         ((TreeRegister) element).getBitSize());
             return ""; //$NON-NLS-1$
         }

    @Override
    protected void setValue(Object element, Object value) {
        if (element instanceof TreeRegister) {
            final TreeRegister treeRegister = (TreeRegister) element;
            final Long lvalue = EmbSysRegCore.parseLong(value);
            if (lvalue != null) {
                engine.setValue(treeRegister, lvalue);
            } else {
                Activator.log(IStatus.ERROR, "Cannot convert register value!"); //$NON-NLS-1$
            }
        } else if (element instanceof TreeField) {
            final TreeField registerField = (TreeField) element;
            if (value instanceof String) {
                long lvalue = registerField.getInterpretations().getValue((String) value);
                if (lvalue != -1) {
                    engine.updateRegisterByField(registerField, lvalue);
                } else {
                    try {
                        lvalue = EmbSysRegCore.parseLong(value);
                        if (lvalue != -1) {
                            long maxValue = registerField.getMaxAllowedValue();
                            if (lvalue <= maxValue) {
                                engine.updateRegisterByField(registerField, lvalue);
                            } else {
                                Activator.log(IStatus.ERROR, NLS.bind(
                                        Messages.HexColumnEditionSupport_Register_filed_value_out_of_range, maxValue));
                            }
                        }
                    } catch (Exception e) {
                        // do nothig
                    }
                }
                if (lvalue == -1) {
                    Activator.log(IStatus.ERROR, NLS.bind(
                            Messages.HexColumnEditingSupport_Cannot_convert_register_field_value, new Object[0]));
                }
            }
        } else if (element != null) {
            Activator.log(IStatus.ERROR, "Unknown object type!"); //$NON-NLS-1$
        } else {
            Activator.log(IStatus.ERROR, "Null object!"); //$NON-NLS-1$
        }
    }
     

         @Override
         protected CellEditor getCellEditor(Object element) {
             if (element instanceof TreeField && ((TreeField) element).hasInterpretations()) {
                 comboCellEditor.setContentProvider(new IStructuredContentProvider() {

                     @Override
                     public void dispose() {
                    	 //
                     }

                     @Override
                     public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                    	 //
                     }

                     @Override
                     public Object[] getElements(Object obj) {
                         return ((TreeField) obj).getInterpretations().getLabelsArray();
                     }

                 });

                 comboCellEditor.setInput(element);

                 int combolength = PreferencePageEmbSysBehavior.getComboLengthPref();
                 if (combolength > 0) {
                     ((CCombo) comboCellEditor.getControl()).setVisibleItemCount(combolength);
                 }
                 currentEditedElement = (TreeElement) element;
                 return comboCellEditor;
             }
             return textCellEditor;
         }
         
		public TreeElement getCurrentEditedElement() {
			return currentEditedElement;
		}		
}
