package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.internal.utils.ExportImportRegistersPathValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportRegDialog extends TitleAreaDialog {
	private Text txtFilename;
	private Button changeButton;
	private Button selectAllRadioButton;
	private Button selectedRadioButton;

	private String filename = "";
	private boolean selectAll = false;

	public ExportRegDialog(Shell parentShell) {
		super(parentShell);
	}

	@Override
	public void create() {
		super.create();
		setTitle(Messages.export_title);
		setMessage(Messages.export_ok_message);
		setErrorMessage(Messages.export_select_file_message);
		getButton(IDialogConstants.OK_ID).setEnabled(false);
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.export_title);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		container.setLayout(new GridLayout(2, false));
		createFilename(container);
		createButtons(container);
		return area;
	}

	private void createFilename(Composite container) {
		GridData dataFilename = new GridData(SWT.FILL, SWT.END, true, false);
		dataFilename.horizontalSpan = 2;
		Label lbtFilename = new Label(container, SWT.NONE);
		lbtFilename.setText("File:");
		lbtFilename.setLayoutData(dataFilename);

		dataFilename = new GridData(SWT.FILL, SWT.BEGINNING, true, false);
        txtFilename = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtFilename.setLayoutData(dataFilename);
		txtFilename.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				String text = ((Text) e.getSource()).getText();
				validate(text);
			}
		});
		changeButton = new Button(container, SWT.PUSH);
		changeButton.setText("Browse");
		changeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog filePromt = new FileDialog(getShell(), SWT.SAVE);
				filename = filePromt.open();
				if (filename != null) {
					txtFilename.setText(filename);
                } else {
                    filename = txtFilename.getText();
				}
				validate(filename);
			}
		});
	}

	private void createButtons(Composite container) {
		Group selection = new Group(container, SWT.NONE);
		selection.setText("Registers");

		selection.setLayout(new GridLayout(1, false));
		GridData dataCreateButtons = new GridData(SWT.FILL, SWT.FILL, true, false);
		dataCreateButtons.horizontalSpan = 2;
		selection.setLayoutData(dataCreateButtons);

		selectAllRadioButton = new Button(selection, SWT.RADIO);
		selectAllRadioButton.setText("All");
		selectedRadioButton = new Button(selection, SWT.RADIO);
		selectedRadioButton.setText("Selected");
		selectedRadioButton.setSelection(true);
	}

	private void validate(String input) {
        IStatus status = ExportImportRegistersPathValidator.validateInputPath(input);
        setValidState(status.isOK() ? null : status.getMessage());
	}

	private void setValidState(String message) {
		setErrorMessage(message);
		if (message == null) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}

	@Override
	protected boolean isResizable() {
		return true;
	}

	// save content of the Text fields because they get disposed
	// as soon as the Dialog closes
	private void saveInput() {
		filename = txtFilename.getText();
		selectAll = selectAllRadioButton.getSelection();
	}

	@Override
	protected void okPressed() {
		saveInput();
		super.okPressed();
	}

	public String getFilename() {
		return filename;
	}

	public boolean selection() {
		return selectAll;
	}
}
