package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.internal.IEmbSysImages;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeGroup;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * 
 * */
public class EmbSysRegUi {
    private EmbSysRegUi() {
    }
     
    /**
     * 
     * */
    public static final ImageDescriptor getButtonImage() {
        return Activator.getDefault().getImageDescriptor(IEmbSysImages.IMG_EMBSYS_CONFIG_BUTTON);
    }

    /** */
    public static final ImageDescriptor getToolbarImage() {
        return Activator.getDefault().getImageDescriptor(IEmbSysImages.IMG_EMBSYS_TOOLBAR_FILTER);
    }

    /**
     * Not implemented yet
     * 
     * @param treeRegisterGroup
     *            not used yet
     */
    public void setRegisterGroupLive(TreeRegisterGroup treeRegisterGroup) {
        // TODO Auto-generated method stub

    }

    /**
     * 
     * */
    static ColumnLabelProvider getRegisterColumnLabelProvider(final Composite parent) {
        return new ColumnLabelProvider() {
            @Override
            public Color getBackground(Object element) {
                if (element instanceof TreeRegister) {
                    if (((TreeRegister) element).isUnsertain()) {
                        return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_DARK_MAGENTA);
                    }
                }
                return null;
            }

            @Override
            public Color getForeground(Object element) {
                if (element instanceof TreeRegister)
                    if (((TreeRegister) element).isRetrievalActive())
                        return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN);
                if (element instanceof TreeField)
                    if (((TreeRegister) ((TreeField) element).getParent()).isRetrievalActive())
                        return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN);

                return null;
            }

            @Override
            public String getText(Object element) {
                if (element instanceof TreeRegister) {
                    if (!((TreeRegister) element).getAlterName().isEmpty()) {
                        return ("+ " + element.toString());
                    }
                }
                if (element instanceof TreeField) {
                    return ((TreeField) element).getFieldLabel();                    
                }
                return element.toString();
            }

            @Override
            public Image getImage(Object obj) {
                if (obj instanceof TreeRegisterGroup) {
                    if (((TreeRegisterGroup) obj).isChecked()) {
                        return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_REG_GROUP_SELECTED);
                    }
                    return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_REG_GROUP);
                } else if (obj instanceof TreeParent) {
                    if (obj instanceof TreeRegister) {
                        if (((TreeRegister) obj).isRetrievalActive()) {
                            return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_SELECTED);
                        }
                        return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_UNSELECTED);
                    }
                } else if (obj instanceof TreeField) {
                    if (((TreeRegister) ((TreeField) obj).getParent()).isRetrievalActive()) {
                        return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_SELECTED_FIELD);
                    }
                    return Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_UNSELECTED_FIELD);
                } else {
                    ;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);
            }

        };

        // return registerColumnLabelProvider;
    }

    /**
     * 
     * */
    static CellLabelProvider getDescriptionCellLabelProvider() {
        CellLabelProvider descriptionCellLabelProvider = new CellLabelProvider() {

            @Override
            public String getToolTipText(Object element) {
                if (element instanceof TreeRegister) { // only display if more
                                                       // than one line is found
                    if (org.eclipse.cdt.embsysregview.internal.utils.Utils
                            .countTextLines(((TreeRegister) element).getDescription()) > 1) {
                        return ((TreeRegister) element).getDescription();
                    }
                    return null;
                }
                if (element instanceof TreeField) { // display tooltip if more
                                                    // than one line is found,
                                                    // or an interpretation is
                                                    // shown instead of this one
                                                    // line
                    if (org.eclipse.cdt.embsysregview.internal.utils.Utils
                            .countTextLines(((TreeField) element).getDescription()) > 1
                            || ((TreeField) element).hasInterpretation()) {
                        return ((TreeField) element).getDescription();
                    }
                    return null;
                }
                return null;
            }

            @Override
            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            @Override
            public int getToolTipDisplayDelayTime(Object object) {
                return 200;
            }

            @Override
            public int getToolTipTimeDisplayed(Object object) {
                return 0;
            }

            @Override
            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof TreeGroup)
                    cell.setText(((TreeGroup) element).getDescription());
                if (element instanceof TreeRegisterGroup)
                    cell.setText(((TreeRegisterGroup) element).getDescription());
                if (element instanceof TreeRegister) {
                    cell.setText(org.eclipse.cdt.embsysregview.internal.utils.Utils
                            .getFirstNotEmptyTextLine(((TreeRegister) element).getDescription()).trim());
                }

                if (element instanceof TreeField)
                    if (((TreeField) element).hasInterpretation()) {
                        cell.setText(((TreeField) element).getInterpretation());
                        cell.setImage(Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_INTERPRETATION));
                    } else {
                        // Display first line
                        cell.setText(org.eclipse.cdt.embsysregview.internal.utils.Utils
                                .getFirstNotEmptyTextLine(((TreeField) element).getDescription()).trim());
                        // Display Icon if there are more than one line
                        if (org.eclipse.cdt.embsysregview.internal.utils.Utils
                                .countTextLines(((TreeField) element).getDescription()) > 1)
                            cell.setImage(Activator.getDefault().getImage(IEmbSysImages.IMG_EMBSYS_INFO));
                    }
            }
        };
        return descriptionCellLabelProvider;
    }

    /**
     * 
     * */
    static ColumnLabelProvider getAccessColumnLabelProvider() {
        ColumnLabelProvider accessColumnLabelProvider = new ColumnLabelProvider() {
            @Override
            public String getText(Object element) {
                if (element instanceof TreeGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegisterGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegister)
                    return ((TreeRegister) element).getType().toUpperCase();
                if (element instanceof TreeField)
                    return "("+((TreeField) element).getAccess().toUpperCase()+")"; 
                return ""; //$NON-NLS-1$
            }

        };

        return accessColumnLabelProvider;
    }

    /**
     * 
     * */
    static ColumnLabelProvider getAddressColumnLabelProvider() {
        return new ColumnLabelProvider() {
            @Override
            public String getText(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister) element).isSPR()) {
               		return Utils.longtoHexString(((TreeRegister) element).getRegisterAddress(), 32); 
                } else {
                	return ""; //$NON-NLS-1$
                }
            }
        };
    }

    /**
     * 
     * */
    static ColumnLabelProvider getBinColumnLabelProvider(final Composite parent) {
        ColumnLabelProvider binColumnLabelProvider = new ColumnLabelProvider() {
            @Override
            public Color getForeground(Object element) {
                if (element instanceof TreeRegister)
                    if (!((TreeRegister) element).isWriteOnly())
                        if (((TreeRegister) element).hasValueChanged())
                            return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_RED);
                if (element instanceof TreeField)
                    if (!((TreeRegister) ((TreeField) element).getParent()).isWriteOnly())
                        if (((TreeField) element).hasValueChanged())
                            return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_RED);

                return null;
            }

            @Override
            public String getText(Object element) {
                if (element instanceof TreeGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegisterGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegister) {
                    if (!((TreeRegister) element).isRetrievalActive()) {
                        return ""; //$NON-NLS-1$
                    } else if (!((TreeRegister) element).isAlreadyRead()) {
                        return "";
                    } else if (((TreeRegister) element).isWriteOnly()) {
                        return "------------- write only -------------"; //$NON-NLS-1$
                    } else {
                        return Utils.longtobinarystring(((TreeRegister) element).getValue(),
                                ((TreeRegister) element).getBitSize());
                    }
                } else if (element instanceof TreeField) {
                    final TreeRegister parent = (TreeRegister) ((TreeField) element).getParent();
                    if (!parent.isRetrievalActive()) {
                        return ""; //$NON-NLS-1$
                    } else if (!parent.isAlreadyRead()) {
                        return ((TreeField) element).getLabelString();
                    } else if (parent.isWriteOnly()) {
                        return "------------- write only -------------"; //$NON-NLS-1$
                    } else if (((TreeField) element).isWriteOnly()){
                    	return "";
                    } else {
                        return Utils.longtobinarystring(((TreeField) element).getValue(),
                                ((TreeField) element).getBitLength());
                    }
                } else {
                    return element.toString();
                }
            }

        };

        return binColumnLabelProvider;
    }

    /**  */
    static ColumnLabelProvider getHexColumnLabelProvider(final Composite parent) {
        ColumnLabelProvider hexColumnLabelProvider = new ColumnLabelProvider() {
            @Override
            public Color getForeground(Object element) {
                if (element instanceof TreeRegister)
                    if (!((TreeRegister) element).isWriteOnly())
                        if (((TreeRegister) element).hasValueChanged())
                            return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_RED);
                if (element instanceof TreeField)
                    if (!((TreeRegister) ((TreeField) element).getParent()).isWriteOnly())
                        if (((TreeField) element).hasValueChanged())
                            return parent.getShell().getDisplay().getSystemColor(SWT.COLOR_RED);
                return null;
            }

            /**  */
            @Override
            public String getText(Object element) {
                if (element instanceof TreeGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegisterGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegister) {
                    final TreeRegister reg = (TreeRegister) element;
                    if (reg.isWriteOnly()) {
                        return "- write only -"; //$NON-NLS-1$
                    } else if (!reg.isRetrievalActive()) {
                        return ""; //$NON-NLS-1$
                    } else if (!reg.isAlreadyRead()) {
                        return "- not read -";
                    } else {
                        return Utils.longtoHexString(reg.getValue(), reg.getBitSize());
                    }
                } else if (element instanceof TreeField) {
                    final TreeRegister parent = (TreeRegister) ((TreeField) element).getParent();
                    if (!parent.isRetrievalActive()) {
                        return ""; //$NON-NLS-1$
                    } else if (parent.isWriteOnly() || ((TreeField) element).isWriteOnly()) {
                        return "- write only -"; //$NON-NLS-1$
                    } else if (!parent.isAlreadyRead()) {
                        return "?";
                    } else {
                        return Utils.longtoHexString(((TreeField) element).getValue(),
                                ((TreeField) element).getBitLength());
                    }
                } else {
                    return element.toString();
                }
            }

        };
        return hexColumnLabelProvider;
    }

    /**  */
    static ColumnLabelProvider getResetColumnLabelProvider() {
        ColumnLabelProvider resetColumnLabelProvider = new ColumnLabelProvider() {
            @Override
            public String getText(Object element) {
                if (element instanceof TreeGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegisterGroup)
                    return ""; //$NON-NLS-1$
                if (element instanceof TreeRegister)
                    return Utils.longtoHexString(((TreeRegister) element).getResetValue(),
                            ((TreeRegister) element).getBitSize());
                if (element instanceof TreeField) {
                    return ""; //$NON-NLS-1$
                }
                return ""; //$NON-NLS-1$
            }
            @Override
            public String getToolTipText(Object element) {
                if (element instanceof TreeRegister) {
                    TreeRegister register = (TreeRegister) element;
                    return Utils.longtobinarystring(register.getResetValue(),
                            register.getBitSize());
                }
                return null; //$NON-NLS-1$
            }

        };

        return resetColumnLabelProvider;
    }
 
}
