/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSysBehavior;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;

/**
 * 
 * */
public class BinaryButtonsCellEditor extends CellEditor {

    private Composite composite;
    private TreeElement element;
    private int cellHeight;
    /** Property to change binary editor apply method */
    private boolean isInstantApply;
    private Label[] b;
    private EmbSysRegEngine m_engine;
    protected final int THIN_GAP = 2;

    /**
     * 
     * */
    public BinaryButtonsCellEditor(final Tree parent, final EmbSysRegEngine engine) {
        super(parent, SWT.NONE);
        this.m_engine = engine;

    }

    @Override
    protected Control createControl(Composite parent) {

        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.type = SWT.HORIZONTAL;
        layout.marginLeft = 1;
        layout.marginTop = 2;
        layout.marginRight = 1;
        layout.marginBottom = 1;
        layout.spacing = 0;

        // Initialize the components in a Composite container.
        composite = new Composite(parent, SWT.NONE);
        // Set the layout for the editor.
        composite.setLayout(layout);
        cellHeight = ((Tree) parent).getItemHeight();
        // read user settings        
        isInstantApply = PreferencePageEmbSysBehavior.getBitButtonPref();
        return composite;
    }

    @Override
    public LayoutData getLayoutData() {
        LayoutData data = super.getLayoutData();
        if (cellHeight > 0) {
            data.minimumHeight = cellHeight + THIN_GAP;
        }
        return data;
    }

    /**
     * need this empty stuff.
     */
    @Override
    protected Object doGetValue() {
        // TODO: ???
        return 0xAFFE;
    }

    @Override
    protected void doSetFocus() {
        if (composite != null) {
            composite.setFocus();
        }
    }

    protected void updateBinaryValue(final Object inputData)// , boolean
                                                            // updateView)
    {
        long value = 0;

        for (int i = b.length - 1; i >= 0; i--)
            value = (value << 1) + Integer.valueOf(b[i].getText());

        if (inputData instanceof TreeRegister) {
            // ((TreeRegister) element).updateValue(value);
            final TreeRegister register = (TreeRegister) inputData;
            m_engine.setValue(register, value);
        } else if (inputData instanceof TreeField) {
            // ((TreeField) Element).setValue(value);
            final TreeField registerField = (TreeField) inputData;
            m_engine.updateRegisterByField(registerField, value);
        }
    }

    @Override
    protected void doSetValue(Object value) {
        int bitsize = 0;
        element = (TreeElement) value;

        if (element instanceof TreeRegister) {
            bitsize = ((TreeRegister) element).getBitSize();
        }

        if (element instanceof TreeField) {
            bitsize = ((TreeField) element).getBitLength();
        }

        drawEditor(bitsize);

        // show set button only if immediate effect is disabled
        if (isInstantApply == false) {
            showSetButton();
        }

    }

    /** 
     * */
    private void drawEditor(int bitsize) {
        b = new Label[bitsize];

        for (int i = bitsize - 1; i >= 0; i--) {
            b[i] = new Label(composite, SWT.FLAT | SWT.CENTER);
            RowData data = new RowData();
            data.width = (cellHeight * 65) / 100;
            data.height = cellHeight - THIN_GAP;
            b[i].setLayoutData(data);
            b[i].addMouseListener(new MouseListener() {

                @Override
                public void mouseUp(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                    Label but = ((Label) e.getSource());
                    if (but.getData() == null) {
                      if (but.getText().equals("1")) { //$NON-NLS-1$
                        but.setText("0"); //$NON-NLS-1$
                      } else {
                        but.setText("1"); //$NON-NLS-1$
                      }
                      if (isInstantApply == true) {
                        updateBinaryValue(element);
                      }
                    }
                }

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }
            });

            b[i].setText("-"); //$NON-NLS-1$
            if (element instanceof TreeRegister) {
                b[i].setText(String.valueOf(org.eclipse.cdt.embsysregview.internal.utils.Utils.getBitFromValue(i,
                        ((TreeRegister) element).getValue())));
                //mark RO buttons with not null object disabling stops tooltip to show up
                if (Utils.getBitFromValue(i, ((TreeRegister) element).getReadOnlyMask()) == 1) {
                  b[i].setData(new Object());
                }
                // add tooltip
                b[i].setToolTipText("Bit " + i); //$NON-NLS-1$
                TreeElement[] children = ((TreeRegister) element).getChildren();
                for (TreeElement child : children) {
                    if (child instanceof TreeField) {
                        TreeField tf = (TreeField) child;
                        if (0 <= i - tf.getBitOffset() && i - tf.getBitOffset() <= tf.getBitLength() - 1) {
                            b[i].setToolTipText("Bit " + i + ": " + tf.getName()); //$NON-NLS-1$ //$NON-NLS-2$
                        }
                    }
                }
            }
            if (element instanceof TreeField) {
                b[i].setText(String.valueOf(org.eclipse.cdt.embsysregview.internal.utils.Utils.getBitFromValue(i,
                        ((TreeField) element).getValue())));
                // add tooltip
                b[i].setToolTipText("Bit " + (i + ((TreeField) element).getBitOffset())); //$NON-NLS-1$
            }

            // add separator between each nibble
            if ((i > 0) && ((i % 4) == 0)) {
                RowData ldata = new RowData();
                int style = SWT.NONE;
                ldata.width = 3;
                ldata.height = cellHeight - THIN_GAP;
                if ((i % 8) == 0) {
                    ldata.width = 7;
                    style = SWT.SEPARATOR | SWT.VERTICAL;
                }
                Label l = new Label(composite, style);
                l.setText(".");
                l.setLayoutData(ldata);

            }

        }

    }

    private void showSetButton() {
        Button setButton = new Button(composite, SWT.NONE);
        setButton.setText("Set"); //$NON-NLS-1$
        RowData data = new RowData();
        data.width = 45;
        data.height = cellHeight - THIN_GAP;
        setButton.setLayoutData(data);
        setButton.addMouseListener(new MouseListener() {

            @Override
            public void mouseUp(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                updateBinaryValue(element);
            }

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }
}
