/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Logical root of tree. Only one instance.
 */
public class TreeParent extends HiddenTreeParent {

    private final List<TreeElement> children = new ArrayList<>();

    public TreeParent(String name, String description) {
        super(name, description);
    }

    public void addChild(final TreeElement child) {
        children.add(child);
        child.setParent(this);
    }

    public void removeChild(final TreeElement child) {
        children.remove(child);
        child.setParent(null);
    }

    public TreeElement[] getChildren() {
        return children.toArray(new TreeElement[children.size()]);
    }

    @Override
	public boolean hasChildren() {
        return !children.isEmpty();
    }

    public void removeChildren() {
        children.clear();
    }

}
