/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.internal.model;

public abstract class TreeElement {
    private final String name;
    private String description;
    private TreeElement parent;
    private TreeElement modelParent;
    private static boolean modelAccessGranted;

    public TreeElement(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public final String getName() {
        return name;
    }

    public final String getDescription() {
        return description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    /** Insertion into view tree */
    public final void setParent(TreeElement parent) {
        this.parent = parent;
    }

    public final TreeElement getParent() {
        return parent;
    }

    /** Insertion into model tree */
    public final void setModelParent(TreeElement parent) {
        this.modelParent = parent;
    }

    /** */
    public final TreeElement getModelParent() {
        return modelParent;
    }

    /** */
    public final static boolean isModelAccessGranted() {
        return modelAccessGranted;
    }

    /** Sets whole model edit ability. */
    public final static void setAccessGranted(final boolean edit) {
        modelAccessGranted = edit;
    }

    @Override
    public String toString() {
        return getName();
    }
    
    /** Used to restore expanded state. */
	public final String getPath() {		
        String path = getName(); 
        TreeElement node = getParent(); 
        while (node != null) { 	           
            path = node.getName() + "/" + path; 	             
            node = node.getParent(); 
        }  	         
        return path; 	    
	}
}
