/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

import org.eclipse.cdt.embsysregview.internal.utils.Utils;

/**
 *  
 * */
public class Interpretations {

	private final ArrayList<Interpretation> interpretations = new ArrayList<>();
    private TreeField treeField;

    public void setTreeField(TreeField treeField) {
        this.treeField = treeField;
    }

    public void addInterpretation(long value, String description) {
        interpretations.add(new Interpretation(value, description));
    }

    public String getInterpretation(long value) {
    	return interpretations.stream().filter(i -> i.getValue() == value)
    			.map(Interpretation::getInterpretation).findAny().orElse("");
    }

    public long getValue(String interpretation) {
    	return interpretations.stream()
    			.filter(i -> i.getInterpretation().equals(interpretation))
    			.map(Interpretation::getValue).findAny().orElse(-1L);
    }
    
    /**
     *  
     * */
    public String[] getLabelsArray() {
        Iterator<Interpretation> it = interpretations.iterator();
        int j = 1;
        String[] ret = new String[interpretations.size() + 1];
        ret[0] = Utils.longtoHexString(treeField.getValue(), treeField.getBitLength());
        while (it.hasNext()) {
            Interpretation i = it.next();
            ret[j] = i.getInterpretation();
            j++;
        }
        return ret;
    }

    public void sort() {
        Collections.sort(interpretations);
    }

    public boolean hasInterpretations() {
        return !interpretations.isEmpty();
    }
	
}
