/*******************************************************************************
 * Copyright (c) 2016 EmbSysRegView
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     ravenclaw78 - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.Objects;

import org.eclipse.cdt.embsysregview.internal.utils.Utils;

/**
 * 
 * */
public class Interpretation implements Comparable<Interpretation> {
    /** */
	final long value;
	/** */
    final String interpretation;

    public Interpretation(long value, String interpretation) {
        this.interpretation = interpretation;
        this.value = value;
    }
    
    public long getValue() {
        return value;
    }

    public String getInterpretation() {
        return interpretation;
    }

    @Override
    public int compareTo(Interpretation that) {
    	return Utils.compare(that, this, Interpretation::getValue);
    }
    
    /**
     * A class that overrides compareTo should also override equals.
     */
    @Override
	public boolean equals(Object aThat) {
    	if (this == aThat) {
    		return true;
    	}
        if (!(aThat instanceof Interpretation)) {
        	return false;
        }
        
        Interpretation that = (Interpretation)aThat;
        return (Objects.equals(value, that.value)) &&
        	   (Objects.equals(interpretation, that.interpretation));
    }
    
    /**
     * A class that overrides equals must also override hashCode.
     */
     @Override 
     public int hashCode() {
    	 return Objects.hash(value, interpretation);
     }
}
