package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.List;

public abstract class HiddenTreeParent extends TreeElement {
	
    private final List<TreeElement> modelChildren = new ArrayList<>();

    public HiddenTreeParent(String name, String description) {
        super(name, description);
    }

    protected boolean addModelChild(final TreeElement child) {
        modelChildren.add(child);
        child.setModelParent(this);
        return true;
    }

    public List<TreeElement> getModelChildren() {
        return modelChildren;
    }

    public boolean hasChildren() {
        return !modelChildren.isEmpty();
    }

}
