package org.eclipse.cdt.embsysregview.internal;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class RegisterXMLCollector {
	
	public Map<String, String> collectPaths(){
		Map<String, String> registerDescriptionPaths = new HashMap<>();
		final String extensionPointName = "org.eclipse.cdt.registersDescriptionPath";  //$NON-NLS-1$

		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(extensionPointName);
		IExtension[] extensions = extensionPoint.getExtensions();
		if (extensions == null) return registerDescriptionPaths;
		
		String directory = ""; //$NON-NLS-1$
		String bundle = ""; //$NON-NLS-1$
		for (IExtension extension : extensions) {
			IConfigurationElement[] configurationElements = extension.getConfigurationElements();
			for(IConfigurationElement element: configurationElements){
				String name = element.getName();
				if("path".equals(name)){ //$NON-NLS-1$
					bundle 	= element.getAttribute("bundle"); //$NON-NLS-1$
					directory 	= element.getAttribute("directory"); //$NON-NLS-1$
				}
			}
			
			registerDescriptionPaths.put(bundle, directory);
		}
		
		return registerDescriptionPaths;
	}

}
