package org.eclipse.cdt.embsysregview.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.PropertiesKeys;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.jface.preference.IPreferenceStore;

/** */
public class SortingOrder {	
	
	public static class BitFieldSorter implements Comparator<TreeField> {

		private final String label;
		private final boolean isDescendant;
        
		private BitFieldSorter (final String name, final boolean direction) {
			label = name;
			isDescendant = direction;
		}
		
		@Override
		public int compare(TreeField o1, TreeField o2) {
			if (isDescendant) {
				return Integer.compare(o1.getBitOffset(), o2.getBitOffset());
			}  
			return Integer.compare(o2.getBitOffset(), o1.getBitOffset());			
		}
		
		public boolean isLittleEndian() { return isDescendant; }
		
		public String getLabel() { return label;}
		
	}
	
	//N.B. insertion ordered collection 
	private static final Map<Integer, BitFieldSorter> stateMap = new LinkedHashMap<Integer, BitFieldSorter>();
	private static final int UNSORTED = 255;
	
	private SortingOrder() {}
	
	/** maps preference codes to comparator objects*/
	static {
		//Add text label like enum  
		stateMap.put(0, new BitFieldSorter("Little Endian", true));
		stateMap.put(1, new BitFieldSorter ("Big Endian", false));		
		stateMap.put(UNSORTED, new BitFieldSorter("unsorted", false));    
	}
		
	/** store preference code by selection index */	
	public static void saveToPreference(int index) {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		Iterator<Integer> it = stateMap.keySet().iterator();
		int code = UNSORTED;
		int next = 0;
		do {
		 code = it.next(); 
		 if (index == next) break;
		 next++;
		} while (it.hasNext());
		
		store.setValue(PropertiesKeys.COMBO_SORT_PREF, code);		
	}
    
	/**return comparator object by preference code*/
	public static BitFieldSorter getFromPreference() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		int key = store.getInt(PropertiesKeys.COMBO_SORT_PREF);
		if (stateMap.containsKey(key)) {
			return stateMap.get(key);
		}
		return getDefaultSorter();
	}
    
	/** */
	public static BitFieldSorter getDefaultSorter() {		
		return stateMap.get(UNSORTED);
	}

	public static Collection<BitFieldSorter> getSortersMap() {		
		return stateMap.values();
	}
}