package org.eclipse.cdt.embsysregview.core;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.internal.model.IEditable;
import org.eclipse.core.runtime.IStatus;

/**
 * 
 * */
public class EmbSysRegCore {
	private EmbSysRegCore () {}
	
	 /**  */
    public static Long parseLong(Object value) {
        if (value instanceof String && ((String) value).startsWith("0x")) //$NON-NLS-1$
            try {
                String svalue = (String) value;
                return Long.valueOf(svalue.substring(2, svalue.length()), 16);
            } catch (NumberFormatException e) {
                Activator.log(IStatus.ERROR, "Wrong Number!", e); //$NON-NLS-1$
            }
        return null;
    }
	
    
	 /** */
    public static boolean checkEditRules(Object element) {
        if (element instanceof IEditable) {
            return ((IEditable) element).isEditAllowed();
        }        
        return false;
    }
	
}
