/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

#include <stdio.h>

class CCounter {
private:
	static const int m_limit = 1000000;
	int m_counter;

public:
	CCounter() : m_counter(0) {
	};
	CCounter(const CCounter& counter) {
		m_counter = counter.m_counter;
	}
	void increment() {
		m_counter++;
	};
	int get() {
		return m_counter;
	};
	void set(int value) {
		m_counter = value;
	};
	int getLimit() {
		return m_limit;
	};
};

CCounter* myCounter;
CCounter myAccumulator;

int main() {

	for (;;) {
		myCounter = new CCounter();
		while((myCounter->get() < myCounter->getLimit())) {
			myCounter->increment();
		}
		__asm volatile ("svc 0");
		delete myCounter;
	}

	return 0;
}

extern "C" {

void __attribute__ ((interrupt ("SVC"))) SVC_Handler () {
		myAccumulator.set(myAccumulator.get() + myCounter->get());
		printf("counter is 0x%08x, accumulator is 0x%08x\n", myCounter->get(), myAccumulator.get());
	}

}
