/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

#include <stdio.h>

#define read_mpidr() ({									\
	unsigned long long __mpidr;							\
	__asm volatile("mrs %0, MPIDR_EL1" : "=r" (__mpidr));	\
	__mpidr;											\
})

#define clusterid(mpidr) ((mpidr >> 8) & 1)
#define coreid(mpidr) (mpidr & 1)

class CCounter {
private:
	static const int m_limit = 1000000;
	int m_counter;

public:
	CCounter() : m_counter(0) {
	};
	CCounter(const CCounter& counter) {
		m_counter = counter.m_counter;
	}
	void increment() {
		m_counter++;
	};
	int get() {
		return m_counter;
	};
	void set(int value) {
		m_counter = value;
	};
	int getLimit() {
		return m_limit;
	};
};

CCounter* myCounter;
CCounter myAccumulator;
int clusterid, coreid;

int main() {
	int mpidr = read_mpidr();
	clusterid = clusterid(mpidr);
	coreid = coreid(mpidr);

	for (;;) {
		myCounter = new CCounter();
		while((myCounter->get() < myCounter->getLimit())) {
			myCounter->increment();
		}
		__asm volatile ("svc 0");
		delete myCounter;
	}

	return 0;
}

extern "C" {

	void Current_EL3_SPx_Sync() {
		myAccumulator.set(myAccumulator.get() + myCounter->get());
		printf("cluster %d, A53 core %d, counter is 0x%08x, accumulator is 0x%08x\n",
				clusterid, coreid, myCounter->get(), myAccumulator.get());
	}

}
