/*
 * main implementation: use this 'C' sample to create your own application
 *
 */

#include <stdio.h>

#define read_mpidr() ({									\
	unsigned long long __mpidr;							\
	__asm volatile("mrs %0, MPIDR_EL1" : "=r" (__mpidr));	\
	__mpidr;											\
})

#define clusterid(mpidr) ((mpidr >> 8) & 1)
#define coreid(mpidr) (mpidr & 1)

int clusterid, coreid, counter, accumulator = 0, limit_value = 1000000;

int main(void) {
	int mpidr = read_mpidr();
	clusterid = clusterid(mpidr);
	coreid = coreid(mpidr);
	counter = 0;

	for (;;) {
		counter++;

		if (counter >= limit_value) {
			__asm volatile ("svc 0");
			counter = 0;
		}
	}
	return 0;
}

void Current_EL3_SPx_Sync() {
	accumulator += counter;
	printf("cluster %d, A53 core %d, counter is 0x%08x, accumulator is 0x%08x\n",
			clusterid, coreid, counter, accumulator);
}
