/**************************************************************************
 * FILE NAME: S32V234.h                            COPYRIGHT (c) NXP 2017 *
 * REVISION:  2.1                                     All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the S32V234.                                                           *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1   M.Doidge     04-Jun-2014  Generated from initial draft RDP       *
 *                                                                        *
 * 1.0   M.Doidge     22-Jul-2014  Generated from RDP rev 1 draft B       *
 *                                                                        *
 * 1.1   M.Doidge     23-Sep-2014  Generated from RDP rev 1.1 draft B     *
 *                                                                        *
 * 1.1.1 M.Doidge     01-Oct-2014  Corrected reserved memory definitions  *
 *                                 in modules: AXBS, H264_DEC, H264_ENC,  *
 *                                 HPSMI, IPUS, IPUV, jpeg, CSI, PIT, SSE *
 *                                                                        *
 * 1.1.2 M.Doidge     25-Nov-2014  Generated from RDP rev 1.1 draft C     *
 *                                                                        *
 * 1.1.3 M.Doidge     26-Nov-2014  Updated CSI module                     *
 *                                                                        *
 * 1.1.4 M.Doidge     20-Jan-2015  Corrected MC_CGM module                *
 *                                                                        *
 * 1.1.5 M.Doidge     19-Mar-2015  Generated from RDP rev 1.1 draft D     *
 *                                                                        *
 * 1.1.6 M.Doidge     27-Mar-2015  Added missing modules BIST, DFS,       *
 *                                 HPSMI_NIC, MCT, PMC, REP, SIUL2,	SRC,  *
 *                                 TMU, and WKPU                          *
 *                                                                        *
 * 1.1.7 M.Doidge     27-Mar-2015  Corrected issue in IPUS module         *
 *                                                                        *
 * 1.1.8 M.Doidge     14-May-2015  Generated from RDP rev 1.1 draft E     *
 *                                                                        *
 * 1.1.9 M.Doidge     26-May-2015  Generated from RDP rev 1.1 draft F     *
 *                                                                        *
 * 1.1.10 M.Doidge    13-Jul-2015  Generated from S32V234 RDP rev 1       *
 *                                                                        *
 * 1.2.0 M.Doidge     18-Nov-2015  Generated from S32V234 RDP rev 1.2     *
 *                                                                        *
 * 1.2.0A ttz778      23-Nov-2015 Added Cortex M4 and GIC tags            *
 *                                 Fixed illegal naming of bits in PCIe   *
 *                                 Fixed DCU_MODE macro conflict          *
 *                                 DCU.CTRLDESCL_1 HEIGHT & WIDTH -> 12 bit *
 *                                 DCU.CTRLDESCL_2 POSX and POSY are 13 bit *
 *                                 DCU.DISP_SIZE DELTA_Y is 12 bit        *
 *                                               DELTA_X is 8 bit         *
 *                                                                        *
 * 2.0 I. Talpiga     16-Mar-2017  Generated from S32V234 RDP rev 2.0 RC  *
 *                                                                        *
 * 2.1 I. Talpiga     29-Mar-2017  Generated from S32V234 RDP rev 2.0     *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR             *
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES *
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.   *
 *  IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,       *
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES        *
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR        *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)        *
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,       *
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING     *
 *  IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF            *
 *  THE POSSIBILITY OF SUCH DAMAGE.                                           *
 *                                                                            *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _S32V234_H_
#define _S32V234_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

typedef union AXBS_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_31:1;
  } B;
} AXBS_PORT_PRS_tag;

typedef union AXBS_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t PARK:3;                  /* Park */
    vuint32_t _unused_3:1;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_6:2;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_10:6;
    vuint32_t HPE0:1;
    vuint32_t HPE1:1;
    vuint32_t HPE2:1;
    vuint32_t HPE3:1;
    vuint32_t HPE4:1;
    vuint32_t HPE5:1;
    vuint32_t HPE6:1;
    vuint32_t HPE7:1;
    vuint32_t _unused_24:6;
    vuint32_t HLP:1;                   /* Halt Low Priority */
    vuint32_t RO:1;                    /* Read Only */
  } B;
} AXBS_PORT_CRS_tag;

typedef struct AXBS_PORT_struct_tag {
  AXBS_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint32_t PORT_reserved0[15];
  AXBS_PORT_CRS_tag CRS;               /* Control Register */
  uint32_t PORT_reserved1[59];
} AXBS_PORT_tag;

typedef union AXBS_MGPCR_MGPCR_union_tag { /* Master General Purpose Control Register */
  vuint32_t R;
  struct {
    vuint32_t AULB:3;                  /* Arbitrates On Undefined Length Bursts */
    vuint32_t _unused_3:29;
  } B;
} AXBS_MGPCR_MGPCR_tag;

typedef struct AXBS_MGPCR_struct_tag {
  AXBS_MGPCR_MGPCR_tag MGPCR;          /* Master General Purpose Control Register */
  uint32_t MGPCR_reserved0[63];
} AXBS_MGPCR_tag;

struct AXBS_tag {
  AXBS_PORT_tag PORT[8];
  AXBS_MGPCR_tag MGPCR[8];
};


/* ============================================================================
   =============================== Module: BCTRL ==============================
   ============================================================================ */

typedef union BCTRL_BISTALL_union_tag { /* BIST All register */
  vuint32_t R;
  struct {
    vuint32_t STAT_ALL:2;              /* Status All field */
    vuint32_t BIRA_FAIL:1;
    vuint32_t _unused_3:29;
  } B;
} BCTRL_BISTALL_tag;

typedef union BCTRL_BSEL_union_tag {   /* BIST Select Register */
  vuint32_t R;
  struct {
    vuint32_t BIST_CTRL:32;            /* BIST Select (BIST ID) */
  } B;
} BCTRL_BSEL_tag;

typedef union BCTRL_BIST_STAT_union_tag { /* BIST Status register */
  vuint32_t R;
  struct {
    vuint32_t BIST0STAT:4;             /* Status of BIST0 */
    vuint32_t BIST1STAT:4;             /* Status of BIST1 */
    vuint32_t BIST2STAT:4;             /* Status of BIST2 */
    vuint32_t BIST3STAT:4;             /* Status of BIST3 */
    vuint32_t BIST4STAT:4;             /* Status of BIST4 */
    vuint32_t BIST5STAT:4;             /* Status of BIST5 */
    vuint32_t BIST6STAT:4;             /* Status of BIST6 */
    vuint32_t BIST7STAT:4;             /* Status of BIST7 */
  } B;
} BCTRL_BIST_STAT_tag;

struct BCTRL_tag {
  uint8_t BCTRL_reserved0[44];
  BCTRL_BISTALL_tag BISTALL;           /* BIST All register */
  uint8_t BCTRL_reserved1[464];
  BCTRL_BSEL_tag BSEL;                 /* BIST Select Register */
  uint8_t BCTRL_reserved2[252];
  BCTRL_BIST_STAT_tag BIST_STAT;       /* BIST Status register */
};


/* ============================================================================
   =============================== Module: BIST ===============================
   ============================================================================ */

typedef union BIST_MSR_union_tag {     /* Memory selection register */
  vuint32_t R;
  struct {
    vuint32_t MSELn:32;                /* Memory Selection */
  } B;
} BIST_MSR_tag;

typedef union BIST_BSTART_union_tag {  /* BIST start register */
  vuint32_t R;
  struct {
    vuint32_t BSTART:2;
    vuint32_t _unused_2:30;
  } B;
} BIST_BSTART_tag;

typedef union BIST_BRST_union_tag {    /* BIST reset register */
  vuint32_t R;
  struct {
    vuint32_t BRST:1;
    vuint32_t SRST:1;
    vuint32_t _unused_2:30;
  } B;
} BIST_BRST_tag;

typedef union BIST_BSTAT_union_tag {   /* BIST status register */
  vuint32_t R;
  struct {
    vuint32_t BSTAT1:2;
    vuint32_t _unused_2:1;
    vuint32_t BSTAT3:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} BIST_BSTAT_tag;

typedef union BIST_BFPM_union_tag {    /* BIST Fail Per Memory register */
  vuint32_t R;
  struct {
    vuint32_t FPMn:32;                 /* Fail Per Memory */
  } B;
} BIST_BFPM_tag;

typedef union BIST_ROM_SEL_union_tag { /* ROM Selection register */
  vuint32_t R;
  struct {
    vuint32_t MISRL:2;                 /* MISR location */
    vuint32_t ROMSEL0:1;
    vuint32_t ROMSEL1:1;
    vuint32_t ROMSEL2:1;
    vuint32_t ROMSEL3:1;
    vuint32_t ROMSEL4:1;
    vuint32_t ROMSEL5:1;
    vuint32_t ROMSEL6:1;
    vuint32_t ROMSEL7:1;
    vuint32_t ROMSEL8:1;
    vuint32_t ROMSEL9:1;
    vuint32_t ROMSEL10:1;
    vuint32_t ROMSEL11:1;
    vuint32_t ROMSEL12:1;
    vuint32_t ROMSEL13:1;
    vuint32_t ROMSEL14:1;
    vuint32_t _unused_17:15;
  } B;
} BIST_ROM_SEL_tag;

typedef union BIST_ROM_STAT_union_tag { /* ROM General Status register */
  vuint32_t R;
  struct {
    vuint32_t BSTAT1:2;
    vuint32_t BSTAT2:1;
    vuint32_t BSTAT3:1;
    vuint32_t RFPM0:1;
    vuint32_t RFPM1:1;
    vuint32_t RFPM2:1;
    vuint32_t RFPM3:1;
    vuint32_t RFPM4:1;
    vuint32_t RFPM5:1;
    vuint32_t RFPM6:1;
    vuint32_t RFPM7:1;
    vuint32_t RFPM8:1;
    vuint32_t RFPM9:1;
    vuint32_t RFPM10:1;
    vuint32_t RFPM11:1;
    vuint32_t RFPM12:1;
    vuint32_t RFPM13:1;
    vuint32_t RFPM14:1;
    vuint32_t _unused_19:13;
  } B;
} BIST_ROM_STAT_tag;

typedef union BIST_ADDR_DBG_union_tag { /* Address Debug register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_19:13;
  } B;
} BIST_ADDR_DBG_tag;

typedef union BIST_DBG_union_tag {     /* Data Debug register */
  vuint32_t R;
  struct {
    vuint32_t CDATAn:32;               /* Compared data */
  } B;
} BIST_DBG_tag;

struct BIST_tag {
  uint8_t BIST_reserved0[64];
  BIST_MSR_tag MSR[8];                 /* Memory selection register */
  uint8_t BIST_reserved1[68];
  BIST_BSTART_tag BSTART;              /* BIST start register */
  BIST_BRST_tag BRST;                  /* BIST reset register */
  uint8_t BIST_reserved2[12];
  BIST_BSTAT_tag BSTAT;                /* BIST status register */
  BIST_BFPM_tag BFPM[8];               /* BIST Fail Per Memory register */
  uint8_t BIST_reserved3[32];
  BIST_ROM_SEL_tag ROM_SEL;            /* ROM Selection register */
  BIST_ROM_STAT_tag ROM_STAT;          /* ROM General Status register */
  uint8_t BIST_reserved4[12];
  BIST_ADDR_DBG_tag ADDR_DBG;          /* Address Debug register */
  BIST_DBG_tag DBG[16];                /* Data Debug register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
    vuint32_t _unused_7:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_10:1;
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t _unused_14:1;
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t _unused_26:1;
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t MDIS:1;                  /* Module Disable */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PROPSEG:3;               /* Propagation Segment */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t _unused_13:1;
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t TIMER:16;                /* Timer Value */
    vuint32_t _unused_16:16;
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t IDLE:1;
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t _unused_22:4;
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or Clear FIFO bit */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t EDFLTDIS:1;              /* Edge Filter Disable */
    vuint32_t ISOCANFDEN:1;            /* ISO CAN FD Enable */
    vuint32_t _unused_13:1;
    vuint32_t PREXCEN:1;               /* Protocol Exception Enable */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:13;
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t _unused_15:1;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_23:9;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
    vuint32_t _unused_15:1;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_23:9;
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
    vuint32_t _unused_9:23;
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t ERJW:5;                  /* Extended Resync Jump Width */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
  } B;
} CAN_CBT_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t _unused_10:3;
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t _unused_17:1;
    vuint32_t FANCEI_MSK:1;            /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t HANCEI_MSK:1;            /* Host Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t _unused_20:11;
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t INJADDR:14;              /* Error Injection Address */
    vuint32_t _unused_14:18;
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
    vuint32_t _unused_5:3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_13:3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_21:3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_29:3;
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
    vuint32_t _unused_14:2;
    vuint32_t SAID:3;
    vuint32_t _unused_19:5;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_25:7;
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
    vuint32_t _unused_5:2;
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t _unused_13:2;
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t _unused_21:2;
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t _unused_29:2;
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_4:12;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_20:12;
  } B;
} CAN_ERRSR_tag;

typedef union CAN_FDCTRL_union_tag {   /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
    vuint32_t _unused_6:2;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_13:1;
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_21:1;
    vuint32_t _unused_22:2;
    vuint32_t _unused_24:1;
    vuint32_t _unused_25:2;
    vuint32_t _unused_27:4;
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
  } B;
} CAN_FDCTRL_tag;

typedef union CAN_FDCBT_union_tag {    /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_8:2;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_15:1;
    vuint32_t FRJW:3;                  /* Fast Resync Jump Width */
    vuint32_t _unused_19:1;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_30:2;
  } B;
} CAN_FDCBT_tag;

typedef union CAN_FDCRC_union_tag {    /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
    vuint32_t _unused_21:3;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_31:1;
  } B;
} CAN_FDCRC_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[2092];
  CAN_RXIMR_tag RXIMR[64];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved3[352];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
  uint8_t CAN_reserved4[256];
  CAN_FDCTRL_tag FDCTRL;               /* CAN FD Control Register */
  CAN_FDCBT_tag FDCBT;                 /* CAN FD Bit Timing Register */
  CAN_FDCRC_tag FDCRC;                 /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t _unused_3:5;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_10:13;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_24:8;
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t FD:20;                   /* Measured frequency bits. */
    vuint32_t _unused_20:12;
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t HFREF:12;                /* High Frequency reference value. */
    vuint32_t _unused_12:20;
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
    vuint32_t _unused_12:20;
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:28;
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t MD:20;                   /* Measurement duration bits */
    vuint32_t _unused_20:12;
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG1_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;
    vuint32_t _unused_24:8;
  } B;
} CRC_CFG1_tag;

typedef union CRC_INP1_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP1_tag;

typedef union CRC_CSTAT1_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT1_tag;

typedef union CRC_OUTP1_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP1_tag;

typedef union CRC_MODE_CFG2_union_tag { /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;
    vuint32_t _unused_24:8;
  } B;
} CRC_MODE_CFG2_tag;

typedef union CRC_MODE_union_tag {
  CRC_MODE_CFG2_tag CFG2;              /* Configuration Register */
} CRC_MODE_tag;

typedef union CRC_INP2_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP2_tag;

typedef union CRC_CSTAT2_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT2_tag;

typedef union CRC_OUTP2_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP2_tag;

typedef union CRC_CFG3_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;
    vuint32_t _unused_24:8;
  } B;
} CRC_CFG3_tag;

typedef union CRC_INP3_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP3_tag;

typedef union CRC_CSTAT3_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT3_tag;

typedef union CRC_OUTP3_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP3_tag;

struct CRC_tag {
  CRC_CFG1_tag CFG1;                   /* Configuration Register */
  CRC_INP1_tag INP1;                   /* Input Register */
  CRC_CSTAT1_tag CSTAT1;               /* Current Status Register */
  CRC_OUTP1_tag OUTP1;                 /* Output Register */
  CRC_MODE_tag MODE;
  CRC_INP2_tag INP2;                   /* Input Register */
  CRC_CSTAT2_tag CSTAT2;               /* Current Status Register */
  CRC_OUTP2_tag OUTP2;                 /* Output Register */
  CRC_CFG3_tag CFG3;                   /* Configuration Register */
  CRC_INP3_tag INP3;                   /* Input Register */
  CRC_CSTAT3_tag CSTAT3;               /* Current Status Register */
  CRC_OUTP3_tag OUTP3;                 /* Output Register */
};


/* ============================================================================
   =============================== Module: CSE3 ===============================
   ============================================================================ */

typedef union CSE3_CR_union_tag {      /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;
    vuint32_t DRE:1;
    vuint32_t SUS:1;
    vuint32_t MDIS:1;
    vuint32_t SFE:1;
    vuint32_t KBS:1;
    vuint32_t _unused_6:26;
  } B;
} CSE3_CR_tag;

typedef union CSE3_SR_union_tag {      /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t BSY:1;
    vuint32_t SB:1;
    vuint32_t BIN:1;
    vuint32_t BFN:1;
    vuint32_t BOK:1;
    vuint32_t RIN:1;
    vuint32_t EDB:1;
    vuint32_t IDB:1;
    vuint32_t EX:1;
    vuint32_t FLC:1;
    vuint32_t LEC:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:20;
  } B;
} CSE3_SR_tag;

typedef union CSE3_IR_union_tag {      /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t CIF:1;
    vuint32_t _unused_1:31;
  } B;
} CSE3_IR_tag;

typedef union CSE3_ECR_union_tag {     /* Error Code Register */
  vuint32_t R;
  struct {
    vuint32_t EC:6;
    vuint32_t _unused_6:26;
  } B;
} CSE3_ECR_tag;

typedef union CSE3_TRNG_union_tag {    /* TRNG Control Register */
  vuint32_t R;
  struct {
    vuint32_t TTM:1;
    vuint32_t _unused_1:15;
    vuint32_t DLY:16;
  } B;
} CSE3_TRNG_tag;

typedef union CSE3_CMD_union_tag {     /* Command Register */
  vuint32_t R;
  struct {
    vuint32_t CMD:5;
    vuint32_t _unused_5:27;
  } B;
} CSE3_CMD_tag;

typedef union CSE3_P_union_tag {       /* Command Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t PARM:32;
  } B;
} CSE3_P_tag;

typedef union CSE3_KIA_union_tag {     /* Key Image Address Register */
  vuint32_t R;
  struct {
    vuint32_t KI_ADDR:32;
  } B;
} CSE3_KIA_tag;

typedef union CSE3_OTP_union_tag {     /* OTP Status Register */
  vuint32_t R;
  struct {
    vuint32_t SEC_CNT:6;
    vuint32_t _unused_6:26;
  } B;
} CSE3_OTP_tag;

typedef union CSE3_PC_union_tag {      /* Publish Count Register */
  vuint32_t R;
  struct {
    vuint32_t PUB_CNT:32;
  } B;
} CSE3_PC_tag;

typedef union CSE3_SRA0_union_tag {    /* Secure RAM Address Register */
  vuint32_t R;
  struct {
    vuint32_t SEC_RAM_ADDR:32;
  } B;
} CSE3_SRA0_tag;

typedef union CSE3_SRS0_union_tag {    /* Secure RAM Size Register */
  vuint32_t R;
  struct {
    vuint32_t SEC_RAM_SIZE:32;
  } B;
} CSE3_SRS0_tag;

struct CSE3_tag {
  CSE3_CR_tag CR;                      /* Control Register */
  CSE3_SR_tag SR;                      /* Status Register */
  CSE3_IR_tag IR;                      /* Interrupt Register */
  CSE3_ECR_tag ECR;                    /* Error Code Register */
  CSE3_TRNG_tag TRNG;                  /* TRNG Control Register */
  uint8_t CSE3_reserved0[12];
  CSE3_CMD_tag CMD;                    /* Command Register */
  CSE3_P_tag P[5];                     /* Command Parameter Register */
  uint8_t CSE3_reserved1[24];
  CSE3_KIA_tag KIA[2];                 /* Key Image Address Register */
  CSE3_OTP_tag OTP;                    /* OTP Status Register */
  CSE3_PC_tag PC;                      /* Publish Count Register */
  uint8_t CSE3_reserved2[16];
  CSE3_SRA0_tag SRA0;                  /* Secure RAM Address Register */
  CSE3_SRS0_tag SRS0;                  /* Secure RAM Size Register */
};


/* ============================================================================
   =============================== Module: DCU ================================
   ============================================================================ */

typedef union DCU_CTRLDESCCURSOR1_union_tag { /* Control Descriptor Cursor 1 Register */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:11;                /* Width of the cursor in pixels. */
    vuint32_t _unused_11:5;
    vuint32_t HEIGHT:11;               /* Height of the cursor in pixels. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CTRLDESCCURSOR1_tag;

typedef union DCU_CTRLDESCCURSOR2_union_tag { /* Control Descriptor Cursor 2 Register */
  vuint32_t R;
  struct {
    vuint32_t POSX:11;                 /* X position of the cursor in pixels */
    vuint32_t _unused_11:5;
    vuint32_t POSY:11;                 /* Y position of the cursor in pixels */
    vuint32_t _unused_27:5;
  } B;
} DCU_CTRLDESCCURSOR2_tag;

typedef union DCU_CTRLDESCCURSOR3_union_tag { /* Control Descriptor Cursor 3 Register */
  vuint32_t R;
  struct {
    vuint32_t DEFAULT_CURSOR_COLOR:24; /* Default pixel color value for the cursor. In the 2D-ACE, the pixel value for the cursor is fixed for a particular frame. */
    vuint32_t _unused_24:7;
    vuint32_t CUR_EN:1;                /* Cursor Enable signal. */
  } B;
} DCU_CTRLDESCCURSOR3_tag;

typedef union DCU_MODE_union_tag {     /* Mode Register */
  vuint32_t R;
  struct {
    vuint32_t DCU_MODE:2;              /* 2D-ACE operating mode. */
    vuint32_t EN_GAMMA:1;              /* Enables/Disables the Gamma Correction. */
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t SIG_EN:1;                /* Enables the signature calculator block. */
    vuint32_t TAG_EN:1;                /* Enables the calculation of CRC only on the safety layers. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:2;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t RASTER_EN:1;             /* Enables raster scanning of pixel data including the VSYNC and HSYNC signals and the pixel data. This bit takes effect immediately and does not require a transfer to the frame timing logic. */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:4;
    vuint32_t BLEND_ITER:3;            /* Defines the maximum number of pixels which are blended in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t ADDR:2;                  /* Two-bit value to be added to pixel red component for dithering. */
    vuint32_t ADDG:2;                  /* Two bit Value to be added with pixel green component for dithering. */
    vuint32_t ADDB:2;                  /* Two-bit value to be added to pixel blue component for dithering. */
    vuint32_t EN_DITHER:1;             /* Enable dithering mode. */
    vuint32_t DCU_SW_RESET:1;
  } B;
} DCU_MODE_tag;

typedef union DCU_BGND_union_tag {     /* Background Register */
  vuint32_t R;
  struct {
    vuint32_t BGND_B:8;                /* Blue component of the default color displayed in the sectors where no layer is active. */
    vuint32_t BGND_G:8;                /* Green component of the default color displayed in the sectors where no layer is active. */
    vuint32_t BGND_R:8;                /* Red component of the default color displayed in the sectors where no layer is active. */
    vuint32_t _unused_24:8;
  } B;
} DCU_BGND_tag;

typedef union DCU_DISP_SIZE_union_tag { /* Display Size Register */
  vuint32_t R;
  struct {
    vuint32_t DELTA_X:8;               /* Sets the display size horizontal resolution (in multiples of 16 pixels) */
    vuint32_t _unused_8:8;
    vuint32_t DELTA_Y:12;              /* Sets the display size vertical resolution (in pixels) */
    vuint32_t _unused_28:4;
  } B;
} DCU_DISP_SIZE_tag;

typedef union DCU_HSYN_PARA_union_tag { /* Horizontal Sync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t FP_H:9;                  /* HSYNC front-porch pulse width (in pixel clock cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_9:2;
    vuint32_t PW_H:9;                  /* HSYNC active pulse width (in pixel clock cycles). */
    vuint32_t _unused_20:2;
    vuint32_t BP_H:9;                  /* HSYNC back-porch pulse width (in pixel clock cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_31:1;
  } B;
} DCU_HSYN_PARA_tag;

typedef union DCU_VSYN_PARA_union_tag { /* Vertical Sync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t FP_V:9;                  /* VSYNC front-porch pulse width (in horizontal line cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_9:2;
    vuint32_t PW_V:9;                  /* VSYNC active pulse width (in horizontal line cycles). */
    vuint32_t _unused_20:2;
    vuint32_t BP_V:9;                  /* VSYNC back-porch pulse width (in horizontal line cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_31:1;
  } B;
} DCU_VSYN_PARA_tag;

typedef union DCU_SYNPOL_union_tag {   /* Synchronize Polarity Register */
  vuint32_t R;
  struct {
    vuint32_t INV_HS:1;                /* Invert Horizontal synchronization signal. */
    vuint32_t INV_VS:1;                /* Invert Vertical synchronization signal. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t NEG:1;                   /* Indicates if value at the output (pixel data output) needs to be negated. */
    vuint32_t INV_PXCK:1;              /* Polarity change of Pixel Clock. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:1;
    vuint32_t INV_DE:1;                /* Invert Data Enable polarity */
    vuint32_t _unused_12:20;
  } B;
} DCU_SYNPOL_tag;

typedef union DCU_THRESHOLD_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t OUT_BUF_LOW:8;           /* Output buffer filling low Threshold (in pixels).This value is used to generate the underrun exception (UNDRUN in INT_STATUS). The maximum programmable threshold is 127. */
    vuint32_t OUT_BUF_HIGH:8;          /* Output buffer high threshold (in pixels). When the output buffer exceeds this value, the datapath clock is suspended. The maximum programmable threshold is 127. */
    vuint32_t LS_BF_VS:11;             /* Lines before VS_BLANK threshold value. This field provides the value in terms of number of lines before the VS_BLANK interval starts at which the LS_BF_VS status flag in INT_STATUS register is set. */
    vuint32_t _unused_27:5;
  } B;
} DCU_THRESHOLD_tag;

typedef union DCU_INT_STATUS_union_tag { /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t VSYNC:1;                 /* Interrupt flag to indicate that the vertical synchronization phase has begun. If enabled, an interrupt is generated at the beginning of a frame. */
    vuint32_t UNDRUN:1;                /* Interrupt flag to indicate the output buffer underrun condition. Asserted when the panel needs data and the output buffer level is lower than or equal to the OUT_BUF_LOW threshold. Flag is cleared when the data in the output buffer is greater than threshold and CPU writes 1 to this bit. */
    vuint32_t LS_BF_VS:1;              /* Interrupt flag to indicate the Lines Before VS_BLANK event has been reached. The LS_BF_VS field in the Threshold register defines the timing of the event. */
    vuint32_t VS_BLANK:1;              /* Interrupt signal to indicate vertical blanking period. This is the period in which all the registers that affect the visible state of the layers need to be latched. This is needed so that CPU writes to the register while the display is being updated does not cause any errors. Interrupt can be cleared by writing 1 to this bit.. */
    vuint32_t CRC_READY:1;             /* Interrupt flag to indicate CRC calculation is done and ready to be compared with precomputed CRC value by the software. */
    vuint32_t CRC_OVERFLOW:1;          /* Interrupt signal to indicate that CRC_ready has not been serviced and CRC has been calculated for the next frame */
    vuint32_t P1_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t P1_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t P2_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 2 in the pixel blend stack. */
    vuint32_t P2_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 2 in the pixel blend stack. */
    vuint32_t PROG_END:1;              /* Interrupt flag which indicates that the 2D-ACE has begun to transfer layer configuration from the layer control descriptor registers into the functional block. Any register modification after this time and before LYR_TRANS_FINISH is asserted may or may not be included in this transfer. */
    vuint32_t IPM_ERROR:1;             /* Interrupt flag, which indicates that an error has occured in an AXI bus read transaction. */
    vuint32_t LYR_TRANS_FINISH:1;      /* Interrupt flag to indicate that the transfer is complete of layer configuration from the layer control descriptor registers into the functional block */
    vuint32_t _unused_13:1;
    vuint32_t DMA_TRANS_FINISH:1;      /* Interrupt flag, which indicates that the DMA has fetched the last pixel of data from the memory. */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:2;
    vuint32_t P1_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 1 (lowest) in the pixel blend stack underflowed. */
    vuint32_t P2_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 2 in the pixel blend stack underflowed. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} DCU_INT_STATUS_tag;

typedef union DCU_INT_MASK_union_tag { /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t M_VSYNC:1;               /* Mask for VSYNC interrupt flag. */
    vuint32_t M_UNDRUN:1;              /* Mask for M_UNDRUN interrupt flag. */
    vuint32_t M_LS_BF_VS:1;            /* Mask for LS_BF_VS interrupt flag. */
    vuint32_t M_VS_BLANK:1;            /* Mask for VS_BLANK interrupt flag */
    vuint32_t M_CRC_READY:1;           /* Mask for CRC_READY interrupt flag. */
    vuint32_t M_CRC_OVERFLOW:1;        /* Mask for CRC_OVERFLOW interrupt flag. */
    vuint32_t M_P1_FIFO_LO_FLAG:1;     /* Mask for P1_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P1_FIFO_HI_FLAG:1;     /* Mask for P1_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_P2_FIFO_LO_FLAG:1;     /* Mask for P2_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P2_FIFO_HI_FLAG:1;     /* Mask for P2_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_PROG_END:1;            /* Mask for PROG_END interrupt flag. */
    vuint32_t M_IPM_ERROR:1;           /* Mask for IPM_ERROR interrupt flag. */
    vuint32_t M_LYR_TRANS_FINISH:1;    /* Mask for LYR_TRANS_FINISH interrupt flag. */
    vuint32_t _unused_13:1;
    vuint32_t M_DMA_TRANS_FINISH:1;    /* Mask for DMA_TRANS_FINISH interrupt flag. */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:2;
    vuint32_t M_P1_EMPTY:1;            /* Mask for P1_EMPTY interrupt flag. */
    vuint32_t M_P2_EMPTY:1;            /* Mask for P2_EMPTY interrupt flag. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} DCU_INT_MASK_tag;

typedef union DCU_COLBAR_1_union_tag { /* COLBAR_1 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_1_tag;

typedef union DCU_COLBAR_2_union_tag { /* COLBAR_2 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_2_tag;

typedef union DCU_COLBAR_3_union_tag { /* COLBAR_3 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_3_tag;

typedef union DCU_COLBAR_4_union_tag { /* COLBAR_4 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_4_tag;

typedef union DCU_COLBAR_5_union_tag { /* COLBAR_5 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_5_tag;

typedef union DCU_COLBAR_6_union_tag { /* COLBAR_6 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_6_tag;

typedef union DCU_COLBAR_7_union_tag { /* COLBAR_7 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_7_tag;

typedef union DCU_COLBAR_8_union_tag { /* COLBAR_8 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_8_tag;

typedef union DCU_DIV_RATIO_union_tag { /* Divide Ratio Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_RATIO:8;             /* Specifies the divide value for the input clock. Used to generate the pixel clock to support different types of displays. To divide by N, set the DIV_RATIO to (N - 1). */
    vuint32_t _unused_8:23;
    vuint32_t DUAL_EDGE_EN:1;          /* When set to 1, the frequency of pixel clock driving the display is reduced by factor 2. Both rising and falling edges, are used for providing the pixel data (RGB) and other control signals. */
  } B;
} DCU_DIV_RATIO_tag;

typedef union DCU_SIGN_CALC_1_union_tag { /* Sign Calculation 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SIG_HOR_SIZE:12;         /* Horizontal size of window of interest of pixels for CRC calculations (in pixels). */
    vuint32_t _unused_12:4;
    vuint32_t SIG_VER_SIZE:12;         /* Vertical size of the window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_28:4;
  } B;
} DCU_SIGN_CALC_1_tag;

typedef union DCU_SIGN_CALC_2_union_tag { /* Sign Calculation 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SIG_HOR_POS:12;          /* Horizontal position of window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_12:4;
    vuint32_t SIG_VER_POS:12;          /* Vertical position of the window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_28:4;
  } B;
} DCU_SIGN_CALC_2_tag;

typedef union DCU_CRC_VAL_union_tag {  /* CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CRC_VAL:32;              /* The result of the CRC calculation for the value of the pixels on the safety layers */
  } B;
} DCU_CRC_VAL_tag;

typedef union DCU_PARR_ERR_STATUS1_union_tag { /* Parameter Error Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t L7_0:8;                  /* A value of 1 indicates that a parameter error exists for the corresponding layer */
    vuint32_t _unused_8:24;
  } B;
} DCU_PARR_ERR_STATUS1_tag;

typedef union DCU_PARR_ERR_STATUS3_union_tag { /* Parameter Error Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t DISP_ERR:1;              /* Interrupt occurs whenever width and height of display, pulse width (both vertical and horizontal sync) value is 0. */
    vuint32_t SIG_ERR:1;               /* Interrupt occurs whenever the area of interest specified by SIG_CALC register is outside the display size. */
    vuint32_t HWC_ERR:1;               /* Interrupt signal to indicate HWC error. This can occur if HWC position is out of display area or cursor memory is bigger than the HWC size. When this occurs, the HWC is disabled. */
    vuint32_t _unused_3:1;             /* This field is reserved. */
    vuint32_t _unused_4:28;
  } B;
} DCU_PARR_ERR_STATUS3_tag;

typedef union DCU_MASK_PARR_ERR_STATUS1_union_tag { /* Mask Parameter Error Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ML7_0:8;                 /* Mask for L[7:0] interrupt flag. */
    vuint32_t _unused_8:24;
  } B;
} DCU_MASK_PARR_ERR_STATUS1_tag;

typedef union DCU_MASK_PARR_ERR_STATUS3_union_tag { /* Mask Parameter Error Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t M_DISP_ERR:1;            /* Mask for DISP_ERR interrupt flag. */
    vuint32_t M_SIG_ERR:1;             /* Mask for SIG_ERR interrupt flag. */
    vuint32_t M_HWC_ERR:1;             /* Mask for HWC_ERR interrupt flag. */
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:28;
  } B;
} DCU_MASK_PARR_ERR_STATUS3_tag;

typedef union DCU_THRESHOLD_INP_BUF_1_union_tag { /* Threshold Input 1 Register */
  vuint32_t R;
  struct {
    vuint32_t INP_BUF_P1_LO:7;         /* Low threshold for the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t _unused_7:1;
    vuint32_t INP_BUF_P1_HI:7;         /* High threshold for the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t _unused_15:1;
    vuint32_t INP_BUF_P2_LO:7;         /* Low threshold for the FIFO in position 2 in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t INP_BUF_P2_HI:7;         /* High threshold for the FIFO in position 2 in the pixel blend stack. */
    vuint32_t _unused_31:1;
  } B;
} DCU_THRESHOLD_INP_BUF_1_tag;

typedef union DCU_LUMA_COMP_union_tag { /* LUMA Component Register */
  vuint32_t R;
  struct {
    vuint32_t Y_BLUE:10;               /* Luminance coefficient for blue component. */
    vuint32_t _unused_10:1;
    vuint32_t Y_GREEN:10;              /* Luminance coefficient for green component. */
    vuint32_t _unused_21:1;
    vuint32_t Y_RED:10;                /* Luminance coefficient for red component. */
  } B;
} DCU_LUMA_COMP_tag;

typedef union DCU_CHROMA_RED_union_tag { /* Red Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_RED:12;               /* Cb coefficient for calculation of red component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_RED:11;               /* Cr coefficient for calculation of red component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_RED_tag;

typedef union DCU_CHROMA_GREEN_union_tag { /* Green Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_GREEN:12;             /* Cb coefficient for calculation of green component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_GREEN:11;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_GREEN_tag;

typedef union DCU_CHROMA_BLUE_union_tag { /* Blue Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_BLUE:12;              /* Cb coefficient for calculation of blue component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_BLUE:11;              /* Cr coefficient for calculation of blue component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_BLUE_tag;

typedef union DCU_CRC_POS_union_tag {  /* CRC Position Register */
  vuint32_t R;
  struct {
    vuint32_t CRC_POS:32;              /* The result of the CRC calculation for the position of the pixels on the safety layers. */
  } B;
} DCU_CRC_POS_tag;

typedef union DCU_LYR_INTPOL_EN_union_tag { /* Layer Interpolation Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t EN:1;                    /* Interpolation Enable bit for DCU3 Layer coded in YCbCr422 format. */
  } B;
} DCU_LYR_INTPOL_EN_tag;

typedef union DCU_LYR_LUMA_COMP_union_tag { /* Layer Luminance Component Register */
  vuint32_t R;
  struct {
    vuint32_t Y_BLUE:10;               /* Luminance coefficient for blue component. */
    vuint32_t _unused_10:1;
    vuint32_t Y_GREEN:10;              /* Luminance coefficient for green component. */
    vuint32_t _unused_21:1;
    vuint32_t Y_RED:10;                /* Luminance coefficient for red component. */
  } B;
} DCU_LYR_LUMA_COMP_tag;

typedef union DCU_LYR_CHRM_RED_union_tag { /* Layer Chroma Red Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_RED:12;               /* Cb coefficient for calculation of red component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_RED:11;               /* Cr coefficient for calculation of red component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_RED_tag;

typedef union DCU_LYR_CHRM_GRN_union_tag { /* Layer Chroma Green Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_GREEN:12;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_GREEN:11;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_GRN_tag;

typedef union DCU_LYR_CHRM_BLUE_union_tag { /* Layer Chroma Blue Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_BLUE:12;              /* Cb coefficient for calculation of blue component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_BLUE:11;              /* Cr coefficient for calculation of blue component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_BLUE_tag;

typedef union DCU_UPDATE_MODE_union_tag { /* Update Mode Register */
  vuint32_t R;
  struct {
    vuint32_t TRIG_PROG_END:8;
    vuint32_t _unused_8:22;
    vuint32_t READREG:1;               /* When the MODE bit is clear this bit is a control bit which can be written to initiate a transfer of register value during the next vertical blanking period. */
    vuint32_t MODE:1;                  /* Do not set the MODE bit while the READREG is also set as this will block automatic updates. Do not set the MODE bit and the READREG register in the same write operation. */
  } B;
} DCU_UPDATE_MODE_tag;

typedef union DCU_UNDERRUN_union_tag { /* Underrun Register */
  vuint32_t R;
  struct {
    vuint32_t PIXEL:11;                /* Pixel number where the under run occured. */
    vuint32_t _unused_11:5;
    vuint32_t LINE:11;                 /* Line number where the underrun occured. */
    vuint32_t _unused_27:5;
  } B;
} DCU_UNDERRUN_tag;

typedef union DCU_FRM_CRC_CTRL_union_tag { /* Frame CRC Control */
  vuint32_t R;
  struct {
    vuint32_t FRM_CRC_EN:1;
    vuint32_t _unused_1:31;
  } B;
} DCU_FRM_CRC_CTRL_tag;

typedef union DCU_FRM_CRC_VAL_union_tag { /* Frame CRC Value */
  vuint32_t R;
  struct {
    vuint32_t FRM_CRC_VAL:32;
  } B;
} DCU_FRM_CRC_VAL_tag;

typedef union DCU_TX_ESCAL_LVL_union_tag { /* QoS Level */
  vuint32_t R;
  struct {
    vuint32_t TX_ESCAL_LVL:4;
    vuint32_t _unused_4:28;
  } B;
} DCU_TX_ESCAL_LVL_tag;

typedef union DCU_GPR_union_tag {      /* Global Protection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t HLB:1;                   /* Hard Lock Bit. This bit cannot be cleared once it is set by software. It can only be cleared by a system reset. */
  } B;
} DCU_GPR_tag;

typedef union DCU_SLR_L0_union_tag {   /* Soft Lock Bit Layer 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t SLB_L0_11:1;             /* Soft Lock Bit for Control Desc L0_11 Register. */
    vuint32_t _unused_12:3;
    vuint32_t WEN_L0_11:1;             /* Write Enable for Soft Lock Bit SLB_L0_11. */
    vuint32_t SLB_L0_10:1;             /* Soft Lock Bit for Control Desc L0_10 Register. */
    vuint32_t SLB_L0_7:1;              /* Soft Lock Bit for Control Desc L0_7 Register. */
    vuint32_t SLB_L0_6:1;              /* Soft Lock Bit for Control Desc L0_6 Register. */
    vuint32_t SLB_L0_5:1;              /* Soft Lock Bit for Control Desc L0_5 Register. */
    vuint32_t WEN_L0_10:1;             /* Write Enable for Soft Lock Bit SLB_L0_10. */
    vuint32_t WEN_LO_7:1;              /* Write Enable for Soft Lock Bit SLB_L0_7. */
    vuint32_t WEN_LO_6:1;              /* Write Enable for Soft Lock Bit SLB_L0_6. */
    vuint32_t WEN_LO_5:1;              /* Write Enable for Soft Lock Bit SLB_L0_5. */
    vuint32_t SLB_L0_4:1;              /* Soft Lock Bit for Control Desc L0_4 Register. */
    vuint32_t SLB_L0_3:1;              /* Soft Lock Bit for Control Desc L0_3 Register. */
    vuint32_t SLB_L0_2:1;              /* Soft Lock Bit for Control Desc L0_2 Register. */
    vuint32_t SLB_L0_1:1;              /* Soft Lock Bit for Control Desc L0_1 Register. */
    vuint32_t WEN_LO_4:1;              /* Write Enable for Soft Lock Bit SLB_L0_4. */
    vuint32_t WEN_LO_3:1;              /* Write Enable for Soft Lock Bit SLB_L0_3. */
    vuint32_t WEN_LO_2:1;              /* Write Enable for Soft Lock Bit SLB_L0_2. */
    vuint32_t WEN_LO_1:1;              /* Write Enable for Soft Lock Bit SLB_L0_1. */
  } B;
} DCU_SLR_L0_tag;

typedef union DCU_SLR_L1_union_tag {   /* Soft Lock Bit Layer 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t SLB_L1_11:1;             /* Soft Lock Bit for Control Desc L1_11 Register. */
    vuint32_t _unused_12:3;
    vuint32_t WEN_L1_11:1;             /* Write Enable for Soft Lock Bit SLB_L1_11. */
    vuint32_t SLB_L1_10:1;             /* Soft Lock Bit for Control Desc L1_10 Register. */
    vuint32_t SLB_L1_7:1;              /* Soft Lock Bit for Control Desc L1_7 Register. */
    vuint32_t SLB_L1_6:1;              /* Soft Lock Bit for Control Desc L1_6 Register. */
    vuint32_t SLB_L1_5:1;              /* Soft Lock Bit for Control Desc L1_5 Register. */
    vuint32_t WEN_L1_10:1;             /* Write Enable for Soft Lock Bit SLB_L1_10. */
    vuint32_t WEN_L1_7:1;              /* Write Enable for Soft Lock Bit SLB_L1_7. */
    vuint32_t WEN_L1_6:1;              /* Write Enable for Soft Lock Bit SLB_L1_6. */
    vuint32_t WEN_L1_5:1;              /* Write Enable for Soft Lock Bit SLB_L1_5. */
    vuint32_t SLB_L1_4:1;              /* Soft Lock Bit for Control Desc L1_4 Register. */
    vuint32_t SLB_L1_3:1;              /* Soft Lock Bit for Control Desc L1_3 Register. */
    vuint32_t SLB_L1_2:1;              /* Soft Lock Bit for Control Desc L1_2 Register. */
    vuint32_t SLB_L1_1:1;              /* Soft Lock Bit for Control Desc L1_1 Register. */
    vuint32_t WEN_L1_4:1;              /* Write Enable for Soft Lock Bit SLB_L1_4. */
    vuint32_t WEN_L1_3:1;              /* Write Enable for Soft Lock Bit SLB_L1_3. */
    vuint32_t WEN_L1_2:1;              /* Write Enable for Soft Lock Bit SLB_L1_2. */
    vuint32_t WEN_L1_1:1;              /* Write Enable for Soft Lock Bit SLB_L1_1. */
  } B;
} DCU_SLR_L1_tag;

typedef union DCU_SLR_DISP_SIZE_union_tag { /* Soft Lock Display Size Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t SLB_DISP:1;              /* Soft Lock Bit for DISP_SIZE Register. This bit cannot be cleared once set by software. Can only be cleared by system reset. */
    vuint32_t _unused_28:3;
    vuint32_t WEN_DISP:1;              /* Write Enable for Soft Lock Bit SLB_DISP. */
  } B;
} DCU_SLR_DISP_SIZE_tag;

typedef union DCU_SLR_HVSYNC_PARA_union_tag { /* Soft Lock Hsync/Vsync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_VSYNC:1;             /* Soft Lock Bit for VSYNC Register. */
    vuint32_t SLB_HSYNC:1;             /* Soft Lock Bit for HSYNC Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_VSYNC:1;             /* Write Enable for Soft Lock Bit SLB_VSYNC */
    vuint32_t WEN_HSYNC:1;             /* Write Enable for Soft Lock Bit SLB_HSYNC. */
  } B;
} DCU_SLR_HVSYNC_PARA_tag;

typedef union DCU_SLR_POL_union_tag {  /* Soft Lock POL Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t SLB_POL:1;               /* Soft Lock Bit for SYN_POL Register. */
    vuint32_t _unused_28:3;
    vuint32_t WEN_POL:1;               /* Write Enable for Soft Lock Bit SLB_POL */
  } B;
} DCU_SLR_POL_tag;

typedef union DCU_SLR_L0_TRANSP_union_tag { /* Soft Lock L0 Transparency Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_L0_BCOLOR:1;         /* Soft Lock Bit for L0_BCOLOR Register. */
    vuint32_t SLB_L0_FCOLOR:1;         /* Soft Lock Bit for L0_FCOLOR Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_L0_BCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L0_BCOLOR */
    vuint32_t WEN_L0_FCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L0_FCOLOR */
  } B;
} DCU_SLR_L0_TRANSP_tag;

typedef union DCU_SLR_L1_TRANSP_union_tag { /* Soft Lock L1 Transparency Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_L1_BCOLOR:1;         /* Soft Lock Bit for L1_BCOLOR Register. */
    vuint32_t SLB_L1_FCOLOR:1;         /* Soft Lock Bit for L1_FCOLOR Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_L1_BCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L1_BCOLOR */
    vuint32_t WEN_L1_FCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L1_FCOLOR */
  } B;
} DCU_SLR_L1_TRANSP_tag;

typedef union DCU_LAYER_CTRLDESCL_1_union_tag { /* Control Descriptor Layer 1 Register */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:12;                /* Width of the layer (in pixels). */
    vuint32_t _unused_12:4;
    vuint32_t HEIGHT:12;               /* Height of the layer in pixels. */
    vuint32_t _unused_28:4;
  } B;
} DCU_LAYER_CTRLDESCL_1_tag;

typedef union DCU_LAYER_CTRLDESCL_2_union_tag { /* Control Descriptor Layer 2 Register */
  vuint32_t R;
  struct {
    vuint32_t POSX:13;                 /* Two's complement signed value setting the horizontal position of left hand column of the layer, where 0 is the left-hand column of the panel. Positive values are to the right and negative values are to the left the left-hand column of the panel. */
    vuint32_t _unused_13:3;
    vuint32_t POSY:13;                 /* Two's complement signed value setting the vertical position of top row of the layer, where 0 is the top row of the panel. Positive values are below and negative values are above the top row of the panel. */
    vuint32_t _unused_29:3;
  } B;
} DCU_LAYER_CTRLDESCL_2_tag;

typedef union DCU_LAYER_CTRLDESCL_3_union_tag { /* Control Descriptor Layer 3 Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;                 /* Address of layer data in the memory. The address programmed should be 64-bit aligned. */
  } B;
} DCU_LAYER_CTRLDESCL_3_tag;

typedef union DCU_LAYER_CTRLDESCL_4_union_tag { /* Control Descriptor Layer 4 Register */
  vuint32_t R;
  struct {
    vuint32_t AB:2;                    /* Alpha Blending. */
    vuint32_t BB:1;                    /* Chroma Keying. */
    vuint32_t _unused_3:1;             /* The field is reserved */
    vuint32_t LUOFFS:11;               /* Look Up Table offset. */
    vuint32_t _unused_15:1;            /* This field is reserved. */
    vuint32_t BPP:4;                   /* Layer encoding format (bit per pixel) */
    vuint32_t TRANS:8;                 /* Transparency Level. Specifies the alpha value for the layer. This value may be used by the blending engine to blend pixels on this layer. Value can vary between 0-255 where 0 is completely transparent and 255 is completely opaque. */
    vuint32_t SAFETY_EN:1;             /* Safety Mode Enable Bit. Valid only for layer 0 and layer 1. For registers of all other layers, this should be set to 0. */
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t EN:1;                    /* Enable the layer. */
  } B;
} DCU_LAYER_CTRLDESCL_4_tag;

typedef union DCU_LAYER_CTRLDESCL_5_union_tag { /* Control Descriptor Layer 5 Register */
  vuint32_t R;
  struct {
    vuint32_t CKMAX_B:8;               /* Chroma Keying Max Blue Component. */
    vuint32_t CKMAX_G:8;               /* Chroma Keying Max Green Component */
    vuint32_t CKMAX_R:8;               /* Chroma Keying Max Red Component. */
    vuint32_t _unused_24:8;
  } B;
} DCU_LAYER_CTRLDESCL_5_tag;

typedef union DCU_LAYER_CTRLDESCL_6_union_tag { /* Control Descriptor Layer 6 Register */
  vuint32_t R;
  struct {
    vuint32_t CKMIN_B:8;               /* Chroma Keying Minimum Blue Component. */
    vuint32_t CKMIN_G:8;               /* Chroma Keying Minimum Green Component. */
    vuint32_t CKMIN_R:8;               /* Chroma Keying Minimum Red Component */
    vuint32_t _unused_24:8;
  } B;
} DCU_LAYER_CTRLDESCL_6_tag;

typedef union DCU_LAYER_CTRLDESCL_8_union_tag { /* Control Descriptor Layer 8 Register */
  vuint32_t R;
  struct {
    vuint32_t FGn_FCOLOR:24;           /* Foreground color to use when the layer is configured to use a transparency mode. */
    vuint32_t _unused_24:8;
  } B;
} DCU_LAYER_CTRLDESCL_8_tag;

typedef union DCU_LAYER_CTRLDESCL_9_union_tag { /* Control Descriptor Layer 9 Register */
  vuint32_t R;
  struct {
    vuint32_t FGn_BCOLOR:24;           /* Background color to use when the layer is configured to use a transparency mode */
    vuint32_t _unused_24:8;
  } B;
} DCU_LAYER_CTRLDESCL_9_tag;

typedef union DCU_LAYER_CTRLDESCL_10_union_tag { /* Control Descriptor Layer 10 Register */
  vuint32_t R;
  struct {
    vuint32_t PRE_SKIP:12;             /* This field indicates the number of pixels to be skipped from the start at each line of the rectangular layer. The number of pixels specified by the PRE_SKIP field do not take part in arbitration and blending stage. PRE_SKIP field along with POST_SKIP field provides a visual in which layer appears to be horizontally cropped. This value in this field is treated as unsigned. */
    vuint32_t _unused_12:4;
    vuint32_t POST_SKIP:12;            /* This field indicates the number of pixels to be skipped before the end of each line of the rectangular layer. The number of pixels specified by the POST_SKIP field do not take part in arbitration and blending stage. POST_SKIP field along with PRE_SKIP field provides a visual in which layer appears to be horizontally cropped. The value in this field is treated as unsigned. */
    vuint32_t _unused_28:3;
    vuint32_t EN_GPUTILE:1;
  } B;
} DCU_LAYER_CTRLDESCL_10_tag;

typedef struct DCU_LAYER_struct_tag {
  DCU_LAYER_CTRLDESCL_1_tag CTRLDESCL_1; /* Control Descriptor Layer 1 Register */
  DCU_LAYER_CTRLDESCL_2_tag CTRLDESCL_2; /* Control Descriptor Layer 2 Register */
  DCU_LAYER_CTRLDESCL_3_tag CTRLDESCL_3; /* Control Descriptor Layer 3 Register */
  DCU_LAYER_CTRLDESCL_4_tag CTRLDESCL_4; /* Control Descriptor Layer 4 Register */
  DCU_LAYER_CTRLDESCL_5_tag CTRLDESCL_5; /* Control Descriptor Layer 5 Register */
  DCU_LAYER_CTRLDESCL_6_tag CTRLDESCL_6; /* Control Descriptor Layer 6 Register */
  uint8_t LAYER_reserved0[4];
  DCU_LAYER_CTRLDESCL_8_tag CTRLDESCL_8; /* Control Descriptor Layer 8 Register */
  DCU_LAYER_CTRLDESCL_9_tag CTRLDESCL_9; /* Control Descriptor Layer 9 Register */
  DCU_LAYER_CTRLDESCL_10_tag CTRLDESCL_10; /* Control Descriptor Layer 10 Register */
  uint8_t LAYER_reserved1[24];
} DCU_LAYER_tag;

struct DCU_tag {
  DCU_CTRLDESCCURSOR1_tag CTRLDESCCURSOR1; /* Control Descriptor Cursor 1 Register */
  DCU_CTRLDESCCURSOR2_tag CTRLDESCCURSOR2; /* Control Descriptor Cursor 2 Register */
  DCU_CTRLDESCCURSOR3_tag CTRLDESCCURSOR3; /* Control Descriptor Cursor 3 Register */
  uint8_t DCU_reserved0[4];
  DCU_MODE_tag MODE;                   /* Mode Register */
  DCU_BGND_tag BGND;                   /* Background Register */
  DCU_DISP_SIZE_tag DISP_SIZE;         /* Display Size Register */
  DCU_HSYN_PARA_tag HSYN_PARA;         /* Horizontal Sync Parameter Register */
  DCU_VSYN_PARA_tag VSYN_PARA;         /* Vertical Sync Parameter Register */
  DCU_SYNPOL_tag SYNPOL;               /* Synchronize Polarity Register */
  DCU_THRESHOLD_tag THRESHOLD;         /* Threshold Register */
  DCU_INT_STATUS_tag INT_STATUS;       /* Interrupt Status Register */
  DCU_INT_MASK_tag INT_MASK;           /* Interrupt Mask Register */
  DCU_COLBAR_1_tag COLBAR_1;           /* COLBAR_1 Register */
  DCU_COLBAR_2_tag COLBAR_2;           /* COLBAR_2 Register */
  DCU_COLBAR_3_tag COLBAR_3;           /* COLBAR_3 Register */
  DCU_COLBAR_4_tag COLBAR_4;           /* COLBAR_4 Register */
  DCU_COLBAR_5_tag COLBAR_5;           /* COLBAR_5 Register */
  DCU_COLBAR_6_tag COLBAR_6;           /* COLBAR_6 Register */
  DCU_COLBAR_7_tag COLBAR_7;           /* COLBAR_7 Register */
  DCU_COLBAR_8_tag COLBAR_8;           /* COLBAR_8 Register */
  DCU_DIV_RATIO_tag DIV_RATIO;         /* Divide Ratio Register */
  DCU_SIGN_CALC_1_tag SIGN_CALC_1;     /* Sign Calculation 1 Register */
  DCU_SIGN_CALC_2_tag SIGN_CALC_2;     /* Sign Calculation 2 Register */
  DCU_CRC_VAL_tag CRC_VAL;             /* CRC Value Register */
  uint8_t DCU_reserved1[8];
  DCU_PARR_ERR_STATUS1_tag PARR_ERR_STATUS1; /* Parameter Error Status 1 Register */
  uint8_t DCU_reserved2[12];
  DCU_PARR_ERR_STATUS3_tag PARR_ERR_STATUS3; /* Parameter Error Status 3 Register */
  DCU_MASK_PARR_ERR_STATUS1_tag MASK_PARR_ERR_STATUS1; /* Mask Parameter Error Status 1 Register */
  uint8_t DCU_reserved3[12];
  DCU_MASK_PARR_ERR_STATUS3_tag MASK_PARR_ERR_STATUS3; /* Mask Parameter Error Status 3 Register */
  DCU_THRESHOLD_INP_BUF_1_tag THRESHOLD_INP_BUF_1; /* Threshold Input 1 Register */
  uint8_t DCU_reserved4[8];
  DCU_LUMA_COMP_tag LUMA_COMP;         /* LUMA Component Register */
  DCU_CHROMA_RED_tag CHROMA_RED;       /* Red Chroma Components Register */
  DCU_CHROMA_GREEN_tag CHROMA_GREEN;   /* Green Chroma Components Register */
  DCU_CHROMA_BLUE_tag CHROMA_BLUE;     /* Blue Chroma Components Register */
  DCU_CRC_POS_tag CRC_POS;             /* CRC Position Register */
  DCU_LYR_INTPOL_EN_tag LYR_INTPOL_EN; /* Layer Interpolation Enable Register */
  DCU_LYR_LUMA_COMP_tag LYR_LUMA_COMP; /* Layer Luminance Component Register */
  DCU_LYR_CHRM_RED_tag LYR_CHRM_RED;   /* Layer Chroma Red Register */
  DCU_LYR_CHRM_GRN_tag LYR_CHRM_GRN;   /* Layer Chroma Green Register */
  DCU_LYR_CHRM_BLUE_tag LYR_CHRM_BLUE; /* Layer Chroma Blue Register */
  uint8_t DCU_reserved5[4];
  DCU_UPDATE_MODE_tag UPDATE_MODE;     /* Update Mode Register */
  DCU_UNDERRUN_tag UNDERRUN;           /* Underrun Register */
  uint8_t DCU_reserved6[12];
  DCU_FRM_CRC_CTRL_tag FRM_CRC_CTRL;   /* Frame CRC Control */
  DCU_FRM_CRC_VAL_tag FRM_CRC_VAL;     /* Frame CRC Value */
  DCU_TX_ESCAL_LVL_tag TX_ESCAL_LVL;   /* QoS Level */
  uint8_t DCU_reserved7[20];
  DCU_GPR_tag GPR;                     /* Global Protection Register */
  DCU_SLR_L0_tag SLR_L0;               /* Soft Lock Bit Layer 0 Register */
  DCU_SLR_L1_tag SLR_L1;               /* Soft Lock Bit Layer 1 Register */
  DCU_SLR_DISP_SIZE_tag SLR_DISP_SIZE; /* Soft Lock Display Size Register */
  DCU_SLR_HVSYNC_PARA_tag SLR_HVSYNC_PARA; /* Soft Lock Hsync/Vsync Parameter Register */
  DCU_SLR_POL_tag SLR_POL;             /* Soft Lock POL Register */
  DCU_SLR_L0_TRANSP_tag SLR_L0_TRANSP; /* Soft Lock L0 Transparency Register */
  DCU_SLR_L1_TRANSP_tag SLR_L1_TRANSP; /* Soft Lock L1 Transparency Register */
  uint8_t DCU_reserved8[224];
  DCU_LAYER_tag LAYER[8];
};


/* ============================================================================
   =============================== Module: DEC200 =============================
   ============================================================================ */

typedef union DEC200_gcregDECReadConfig_gcregDECReadConfig_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COMPRESSION_ENABLE:1;
    vuint32_t COMPRESSION_SIZE:2;
    vuint32_t COMPRESSION_FORMAT:4;
    vuint32_t _unused_7:13;
    vuint32_t SWIZZLE:2;
    vuint32_t _unused_22:10;
  } B;
} DEC200_gcregDECReadConfig_gcregDECReadConfig_tag;

typedef struct DEC200_gcregDECReadConfig_struct_tag {
  DEC200_gcregDECReadConfig_gcregDECReadConfig_tag gcregDECReadConfig;
  uint16_t gcregDECReadConfig_reserved0[1];
} DEC200_gcregDECReadConfig_tag;

typedef union DEC200_gcregDECWriteConfig_gcregDECWriteConfig_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COMPRESSION_ENABLE:1;
    vuint32_t COMPRESSION_SIZE:2;
    vuint32_t COMPRESSION_FORMAT:4;
    vuint32_t _unused_7:13;
    vuint32_t SWIZZLE:2;
    vuint32_t _unused_22:10;
  } B;
} DEC200_gcregDECWriteConfig_gcregDECWriteConfig_tag;

typedef struct DEC200_gcregDECWriteConfig_struct_tag {
  DEC200_gcregDECWriteConfig_gcregDECWriteConfig_tag gcregDECWriteConfig;
  uint16_t gcregDECWriteConfig_reserved0[1];
} DEC200_gcregDECWriteConfig_tag;

typedef union DEC200_gcregDECReadBufferBase_gcregDECReadBufferBase_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} DEC200_gcregDECReadBufferBase_gcregDECReadBufferBase_tag;

typedef struct DEC200_gcregDECReadBufferBase_struct_tag {
  DEC200_gcregDECReadBufferBase_gcregDECReadBufferBase_tag gcregDECReadBufferBase;
  uint16_t gcregDECReadBufferBase_reserved0[1];
} DEC200_gcregDECReadBufferBase_tag;

typedef union DEC200_gcregDECReadCacheBase_gcregDECReadCacheBase_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} DEC200_gcregDECReadCacheBase_gcregDECReadCacheBase_tag;

typedef struct DEC200_gcregDECReadCacheBase_struct_tag {
  DEC200_gcregDECReadCacheBase_gcregDECReadCacheBase_tag gcregDECReadCacheBase;
  uint16_t gcregDECReadCacheBase_reserved0[1];
} DEC200_gcregDECReadCacheBase_tag;

typedef union DEC200_gcregDECWriteBufferBase_gcregDECWriteBufferBase_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} DEC200_gcregDECWriteBufferBase_gcregDECWriteBufferBase_tag;

typedef struct DEC200_gcregDECWriteBufferBase_struct_tag {
  DEC200_gcregDECWriteBufferBase_gcregDECWriteBufferBase_tag gcregDECWriteBufferBase;
  uint16_t gcregDECWriteBufferBase_reserved0[1];
} DEC200_gcregDECWriteBufferBase_tag;

typedef union DEC200_gcregDECWriteCacheBase_gcregDECWriteCacheBase_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} DEC200_gcregDECWriteCacheBase_gcregDECWriteCacheBase_tag;

typedef struct DEC200_gcregDECWriteCacheBase_struct_tag {
  DEC200_gcregDECWriteCacheBase_gcregDECWriteCacheBase_tag gcregDECWriteCacheBase;
  uint16_t gcregDECWriteCacheBase_reserved0[1];
} DEC200_gcregDECWriteCacheBase_tag;

typedef union DEC200_gcregDECControl_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FLUSH:1;
    vuint32_t DISABLE_COMPRESSION:1;
    vuint32_t DISABLE_RAM_CLOCK_GATING:1;
    vuint32_t DISABLE_DEBUG_REGISTERS:1;
    vuint32_t SOFT_RESET:1;
    vuint32_t _unused_5:1;
    vuint32_t ENABLE_WRITE_SYNC:1;
    vuint32_t ENABLE96_BYTE_YUV_COMP:1;
    vuint32_t TILE_STATUS_READ_ID:4;
    vuint32_t TILE_STATUS_WRITE_ID:4;
    vuint32_t DISABLE_HW_FLUSH:1;
    vuint32_t CLK_DIS:1;
    vuint32_t SW_FLUSH_ID:4;
    vuint32_t _unused_22:10;
  } B;
} DEC200_gcregDECControl_tag;

typedef union DEC200_gcregDECIntrAcknowledge_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:30;
    vuint32_t AXI_ERR_INT:1;
    vuint32_t FLUSH_DN_INT:1;
  } B;
} DEC200_gcregDECIntrAcknowledge_tag;

typedef union DEC200_gcregDECIntrEnbl_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:30;
    vuint32_t AXI_ERR_INT_ENBL:1;
    vuint32_t FLUSH_DN_INT_ENBL:1;
  } B;
} DEC200_gcregDECIntrEnbl_tag;

typedef union DEC200_gcDECTotalReadsIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadsIn_tag;

typedef union DEC200_gcDECTotalWritesIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWritesIn_tag;

typedef union DEC200_gcDECTotalReadBurstsIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadBurstsIn_tag;

typedef union DEC200_gcDECTotalWriteBurstsIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWriteBurstsIn_tag;

typedef union DEC200_gcDECTotalReadsReqIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadsReqIn_tag;

typedef union DEC200_gcDECTotalWritesReqIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWritesReqIn_tag;

typedef union DEC200_gcDECTotalReadLastsIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadLastsIn_tag;

typedef union DEC200_gcDECTotalWriteLastsIn_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWriteLastsIn_tag;

typedef union DEC200_gcDECTotalReadsOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadsOUT_tag;

typedef union DEC200_gcDECTotalWritesOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWritesOUT_tag;

typedef union DEC200_gcDECTotalReadBurstsOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadBurstsOUT_tag;

typedef union DEC200_gcDECTotalWriteBurstsOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWriteBurstsOUT_tag;

typedef union DEC200_gcDECTotalReadsReqOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadsReqOUT_tag;

typedef union DEC200_gcDECTotalWritesReqOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWritesReqOUT_tag;

typedef union DEC200_gcDECTotalReadLastsOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalReadLastsOUT_tag;

typedef union DEC200_gcDECTotalWriteLastsOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;
  } B;
} DEC200_gcDECTotalWriteLastsOUT_tag;

struct DEC200_tag {
  uint16_t DEC200_reserved0[2048];
  DEC200_gcregDECReadConfig_tag gcregDECReadConfig[8];
  uint16_t DEC200_reserved1[32];
  DEC200_gcregDECWriteConfig_tag gcregDECWriteConfig[8];
  uint16_t DEC200_reserved2[32];
  DEC200_gcregDECReadBufferBase_tag gcregDECReadBufferBase[8];
  uint16_t DEC200_reserved3[32];
  DEC200_gcregDECReadCacheBase_tag gcregDECReadCacheBase[8];
  uint16_t DEC200_reserved4[32];
  DEC200_gcregDECWriteBufferBase_tag gcregDECWriteBufferBase[8];
  uint16_t DEC200_reserved5[32];
  DEC200_gcregDECWriteCacheBase_tag gcregDECWriteCacheBase[8];
  uint16_t DEC200_reserved6[32];
  DEC200_gcregDECControl_tag gcregDECControl;
  uint16_t DEC200_reserved7[2];
  DEC200_gcregDECIntrAcknowledge_tag gcregDECIntrAcknowledge;
  uint16_t DEC200_reserved8[2];
  DEC200_gcregDECIntrEnbl_tag gcregDECIntrEnbl;
  uint16_t DEC200_reserved9[14];
  DEC200_gcDECTotalReadsIn_tag gcDECTotalReadsIn;
  uint16_t DEC200_reserved10[2];
  DEC200_gcDECTotalWritesIn_tag gcDECTotalWritesIn;
  uint16_t DEC200_reserved11[2];
  DEC200_gcDECTotalReadBurstsIn_tag gcDECTotalReadBurstsIn;
  uint16_t DEC200_reserved12[2];
  DEC200_gcDECTotalWriteBurstsIn_tag gcDECTotalWriteBurstsIn;
  uint16_t DEC200_reserved13[2];
  DEC200_gcDECTotalReadsReqIn_tag gcDECTotalReadsReqIn;
  uint16_t DEC200_reserved14[2];
  DEC200_gcDECTotalWritesReqIn_tag gcDECTotalWritesReqIn;
  uint16_t DEC200_reserved15[2];
  DEC200_gcDECTotalReadLastsIn_tag gcDECTotalReadLastsIn;
  uint16_t DEC200_reserved16[2];
  DEC200_gcDECTotalWriteLastsIn_tag gcDECTotalWriteLastsIn;
  uint16_t DEC200_reserved17[2];
  DEC200_gcDECTotalReadsOUT_tag gcDECTotalReadsOUT;
  uint16_t DEC200_reserved18[2];
  DEC200_gcDECTotalWritesOUT_tag gcDECTotalWritesOUT;
  uint16_t DEC200_reserved19[2];
  DEC200_gcDECTotalReadBurstsOUT_tag gcDECTotalReadBurstsOUT;
  uint16_t DEC200_reserved20[2];
  DEC200_gcDECTotalWriteBurstsOUT_tag gcDECTotalWriteBurstsOUT;
  uint16_t DEC200_reserved21[2];
  DEC200_gcDECTotalReadsReqOUT_tag gcDECTotalReadsReqOUT;
  uint16_t DEC200_reserved22[2];
  DEC200_gcDECTotalWritesReqOUT_tag gcDECTotalWritesReqOUT;
  uint16_t DEC200_reserved23[2];
  DEC200_gcDECTotalReadLastsOUT_tag gcDECTotalReadLastsOUT;
  uint16_t DEC200_reserved24[2];
  DEC200_gcDECTotalWriteLastsOUT_tag gcDECTotalWriteLastsOUT;
};


/* ============================================================================
   =============================== Module: DFS ================================
   ============================================================================ */

typedef union DFS_DLLPRG1_union_tag {  /* DFS DLL Program Register 1 */
  vuint32_t R;
  struct {
    vuint32_t V2IGC:3;
    vuint32_t _unused_3:1;
    vuint32_t LCKWT:2;
    vuint32_t DACIN:3;
    vuint32_t CALBYPEN:1;
    vuint32_t VSETTLCTRL:2;
    vuint32_t CPICTRL:3;
    vuint32_t _unused_15:17;
  } B;
} DFS_DLLPRG1_tag;

typedef union DFS_CLKOUTEN_union_tag { /* DFS Clockout Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CLKOUTEN:4;
    vuint32_t _unused_4:28;
  } B;
} DFS_CLKOUTEN_tag;

typedef union DFS_PORTSR_union_tag {   /* DFS Port Status Register */
  vuint32_t R;
  struct {
    vuint32_t PORTSTAT:4;
    vuint32_t _unused_4:28;
  } B;
} DFS_PORTSR_tag;

typedef union DFS_PORTLOLSR_union_tag { /* DFS Port Loss of Lock Status Register */
  vuint32_t R;
  struct {
    vuint32_t LOLF:4;
    vuint32_t _unused_4:28;
  } B;
} DFS_PORTLOLSR_tag;

typedef union DFS_PORTRESET_union_tag { /* DFS Port Reset register */
  vuint32_t R;
  struct {
    vuint32_t PORTRESET:4;
    vuint32_t _unused_4:28;
  } B;
} DFS_PORTRESET_tag;

typedef union DFS_CTRL_union_tag {     /* DFS Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOLIE:1;
    vuint32_t DLL_RESET:1;
    vuint32_t _unused_2:30;
  } B;
} DFS_CTRL_tag;

typedef union DFS_DVPORT_union_tag {   /* DFS Divide Register Portn */
  vuint32_t R;
  struct {
    vuint32_t MFN:8;
    vuint32_t MFI:8;
    vuint32_t _unused_16:16;
  } B;
} DFS_DVPORT_tag;

struct DFS_tag {
  DFS_DLLPRG1_tag DLLPRG1;             /* DFS DLL Program Register 1 */
  uint8_t DFS_reserved0[4];
  DFS_CLKOUTEN_tag CLKOUTEN;           /* DFS Clockout Enable Register */
  DFS_PORTSR_tag PORTSR;               /* DFS Port Status Register */
  DFS_PORTLOLSR_tag PORTLOLSR;         /* DFS Port Loss of Lock Status Register */
  DFS_PORTRESET_tag PORTRESET;         /* DFS Port Reset register */
  DFS_CTRL_tag CTRL;                   /* DFS Control Register */
  DFS_DVPORT_tag DVPORT[4];            /* DFS Divide Register Portn */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t GRP0PRI:1;               /* Channel Group 0 Priority */
    vuint32_t _unused_9:1;
    vuint32_t GRP1PRI:1;               /* Channel Group 1 Priority */
    vuint32_t _unused_11:5;
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t _unused_18:14;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t DBE:1;                   /* Destination Bus Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t ERRCHN:5;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t _unused_13:1;
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t _unused_18:13;
    vuint32_t VLD:1;
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
  } B;
} DMA_EEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t CEEI:5;                   /* Clear Enable Error Interrupt */
    vuint8_t _unused_5:1;
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CEEI_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SEEI:5;                   /* Set Enable Error Interrupt */
    vuint8_t _unused_5:1;
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t CERQ:5;                   /* Clear Enable Request */
    vuint8_t _unused_5:1;
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t SERQ:5;                   /* Set Enable Request */
    vuint8_t _unused_5:1;
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t CDNE:5;                   /* Clear DONE Bit */
    vuint8_t _unused_5:1;
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CDNE_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t SSRT:5;                   /* Set START Bit */
    vuint8_t _unused_5:1;
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t CERR:5;                   /* Clear Error Indicator */
    vuint8_t _unused_5:1;
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CERR_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t CINT:5;                   /* Clear Interrupt Request */
    vuint8_t _unused_5:1;
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CINT_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
  } B;
} DMA_HRS_tag;

typedef union DMA_GPOR_union_tag {     /* General-Purpose Output Register */
  vuint32_t R;
  struct {
    vuint32_t GPOR:32;                 /* General-purpose output */
  } B;
} DMA_GPOR_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t SMOD:5;                  /* Source Address Modulo */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:15;                /* Current Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
    vuint16_t LINKCH:5;                /* Minor Loop Link Channel Number */
    vuint16_t _unused_14:1;
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t START:1;                 /* Channel Start */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t MAJORLINKCH:5;           /* Major Loop Link Channel Number */
    vuint16_t _unused_13:1;
    vuint16_t BWC:2;                   /* Bandwidth Control */
  } B;
} DMA_TCD_CSR_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:9;                 /* Starting major iteration count */
    vuint16_t LINKCH:5;                /* Link Channel Number */
    vuint16_t _unused_14:1;
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
  DMA_TCD_BITER_tag BITER;
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  DMA_GPOR_tag GPOR[2];                /* General-Purpose Output Register */
  uint8_t DMA_reserved5[192];
  DMA_DCHPRI_tag DCHPRI[32];           /* Channel n Priority Register */
  uint8_t DMA_reserved6[32];
  DMA_DCHMID_tag DCHMID[32];           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3744];
  DMA_TCD_tag TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:19;
    vuint32_t EICH12EN:1;              /* Error Injection Channel 12 Enable */
    vuint32_t EICH11EN:1;              /* Error Injection Channel 11 Enable */
    vuint32_t EICH10EN:1;              /* Error Injection Channel 10 Enable */
    vuint32_t EICH9EN:1;               /* Error Injection Channel 9 Enable */
    vuint32_t EICH8EN:1;               /* Error Injection Channel 8 Enable */
    vuint32_t EICH7EN:1;               /* Error Injection Channel 7 Enable */
    vuint32_t EICH6EN:1;               /* Error Injection Channel 6 Enable */
    vuint32_t EICH5EN:1;               /* Error Injection Channel 5 Enable */
    vuint32_t EICH4EN:1;               /* Error Injection Channel 4 Enable */
    vuint32_t EICH3EN:1;               /* Error Injection Channel 3 Enable */
    vuint32_t EICH2EN:1;               /* Error Injection Channel 2 Enable */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t CHKBIT_MASK:20;          /* Checkbit Mask */
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

typedef struct EIM_EICHD_struct_tag {
  EIM_EICHD_WORD0_tag WORD0;           /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag WORD1;           /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag WORD2;           /* Error Injection Channel Descriptor, Word2 */
  uint8_t EICHD_reserved0[244];
} EIM_EICHD_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_tag EICHD[13];
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

typedef union ENET_EIR_union_tag {     /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t _unused_8:1;
    vuint32_t PARSRF:1;
    vuint32_t PARSERR:1;
    vuint32_t _unused_11:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_2:1;
    vuint32_t TS_TIMER:1;              /* Timestamp Timer */
    vuint32_t TS_AVAIL:1;              /* Transmit Timestamp Available */
    vuint32_t WAKEUP:1;                /* Node Wakeup Request Indication */
    vuint32_t PLR:1;                   /* Payload Receive Error */
    vuint32_t UN:1;                    /* Transmit FIFO Underrun */
    vuint32_t RL:1;                    /* Collision Retry Limit */
    vuint32_t LC:1;                    /* Late Collision */
    vuint32_t EBERR:1;                 /* Ethernet Bus Error */
    vuint32_t MII:1;                   /* MII Interrupt. */
    vuint32_t RXB:1;                   /* Receive Buffer Interrupt */
    vuint32_t RXF:1;                   /* Receive Frame Interrupt */
    vuint32_t TXB:1;                   /* Transmit Buffer Interrupt */
    vuint32_t TXF:1;                   /* Transmit Frame Interrupt */
    vuint32_t GRA:1;                   /* Graceful Stop Complete */
    vuint32_t BABT:1;                  /* Babbling Transmit Error */
    vuint32_t BABR:1;                  /* Babbling Receive Error */
    vuint32_t _unused_31:1;
  } B;
} ENET_EIR_tag;

typedef union ENET_EIMR_union_tag {    /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t _unused_8:1;
    vuint32_t PARSRF:1;
    vuint32_t PARSERR:1;
    vuint32_t _unused_11:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_2:1;
    vuint32_t TS_TIMER:1;              /* TS_TIMER Interrupt Mask */
    vuint32_t TS_AVAIL:1;              /* TS_AVAIL Interrupt Mask */
    vuint32_t WAKEUP:1;                /* WAKEUP Interrupt Mask */
    vuint32_t PLR:1;                   /* PLR Interrupt Mask */
    vuint32_t UN:1;                    /* UN Interrupt Mask */
    vuint32_t RL:1;                    /* RL Interrupt Mask */
    vuint32_t LC:1;                    /* LC Interrupt Mask */
    vuint32_t EBERR:1;                 /* EBERR Interrupt Mask */
    vuint32_t MII:1;                   /* MII Interrupt Mask */
    vuint32_t RXB:1;                   /* RXB Interrupt Mask */
    vuint32_t RXF:1;                   /* RXF Interrupt Mask */
    vuint32_t TXB:1;                   /* TXB Interrupt Mask */
    vuint32_t TXF:1;                   /* TXF Interrupt Mask */
    vuint32_t GRA:1;                   /* GRA Interrupt Mask */
    vuint32_t BABT:1;                  /* BABT Interrupt Mask */
    vuint32_t BABR:1;                  /* BABR Interrupt Mask */
    vuint32_t _unused_31:1;
  } B;
} ENET_EIMR_tag;

typedef union ENET_RDAR_union_tag {    /* Receive Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR_tag;

typedef union ENET_TDAR_union_tag {    /* Transmit Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR_tag;

typedef union ENET_ECR_union_tag {     /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t RESET:1;                 /* Ethernet MAC Reset */
    vuint32_t ETHEREN:1;               /* Ethernet Enable */
    vuint32_t MAGICEN:1;               /* Magic Packet Detection Enable */
    vuint32_t SLEEP:1;                 /* Sleep Mode Enable */
    vuint32_t EN1588:1;                /* EN1588 Enable */
    vuint32_t SPEED:1;
    vuint32_t DBGEN:1;                 /* Debug Enable */
    vuint32_t _unused_7:1;
    vuint32_t DBSWP:1;                 /* Descriptor Byte Swapping Enable */
    vuint32_t SVLANEN:1;               /* S-VLAN enable */
    vuint32_t VLANUSE2ND:1;            /* VLAN use second tag */
    vuint32_t SVLANDBL:1;              /* S-VLAN double tag */
    vuint32_t _unused_12:4;
    vuint32_t TXC_DLY:1;               /* Transmit clock delay */
    vuint32_t RXC_DLY:1;               /* Receive clock delay */
    vuint32_t _unused_18:14;
  } B;
} ENET_ECR_tag;

typedef union ENET_MMFR_union_tag {    /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:16;                 /* Management Frame Data */
    vuint32_t TA:2;                    /* Turn Around */
    vuint32_t RA:5;                    /* Register Address */
    vuint32_t PA:5;                    /* PHY Address */
    vuint32_t OP:2;                    /* Operation Code */
    vuint32_t ST:2;                    /* Start Of Frame Delimiter */
  } B;
} ENET_MMFR_tag;

typedef union ENET_MSCR_union_tag {    /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t MII_SPEED:6;             /* MII Speed */
    vuint32_t DIS_PRE:1;               /* Disable Preamble */
    vuint32_t HOLDTIME:3;              /* Hold time On MDIO Output */
    vuint32_t _unused_11:21;
  } B;
} ENET_MSCR_tag;

typedef union ENET_MIBC_union_tag {    /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t MIB_CLEAR:1;             /* MIB Clear */
    vuint32_t MIB_IDLE:1;              /* MIB Idle */
    vuint32_t MIB_DIS:1;               /* Disable MIB Logic */
  } B;
} ENET_MIBC_tag;

typedef union ENET_RCR_union_tag {     /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* Internal Loopback */
    vuint32_t DRT:1;                   /* Disable Receive On Transmit */
    vuint32_t MII_MODE:1;              /* Media Independent Interface Mode */
    vuint32_t PROM:1;                  /* Promiscuous Mode */
    vuint32_t BC_REJ:1;                /* Broadcast Frame Reject */
    vuint32_t FCE:1;                   /* Flow Control Enable */
    vuint32_t RGMII_EN:1;              /* RGMII Mode Enable */
    vuint32_t _unused_7:1;
    vuint32_t RMII_MODE:1;             /* RMII Mode Enable */
    vuint32_t RMII_10T:1;
    vuint32_t _unused_10:2;
    vuint32_t PADEN:1;                 /* Enable Frame Padding Remove On Receive */
    vuint32_t PAUFWD:1;                /* Terminate/Forward Pause Frames */
    vuint32_t CRCFWD:1;                /* Terminate/Forward Received CRC */
    vuint32_t CFEN:1;                  /* MAC Control Frame Enable */
    vuint32_t MAX_FL:14;               /* Maximum Frame Length */
    vuint32_t NLC:1;                   /* Payload Length Check Disable */
    vuint32_t GRS:1;                   /* Graceful Receive Stopped */
  } B;
} ENET_RCR_tag;

typedef union ENET_TCR_union_tag {     /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t GTS:1;                   /* Graceful Transmit Stop */
    vuint32_t _unused_1:1;
    vuint32_t FDEN:1;                  /* Full-Duplex Enable */
    vuint32_t TFC_PAUSE:1;             /* Transmit Frame Control Pause */
    vuint32_t RFC_PAUSE:1;             /* Receive Frame Control Pause */
    vuint32_t ADDSEL:3;                /* Source MAC Address Select On Transmit */
    vuint32_t ADDINS:1;                /* Set MAC Address On Transmit */
    vuint32_t CRCFWD:1;                /* Forward Frame From Application With CRC */
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:21;
  } B;
} ENET_TCR_tag;

typedef union ENET_PALR_union_tag {    /* Physical Address Lower Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;               /* Pause Address */
  } B;
} ENET_PALR_tag;

typedef union ENET_PAUR_union_tag {    /* Physical Address Upper Register */
  vuint32_t R;
  struct {
    vuint32_t TYPE:16;                 /* Type Field In PAUSE Frames */
    vuint32_t PADDR2:16;
  } B;
} ENET_PAUR_tag;

typedef union ENET_OPD_union_tag {     /* Opcode/Pause Duration Register */
  vuint32_t R;
  struct {
    vuint32_t PAUSE_DUR:16;            /* Pause Duration */
    vuint32_t OPCODE:16;               /* Opcode Field In PAUSE Frames */
  } B;
} ENET_OPD_tag;

typedef union ENET_TXIC_union_tag {    /* Transmit Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
  } B;
} ENET_TXIC_tag;

typedef union ENET_RXIC_union_tag {    /* Receive Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
  } B;
} ENET_RXIC_tag;

typedef union ENET_IAUR_union_tag {    /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} ENET_IAUR_tag;

typedef union ENET_IALR_union_tag {    /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} ENET_IALR_tag;

typedef union ENET_GAUR_union_tag {    /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} ENET_GAUR_tag;

typedef union ENET_GALR_union_tag {    /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} ENET_GALR_tag;

typedef union ENET_TFWR_union_tag {    /* Transmit FIFO Watermark Register */
  vuint32_t R;
  struct {
    vuint32_t TFWR:6;                  /* Transmit FIFO Write */
    vuint32_t _unused_6:2;
    vuint32_t STRFWD:1;                /* Store And Forward Enable */
    vuint32_t _unused_9:23;
  } B;
} ENET_TFWR_tag;

typedef union ENET_RDSR1_union_tag {   /* Receive Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR1_tag;

typedef union ENET_TDSR1_union_tag {   /* Transmit Buffer Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR1_tag;

typedef union ENET_MRBR1_union_tag {   /* Maximum Receive Buffer Size Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:10;
    vuint32_t _unused_14:18;
  } B;
} ENET_MRBR1_tag;

typedef union ENET_RDSR2_union_tag {   /* Receive Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR2_tag;

typedef union ENET_TDSR2_union_tag {   /* Transmit Buffer Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR2_tag;

typedef union ENET_MRBR2_union_tag {   /* Maximum Receive Buffer Size Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:10;
    vuint32_t _unused_14:18;
  } B;
} ENET_MRBR2_tag;

typedef union ENET_RDSR_union_tag {    /* Receive Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR_tag;

typedef union ENET_TDSR_union_tag {    /* Transmit Buffer Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR_tag;

typedef union ENET_MRBR_union_tag {    /* Maximum Receive Buffer Size Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:10;
    vuint32_t _unused_14:18;
  } B;
} ENET_MRBR_tag;

typedef union ENET_RSFL_union_tag {    /* Receive FIFO Section Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_SECTION_FULL:10;      /* Value Of Receive FIFO Section Full Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_RSFL_tag;

typedef union ENET_RSEM_union_tag {    /* Receive FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_SECTION_EMPTY:10;     /* Value Of The Receive FIFO Section Empty Threshold */
    vuint32_t _unused_10:6;
    vuint32_t STAT_SECTION_EMPTY:5;    /* RX Status FIFO Section Empty Threshold */
    vuint32_t _unused_21:11;
  } B;
} ENET_RSEM_tag;

typedef union ENET_RAEM_union_tag {    /* Receive FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_ALMOST_EMPTY:10;      /* Value Of The Receive FIFO Almost Empty Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_RAEM_tag;

typedef union ENET_RAFL_union_tag {    /* Receive FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_ALMOST_FULL:10;       /* Value Of The Receive FIFO Almost Full Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_RAFL_tag;

typedef union ENET_TSEM_union_tag {    /* Transmit FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_SECTION_EMPTY:10;     /* Value Of The Transmit FIFO Section Empty Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_TSEM_tag;

typedef union ENET_TAEM_union_tag {    /* Transmit FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_ALMOST_EMPTY:10;      /* Value of Transmit FIFO Almost Empty Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_TAEM_tag;

typedef union ENET_TAFL_union_tag {    /* Transmit FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_ALMOST_FULL:10;       /* Value Of The Transmit FIFO Almost Full Threshold */
    vuint32_t _unused_10:22;
  } B;
} ENET_TAFL_tag;

typedef union ENET_TIPG_union_tag {    /* Transmit Inter-Packet Gap */
  vuint32_t R;
  struct {
    vuint32_t IPG:5;                   /* Transmit Inter-Packet Gap */
    vuint32_t _unused_5:27;
  } B;
} ENET_TIPG_tag;

typedef union ENET_FTRL_union_tag {    /* Frame Truncation Length */
  vuint32_t R;
  struct {
    vuint32_t TRUNC_FL:14;             /* Frame Truncation Length */
    vuint32_t _unused_14:18;
  } B;
} ENET_FTRL_tag;

typedef union ENET_TACC_union_tag {    /* Transmit Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t SHIFT16:1;               /* TX FIFO Shift-16 */
    vuint32_t _unused_1:2;
    vuint32_t IPCHK:1;
    vuint32_t PROCHK:1;
    vuint32_t _unused_5:27;
  } B;
} ENET_TACC_tag;

typedef union ENET_RACC_union_tag {    /* Receive Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t PADREM:1;                /* Enable Padding Removal For Short IP Frames */
    vuint32_t IPDIS:1;                 /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
    vuint32_t PRODIS:1;                /* Enable Discard Of Frames With Wrong Protocol Checksum */
    vuint32_t _unused_3:3;
    vuint32_t LINEDIS:1;               /* Enable Discard Of Frames With MAC Layer Errors */
    vuint32_t SHIFT16:1;               /* RX FIFO Shift-16 */
    vuint32_t _unused_8:24;
  } B;
} ENET_RACC_tag;

typedef union ENET_RCMR_union_tag {    /* Receive Classification Match Register for Class n */
  vuint32_t R;
  struct {
    vuint32_t CMP0:3;                  /* Compare 0 */
    vuint32_t _unused_3:1;
    vuint32_t CMP1:3;                  /* Compare 1 */
    vuint32_t _unused_7:1;
    vuint32_t CMP2:3;                  /* Compare 2 */
    vuint32_t _unused_11:1;
    vuint32_t CMP3:3;                  /* Compare 3 */
    vuint32_t _unused_15:1;
    vuint32_t MATCHEN:1;               /* Match Enable */
    vuint32_t _unused_17:15;
  } B;
} ENET_RCMR_tag;

typedef union ENET_DMACFG_union_tag {  /* DMA Class Based Configuration */
  vuint32_t R;
  struct {
    vuint32_t IDLE_SLOPE:16;           /* Idle slope */
    vuint32_t DMA_CLASS_EN:1;          /* DMA class enable */
    vuint32_t CALC_NOIPG:1;            /* Calculate no IPG */
    vuint32_t _unused_18:6;
    vuint32_t _unused_24:8;
  } B;
} ENET_DMACFG_tag;

typedef union ENET_RDAR1_union_tag {   /* Receive Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR1_tag;

typedef union ENET_TDAR1_union_tag {   /* Transmit Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR1_tag;

typedef union ENET_RDAR2_union_tag {   /* Receive Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR2_tag;

typedef union ENET_TDAR2_union_tag {   /* Transmit Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR2_tag;

typedef union ENET_QOS_union_tag {     /* QOS Scheme */
  vuint32_t R;
  struct {
    vuint32_t TX_SCHEME:3;             /* TX scheme configuration */
    vuint32_t RX_FLUSH0:1;             /* RX Flush Ring 0 */
    vuint32_t RX_FLUSH1:1;             /* RX Flush Ring 1 */
    vuint32_t RX_FLUSH2:1;             /* RX Flush Ring 2 */
    vuint32_t _unused_6:26;
  } B;
} ENET_QOS_tag;

typedef union ENET_RMON_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_RMON_T_DROP_tag;

typedef union ENET_RMON_T_PACKETS_union_tag { /* Tx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Packet count */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_PACKETS_tag;

typedef union ENET_RMON_T_BC_PKT_union_tag { /* Tx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Broadcast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_BC_PKT_tag;

typedef union ENET_RMON_T_MC_PKT_union_tag { /* Tx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Multicast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_MC_PKT_tag;

typedef union ENET_RMON_T_CRC_ALIGN_union_tag { /* Tx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Packets with CRC/align error */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_CRC_ALIGN_tag;

typedef union ENET_RMON_T_UNDERSIZE_union_tag { /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_UNDERSIZE_tag;

typedef union ENET_RMON_T_OVERSIZE_union_tag { /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_OVERSIZE_tag;

typedef union ENET_RMON_T_FRAG_union_tag { /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_FRAG_tag;

typedef union ENET_RMON_T_JAB_union_tag { /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_JAB_tag;

typedef union ENET_RMON_T_COL_union_tag { /* Tx Collision Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_COL_tag;

typedef union ENET_RMON_T_P64_union_tag { /* Tx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 64-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P64_tag;

typedef union ENET_RMON_T_P65TO127_union_tag { /* Tx 65- to 127-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P65TO127_tag;

typedef union ENET_RMON_T_P128TO255_union_tag { /* Tx 128- to 255-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P128TO255_tag;

typedef union ENET_RMON_T_P256TO511_union_tag { /* Tx 256- to 511-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P256TO511_tag;

typedef union ENET_RMON_T_P512TO1023_union_tag { /* Tx 512- to 1023-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P512TO1023_tag;

typedef union ENET_RMON_T_P1024TO2047_union_tag { /* Tx 1024- to 2047-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P1024TO2047_tag;

typedef union ENET_RMON_T_P_GTE2048_union_tag { /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P_GTE2048_tag;

typedef union ENET_RMON_T_OCTETS_union_tag { /* Tx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXOCTS:32;               /* Number of transmit octets */
  } B;
} ENET_RMON_T_OCTETS_tag;

typedef union ENET_IEEE_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_IEEE_T_DROP_tag;

typedef union ENET_IEEE_T_FRAME_OK_union_tag { /* Frames Transmitted OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted OK */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_FRAME_OK_tag;

typedef union ENET_IEEE_T_1COL_union_tag { /* Frames Transmitted with Single Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with one collision */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_1COL_tag;

typedef union ENET_IEEE_T_MCOL_union_tag { /* Frames Transmitted with Multiple Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with multiple collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_MCOL_tag;

typedef union ENET_IEEE_T_DEF_union_tag { /* Frames Transmitted after Deferral Delay Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with deferral delay */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_DEF_tag;

typedef union ENET_IEEE_T_LCOL_union_tag { /* Frames Transmitted with Late Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with late collision */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_LCOL_tag;

typedef union ENET_IEEE_T_EXCOL_union_tag { /* Frames Transmitted with Excessive Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with excessive collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_EXCOL_tag;

typedef union ENET_IEEE_T_MACERR_union_tag { /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_MACERR_tag;

typedef union ENET_IEEE_T_CSERR_union_tag { /* Frames Transmitted with Carrier Sense Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with carrier sense error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_CSERR_tag;

typedef union ENET_IEEE_T_SQE_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_SQE_tag;

typedef union ENET_IEEE_T_FDXFC_union_tag { /* Flow Control Pause Frames Transmitted Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of flow-control pause frames transmitted */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_FDXFC_tag;

typedef union ENET_IEEE_T_OCTETS_OK_union_tag { /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
  } B;
} ENET_IEEE_T_OCTETS_OK_tag;

typedef union ENET_RMON_R_PACKETS_union_tag { /* Rx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of packets received */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_PACKETS_tag;

typedef union ENET_RMON_R_BC_PKT_union_tag { /* Rx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive broadcast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_BC_PKT_tag;

typedef union ENET_RMON_R_MC_PKT_union_tag { /* Rx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive multicast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_MC_PKT_tag;

typedef union ENET_RMON_R_CRC_ALIGN_union_tag { /* Rx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with CRC or align error */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_CRC_ALIGN_tag;

typedef union ENET_RMON_R_UNDERSIZE_union_tag { /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_UNDERSIZE_tag;

typedef union ENET_RMON_R_OVERSIZE_union_tag { /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_OVERSIZE_tag;

typedef union ENET_RMON_R_FRAG_union_tag { /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_FRAG_tag;

typedef union ENET_RMON_R_JAB_union_tag { /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_JAB_tag;

typedef union ENET_RMON_R_RESVD_0_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_RESVD_0_tag;

typedef union ENET_RMON_R_P64_union_tag { /* Rx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 64-byte receive packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P64_tag;

typedef union ENET_RMON_R_P65TO127_union_tag { /* Rx 65- to 127-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P65TO127_tag;

typedef union ENET_RMON_R_P128TO255_union_tag { /* Rx 128- to 255-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P128TO255_tag;

typedef union ENET_RMON_R_P256TO511_union_tag { /* Rx 256- to 511-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P256TO511_tag;

typedef union ENET_RMON_R_P512TO1023_union_tag { /* Rx 512- to 1023-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P512TO1023_tag;

typedef union ENET_RMON_R_P1024TO2047_union_tag { /* Rx 1024- to 2047-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P1024TO2047_tag;

typedef union ENET_RMON_R_P_GTE2048_union_tag { /* Rx Packets Greater than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P_GTE2048_tag;

typedef union ENET_RMON_R_OCTETS_union_tag { /* Rx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of receive octets */
  } B;
} ENET_RMON_R_OCTETS_tag;

typedef union ENET_IEEE_R_DROP_union_tag { /* Frames not Counted Correctly Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Frame count */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_DROP_tag;

typedef union ENET_IEEE_R_FRAME_OK_union_tag { /* Frames Received OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received OK */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_FRAME_OK_tag;

typedef union ENET_IEEE_R_CRC_union_tag { /* Frames Received with CRC Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received with CRC error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_CRC_tag;

typedef union ENET_IEEE_R_ALIGN_union_tag { /* Frames Received with Alignment Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received with alignment error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_ALIGN_tag;

typedef union ENET_IEEE_R_MACERR_union_tag { /* Receive FIFO Overflow Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Receive FIFO overflow count */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_MACERR_tag;

typedef union ENET_IEEE_R_FDXFC_union_tag { /* Flow Control Pause Frames Received Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of flow-control pause frames received */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_FDXFC_tag;

typedef union ENET_IEEE_R_OCTETS_OK_union_tag { /* Octet Count for Frames Received without Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of octets for frames received without error */
  } B;
} ENET_IEEE_R_OCTETS_OK_tag;

typedef union ENET_ATCR_union_tag {    /* Adjustable Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t EN:1;                    /* Enable Timer */
    vuint32_t _unused_1:1;
    vuint32_t OFFEN:1;                 /* Enable One-Shot Offset Event */
    vuint32_t OFFRST:1;                /* Reset Timer On Offset Event */
    vuint32_t PEREN:1;                 /* Enable Periodical Event */
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t PINPER:1;
    vuint32_t _unused_8:1;
    vuint32_t RESTART:1;               /* Reset Timer */
    vuint32_t _unused_10:1;
    vuint32_t CAPTURE:1;               /* Capture Timer Value */
    vuint32_t _unused_12:1;
    vuint32_t SLAVE:1;                 /* Enable Timer Slave Mode */
    vuint32_t _unused_14:18;
  } B;
} ENET_ATCR_tag;

typedef union ENET_ATVR_union_tag {    /* Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t ATIME:32;
  } B;
} ENET_ATVR_tag;

typedef union ENET_ATOFF_union_tag {   /* Timer Offset Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:32;
  } B;
} ENET_ATOFF_tag;

typedef union ENET_ATPER_union_tag {   /* Timer Period Register */
  vuint32_t R;
  struct {
    vuint32_t PERIOD:32;
  } B;
} ENET_ATPER_tag;

typedef union ENET_ATCOR_union_tag {   /* Timer Correction Register */
  vuint32_t R;
  struct {
    vuint32_t COR:31;                  /* Correction Counter Wrap-Around Value */
    vuint32_t _unused_31:1;
  } B;
} ENET_ATCOR_tag;

typedef union ENET_ATINC_union_tag {   /* Time-Stamping Clock Period Register */
  vuint32_t R;
  struct {
    vuint32_t INC:7;                   /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
    vuint32_t _unused_7:1;
    vuint32_t INC_CORR:7;              /* Correction Increment Value */
    vuint32_t _unused_15:17;
  } B;
} ENET_ATINC_tag;

typedef union ENET_ATSTMP_union_tag {  /* Timestamp of Last Transmitted Frame */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:32;
  } B;
} ENET_ATSTMP_tag;

typedef union ENET_MDATA_union_tag {   /* Pattern Match Data Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHDATA:32;            /* Match Data */
  } B;
} ENET_MDATA_tag;

typedef union ENET_MMASK_union_tag {   /* Match Entry Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHMASK:32;            /* Match Mask */
  } B;
} ENET_MMASK_tag;

typedef union ENET_MCONFIG_union_tag { /* Match Entry Rules Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t FRMOFF:6;                /* Frame Offset */
    vuint32_t _unused_8:8;
    vuint32_t OK_INDEX:8;
    vuint32_t _unused_24:5;
    vuint32_t IM:1;                    /* Invert Match */
    vuint32_t RF:1;                    /* Reject Frame */
    vuint32_t AF:1;                    /* Accept Frame */
  } B;
} ENET_MCONFIG_tag;

typedef union ENET_MENTRYRW_union_tag { /* Match Entry Read/Write Command Register */
  vuint32_t R;
  struct {
    vuint32_t ENTRYADD:8;              /* Entry Address */
    vuint32_t WR:1;                    /* Entry write command */
    vuint32_t RD:1;                    /* Entry Read Command */
    vuint32_t _unused_10:22;
  } B;
} ENET_MENTRYRW_tag;

typedef union ENET_RXPCTL_union_tag {  /* Receive Parser Control Register */
  vuint32_t R;
  struct {
    vuint32_t ENPARSER:1;              /* Enable Receive Parser */
    vuint32_t INVBYTORD:1;             /* Inverse Frame Byte Order */
    vuint32_t _unused_2:2;
    vuint32_t PRSRSCLR:1;              /* Clear Parser Statistics Counter */
    vuint32_t _unused_5:3;
    vuint32_t MAXINDEX:8;              /* Maximum Index */
    vuint32_t ENDERRQ:8;               /* End Error Queue */
    vuint32_t ACPTEERR:1;              /* Accept End Error */
    vuint32_t _unused_25:7;
  } B;
} ENET_RXPCTL_tag;

typedef union ENET_MAXFRMOFF_union_tag { /* Maximum Frame Offset */
  vuint32_t R;
  struct {
    vuint32_t MXFRMOFF:6;              /* Max. Frame Offset */
    vuint32_t _unused_6:26;
  } B;
} ENET_MAXFRMOFF_tag;

typedef union ENET_RXPARST_union_tag { /* Receive Parser Status */
  vuint32_t R;
  struct {
    vuint32_t MXINDERR:1;              /* Maximum Index Error */
    vuint32_t TBLDPTERR:1;             /* Table Depth Error */
    vuint32_t NOMTCERR:1;              /* No Match Error */
    vuint32_t FMOFFERR:1;              /* Maximum Frame Offset Error */
    vuint32_t PRSENDERR:1;             /* Parser End Error */
    vuint32_t INVMAXIDX:1;             /* Invalid Value of MAXINDEX */
    vuint32_t _unused_6:2;
    vuint32_t RXPRSDN:1;               /* Receive Parser Done */
    vuint32_t _unused_9:23;
  } B;
} ENET_RXPARST_tag;

typedef union ENET_PARSDSCD_union_tag { /* Parser Discard Count */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PARSDSCD_tag;

typedef union ENET_PRSACPT0_union_tag { /* Parser Accept Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT0_tag;

typedef union ENET_PRSRJCT0_union_tag { /* Parser Reject Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT0_tag;

typedef union ENET_PRSACPT1_union_tag { /* Parser Accept Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT1_tag;

typedef union ENET_PRSRJCT1_union_tag { /* Parser Reject Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT1_tag;

typedef union ENET_PRSACPT2_union_tag { /* Parser Accept Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT2_tag;

typedef union ENET_PRSRJCT2_union_tag { /* Parser Reject Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT2_tag;

typedef union ENET_TGSR_union_tag {    /* Timer Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t TF0:1;                   /* Copy Of Timer Flag For Channel 0 */
    vuint32_t TF1:1;                   /* Copy Of Timer Flag For Channel 1 */
    vuint32_t TF2:1;                   /* Copy Of Timer Flag For Channel 2 */
    vuint32_t TF3:1;                   /* Copy Of Timer Flag For Channel 3 */
    vuint32_t _unused_4:28;
  } B;
} ENET_TGSR_tag;

typedef union ENET_CHANNEL_TCSR_union_tag { /* Timer Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t TDRE:1;                  /* Timer DMA Request Enable */
    vuint32_t _unused_1:1;
    vuint32_t TMODE:4;                 /* Timer Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TF:1;                    /* Timer Flag */
    vuint32_t _unused_8:3;
    vuint32_t _unused_11:5;
    vuint32_t _unused_16:16;
  } B;
} ENET_CHANNEL_TCSR_tag;

typedef union ENET_CHANNEL_TCCR_union_tag { /* Timer Compare Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TCC:32;                  /* Timer Capture Compare */
  } B;
} ENET_CHANNEL_TCCR_tag;

typedef struct ENET_CHANNEL_struct_tag {
  ENET_CHANNEL_TCSR_tag TCSR;          /* Timer Control Status Register */
  ENET_CHANNEL_TCCR_tag TCCR;          /* Timer Compare Capture Register */
} ENET_CHANNEL_tag;

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  ENET_EIR_tag EIR;                    /* Interrupt Event Register */
  ENET_EIMR_tag EIMR;                  /* Interrupt Mask Register */
  uint8_t ENET_reserved1[4];
  ENET_RDAR_tag RDAR;                  /* Receive Descriptor Active Register - Ring 0 */
  ENET_TDAR_tag TDAR;                  /* Transmit Descriptor Active Register - Ring 0 */
  uint8_t ENET_reserved2[12];
  ENET_ECR_tag ECR;                    /* Ethernet Control Register */
  uint8_t ENET_reserved3[24];
  ENET_MMFR_tag MMFR;                  /* MII Management Frame Register */
  ENET_MSCR_tag MSCR;                  /* MII Speed Control Register */
  uint8_t ENET_reserved4[28];
  ENET_MIBC_tag MIBC;                  /* MIB Control Register */
  uint8_t ENET_reserved5[28];
  ENET_RCR_tag RCR;                    /* Receive Control Register */
  uint8_t ENET_reserved6[60];
  ENET_TCR_tag TCR;                    /* Transmit Control Register */
  uint8_t ENET_reserved7[28];
  ENET_PALR_tag PALR;                  /* Physical Address Lower Register */
  ENET_PAUR_tag PAUR;                  /* Physical Address Upper Register */
  ENET_OPD_tag OPD;                    /* Opcode/Pause Duration Register */
  ENET_TXIC_tag TXIC[3];               /* Transmit Interrupt Coalescing Register */
  uint8_t ENET_reserved8[4];
  ENET_RXIC_tag RXIC[3];               /* Receive Interrupt Coalescing Register */
  uint8_t ENET_reserved9[12];
  ENET_IAUR_tag IAUR;                  /* Descriptor Individual Upper Address Register */
  ENET_IALR_tag IALR;                  /* Descriptor Individual Lower Address Register */
  ENET_GAUR_tag GAUR;                  /* Descriptor Group Upper Address Register */
  ENET_GALR_tag GALR;                  /* Descriptor Group Lower Address Register */
  uint8_t ENET_reserved10[28];
  ENET_TFWR_tag TFWR;                  /* Transmit FIFO Watermark Register */
  uint8_t ENET_reserved11[24];
  ENET_RDSR1_tag RDSR1;                /* Receive Descriptor Ring 1 Start Register */
  ENET_TDSR1_tag TDSR1;                /* Transmit Buffer Descriptor Ring 1 Start Register */
  ENET_MRBR1_tag MRBR1;                /* Maximum Receive Buffer Size Register - Ring 1 */
  ENET_RDSR2_tag RDSR2;                /* Receive Descriptor Ring 2 Start Register */
  ENET_TDSR2_tag TDSR2;                /* Transmit Buffer Descriptor Ring 2 Start Register */
  ENET_MRBR2_tag MRBR2;                /* Maximum Receive Buffer Size Register - Ring 2 */
  uint8_t ENET_reserved12[8];
  ENET_RDSR_tag RDSR;                  /* Receive Descriptor Ring 0 Start Register */
  ENET_TDSR_tag TDSR;                  /* Transmit Buffer Descriptor Ring 0 Start Register */
  ENET_MRBR_tag MRBR;                  /* Maximum Receive Buffer Size Register - Ring 0 */
  uint8_t ENET_reserved13[4];
  ENET_RSFL_tag RSFL;                  /* Receive FIFO Section Full Threshold */
  ENET_RSEM_tag RSEM;                  /* Receive FIFO Section Empty Threshold */
  ENET_RAEM_tag RAEM;                  /* Receive FIFO Almost Empty Threshold */
  ENET_RAFL_tag RAFL;                  /* Receive FIFO Almost Full Threshold */
  ENET_TSEM_tag TSEM;                  /* Transmit FIFO Section Empty Threshold */
  ENET_TAEM_tag TAEM;                  /* Transmit FIFO Almost Empty Threshold */
  ENET_TAFL_tag TAFL;                  /* Transmit FIFO Almost Full Threshold */
  ENET_TIPG_tag TIPG;                  /* Transmit Inter-Packet Gap */
  ENET_FTRL_tag FTRL;                  /* Frame Truncation Length */
  uint8_t ENET_reserved14[12];
  ENET_TACC_tag TACC;                  /* Transmit Accelerator Function Configuration */
  ENET_RACC_tag RACC;                  /* Receive Accelerator Function Configuration */
  ENET_RCMR_tag RCMR[2];               /* Receive Classification Match Register for Class n */
  uint8_t ENET_reserved15[8];
  ENET_DMACFG_tag DMACFG[2];           /* DMA Class Based Configuration */
  ENET_RDAR1_tag RDAR1;                /* Receive Descriptor Active Register - Ring 1 */
  ENET_TDAR1_tag TDAR1;                /* Transmit Descriptor Active Register - Ring 1 */
  ENET_RDAR2_tag RDAR2;                /* Receive Descriptor Active Register - Ring 2 */
  ENET_TDAR2_tag TDAR2;                /* Transmit Descriptor Active Register - Ring 2 */
  ENET_QOS_tag QOS;                    /* QOS Scheme */
  uint8_t ENET_reserved16[12];
  ENET_RMON_T_DROP_tag RMON_T_DROP;    /* Reserved Statistic Register */
  ENET_RMON_T_PACKETS_tag RMON_T_PACKETS; /* Tx Packet Count Statistic Register */
  ENET_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* Tx Broadcast Packets Statistic Register */
  ENET_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* Tx Multicast Packets Statistic Register */
  ENET_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* Tx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  ENET_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  ENET_RMON_T_FRAG_tag RMON_T_FRAG;    /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_T_JAB_tag RMON_T_JAB;      /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  ENET_RMON_T_COL_tag RMON_T_COL;      /* Tx Collision Count Statistic Register */
  ENET_RMON_T_P64_tag RMON_T_P64;      /* Tx 64-Byte Packets Statistic Register */
  ENET_RMON_T_P65TO127_tag RMON_T_P65TO127; /* Tx 65- to 127-byte Packets Statistic Register */
  ENET_RMON_T_P128TO255_tag RMON_T_P128TO255; /* Tx 128- to 255-byte Packets Statistic Register */
  ENET_RMON_T_P256TO511_tag RMON_T_P256TO511; /* Tx 256- to 511-byte Packets Statistic Register */
  ENET_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* Tx 512- to 1023-byte Packets Statistic Register */
  ENET_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* Tx 1024- to 2047-byte Packets Statistic Register */
  ENET_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  ENET_RMON_T_OCTETS_tag RMON_T_OCTETS; /* Tx Octets Statistic Register */
  ENET_IEEE_T_DROP_tag IEEE_T_DROP;    /* Reserved Statistic Register */
  ENET_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames Transmitted OK Statistic Register */
  ENET_IEEE_T_1COL_tag IEEE_T_1COL;    /* Frames Transmitted with Single Collision Statistic Register */
  ENET_IEEE_T_MCOL_tag IEEE_T_MCOL;    /* Frames Transmitted with Multiple Collisions Statistic Register */
  ENET_IEEE_T_DEF_tag IEEE_T_DEF;      /* Frames Transmitted after Deferral Delay Statistic Register */
  ENET_IEEE_T_LCOL_tag IEEE_T_LCOL;    /* Frames Transmitted with Late Collision Statistic Register */
  ENET_IEEE_T_EXCOL_tag IEEE_T_EXCOL;  /* Frames Transmitted with Excessive Collisions Statistic Register */
  ENET_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  ENET_IEEE_T_CSERR_tag IEEE_T_CSERR;  /* Frames Transmitted with Carrier Sense Error Statistic Register */
  ENET_IEEE_T_SQE_tag IEEE_T_SQE;      /* Reserved Statistic Register */
  ENET_IEEE_T_FDXFC_tag IEEE_T_FDXFC;  /* Flow Control Pause Frames Transmitted Statistic Register */
  ENET_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  uint8_t ENET_reserved17[12];
  ENET_RMON_R_PACKETS_tag RMON_R_PACKETS; /* Rx Packet Count Statistic Register */
  ENET_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* Rx Broadcast Packets Statistic Register */
  ENET_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* Rx Multicast Packets Statistic Register */
  ENET_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* Rx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  ENET_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  ENET_RMON_R_FRAG_tag RMON_R_FRAG;    /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_JAB_tag RMON_R_JAB;      /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved Statistic Register */
  ENET_RMON_R_P64_tag RMON_R_P64;      /* Rx 64-Byte Packets Statistic Register */
  ENET_RMON_R_P65TO127_tag RMON_R_P65TO127; /* Rx 65- to 127-Byte Packets Statistic Register */
  ENET_RMON_R_P128TO255_tag RMON_R_P128TO255; /* Rx 128- to 255-Byte Packets Statistic Register */
  ENET_RMON_R_P256TO511_tag RMON_R_P256TO511; /* Rx 256- to 511-Byte Packets Statistic Register */
  ENET_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* Rx 512- to 1023-Byte Packets Statistic Register */
  ENET_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* Rx 1024- to 2047-Byte Packets Statistic Register */
  ENET_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* Rx Packets Greater than 2048 Bytes Statistic Register */
  ENET_RMON_R_OCTETS_tag RMON_R_OCTETS; /* Rx Octets Statistic Register */
  ENET_IEEE_R_DROP_tag IEEE_R_DROP;    /* Frames not Counted Correctly Statistic Register */
  ENET_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames Received OK Statistic Register */
  ENET_IEEE_R_CRC_tag IEEE_R_CRC;      /* Frames Received with CRC Error Statistic Register */
  ENET_IEEE_R_ALIGN_tag IEEE_R_ALIGN;  /* Frames Received with Alignment Error Statistic Register */
  ENET_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO Overflow Count Statistic Register */
  ENET_IEEE_R_FDXFC_tag IEEE_R_FDXFC;  /* Flow Control Pause Frames Received Statistic Register */
  ENET_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet Count for Frames Received without Error Statistic Register */
  uint8_t ENET_reserved18[284];
  ENET_ATCR_tag ATCR;                  /* Adjustable Timer Control Register */
  ENET_ATVR_tag ATVR;                  /* Timer Value Register */
  ENET_ATOFF_tag ATOFF;                /* Timer Offset Register */
  ENET_ATPER_tag ATPER;                /* Timer Period Register */
  ENET_ATCOR_tag ATCOR;                /* Timer Correction Register */
  ENET_ATINC_tag ATINC;                /* Time-Stamping Clock Period Register */
  ENET_ATSTMP_tag ATSTMP;              /* Timestamp of Last Transmitted Frame */
  uint8_t ENET_reserved19[356];
  ENET_MDATA_tag MDATA;                /* Pattern Match Data Register */
  ENET_MMASK_tag MMASK;                /* Match Entry Mask Register */
  ENET_MCONFIG_tag MCONFIG;            /* Match Entry Rules Configuration Register */
  ENET_MENTRYRW_tag MENTRYRW;          /* Match Entry Read/Write Command Register */
  ENET_RXPCTL_tag RXPCTL;              /* Receive Parser Control Register */
  ENET_MAXFRMOFF_tag MAXFRMOFF;        /* Maximum Frame Offset */
  ENET_RXPARST_tag RXPARST;            /* Receive Parser Status */
  uint8_t ENET_reserved20[4];
  ENET_PARSDSCD_tag PARSDSCD;          /* Parser Discard Count */
  ENET_PRSACPT0_tag PRSACPT0;          /* Parser Accept Count 0 */
  ENET_PRSRJCT0_tag PRSRJCT0;          /* Parser Reject Count 0 */
  ENET_PRSACPT1_tag PRSACPT1;          /* Parser Accept Count 1 */
  ENET_PRSRJCT1_tag PRSRJCT1;          /* Parser Reject Count 1 */
  ENET_PRSACPT2_tag PRSACPT2;          /* Parser Accept Count 2 */
  ENET_PRSRJCT2_tag PRSRJCT2;          /* Parser Reject Count 2 */
  uint8_t ENET_reserved21[72];
  ENET_TGSR_tag TGSR;                  /* Timer Global Status Register */
  ENET_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: ERM ================================
   ============================================================================ */

typedef union ERM_CR_union_tag {       /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:2;
    vuint32_t _unused_4:2;
    vuint32_t ENCIE6:1;
    vuint32_t ESCIE6:1;
    vuint32_t _unused_8:2;
    vuint32_t ENCIE5:1;
    vuint32_t ESCIE5:1;
    vuint32_t _unused_12:2;
    vuint32_t ENCIE4:1;
    vuint32_t ESCIE4:1;
    vuint32_t _unused_16:2;
    vuint32_t ENCIE3:1;
    vuint32_t ESCIE3:1;
    vuint32_t _unused_20:2;
    vuint32_t ENCIE2:1;
    vuint32_t ESCIE2:1;
    vuint32_t _unused_24:2;
    vuint32_t ENCIE1:1;
    vuint32_t ESCIE1:1;
    vuint32_t _unused_28:2;
    vuint32_t ENCIE0:1;
    vuint32_t ESCIE0:1;
  } B;
} ERM_CR_tag;

typedef union ERM_SR_union_tag {       /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t _unused_4:2;
    vuint32_t NCE6:1;
    vuint32_t SBC6:1;
    vuint32_t _unused_8:2;
    vuint32_t NCE5:1;
    vuint32_t SBC5:1;
    vuint32_t _unused_12:2;
    vuint32_t NCE4:1;
    vuint32_t SBC4:1;
    vuint32_t _unused_16:2;
    vuint32_t NCE3:1;
    vuint32_t SBC3:1;
    vuint32_t _unused_20:2;
    vuint32_t NCE2:1;
    vuint32_t SBC2:1;
    vuint32_t _unused_24:2;
    vuint32_t NCE1:1;
    vuint32_t SBC1:1;
    vuint32_t _unused_28:2;
    vuint32_t NCE0:1;
    vuint32_t SBC0:1;
  } B;
} ERM_SR_tag;

typedef union ERM_ERROR_EAR_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;
  } B;
} ERM_ERROR_EAR_tag;

typedef union ERM_ERROR_SYN_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SYNDROME:8;
  } B;
} ERM_ERROR_SYN_tag;

typedef struct ERM_ERROR_struct_tag {
  ERM_ERROR_EAR_tag EAR;               /* ERM Memory n Error Address Register */
  ERM_ERROR_SYN_tag SYN;               /* ERM Memory n Syndrome Register */
  uint8_t ERROR_reserved0[8];
} ERM_ERROR_tag;

struct ERM_tag {
  ERM_CR_tag CR;                       /* ERM Configuration Register */
  uint8_t ERM_reserved0[12];
  ERM_SR_tag SR;                       /* ERM Status Register */
  uint8_t ERM_reserved1[236];
  ERM_ERROR_tag ERROR[7];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t OPR:5;                   /* Operation Run */
    vuint32_t _unused_5:1;
    vuint32_t OPS:2;
    vuint32_t _unused_8:1;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_10:19;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t FILTER_BYPASS:1;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;                /* Locked-Operation Control Key */
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t _unused_11:1;
    vuint32_t OD:1;
    vuint32_t _unused_13:2;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t _unused_16:4;
    vuint32_t _unused_20:2;
    vuint32_t FCCU_SET_CLEAR:2;        /* Fault-Output (EOUT) Control */
    vuint32_t FCCU_SET_AFTER_RESET:1;  /* Fault-Output (EOUT) Activate */
    vuint32_t _unused_25:7;
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFCx:32;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSCx:32;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFSx:32;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFEx:32;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOEx:32;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timer Interval */
  vuint32_t R;
  struct {
    vuint32_t TO:3;                    /* Configuration-State Timer Interval */
    vuint32_t _unused_3:29;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t EOUT0:1;
    vuint32_t EOUT1:1;
    vuint32_t _unused_2:2;
    vuint32_t EIN0:1;                  /* Error Input 0 */
    vuint32_t EIN1:1;                  /* Error Input 1 */
    vuint32_t _unused_6:26;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t STATUS:3;                /* FCCU State */
    vuint32_t ESTAT:1;                 /* Fault State */
    vuint32_t PhysicErrorPin:2;        /* Fault Output (EOUT) States */
    vuint32_t _unused_6:26;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NAFS:8;
    vuint32_t _unused_8:24;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t AFFS:8;
    vuint32_t AF_SRC:2;
    vuint32_t _unused_10:22;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NFFS:8;
    vuint32_t NF_SRC:2;
    vuint32_t _unused_10:22;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t FAFS:9;
    vuint32_t _unused_9:23;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t FNCFC:7;
    vuint32_t _unused_7:25;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t NMI_STAT:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_IEN:1;
    vuint32_t _unused_1:2;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:28;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t MCS0:4;
    vuint32_t _unused_4:2;
    vuint32_t FS0:1;                   /* Fault Status 0 */
    vuint32_t VL0:1;
    vuint32_t MCS1:4;
    vuint32_t _unused_12:2;
    vuint32_t FS1:1;                   /* Fault Status 1 */
    vuint32_t VL1:1;
    vuint32_t MCS2:4;
    vuint32_t _unused_20:2;
    vuint32_t FS2:1;                   /* Fault Status 2 */
    vuint32_t VL2:1;
    vuint32_t MCS3:4;
    vuint32_t _unused_28:2;
    vuint32_t FS3:1;                   /* Fault Status 3 */
    vuint32_t VL3:1;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t TRANSKEY:9;              /* Transient Configuration Lock */
    vuint32_t _unused_9:23;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t PERMNTKEY:9;             /* Permanent Configuration Lock */
    vuint32_t _unused_9:23;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t DELTA_T:14;              /* Bistable Minimum Fault-Output (EOUT) Faulty Interval */
    vuint32_t _unused_14:2;
    vuint32_t _unused_16:14;
    vuint32_t _unused_30:2;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQENx:32;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIENx:32;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTENx:32;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[4];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[32];
  FCCU_NCFS_CFG_tag NCFS_CFG[8];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[20];
  FCCU_NCF_S_tag NCF_S[4];             /* Noncritical Fault Status */
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[4];             /* Noncritical Fault Enable */
  FCCU_NCF_TOE_tag NCF_TOE[4];         /* Noncritical Fault Timeout Enable */
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timer Interval */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved3[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Configuration Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Configuration Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[4]; /* IRQ Alarm Enable */
  FCCU_NMI_EN_tag NMI_EN[4];           /* NMI Enable */
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[4]; /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
};


/* ============================================================================
   =============================== Module: FDMA ===============================
   ============================================================================ */

typedef union FDMA_XFR_REC_LIST_PTR_union_tag { /* Transfer Records List Pointer register */
  vuint32_t R;
  struct {
    vuint32_t XFR_REC_LIST_PTR:32;     /* Transfer Records List Pointer */
  } B;
} FDMA_XFR_REC_LIST_PTR_tag;

typedef union FDMA_XFR_REC_CNT_union_tag { /* Total entries in Transfer Record List */
  vuint32_t R;
  struct {
    vuint32_t XFR_REC_CNT:7;           /* Total entries in the Transfer Record List */
    vuint32_t _unused_7:25;
  } B;
} FDMA_XFR_REC_CNT_tag;

typedef union FDMA_XFR_REC_NUM_union_tag { /* Transfer Record number for current Line transfer */
  vuint32_t R;
  struct {
    vuint32_t XFR_REC_NUM:7;           /* Transfer Record number to be used for current Line transfer */
    vuint32_t _unused_7:25;
  } B;
} FDMA_XFR_REC_NUM_tag;

typedef union FDMA_XFR_LINE_NUM_union_tag { /* DDR and SRAM Line numbers for current transfer */
  vuint32_t R;
  struct {
    vuint32_t DDR_IMG_LINE_NUM:16;     /* Image Line number to be accessed from the selected Image in DDR */
    vuint32_t SRAM_LINE_NUM:14;        /* Image Line number to be accessed from the selected Image Slice in SRAM */
    vuint32_t _unused_30:2;
  } B;
} FDMA_XFR_LINE_NUM_tag;

typedef union FDMA_LINE_INCR_union_tag { /* Line increment value for SRAM and DDR */
  vuint32_t R;
  struct {
    vuint32_t DDR_LINE_INCR:8;         /* DDR Line increment value */
    vuint32_t _unused_8:8;
    vuint32_t SRAM_LINE_INCR:8;        /* SRAM Line increment value */
    vuint32_t _unused_24:8;
  } B;
} FDMA_LINE_INCR_tag;

typedef union FDMA_IRQ_EN_union_tag {  /* Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t FDMA_DONE_IRQ_EN:1;      /* FastDMA Done interrupt enable */
    vuint32_t FDMA_ERR_IRQ_EN:1;       /* FastDMA error interrupt enable */
    vuint32_t FDMA_CRC_ERR_IRQ_EN:1;   /* FastDMA CRC Error interrupt enable */
    vuint32_t EDMA_TRIG_EN:1;          /* eDMA Trigger enable */
    vuint32_t _unused_4:28;
  } B;
} FDMA_IRQ_EN_tag;

typedef union FDMA_XFR_STAT_union_tag { /* Status register */
  vuint32_t R;
  struct {
    vuint32_t XFR_CMD_QUEUE_EMPTY:1;   /* Transfer Command Queue Empty indicator */
    vuint32_t XFR_CMD_QUEUE_FULL:1;    /* Transfer Command Queue Full indicator */
    vuint32_t CRC_ERR:1;               /* CRC Error */
    vuint32_t CMD_CFG_ERR:1;           /* Transfer Command configuration Error */
    vuint32_t TR_RD_ERR:1;             /* Transfer setup error during Transfer Record List read */
    vuint32_t CRC_RD_ERR:1;            /* Error during CRC Read from SRAM */
    vuint32_t XFR_CFG_ERR:1;           /* Transfer Record configuration error */
    vuint32_t XFR_ERR_DDR:1;           /* Transfer error during AXI read/write on DDR interface */
    vuint32_t XFR_ERR_SRAM:1;          /* Transfer error during AXI read/write on SRAM interface */
    vuint32_t CRC_WR_ERR:1;            /* Error during CRC Write to SRAM */
    vuint32_t TR_WBACK_ERR:1;          /* Error during Transfer Record Write-back access */
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:4;
    vuint32_t XFR_DONE:1;
    vuint32_t _unused_17:7;
    vuint32_t DONE_CNT:8;
  } B;
} FDMA_XFR_STAT_tag;

typedef union FDMA_CALC_CRC_VAL_union_tag { /* Calculated CRC value */
  vuint32_t R;
  struct {
    vuint32_t CALC_CRC_VAL:32;         /* Calculated 32-bit CRC value for the current Line data */
  } B;
} FDMA_CALC_CRC_VAL_tag;

typedef union FDMA_CURR_DDR_PTR_union_tag { /* Current DDR address */
  vuint32_t R;
  struct {
    vuint32_t CURR_DDR_PTR:32;         /* Current DDR address */
  } B;
} FDMA_CURR_DDR_PTR_tag;

typedef union FDMA_CURR_SRAM_PTR_union_tag { /* Current SRAM address */
  vuint32_t R;
  struct {
    vuint32_t CURR_SRAM_PTR:32;        /* Current SRAM address */
  } B;
} FDMA_CURR_SRAM_PTR_tag;

typedef union FDMA_XFR_REC_NUM_DONE_union_tag { /* Last completed Transfer Record Number */
  vuint32_t R;
  struct {
    vuint32_t XFR_REC_NUM_DONE:7;      /* Last completed Transfer Record number */
    vuint32_t _unused_7:25;
  } B;
} FDMA_XFR_REC_NUM_DONE_tag;

typedef union FDMA_ERR_XFR_REC_NUM_union_tag { /* Transfer Record Number of an Erroneous Transfer */
  vuint32_t R;
  struct {
    vuint32_t ERR_XFR_REC_NUM:7;       /* Transfer Record number of an Erroneous Transfer */
    vuint32_t _unused_7:25;
  } B;
} FDMA_ERR_XFR_REC_NUM_tag;

typedef union FDMA_NEXT_LINE_union_tag { /* SRAM and DDR next Line number */
  vuint32_t R;
  struct {
    vuint32_t DDR_NEXT_LINE_NUM:16;    /* Next Line number to be accessed from the selected Image in DDR */
    vuint32_t SRAM_NEXT_LINE_NUM:14;   /* Next Line number to be accessed from the selected Image slice in SRAM */
    vuint32_t _unused_30:2;
  } B;
} FDMA_NEXT_LINE_tag;

typedef union FDMA_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t SOFT_RST:1;              /* Soft Reset bit */
    vuint32_t _unused_1:31;
  } B;
} FDMA_CTRL_tag;

struct FDMA_tag {
  FDMA_XFR_REC_LIST_PTR_tag XFR_REC_LIST_PTR; /* Transfer Records List Pointer register */
  FDMA_XFR_REC_CNT_tag XFR_REC_CNT;    /* Total entries in Transfer Record List */
  FDMA_XFR_REC_NUM_tag XFR_REC_NUM;    /* Transfer Record number for current Line transfer */
  FDMA_XFR_LINE_NUM_tag XFR_LINE_NUM;  /* DDR and SRAM Line numbers for current transfer */
  FDMA_LINE_INCR_tag LINE_INCR;        /* Line increment value for SRAM and DDR */
  FDMA_IRQ_EN_tag IRQ_EN;              /* Interrupt enable register */
  FDMA_XFR_STAT_tag XFR_STAT;          /* Status register */
  FDMA_CALC_CRC_VAL_tag CALC_CRC_VAL;  /* Calculated CRC value */
  FDMA_CURR_DDR_PTR_tag CURR_DDR_PTR;  /* Current DDR address */
  FDMA_CURR_SRAM_PTR_tag CURR_SRAM_PTR; /* Current SRAM address */
  FDMA_XFR_REC_NUM_DONE_tag XFR_REC_NUM_DONE; /* Last completed Transfer Record Number */
  FDMA_ERR_XFR_REC_NUM_tag ERR_XFR_REC_NUM; /* Transfer Record Number of an Erroneous Transfer */
  FDMA_NEXT_LINE_tag NEXT_LINE;        /* SRAM and DDR next Line number */
  FDMA_CTRL_tag CTRL;                  /* Control register */
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

typedef union FR_MVR_union_tag {       /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t PEVER:8;
    vuint16_t CHIVER:8;
  } B;
} FR_MVR_tag;

typedef union FR_MCR_union_tag {       /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:1;
    vuint16_t BITRATE:3;
    vuint16_t CLKSEL:1;
    vuint16_t _unused_5:1;
    vuint16_t FAM:1;
    vuint16_t FUM:1;
    vuint16_t _unused_8:1;             /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t ECCE:1;
    vuint16_t SFFE:1;
    vuint16_t CHA:1;
    vuint16_t CHB:1;
    vuint16_t SCM:1;
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t MEN:1;
  } B;
} FR_MCR_tag;

typedef union FR_SYMBADHR_union_tag {  /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
  } B;
} FR_SYMBADHR_tag;

typedef union FR_SYMBADLR_union_tag {  /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;
    vuint16_t SMBA:12;
  } B;
} FR_SYMBADLR_tag;

typedef union FR_STBSCR_union_tag {    /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t STBPSEL:2;
    vuint16_t _unused_2:2;
    vuint16_t ENB:1;
    vuint16_t _unused_5:3;
    vuint16_t SEL:4;
    vuint16_t _unused_12:3;
    vuint16_t WMD:1;
  } B;
} FR_STBSCR_tag;

typedef union FR_MBDSR_union_tag {     /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t MBSEG1DS:7;
    vuint16_t _unused_7:1;
    vuint16_t MBSEG2DS:7;
    vuint16_t _unused_15:1;
  } B;
} FR_MBDSR_tag;

typedef union FR_MBSSUTR_union_tag {   /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t LAST_MB_UTIL:7;
    vuint16_t _unused_7:1;
    vuint16_t LAST_MB_SEG1:7;
    vuint16_t _unused_15:1;
  } B;
} FR_MBSSUTR_tag;

typedef union FR_PEDRAR_union_tag {    /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t DAD:1;
    vuint16_t ADDR:11;
    vuint16_t INST:4;
  } B;
} FR_PEDRAR_tag;

typedef union FR_PEDRDR_union_tag {    /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_PEDRDR_tag;

typedef union FR_POCR_union_tag {      /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t POCCMD:4;
    vuint16_t _unused_4:3;
    vuint16_t BSY_WMC:1;
    vuint16_t ERC_AP:2;
    vuint16_t EOC_AP:2;
    vuint16_t _unused_12:3;
    vuint16_t WME:1;
  } B;
} FR_POCR_tag;

typedef union FR_GIFER_union_tag {     /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t TBIE:1;
    vuint16_t RBIE:1;
    vuint16_t FAFAIE:1;
    vuint16_t FAFBIE:1;
    vuint16_t WUPIE:1;
    vuint16_t CHIE:1;
    vuint16_t PRIE:1;
    vuint16_t MIE:1;
    vuint16_t TBIF:1;
    vuint16_t RBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t WUPIF:1;
    vuint16_t CHIF:1;
    vuint16_t PRIF:1;
    vuint16_t MIF:1;
  } B;
} FR_GIFER_tag;

typedef union FR_PIFR0_union_tag {     /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t CYS_IF:1;
    vuint16_t TI1_IF:1;
    vuint16_t TI2_IF:1;
    vuint16_t TBVA_IF:1;
    vuint16_t TBVB_IF:1;
    vuint16_t LTXA_IF:1;
    vuint16_t LTXB_IF:1;
    vuint16_t MTX_IF:1;
    vuint16_t MXS_IF:1;
    vuint16_t CCL_IF:1;
    vuint16_t MOC_IF:1;
    vuint16_t MRC_IF:1;
    vuint16_t CSA_IF:1;
    vuint16_t ILCF_IF:1;
    vuint16_t INTL_IF:1;
    vuint16_t FATL_IF:1;
  } B;
} FR_PIFR0_tag;

typedef union FR_PIFR1_union_tag {     /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;
    vuint16_t ODT_IF:1;
    vuint16_t EVT_IF:1;
    vuint16_t _unused_6:2;
    vuint16_t SSI0_IF:1;
    vuint16_t SSI1_IF:1;
    vuint16_t SSI2_IF:1;
    vuint16_t SSI3_IF:1;
    vuint16_t PSC_IF:1;
    vuint16_t PECF_IF:1;
    vuint16_t IPC_IF:1;
    vuint16_t EMC_IF:1;
  } B;
} FR_PIFR1_tag;

typedef union FR_PIER0_union_tag {     /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t CYS_IE:1;
    vuint16_t TI1_IE:1;
    vuint16_t TI2_IE:1;
    vuint16_t TBVA_IE:1;
    vuint16_t TBVB_IE:1;
    vuint16_t LTXA_IE:1;
    vuint16_t LTXB_IE:1;
    vuint16_t MTX_IE:1;
    vuint16_t MXS_IE:1;
    vuint16_t CCL_IE:1;
    vuint16_t MOC_IE:1;
    vuint16_t MRC_IE:1;
    vuint16_t CSA_IE:1;
    vuint16_t ILCF_IE:1;
    vuint16_t INTL_IE:1;
    vuint16_t FATL_IE:1;
  } B;
} FR_PIER0_tag;

typedef union FR_PIER1_union_tag {     /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;
    vuint16_t ODT_IE:1;
    vuint16_t EVT_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t SSI0_IE:1;
    vuint16_t SSI1_IE:1;
    vuint16_t SSI2_IE:1;
    vuint16_t SSI3_IE:1;
    vuint16_t PSC_IE:1;
    vuint16_t PECF_IE:1;
    vuint16_t IPC_IE:1;
    vuint16_t EMC_IE:1;
  } B;
} FR_PIER1_tag;

typedef union FR_CHIERFR_union_tag {   /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t ILSA_EF:1;
    vuint16_t NMF_EF:1;
    vuint16_t NML_EF:1;
    vuint16_t SPL_EF:1;
    vuint16_t DPL_EF:1;
    vuint16_t FID_EF:1;
    vuint16_t SBCF_EF:1;
    vuint16_t _unused_7:1;
    vuint16_t LCK_EF:1;
    vuint16_t MBU_EF:1;
    vuint16_t MBS_EF:1;
    vuint16_t FOVA_EF:1;
    vuint16_t FOVB_EF:1;
    vuint16_t PCMI_EF:1;
    vuint16_t FRLA_EF:1;
    vuint16_t FRLB_EF:1;
  } B;
} FR_CHIERFR_tag;

typedef union FR_MBIVEC_union_tag {    /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t RBIVEC:7;
    vuint16_t _unused_7:1;
    vuint16_t TBIVEC:7;
    vuint16_t _unused_15:1;
  } B;
} FR_MBIVEC_tag;

typedef union FR_CASERCR_union_tag {   /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;
  } B;
} FR_CASERCR_tag;

typedef union FR_CBSERCR_union_tag {   /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;
  } B;
} FR_CBSERCR_tag;

typedef union FR_PSR0_union_tag {      /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t WAKEUPSTATUS:3;
    vuint16_t _unused_3:1;
    vuint16_t STARTUPSTATE:4;
    vuint16_t PROTSTATE:3;
    vuint16_t _unused_11:1;
    vuint16_t SLOTMODE:2;
    vuint16_t ERRMODE:2;
  } B;
} FR_PSR0_tag;

typedef union FR_PSR1_union_tag {      /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t APTAC:5;
    vuint16_t FRZ:1;
    vuint16_t HHR:1;
    vuint16_t CPN:1;
    vuint16_t REMCSAT:5;
    vuint16_t _unused_13:1;
    vuint16_t CSP:1;
    vuint16_t CSAA:1;
  } B;
} FR_PSR1_tag;

typedef union FR_PSR2_union_tag {      /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CKCORFCNT:4;
    vuint16_t MTA:1;
    vuint16_t SSEA:1;
    vuint16_t SBVA:1;
    vuint16_t STCA:1;
    vuint16_t NSEA:1;
    vuint16_t NBVA:1;
    vuint16_t MTB:1;
    vuint16_t SSEB:1;
    vuint16_t SBVB:1;
    vuint16_t STCB:1;
    vuint16_t NSEB:1;
    vuint16_t NBVB:1;
  } B;
} FR_PSR2_tag;

typedef union FR_PSR3_union_tag {      /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t AVFA:1;
    vuint16_t ASEA:1;
    vuint16_t ACEA:1;
    vuint16_t AACA:1;
    vuint16_t ABVA:1;
    vuint16_t WUA:1;
    vuint16_t _unused_6:2;
    vuint16_t AVFB:1;
    vuint16_t ASEB:1;
    vuint16_t ACEB:1;
    vuint16_t AACB:1;
    vuint16_t ABVB:1;
    vuint16_t WUB:1;
    vuint16_t _unused_14:2;
  } B;
} FR_PSR3_tag;

typedef union FR_MTCTR_union_tag {     /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t MTCT:14;
    vuint16_t _unused_14:2;
  } B;
} FR_MTCTR_tag;

typedef union FR_CYCTR_union_tag {     /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNT:6;
    vuint16_t _unused_6:10;
  } B;
} FR_CYCTR_tag;

typedef union FR_SLTCTAR_union_tag {   /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTCNTA:11;
    vuint16_t _unused_11:5;
  } B;
} FR_SLTCTAR_tag;

typedef union FR_SLTCTBR_union_tag {   /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTCNTB:11;
    vuint16_t _unused_11:5;
  } B;
} FR_SLTCTBR_tag;

typedef union FR_RTCORVR_union_tag {   /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;
  } B;
} FR_RTCORVR_tag;

typedef union FR_OFCORVR_union_tag {   /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;
  } B;
} FR_OFCORVR_tag;

typedef union FR_CIFR_union_tag {      /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t TBIF:1;
    vuint16_t RBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t WUPIF:1;
    vuint16_t CHIF:1;
    vuint16_t PRIF:1;
    vuint16_t MIF:1;
    vuint16_t _unused_8:8;
  } B;
} FR_CIFR_tag;

typedef union FR_SYMATOR_union_tag {   /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t TIMEOUT:8;
    vuint16_t _unused_8:8;
  } B;
} FR_SYMATOR_tag;

typedef union FR_SFCNTR_union_tag {    /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFODA:4;
    vuint16_t SFODB:4;
    vuint16_t SFEVA:4;
    vuint16_t SFEVB:4;
  } B;
} FR_SFCNTR_tag;

typedef union FR_SFTOR_union_tag {     /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:1;
    vuint16_t SFT_OFFSET:15;
  } B;
} FR_SFTOR_tag;

typedef union FR_SFTCCSR_union_tag {   /* Sync Frame Table Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t SIDEN:1;
    vuint16_t SDVEN:1;
    vuint16_t OPT:1;
    vuint16_t _unused_3:1;
    vuint16_t OVAL:1;
    vuint16_t EVAL:1;
    vuint16_t OLKS:1;
    vuint16_t ELKS:1;
    vuint16_t CYCNUM:6;
    vuint16_t OLKT:1;
    vuint16_t ELKT:1;
  } B;
} FR_SFTCCSR_tag;

typedef union FR_SFIDRFR_union_tag {   /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t SYNFRID:10;
    vuint16_t _unused_10:6;
  } B;
} FR_SFIDRFR_tag;

typedef union FR_SFIDAFVR_union_tag {  /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t FVAL:10;
    vuint16_t _unused_10:6;
  } B;
} FR_SFIDAFVR_tag;

typedef union FR_SFIDAFMR_union_tag {  /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t FMSK:10;
    vuint16_t _unused_10:6;
  } B;
} FR_SFIDAFMR_tag;

typedef union FR_NMVR_union_tag {      /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;
  } B;
} FR_NMVR_tag;

typedef union FR_NMVLR_union_tag {     /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t NMVL:4;
    vuint16_t _unused_4:12;
  } B;
} FR_NMVLR_tag;

typedef union FR_TICCR_union_tag {     /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t T1ST:1;
    vuint16_t T1TR:1;
    vuint16_t T1SP:1;
    vuint16_t _unused_3:1;
    vuint16_t T1_REP:1;
    vuint16_t _unused_5:3;
    vuint16_t T2ST:1;
    vuint16_t T2TR:1;
    vuint16_t T2SP:1;
    vuint16_t _unused_11:1;
    vuint16_t T2_REP:1;
    vuint16_t T2_CFG:1;
    vuint16_t _unused_14:2;
  } B;
} FR_TICCR_tag;

typedef union FR_TI1CYSR_union_tag {   /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t T1_CYC_MSK:6;
    vuint16_t _unused_6:2;
    vuint16_t T1_CYC_VAL:6;
    vuint16_t _unused_14:2;
  } B;
} FR_TI1CYSR_tag;

typedef union FR_TI1MTOR_union_tag {   /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t T1_MTOFFSET:14;
    vuint16_t _unused_14:2;
  } B;
} FR_TI1MTOR_tag;

typedef union FR_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_6:2;
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_14:2;
  } B;
} FR_TI2CR0_ABS_tag;

typedef union FR_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FR_TI2CR0_REL_tag;

typedef union FR_TI2CR0_union_tag {
  FR_TI2CR0_ABS_tag ABS;               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FR_TI2CR0_REL_tag REL;               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FR_TI2CR0_tag;

typedef union FR_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
    vuint16_t _unused_14:2;
  } B;
} FR_TI2CR1_ABS_tag;

typedef union FR_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FR_TI2CR1_REL_tag;

typedef union FR_TI2CR1_union_tag {
  FR_TI2CR1_ABS_tag ABS;               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FR_TI2CR1_REL_tag REL;               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FR_TI2CR1_tag;

typedef union FR_SSSR_union_tag {      /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTNUMBER:11;
    vuint16_t _unused_11:1;
    vuint16_t SEL:2;
    vuint16_t _unused_14:1;
    vuint16_t WMD:1;
  } B;
} FR_SSSR_tag;

typedef union FR_SSCCR_union_tag {     /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t STATUSMASK:4;
    vuint16_t SUF:1;
    vuint16_t NUF:1;
    vuint16_t SYF:1;
    vuint16_t VFR:1;
    vuint16_t MCY:1;
    vuint16_t CNTCFG:2;
    vuint16_t _unused_11:1;
    vuint16_t SEL:2;
    vuint16_t _unused_14:1;
    vuint16_t WMD:1;
  } B;
} FR_SSCCR_tag;

typedef union FR_SSR_union_tag {       /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t TCA:1;
    vuint16_t BVA:1;
    vuint16_t CEA:1;
    vuint16_t SEA:1;
    vuint16_t SUA:1;
    vuint16_t NFA:1;
    vuint16_t SYA:1;
    vuint16_t VFA:1;
    vuint16_t TCB:1;
    vuint16_t BVB:1;
    vuint16_t CEB:1;
    vuint16_t SEB:1;
    vuint16_t SUB:1;
    vuint16_t NFB:1;
    vuint16_t SYB:1;
    vuint16_t VFB:1;
  } B;
} FR_SSR_tag;

typedef union FR_SSCR_union_tag {      /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;
  } B;
} FR_SSCR_tag;

typedef union FR_MTSACFR_union_tag {   /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNTVAL:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_14:1;
    vuint16_t MTE:1;
  } B;
} FR_MTSACFR_tag;

typedef union FR_MTSBCFR_union_tag {   /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNTVAL:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_14:1;
    vuint16_t MTE:1;
  } B;
} FR_MTSBCFR_tag;

typedef union FR_RSBIR_union_tag {     /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t RSBIDX:8;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    vuint16_t _unused_8:4;
    vuint16_t SEL:2;
    vuint16_t _unused_14:1;
    vuint16_t WMD:1;
  } B;
} FR_RSBIR_tag;

typedef union FR_RFWMSR_union_tag {    /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t SEL:1;
    vuint16_t _unused_1:7;
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
  } B;
} FR_RFWMSR_tag;

typedef union FR_RFSIR_union_tag {     /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
    vuint16_t _unused_10:6;
  } B;
} FR_RFSIR_tag;

typedef union FR_RFDSR_union_tag {     /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    vuint16_t _unused_7:1;
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
  } B;
} FR_RFDSR_tag;

typedef union FR_RFARIR_union_tag {    /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t RDIDX:10;
    vuint16_t _unused_10:6;
  } B;
} FR_RFARIR_tag;

typedef union FR_RFBRIR_union_tag {    /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t RDIDX:10;
    vuint16_t _unused_10:6;
  } B;
} FR_RFBRIR_tag;

typedef union FR_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FR_RFMIDAFVR_tag;

typedef union FR_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FR_RFMIDAFMR_tag;

typedef union FR_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    vuint16_t _unused_11:5;
  } B;
} FR_RFFIDRFVR_tag;

typedef union FR_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t FIDRFMSK:11;
    vuint16_t _unused_11:5;
  } B;
} FR_RFFIDRFMR_tag;

typedef union FR_RFRFCFR_union_tag {   /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t SID:11;                  /* Slot ID */
    vuint16_t _unused_11:1;
    vuint16_t SEL:2;
    vuint16_t IBD:1;
    vuint16_t WMD:1;
  } B;
} FR_RFRFCFR_tag;

typedef union FR_RFRFCTR_union_tag {   /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t F0EN:1;
    vuint16_t F1EN:1;
    vuint16_t F2EN:1;
    vuint16_t F3EN:1;
    vuint16_t _unused_4:4;
    vuint16_t F0MD:1;
    vuint16_t F1MD:1;
    vuint16_t F2MD:1;
    vuint16_t F3MD:1;
    vuint16_t _unused_12:4;
  } B;
} FR_RFRFCTR_tag;

typedef union FR_LDTXSLAR_union_tag {  /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t LDYNTXSLOTA:11;
    vuint16_t _unused_11:5;
  } B;
} FR_LDTXSLAR_tag;

typedef union FR_LDTXSLBR_union_tag {  /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t LDYNTXSLOTB:11;
    vuint16_t _unused_11:5;
  } B;
} FR_LDTXSLBR_tag;

typedef union FR_PCR0_union_tag {      /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t static_slot_length:10;
    vuint16_t action_point_offset:6;
  } B;
} FR_PCR0_tag;

typedef union FR_PCR1_union_tag {      /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t macro_after_first_static_slot:14;
    vuint16_t _unused_14:2;
  } B;
} FR_PCR1_tag;

typedef union FR_PCR2_union_tag {      /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
    vuint16_t minislot_after_action_point:6;
  } B;
} FR_PCR2_tag;

typedef union FR_PCR3_union_tag {      /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t coldstart_attempts:5;
    vuint16_t minislot_action_point_offset:5;
    vuint16_t wakeup_symbol_rx_low:6;
  } B;
} FR_PCR3_tag;

typedef union FR_PCR4_union_tag {      /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_window:9;
    vuint16_t cas_rx_low_max:7;
  } B;
} FR_PCR4_tag;

typedef union FR_PCR5_union_tag {      /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_idle:6;
    vuint16_t wakeup_symbol_tx_low:6;
    vuint16_t tss_transmitter:4;
  } B;
} FR_PCR5_tag;

typedef union FR_PCR6_union_tag {      /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t macro_initial_offset_a:7;
    vuint16_t symbol_window_after_action_point:8;
    vuint16_t _unused_15:1;
  } B;
} FR_PCR6_tag;

typedef union FR_PCR7_union_tag {      /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_macro_nom_half:7;
    vuint16_t decoding_correction_b:9;
  } B;
} FR_PCR7_tag;

typedef union FR_PCR8_union_tag {      /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_tx_idle:8;
    vuint16_t max_without_clock_correction_passive:4;
    vuint16_t max_without_clock_correction_fatal:4;
  } B;
} FR_PCR8_tag;

typedef union FR_PCR9_union_tag {      /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t offset_correction_out:14;
    vuint16_t symbol_window_exists:1;
    vuint16_t minislot_exists:1;
  } B;
} FR_PCR9_tag;

typedef union FR_PCR10_union_tag {     /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t macro_per_cycle:14;
    vuint16_t wakeup_channel:1;
    vuint16_t single_slot_enabled:1;
  } B;
} FR_PCR10_tag;

typedef union FR_PCR11_union_tag {     /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t offset_correction_start:14;
    vuint16_t key_slot_used_for_sync:1;
    vuint16_t key_slot_used_for_startup:1;
  } B;
} FR_PCR11_tag;

typedef union FR_PCR12_union_tag {     /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_header_crc:11;
    vuint16_t allow_passive_to_active:5;
  } B;
} FR_PCR12_tag;

typedef union FR_PCR13_union_tag {     /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t static_slot_after_action_point:10;
    vuint16_t first_minislot_action_point_offset:6;
  } B;
} FR_PCR13_tag;

typedef union FR_PCR14_union_tag {     /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:5;
    vuint16_t rate_correction_out:11;
  } B;
} FR_PCR14_tag;

typedef union FR_PCR15_union_tag {     /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:16;
  } B;
} FR_PCR15_tag;

typedef union FR_PCR16_union_tag {     /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:9;
    vuint16_t macro_initial_offset_b:7;
  } B;
} FR_PCR16_tag;

typedef union FR_PCR17_union_tag {     /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:16;
  } B;
} FR_PCR17_tag;

typedef union FR_PCR18_union_tag {     /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_id:10;
    vuint16_t wakeup_pattern:6;
  } B;
} FR_PCR18_tag;

typedef union FR_PCR19_union_tag {     /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t payload_length_static:7;
    vuint16_t decoding_correction_a:9;
  } B;
} FR_PCR19_tag;

typedef union FR_PCR20_union_tag {     /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t micro_initial_offset_a:8;
    vuint16_t micro_initial_offset_b:8;
  } B;
} FR_PCR20_tag;

typedef union FR_PCR21_union_tag {     /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t latest_tx:13;
    vuint16_t extern_rate_correction:3;
  } B;
} FR_PCR21_tag;

typedef union FR_PCR22_union_tag {     /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:4;
    vuint16_t comp_accepted_startup_range_a:11;
    vuint16_t _unused_15:1;            /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
  } B;
} FR_PCR22_tag;

typedef union FR_PCR23_union_tag {     /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:16;
  } B;
} FR_PCR23_tag;

typedef union FR_PCR24_union_tag {     /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:4;
    vuint16_t max_payload_length_dynamic:7;
    vuint16_t cluster_drift_damping:5;
  } B;
} FR_PCR24_tag;

typedef union FR_PCR25_union_tag {     /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:16;
  } B;
} FR_PCR25_tag;

typedef union FR_PCR26_union_tag {     /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:4;
    vuint16_t comp_accepted_startup_range_b:11;
    vuint16_t allow_halt_due_to_clock:1;
  } B;
} FR_PCR26_tag;

typedef union FR_PCR27_union_tag {     /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:16;
  } B;
} FR_PCR27_tag;

typedef union FR_PCR28_union_tag {     /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t macro_after_offset_correction:14;
    vuint16_t dynamic_slot_idle_phase:2;
  } B;
} FR_PCR28_tag;

typedef union FR_PCR29_union_tag {     /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t minislots_max:13;
    vuint16_t extern_offset_correction:3;
  } B;
} FR_PCR29_tag;

typedef union FR_PCR30_union_tag {     /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t sync_node_max:4;
    vuint16_t _unused_4:12;
  } B;
} FR_PCR30_tag;

typedef union FR_STPWHR_union_tag {    /* StopWatch Count High Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_H:16;             /* StopWatch Count High */
  } B;
} FR_STPWHR_tag;

typedef union FR_STPWLR_union_tag {    /* Stop Watch Count Low Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_L:16;             /* StopWatch Count Low */
  } B;
} FR_STPWLR_tag;

typedef union FR_PEOER_union_tag {     /* Protocol Event Output Enable and StopWatch Control Register */
  vuint16_t R;
  struct {
    vuint16_t CYC_EE:1;
    vuint16_t TIM1_EE:1;
    vuint16_t TIM2_EE:1;
    vuint16_t _unused_3:5;
    vuint16_t STPW_EN:1;               /* Stopwatch count Enable */
    vuint16_t _unused_9:7;
  } B;
} FR_PEOER_tag;

typedef union FR_RFSDOR_union_tag {    /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FR_RFSDOR_tag;

typedef union FR_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;
  } B;
} FR_RFSYMBADHR_tag;

typedef union FR_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;
    vuint16_t SMBA:12;
  } B;
} FR_RFSYMBADLR_tag;

typedef union FR_RFPTR_union_tag {     /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t PTD:14;
    vuint16_t _unused_14:2;
  } B;
} FR_RFPTR_tag;

typedef union FR_RFFLPCR_union_tag {   /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLA_or_PCA:8;
    vuint16_t FLB_or_PCB:8;
  } B;
} FR_RFFLPCR_tag;

typedef union FR_EEIFER_union_tag {    /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t DRCE_IE:1;
    vuint16_t DRNE_IE:1;
    vuint16_t LRCE_IE:1;
    vuint16_t LRNE_IE:1;
    vuint16_t _unused_4:4;
    vuint16_t DRCE_IF:1;
    vuint16_t DRNE_IF:1;
    vuint16_t LRCE_IF:1;
    vuint16_t LRNE_IF:1;
    vuint16_t DRCE_OF:1;
    vuint16_t DRNE_OF:1;
    vuint16_t LRCE_OF:1;
    vuint16_t LRNE_OF:1;
  } B;
} FR_EEIFER_tag;

typedef union FR_EERICR_union_tag {    /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t EIE:1;
    vuint16_t EIM:1;
    vuint16_t _unused_2:2;
    vuint16_t ERM:1;
    vuint16_t _unused_5:3;
    vuint16_t ERS:2;
    vuint16_t _unused_10:5;
    vuint16_t BSY:1;
  } B;
} FR_EERICR_tag;

typedef union FR_EERAR_union_tag {     /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t ADDR:12;
    vuint16_t BANK:3;
    vuint16_t MID:1;
  } B;
} FR_EERAR_tag;

typedef union FR_EERDR_union_tag {     /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EERDR_tag;

typedef union FR_EERCR_union_tag {     /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t CODE:5;
    vuint16_t _unused_5:11;
  } B;
} FR_EERCR_tag;

typedef union FR_EEIAR_union_tag {     /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t ADDR:12;
    vuint16_t BANK:3;
    vuint16_t MID:1;
  } B;
} FR_EEIAR_tag;

typedef union FR_EEIDR_union_tag {     /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EEIDR_tag;

typedef union FR_EEICR_union_tag {     /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t CODE:5;
    vuint16_t _unused_5:11;
  } B;
} FR_EEICR_tag;

typedef union FR_MB_CCSR_union_tag {   /* Message Buffer Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t MBIF:1;
    vuint16_t LCKS:1;
    vuint16_t EDS:1;
    vuint16_t DVAL:1;
    vuint16_t DUP:1;
    vuint16_t _unused_5:3;
    vuint16_t MBIE:1;
    vuint16_t LCKT:1;
    vuint16_t EDT:1;
    vuint16_t CMT:1;
    vuint16_t MTD:1;
    vuint16_t _unused_13:3;
  } B;
} FR_MB_CCSR_tag;

typedef union FR_MB_CCFR_union_tag {   /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t CCFVAL:6;
    vuint16_t CCFMSK:6;
    vuint16_t CCFE:1;
    vuint16_t CHB:1;
    vuint16_t CHA:1;
    vuint16_t MTM:1;
  } B;
} FR_MB_CCFR_tag;

typedef union FR_MB_FIDR_union_tag {   /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t FID:11;
    vuint16_t _unused_11:5;
  } B;
} FR_MB_FIDR_tag;

typedef union FR_MB_IDXR_union_tag {   /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t MBIDX:8;
    vuint16_t _unused_8:8;
  } B;
} FR_MB_IDXR_tag;

typedef struct FR_MB_struct_tag {
  FR_MB_CCSR_tag CCSR;                 /* Message Buffer Configuration, Control, Status Register */
  FR_MB_CCFR_tag CCFR;                 /* Message Buffer Cycle Counter Filter Register */
  FR_MB_FIDR_tag FIDR;                 /* Message Buffer Frame ID Register */
  FR_MB_IDXR_tag IDXR;                 /* Message Buffer Index Register */
} FR_MB_tag;

typedef union FR_MBDOR_union_tag {     /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;
  } B;
} FR_MBDOR_tag;

typedef union FR_LEETR_union_tag {     /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;
  } B;
} FR_LEETR_tag;

struct FR_tag {
  FR_MVR_tag MVR;                      /* Module Version Register */
  FR_MCR_tag MCR;                      /* Module Configuration Register */
  FR_SYMBADHR_tag SYMBADHR;            /* System Memory Base Address High Register */
  FR_SYMBADLR_tag SYMBADLR;            /* System Memory Base Address Low Register */
  FR_STBSCR_tag STBSCR;                /* Strobe Signal Control Register */
  uint8_t FR_reserved0[2];
  FR_MBDSR_tag MBDSR;                  /* Message Buffer Data Size Register */
  FR_MBSSUTR_tag MBSSUTR;              /* Message Buffer Segment Size and Utilization Register */
  FR_PEDRAR_tag PEDRAR;                /* PE DRAM Access Register */
  FR_PEDRDR_tag PEDRDR;                /* PE DRAM Data Register */
  FR_POCR_tag POCR;                    /* Protocol Operation Control Register */
  FR_GIFER_tag GIFER;                  /* Global Interrupt Flag and Enable Register */
  FR_PIFR0_tag PIFR0;                  /* Protocol Interrupt Flag Register 0 */
  FR_PIFR1_tag PIFR1;                  /* Protocol Interrupt Flag Register 1 */
  FR_PIER0_tag PIER0;                  /* Protocol Interrupt Enable Register 0 */
  FR_PIER1_tag PIER1;                  /* Protocol Interrupt Enable Register 1 */
  FR_CHIERFR_tag CHIERFR;              /* CHI Error Flag Register */
  FR_MBIVEC_tag MBIVEC;                /* Message Buffer Interrupt Vector Register */
  FR_CASERCR_tag CASERCR;              /* Channel A Status Error Counter Register */
  FR_CBSERCR_tag CBSERCR;              /* Channel B Status Error Counter Register */
  FR_PSR0_tag PSR0;                    /* Protocol Status Register 0 */
  FR_PSR1_tag PSR1;                    /* Protocol Status Register 1 */
  FR_PSR2_tag PSR2;                    /* Protocol Status Register 2 */
  FR_PSR3_tag PSR3;                    /* Protocol Status Register 3 */
  FR_MTCTR_tag MTCTR;                  /* Macrotick Counter Register */
  FR_CYCTR_tag CYCTR;                  /* Cycle Counter Register */
  FR_SLTCTAR_tag SLTCTAR;              /* Slot Counter Channel A Register */
  FR_SLTCTBR_tag SLTCTBR;              /* Slot Counter Channel B Register */
  FR_RTCORVR_tag RTCORVR;              /* Rate Correction Value Register */
  FR_OFCORVR_tag OFCORVR;              /* Offset Correction Value Register */
  FR_CIFR_tag CIFR;                    /* Combined Interrupt Flag Register */
  FR_SYMATOR_tag SYMATOR;              /* System Memory Access Time-Out Register */
  FR_SFCNTR_tag SFCNTR;                /* Sync Frame Counter Register */
  FR_SFTOR_tag SFTOR;                  /* Sync Frame Table Offset Register */
  FR_SFTCCSR_tag SFTCCSR;              /* Sync Frame Table Configuration, Control, Status Register */
  FR_SFIDRFR_tag SFIDRFR;              /* Sync Frame ID Rejection Filter Register */
  FR_SFIDAFVR_tag SFIDAFVR;            /* Sync Frame ID Acceptance Filter Value Register */
  FR_SFIDAFMR_tag SFIDAFMR;            /* Sync Frame ID Acceptance Filter Mask Register */
  FR_NMVR_tag NMVR[6];                 /* Network Management Vector Register */
  FR_NMVLR_tag NMVLR;                  /* Network Management Vector Length Register */
  FR_TICCR_tag TICCR;                  /* Timer Configuration and Control Register */
  FR_TI1CYSR_tag TI1CYSR;              /* Timer 1 Cycle Set Register */
  FR_TI1MTOR_tag TI1MTOR;              /* Timer 1 Macrotick Offset Register */
  FR_TI2CR0_tag TI2CR0;
  FR_TI2CR1_tag TI2CR1;
  FR_SSSR_tag SSSR;                    /* Slot Status Selection Register */
  FR_SSCCR_tag SSCCR;                  /* Slot Status Counter Condition Register */
  FR_SSR_tag SSR[8];                   /* Slot Status Register */
  FR_SSCR_tag SSCR[4];                 /* Slot Status Counter Register */
  FR_MTSACFR_tag MTSACFR;              /* MTS A Configuration Register */
  FR_MTSBCFR_tag MTSBCFR;              /* MTS B Configuration Register */
  FR_RSBIR_tag RSBIR;                  /* Receive Shadow Buffer Index Register */
  FR_RFWMSR_tag RFWMSR;                /* Receive FIFO Watermark and Selection Register */
  FR_RFSIR_tag RFSIR;                  /* Receive FIFO Start Index Register */
  FR_RFDSR_tag RFDSR;                  /* Receive FIFO Depth and Size Register */
  FR_RFARIR_tag RFARIR;                /* Receive FIFO A Read Index Register */
  FR_RFBRIR_tag RFBRIR;                /* Receive FIFO B Read Index Register */
  FR_RFMIDAFVR_tag RFMIDAFVR;          /* Receive FIFO Message ID Acceptance Filter Value Register */
  FR_RFMIDAFMR_tag RFMIDAFMR;          /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FR_RFFIDRFVR_tag RFFIDRFVR;          /* Receive FIFO Frame ID Rejection Filter Value Register */
  FR_RFFIDRFMR_tag RFFIDRFMR;          /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FR_RFRFCFR_tag RFRFCFR;              /* Receive FIFO Range Filter Configuration Register */
  FR_RFRFCTR_tag RFRFCTR;              /* Receive FIFO Range Filter Control Register */
  FR_LDTXSLAR_tag LDTXSLAR;            /* Last Dynamic Transmit Slot Channel A Register */
  FR_LDTXSLBR_tag LDTXSLBR;            /* Last Dynamic Transmit Slot Channel B Register */
  FR_PCR0_tag PCR0;                    /* Protocol Configuration Register 0 */
  FR_PCR1_tag PCR1;                    /* Protocol Configuration Register 1 */
  FR_PCR2_tag PCR2;                    /* Protocol Configuration Register 2 */
  FR_PCR3_tag PCR3;                    /* Protocol Configuration Register 3 */
  FR_PCR4_tag PCR4;                    /* Protocol Configuration Register 4 */
  FR_PCR5_tag PCR5;                    /* Protocol Configuration Register 5 */
  FR_PCR6_tag PCR6;                    /* Protocol Configuration Register 6 */
  FR_PCR7_tag PCR7;                    /* Protocol Configuration Register 7 */
  FR_PCR8_tag PCR8;                    /* Protocol Configuration Register 8 */
  FR_PCR9_tag PCR9;                    /* Protocol Configuration Register 9 */
  FR_PCR10_tag PCR10;                  /* Protocol Configuration Register 10 */
  FR_PCR11_tag PCR11;                  /* Protocol Configuration Register 11 */
  FR_PCR12_tag PCR12;                  /* Protocol Configuration Register 12 */
  FR_PCR13_tag PCR13;                  /* Protocol Configuration Register 13 */
  FR_PCR14_tag PCR14;                  /* Protocol Configuration Register 14 */
  FR_PCR15_tag PCR15;                  /* Protocol Configuration Register 15 */
  FR_PCR16_tag PCR16;                  /* Protocol Configuration Register 16 */
  FR_PCR17_tag PCR17;                  /* Protocol Configuration Register 17 */
  FR_PCR18_tag PCR18;                  /* Protocol Configuration Register 18 */
  FR_PCR19_tag PCR19;                  /* Protocol Configuration Register 19 */
  FR_PCR20_tag PCR20;                  /* Protocol Configuration Register 20 */
  FR_PCR21_tag PCR21;                  /* Protocol Configuration Register 21 */
  FR_PCR22_tag PCR22;                  /* Protocol Configuration Register 22 */
  FR_PCR23_tag PCR23;                  /* Protocol Configuration Register 23 */
  FR_PCR24_tag PCR24;                  /* Protocol Configuration Register 24 */
  FR_PCR25_tag PCR25;                  /* Protocol Configuration Register 25 */
  FR_PCR26_tag PCR26;                  /* Protocol Configuration Register 26 */
  FR_PCR27_tag PCR27;                  /* Protocol Configuration Register 27 */
  FR_PCR28_tag PCR28;                  /* Protocol Configuration Register 28 */
  FR_PCR29_tag PCR29;                  /* Protocol Configuration Register 29 */
  FR_PCR30_tag PCR30;                  /* Protocol Configuration Register 30 */
  FR_STPWHR_tag STPWHR;                /* StopWatch Count High Register */
  FR_STPWLR_tag STPWLR;                /* Stop Watch Count Low Register */
  FR_PEOER_tag PEOER;                  /* Protocol Event Output Enable and StopWatch Control Register */
  uint8_t FR_reserved1[2];
  FR_RFSDOR_tag RFSDOR;                /* Receive FIFO Start Data Offset Register */
  FR_RFSYMBADHR_tag RFSYMBADHR;        /* Receive FIFO System Memory Base Address High Register */
  FR_RFSYMBADLR_tag RFSYMBADLR;        /* Receive FIFO System Memory Base Address Low Register */
  FR_RFPTR_tag RFPTR;                  /* Receive FIFO Periodic Timer Register */
  FR_RFFLPCR_tag RFFLPCR;              /* Receive FIFO Fill Level and POP Count Register */
  FR_EEIFER_tag EEIFER;                /* ECC Error Interrupt Flag and Enable Register */
  FR_EERICR_tag EERICR;                /* ECC Error Report and Injection Control Register */
  FR_EERAR_tag EERAR;                  /* ECC Error Report Address Register */
  FR_EERDR_tag EERDR;                  /* ECC Error Report Data Register */
  FR_EERCR_tag EERCR;                  /* ECC Error Report Code Register */
  FR_EEIAR_tag EEIAR;                  /* ECC Error Injection Address Register */
  FR_EEIDR_tag EEIDR;                  /* ECC Error Injection Data Register */
  FR_EEICR_tag EEICR;                  /* ECC Error Injection Code Register */
  uint8_t FR_reserved2[1792];
  FR_MB_tag MB[128];
  uint8_t FR_reserved3[1024];
  FR_MBDOR_tag MBDOR[132];             /* Message Buffer Data Field Offset Register */
  FR_LEETR_tag LEETR[6];               /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: FTM ================================
   ============================================================================ */

typedef union FTM_SC_union_tag {       /* Status And Control */
  vuint32_t R;
  struct {
    vuint32_t PS:3;                    /* Prescale Factor Selection */
    vuint32_t CLKS:2;                  /* Clock Source Selection */
    vuint32_t CPWMS:1;                 /* Center-Aligned PWM Select */
    vuint32_t TOIE:1;                  /* Timer Overflow Interrupt Enable */
    vuint32_t TOF:1;                   /* Timer Overflow Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_SC_tag;

typedef union FTM_CNT_union_tag {      /* Counter */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Counter Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_CNT_tag;

typedef union FTM_MOD_union_tag {      /* Modulo */
  vuint32_t R;
  struct {
    vuint32_t MOD:16;
    vuint32_t _unused_16:16;
  } B;
} FTM_MOD_tag;

typedef union FTM_CONTROLS_CSC_union_tag { /* Channel (n) Status And Control */
  vuint32_t R;
  struct {
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t ICRST:1;                 /* FTM counter reset by the selected input capture event. */
    vuint32_t ELSA:1;                  /* Edge or Level Select */
    vuint32_t ELSB:1;                  /* Edge or Level Select */
    vuint32_t MSA:1;                   /* Channel Mode Select */
    vuint32_t MSB:1;                   /* Channel Mode Select */
    vuint32_t CHIE:1;                  /* Channel Interrupt Enable */
    vuint32_t CHF:1;                   /* Channel Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_CONTROLS_CSC_tag;

typedef union FTM_CONTROLS_CV_union_tag { /* Channel (n) Value */
  vuint32_t R;
  struct {
    vuint32_t VAL:16;                  /* Channel Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_CONTROLS_CV_tag;

typedef struct FTM_CONTROLS_struct_tag {
  FTM_CONTROLS_CSC_tag CSC;            /* Channel (n) Status And Control */
  FTM_CONTROLS_CV_tag CV;              /* Channel (n) Value */
} FTM_CONTROLS_tag;

typedef union FTM_CNTIN_union_tag {    /* Counter Initial Value */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_16:16;
  } B;
} FTM_CNTIN_tag;

typedef union FTM_STATUS_union_tag {   /* Capture And Compare Status */
  vuint32_t R;
  struct {
    vuint32_t CH0F:1;                  /* Channel 0 Flag */
    vuint32_t CH1F:1;                  /* Channel 1 Flag */
    vuint32_t CH2F:1;                  /* Channel 2 Flag */
    vuint32_t CH3F:1;                  /* Channel 3 Flag */
    vuint32_t CH4F:1;                  /* Channel 4 Flag */
    vuint32_t CH5F:1;                  /* Channel 5 Flag */
    vuint32_t CH6F:1;                  /* Channel 6 Flag */
    vuint32_t CH7F:1;                  /* Channel 7 Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_STATUS_tag;

typedef union FTM_MODE_union_tag {     /* Features Mode Selection */
  vuint32_t R;
  struct {
    vuint32_t FTMEN:1;                 /* FTM Enable */
    vuint32_t INIT:1;                  /* Initialize The Channels Output */
    vuint32_t WPDIS:1;                 /* Write Protection Disable */
    vuint32_t PWMSYNC:1;               /* PWM Synchronization Mode */
    vuint32_t CAPTEST:1;               /* Capture Test Mode Enable */
    vuint32_t FAULTM:2;                /* Fault Control Mode */
    vuint32_t FAULTIE:1;               /* Fault Interrupt Enable */
    vuint32_t _unused_8:24;
  } B;
} FTM_MODE_tag;

typedef union FTM_SYNC_union_tag {     /* Synchronization */
  vuint32_t R;
  struct {
    vuint32_t CNTMIN:1;                /* Minimum Loading Point Enable */
    vuint32_t CNTMAX:1;                /* Maximum Loading Point Enable */
    vuint32_t REINIT:1;                /* FTM Counter Reinitialization By Synchronization (FTM counter synchronization) */
    vuint32_t SYNCHOM:1;               /* Output Mask Synchronization */
    vuint32_t TRIG0:1;                 /* PWM Synchronization Hardware Trigger 0 */
    vuint32_t TRIG1:1;                 /* PWM Synchronization Hardware Trigger 1 */
    vuint32_t TRIG2:1;                 /* PWM Synchronization Hardware Trigger 2 */
    vuint32_t SWSYNC:1;                /* PWM Synchronization Software Trigger */
    vuint32_t _unused_8:24;
  } B;
} FTM_SYNC_tag;

typedef union FTM_OUTINIT_union_tag {  /* Initial State For Channels Output */
  vuint32_t R;
  struct {
    vuint32_t CH0OI:1;                 /* Channel 0 Output Initialization Value */
    vuint32_t CH1OI:1;                 /* Channel 1 Output Initialization Value */
    vuint32_t CH2OI:1;                 /* Channel 2 Output Initialization Value */
    vuint32_t CH3OI:1;                 /* Channel 3 Output Initialization Value */
    vuint32_t CH4OI:1;                 /* Channel 4 Output Initialization Value */
    vuint32_t CH5OI:1;                 /* Channel 5 Output Initialization Value */
    vuint32_t CH6OI:1;                 /* Channel 6 Output Initialization Value */
    vuint32_t CH7OI:1;                 /* Channel 7 Output Initialization Value */
    vuint32_t _unused_8:24;
  } B;
} FTM_OUTINIT_tag;

typedef union FTM_OUTMASK_union_tag {  /* Output Mask */
  vuint32_t R;
  struct {
    vuint32_t CH0OM:1;                 /* Channel 0 Output Mask */
    vuint32_t CH1OM:1;                 /* Channel 1 Output Mask */
    vuint32_t CH2OM:1;                 /* Channel 2 Output Mask */
    vuint32_t CH3OM:1;                 /* Channel 3 Output Mask */
    vuint32_t CH4OM:1;                 /* Channel 4 Output Mask */
    vuint32_t CH5OM:1;                 /* Channel 5 Output Mask */
    vuint32_t CH6OM:1;                 /* Channel 6 Output Mask */
    vuint32_t CH7OM:1;                 /* Channel 7 Output Mask */
    vuint32_t _unused_8:24;
  } B;
} FTM_OUTMASK_tag;

typedef union FTM_COMBINE_union_tag {  /* Function For Linked Channels */
  vuint32_t R;
  struct {
    vuint32_t COMBINE0:1;              /* Combine Channels For n = 0 */
    vuint32_t COMP0:1;                 /* Complement Of Channel (n) For n = 0 */
    vuint32_t DECAPEN0:1;              /* Dual Edge Capture Mode Enable For n = 0 */
    vuint32_t DECAP0:1;                /* Dual Edge Capture Mode Captures For n = 0 */
    vuint32_t DTEN0:1;                 /* Deadtime Enable For n = 0 */
    vuint32_t SYNCEN0:1;               /* Synchronization Enable For n = 0 */
    vuint32_t FAULTEN0:1;              /* Fault Control Enable For n = 0 */
    vuint32_t _unused_7:1;
    vuint32_t COMBINE1:1;              /* Combine Channels For n = 2 */
    vuint32_t COMP1:1;                 /* Complement Of Channel (n) For n = 2 */
    vuint32_t DECAPEN1:1;              /* Dual Edge Capture Mode Enable For n = 2 */
    vuint32_t DECAP1:1;                /* Dual Edge Capture Mode Captures For n = 2 */
    vuint32_t DTEN1:1;                 /* Deadtime Enable For n = 2 */
    vuint32_t SYNCEN1:1;               /* Synchronization Enable For n = 2 */
    vuint32_t FAULTEN1:1;              /* Fault Control Enable For n = 2 */
    vuint32_t _unused_15:1;
    vuint32_t COMBINE2:1;              /* Combine Channels For n = 4 */
    vuint32_t COMP2:1;                 /* Complement Of Channel (n) For n = 4 */
    vuint32_t DECAPEN2:1;              /* Dual Edge Capture Mode Enable For n = 4 */
    vuint32_t DECAP2:1;                /* Dual Edge Capture Mode Captures For n = 4 */
    vuint32_t DTEN2:1;                 /* Deadtime Enable For n = 4 */
    vuint32_t SYNCEN2:1;               /* Synchronization Enable For n = 4 */
    vuint32_t FAULTEN2:1;              /* Fault Control Enable For n = 4 */
    vuint32_t _unused_23:1;
    vuint32_t COMBINE3:1;              /* Combine Channels For n = 6 */
    vuint32_t COMP3:1;                 /* Complement Of Channel (n) for n = 6 */
    vuint32_t DECAPEN3:1;              /* Dual Edge Capture Mode Enable For n = 6 */
    vuint32_t DECAP3:1;                /* Dual Edge Capture Mode Captures For n = 6 */
    vuint32_t DTEN3:1;                 /* Deadtime Enable For n = 6 */
    vuint32_t SYNCEN3:1;               /* Synchronization Enable For n = 6 */
    vuint32_t FAULTEN3:1;              /* Fault Control Enable For n = 6 */
    vuint32_t _unused_31:1;
  } B;
} FTM_COMBINE_tag;

typedef union FTM_DEADTIME_union_tag { /* Deadtime Insertion Control */
  vuint32_t R;
  struct {
    vuint32_t DTVAL:6;                 /* Deadtime Value */
    vuint32_t DTPS:2;                  /* Deadtime Prescaler Value */
    vuint32_t _unused_8:24;
  } B;
} FTM_DEADTIME_tag;

typedef union FTM_EXTTRIG_union_tag {  /* FTM External Trigger */
  vuint32_t R;
  struct {
    vuint32_t CH2TRIG:1;               /* Channel 2 Trigger Enable */
    vuint32_t CH3TRIG:1;               /* Channel 3 Trigger Enable */
    vuint32_t CH4TRIG:1;               /* Channel 4 Trigger Enable */
    vuint32_t CH5TRIG:1;               /* Channel 5 Trigger Enable */
    vuint32_t CH0TRIG:1;               /* Channel 0 Trigger Enable */
    vuint32_t CH1TRIG:1;               /* Channel 1 Trigger Enable */
    vuint32_t INITTRIGEN:1;            /* Initialization Trigger Enable */
    vuint32_t TRIGF:1;                 /* Channel Trigger Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_EXTTRIG_tag;

typedef union FTM_POL_union_tag {      /* Channels Polarity */
  vuint32_t R;
  struct {
    vuint32_t POL0:1;                  /* Channel 0 Polarity */
    vuint32_t POL1:1;                  /* Channel 1 Polarity */
    vuint32_t POL2:1;                  /* Channel 2 Polarity */
    vuint32_t POL3:1;                  /* Channel 3 Polarity */
    vuint32_t POL4:1;                  /* Channel 4 Polarity */
    vuint32_t POL5:1;                  /* Channel 5 Polarity */
    vuint32_t POL6:1;                  /* Channel 6 Polarity */
    vuint32_t POL7:1;                  /* Channel 7 Polarity */
    vuint32_t _unused_8:24;
  } B;
} FTM_POL_tag;

typedef union FTM_FMS_union_tag {      /* Fault Mode Status */
  vuint32_t R;
  struct {
    vuint32_t FAULTF0:1;               /* Fault Detection Flag 0 */
    vuint32_t FAULTF1:1;               /* Fault Detection Flag 1 */
    vuint32_t FAULTF2:1;               /* Fault Detection Flag 2 */
    vuint32_t FAULTF3:1;               /* Fault Detection Flag 3 */
    vuint32_t _unused_4:1;
    vuint32_t FAULTIN:1;               /* Fault Inputs */
    vuint32_t WPEN:1;                  /* Write Protection Enable */
    vuint32_t FAULTF:1;                /* Fault Detection Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_FMS_tag;

typedef union FTM_FILTER_union_tag {   /* Input Capture Filter Control */
  vuint32_t R;
  struct {
    vuint32_t CH0FVAL:4;               /* Channel 0 Input Filter */
    vuint32_t CH1FVAL:4;               /* Channel 1 Input Filter */
    vuint32_t CH2FVAL:4;               /* Channel 2 Input Filter */
    vuint32_t CH3FVAL:4;               /* Channel 3 Input Filter */
    vuint32_t _unused_16:16;
  } B;
} FTM_FILTER_tag;

typedef union FTM_FLTCTRL_union_tag {  /* Fault Control */
  vuint32_t R;
  struct {
    vuint32_t FAULT0EN:1;              /* Fault Input 0 Enable */
    vuint32_t FAULT1EN:1;              /* Fault Input 1 Enable */
    vuint32_t FAULT2EN:1;              /* Fault Input 2 Enable */
    vuint32_t FAULT3EN:1;              /* Fault Input 3 Enable */
    vuint32_t FFLTR0EN:1;              /* Fault Input 0 Filter Enable */
    vuint32_t FFLTR1EN:1;              /* Fault Input 1 Filter Enable */
    vuint32_t FFLTR2EN:1;              /* Fault Input 2 Filter Enable */
    vuint32_t FFLTR3EN:1;              /* Fault Input 3 Filter Enable */
    vuint32_t FFVAL:4;                 /* Fault Input Filter */
    vuint32_t _unused_12:20;
  } B;
} FTM_FLTCTRL_tag;

typedef union FTM_QDCTRL_union_tag {   /* Quadrature Decoder Control And Status */
  vuint32_t R;
  struct {
    vuint32_t QUADEN:1;                /* Quadrature Decoder Mode Enable */
    vuint32_t TOFDIR:1;                /* Timer Overflow Direction In Quadrature Decoder Mode */
    vuint32_t QUADIR:1;                /* FTM Counter Direction In Quadrature Decoder Mode */
    vuint32_t QUADMODE:1;              /* Quadrature Decoder Mode */
    vuint32_t PHBPOL:1;                /* Phase B Input Polarity */
    vuint32_t PHAPOL:1;                /* Phase A Input Polarity */
    vuint32_t PHBFLTREN:1;             /* Phase B Input Filter Enable */
    vuint32_t PHAFLTREN:1;             /* Phase A Input Filter Enable */
    vuint32_t _unused_8:24;
  } B;
} FTM_QDCTRL_tag;

typedef union FTM_CONF_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t NUMTOF:5;                /* TOF Frequency */
    vuint32_t _unused_5:1;
    vuint32_t BDMMODE:2;               /* BDM Mode */
    vuint32_t _unused_8:1;
    vuint32_t GTBEEN:1;                /* Global Time Base Enable */
    vuint32_t GTBEOUT:1;               /* Global Time Base Output */
    vuint32_t _unused_11:21;
  } B;
} FTM_CONF_tag;

typedef union FTM_FLTPOL_union_tag {   /* FTM Fault Input Polarity */
  vuint32_t R;
  struct {
    vuint32_t FLT0POL:1;               /* Fault Input 0 Polarity */
    vuint32_t FLT1POL:1;               /* Fault Input 1 Polarity */
    vuint32_t FLT2POL:1;               /* Fault Input 2 Polarity */
    vuint32_t FLT3POL:1;               /* Fault Input 3 Polarity */
    vuint32_t _unused_4:28;
  } B;
} FTM_FLTPOL_tag;

typedef union FTM_SYNCONF_union_tag {  /* Synchronization Configuration */
  vuint32_t R;
  struct {
    vuint32_t HWTRIGMODE:1;            /* Hardware Trigger Mode */
    vuint32_t _unused_1:1;
    vuint32_t CNTINC:1;                /* CNTIN Register Synchronization */
    vuint32_t _unused_3:1;
    vuint32_t INVC:1;                  /* INVCTRL Register Synchronization */
    vuint32_t SWOC:1;                  /* SWOCTRL Register Synchronization */
    vuint32_t _unused_6:1;
    vuint32_t SYNCMODE:1;              /* Synchronization Mode */
    vuint32_t SWRSTCNT:1;
    vuint32_t SWWRBUF:1;
    vuint32_t SWOM:1;
    vuint32_t SWINVC:1;
    vuint32_t SWSOC:1;
    vuint32_t _unused_13:3;
    vuint32_t HWRSTCNT:1;
    vuint32_t HWWRBUF:1;
    vuint32_t HWOM:1;
    vuint32_t HWINVC:1;
    vuint32_t HWSOC:1;
    vuint32_t _unused_21:11;
  } B;
} FTM_SYNCONF_tag;

typedef union FTM_INVCTRL_union_tag {  /* FTM Inverting Control */
  vuint32_t R;
  struct {
    vuint32_t INV0EN:1;                /* Pair Channels 0 Inverting Enable */
    vuint32_t INV1EN:1;                /* Pair Channels 1 Inverting Enable */
    vuint32_t INV2EN:1;                /* Pair Channels 2 Inverting Enable */
    vuint32_t INV3EN:1;                /* Pair Channels 3 Inverting Enable */
    vuint32_t _unused_4:28;
  } B;
} FTM_INVCTRL_tag;

typedef union FTM_SWOCTRL_union_tag {  /* FTM Software Output Control */
  vuint32_t R;
  struct {
    vuint32_t CH0OC:1;                 /* Channel 0 Software Output Control Enable */
    vuint32_t CH1OC:1;                 /* Channel 1 Software Output Control Enable */
    vuint32_t CH2OC:1;                 /* Channel 2 Software Output Control Enable */
    vuint32_t CH3OC:1;                 /* Channel 3 Software Output Control Enable */
    vuint32_t CH4OC:1;                 /* Channel 4 Software Output Control Enable */
    vuint32_t CH5OC:1;                 /* Channel 5 Software Output Control Enable */
    vuint32_t CH6OC:1;                 /* Channel 6 Software Output Control Enable */
    vuint32_t CH7OC:1;                 /* Channel 7 Software Output Control Enable */
    vuint32_t CH0OCV:1;                /* Channel 0 Software Output Control Value */
    vuint32_t CH1OCV:1;                /* Channel 1 Software Output Control Value */
    vuint32_t CH2OCV:1;                /* Channel 2 Software Output Control Value */
    vuint32_t CH3OCV:1;                /* Channel 3 Software Output Control Value */
    vuint32_t CH4OCV:1;                /* Channel 4 Software Output Control Value */
    vuint32_t CH5OCV:1;                /* Channel 5 Software Output Control Value */
    vuint32_t CH6OCV:1;                /* Channel 6 Software Output Control Value */
    vuint32_t CH7OCV:1;                /* Channel 7 Software Output Control Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_SWOCTRL_tag;

typedef union FTM_PWMLOAD_union_tag {  /* FTM PWM Load */
  vuint32_t R;
  struct {
    vuint32_t CH0SEL:1;                /* Channel 0 Select */
    vuint32_t CH1SEL:1;                /* Channel 1 Select */
    vuint32_t CH2SEL:1;                /* Channel 2 Select */
    vuint32_t CH3SEL:1;                /* Channel 3 Select */
    vuint32_t CH4SEL:1;                /* Channel 4 Select */
    vuint32_t CH5SEL:1;                /* Channel 5 Select */
    vuint32_t CH6SEL:1;                /* Channel 6 Select */
    vuint32_t CH7SEL:1;                /* Channel 7 Select */
    vuint32_t _unused_8:1;
    vuint32_t LDOK:1;                  /* Load Enable */
    vuint32_t _unused_10:22;
  } B;
} FTM_PWMLOAD_tag;

struct FTM_tag {
  FTM_SC_tag SC;                       /* Status And Control */
  FTM_CNT_tag CNT;                     /* Counter */
  FTM_MOD_tag MOD;                     /* Modulo */
  FTM_CONTROLS_tag CONTROLS[8];
  FTM_CNTIN_tag CNTIN;                 /* Counter Initial Value */
  FTM_STATUS_tag STATUS;               /* Capture And Compare Status */
  FTM_MODE_tag MODE;                   /* Features Mode Selection */
  FTM_SYNC_tag SYNC;                   /* Synchronization */
  FTM_OUTINIT_tag OUTINIT;             /* Initial State For Channels Output */
  FTM_OUTMASK_tag OUTMASK;             /* Output Mask */
  FTM_COMBINE_tag COMBINE;             /* Function For Linked Channels */
  FTM_DEADTIME_tag DEADTIME;           /* Deadtime Insertion Control */
  FTM_EXTTRIG_tag EXTTRIG;             /* FTM External Trigger */
  FTM_POL_tag POL;                     /* Channels Polarity */
  FTM_FMS_tag FMS;                     /* Fault Mode Status */
  FTM_FILTER_tag FILTER;               /* Input Capture Filter Control */
  FTM_FLTCTRL_tag FLTCTRL;             /* Fault Control */
  FTM_QDCTRL_tag QDCTRL;               /* Quadrature Decoder Control And Status */
  FTM_CONF_tag CONF;                   /* Configuration */
  FTM_FLTPOL_tag FLTPOL;               /* FTM Fault Input Polarity */
  FTM_SYNCONF_tag SYNCONF;             /* Synchronization Configuration */
  FTM_INVCTRL_tag INVCTRL;             /* FTM Inverting Control */
  FTM_SWOCTRL_tag SWOCTRL;             /* FTM Software Output Control */
  FTM_PWMLOAD_tag PWMLOAD;             /* FTM PWM Load */
};


/* ============================================================================
   =============================== Module: FXOSC ==============================
   ============================================================================ */

typedef union FXOSC_CTL_union_tag {    /* FXOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:2;
    vuint32_t GM_SEL:3;                /* Crystal overdrive protection */
    vuint32_t I_OSC:1;
    vuint32_t _unused_8:5;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t MISC_IN1:1;              /* Miscellaneous input 1 */
    vuint32_t _unused_25:4;
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t OSCBYP:1;
  } B;
} FXOSC_CTL_tag;

struct FXOSC_tag {
  FXOSC_CTL_tag CTL;                   /* FXOSC Control Register */
};


/* ============================================================================
   =============================== Module: H264_DEC ===========================
   ============================================================================ */

typedef union H264_DEC_MCR_union_tag { /* MODULE CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t SW_RESET:1;              /* Software Reset */
    vuint32_t VO_BUF_0_RSTRT:1;        /* Video Output Buffer 0 restart */
    vuint32_t VO_BUF_1_RSTRT:1;        /* Video Output Buffer 1 Restart */
    vuint32_t VO_BUF_2_RSTRT:1;        /* Video Output Buffer 2 Restart */
    vuint32_t VO_BUF_3_RSTRT:1;        /* Video Ouput Buffer 3 Restart */
    vuint32_t _unused_5:3;
    vuint32_t VO_BIT_WIDTH_STR_0:1;    /* Video Output Bit Width Stream 0 */
    vuint32_t VO_BIT_WIDTH_STR_1:1;    /* Video Output Bit Width Stream 1 */
    vuint32_t VO_BIT_WIDTH_STR_2:1;    /* Video Output Bit Width Stream 2 */
    vuint32_t VO_BIT_WIDTH_STR_3:1;    /* Video Output Bit Width Stream 3 */
    vuint32_t _unused_12:4;
    vuint32_t DATA_FLOW_MODE:2;        /* Data Flow Mode */
    vuint32_t _unused_18:2;
    vuint32_t VO_COLOR_FMT_STR_0:1;    /* Video Output Color Format Stream 0 */
    vuint32_t VO_COLOR_FMT_STR_1:1;    /* Video Output Color Format Stream 1 */
    vuint32_t VO_COLOR_FMT_STR_2:1;    /* Video Output Color Format Stream 2 */
    vuint32_t VO_COLOR_FMT_STR_3:1;    /* Video Output Color Format Stream 3 */
    vuint32_t DATA_MODE_CHR:1;         /* Data mode Chroma */
    vuint32_t _unused_25:3;
    vuint32_t CLR_IPS_FIFO_0:1;        /* Clear IPS FIFO Stream 0 */
    vuint32_t CLR_IPS_FIFO_1:1;        /* Clear IPS FIFO Stream 1 */
    vuint32_t CLR_IPS_FIFO_2:1;        /* Clear IPS FIFO Stream 2 */
    vuint32_t CLR_IPS_FIFO_3:1;        /* Clear IPS FIFO Stream 3 */
  } B;
} H264_DEC_MCR_tag;

typedef union H264_DEC_TIMEOUT_CFG_union_tag { /* TIMEOUT CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL:16;                  /* Value */
    vuint32_t _unused_16:12;
    vuint32_t EN_STR_0:1;              /* Enable Stream 0 */
    vuint32_t EN_STR_1:1;              /* Enable Stream 1 */
    vuint32_t EN_STR_2:1;              /* Enable Stream 2 */
    vuint32_t EN_STR_3:1;              /* Enable Stream 3 */
  } B;
} H264_DEC_TIMEOUT_CFG_tag;

typedef union H264_DEC_STR_VCR_STR_VCR_union_tag { /* STREAM VIDEO CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t FR_WIDTH:8;              /* Frame Width */
    vuint32_t _unused_12:8;
    vuint32_t FR_HEIGHT:8;             /* Frame Height */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_STR_VCR_STR_VCR_tag;

typedef struct H264_DEC_STR_VCR_struct_tag {
  H264_DEC_STR_VCR_STR_VCR_tag STR_VCR; /* STREAM VIDEO CONFIGURATION REGISTER */
} H264_DEC_STR_VCR_tag;

typedef union H264_DEC_STR_PKT_ADDR_union_tag { /* STREAM PACKET ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR:22;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_STR_PKT_ADDR_tag;

typedef union H264_DEC_STR_TRIG_PKT_CFG_union_tag { /* STREAM TRIGGER AND PACKET CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_PKT_LTH:15;          /* Stream Packet Length */
    vuint32_t _unused_15:15;
    vuint32_t STR_NUM:2;               /* Stream number */
  } B;
} H264_DEC_STR_TRIG_PKT_CFG_tag;

typedef union H264_DEC_STR_PKT_FIFO_WMRK_union_tag { /* STREAM PACKET FIFO WATERMARK REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_0:8;                 /* Stream 0 */
    vuint32_t STR_1:8;                 /* Stream 1 */
    vuint32_t STR_2:8;                 /* Stream 2 */
    vuint32_t STR_3:8;                 /* Stream 3 */
  } B;
} H264_DEC_STR_PKT_FIFO_WMRK_tag;

typedef union H264_DEC_STR_01_PKT_FIFO_STAT_union_tag { /* STREAM 0 and 1 PACKET FIFO STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_0_LVL:8;             /* Stream 0 Level */
    vuint32_t STR_1_LVL:8;             /* Stream 1 Level */
    vuint32_t STR_0_ACTIV_LOC:8;       /* Stream 0 FIFO Active Location */
    vuint32_t STR_1_ACTIV_LOC:8;       /* Stream 1 Active Location */
  } B;
} H264_DEC_STR_01_PKT_FIFO_STAT_tag;

typedef union H264_DEC_STR_23_PKT_FIFO_STAT_union_tag { /* STREAM 2 and 3 PACKET FIFO STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_2_LVL:8;             /* Stream 2 Level */
    vuint32_t STR_3_LVL:8;             /* Stream 2 Level */
    vuint32_t STR_2_ACTIV_LOC:8;       /* Stream 2 Active Location */
    vuint32_t STR_3_ACTIV_LOC:8;       /* Stream 3 Active Location */
  } B;
} H264_DEC_STR_23_PKT_FIFO_STAT_tag;

typedef union H264_DEC_STR_0_PKT_STATUS_STR_0_PKT_STATUS_union_tag { /* STREAM 0 PACKET STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR_OFFSET:16;          /* Address offset */
    vuint32_t _unused_16:15;
    vuint32_t _unused_31:1;
  } B;
} H264_DEC_STR_0_PKT_STATUS_STR_0_PKT_STATUS_tag;

typedef struct H264_DEC_STR_0_PKT_STATUS_struct_tag {
  H264_DEC_STR_0_PKT_STATUS_STR_0_PKT_STATUS_tag STR_0_PKT_STATUS; /* STREAM 0 PACKET STATUS REGISTER */
} H264_DEC_STR_0_PKT_STATUS_tag;

typedef union H264_DEC_STR_1_PKT_STATUS_STR_1_PKT_STATUS_union_tag { /* STREAM 1 PACKET STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR_OFFSET:16;          /* Address offset */
    vuint32_t _unused_16:15;
    vuint32_t _unused_31:1;
  } B;
} H264_DEC_STR_1_PKT_STATUS_STR_1_PKT_STATUS_tag;

typedef struct H264_DEC_STR_1_PKT_STATUS_struct_tag {
  H264_DEC_STR_1_PKT_STATUS_STR_1_PKT_STATUS_tag STR_1_PKT_STATUS; /* STREAM 1 PACKET STATUS REGISTER */
} H264_DEC_STR_1_PKT_STATUS_tag;

typedef union H264_DEC_STR_2_PKT_STATUS_STR_2_PKT_STATUS_union_tag { /* STREAM 2 PACKET STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR_OFFSET:16;          /* Address offset */
    vuint32_t _unused_16:15;
    vuint32_t _unused_31:1;
  } B;
} H264_DEC_STR_2_PKT_STATUS_STR_2_PKT_STATUS_tag;

typedef struct H264_DEC_STR_2_PKT_STATUS_struct_tag {
  H264_DEC_STR_2_PKT_STATUS_STR_2_PKT_STATUS_tag STR_2_PKT_STATUS; /* STREAM 2 PACKET STATUS REGISTER */
} H264_DEC_STR_2_PKT_STATUS_tag;

typedef union H264_DEC_STR_3_PKT_STATUS_STR_3_PKT_STATUS_union_tag { /* STREAM 3 PACKET STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR_OFFSET:16;          /* Address offset */
    vuint32_t _unused_16:15;
    vuint32_t _unused_31:1;
  } B;
} H264_DEC_STR_3_PKT_STATUS_STR_3_PKT_STATUS_tag;

typedef struct H264_DEC_STR_3_PKT_STATUS_struct_tag {
  H264_DEC_STR_3_PKT_STATUS_STR_3_PKT_STATUS_tag STR_3_PKT_STATUS; /* STREAM 3 PACKET STATUS REGISTER */
} H264_DEC_STR_3_PKT_STATUS_tag;

typedef union H264_DEC_VO_STR0_Y_ADDR_union_tag { /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR0_Y_ADDR_tag;

typedef union H264_DEC_VO_STR0_CB_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR0_CB_ADDR_tag;

typedef union H264_DEC_VO_STR0_CR_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR0_CR_ADDR_tag;

typedef union H264_DEC_VO_STR0_NRLINES_union_tag { /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  vuint32_t R;
  struct {
    vuint32_t Y_LINES:16;              /* Luma Lines */
    vuint32_t _unused_16:16;
  } B;
} H264_DEC_VO_STR0_NRLINES_tag;

typedef union H264_DEC_VO_STR1_Y_ADDR_union_tag { /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR1_Y_ADDR_tag;

typedef union H264_DEC_VO_STR1_CB_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR1_CB_ADDR_tag;

typedef union H264_DEC_VO_STR1_CR_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR1_CR_ADDR_tag;

typedef union H264_DEC_VO_STR1_NRLINES_union_tag { /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  vuint32_t R;
  struct {
    vuint32_t Y_LINES:16;              /* Luma Lines */
    vuint32_t _unused_16:16;
  } B;
} H264_DEC_VO_STR1_NRLINES_tag;

typedef union H264_DEC_VO_STR2_Y_ADDR_union_tag { /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR2_Y_ADDR_tag;

typedef union H264_DEC_VO_STR2_CB_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR2_CB_ADDR_tag;

typedef union H264_DEC_VO_STR2_CR_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR2_CR_ADDR_tag;

typedef union H264_DEC_VO_STR2_NRLINES_union_tag { /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  vuint32_t R;
  struct {
    vuint32_t Y_LINES:16;              /* Luma Lines */
    vuint32_t _unused_16:16;
  } B;
} H264_DEC_VO_STR2_NRLINES_tag;

typedef union H264_DEC_VO_STR3_Y_ADDR_union_tag { /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR3_Y_ADDR_tag;

typedef union H264_DEC_VO_STR3_CB_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR3_CB_ADDR_tag;

typedef union H264_DEC_VO_STR3_CR_ADDR_union_tag { /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Address */
    vuint32_t _unused_22:10;
  } B;
} H264_DEC_VO_STR3_CR_ADDR_tag;

typedef union H264_DEC_VO_STR3_NRLINES_union_tag { /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  vuint32_t R;
  struct {
    vuint32_t Y_LINES:16;              /* Luma Lines */
    vuint32_t _unused_16:16;
  } B;
} H264_DEC_VO_STR3_NRLINES_tag;

typedef union H264_DEC_RATE_FLOW_CNTRL_union_tag { /* RATE FLOW CONTROL REGISTER */
  vuint32_t R;
  struct {
    vuint32_t BANK_STRIDE_LTH:3;       /* Bank Stride Length */
    vuint32_t _unused_3:28;
    vuint32_t EN:1;                    /* Enable */
  } B;
} H264_DEC_RATE_FLOW_CNTRL_tag;

typedef union H264_DEC_LINE_CNT_STAT_union_tag { /* LINE COUNT STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_0:8;                 /* Stream 0 */
    vuint32_t STR_1:8;                 /* Stream 1 */
    vuint32_t STR_2:8;                 /* Stream 2 */
    vuint32_t STR_3:8;                 /* Stream 3 */
  } B;
} H264_DEC_LINE_CNT_STAT_tag;

typedef union H264_DEC_STAT_union_tag { /* STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STR_0_TIMED_OUT:1;       /* Stream 0 Timed Out */
    vuint32_t STR_1_TIMED_OUT:1;       /* Stream 1 Timed Out */
    vuint32_t STR_2_TIMED_OUT:1;       /* Stream 2 Timed Out */
    vuint32_t STR_3_TIMED_OUT:1;       /* Stream 3 Timed Out */
    vuint32_t _unused_4:28;
  } B;
} H264_DEC_STAT_tag;

typedef union H264_DEC_ISR_union_tag { /* INTERRUPT STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t EOF_0_INT:1;             /* End of frame Interrupt for stream 0 */
    vuint32_t EOF_1_INT:1;             /* End of frame for Interrupt stream 1 */
    vuint32_t EOF_2_INT:1;             /* End of frame Interrupt for stream 2 */
    vuint32_t EOF_3_INT:1;             /* End of frame Interrupt for stream 3 */
    vuint32_t MBROW_DONE_0_INT:1;      /* Macroblock row done Interrupt for stream 0 */
    vuint32_t MBROW_DONE_1_INT:1;      /* Macroblock row done Interrupt for stream 1 */
    vuint32_t MBROW_DONE_2_INT:1;      /* Macroblock row done Interrupt for stream 2 */
    vuint32_t MBROW_DONE_3_INT:1;      /* Macroblock row done Interrupt for stream 3 */
    vuint32_t STR_0_PKT_FIFO_WE_INT:1; /* Stream 0 Packet Fifo Watermark Enabled Interrupt */
    vuint32_t STR_1_PKT_FIFO_WE_INT:1; /* Stream 1 Packet Fifo Watermark Enabled Interrupt */
    vuint32_t STR_2_PKT_FIFO_WE_INT:1; /* Stream 2 Packet Fifo Watermark Enabled Interrupt */
    vuint32_t STR_3_PKT_FIFO_WE_INT:1; /* Stream 3 Packet Fifo Watermark Enabled Interrupt */
    vuint32_t DEC_OOS_STR_0_INT:1;     /* Decoder Out of Synch Stream 0 Interrupt */
    vuint32_t DEC_OOS_STR_1_INT:1;     /* Decoder Out of Synch Stream 1 Interrupt */
    vuint32_t DEC_OOS_STR_2_INT:1;     /* Decoder Out of Synch Stream 2 Interrupt */
    vuint32_t DEC_OOS_STR_3_INT:1;     /* Decoder Out of Synch Stream 3 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_0_INT:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 0 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_1_INT:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 1 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_2_INT:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 2 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_3_INT:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 3 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_0_INT:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 0 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_1_INT:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 1 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_2_INT:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 2 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_3_INT:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 3 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_0_INT:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 0 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_1_INT:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 1 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_2_INT:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 2 Interrupt */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_3_INT:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 3 Interrupt */
    vuint32_t _unused_28:2;
    vuint32_t STR_TIMED_OUT_INT:1;     /* Stream Timed Out Interrupt */
    vuint32_t ERR_REQ_INT:1;           /* Error Request Interrupt */
  } B;
} H264_DEC_ISR_tag;

typedef union H264_DEC_IER_union_tag { /* INTERRUPT ENABLE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t EOF_0_EN:1;              /* End of Frame Stream 0 Interrupt Enable */
    vuint32_t EOF_1_EN:1;              /* End of Frame Stream 1 Interrupt Enable */
    vuint32_t EOF_2_EN:1;              /* End of Frame Stream 2 Interrupt Enable */
    vuint32_t EOF_3_EN:1;              /* End of Frame Stream 3 Interrupt Enable */
    vuint32_t MBROW_DONE_0_EN:1;       /* Macroblock Row Done Stream 0 Interrupt Enable */
    vuint32_t MBROW_DONE_1_EN:1;       /* Macroblock Row Done Stream 1 Interrupt Enable */
    vuint32_t MBROW_DONE_2_EN:1;       /* Macroblock Row Done Stream 2 Interrupt Enable */
    vuint32_t MBROW_DONE_3_EN:1;       /* Macroblock Row Done Stream 3 Interrupt Enable */
    vuint32_t STR_0_PKT_FIFO_WE_EN:1;  /* Stream 0 Packet FIFO Watermark Enabled Interrupt enable */
    vuint32_t STR_1_PKT_FIFO_WE_EN:1;  /* Stream 1 Packet FIFO Watermark Enabled Interrupt enable */
    vuint32_t STR_2_PKT_FIFO_WE_EN:1;  /* Stream 2 Packet FIFO Watermark Enabled Interrupt enable */
    vuint32_t STR_3_PKT_FIFO_WE_EN:1;  /* Stream 3 Packet FIFO Watermark Enabled Interrupt enable */
    vuint32_t DEC_OOS_STR_0_EN:1;      /* Decoder Out of Synch Stream 0 Interrupt Enable */
    vuint32_t DEC_OOS_STR_1_EN:1;      /* Decoder Out of Synch Stream 1 Interrupt Enable */
    vuint32_t DEC_OOS_STR_2_EN:1;      /* Decoder Out of Synch Stream 2 Interrupt Enable */
    vuint32_t DEC_OOS_STR_3_EN:1;      /* Decoder Out of Synch Stream 3 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_0_EN:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 0 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_1_EN:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 1 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_2_EN:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 2 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_0_CH_3_EN:1; /* Frame Cycle Counter Greater than Threshold 0 of Channel 3 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_0_EN:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 0 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_1_EN:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 1 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_2_EN:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 2 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_1_CH_3_EN:1; /* Frame Cycle Counter Greater than Threshold 1 of Channel 3 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_0_EN:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 0 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_1_EN:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 1 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_2_EN:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 2 Interrupt Enable */
    vuint32_t FRM_CYC_CNT_GRT_THR_2_CH_3_EN:1; /* Frame Cycle Counter Greater than Threshold 2 of Channel 3 Interrupt Enable */
    vuint32_t _unused_28:2;
    vuint32_t STR_TIMED_OUT_EN:1;      /* Stream Timed Out Interrupt Enable */
    vuint32_t ERR_REQ_EN:1;            /* Error Request Interrupt Enable */
  } B;
} H264_DEC_IER_tag;

typedef union H264_DEC_TESTLINE_CFG_union_tag { /* TESTLINE CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STRT_LOC:12;             /* Start Location */
    vuint32_t _unused_12:19;
    vuint32_t EN:1;                    /* Enable */
  } B;
} H264_DEC_TESTLINE_CFG_tag;

typedef union H264_DEC_TESTLINE_PXL_LOC_union_tag { /* TESTLINE PIXEL LOCATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t LOC_1:8;                 /* Location 1 */
    vuint32_t _unused_12:8;
    vuint32_t LOC_2:8;                 /* Location 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_PXL_LOC_tag;

typedef union H264_DEC_TESTLINE_STR0_LUMA_VAL_union_tag { /* TESTLINE STREAM LUMA PIXEL VALUE */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR0_LUMA_VAL_tag;

typedef union H264_DEC_TESTLINE_STR0_CB_VAL_union_tag { /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR0_CB_VAL_tag;

typedef union H264_DEC_TESTLINE_STR0_CR_VAL_union_tag { /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR0_CR_VAL_tag;

typedef union H264_DEC_TESTLINE_STR1_LUMA_VAL_union_tag { /* TESTLINE STREAM LUMA PIXEL VALUE */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR1_LUMA_VAL_tag;

typedef union H264_DEC_TESTLINE_STR1_CB_VAL_union_tag { /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR1_CB_VAL_tag;

typedef union H264_DEC_TESTLINE_STR1_CR_VAL_union_tag { /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR1_CR_VAL_tag;

typedef union H264_DEC_TESTLINE_STR2_LUMA_VAL_union_tag { /* TESTLINE STREAM LUMA PIXEL VALUE */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR2_LUMA_VAL_tag;

typedef union H264_DEC_TESTLINE_STR2_CB_VAL_union_tag { /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR2_CB_VAL_tag;

typedef union H264_DEC_TESTLINE_STR2_CR_VAL_union_tag { /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR2_CR_VAL_tag;

typedef union H264_DEC_TESTLINE_STR3_LUMA_VAL_union_tag { /* TESTLINE STREAM LUMA PIXEL VALUE */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR3_LUMA_VAL_tag;

typedef union H264_DEC_TESTLINE_STR3_CB_VAL_union_tag { /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR3_CB_VAL_tag;

typedef union H264_DEC_TESTLINE_STR3_CR_VAL_union_tag { /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* Value 1 */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Value 2 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_TESTLINE_STR3_CR_VAL_tag;

typedef union H264_DEC_ELLVC_CFG_union_tag { /* ELLVC CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t DBF_FORCE_OFF:1;         /* Deblocking Filter Force Off */
    vuint32_t _unused_1:7;
    vuint32_t USE_SRAM_DDR:1;          /* Use SRAM or DDR */
    vuint32_t _unused_9:15;
    vuint32_t STOP_CH_0:1;             /* Stop Channel 0 */
    vuint32_t STOP_CH_1:1;             /* Stop Channel 1 */
    vuint32_t STOP_CH_2:1;             /* Stop Channel 2 */
    vuint32_t STOP_CH_3:1;             /* Stop Channel 3 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_CFG_tag;

typedef union H264_DEC_ELLVC_REF_ADDR_CH_ELLVC_REF_ADDR_CH_union_tag { /* ELLVC REFERENCE ADDRESS CHANNEL REGISTER */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;                 /* Address */
  } B;
} H264_DEC_ELLVC_REF_ADDR_CH_ELLVC_REF_ADDR_CH_tag;

typedef struct H264_DEC_ELLVC_REF_ADDR_CH_struct_tag {
  H264_DEC_ELLVC_REF_ADDR_CH_ELLVC_REF_ADDR_CH_tag ELLVC_REF_ADDR_CH; /* ELLVC REFERENCE ADDRESS CHANNEL REGISTER */
} H264_DEC_ELLVC_REF_ADDR_CH_tag;

typedef union H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_ELLVC_DBG_FRAME_CYC_CNT_THR_union_tag { /* ELLVC DEBUG FRAME CYCLE COUNTER THRESHOLD REGISTER */
  vuint32_t R;
  struct {
    vuint32_t VAL:32;                  /* Value */
  } B;
} H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_ELLVC_DBG_FRAME_CYC_CNT_THR_tag;

typedef struct H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_struct_tag {
  H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_ELLVC_DBG_FRAME_CYC_CNT_THR_tag ELLVC_DBG_FRAME_CYC_CNT_THR; /* ELLVC DEBUG FRAME CYCLE COUNTER THRESHOLD REGISTER */
} H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_tag;

typedef union H264_DEC_ELLVC_STATE_union_tag { /* ELLVC STATE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:5;                  /* Channel 0 */
    vuint32_t _unused_5:3;
    vuint32_t CH_1:5;                  /* Channel 1 */
    vuint32_t _unused_13:3;
    vuint32_t CH_2:5;                  /* Channel 2 */
    vuint32_t _unused_21:3;
    vuint32_t CH_3:5;                  /* Channel 3 */
    vuint32_t _unused_29:3;
  } B;
} H264_DEC_ELLVC_STATE_tag;

typedef union H264_DEC_ELLVC_PIC_BIT_union_tag { /* ELLVC PIC BIT REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:2;                  /* Channel 0 */
    vuint32_t _unused_2:6;
    vuint32_t CH_1:2;                  /* Channel 1 */
    vuint32_t _unused_10:6;
    vuint32_t CH_2:2;                  /* Channel 2 */
    vuint32_t _unused_18:6;
    vuint32_t CH_3:2;                  /* Channel 3 */
    vuint32_t _unused_26:6;
  } B;
} H264_DEC_ELLVC_PIC_BIT_tag;

typedef union H264_DEC_ELLVC_PIC_WIDTH_IN_MBS_union_tag { /* ELLVC PIC WIDTH IN MBS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:8;                  /* Channel 0 */
    vuint32_t CH_1:8;                  /* Channel 1 */
    vuint32_t CH_2:8;                  /* Channel 2 */
    vuint32_t CH_3:8;                  /* Channel 3 */
  } B;
} H264_DEC_ELLVC_PIC_WIDTH_IN_MBS_tag;

typedef union H264_DEC_ELLVC_PIC_HEIGHT_IN_MBS_union_tag { /* ELLVC PIC HEIGHT IN MBS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:8;                  /* Channel 0 */
    vuint32_t CH_1:8;                  /* Channel 1 */
    vuint32_t CH_2:8;                  /* Channel 2 */
    vuint32_t CH_3:8;                  /* Channel 3 */
  } B;
} H264_DEC_ELLVC_PIC_HEIGHT_IN_MBS_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_LEFT_CH_01_union_tag { /* ELLVC PIC CROP LEFT CHANNEL 0, 1 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:12;                 /* Channel 0 */
    vuint32_t _unused_12:4;
    vuint32_t CH_1:12;                 /* Channel 1 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_LEFT_CH_01_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_LEFT_CH_23_union_tag { /* ELLVC PIC CROP LEFT CHANNEL 2, 3 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_2:12;                 /* Channel 2 */
    vuint32_t _unused_12:4;
    vuint32_t CH_3:12;                 /* Channel 3 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_LEFT_CH_23_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_RGHT_CH_01_union_tag { /* ELLVC PIC CROP RIGHT CHANNEL 0, 1 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:12;                 /* Channel 0 */
    vuint32_t _unused_12:4;
    vuint32_t CH_1:12;                 /* Channel 1 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_RGHT_CH_01_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_RGHT_CH_23_union_tag { /* ELLVC PIC CROP RIGHT CHANNEL 2, 3 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_2:12;                 /* Channel 2 */
    vuint32_t _unused_12:4;
    vuint32_t CH_3:12;                 /* Channel 3 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_RGHT_CH_23_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_TOP_CH_01_union_tag { /* ELLVC PIC CROP TOP CHANNEL 0, 1 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:12;                 /* Channel 0 */
    vuint32_t _unused_12:4;
    vuint32_t CH_1:12;                 /* Channel 1 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_TOP_CH_01_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_TOP_CH_23_union_tag { /* ELLVC PIC CROP TOP CHANNEL 2, 3 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_2:12;                 /* Channel 2 */
    vuint32_t _unused_12:4;
    vuint32_t CH_3:12;                 /* Channel 3 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_TOP_CH_23_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_BTTM_CH_01_union_tag { /* ELLVC PIC CROP BOTTOM CHANNEL 0, 1 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:12;                 /* Channel 0 */
    vuint32_t _unused_12:4;
    vuint32_t CH_1:12;                 /* Channel 1 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_BTTM_CH_01_tag;

typedef union H264_DEC_ELLVC_PIC_CROP_BTTM_CH_23_union_tag { /* ELLVC PIC CROP BOTTOM CHANNEL 2, 3 REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_2:12;                 /* Channel 2 */
    vuint32_t _unused_12:4;
    vuint32_t CH_3:12;                 /* Channel 3 */
    vuint32_t _unused_28:4;
  } B;
} H264_DEC_ELLVC_PIC_CROP_BTTM_CH_23_tag;

typedef union H264_DEC_ELLVC_PIC_PARAM_VLD_union_tag { /* ELLVC PIC PARAM VALID REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:1;                  /* Channel 0 */
    vuint32_t _unused_1:7;
    vuint32_t CH_1:1;                  /* Channel 1 */
    vuint32_t _unused_9:7;
    vuint32_t CH_2:1;                  /* Channel 2 */
    vuint32_t _unused_17:7;
    vuint32_t CH_3:1;                  /* Channel 3 */
    vuint32_t _unused_25:7;
  } B;
} H264_DEC_ELLVC_PIC_PARAM_VLD_tag;

typedef union H264_DEC_ELLVC_POC_VALUE_union_tag { /* ELLVC PICTURE ORDER COUNT VALUE REGISTER */
  vuint32_t R;
  struct {
    vuint32_t CH_0:32;                 /* Channel 0 */
  } B;
} H264_DEC_ELLVC_POC_VALUE_tag;

typedef union H264_DEC_ELLVC_STAT_union_tag { /* ELLVC STATUS REGISTER */
  vuint32_t R;
  struct {
    vuint32_t MAX_NUM_REF_FRM_CH_0:5;  /* Maximun Number Reference Frame Channel 0 */
    vuint32_t _unused_5:12;
    vuint32_t NEW_POC_CYC_CH_0:1;      /* New Picture Order Count Cycle Channel 0 */
    vuint32_t _unused_18:14;
  } B;
} H264_DEC_ELLVC_STAT_tag;

struct H264_DEC_tag {
  H264_DEC_MCR_tag MCR;                /* MODULE CONFIGURATION REGISTER */
  uint32_t H264_DEC_reserved0[3];
  H264_DEC_TIMEOUT_CFG_tag TIMEOUT_CFG; /* TIMEOUT CONFIGURATION REGISTER */
  uint32_t H264_DEC_reserved1[11];
  H264_DEC_STR_VCR_tag STR_VCR[4];
  uint32_t H264_DEC_reserved2[16];
  H264_DEC_STR_PKT_ADDR_tag STR_PKT_ADDR; /* STREAM PACKET ADDRESS REGISTER */
  uint32_t H264_DEC_reserved3[3];
  H264_DEC_STR_TRIG_PKT_CFG_tag STR_TRIG_PKT_CFG; /* STREAM TRIGGER AND PACKET CONFIGURATION REGISTER */
  uint32_t H264_DEC_reserved4[3];
  H264_DEC_STR_PKT_FIFO_WMRK_tag STR_PKT_FIFO_WMRK; /* STREAM PACKET FIFO WATERMARK REGISTER */
  uint32_t H264_DEC_reserved5[7];
  H264_DEC_STR_01_PKT_FIFO_STAT_tag STR_01_PKT_FIFO_STAT; /* STREAM 0 and 1 PACKET FIFO STATUS REGISTER */
  uint32_t H264_DEC_reserved6[3];
  H264_DEC_STR_23_PKT_FIFO_STAT_tag STR_23_PKT_FIFO_STAT; /* STREAM 2 and 3 PACKET FIFO STATUS REGISTER */
  uint32_t H264_DEC_reserved7[11];
  H264_DEC_STR_0_PKT_STATUS_tag STR_0_PKT_STATUS[16];
  uint32_t H264_DEC_reserved8[64];
  H264_DEC_STR_1_PKT_STATUS_tag STR_1_PKT_STATUS[16];
  uint32_t H264_DEC_reserved9[64];
  H264_DEC_STR_2_PKT_STATUS_tag STR_2_PKT_STATUS[16];
  uint32_t H264_DEC_reserved10[64];
  H264_DEC_STR_3_PKT_STATUS_tag STR_3_PKT_STATUS[16];
  uint32_t H264_DEC_reserved11[240];
  H264_DEC_VO_STR0_Y_ADDR_tag VO_STR0_Y_ADDR; /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  uint32_t H264_DEC_reserved12[3];
  H264_DEC_VO_STR0_CB_ADDR_tag VO_STR0_CB_ADDR; /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  uint32_t H264_DEC_reserved13[3];
  H264_DEC_VO_STR0_CR_ADDR_tag VO_STR0_CR_ADDR; /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  uint32_t H264_DEC_reserved14[3];
  H264_DEC_VO_STR0_NRLINES_tag VO_STR0_NRLINES; /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  uint32_t H264_DEC_reserved15[3];
  H264_DEC_VO_STR1_Y_ADDR_tag VO_STR1_Y_ADDR; /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  uint32_t H264_DEC_reserved16[3];
  H264_DEC_VO_STR1_CB_ADDR_tag VO_STR1_CB_ADDR; /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  uint32_t H264_DEC_reserved17[3];
  H264_DEC_VO_STR1_CR_ADDR_tag VO_STR1_CR_ADDR; /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  uint32_t H264_DEC_reserved18[3];
  H264_DEC_VO_STR1_NRLINES_tag VO_STR1_NRLINES; /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  uint32_t H264_DEC_reserved19[3];
  H264_DEC_VO_STR2_Y_ADDR_tag VO_STR2_Y_ADDR; /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  uint32_t H264_DEC_reserved20[3];
  H264_DEC_VO_STR2_CB_ADDR_tag VO_STR2_CB_ADDR; /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  uint32_t H264_DEC_reserved21[3];
  H264_DEC_VO_STR2_CR_ADDR_tag VO_STR2_CR_ADDR; /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  uint32_t H264_DEC_reserved22[3];
  H264_DEC_VO_STR2_NRLINES_tag VO_STR2_NRLINES; /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  uint32_t H264_DEC_reserved23[3];
  H264_DEC_VO_STR3_Y_ADDR_tag VO_STR3_Y_ADDR; /* VIDEO OUTPUT STREAM LUMA ADDRESS REGISTER */
  uint32_t H264_DEC_reserved24[3];
  H264_DEC_VO_STR3_CB_ADDR_tag VO_STR3_CB_ADDR; /* VIDEO OUTPUT STREAM Cb ADDRESS REGISTER */
  uint32_t H264_DEC_reserved25[3];
  H264_DEC_VO_STR3_CR_ADDR_tag VO_STR3_CR_ADDR; /* VIDEO OUTPUT STREAM Cr ADDRESS REGISTER */
  uint32_t H264_DEC_reserved26[3];
  H264_DEC_VO_STR3_NRLINES_tag VO_STR3_NRLINES; /* VIDEO OUTPUT STREAM NUMBER OF LINES REGISTER */
  uint32_t H264_DEC_reserved27[35];
  H264_DEC_RATE_FLOW_CNTRL_tag RATE_FLOW_CNTRL; /* RATE FLOW CONTROL REGISTER */
  uint32_t H264_DEC_reserved28[31];
  H264_DEC_LINE_CNT_STAT_tag LINE_CNT_STAT; /* LINE COUNT STATUS REGISTER */
  uint32_t H264_DEC_reserved29[3];
  H264_DEC_STAT_tag STAT;              /* STATUS REGISTER */
  uint32_t H264_DEC_reserved30[91];
  H264_DEC_ISR_tag ISR;                /* INTERRUPT STATUS REGISTER */
  uint32_t H264_DEC_reserved31[3];
  H264_DEC_IER_tag IER;                /* INTERRUPT ENABLE REGISTER */
  uint32_t H264_DEC_reserved32[27];
  H264_DEC_TESTLINE_CFG_tag TESTLINE_CFG; /* TESTLINE CONFIGURATION REGISTER */
  uint32_t H264_DEC_reserved33[3];
  H264_DEC_TESTLINE_PXL_LOC_tag TESTLINE_PXL_LOC; /* TESTLINE PIXEL LOCATION REGISTER */
  uint32_t H264_DEC_reserved34[11];
  H264_DEC_TESTLINE_STR0_LUMA_VAL_tag TESTLINE_STR0_LUMA_VAL; /* TESTLINE STREAM LUMA PIXEL VALUE */
  uint32_t H264_DEC_reserved35[3];
  H264_DEC_TESTLINE_STR0_CB_VAL_tag TESTLINE_STR0_CB_VAL; /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved36[3];
  H264_DEC_TESTLINE_STR0_CR_VAL_tag TESTLINE_STR0_CR_VAL; /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved37[7];
  H264_DEC_TESTLINE_STR1_LUMA_VAL_tag TESTLINE_STR1_LUMA_VAL; /* TESTLINE STREAM LUMA PIXEL VALUE */
  uint32_t H264_DEC_reserved38[3];
  H264_DEC_TESTLINE_STR1_CB_VAL_tag TESTLINE_STR1_CB_VAL; /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved39[3];
  H264_DEC_TESTLINE_STR1_CR_VAL_tag TESTLINE_STR1_CR_VAL; /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved40[7];
  H264_DEC_TESTLINE_STR2_LUMA_VAL_tag TESTLINE_STR2_LUMA_VAL; /* TESTLINE STREAM LUMA PIXEL VALUE */
  uint32_t H264_DEC_reserved41[3];
  H264_DEC_TESTLINE_STR2_CB_VAL_tag TESTLINE_STR2_CB_VAL; /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved42[3];
  H264_DEC_TESTLINE_STR2_CR_VAL_tag TESTLINE_STR2_CR_VAL; /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved43[7];
  H264_DEC_TESTLINE_STR3_LUMA_VAL_tag TESTLINE_STR3_LUMA_VAL; /* TESTLINE STREAM LUMA PIXEL VALUE */
  uint32_t H264_DEC_reserved44[3];
  H264_DEC_TESTLINE_STR3_CB_VAL_tag TESTLINE_STR3_CB_VAL; /* TESTLINE STREAM Cb PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved45[3];
  H264_DEC_TESTLINE_STR3_CR_VAL_tag TESTLINE_STR3_CR_VAL[1]; /* TESTLINE STREAM Cr PIXEL VALUE REGISTER */
  uint32_t H264_DEC_reserved46[183];
  H264_DEC_ELLVC_CFG_tag ELLVC_CFG;    /* ELLVC CONFIGURATION REGISTER */
  uint32_t H264_DEC_reserved47[15];
  H264_DEC_ELLVC_REF_ADDR_CH_tag ELLVC_REF_ADDR_CH[4];
  uint32_t H264_DEC_reserved48[16];
  H264_DEC_ELLVC_DBG_FRAME_CYC_CNT_THR_tag ELLVC_DBG_FRAME_CYC_CNT_THR[3];
  uint32_t H264_DEC_reserved49[36];
  H264_DEC_ELLVC_STATE_tag ELLVC_STATE; /* ELLVC STATE REGISTER */
  uint32_t H264_DEC_reserved50[3];
  H264_DEC_ELLVC_PIC_BIT_tag ELLVC_PIC_BIT; /* ELLVC PIC BIT REGISTER */
  uint32_t H264_DEC_reserved51[3];
  H264_DEC_ELLVC_PIC_WIDTH_IN_MBS_tag ELLVC_PIC_WIDTH_IN_MBS; /* ELLVC PIC WIDTH IN MBS REGISTER */
  uint32_t H264_DEC_reserved52[3];
  H264_DEC_ELLVC_PIC_HEIGHT_IN_MBS_tag ELLVC_PIC_HEIGHT_IN_MBS; /* ELLVC PIC HEIGHT IN MBS REGISTER */
  uint32_t H264_DEC_reserved53[3];
  H264_DEC_ELLVC_PIC_CROP_LEFT_CH_01_tag ELLVC_PIC_CROP_LEFT_CH_01; /* ELLVC PIC CROP LEFT CHANNEL 0, 1 REGISTER */
  uint32_t H264_DEC_reserved54[3];
  H264_DEC_ELLVC_PIC_CROP_LEFT_CH_23_tag ELLVC_PIC_CROP_LEFT_CH_23; /* ELLVC PIC CROP LEFT CHANNEL 2, 3 REGISTER */
  uint32_t H264_DEC_reserved55[3];
  H264_DEC_ELLVC_PIC_CROP_RGHT_CH_01_tag ELLVC_PIC_CROP_RGHT_CH_01; /* ELLVC PIC CROP RIGHT CHANNEL 0, 1 REGISTER */
  uint32_t H264_DEC_reserved56[3];
  H264_DEC_ELLVC_PIC_CROP_RGHT_CH_23_tag ELLVC_PIC_CROP_RGHT_CH_23; /* ELLVC PIC CROP RIGHT CHANNEL 2, 3 REGISTER */
  uint32_t H264_DEC_reserved57[3];
  H264_DEC_ELLVC_PIC_CROP_TOP_CH_01_tag ELLVC_PIC_CROP_TOP_CH_01; /* ELLVC PIC CROP TOP CHANNEL 0, 1 REGISTER */
  uint32_t H264_DEC_reserved58[3];
  H264_DEC_ELLVC_PIC_CROP_TOP_CH_23_tag ELLVC_PIC_CROP_TOP_CH_23; /* ELLVC PIC CROP TOP CHANNEL 2, 3 REGISTER */
  uint32_t H264_DEC_reserved59[3];
  H264_DEC_ELLVC_PIC_CROP_BTTM_CH_01_tag ELLVC_PIC_CROP_BTTM_CH_01; /* ELLVC PIC CROP BOTTOM CHANNEL 0, 1 REGISTER */
  uint32_t H264_DEC_reserved60[3];
  H264_DEC_ELLVC_PIC_CROP_BTTM_CH_23_tag ELLVC_PIC_CROP_BTTM_CH_23; /* ELLVC PIC CROP BOTTOM CHANNEL 2, 3 REGISTER */
  uint32_t H264_DEC_reserved61[3];
  H264_DEC_ELLVC_PIC_PARAM_VLD_tag ELLVC_PIC_PARAM_VLD; /* ELLVC PIC PARAM VALID REGISTER */
  uint32_t H264_DEC_reserved62[3];
  H264_DEC_ELLVC_POC_VALUE_tag ELLVC_POC_VALUE; /* ELLVC PICTURE ORDER COUNT VALUE REGISTER */
  uint32_t H264_DEC_reserved63[3];
  H264_DEC_ELLVC_STAT_tag ELLVC_STAT;  /* ELLVC STATUS REGISTER */
};


/* ============================================================================
   =============================== Module: H264_ENC ===========================
   ============================================================================ */

typedef union H264_ENC_MCR_union_tag { /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SW_RESET:1;
    vuint32_t _unused_1:3;
    vuint32_t VI_BUF_RESTART:1;        /* Video Input Buffer restart */
    vuint32_t OUT_BUF_RESTART:1;       /* Ouput Buffer restart */
    vuint32_t _unused_6:2;
    vuint32_t VI_BIT_WIDTH:2;          /* Video Input Bit Width */
    vuint32_t _unused_10:2;
    vuint32_t VI_COLOR_FMT:1;          /* Video Input Color Format */
    vuint32_t _unused_13:3;
    vuint32_t FETCH_TRIG:1;            /* Fetch Trigger */
    vuint32_t _unused_17:7;
    vuint32_t DATA_MODE_CHR:1;         /* Data Mode Chroma */
    vuint32_t _unused_25:7;
  } B;
} H264_ENC_MCR_tag;

typedef union H264_ENC_VCR_union_tag { /* Video Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t FR_WIDTH:11;             /* Frame Width */
    vuint32_t _unused_12:5;
    vuint32_t FR_HEIGHT:11;            /* Frame Height */
    vuint32_t _unused_28:4;
  } B;
} H264_ENC_VCR_tag;

typedef union H264_ENC_VI_ALARM_union_tag { /* Video Input Alarm Register */
  vuint32_t R;
  struct {
    vuint32_t MBRW_THLD:8;             /* Macroblock Row Threshold */
    vuint32_t _unused_8:8;
    vuint32_t MBRW_ALARM_THLD:8;       /* Macroblock row alarm threshold */
    vuint32_t _unused_24:8;
  } B;
} H264_ENC_VI_ALARM_tag;

typedef union H264_ENC_FETCH_MBRW_union_tag { /* Fetch Macroblock Row Register */
  vuint32_t R;
  struct {
    vuint32_t FETCH:1;                 /* Fetch Macroblock Row */
    vuint32_t _unused_1:31;
  } B;
} H264_ENC_FETCH_MBRW_tag;

typedef union H264_ENC_VI_CBUF_Y_ADDR_union_tag { /* Video Input Circular Buffer Luma Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_VI_CBUF_Y_ADDR_tag;

typedef union H264_ENC_VI_CBUF_CB_ADDR_union_tag { /* Video Input Circular Buffer Cb Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_VI_CBUF_CB_ADDR_tag;

typedef union H264_ENC_VI_CBUF_CR_ADDR_union_tag { /* Video Input Circular Buffer Cr Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_VI_CBUF_CR_ADDR_tag;

typedef union H264_ENC_VI_NRLINES_union_tag { /* Video Input Number of Lines Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t Y_LINES:7;               /* Y lines */
    vuint32_t _unused_8:24;
  } B;
} H264_ENC_VI_NRLINES_tag;

typedef union H264_ENC_RATE_FLOW_CTRL_union_tag { /* Rate Flow Control Register */
  vuint32_t R;
  struct {
    vuint32_t BANK_STRIDE_LTH:3;       /* Bank Stride Length */
    vuint32_t _unused_3:28;
    vuint32_t EN:1;                    /* Rate Flow Enable */
  } B;
} H264_ENC_RATE_FLOW_CTRL_tag;

typedef union H264_ENC_OUT_CBUF_START_ADDR_union_tag { /* Output Circular Buffer Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Circular Buffer Start Address */
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_OUT_CBUF_START_ADDR_tag;

typedef union H264_ENC_OUT_CBUF_END_ADDR_union_tag { /* Output Circular Buffer End Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Circular Buffer End Address */
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_OUT_CBUF_END_ADDR_tag;

typedef union H264_ENC_OUT_CBUF_ALARM_ADDR_union_tag { /* Ouput Circular Buffer Alarm Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Circular Buffer Alarm Address */
    vuint32_t WRAP:1;                  /* Circular Buffer Alarm Wrap */
    vuint32_t _unused_23:9;
  } B;
} H264_ENC_OUT_CBUF_ALARM_ADDR_tag;

typedef union H264_ENC_OUT_CBUF_CURR_ADDR_union_tag { /* Output Circular Buffer Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Circular Buffer Current Address */
    vuint32_t WRAP:1;                  /* Internal Wrap */
    vuint32_t _unused_23:9;
  } B;
} H264_ENC_OUT_CBUF_CURR_ADDR_tag;

typedef union H264_ENC_OUT_CBUF_VEND_ADDR_union_tag { /* Output Circular Buffer Vend Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:19;                 /* Circular Buffer Frame End Address */
    vuint32_t _unused_22:10;
  } B;
} H264_ENC_OUT_CBUF_VEND_ADDR_tag;

typedef union H264_ENC_LINE_CNTR_STAT_union_tag { /* Line Counter Status Register */
  vuint32_t R;
  struct {
    vuint32_t VAL:12;                  /* Line Counter Value. */
    vuint32_t _unused_12:20;
  } B;
} H264_ENC_LINE_CNTR_STAT_tag;

typedef union H264_ENC_ISR_union_tag { /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t VI_FRAME_DONE_INT:1;     /* Video Input Frame Done Interrupt */
    vuint32_t BS_NEW_ROW_INT:1;        /* Bitstream New Row Interrupt */
    vuint32_t CB_ALARM_INT:1;          /* Circular Buffer Alarm Interrupt */
    vuint32_t VI_LINE_INT:1;           /* Video Input Line Interrupt */
    vuint32_t VI_LCOUNT_ALARM_INT:1;   /* Video Input Line Count Alarm Interrupt */
    vuint32_t ENC_OOS_INT:1;           /* Encoder Out of Synch Interrupt */
    vuint32_t MBRW_DONE_INT:1;         /* Macroblock Row Done Interrupt */
    vuint32_t MBRW_FF_OVF_INT:1;       /* Macroblock Row Fifo Overflow Interrupt */
    vuint32_t BS_FRAME_DONE_INT:1;     /* Bitstream Frame Done Interrupt */
    vuint32_t OUT_CBUF_OVF_INT:1;      /* Output Circular Buffer Overflow Interrupt */
    vuint32_t BR_TOO_HIGH_INT:1;       /* Bitrate Too High Interrupt */
    vuint32_t BS_FIFO_ALMOST_FULL_INT:1; /* Bitstream Fifo Almost Full Interrupt */
    vuint32_t BS_FIFO_FULL_INT:1;      /* Bitstream Fifo Full Interrupt */
    vuint32_t _unused_13:19;
  } B;
} H264_ENC_ISR_tag;

typedef union H264_ENC_IER_union_tag { /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t VI_FRAME_DONE_INT_EN:1;  /* Video Input Frame Done Interrupt Enable */
    vuint32_t BS_NEW_ROW_INT_EN:1;     /* Bitstream New Row Interrupt Enable */
    vuint32_t CB_ALARM_INT_EN:1;       /* Circular Buffer Alarm Interrupt Enable */
    vuint32_t VI_LINE_INT_EN:1;        /* Video Input Line Interrupt Enable */
    vuint32_t VI_LCOUNT_ALARM_INT_EN:1; /* Video Input Line Count Alarm Interrupt Enable */
    vuint32_t ENC_OOS_INT_EN:1;        /* Encoder Out of Synch Interrupt Enable */
    vuint32_t MBRW_DONE_INT_EN:1;      /* Macroblock Row Done Interrupt Enable */
    vuint32_t MBRW_FF_OVF_EN:1;        /* Macroblock Row FIFO Overflow Interrupt Enable */
    vuint32_t BS_FRAME_DONE_INT_EN:1;  /* Bitstream Frame Done Interrupt Enable */
    vuint32_t OUT_CBUF_OVF_INT_EN:1;   /* Output Circular Buffer Overflow Interrupt Enable */
    vuint32_t BR_TOO_HIGH_INT_EN:1;    /* Bitrate Too High Interrupt Enable */
    vuint32_t BS_FIFO_ALMOST_FULL_INT_EN:1; /* Bitstream Fifo Almost Full Interrupt Enable */
    vuint32_t BS_FIFO_FULL_INT_EN:1;   /* Bitstream Fifo Full Interrupt Enable */
    vuint32_t _unused_13:19;
  } B;
} H264_ENC_IER_tag;

typedef union H264_ENC_TESTLINE_CFG_union_tag { /* Testline Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NR_W:6;                  /* Number of test-lines to be written */
    vuint32_t _unused_6:25;
    vuint32_t EN:1;
  } B;
} H264_ENC_TESTLINE_CFG_tag;

typedef union H264_ENC_TESTLINE_STRT_LOC_union_tag { /* Testline Start Location Register */
  vuint32_t R;
  struct {
    vuint32_t STRT_LOC:12;             /* Test line Number Start Value */
    vuint32_t _unused_12:20;
  } B;
} H264_ENC_TESTLINE_STRT_LOC_tag;

typedef union H264_ENC_TESTLINE_LUMA_VAL_union_tag { /* Testline Luma Value Register */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* First Value of the luma pixel */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Second value of the Luma Pixel */
    vuint32_t _unused_28:4;
  } B;
} H264_ENC_TESTLINE_LUMA_VAL_tag;

typedef union H264_ENC_TESTLINE_CB_VAL_union_tag { /* Testline Chroma Cb Value Register */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* First Value of the Cb pixel */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Second Value of the Cb Pixel */
    vuint32_t _unused_28:4;
  } B;
} H264_ENC_TESTLINE_CB_VAL_tag;

typedef union H264_ENC_TESTLINE_CR_VAL_union_tag { /* Testline Chroma Cr Value Register */
  vuint32_t R;
  struct {
    vuint32_t VAL_1:12;                /* First Value of the Cr pixel */
    vuint32_t _unused_12:4;
    vuint32_t VAL_2:12;                /* Second Value of the Cr Pixel */
    vuint32_t _unused_28:4;
  } B;
} H264_ENC_TESTLINE_CR_VAL_tag;

typedef union H264_ENC_ULLVC_FRAME_RATE_union_tag { /* ULLVC Frame Rate Register */
  vuint32_t R;
  struct {
    vuint32_t VAL:8;                   /* Value */
    vuint32_t _unused_8:24;
  } B;
} H264_ENC_ULLVC_FRAME_RATE_tag;

typedef union H264_ENC_ULLVC_QP_INIT_union_tag { /* ULLVC Quantization Parameter Initial Register */
  vuint32_t R;
  struct {
    vuint32_t INITIAL:7;               /* Initial */
    vuint32_t _unused_7:25;
  } B;
} H264_ENC_ULLVC_QP_INIT_tag;

typedef union H264_ENC_ULLVC_QP_RANGE_union_tag { /* ULLVC Quantization Parameter Range Register */
  vuint32_t R;
  struct {
    vuint32_t MIN:7;                   /* Minimum */
    vuint32_t _unused_7:9;
    vuint32_t MAX:7;                   /* Maximum */
    vuint32_t _unused_23:9;
  } B;
} H264_ENC_ULLVC_QP_RANGE_tag;

typedef union H264_ENC_ULLVC_BITS_PER_MB_ROW_union_tag { /* ULLVC Bits Per Macroblock Row Register */
  vuint32_t R;
  struct {
    vuint32_t BITRATE:31;              /* Bitrate */
    vuint32_t _unused_31:1;
  } B;
} H264_ENC_ULLVC_BITS_PER_MB_ROW_tag;

typedef union H264_ENC_ULLVC_QP_FALLBACK_LIMIT_union_tag { /* ULLVC Fallback QP Limit Register */
  vuint32_t R;
  struct {
    vuint32_t LIMIT:8;                 /* Limit */
    vuint32_t _unused_8:24;
  } B;
} H264_ENC_ULLVC_QP_FALLBACK_LIMIT_tag;

typedef union H264_ENC_ULLVC_QP_INC_union_tag { /* ULLVC Increment QP Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:7;                /* Offset */
    vuint32_t _unused_7:1;
    vuint32_t DIFF_0:7;                /* Increment QP Difference 0 */
    vuint32_t _unused_15:1;
    vuint32_t DIFF_1:7;                /* Increment QP Difference 1 */
    vuint32_t _unused_23:1;
    vuint32_t DIFF_2:7;                /* Difference 2 */
    vuint32_t _unused_31:1;
  } B;
} H264_ENC_ULLVC_QP_INC_tag;

typedef union H264_ENC_ULLVC_QP_INC_THLD_ULLVC_QP_INC_THLD_union_tag { /* ULLVC Increment Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THLD:31;                 /* Threshold */
    vuint32_t _unused_31:1;
  } B;
} H264_ENC_ULLVC_QP_INC_THLD_ULLVC_QP_INC_THLD_tag;

typedef struct H264_ENC_ULLVC_QP_INC_THLD_struct_tag {
  H264_ENC_ULLVC_QP_INC_THLD_ULLVC_QP_INC_THLD_tag ULLVC_QP_INC_THLD; /* ULLVC Increment Threshold Register */
} H264_ENC_ULLVC_QP_INC_THLD_tag;

typedef union H264_ENC_ULLVC_QP_DEC_union_tag { /* ULLVC Decrement QP Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:7;                /* Offset */
    vuint32_t _unused_7:1;
    vuint32_t DIFF_0:7;                /* Difference 0 */
    vuint32_t _unused_15:1;
    vuint32_t DIFF_1:7;                /* Difference 1 */
    vuint32_t _unused_23:1;
    vuint32_t DIFF_2:7;                /* Difference 2 */
    vuint32_t _unused_31:1;
  } B;
} H264_ENC_ULLVC_QP_DEC_tag;

typedef union H264_ENC_ULLVC_QP_DEC_THLD_ULLVC_QP_DEC_THLD_union_tag { /* ULLVC Decrement Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THLD:31;                 /* Threshold */
    vuint32_t _unused_31:1;
  } B;
} H264_ENC_ULLVC_QP_DEC_THLD_ULLVC_QP_DEC_THLD_tag;

typedef struct H264_ENC_ULLVC_QP_DEC_THLD_struct_tag {
  H264_ENC_ULLVC_QP_DEC_THLD_ULLVC_QP_DEC_THLD_tag ULLVC_QP_DEC_THLD; /* ULLVC Decrement Threshold Register */
} H264_ENC_ULLVC_QP_DEC_THLD_tag;

typedef union H264_ENC_ULLVC_WAIT_FRAMES_union_tag { /* ULLVC Wait Frames Register */
  vuint32_t R;
  struct {
    vuint32_t WAIT_FRAMES:6;           /* Wait Frames */
    vuint32_t _unused_6:26;
  } B;
} H264_ENC_ULLVC_WAIT_FRAMES_tag;

typedef union H264_ENC_ULLVC_DISABLE_DBF_union_tag { /* ULLVC Disable DBF Register */
  vuint32_t R;
  struct {
    vuint32_t DISABLE:1;               /* Disable */
    vuint32_t _unused_1:31;
  } B;
} H264_ENC_ULLVC_DISABLE_DBF_tag;

typedef union H264_ENC_ULLVC_BITRATE_STREAM_union_tag { /* ULLVC Bitrate Stream Register */
  vuint32_t R;
  struct {
    vuint32_t VAL:32;                  /* Value */
  } B;
} H264_ENC_ULLVC_BITRATE_STREAM_tag;

struct H264_ENC_tag {
  H264_ENC_MCR_tag MCR;                /* Module Configuration Register */
  uint32_t H264_ENC_reserved0[15];
  H264_ENC_VCR_tag VCR;                /* Video Configuration Register */
  uint32_t H264_ENC_reserved1[3];
  H264_ENC_VI_ALARM_tag VI_ALARM;      /* Video Input Alarm Register */
  uint32_t H264_ENC_reserved2[3];
  H264_ENC_FETCH_MBRW_tag FETCH_MBRW;  /* Fetch Macroblock Row Register */
  uint32_t H264_ENC_reserved3[23];
  H264_ENC_VI_CBUF_Y_ADDR_tag VI_CBUF_Y_ADDR; /* Video Input Circular Buffer Luma Start Address Register */
  uint32_t H264_ENC_reserved4[3];
  H264_ENC_VI_CBUF_CB_ADDR_tag VI_CBUF_CB_ADDR; /* Video Input Circular Buffer Cb Start Address Register */
  uint32_t H264_ENC_reserved5[3];
  H264_ENC_VI_CBUF_CR_ADDR_tag VI_CBUF_CR_ADDR; /* Video Input Circular Buffer Cr Start Address Register */
  uint32_t H264_ENC_reserved6[3];
  H264_ENC_VI_NRLINES_tag VI_NRLINES;  /* Video Input Number of Lines Register */
  uint32_t H264_ENC_reserved7[3];
  H264_ENC_RATE_FLOW_CTRL_tag RATE_FLOW_CTRL; /* Rate Flow Control Register */
  uint32_t H264_ENC_reserved8[63];
  H264_ENC_OUT_CBUF_START_ADDR_tag OUT_CBUF_START_ADDR; /* Output Circular Buffer Start Address Register */
  uint32_t H264_ENC_reserved9[3];
  H264_ENC_OUT_CBUF_END_ADDR_tag OUT_CBUF_END_ADDR; /* Output Circular Buffer End Address Register */
  uint32_t H264_ENC_reserved10[3];
  H264_ENC_OUT_CBUF_ALARM_ADDR_tag OUT_CBUF_ALARM_ADDR; /* Ouput Circular Buffer Alarm Address Register */
  uint32_t H264_ENC_reserved11[7];
  H264_ENC_OUT_CBUF_CURR_ADDR_tag OUT_CBUF_CURR_ADDR; /* Output Circular Buffer Current Address Register */
  uint32_t H264_ENC_reserved12[3];
  H264_ENC_OUT_CBUF_VEND_ADDR_tag OUT_CBUF_VEND_ADDR; /* Output Circular Buffer Vend Address Register */
  uint32_t H264_ENC_reserved13[111];
  H264_ENC_LINE_CNTR_STAT_tag LINE_CNTR_STAT; /* Line Counter Status Register */
  uint32_t H264_ENC_reserved14[23];
  H264_ENC_ISR_tag ISR;                /* Interrupt Status Register */
  uint32_t H264_ENC_reserved15[3];
  H264_ENC_IER_tag IER;                /* Interrupt Enable Register */
  uint32_t H264_ENC_reserved16[31];
  H264_ENC_TESTLINE_CFG_tag TESTLINE_CFG; /* Testline Configuration Register */
  uint32_t H264_ENC_reserved17[3];
  H264_ENC_TESTLINE_STRT_LOC_tag TESTLINE_STRT_LOC; /* Testline Start Location Register */
  uint32_t H264_ENC_reserved18[3];
  H264_ENC_TESTLINE_LUMA_VAL_tag TESTLINE_LUMA_VAL; /* Testline Luma Value Register */
  uint32_t H264_ENC_reserved19[3];
  H264_ENC_TESTLINE_CB_VAL_tag TESTLINE_CB_VAL; /* Testline Chroma Cb Value Register */
  uint32_t H264_ENC_reserved20[3];
  H264_ENC_TESTLINE_CR_VAL_tag TESTLINE_CR_VAL; /* Testline Chroma Cr Value Register */
  uint32_t H264_ENC_reserved21[175];
  H264_ENC_ULLVC_FRAME_RATE_tag ULLVC_FRAME_RATE; /* ULLVC Frame Rate Register */
  uint32_t H264_ENC_reserved22[3];
  H264_ENC_ULLVC_QP_INIT_tag ULLVC_QP_INIT; /* ULLVC Quantization Parameter Initial Register */
  uint32_t H264_ENC_reserved23[3];
  H264_ENC_ULLVC_QP_RANGE_tag ULLVC_QP_RANGE; /* ULLVC Quantization Parameter Range Register */
  uint32_t H264_ENC_reserved24[3];
  H264_ENC_ULLVC_BITS_PER_MB_ROW_tag ULLVC_BITS_PER_MB_ROW; /* ULLVC Bits Per Macroblock Row Register */
  uint32_t H264_ENC_reserved25[3];
  H264_ENC_ULLVC_QP_FALLBACK_LIMIT_tag ULLVC_QP_FALLBACK_LIMIT; /* ULLVC Fallback QP Limit Register */
  uint32_t H264_ENC_reserved26[3];
  H264_ENC_ULLVC_QP_INC_tag ULLVC_QP_INC; /* ULLVC Increment QP Register */
  uint32_t H264_ENC_reserved27[3];
  H264_ENC_ULLVC_QP_INC_THLD_tag ULLVC_QP_INC_THLD[3];
  H264_ENC_ULLVC_QP_DEC_tag ULLVC_QP_DEC; /* ULLVC Decrement QP Register */
  uint32_t H264_ENC_reserved28[3];
  H264_ENC_ULLVC_QP_DEC_THLD_tag ULLVC_QP_DEC_THLD[3];
  H264_ENC_ULLVC_WAIT_FRAMES_tag ULLVC_WAIT_FRAMES; /* ULLVC Wait Frames Register */
  uint32_t H264_ENC_reserved29[3];
  H264_ENC_ULLVC_DISABLE_DBF_tag ULLVC_DISABLE_DBF; /* ULLVC Disable DBF Register */
  uint32_t H264_ENC_reserved30[75];
  H264_ENC_ULLVC_BITRATE_STREAM_tag ULLVC_BITRATE_STREAM; /* ULLVC Bitrate Stream Register */
};


/* ============================================================================
   =============================== Module: HPSMI ==============================
   ============================================================================ */

typedef union HPSMI_GBL_CTRL_union_tag { /* HPSMI Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t WR_ENABLE:1;
    vuint32_t _unused_2:30;
  } B;
} HPSMI_GBL_CTRL_tag;

typedef union HPSMI_MPU_SEL0_union_tag { /* HPSMI MPU Address Select 0 Register */
  vuint32_t R;
  struct {
    vuint32_t SELVAL:32;
  } B;
} HPSMI_MPU_SEL0_tag;

typedef union HPSMI_MPU_SEL1_union_tag { /* HPSMI MPU Address Select 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SELVAL:32;
  } B;
} HPSMI_MPU_SEL1_tag;

typedef union HPSMI_MPU_SEL2_union_tag { /* HPSMI MPU Address Select 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SELVAL:32;
  } B;
} HPSMI_MPU_SEL2_tag;

typedef union HPSMI_MPU_SEL3_union_tag { /* HPSMI MPU Address Select 3 Register */
  vuint32_t R;
  struct {
    vuint32_t SELVAL:32;
  } B;
} HPSMI_MPU_SEL3_tag;

typedef union HPSMI_PRIO_CHANGE_union_tag { /* HPSMI Stream DMA Master Priority Change Register */
  vuint32_t R;
  struct {
    vuint32_t SEL_PRIO:7;
    vuint32_t _unused_7:1;
    vuint32_t PRIO_MASK:7;
    vuint32_t CNTR_EN:1;
    vuint32_t CNTR_MODE:1;
    vuint32_t _unused_17:15;
  } B;
} HPSMI_PRIO_CHANGE_tag;

typedef union HPSMI_PROFILE_LSB2AXICYCCNTR_0_union_tag { /* HPSMI LSB2AXI Master 0 Cycle counter Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXICYCCNTR_0_tag;

typedef union HPSMI_PROFILE_LSB2AXICYCCNTR_1_union_tag { /* HPSMI LSB2AXI Master 1 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXICYCCNTR_1_tag;

typedef union HPSMI_PROFILE_CYCCNTR_OVF_union_tag { /* HPSMI Profile Cycle Counter Overflow Register */
  vuint32_t R;
  struct {
    vuint32_t AXI_CYCCNTR_OVF0:1;
    vuint32_t AXI_CYCCNTR_OVF1:1;
    vuint32_t AXI_CYCCNTR_OVF2:1;
    vuint32_t AXi_CYCCNTR_OVF3:1;
    vuint32_t AXI_CYCCNTR_OVF4:1;
    vuint32_t AXI_CYCCNTR_OVF5:1;
    vuint32_t AXI_CYCCNTR_OVF6:1;
    vuint32_t LSB2AXI_CYCCNTR_OVF0:1;
    vuint32_t LSB2AXI_CYCCNTR_OVF1:1;
    vuint32_t _unused_9:2;
    vuint32_t _unused_11:21;
  } B;
} HPSMI_PROFILE_CYCCNTR_OVF_tag;

typedef union HPSMI_PROFILE_STOP_union_tag { /* HPSMI AXI Profile Stop Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;
    vuint32_t STOP_TOTAL:1;
    vuint32_t _unused_2:6;
    vuint32_t STOP_AXIMASTER:7;
    vuint32_t _unused_15:1;
    vuint32_t STOP_LSB2AXIMASTER:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_PROFILE_STOP_tag;

typedef union HPSMI_INTR_EN0_union_tag { /* HPSMI Interrupt Enable 0 Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_ERR:1;
    vuint32_t MPU_ERR:1;
    vuint32_t _unused_2:1;
    vuint32_t PM_ERR:1;
    vuint32_t ECC_ERR_SEG0:1;
    vuint32_t ECC_ERR_SEG1:1;
    vuint32_t ECC_ERR_SEG2:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:2;
    vuint32_t _unused_10:22;
  } B;
} HPSMI_INTR_EN0_tag;

typedef union HPSMI_INTR_EN1_union_tag { /* HPSMI Interrupt Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ECC_SINGLEERR_SEG0_OVF:1;
    vuint32_t ECC_SINGLEERR_SEG1_OVF:1;
    vuint32_t ECC_SINGLEERR_SEG2_OVF:1;
    vuint32_t ECC_UNCORRERR_SEG0_OVF:1;
    vuint32_t ECC_UNCORRERR_SEG1_OVF:1;
    vuint32_t ECC_UNCORERR_SEG2_OVF:1;
    vuint32_t _unused_6:2;
    vuint32_t _unused_8:4;
    vuint32_t _unused_12:20;
  } B;
} HPSMI_INTR_EN1_tag;

typedef union HPSMI_PROFILE_START_union_tag { /* HPSMI AXI Profile Start Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;
    vuint32_t START_TOTAL:1;
    vuint32_t _unused_2:6;
    vuint32_t START_AXIMASTER:7;
    vuint32_t _unused_15:1;
    vuint32_t START_LSB2AXIMASTER:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_PROFILE_START_tag;

typedef union HPSMI_PROFILE_RESET_union_tag { /* HPSMI AXI Profile Reset Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;
    vuint32_t RESET_TOTAL:1;
    vuint32_t _unused_2:6;
    vuint32_t RESET_AXIMASTER:7;
    vuint32_t _unused_15:1;
    vuint32_t RESET_LSB2AXIMASTER:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_PROFILE_RESET_tag;

typedef union HPSMI_PROFILE_FREEZE_union_tag { /* HPSMI AXI Profile Freeze Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;
    vuint32_t FREEZE_TOTAL:1;
    vuint32_t _unused_2:6;
    vuint32_t FREEZE_AXIMASTER:7;
    vuint32_t _unused_15:1;
    vuint32_t FREEZE_LSB2AXIMASTER:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_PROFILE_FREEZE_tag;

typedef union HPSMI_PROFILE_DECVAL_union_tag { /* HPSMI AXI Profile Decrement Value Register */
  vuint32_t R;
  struct {
    vuint32_t DECVAL:32;
  } B;
} HPSMI_PROFILE_DECVAL_tag;

typedef union HPSMI_PROFILE_DECVAL_CNTRNUM_union_tag { /* HPSMI AXI Profile Decrement Counter Information Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRNUM:4;
    vuint32_t DEC:1;
    vuint32_t _unused_5:27;
  } B;
} HPSMI_PROFILE_DECVAL_CNTRNUM_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_0_union_tag { /* HPSMI AXI Master 0 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_0_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_0_union_tag { /* HPSMI AXI Master 0 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_0_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_1_union_tag { /* HPSMI AXI Master 1 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_1_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_1_union_tag { /* HPSMI AXI Master 1 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_1_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_2_union_tag { /* HPSMI AXI Master 2 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_2_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_2_union_tag { /* HPSMI AXI Master 2 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_2_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_3_union_tag { /* HPSMI AXI Master 3 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_3_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_3_union_tag { /* HPSMI AXI Master 3 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_3_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_4_union_tag { /* HPSMI AXI Master 4 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_4_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_4_union_tag { /* HPSMI AXI Master 4 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_4_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_5_union_tag { /* HPSMI AXI Master 5 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_5_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_5_union_tag { /* HPSMI AXI Master 5 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_5_tag;

typedef union HPSMI_PROFILE_AXIRDCNTRVAL_6_union_tag { /* HPSMI AXI Master 6 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIRDCNTRVAL_6_tag;

typedef union HPSMI_PROFILE_AXIWRCNTRVAL_6_union_tag { /* HPSMI AXI Master 6 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXIWRCNTRVAL_6_tag;

typedef union HPSMI_PROFILE_LSB2AXIRDCNTRVAL_0_union_tag { /* HPSMI LSB2AXI Master 0 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXIRDCNTRVAL_0_tag;

typedef union HPSMI_PROFILE_LSB2AXIWRCNTRVAL_0_union_tag { /* HPSMI LSB2AXI Master 0 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXIWRCNTRVAL_0_tag;

typedef union HPSMI_PROFILE_LSB2AXIRDCNTRVAL_1_union_tag { /* HPSMI LSB2AXI Master 1 Read Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXIRDCNTRVAL_1_tag;

typedef union HPSMI_PROFILE_LSB2AXIWRCNTRVAL_1_union_tag { /* HPSMI LSB2AXI Master 1 Write Port Profile Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_LSB2AXIWRCNTRVAL_1_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_0_union_tag { /* HPSMI AXI Master 0 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_0_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_1_union_tag { /* HPSMI AXI Master 1 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_1_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_2_union_tag { /* HPSMI AXI Master 2 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_2_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_3_union_tag { /* HPSMI AXI Master 3 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_3_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_4_union_tag { /* HPSMI AXI Master 4 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_4_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_5_union_tag { /* HPSMI AXI Master 5 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_5_tag;

typedef union HPSMI_PROFILE_AXICYCCNTRVAL_6_union_tag { /* HPSMI AXI Master 6 Cycle Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t CNTRVAL:32;
  } B;
} HPSMI_PROFILE_AXICYCCNTRVAL_6_tag;

typedef union HPSMI_RD_PL_LVL_31_0_union_tag { /* HPSMI Stream DMA Read Pipeline Level 31_0 Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:32;
  } B;
} HPSMI_RD_PL_LVL_31_0_tag;

typedef union HPSMI_RD_PL_LVL_63_32_union_tag { /* HPSMI Stream DMA Read Pipeline Level 63_32 Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:32;
  } B;
} HPSMI_RD_PL_LVL_63_32_tag;

typedef union HPSMI_WR_PL_LVL_31_0_union_tag { /* HPSMI Stream DMA Write Pipeline Level 31_0 Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:32;
  } B;
} HPSMI_WR_PL_LVL_31_0_tag;

typedef union HPSMI_WR_PL_LVL_63_32_union_tag { /* HPSMI Stream DMA Write Pipeline Level 63_32 Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:32;
  } B;
} HPSMI_WR_PL_LVL_63_32_tag;

typedef union HPSMI_DSRD_ADDRESS_ERROR0_union_tag { /* HPSMI Stream DMA Read Address Error 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_RD_ADDR_ERROR:32;
  } B;
} HPSMI_DSRD_ADDRESS_ERROR0_tag;

typedef union HPSMI_DSRD_ADDRESS_ERROR1_union_tag { /* HPSMI Stream DMA Read Address Error 1 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_RD_ADDR_ERROR:32;
  } B;
} HPSMI_DSRD_ADDRESS_ERROR1_tag;

typedef union HPSMI_DSWR_ADDRESS_ERROR0_union_tag { /* HPSMI Stream DMA Write Address Error 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_WR_ADDR_ERROR:32;
  } B;
} HPSMI_DSWR_ADDRESS_ERROR0_tag;

typedef union HPSMI_DSWR_ADDRESS_ERROR1_union_tag { /* HPSMI Stream DMA Write Address Error 1 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_WR_ADDR_ERROR:32;
  } B;
} HPSMI_DSWR_ADDRESS_ERROR1_tag;

typedef union HPSMI_ADDR_ERROR_ADDRVAL_union_tag { /* HPSMI Addressing Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDRESS:32;
  } B;
} HPSMI_ADDR_ERROR_ADDRVAL_tag;

typedef union HPSMI_ADDR_ERROR_INFO_union_tag { /* HPSMI Addressing Error Information Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:6;
    vuint32_t MASTER_TYPE:1;
    vuint32_t _unused_7:2;
    vuint32_t ADDR_ERR:1;
    vuint32_t _unused_10:22;
  } B;
} HPSMI_ADDR_ERROR_INFO_tag;

typedef union HPSMI_WRMPU_ERROR0_union_tag { /* HPSMI Stream DMA Write MPU Error 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_WR_MPU_ERR:32;
  } B;
} HPSMI_WRMPU_ERROR0_tag;

typedef union HPSMI_WRMPU_ERROR1_union_tag { /* HPSMI Stream DMA Write MPU Error 1 Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_WR_MPU_ERR:32;
  } B;
} HPSMI_WRMPU_ERROR1_tag;

typedef union HPSMI_WRMPU_ERROR_ADDR_union_tag { /* HPSMI MPU Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDRESS:32;
  } B;
} HPSMI_WRMPU_ERROR_ADDR_tag;

typedef union HPSMI_WRMPU_ERROR_INFO_union_tag { /* HPSMI MPU Error Information Register */
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:6;
    vuint32_t _unused_6:3;
    vuint32_t MPU_ERR:1;
    vuint32_t _unused_10:22;
  } B;
} HPSMI_WRMPU_ERROR_INFO_tag;

typedef union HPSMI_PM_ERROR_1_2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERROR_BANK:16;
    vuint32_t _unused_16:16;
  } B;
} HPSMI_PM_ERROR_1_2_tag;

typedef union HPSMI_PM_ERROR_ADDR_1_2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDR:32;
  } B;
} HPSMI_PM_ERROR_ADDR_1_2_tag;

typedef union HPSMI_PM_ERROR_INFO_1_2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MASTERNUM:6;
    vuint32_t MASTER_TYPE:2;
    vuint32_t BANKNUM:4;
    vuint32_t _unused_12:1;
    vuint32_t PM_ERR:1;
    vuint32_t _unused_14:18;
  } B;
} HPSMI_PM_ERROR_INFO_1_2_tag;

typedef union HPSMI_ECC_ERR_INJECT_union_tag { /* HPSMI Error Inject Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INJECT:8;
    vuint32_t _unused_8:24;
  } B;
} HPSMI_ECC_ERR_INJECT_tag;

typedef union HPSMI_ECC_ERRCNTR_MASK_union_tag { /* HPSMI ECC Error Counter Reset Mask */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:6;
    vuint32_t _unused_6:2;
    vuint32_t SEG1_MASK:1;
    vuint32_t SEG2_MASK:1;
    vuint32_t SEG0_ODD_MASK:1;
    vuint32_t SEG0_EVEN_MASK:1;
    vuint32_t _unused_12:20;
  } B;
} HPSMI_ECC_ERRCNTR_MASK_tag;

typedef union HPSMI_ECC_SINGLE_ERRCNTR_1_2_union_tag { /* Single Error counter for SEG1_2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_CNTR_SEG1:6;
    vuint32_t ECCERR_OVF_SEG1:1;
    vuint32_t _unused_7:1;
    vuint32_t ERR_CNTR_SEG2:6;
    vuint32_t ECCERR_OVF_SEG2:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:16;
  } B;
} HPSMI_ECC_SINGLE_ERRCNTR_1_2_tag;

typedef union HPSMI_ECC_UNCORR_ERRCNTR_1_2_union_tag { /* Uncorrectable Error Counter for Seg1_2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_CNTR_SEG1:6;
    vuint32_t ECCERR_OVF_SEG1:1;
    vuint32_t _unused_7:1;
    vuint32_t ERR_CNTR_SEG2:6;
    vuint32_t ECCERR_OVF_SEG2:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:16;
  } B;
} HPSMI_ECC_UNCORR_ERRCNTR_1_2_tag;

typedef union HPSMI_ECC_ERRADDR_SEG1_union_tag { /* HPSMI ECC Error Address Segment 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDR:32;
  } B;
} HPSMI_ECC_ERRADDR_SEG1_tag;

typedef union HPSMI_ECC_ERRDATA0_SEG1_union_tag { /* HPSMI ECC Error Data 31:0 for Segment 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_DATA0:32;
  } B;
} HPSMI_ECC_ERRDATA0_SEG1_tag;

typedef union HPSMI_ECC_ERRDATA1_SEG1_union_tag { /* HPSMI ECC Error Data 63:32 for Segment 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_DATA1:32;
  } B;
} HPSMI_ECC_ERRDATA1_SEG1_tag;

typedef union HPSMI_ECC_ERRINFO_SEG1_union_tag { /* HPSMI ECC Error Information Segment 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNDROME:8;
    vuint32_t ERR_TYPE:1;
    vuint32_t ERR_BANK:3;
    vuint32_t ECC_ERR:1;
    vuint32_t _unused_13:19;
  } B;
} HPSMI_ECC_ERRINFO_SEG1_tag;

typedef union HPSMI_ECC_ERRADDR_SEG2_union_tag { /* HPSMI ECC Error Address Segment 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDR:32;
  } B;
} HPSMI_ECC_ERRADDR_SEG2_tag;

typedef union HPSMI_ECC_ERRDATA0_SEG2_union_tag { /* HPSMI ECC Error Data 31:0 for Segment 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_DATA0:32;
  } B;
} HPSMI_ECC_ERRDATA0_SEG2_tag;

typedef union HPSMI_ECC_ERRDATA1_SEG2_union_tag { /* HPSMI ECC Error Data 63:32 for Segment 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_DATA1:32;
  } B;
} HPSMI_ECC_ERRDATA1_SEG2_tag;

typedef union HPSMI_ECC_ERRINFO_SEG2_union_tag { /* HPSMI ECC Error Information Segment 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNDROME:8;
    vuint32_t ERR_TYPE:1;
    vuint32_t ERR_BANK:3;
    vuint32_t ECC_ERR:1;
    vuint32_t _unused_13:19;
  } B;
} HPSMI_ECC_ERRINFO_SEG2_tag;

typedef union HPSMI_ECC_ERROCCURRED_SEG1_2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERR:16;
    vuint32_t _unused_16:16;
  } B;
} HPSMI_ECC_ERROCCURRED_SEG1_2_tag;

typedef union HPSMI_ECC_ERRADDR_SEG0_EVEN_union_tag { /* HPSMI ECC Error Address for Even Banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADDR_EVEN:32;
  } B;
} HPSMI_ECC_ERRADDR_SEG0_EVEN_tag;

typedef union HPSMI_ECC_ERRADDR_SEG0_ODD_union_tag { /* HPSMI ECC Error Address for Odd Banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADDR_ODD:32;
  } B;
} HPSMI_ECC_ERRADDR_SEG0_ODD_tag;

typedef union HPSMI_ECC_ERRDATA0_SEG0_EVEN_union_tag { /* HPSMI ECC Error Data 31:0 for even banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_DATA0_EVEN:32;
  } B;
} HPSMI_ECC_ERRDATA0_SEG0_EVEN_tag;

typedef union HPSMI_ECC_ERRDATA1_SEG0_EVEN_union_tag { /* HPSMI ECC Error Data 63:32 for even banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_DATA1_EVEN:32;
  } B;
} HPSMI_ECC_ERRDATA1_SEG0_EVEN_tag;

typedef union HPSMI_ECC_ERRDATA0_SEG0_ODD_union_tag { /* HPSMI ECC Error Data 31:0 for odd banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_DATA0_ODD:32;
  } B;
} HPSMI_ECC_ERRDATA0_SEG0_ODD_tag;

typedef union HPSMI_ECC_ERRDATA1_SEG0_ODD_union_tag { /* HPSMI ECC Error Data 63:32 for odd banks of Segment0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_DATA1_ODD:32;
  } B;
} HPSMI_ECC_ERRDATA1_SEG0_ODD_tag;

typedef union HPSMI_ECC_ERRINFO_SEG0_union_tag { /* HPSMI ECC Error Information Segment 0 Register */
  vuint32_t R;
  struct {
    vuint32_t SYND_EVEN:8;
    vuint32_t ERR_TYPE_EVEN:1;
    vuint32_t ERR_EVEN_BANK:4;
    vuint32_t ECC_ERR_EVEN:1;
    vuint32_t _unused_14:2;
    vuint32_t SYND_ODD:8;
    vuint32_t ERR_TYPE_ODD:1;
    vuint32_t ERR_ODD_BANK:4;
    vuint32_t ECC_ERR_ODD:1;
    vuint32_t _unused_30:2;
  } B;
} HPSMI_ECC_ERRINFO_SEG0_tag;

typedef union HPSMI_ECC_ERROCCURED_SEG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERR:24;
    vuint32_t _unused_24:8;
  } B;
} HPSMI_ECC_ERROCCURED_SEG0_tag;

typedef union HPSMI_ECC_SINGLE_ERRCNTR_ODD_EVEN_0_union_tag { /* ECC Single Error Counter for Odd and Even Bank Register */
  vuint32_t R;
  struct {
    vuint32_t ECC_ERR_CNTR_ODD:6;
    vuint32_t ECC_ERR_OVF_ODD:1;
    vuint32_t _unused_7:1;
    vuint32_t ECC_ERR_CNTR_EVEN:6;
    vuint32_t ECC_ERR_OVF_EVEN:1;
    vuint32_t _unused_15:17;
  } B;
} HPSMI_ECC_SINGLE_ERRCNTR_ODD_EVEN_0_tag;

typedef union HPSMI_ECC_UNCORR_ERRCNTR_ODD_EVEN_0_union_tag { /* ECC Uncorectable Error Conter for Odd and Even Bank Register */
  vuint32_t R;
  struct {
    vuint32_t ECC_ERR_CNTR_ODD:6;
    vuint32_t ECC_ERR_OVF_ODD:1;
    vuint32_t _unused_7:1;
    vuint32_t ECC_ERR_CNTR_EVEN:6;
    vuint32_t ECC_ERR_OVF_EVEN:1;
    vuint32_t _unused_15:17;
  } B;
} HPSMI_ECC_UNCORR_ERRCNTR_ODD_EVEN_0_tag;

typedef union HPSMI_PM_ERROR_0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERROR_BANK:12;
    vuint32_t _unused_12:4;
    vuint32_t _unused_16:16;
  } B;
} HPSMI_PM_ERROR_0_tag;

typedef union HPSMI_PM_ERROR_ADDR_0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ERROR_ADDR:32;
  } B;
} HPSMI_PM_ERROR_ADDR_0_tag;

typedef union HPSMI_PM_ERROR_INFO_0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t BANKNUM:4;
    vuint32_t PM_ERR:1;
    vuint32_t _unused_5:6;
    vuint32_t TRANSACTION_ID:21;
  } B;
} HPSMI_PM_ERROR_INFO_0_tag;

typedef union HPSMI_POWMOD_CTRL_0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PM_BANK0:3;
    vuint32_t PM_BANK1:3;
    vuint32_t _unused_6:2;
    vuint32_t PM_BANK2:3;
    vuint32_t PM_BANK3:3;
    vuint32_t _unused_14:2;
    vuint32_t PM_BANK4:3;
    vuint32_t PM_BANK5:3;
    vuint32_t _unused_22:2;
    vuint32_t PM_BANK6:3;
    vuint32_t PM_BANK7:3;
    vuint32_t _unused_30:2;
  } B;
} HPSMI_POWMOD_CTRL_0_tag;

typedef union HPSMI_POWMOD_CTRL_0_8_11_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PM_BANK8:3;
    vuint32_t PM_BANK9:3;
    vuint32_t _unused_6:2;
    vuint32_t PM_BANK10:3;
    vuint32_t PM_BANK11:3;
    vuint32_t _unused_14:18;
  } B;
} HPSMI_POWMOD_CTRL_0_8_11_tag;

typedef union HPSMI_POWMOD_CTRL_1_2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PM_SEG1:3;
    vuint32_t PM_SEG2:3;
    vuint32_t _unused_6:26;
  } B;
} HPSMI_POWMOD_CTRL_1_2_tag;

typedef union HPSMI_QOS_PRIORITY_union_tag {
  vuint32_t R;
  struct {
    vuint32_t M_CORES_AXI4:4;
    vuint32_t _unused_4:4;
    vuint32_t M_FASTDMA_AXI6:4;
    vuint32_t M_LSB0_AXI7:4;
    vuint32_t M_LSB1_AXI8:4;
    vuint32_t _unused_20:11;
    vuint32_t WEN:1;
  } B;
} HPSMI_QOS_PRIORITY_tag;

typedef union HPSMI_IPCGE_union_tag {  /* Interconnect Parity Checking Global Enable Register */
  vuint32_t R;
  struct {
    vuint32_t GLBL_EN:1;
    vuint32_t _unused_1:31;
  } B;
} HPSMI_IPCGE_tag;

typedef union HPSMI_IPRCE_union_tag {  /* Interconnect Parity Read Checking Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPRE_AXI0:1;
    vuint32_t IPRE_AXI1:1;
    vuint32_t IPRE_AXI2:1;
    vuint32_t IPRE_AXI3:1;
    vuint32_t _unused_4:4;
    vuint32_t IPRE_AXI4:1;
    vuint32_t IPRE_AXI5:1;
    vuint32_t IPRE_AXI6:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:4;
    vuint32_t IPRE_LSB2AXI0:1;
    vuint32_t IPRE_LSB2AXI1:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_IPRCE_tag;

typedef union HPSMI_IPWCE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t IPWCE_S0:1;
    vuint32_t IPWCE_S1:1;
    vuint32_t IPWCE_S2:1;
    vuint32_t IPWCE_S3:1;
    vuint32_t IPWCE_S4:1;
    vuint32_t IPWCE_S5:1;
    vuint32_t IPWCE_S6:1;
    vuint32_t IPWCE_S7:1;
    vuint32_t IPWCE_S8:1;
    vuint32_t IPWCE_S9:1;
    vuint32_t IPWCE_S10:1;
    vuint32_t IPWCE_S11:1;
    vuint32_t _unused_12:4;
    vuint32_t IPWCE_S12:1;
    vuint32_t IPWCE_S13:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_IPWCE_tag;

typedef union HPSMI_IPWACE_union_tag { /* Interconnect Parity Write Address Checking Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPWACE_S0:1;
    vuint32_t IPWACE_S1:1;
    vuint32_t IPWACE_S2:1;
    vuint32_t IPWACE_S3:1;
    vuint32_t IPWACE_S4:1;
    vuint32_t IPWACE_S5:1;
    vuint32_t IPWACE_S6:1;
    vuint32_t IPWACE_S7:1;
    vuint32_t IPWACE_S8:1;
    vuint32_t IPWACE_S9:1;
    vuint32_t IPWACE_S10:1;
    vuint32_t IPWACE_S11:1;
    vuint32_t _unused_12:4;
    vuint32_t IPWACE_S12:1;
    vuint32_t IPWACE_S13:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_IPWACE_tag;

typedef union HPSMI_IPRACE_union_tag { /* Interconnect Parity Read Address Checking Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPRACE_S0:1;
    vuint32_t IPRACE_S1:1;
    vuint32_t IPRACE_S2:1;
    vuint32_t IPRACE_S3:1;
    vuint32_t IPRACE_S4:1;
    vuint32_t IPRACE_S5:1;
    vuint32_t IPRACE_S6:1;
    vuint32_t IPRACE_S7:1;
    vuint32_t IPRACE_S8:1;
    vuint32_t IPRACE_S9:1;
    vuint32_t IPRACE_S10:1;
    vuint32_t IPRACE_S11:1;
    vuint32_t _unused_12:4;
    vuint32_t IPRACE_S12:1;
    vuint32_t IPRACE_S13:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:12;
  } B;
} HPSMI_IPRACE_tag;

typedef union HPSMI_IPCGIE_union_tag { /* Interconnect Parity Checking Global Injection Enable Register */
  vuint32_t R;
  struct {
    vuint32_t GLBL_IEN:1;
    vuint32_t _unused_1:31;
  } B;
} HPSMI_IPCGIE_tag;

struct HPSMI_tag {
  HPSMI_GBL_CTRL_tag GBL_CTRL;         /* HPSMI Global Control Register */
  uint32_t HPSMI_reserved0[15];
  HPSMI_MPU_SEL0_tag MPU_SEL0;         /* HPSMI MPU Address Select 0 Register */
  uint32_t HPSMI_reserved1[3];
  HPSMI_MPU_SEL1_tag MPU_SEL1;         /* HPSMI MPU Address Select 1 Register */
  uint32_t HPSMI_reserved2[3];
  HPSMI_MPU_SEL2_tag MPU_SEL2;         /* HPSMI MPU Address Select 2 Register */
  uint32_t HPSMI_reserved3[3];
  HPSMI_MPU_SEL3_tag MPU_SEL3;         /* HPSMI MPU Address Select 3 Register */
  uint32_t HPSMI_reserved4[3];
  HPSMI_PRIO_CHANGE_tag PRIO_CHANGE;   /* HPSMI Stream DMA Master Priority Change Register */
  uint32_t HPSMI_reserved5[3];
  HPSMI_PROFILE_LSB2AXICYCCNTR_0_tag PROFILE_LSB2AXICYCCNTR_0; /* HPSMI LSB2AXI Master 0 Cycle counter Register */
  uint32_t HPSMI_reserved6[3];
  HPSMI_PROFILE_LSB2AXICYCCNTR_1_tag PROFILE_LSB2AXICYCCNTR_1; /* HPSMI LSB2AXI Master 1 Cycle Counter Value Register */
  uint32_t HPSMI_reserved7[3];
  HPSMI_PROFILE_CYCCNTR_OVF_tag PROFILE_CYCCNTR_OVF; /* HPSMI Profile Cycle Counter Overflow Register */
  uint32_t HPSMI_reserved8[3];
  HPSMI_PROFILE_STOP_tag PROFILE_STOP; /* HPSMI AXI Profile Stop Register */
  uint32_t HPSMI_reserved9[31];
  HPSMI_INTR_EN0_tag INTR_EN0;         /* HPSMI Interrupt Enable 0 Register */
  uint32_t HPSMI_reserved10[3];
  HPSMI_INTR_EN1_tag INTR_EN1;         /* HPSMI Interrupt Enable 1 Register */
  uint32_t HPSMI_reserved11[3];
  HPSMI_PROFILE_START_tag PROFILE_START; /* HPSMI AXI Profile Start Register */
  uint32_t HPSMI_reserved12[3];
  HPSMI_PROFILE_RESET_tag PROFILE_RESET; /* HPSMI AXI Profile Reset Register */
  uint32_t HPSMI_reserved13[3];
  HPSMI_PROFILE_FREEZE_tag PROFILE_FREEZE; /* HPSMI AXI Profile Freeze Register */
  uint32_t HPSMI_reserved14[3];
  HPSMI_PROFILE_DECVAL_tag PROFILE_DECVAL; /* HPSMI AXI Profile Decrement Value Register */
  uint32_t HPSMI_reserved15[3];
  HPSMI_PROFILE_DECVAL_CNTRNUM_tag PROFILE_DECVAL_CNTRNUM; /* HPSMI AXI Profile Decrement Counter Information Register */
  uint32_t HPSMI_reserved16[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_0_tag PROFILE_AXIRDCNTRVAL_0; /* HPSMI AXI Master 0 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved17[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_0_tag PROFILE_AXIWRCNTRVAL_0; /* HPSMI AXI Master 0 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved18[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_1_tag PROFILE_AXIRDCNTRVAL_1; /* HPSMI AXI Master 1 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved19[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_1_tag PROFILE_AXIWRCNTRVAL_1; /* HPSMI AXI Master 1 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved20[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_2_tag PROFILE_AXIRDCNTRVAL_2; /* HPSMI AXI Master 2 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved21[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_2_tag PROFILE_AXIWRCNTRVAL_2; /* HPSMI AXI Master 2 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved22[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_3_tag PROFILE_AXIRDCNTRVAL_3; /* HPSMI AXI Master 3 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved23[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_3_tag PROFILE_AXIWRCNTRVAL_3; /* HPSMI AXI Master 3 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved24[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_4_tag PROFILE_AXIRDCNTRVAL_4; /* HPSMI AXI Master 4 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved25[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_4_tag PROFILE_AXIWRCNTRVAL_4; /* HPSMI AXI Master 4 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved26[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_5_tag PROFILE_AXIRDCNTRVAL_5; /* HPSMI AXI Master 5 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved27[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_5_tag PROFILE_AXIWRCNTRVAL_5; /* HPSMI AXI Master 5 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved28[3];
  HPSMI_PROFILE_AXIRDCNTRVAL_6_tag PROFILE_AXIRDCNTRVAL_6; /* HPSMI AXI Master 6 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved29[3];
  HPSMI_PROFILE_AXIWRCNTRVAL_6_tag PROFILE_AXIWRCNTRVAL_6; /* HPSMI AXI Master 6 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved30[3];
  HPSMI_PROFILE_LSB2AXIRDCNTRVAL_0_tag PROFILE_LSB2AXIRDCNTRVAL_0; /* HPSMI LSB2AXI Master 0 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved31[3];
  HPSMI_PROFILE_LSB2AXIWRCNTRVAL_0_tag PROFILE_LSB2AXIWRCNTRVAL_0; /* HPSMI LSB2AXI Master 0 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved32[3];
  HPSMI_PROFILE_LSB2AXIRDCNTRVAL_1_tag PROFILE_LSB2AXIRDCNTRVAL_1; /* HPSMI LSB2AXI Master 1 Read Port Profile Counter Value Register */
  uint32_t HPSMI_reserved33[3];
  HPSMI_PROFILE_LSB2AXIWRCNTRVAL_1_tag PROFILE_LSB2AXIWRCNTRVAL_1; /* HPSMI LSB2AXI Master 1 Write Port Profile Counter Value Register */
  uint32_t HPSMI_reserved34[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_0_tag PROFILE_AXICYCCNTRVAL_0; /* HPSMI AXI Master 0 Cycle Counter Value Register */
  uint32_t HPSMI_reserved35[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_1_tag PROFILE_AXICYCCNTRVAL_1; /* HPSMI AXI Master 1 Cycle Counter Value Register */
  uint32_t HPSMI_reserved36[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_2_tag PROFILE_AXICYCCNTRVAL_2; /* HPSMI AXI Master 2 Cycle Counter Value Register */
  uint32_t HPSMI_reserved37[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_3_tag PROFILE_AXICYCCNTRVAL_3; /* HPSMI AXI Master 3 Cycle Counter Value Register */
  uint32_t HPSMI_reserved38[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_4_tag PROFILE_AXICYCCNTRVAL_4; /* HPSMI AXI Master 4 Cycle Counter Value Register */
  uint32_t HPSMI_reserved39[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_5_tag PROFILE_AXICYCCNTRVAL_5; /* HPSMI AXI Master 5 Cycle Counter Value Register */
  uint32_t HPSMI_reserved40[3];
  HPSMI_PROFILE_AXICYCCNTRVAL_6_tag PROFILE_AXICYCCNTRVAL_6; /* HPSMI AXI Master 6 Cycle Counter Value Register */
  uint32_t HPSMI_reserved41[3];
  HPSMI_RD_PL_LVL_31_0_tag RD_PL_LVL_31_0; /* HPSMI Stream DMA Read Pipeline Level 31_0 Register */
  uint32_t HPSMI_reserved42[3];
  HPSMI_RD_PL_LVL_63_32_tag RD_PL_LVL_63_32; /* HPSMI Stream DMA Read Pipeline Level 63_32 Register */
  uint32_t HPSMI_reserved43[11];
  HPSMI_WR_PL_LVL_31_0_tag WR_PL_LVL_31_0; /* HPSMI Stream DMA Write Pipeline Level 31_0 Register */
  uint32_t HPSMI_reserved44[3];
  HPSMI_WR_PL_LVL_63_32_tag WR_PL_LVL_63_32; /* HPSMI Stream DMA Write Pipeline Level 63_32 Register */
  uint32_t HPSMI_reserved45[27];
  HPSMI_DSRD_ADDRESS_ERROR0_tag DSRD_ADDRESS_ERROR0; /* HPSMI Stream DMA Read Address Error 0 Register */
  uint32_t HPSMI_reserved46[3];
  HPSMI_DSRD_ADDRESS_ERROR1_tag DSRD_ADDRESS_ERROR1; /* HPSMI Stream DMA Read Address Error 1 Register */
  uint32_t HPSMI_reserved47[3];
  HPSMI_DSWR_ADDRESS_ERROR0_tag DSWR_ADDRESS_ERROR0; /* HPSMI Stream DMA Write Address Error 0 Register */
  uint32_t HPSMI_reserved48[3];
  HPSMI_DSWR_ADDRESS_ERROR1_tag DSWR_ADDRESS_ERROR1; /* HPSMI Stream DMA Write Address Error 1 Register */
  uint32_t HPSMI_reserved49[15];
  HPSMI_ADDR_ERROR_ADDRVAL_tag ADDR_ERROR_ADDRVAL; /* HPSMI Addressing Error Address Register */
  uint32_t HPSMI_reserved50[3];
  HPSMI_ADDR_ERROR_INFO_tag ADDR_ERROR_INFO; /* HPSMI Addressing Error Information Register */
  uint32_t HPSMI_reserved51[19];
  HPSMI_WRMPU_ERROR0_tag WRMPU_ERROR0; /* HPSMI Stream DMA Write MPU Error 0 Register */
  uint32_t HPSMI_reserved52[3];
  HPSMI_WRMPU_ERROR1_tag WRMPU_ERROR1; /* HPSMI Stream DMA Write MPU Error 1 Register */
  uint32_t HPSMI_reserved53[3];
  HPSMI_WRMPU_ERROR_ADDR_tag WRMPU_ERROR_ADDR; /* HPSMI MPU Error Address Register */
  uint32_t HPSMI_reserved54[3];
  HPSMI_WRMPU_ERROR_INFO_tag WRMPU_ERROR_INFO; /* HPSMI MPU Error Information Register */
  uint32_t HPSMI_reserved55[15];
  HPSMI_PM_ERROR_1_2_tag PM_ERROR_1_2;
  uint32_t HPSMI_reserved56[3];
  HPSMI_PM_ERROR_ADDR_1_2_tag PM_ERROR_ADDR_1_2;
  uint32_t HPSMI_reserved57[3];
  HPSMI_PM_ERROR_INFO_1_2_tag PM_ERROR_INFO_1_2;
  uint32_t HPSMI_reserved58[39];
  HPSMI_ECC_ERR_INJECT_tag ECC_ERR_INJECT; /* HPSMI Error Inject Register */
  uint32_t HPSMI_reserved59[3];
  HPSMI_ECC_ERRCNTR_MASK_tag ECC_ERRCNTR_MASK; /* HPSMI ECC Error Counter Reset Mask */
  uint32_t HPSMI_reserved60[3];
  HPSMI_ECC_SINGLE_ERRCNTR_1_2_tag ECC_SINGLE_ERRCNTR_1_2; /* Single Error counter for SEG1_2 Register */
  uint32_t HPSMI_reserved61[3];
  HPSMI_ECC_UNCORR_ERRCNTR_1_2_tag ECC_UNCORR_ERRCNTR_1_2; /* Uncorrectable Error Counter for Seg1_2 Register */
  uint32_t HPSMI_reserved62[11];
  HPSMI_ECC_ERRADDR_SEG1_tag ECC_ERRADDR_SEG1; /* HPSMI ECC Error Address Segment 1 Register */
  uint32_t HPSMI_reserved63[3];
  HPSMI_ECC_ERRDATA0_SEG1_tag ECC_ERRDATA0_SEG1; /* HPSMI ECC Error Data 31:0 for Segment 1 Register */
  uint32_t HPSMI_reserved64[3];
  HPSMI_ECC_ERRDATA1_SEG1_tag ECC_ERRDATA1_SEG1; /* HPSMI ECC Error Data 63:32 for Segment 1 Register */
  uint32_t HPSMI_reserved65[3];
  HPSMI_ECC_ERRINFO_SEG1_tag ECC_ERRINFO_SEG1; /* HPSMI ECC Error Information Segment 1 Register */
  uint32_t HPSMI_reserved66[3];
  HPSMI_ECC_ERRADDR_SEG2_tag ECC_ERRADDR_SEG2; /* HPSMI ECC Error Address Segment 2 Register */
  uint32_t HPSMI_reserved67[3];
  HPSMI_ECC_ERRDATA0_SEG2_tag ECC_ERRDATA0_SEG2; /* HPSMI ECC Error Data 31:0 for Segment 2 Register */
  uint32_t HPSMI_reserved68[3];
  HPSMI_ECC_ERRDATA1_SEG2_tag ECC_ERRDATA1_SEG2; /* HPSMI ECC Error Data 63:32 for Segment 2 Register */
  uint32_t HPSMI_reserved69[3];
  HPSMI_ECC_ERRINFO_SEG2_tag ECC_ERRINFO_SEG2; /* HPSMI ECC Error Information Segment 2 Register */
  uint32_t HPSMI_reserved70[3];
  HPSMI_ECC_ERROCCURRED_SEG1_2_tag ECC_ERROCCURRED_SEG1_2;
  uint32_t HPSMI_reserved71[3];
  HPSMI_ECC_ERRADDR_SEG0_EVEN_tag ECC_ERRADDR_SEG0_EVEN; /* HPSMI ECC Error Address for Even Banks of Segment0 Register */
  uint32_t HPSMI_reserved72[3];
  HPSMI_ECC_ERRADDR_SEG0_ODD_tag ECC_ERRADDR_SEG0_ODD; /* HPSMI ECC Error Address for Odd Banks of Segment0 Register */
  uint32_t HPSMI_reserved73[3];
  HPSMI_ECC_ERRDATA0_SEG0_EVEN_tag ECC_ERRDATA0_SEG0_EVEN; /* HPSMI ECC Error Data 31:0 for even banks of Segment0 Register */
  uint32_t HPSMI_reserved74[3];
  HPSMI_ECC_ERRDATA1_SEG0_EVEN_tag ECC_ERRDATA1_SEG0_EVEN; /* HPSMI ECC Error Data 63:32 for even banks of Segment0 Register */
  uint32_t HPSMI_reserved75[3];
  HPSMI_ECC_ERRDATA0_SEG0_ODD_tag ECC_ERRDATA0_SEG0_ODD; /* HPSMI ECC Error Data 31:0 for odd banks of Segment0 Register */
  uint32_t HPSMI_reserved76[3];
  HPSMI_ECC_ERRDATA1_SEG0_ODD_tag ECC_ERRDATA1_SEG0_ODD; /* HPSMI ECC Error Data 63:32 for odd banks of Segment0 Register */
  uint32_t HPSMI_reserved77[3];
  HPSMI_ECC_ERRINFO_SEG0_tag ECC_ERRINFO_SEG0; /* HPSMI ECC Error Information Segment 0 Register */
  uint32_t HPSMI_reserved78[3];
  HPSMI_ECC_ERROCCURED_SEG0_tag ECC_ERROCCURED_SEG0;
  uint32_t HPSMI_reserved79[3];
  HPSMI_ECC_SINGLE_ERRCNTR_ODD_EVEN_0_tag ECC_SINGLE_ERRCNTR_ODD_EVEN_0; /* ECC Single Error Counter for Odd and Even Bank Register */
  uint32_t HPSMI_reserved80[3];
  HPSMI_ECC_UNCORR_ERRCNTR_ODD_EVEN_0_tag ECC_UNCORR_ERRCNTR_ODD_EVEN_0; /* ECC Uncorectable Error Conter for Odd and Even Bank Register */
  uint32_t HPSMI_reserved81[3];
  HPSMI_PM_ERROR_0_tag PM_ERROR_0;
  uint32_t HPSMI_reserved82[3];
  HPSMI_PM_ERROR_ADDR_0_tag PM_ERROR_ADDR_0;
  uint32_t HPSMI_reserved83[3];
  HPSMI_PM_ERROR_INFO_0_tag PM_ERROR_INFO_0;
  uint32_t HPSMI_reserved84[3];
  HPSMI_POWMOD_CTRL_0_tag POWMOD_CTRL_0;
  uint32_t HPSMI_reserved85[3];
  HPSMI_POWMOD_CTRL_0_8_11_tag POWMOD_CTRL_0_8_11;
  uint32_t HPSMI_reserved86[11];
  HPSMI_POWMOD_CTRL_1_2_tag POWMOD_CTRL_1_2;
  uint32_t HPSMI_reserved87[11];
  HPSMI_QOS_PRIORITY_tag QOS_PRIORITY;
  uint32_t HPSMI_reserved88[23];
  HPSMI_IPCGE_tag IPCGE;               /* Interconnect Parity Checking Global Enable Register */
  uint32_t HPSMI_reserved89[3];
  HPSMI_IPRCE_tag IPRCE;               /* Interconnect Parity Read Checking Enable Register */
  uint32_t HPSMI_reserved90[3];
  HPSMI_IPWCE_tag IPWCE;
  uint32_t HPSMI_reserved91[3];
  HPSMI_IPWACE_tag IPWACE;             /* Interconnect Parity Write Address Checking Enable Register */
  uint32_t HPSMI_reserved92[3];
  HPSMI_IPRACE_tag IPRACE;             /* Interconnect Parity Read Address Checking Enable Register */
  uint32_t HPSMI_reserved93[3];
  HPSMI_IPCGIE_tag IPCGIE;             /* Interconnect Parity Checking Global Injection Enable Register */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:1;
    vuint8_t ADR:7;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:1;
    vuint8_t DMAEN:1;
    vuint8_t RSTA:1;
    vuint8_t NOACK:1;
    vuint8_t TXRX:1;
    vuint8_t MSSL:1;
    vuint8_t IBIE:1;
    vuint8_t MDIS:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t RXAK:1;
    vuint8_t IBIF:1;
    vuint8_t SRW:1;
    vuint8_t _unused_3:1;
    vuint8_t IBAL:1;
    vuint8_t IBB:1;
    vuint8_t IAAS:1;
    vuint8_t TCF:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:6;
    vuint8_t BYTERXIE:1;
    vuint8_t BIIE:1;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t IPG_DEBUG_EN:1;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t BYTE_RX:1;
    vuint8_t GLFLT_EN:1;
    vuint8_t _unused_4:4;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: IPUS ===============================
   ============================================================================ */

typedef union IPUS_HOST_START_union_tag { /* Command and Start Register */
  vuint32_t R;
  struct {
    vuint32_t NSA:8;
    vuint32_t _unused_8:8;
    vuint32_t CSA:8;
    vuint32_t _unused_24:8;
  } B;
} IPUS_HOST_START_tag;

typedef union IPUS_HOST_STATUS_union_tag { /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t N_EVENTS:2;
    vuint32_t _unused_2:6;
    vuint32_t CORE_STATUS:2;
    vuint32_t DEBUG_STATUS:1;
    vuint32_t _unused_11:5;
    vuint32_t REMAIN_PIXELS:16;
  } B;
} IPUS_HOST_STATUS_tag;

typedef union IPUS_HOST_POS_union_tag { /* Position Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t YPOS:16;
    vuint32_t XPOS:16;
  } B;
} IPUS_HOST_POS_tag;

typedef union IPUS_HOST_CURRPOS_union_tag { /* Current Position Status Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_YPOS:16;
    vuint32_t CURR_XPOS:16;
  } B;
} IPUS_HOST_CURRPOS_tag;

typedef union IPUS_HOST_XCFG_union_tag { /* Line Width and Step Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t XSTEP:2;
    vuint32_t _unused_2:14;
    vuint32_t XSIZE:16;
  } B;
} IPUS_HOST_XCFG_tag;

typedef union IPUS_HOST_CURRXCFG_union_tag { /* Current Line Width and Step Status Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_XSTEP:2;
    vuint32_t _unused_2:14;
    vuint32_t CURR_XSIZE:16;
  } B;
} IPUS_HOST_CURRXCFG_tag;

typedef union IPUS_HOST_INACFG_union_tag { /* INA Matrix Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SHIFT:2;
    vuint32_t NHOOD:1;
    vuint32_t _unused_3:5;
    vuint32_t EN_LINE0:1;
    vuint32_t EN_LINE1:1;
    vuint32_t EN_LINE2:1;
    vuint32_t _unused_11:5;
    vuint32_t CURR_SHIFT:2;
    vuint32_t CURR_NHOOD:1;
    vuint32_t _unused_19:5;
    vuint32_t CURR_EN_LINE0:1;
    vuint32_t CURR_EN_LINE1:1;
    vuint32_t CURR_EN_LINE2:1;
    vuint32_t _unused_27:5;
  } B;
} IPUS_HOST_INACFG_tag;

typedef union IPUS_HOST_INBCFG_union_tag { /* INB Matrix Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SHIFT:2;
    vuint32_t NHOOD:1;
    vuint32_t _unused_3:5;
    vuint32_t EN_LINE0:1;
    vuint32_t EN_LINE1:1;
    vuint32_t EN_LINE2:1;
    vuint32_t _unused_11:5;
    vuint32_t CURR_SHIFT:2;
    vuint32_t CURR_NHOOD:1;
    vuint32_t _unused_19:5;
    vuint32_t CURR_EN_LINE0:1;
    vuint32_t CURR_EN_LINE1:1;
    vuint32_t CURR_EN_LINE2:1;
    vuint32_t _unused_27:5;
  } B;
} IPUS_HOST_INBCFG_tag;

typedef union IPUS_HOST_INALPHACFG_union_tag { /* INALPHA Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SHIFT:2;
    vuint32_t NHOOD:1;
    vuint32_t _unused_3:5;
    vuint32_t EN_LINE0:1;
    vuint32_t EN_LINE1:1;
    vuint32_t EN_LINE2:1;
    vuint32_t _unused_11:5;
    vuint32_t CURR_SHIFT:2;
    vuint32_t CURR_NHOOD:1;
    vuint32_t _unused_19:5;
    vuint32_t CURR_EN_LINE0:1;
    vuint32_t CURR_EN_LINE1:1;
    vuint32_t CURR_EN_LINE2:1;
    vuint32_t _unused_27:5;
  } B;
} IPUS_HOST_INALPHACFG_tag;

typedef union IPUS_HOST_OUTCFG_union_tag { /* OUT Matrix Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t EN_OUT0:1;
    vuint32_t EN_OUT1:1;
    vuint32_t EN_OUT2:1;
    vuint32_t EN_OUT3:1;
    vuint32_t _unused_12:4;
    vuint32_t _unused_16:8;
    vuint32_t CURR_EN_OUT0:1;
    vuint32_t CURR_EN_OUT1:1;
    vuint32_t CURR_EN_OUT2:1;
    vuint32_t CURR_EN_OUT3:1;
    vuint32_t _unused_28:4;
  } B;
} IPUS_HOST_OUTCFG_tag;

typedef union IPUS_HOST_IMEMA_union_tag { /* Instruction Memory Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR:6;
    vuint32_t _unused_6:26;
  } B;
} IPUS_HOST_IMEMA_tag;

typedef union IPUS_HOST_IMEMD_union_tag { /* Instruction Memory Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} IPUS_HOST_IMEMD_tag;

typedef union IPUS_HOST_DREGA_union_tag { /* Data Register-Bank Address Register */
  vuint32_t R;
  struct {
    vuint32_t DMEMA:8;
    vuint32_t _unused_8:24;
  } B;
} IPUS_HOST_DREGA_tag;

typedef union IPUS_HOST_DREGD_union_tag { /* Data Register-Bank Datum Register */
  vuint32_t R;
  struct {
    vuint32_t DMEMD:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_HOST_DREGD_tag;

typedef union IPUS_HOST_HISTA_union_tag { /* Histogram Memory Address Register */
  vuint32_t R;
  struct {
    vuint32_t HISTA:8;
    vuint32_t _unused_8:24;
  } B;
} IPUS_HOST_HISTA_tag;

typedef union IPUS_HOST_HISTD_union_tag { /* Histogram Memory Data Register */
  vuint32_t R;
  struct {
    vuint32_t HISTD:32;
  } B;
} IPUS_HOST_HISTD_tag;

typedef union IPUS_HOST_HISTPEAK_union_tag { /* Histogram Peak Value Register */
  vuint32_t R;
  struct {
    vuint32_t HISTPEAK:32;
  } B;
} IPUS_HOST_HISTPEAK_tag;

typedef union IPUS_HOST_HISTAMAX_union_tag { /* Histogram Maximum Value Address Register */
  vuint32_t R;
  struct {
    vuint32_t HISTAMAX:8;
    vuint32_t _unused_8:24;
  } B;
} IPUS_HOST_HISTAMAX_tag;

typedef union IPUS_HOST_HISTCLEAR_union_tag { /* Histogram Clear Register */
  vuint32_t R;
  struct {
    vuint32_t HISTCLEAR:32;
  } B;
} IPUS_HOST_HISTCLEAR_tag;

typedef union IPUS_HOST_STATA_union_tag { /* Statistics Memory Address Register */
  vuint32_t R;
  struct {
    vuint32_t STATA:10;
    vuint32_t _unused_10:22;
  } B;
} IPUS_HOST_STATA_tag;

typedef union IPUS_HOST_STATD_union_tag { /* Statistics Memory Data Register */
  vuint32_t R;
  struct {
    vuint32_t STATD:32;
  } B;
} IPUS_HOST_STATD_tag;

typedef union IPUS_HOST_STATCLEAR_union_tag { /* Statistics Memory Clear Register */
  vuint32_t R;
  struct {
    vuint32_t STATCLEAR:32;
  } B;
} IPUS_HOST_STATCLEAR_tag;

typedef union IPUS_HOST_LUTA_union_tag { /* LUT Memory Address Register */
  vuint32_t R;
  struct {
    vuint32_t LUTA:12;
    vuint32_t _unused_12:20;
  } B;
} IPUS_HOST_LUTA_tag;

typedef union IPUS_HOST_LUTD_union_tag { /* LUT Memory Data Register */
  vuint32_t R;
  struct {
    vuint32_t LUTD:32;
  } B;
} IPUS_HOST_LUTD_tag;

typedef union IPUS_S_LINE0_LEN_INA_union_tag { /* INA Stream Line 0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE0_LEN_INA_tag;

typedef union IPUS_S_CH0_CFG_INA_union_tag { /* INA Stream Line 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH0_CFG_INA_tag;

typedef union IPUS_S_LINE0_ADDR_INA_union_tag { /* INA Stream Line 0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE0_ADDR_INA_tag;

typedef union IPUS_S_LINE1_LEN_INA_union_tag { /* INA Stream Line 1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE1_LEN_INA_tag;

typedef union IPUS_S_CH1_CFG_INA_union_tag { /* INA Stream Line 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH1_CFG_INA_tag;

typedef union IPUS_S_LINE1_ADDR_INA_union_tag { /* INA Stream Line 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE1_ADDR_INA_tag;

typedef union IPUS_S_LINE2_LEN_INA_union_tag { /* INA Stream Line 2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE2_LEN_INA_tag;

typedef union IPUS_S_CH2_CFG_INA_union_tag { /* INA Stream Line 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH2_CFG_INA_tag;

typedef union IPUS_S_LINE2_ADDR_INA_union_tag { /* INA Stream Line 2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE2_ADDR_INA_tag;

typedef union IPUS_S_LINE0_LEN_INB_union_tag { /* INB Stream Line 0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE0_LEN_INB_tag;

typedef union IPUS_S_CH0_CFG_INB_union_tag { /* INB Stream Line 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH0_CFG_INB_tag;

typedef union IPUS_S_LINE0_ADDR_INB_union_tag { /* INB Stream Line 0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE0_ADDR_INB_tag;

typedef union IPUS_S_LINE1_LEN_INB_union_tag { /* INB Stream Line 1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE1_LEN_INB_tag;

typedef union IPUS_S_CH1_CFG_INB_union_tag { /* INB Stream Line 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH1_CFG_INB_tag;

typedef union IPUS_S_LINE1_ADDR_INB_union_tag { /* INB Stream Line 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE1_ADDR_INB_tag;

typedef union IPUS_S_LINE2_LEN_INB_union_tag { /* INB Stream Line 2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE2_LEN_INB_tag;

typedef union IPUS_S_CH2_CFG_INB_union_tag { /* INB Stream Line 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH2_CFG_INB_tag;

typedef union IPUS_S_LINE2_ADDR_INB_union_tag { /* INB Stream Line 2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE2_ADDR_INB_tag;

typedef union IPUS_S_LINE0_LEN_INALPHA_union_tag { /* INALPHA Stream Line 0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE0_LEN_INALPHA_tag;

typedef union IPUS_S_CH0_CFG_INALPHA_union_tag { /* INALPHA Stream 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH0_CFG_INALPHA_tag;

typedef union IPUS_S_LINE0_ADDR_INALPHA_union_tag { /* INALPHA Stream Line 0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE0_ADDR_INALPHA_tag;

typedef union IPUS_S_LINE1_LEN_INALPHA_union_tag { /* INALPHA Stream Line 1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE1_LEN_INALPHA_tag;

typedef union IPUS_S_CH1_CFG_INALPHA_union_tag { /* INALPHA Stream 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH1_CFG_INALPHA_tag;

typedef union IPUS_S_LINE1_ADDR_INALPHA_union_tag { /* INALPHA Stream Line 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE1_ADDR_INALPHA_tag;

typedef union IPUS_S_LINE2_LEN_INALPHA_union_tag { /* INALPHA Stream Line 2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE2_LEN_INALPHA_tag;

typedef union IPUS_S_CH2_CFG_INALPHA_union_tag { /* INALPHA Stream 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH2_CFG_INALPHA_tag;

typedef union IPUS_S_LINE2_ADDR_INALPHA_union_tag { /* INALPHA Stream Line 2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_LINE2_ADDR_INALPHA_tag;

typedef union IPUS_S_LINE0_LEN_OUT_union_tag { /* Stream OUT 0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE0_LEN_OUT_tag;

typedef union IPUS_S_CH0_CFG_OUT_union_tag { /* Stream OUT 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH0_CFG_OUT_tag;

typedef union IPUS_S_LINE0_ADDR_OUT_union_tag { /* Stream OUT 0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_LINE0_ADDR_OUT_tag;

typedef union IPUS_S_LINE1_LEN_OUT_union_tag { /* Stream OUT 1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE1_LEN_OUT_tag;

typedef union IPUS_S_CH1_CFG_OUT_union_tag { /* Stream OUT 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH1_CFG_OUT_tag;

typedef union IPUS_S_LINE1_ADDR_OUT_union_tag { /* Stream OUT 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_LINE1_ADDR_OUT_tag;

typedef union IPUS_S_LINE2_LEN_OUT_union_tag { /* Stream OUT 2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE2_LEN_OUT_tag;

typedef union IPUS_S_CH2_CFG_OUT_union_tag { /* Stream OUT 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH2_CFG_OUT_tag;

typedef union IPUS_S_LINE2_ADDR_OUT_union_tag { /* Stream OUT 2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_LINE2_ADDR_OUT_tag;

typedef union IPUS_S_LINE3_LEN_OUT_union_tag { /* Stream OUT 3 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_LINE3_LEN_OUT_tag;

typedef union IPUS_S_CH3_CFG_OUT_union_tag { /* Stream OUT 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CH3_CFG_OUT_tag;

typedef union IPUS_S_LINE3_ADDR_OUT_union_tag { /* Stream OUT 3 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_LINE3_ADDR_OUT_tag;

typedef union IPUS_S_CURR_LINE0_LEN_INA_union_tag { /* Current INA Stream Line0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE0_LEN_INA_tag;

typedef union IPUS_S_CURR_CH0_CFG_INA_union_tag { /* Current INA Stream Channel0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH0_CFG_INA_tag;

typedef union IPUS_S_CURR_LINE0_ADDR_INA_union_tag { /* Current Stream Line0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE0_ADDR_INA_tag;

typedef union IPUS_S_CURR_LINE1_LEN_INA_union_tag { /* Current INA Stream Line1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE1_LEN_INA_tag;

typedef union IPUS_S_CURR_CH1_CFG_INA_union_tag { /* Current INA Stream Channel1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH1_CFG_INA_tag;

typedef union IPUS_S_CURR_LINE1_ADDR_INA_union_tag { /* Current INA Stream Line1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE1_ADDR_INA_tag;

typedef union IPUS_S_CURR_LINE2_LEN_INA_union_tag { /* Current INA Stream Line2 Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE2_LEN_INA_tag;

typedef union IPUS_S_CURR_CH2_CFG_INA_union_tag { /* Current INA Stream Channel2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH2_CFG_INA_tag;

typedef union IPUS_S_CURR_LINE2_ADDR_INA_union_tag { /* Current INA Stream Line2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE2_ADDR_INA_tag;

typedef union IPUS_S_CURR_LINE0_LEN_INB_union_tag { /* Current INB Stream Line0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE0_LEN_INB_tag;

typedef union IPUS_S_CURR_CH0_CFG_INB_union_tag { /* Current INB Stream Channel0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH0_CFG_INB_tag;

typedef union IPUS_S_CURR_LINE0_ADDR_INB_union_tag { /* Current INB Stream Line0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE0_ADDR_INB_tag;

typedef union IPUS_S_CURR_LINE1_LEN_INB_union_tag { /* Current INB Stream Line 1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE1_LEN_INB_tag;

typedef union IPUS_S_CURR_CH1_CFG_INB_union_tag { /* Current INB Stream Channel1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPEAT_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH1_CFG_INB_tag;

typedef union IPUS_S_CURR_LINE1_ADDR_INB_union_tag { /* Current INB Stream Line 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE1_ADDR_INB_tag;

typedef union IPUS_S_CURR_LINE2_LEN_INB_union_tag { /* Current INB Stream Line2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE2_LEN_INB_tag;

typedef union IPUS_S_CURR_CH2_CFG_INB_union_tag { /* Current INB Stream Channel2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH2_CFG_INB_tag;

typedef union IPUS_S_CURR_LINE2_ADDR_INB_union_tag { /* Current INB Stream Line2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE2_ADDR_INB_tag;

typedef union IPUS_S_CURR_LINE0_LEN_INALPHA_union_tag { /* Current INALPHA Stream Line0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE0_LEN_INALPHA_tag;

typedef union IPUS_S_CURR_CH0_CFG_INALPHA_union_tag { /* Current INALPHA Stream Channel0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH0_CFG_INALPHA_tag;

typedef union IPUS_S_CURR_LINE0_ADDR_INALPHA_union_tag { /* Current INALPHA Stream Line0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE0_ADDR_INALPHA_tag;

typedef union IPUS_S_CURR_LINE1_LEN_INALPHA_union_tag { /* Current INALPHA Stream Line1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE1_LEN_INALPHA_tag;

typedef union IPUS_S_CURR_CH1_CFG_INALPHA_union_tag { /* Current INALPHA Stream Channel1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH1_CFG_INALPHA_tag;

typedef union IPUS_S_CURR_LINE1_ADDR_INALPHA_union_tag { /* Current INALPHA Stream Line 1 Address register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE1_ADDR_INALPHA_tag;

typedef union IPUS_S_CURR_LINE2_LEN_INALPHA_union_tag { /* Current INALPHA Stream Line2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE2_LEN_INALPHA_tag;

typedef union IPUS_S_CURR_CH2_CFG_INALPHA_union_tag { /* Current INALPHA Stream Channel2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH2_CFG_INALPHA_tag;

typedef union IPUS_S_CURR_LINE2_ADDR_INALPHA_union_tag { /* Current INALPHA Stream Line2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUS_S_CURR_LINE2_ADDR_INALPHA_tag;

typedef union IPUS_S_CURR_LINE0_LEN_OUT_union_tag { /* Current OUT Stream Line0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE0_LEN_OUT_tag;

typedef union IPUS_S_CURR_CH0_CFG_OUT_union_tag { /* Current OUT Stream Channel0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH0_CFG_OUT_tag;

typedef union IPUS_S_CURR_LINE0_ADDR_OUT_union_tag { /* Current OUT Stream Line0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_CURR_LINE0_ADDR_OUT_tag;

typedef union IPUS_S_CURR_LINE1_LEN_OUT_union_tag { /* Current OUT Stream Line1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE1_LEN_OUT_tag;

typedef union IPUS_S_CURR_CH1_CFG_OUT_union_tag { /* Current OUT Stream Channel1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH1_CFG_OUT_tag;

typedef union IPUS_S_CURR_LINE1_ADDR_OUT_union_tag { /* Current OUT Stream Line1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_CURR_LINE1_ADDR_OUT_tag;

typedef union IPUS_S_CURR_LINE2_LEN_OUT_union_tag { /* Current OUT Stream Line2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE2_LEN_OUT_tag;

typedef union IPUS_S_CURR_CH2_CFG_OUT_union_tag { /* Current OUT Stream Channel2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH2_CFG_OUT_tag;

typedef union IPUS_S_CURR_LINE2_ADDR_OUT_union_tag { /* Current OUT Stream Line2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_CURR_LINE2_ADDR_OUT_tag;

typedef union IPUS_S_CURR_LINE3_LEN_OUT_union_tag { /* Current OUT Stream Line3 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUS_S_CURR_LINE3_LEN_OUT_tag;

typedef union IPUS_S_CURR_CH3_CFG_OUT_union_tag { /* Current OUT Stream Channel3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUS_S_CURR_CH3_CFG_OUT_tag;

typedef union IPUS_S_CURR_LINE3_ADDR_OUT_union_tag { /* Current OUT Stream Line3 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUS_S_CURR_LINE3_ADDR_OUT_tag;

typedef union IPUS_DEBUG_MS_union_tag { /* Debug Mode and Step Register */
  vuint32_t R;
  struct {
    vuint32_t DBG_ACT:1;
    vuint32_t CTI_EN:1;
    vuint32_t _unused_2:14;
    vuint32_t STEP:4;
    vuint32_t _unused_20:5;
    vuint32_t B_XPOS:1;
    vuint32_t B_YPOS:1;
    vuint32_t B_POS:1;
    vuint32_t B_IADDR:1;
    vuint32_t B_RADDR:1;
    vuint32_t B_WADDR:1;
    vuint32_t B_FINISH:1;
  } B;
} IPUS_DEBUG_MS_tag;

typedef union IPUS_DEBUG_BKPT_STAT_union_tag { /* Debug Breakpoint Status Register */
  vuint32_t R;
  struct {
    vuint32_t H_DBG:1;
    vuint32_t _unused_1:15;
    vuint32_t DBG:1;
    vuint32_t XPOS:1;
    vuint32_t YPOS:1;
    vuint32_t POS:1;
    vuint32_t IADDR:1;
    vuint32_t RADDR:1;
    vuint32_t WADDR:1;
    vuint32_t FINISH:1;
    vuint32_t _unused_24:1;
    vuint32_t STEP_REQ:1;
    vuint32_t _unused_26:6;
  } B;
} IPUS_DEBUG_BKPT_STAT_tag;

typedef union IPUS_DEBUG_BKPT_POS_union_tag { /* Debug Breakpoint Position Register */
  vuint32_t R;
  struct {
    vuint32_t YPOS:16;
    vuint32_t XPOS:16;
  } B;
} IPUS_DEBUG_BKPT_POS_tag;

typedef union IPUS_DEBUG_BKPT_ADDR_union_tag { /* Debug Breakpoint Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t DWADDR:8;
    vuint32_t DRADDR:8;
    vuint32_t IADDR:8;
  } B;
} IPUS_DEBUG_BKPT_ADDR_tag;

typedef union IPUS_DEBUG_CORE_STAT_union_tag { /* Debug Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t PC:8;
    vuint32_t _unused_8:16;
    vuint32_t OV:1;
    vuint32_t C:1;
    vuint32_t Z:1;
    vuint32_t N:1;
    vuint32_t _unused_28:4;
  } B;
} IPUS_DEBUG_CORE_STAT_tag;

typedef union IPUS_PMONITOR_CTRL_union_tag { /* Performance Monitor Control Register. */
  vuint32_t R;
  struct {
    vuint32_t EN_S_SIN:1;
    vuint32_t EN_S_SOUT:1;
    vuint32_t EN_S_SINOUT:1;
    vuint32_t EN_S_DH:1;
    vuint32_t EN_EX_CNT:1;
    vuint32_t _unused_5:3;
    vuint32_t STOP_S_SIN:1;
    vuint32_t STOP_S_SOUT:1;
    vuint32_t STOP_S_SINOUT:1;
    vuint32_t STOP_S_DH:1;
    vuint32_t STOP_EX_CNT:1;
    vuint32_t _unused_13:3;
    vuint32_t INIT_S_SIN:1;
    vuint32_t INIT_S_SOUT:1;
    vuint32_t INIT_S_SINOUT:1;
    vuint32_t INIT_S_DH:1;
    vuint32_t INIT_EX_CNT:1;
    vuint32_t _unused_21:11;
  } B;
} IPUS_PMONITOR_CTRL_tag;

typedef union IPUS_PMONITOR_SAMPLE_union_tag { /* Performance Monitor Sample Register */
  vuint32_t R;
  struct {
    vuint32_t SAMPLE_S_SIN:1;
    vuint32_t SAMPLE_S_SOUT:1;
    vuint32_t SAMPLE_S_SINOUT:1;
    vuint32_t SAMPLE_S_DH:1;
    vuint32_t SAMPLE_EX_CNT:1;
    vuint32_t _unused_5:27;
  } B;
} IPUS_PMONITOR_SAMPLE_tag;

typedef union IPUS_STALL_STREAMIN_union_tag { /* Stream-in Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUS_STALL_STREAMIN_tag;

typedef union IPUS_STALL_STREAMOUT_union_tag { /* Stream-out Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUS_STALL_STREAMOUT_tag;

typedef union IPUS_STALL_STREAMINOUT_union_tag { /* Stream-in and Stream-out Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUS_STALL_STREAMINOUT_tag;

typedef union IPUS_STALL_DATAHAZARD_union_tag { /* Data Hazard Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUS_STALL_DATAHAZARD_tag;

typedef union IPUS_EXEC_COUNTER_union_tag { /* Execution Cycle Counter */
  vuint32_t R;
  struct {
    vuint32_t CYCLES:32;
  } B;
} IPUS_EXEC_COUNTER_tag;

typedef union IPUS_IMEM_ERROR_INJECT_ADDR_union_tag { /* Instruction Memory Error Injection Address */
  vuint32_t R;
  struct {
    vuint32_t ADDR:6;
    vuint32_t _unused_6:26;
  } B;
} IPUS_IMEM_ERROR_INJECT_ADDR_tag;

typedef union IPUS_IMEM_ERROR_VECTOR0_union_tag { /* Instruction Memory Error Low Vector */
  vuint32_t R;
  struct {
    vuint32_t ERR_VEC0:32;
  } B;
} IPUS_IMEM_ERROR_VECTOR0_tag;

typedef union IPUS_IMEM_ERROR_VECTOR1_union_tag { /* Instruction Memory Error High Vector */
  vuint32_t R;
  struct {
    vuint32_t ERR_VEC1:7;
    vuint32_t _unused_7:24;
    vuint32_t ERR_EN:1;
  } B;
} IPUS_IMEM_ERROR_VECTOR1_tag;

typedef union IPUS_IMEM_ERROR_INJECT_STAT_union_tag { /* Instruction Memory Error Inject Status Register */
  vuint32_t R;
  struct {
    vuint32_t SEC:1;
    vuint32_t DED:1;
    vuint32_t _unused_2:6;
    vuint32_t SYNDROME:7;
    vuint32_t _unused_15:16;
    vuint32_t LOC_ACC:1;
  } B;
} IPUS_IMEM_ERROR_INJECT_STAT_tag;

typedef union IPUS_RESET_REG_union_tag { /* Reset Register */
  vuint32_t R;
  struct {
    vuint32_t SOFT_RESET:1;
    vuint32_t HARD_RESET:1;
    vuint32_t _unused_2:30;
  } B;
} IPUS_RESET_REG_tag;

struct IPUS_tag {
  IPUS_HOST_START_tag HOST_START;      /* Command and Start Register */
  uint32_t IPUS_reserved0[3];
  IPUS_HOST_STATUS_tag HOST_STATUS;    /* Core Status Register */
  uint32_t IPUS_reserved1[3];
  IPUS_HOST_POS_tag HOST_POS;          /* Position Configuration Register */
  uint32_t IPUS_reserved2[3];
  IPUS_HOST_CURRPOS_tag HOST_CURRPOS;  /* Current Position Status Register */
  uint32_t IPUS_reserved3[3];
  IPUS_HOST_XCFG_tag HOST_XCFG;        /* Line Width and Step Configuration Register */
  uint32_t IPUS_reserved4[3];
  IPUS_HOST_CURRXCFG_tag HOST_CURRXCFG; /* Current Line Width and Step Status Register */
  uint32_t IPUS_reserved5[3];
  IPUS_HOST_INACFG_tag HOST_INACFG;    /* INA Matrix Configuration Register */
  uint32_t IPUS_reserved6[3];
  IPUS_HOST_INBCFG_tag HOST_INBCFG;    /* INB Matrix Configuration Register */
  uint32_t IPUS_reserved7[3];
  IPUS_HOST_INALPHACFG_tag HOST_INALPHACFG; /* INALPHA Configuration Register */
  uint32_t IPUS_reserved8[3];
  IPUS_HOST_OUTCFG_tag HOST_OUTCFG;    /* OUT Matrix Configuration Register */
  uint32_t IPUS_reserved9[27];
  IPUS_HOST_IMEMA_tag HOST_IMEMA;      /* Instruction Memory Address Register */
  uint32_t IPUS_reserved10[3];
  IPUS_HOST_IMEMD_tag HOST_IMEMD;      /* Instruction Memory Data Register */
  uint32_t IPUS_reserved11[3];
  IPUS_HOST_DREGA_tag HOST_DREGA;      /* Data Register-Bank Address Register */
  uint32_t IPUS_reserved12[3];
  IPUS_HOST_DREGD_tag HOST_DREGD;      /* Data Register-Bank Datum Register */
  uint32_t IPUS_reserved13[3];
  IPUS_HOST_HISTA_tag HOST_HISTA;      /* Histogram Memory Address Register */
  uint32_t IPUS_reserved14[3];
  IPUS_HOST_HISTD_tag HOST_HISTD;      /* Histogram Memory Data Register */
  uint32_t IPUS_reserved15[3];
  IPUS_HOST_HISTPEAK_tag HOST_HISTPEAK; /* Histogram Peak Value Register */
  uint32_t IPUS_reserved16[3];
  IPUS_HOST_HISTAMAX_tag HOST_HISTAMAX; /* Histogram Maximum Value Address Register */
  uint32_t IPUS_reserved17[3];
  IPUS_HOST_HISTCLEAR_tag HOST_HISTCLEAR; /* Histogram Clear Register */
  uint32_t IPUS_reserved18[3];
  IPUS_HOST_STATA_tag HOST_STATA;      /* Statistics Memory Address Register */
  uint32_t IPUS_reserved19[3];
  IPUS_HOST_STATD_tag HOST_STATD;      /* Statistics Memory Data Register */
  uint32_t IPUS_reserved20[3];
  IPUS_HOST_STATCLEAR_tag HOST_STATCLEAR; /* Statistics Memory Clear Register */
  uint32_t IPUS_reserved21[11];
  IPUS_HOST_LUTA_tag HOST_LUTA;        /* LUT Memory Address Register */
  uint32_t IPUS_reserved22[3];
  IPUS_HOST_LUTD_tag HOST_LUTD;        /* LUT Memory Data Register */
  uint32_t IPUS_reserved23[135];
  IPUS_S_LINE0_LEN_INA_tag S_LINE0_LEN_INA; /* INA Stream Line 0 Length Register */
  uint32_t IPUS_reserved24[3];
  IPUS_S_CH0_CFG_INA_tag S_CH0_CFG_INA; /* INA Stream Line 0 Configuration Register */
  uint32_t IPUS_reserved25[3];
  IPUS_S_LINE0_ADDR_INA_tag S_LINE0_ADDR_INA; /* INA Stream Line 0 Address Register */
  uint32_t IPUS_reserved26[3];
  IPUS_S_LINE1_LEN_INA_tag S_LINE1_LEN_INA; /* INA Stream Line 1 Length Register */
  uint32_t IPUS_reserved27[3];
  IPUS_S_CH1_CFG_INA_tag S_CH1_CFG_INA; /* INA Stream Line 1 Configuration Register */
  uint32_t IPUS_reserved28[3];
  IPUS_S_LINE1_ADDR_INA_tag S_LINE1_ADDR_INA; /* INA Stream Line 1 Address Register */
  uint32_t IPUS_reserved29[3];
  IPUS_S_LINE2_LEN_INA_tag S_LINE2_LEN_INA; /* INA Stream Line 2 Length Register */
  uint32_t IPUS_reserved30[3];
  IPUS_S_CH2_CFG_INA_tag S_CH2_CFG_INA; /* INA Stream Line 2 Configuration Register */
  uint32_t IPUS_reserved31[3];
  IPUS_S_LINE2_ADDR_INA_tag S_LINE2_ADDR_INA; /* INA Stream Line 2 Address Register */
  uint32_t IPUS_reserved32[31];
  IPUS_S_LINE0_LEN_INB_tag S_LINE0_LEN_INB; /* INB Stream Line 0 Length Register */
  uint32_t IPUS_reserved33[3];
  IPUS_S_CH0_CFG_INB_tag S_CH0_CFG_INB; /* INB Stream Line 0 Configuration Register */
  uint32_t IPUS_reserved34[3];
  IPUS_S_LINE0_ADDR_INB_tag S_LINE0_ADDR_INB; /* INB Stream Line 0 Address Register */
  uint32_t IPUS_reserved35[3];
  IPUS_S_LINE1_LEN_INB_tag S_LINE1_LEN_INB; /* INB Stream Line 1 Length Register */
  uint32_t IPUS_reserved36[3];
  IPUS_S_CH1_CFG_INB_tag S_CH1_CFG_INB; /* INB Stream Line 1 Configuration Register */
  uint32_t IPUS_reserved37[3];
  IPUS_S_LINE1_ADDR_INB_tag S_LINE1_ADDR_INB; /* INB Stream Line 1 Address Register */
  uint32_t IPUS_reserved38[3];
  IPUS_S_LINE2_LEN_INB_tag S_LINE2_LEN_INB; /* INB Stream Line 2 Length Register */
  uint32_t IPUS_reserved39[3];
  IPUS_S_CH2_CFG_INB_tag S_CH2_CFG_INB; /* INB Stream Line 2 Configuration Register */
  uint32_t IPUS_reserved40[3];
  IPUS_S_LINE2_ADDR_INB_tag S_LINE2_ADDR_INB; /* INB Stream Line 2 Address Register */
  uint32_t IPUS_reserved41[31];
  IPUS_S_LINE0_LEN_INALPHA_tag S_LINE0_LEN_INALPHA; /* INALPHA Stream Line 0 Length Register */
  uint32_t IPUS_reserved42[3];
  IPUS_S_CH0_CFG_INALPHA_tag S_CH0_CFG_INALPHA; /* INALPHA Stream 0 Configuration Register */
  uint32_t IPUS_reserved43[3];
  IPUS_S_LINE0_ADDR_INALPHA_tag S_LINE0_ADDR_INALPHA; /* INALPHA Stream Line 0 Address Register */
  uint32_t IPUS_reserved44[3];
  IPUS_S_LINE1_LEN_INALPHA_tag S_LINE1_LEN_INALPHA; /* INALPHA Stream Line 1 Length Register */
  uint32_t IPUS_reserved45[3];
  IPUS_S_CH1_CFG_INALPHA_tag S_CH1_CFG_INALPHA; /* INALPHA Stream 1 Configuration Register */
  uint32_t IPUS_reserved46[3];
  IPUS_S_LINE1_ADDR_INALPHA_tag S_LINE1_ADDR_INALPHA; /* INALPHA Stream Line 1 Address Register */
  uint32_t IPUS_reserved47[3];
  IPUS_S_LINE2_LEN_INALPHA_tag S_LINE2_LEN_INALPHA; /* INALPHA Stream Line 2 Length Register */
  uint32_t IPUS_reserved48[3];
  IPUS_S_CH2_CFG_INALPHA_tag S_CH2_CFG_INALPHA; /* INALPHA Stream 2 Configuration Register */
  uint32_t IPUS_reserved49[3];
  IPUS_S_LINE2_ADDR_INALPHA_tag S_LINE2_ADDR_INALPHA; /* INALPHA Stream Line 2 Address Register */
  uint32_t IPUS_reserved50[31];
  IPUS_S_LINE0_LEN_OUT_tag S_LINE0_LEN_OUT; /* Stream OUT 0 Length Register */
  uint32_t IPUS_reserved51[3];
  IPUS_S_CH0_CFG_OUT_tag S_CH0_CFG_OUT; /* Stream OUT 0 Configuration Register */
  uint32_t IPUS_reserved52[3];
  IPUS_S_LINE0_ADDR_OUT_tag S_LINE0_ADDR_OUT; /* Stream OUT 0 Address Register */
  uint32_t IPUS_reserved53[3];
  IPUS_S_LINE1_LEN_OUT_tag S_LINE1_LEN_OUT; /* Stream OUT 1 Length Register */
  uint32_t IPUS_reserved54[3];
  IPUS_S_CH1_CFG_OUT_tag S_CH1_CFG_OUT; /* Stream OUT 1 Configuration Register */
  uint32_t IPUS_reserved55[3];
  IPUS_S_LINE1_ADDR_OUT_tag S_LINE1_ADDR_OUT; /* Stream OUT 1 Address Register */
  uint32_t IPUS_reserved56[3];
  IPUS_S_LINE2_LEN_OUT_tag S_LINE2_LEN_OUT; /* Stream OUT 2 Length Register */
  uint32_t IPUS_reserved57[3];
  IPUS_S_CH2_CFG_OUT_tag S_CH2_CFG_OUT; /* Stream OUT 2 Configuration Register */
  uint32_t IPUS_reserved58[3];
  IPUS_S_LINE2_ADDR_OUT_tag S_LINE2_ADDR_OUT; /* Stream OUT 2 Address Register */
  uint32_t IPUS_reserved59[3];
  IPUS_S_LINE3_LEN_OUT_tag S_LINE3_LEN_OUT; /* Stream OUT 3 Length Register */
  uint32_t IPUS_reserved60[3];
  IPUS_S_CH3_CFG_OUT_tag S_CH3_CFG_OUT; /* Stream OUT 3 Configuration Register */
  uint32_t IPUS_reserved61[3];
  IPUS_S_LINE3_ADDR_OUT_tag S_LINE3_ADDR_OUT; /* Stream OUT 3 Address Register */
  uint32_t IPUS_reserved62[19];
  IPUS_S_CURR_LINE0_LEN_INA_tag S_CURR_LINE0_LEN_INA; /* Current INA Stream Line0 Length Register */
  uint32_t IPUS_reserved63[3];
  IPUS_S_CURR_CH0_CFG_INA_tag S_CURR_CH0_CFG_INA; /* Current INA Stream Channel0 Configuration Register */
  uint32_t IPUS_reserved64[3];
  IPUS_S_CURR_LINE0_ADDR_INA_tag S_CURR_LINE0_ADDR_INA; /* Current Stream Line0 Address Register */
  uint32_t IPUS_reserved65[3];
  IPUS_S_CURR_LINE1_LEN_INA_tag S_CURR_LINE1_LEN_INA; /* Current INA Stream Line1 Length Register */
  uint32_t IPUS_reserved66[3];
  IPUS_S_CURR_CH1_CFG_INA_tag S_CURR_CH1_CFG_INA; /* Current INA Stream Channel1 Configuration Register */
  uint32_t IPUS_reserved67[3];
  IPUS_S_CURR_LINE1_ADDR_INA_tag S_CURR_LINE1_ADDR_INA; /* Current INA Stream Line1 Address Register */
  uint32_t IPUS_reserved68[3];
  IPUS_S_CURR_LINE2_LEN_INA_tag S_CURR_LINE2_LEN_INA; /* Current INA Stream Line2 Register */
  uint32_t IPUS_reserved69[3];
  IPUS_S_CURR_CH2_CFG_INA_tag S_CURR_CH2_CFG_INA; /* Current INA Stream Channel2 Configuration Register */
  uint32_t IPUS_reserved70[3];
  IPUS_S_CURR_LINE2_ADDR_INA_tag S_CURR_LINE2_ADDR_INA; /* Current INA Stream Line2 Address Register */
  uint32_t IPUS_reserved71[31];
  IPUS_S_CURR_LINE0_LEN_INB_tag S_CURR_LINE0_LEN_INB; /* Current INB Stream Line0 Length Register */
  uint32_t IPUS_reserved72[3];
  IPUS_S_CURR_CH0_CFG_INB_tag S_CURR_CH0_CFG_INB; /* Current INB Stream Channel0 Configuration Register */
  uint32_t IPUS_reserved73[3];
  IPUS_S_CURR_LINE0_ADDR_INB_tag S_CURR_LINE0_ADDR_INB; /* Current INB Stream Line0 Address Register */
  uint32_t IPUS_reserved74[3];
  IPUS_S_CURR_LINE1_LEN_INB_tag S_CURR_LINE1_LEN_INB; /* Current INB Stream Line 1 Length Register */
  uint32_t IPUS_reserved75[3];
  IPUS_S_CURR_CH1_CFG_INB_tag S_CURR_CH1_CFG_INB; /* Current INB Stream Channel1 Configuration Register */
  uint32_t IPUS_reserved76[3];
  IPUS_S_CURR_LINE1_ADDR_INB_tag S_CURR_LINE1_ADDR_INB; /* Current INB Stream Line 1 Address Register */
  uint32_t IPUS_reserved77[3];
  IPUS_S_CURR_LINE2_LEN_INB_tag S_CURR_LINE2_LEN_INB; /* Current INB Stream Line2 Length Register */
  uint32_t IPUS_reserved78[3];
  IPUS_S_CURR_CH2_CFG_INB_tag S_CURR_CH2_CFG_INB; /* Current INB Stream Channel2 Configuration Register */
  uint32_t IPUS_reserved79[3];
  IPUS_S_CURR_LINE2_ADDR_INB_tag S_CURR_LINE2_ADDR_INB; /* Current INB Stream Line2 Address Register */
  uint32_t IPUS_reserved80[31];
  IPUS_S_CURR_LINE0_LEN_INALPHA_tag S_CURR_LINE0_LEN_INALPHA; /* Current INALPHA Stream Line0 Length Register */
  uint32_t IPUS_reserved81[3];
  IPUS_S_CURR_CH0_CFG_INALPHA_tag S_CURR_CH0_CFG_INALPHA; /* Current INALPHA Stream Channel0 Configuration Register */
  uint32_t IPUS_reserved82[3];
  IPUS_S_CURR_LINE0_ADDR_INALPHA_tag S_CURR_LINE0_ADDR_INALPHA; /* Current INALPHA Stream Line0 Address Register */
  uint32_t IPUS_reserved83[3];
  IPUS_S_CURR_LINE1_LEN_INALPHA_tag S_CURR_LINE1_LEN_INALPHA; /* Current INALPHA Stream Line1 Length Register */
  uint32_t IPUS_reserved84[3];
  IPUS_S_CURR_CH1_CFG_INALPHA_tag S_CURR_CH1_CFG_INALPHA; /* Current INALPHA Stream Channel1 Configuration Register */
  uint32_t IPUS_reserved85[3];
  IPUS_S_CURR_LINE1_ADDR_INALPHA_tag S_CURR_LINE1_ADDR_INALPHA; /* Current INALPHA Stream Line 1 Address register */
  uint32_t IPUS_reserved86[3];
  IPUS_S_CURR_LINE2_LEN_INALPHA_tag S_CURR_LINE2_LEN_INALPHA; /* Current INALPHA Stream Line2 Length Register */
  uint32_t IPUS_reserved87[3];
  IPUS_S_CURR_CH2_CFG_INALPHA_tag S_CURR_CH2_CFG_INALPHA; /* Current INALPHA Stream Channel2 Configuration Register */
  uint32_t IPUS_reserved88[3];
  IPUS_S_CURR_LINE2_ADDR_INALPHA_tag S_CURR_LINE2_ADDR_INALPHA; /* Current INALPHA Stream Line2 Address Register */
  uint32_t IPUS_reserved89[31];
  IPUS_S_CURR_LINE0_LEN_OUT_tag S_CURR_LINE0_LEN_OUT; /* Current OUT Stream Line0 Length Register */
  uint32_t IPUS_reserved90[3];
  IPUS_S_CURR_CH0_CFG_OUT_tag S_CURR_CH0_CFG_OUT; /* Current OUT Stream Channel0 Configuration Register */
  uint32_t IPUS_reserved91[3];
  IPUS_S_CURR_LINE0_ADDR_OUT_tag S_CURR_LINE0_ADDR_OUT; /* Current OUT Stream Line0 Address Register */
  uint32_t IPUS_reserved92[3];
  IPUS_S_CURR_LINE1_LEN_OUT_tag S_CURR_LINE1_LEN_OUT; /* Current OUT Stream Line1 Length Register */
  uint32_t IPUS_reserved93[3];
  IPUS_S_CURR_CH1_CFG_OUT_tag S_CURR_CH1_CFG_OUT; /* Current OUT Stream Channel1 Configuration Register */
  uint32_t IPUS_reserved94[3];
  IPUS_S_CURR_LINE1_ADDR_OUT_tag S_CURR_LINE1_ADDR_OUT; /* Current OUT Stream Line1 Address Register */
  uint32_t IPUS_reserved95[3];
  IPUS_S_CURR_LINE2_LEN_OUT_tag S_CURR_LINE2_LEN_OUT; /* Current OUT Stream Line2 Length Register */
  uint32_t IPUS_reserved96[3];
  IPUS_S_CURR_CH2_CFG_OUT_tag S_CURR_CH2_CFG_OUT; /* Current OUT Stream Channel2 Configuration Register */
  uint32_t IPUS_reserved97[3];
  IPUS_S_CURR_LINE2_ADDR_OUT_tag S_CURR_LINE2_ADDR_OUT; /* Current OUT Stream Line2 Address Register */
  uint32_t IPUS_reserved98[3];
  IPUS_S_CURR_LINE3_LEN_OUT_tag S_CURR_LINE3_LEN_OUT; /* Current OUT Stream Line3 Length Register */
  uint32_t IPUS_reserved99[3];
  IPUS_S_CURR_CH3_CFG_OUT_tag S_CURR_CH3_CFG_OUT; /* Current OUT Stream Channel3 Configuration Register */
  uint32_t IPUS_reserved100[3];
  IPUS_S_CURR_LINE3_ADDR_OUT_tag S_CURR_LINE3_ADDR_OUT; /* Current OUT Stream Line3 Address Register */
  uint32_t IPUS_reserved101[271];
  IPUS_DEBUG_MS_tag DEBUG_MS;          /* Debug Mode and Step Register */
  uint32_t IPUS_reserved102[3];
  IPUS_DEBUG_BKPT_STAT_tag DEBUG_BKPT_STAT; /* Debug Breakpoint Status Register */
  uint32_t IPUS_reserved103[3];
  IPUS_DEBUG_BKPT_POS_tag DEBUG_BKPT_POS; /* Debug Breakpoint Position Register */
  uint32_t IPUS_reserved104[3];
  IPUS_DEBUG_BKPT_ADDR_tag DEBUG_BKPT_ADDR; /* Debug Breakpoint Address Register */
  uint32_t IPUS_reserved105[7];
  IPUS_DEBUG_CORE_STAT_tag DEBUG_CORE_STAT; /* Debug Core Status Register */
  uint32_t IPUS_reserved106[235];
  IPUS_PMONITOR_CTRL_tag PMONITOR_CTRL; /* Performance Monitor Control Register. */
  uint32_t IPUS_reserved107[3];
  IPUS_PMONITOR_SAMPLE_tag PMONITOR_SAMPLE; /* Performance Monitor Sample Register */
  uint32_t IPUS_reserved108[3];
  IPUS_STALL_STREAMIN_tag STALL_STREAMIN; /* Stream-in Stall Counter */
  uint32_t IPUS_reserved109[3];
  IPUS_STALL_STREAMOUT_tag STALL_STREAMOUT; /* Stream-out Stall Counter */
  uint32_t IPUS_reserved110[3];
  IPUS_STALL_STREAMINOUT_tag STALL_STREAMINOUT; /* Stream-in and Stream-out Stall Counter */
  uint32_t IPUS_reserved111[3];
  IPUS_STALL_DATAHAZARD_tag STALL_DATAHAZARD; /* Data Hazard Stall Counter */
  uint32_t IPUS_reserved112[3];
  IPUS_EXEC_COUNTER_tag EXEC_COUNTER;  /* Execution Cycle Counter */
  uint32_t IPUS_reserved113[103];
  IPUS_IMEM_ERROR_INJECT_ADDR_tag IMEM_ERROR_INJECT_ADDR; /* Instruction Memory Error Injection Address */
  uint32_t IPUS_reserved114[3];
  IPUS_IMEM_ERROR_VECTOR0_tag IMEM_ERROR_VECTOR0; /* Instruction Memory Error Low Vector */
  uint32_t IPUS_reserved115[3];
  IPUS_IMEM_ERROR_VECTOR1_tag IMEM_ERROR_VECTOR1; /* Instruction Memory Error High Vector */
  uint32_t IPUS_reserved116[3];
  IPUS_IMEM_ERROR_INJECT_STAT_tag IMEM_ERROR_INJECT_STAT; /* Instruction Memory Error Inject Status Register */
  uint32_t IPUS_reserved117[115];
  IPUS_RESET_REG_tag RESET_REG;        /* Reset Register */
};


/* ============================================================================
   =============================== Module: IPUV ===============================
   ============================================================================ */

typedef union IPUV_HOST_START_union_tag { /* Command and Start Register */
  vuint32_t R;
  struct {
    vuint32_t NSA:8;
    vuint32_t _unused_8:8;
    vuint32_t CSA:8;
    vuint32_t _unused_24:8;
  } B;
} IPUV_HOST_START_tag;

typedef union IPUV_HOST_STATUS_union_tag { /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t N_EVENTS:2;
    vuint32_t _unused_2:6;
    vuint32_t CORE_STATUS:2;           /* This field indicates the IPUV core status and number of triggers that has been buffered. */
    vuint32_t DEBUG_STATUS:1;          /* This field provides the debug status of the IPUV core. */
    vuint32_t _unused_11:5;
    vuint32_t REMAIN_PIXELS:16;
  } B;
} IPUV_HOST_STATUS_tag;

typedef union IPUV_HOST_POS_union_tag { /* Position Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t YPOS:16;
    vuint32_t XPOS:16;
  } B;
} IPUV_HOST_POS_tag;

typedef union IPUV_HOST_CURRPOS_union_tag { /* Current Position Status Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_YPOS:16;
    vuint32_t CURR_XPOS:16;
  } B;
} IPUV_HOST_CURRPOS_tag;

typedef union IPUV_HOST_XCFG_union_tag { /* Line Width and Step configuration Register */
  vuint32_t R;
  struct {
    vuint32_t XSTEP:2;
    vuint32_t _unused_2:14;
    vuint32_t XSIZE:16;
  } B;
} IPUV_HOST_XCFG_tag;

typedef union IPUV_HOST_CURRXCFG_union_tag { /* Current Line width and Step Status Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_XSTEP:2;            /* This field indicates the current XSTEP being used for processing. */
    vuint32_t _unused_2:14;
    vuint32_t CURR_XSIZE:16;
  } B;
} IPUV_HOST_CURRXCFG_tag;

typedef union IPUV_HOST_INCFG_union_tag { /* IN Matrix Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t IN_SHIFT:2;
    vuint32_t NHOOD:1;
    vuint32_t _unused_3:5;
    vuint32_t EN_LINE0:1;
    vuint32_t EN_LINE1:1;
    vuint32_t EN_LINE2:1;
    vuint32_t EN_LINE3:1;
    vuint32_t EN_LINE4:1;
    vuint32_t _unused_13:3;
    vuint32_t CURR_IN_SHIFT:2;
    vuint32_t CURR_NHOOD:1;
    vuint32_t _unused_19:5;
    vuint32_t CURR_EN_LINE0:1;
    vuint32_t CURR_EN_LINE1:1;
    vuint32_t CURR_EN_LINE2:1;
    vuint32_t CURR_EN_LINE3:1;
    vuint32_t CURR_EN_LINE4:1;
    vuint32_t _unused_29:3;
  } B;
} IPUV_HOST_INCFG_tag;

typedef union IPUV_HOST_OUTCFG_union_tag { /* OUT Matrix Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OUT_SHIFT:2;             /* This field indicates the number of elements in the OUT matrix 1x4 vector that will be shifted on the stream interface while execution of the next line. Shift of OUT matrix happens when a DONE instruction with 'o' flag set is executed, and the shifted out elements are written onto the stream-out interface while the matrix elements are left unchanged i.e. the shift operation is a function that writes (i.e. shifts) out a number of matrix elements onto the stream-out interface. */
    vuint32_t _unused_2:6;
    vuint32_t EN_OUT0:1;
    vuint32_t EN_OUT1:1;
    vuint32_t EN_OUT2:1;
    vuint32_t _unused_11:5;
    vuint32_t CURR_OUT_SHIFT:2;
    vuint32_t _unused_18:6;
    vuint32_t CURR_EN_OUT0:1;
    vuint32_t CURR_EN_OUT1:1;
    vuint32_t CURR_EN_OUT2:1;
    vuint32_t _unused_27:5;
  } B;
} IPUV_HOST_OUTCFG_tag;

typedef union IPUV_HOST_IMEMA_union_tag { /* Instruction Memory Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR:6;
    vuint32_t _unused_6:26;
  } B;
} IPUV_HOST_IMEMA_tag;

typedef union IPUV_HOST_IMEMD_union_tag { /* Instruction Memory Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} IPUV_HOST_IMEMD_tag;

typedef union IPUV_HOST_DREGA_union_tag { /* Data Register-Bank Address Register */
  vuint32_t R;
  struct {
    vuint32_t DMEMA:8;
    vuint32_t _unused_8:24;
  } B;
} IPUV_HOST_DREGA_tag;

typedef union IPUV_HOST_DREGD_union_tag { /* Data Register-Bank Datum Register */
  vuint32_t R;
  struct {
    vuint32_t DMEMD:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_HOST_DREGD_tag;

typedef union IPUV_S_LINE0_LEN_IN_union_tag { /* IN Stream Line0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE0_LEN_IN_tag;

typedef union IPUV_S_CH0_CFG_IN_union_tag { /* IN Stream Line0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH0_CFG_IN_tag;

typedef union IPUV_S_LINE0_ADDR_IN_union_tag { /* IN Stream Line0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_LINE0_ADDR_IN_tag;

typedef union IPUV_S_LINE1_LEN_IN_union_tag { /* IN Stream Line1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE1_LEN_IN_tag;

typedef union IPUV_S_CH1_CFG_IN_union_tag { /* IN Stream Line1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH1_CFG_IN_tag;

typedef union IPUV_S_LINE1_ADDR_IN_union_tag { /* IN Stream Line1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_LINE1_ADDR_IN_tag;

typedef union IPUV_S_LINE2_LEN_IN_union_tag { /* IN Stream Line2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE2_LEN_IN_tag;

typedef union IPUV_S_CH2_CFG_IN_union_tag { /* IN Stream Line2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH2_CFG_IN_tag;

typedef union IPUV_S_LINE2_ADDR_IN_union_tag { /* IN Stream Line2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_LINE2_ADDR_IN_tag;

typedef union IPUV_S_LINE3_LEN_IN_union_tag { /* IN Stream Line3 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE3_LEN_IN_tag;

typedef union IPUV_S_CH3_CFG_IN_union_tag { /* IN Stream Line3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH3_CFG_IN_tag;

typedef union IPUV_S_LINE3_ADDR_IN_union_tag { /* IN Stream Line3 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_LINE3_ADDR_IN_tag;

typedef union IPUV_S_LINE4_LEN_IN_union_tag { /* IN Stream Line4 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE4_LEN_IN_tag;

typedef union IPUV_S_CH4_CFG_IN_union_tag { /* IN Stream Line4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH4_CFG_IN_tag;

typedef union IPUV_S_LINE4_ADDR_IN_union_tag { /* IN Stream Line4 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_LINE4_ADDR_IN_tag;

typedef union IPUV_S_LINE0_LEN_OUT_union_tag { /* Stream Out0 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE0_LEN_OUT_tag;

typedef union IPUV_S_CH0_CFG_OUT_union_tag { /* Stream Out0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH0_CFG_OUT_tag;

typedef union IPUV_S_LINE0_ADDR_OUT_union_tag { /* Stream Out0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_LINE0_ADDR_OUT_tag;

typedef union IPUV_S_LINE1_LEN_OUT_union_tag { /* Stream Out1 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE1_LEN_OUT_tag;

typedef union IPUV_S_CH1_CFG_OUT_union_tag { /* Stream Out1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH1_CFG_OUT_tag;

typedef union IPUV_S_LINE1_ADDR_OUT_union_tag { /* Stream Out1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_LINE1_ADDR_OUT_tag;

typedef union IPUV_S_LINE2_LEN_OUT_union_tag { /* Stream Out2 Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_LINE2_LEN_OUT_tag;

typedef union IPUV_S_CH2_CFG_OUT_union_tag { /* Stream Out2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CH2_CFG_OUT_tag;

typedef union IPUV_S_LINE2_ADDR_OUT_union_tag { /* Stream Out2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_LINE2_ADDR_OUT_tag;

typedef union IPUV_S_CURR_LINE0_LEN_IN_union_tag { /* IN Stream Line0 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE0_LEN_IN_tag;

typedef union IPUV_S_CURR_CH0_CFG_IN_union_tag { /* IN Stream Line0 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH0_CFG_IN_tag;

typedef union IPUV_S_CURR_LINE0_ADDR_IN_union_tag { /* IN Stream Line0 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_CURR_LINE0_ADDR_IN_tag;

typedef union IPUV_S_CURR_LINE1_LEN_IN_union_tag { /* IN Stream Line1 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE1_LEN_IN_tag;

typedef union IPUV_S_CURR_CH1_CFG_IN_union_tag { /* IN Stream Line1 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH1_CFG_IN_tag;

typedef union IPUV_S_CURR_LINE1_ADDR_IN_union_tag { /* IN Stream Line1 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_CURR_LINE1_ADDR_IN_tag;

typedef union IPUV_S_CURR_LINE2_LEN_IN_union_tag { /* IN Stream Line2 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE2_LEN_IN_tag;

typedef union IPUV_S_CURR_CH2_CFG_IN_union_tag { /* IN Stream Line2 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH2_CFG_IN_tag;

typedef union IPUV_S_CURR_LINE2_ADDR_IN_union_tag { /* IN Stream Line2 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_CURR_LINE2_ADDR_IN_tag;

typedef union IPUV_S_CURR_LINE3_LEN_IN_union_tag { /* IN Stream Line3 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE3_LEN_IN_tag;

typedef union IPUV_S_CURR_CH3_CFG_IN_union_tag { /* IN Stream Line3 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH3_CFG_IN_tag;

typedef union IPUV_S_CURR_LINE3_ADDR_IN_union_tag { /* IN Stream Line3 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_CURR_LINE3_ADDR_IN_tag;

typedef union IPUV_S_CURR_LINE4_LEN_IN_union_tag { /* IN Stream Line4 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE4_LEN_IN_tag;

typedef union IPUV_S_CURR_CH4_CFG_IN_union_tag { /* IN Stream Line4 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REPLACE_VAL:16;
    vuint32_t STEP:2;
    vuint32_t RPT:2;
    vuint32_t REPLACE_MODE:3;
    vuint32_t REVERSE:1;
    vuint32_t REPLACE_WIDTH:3;
    vuint32_t _unused_27:1;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH4_CFG_IN_tag;

typedef union IPUV_S_CURR_LINE4_ADDR_IN_union_tag { /* IN Stream Line4 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} IPUV_S_CURR_LINE4_ADDR_IN_tag;

typedef union IPUV_S_CURR_LINE0_LEN_OUT_union_tag { /* Stream Out0 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE0_LEN_OUT_tag;

typedef union IPUV_S_CURR_CH0_CFG_OUT_union_tag { /* Stream Out0 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH0_CFG_OUT_tag;

typedef union IPUV_S_CURR_LINE0_ADDR_OUT_union_tag { /* Stream Out0 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_CURR_LINE0_ADDR_OUT_tag;

typedef union IPUV_S_CURR_LINE1_LEN_OUT_union_tag { /* Stream Out1 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE1_LEN_OUT_tag;

typedef union IPUV_S_CURR_CH1_CFG_OUT_union_tag { /* Stream Out1 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH1_CFG_OUT_tag;

typedef union IPUV_S_CURR_LINE1_ADDR_OUT_union_tag { /* Stream Out1 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_CURR_LINE1_ADDR_OUT_tag;

typedef union IPUV_S_CURR_LINE2_LEN_OUT_union_tag { /* Stream Out2 Current Length Register */
  vuint32_t R;
  struct {
    vuint32_t LENGTH:16;
    vuint32_t _unused_16:16;
  } B;
} IPUV_S_CURR_LINE2_LEN_OUT_tag;

typedef union IPUV_S_CURR_CH2_CFG_OUT_union_tag { /* Stream Out2 Current Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SKIP:2;
    vuint32_t _unused_18:10;
    vuint32_t TYPE:2;
    vuint32_t _unused_30:2;
  } B;
} IPUV_S_CURR_CH2_CFG_OUT_tag;

typedef union IPUV_S_CURR_LINE2_ADDR_OUT_union_tag { /* Stream Out2 Current Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} IPUV_S_CURR_LINE2_ADDR_OUT_tag;

typedef union IPUV_DEBUG_MS_union_tag { /* Debug Mode and Step Register */
  vuint32_t R;
  struct {
    vuint32_t DBG_ACT:1;
    vuint32_t CTI_EN:1;
    vuint32_t _unused_2:14;
    vuint32_t STEP:4;
    vuint32_t _unused_20:5;
    vuint32_t B_XPOS:1;
    vuint32_t B_YPOS:1;
    vuint32_t B_POS:1;
    vuint32_t B_IADDR:1;
    vuint32_t B_RADDR:1;
    vuint32_t B_WADDR:1;
    vuint32_t B_FINISH:1;
  } B;
} IPUV_DEBUG_MS_tag;

typedef union IPUV_DEBUG_BKPT_STAT_union_tag { /* Debug Breakpoint Status Register */
  vuint32_t R;
  struct {
    vuint32_t H_DBG:1;
    vuint32_t _unused_1:15;
    vuint32_t DBG:1;
    vuint32_t XPOS:1;
    vuint32_t YPOS:1;
    vuint32_t POS:1;
    vuint32_t IADDR:1;
    vuint32_t RADDR:1;
    vuint32_t WADDR:1;
    vuint32_t FINISH:1;
    vuint32_t _unused_24:1;
    vuint32_t STEP_REQ:1;
    vuint32_t _unused_26:6;
  } B;
} IPUV_DEBUG_BKPT_STAT_tag;

typedef union IPUV_DEBUG_BKPT_POS_union_tag { /* Debug Breakpoint Position Register */
  vuint32_t R;
  struct {
    vuint32_t YPOS:16;
    vuint32_t XPOS:16;
  } B;
} IPUV_DEBUG_BKPT_POS_tag;

typedef union IPUV_DEBUG_BKPT_ADDR_union_tag { /* Debug Breakpoint Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t DWADDR:8;
    vuint32_t DRADDR:8;
    vuint32_t IADDR:8;
  } B;
} IPUV_DEBUG_BKPT_ADDR_tag;

typedef union IPUV_DEBUG_CORE_STAT_union_tag { /* Debug Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t PC:8;
    vuint32_t _unused_8:16;
    vuint32_t OV:1;
    vuint32_t C:1;
    vuint32_t Z:1;
    vuint32_t N:1;
    vuint32_t _unused_28:4;
  } B;
} IPUV_DEBUG_CORE_STAT_tag;

typedef union IPUV_PMONITOR_CTRL_union_tag { /* Performance Monitor Control Register */
  vuint32_t R;
  struct {
    vuint32_t EN_S_SIN:1;
    vuint32_t EN_S_SOUT:1;
    vuint32_t EN_S_SINOUT:1;
    vuint32_t EN_S_DH:1;
    vuint32_t EN_EX_CNT:1;
    vuint32_t _unused_5:3;
    vuint32_t STOP_S_SIN:1;
    vuint32_t STOP_S_SOUT:1;
    vuint32_t STOP_S_SINOUT:1;
    vuint32_t STOP_S_DH:1;
    vuint32_t STOP_EX_CNT:1;
    vuint32_t _unused_13:3;
    vuint32_t INIT_S_SIN:1;
    vuint32_t INIT_S_SOUT:1;
    vuint32_t INIT_S_SINOUT:1;
    vuint32_t INIT_S_DH:1;
    vuint32_t INIT_EX_CNT:1;
    vuint32_t _unused_21:11;
  } B;
} IPUV_PMONITOR_CTRL_tag;

typedef union IPUV_PMONITOR_SAMPLE_union_tag { /* Performance Monitor Sample Register */
  vuint32_t R;
  struct {
    vuint32_t SAMPLE_S_SIN:1;
    vuint32_t SAMPLE_S_SOUT:1;
    vuint32_t SAMPLE_S_SINOUT:1;
    vuint32_t SAMPLE_S_DH:1;
    vuint32_t SAMPLE_EX_CNT:1;
    vuint32_t _unused_5:27;
  } B;
} IPUV_PMONITOR_SAMPLE_tag;

typedef union IPUV_STALL_STREAMIN_union_tag { /* Stream-in Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUV_STALL_STREAMIN_tag;

typedef union IPUV_STALL_STREAMOUT_union_tag { /* Stream-out Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUV_STALL_STREAMOUT_tag;

typedef union IPUV_STALL_STREAMINOUT_union_tag { /* Stream-in and Stream-out Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUV_STALL_STREAMINOUT_tag;

typedef union IPUV_STALL_DATAHAZARD_union_tag { /* Data Hazard Stall Counter */
  vuint32_t R;
  struct {
    vuint32_t STALLS:32;
  } B;
} IPUV_STALL_DATAHAZARD_tag;

typedef union IPUV_EXEC_COUNTER_union_tag { /* Execution Cycle Counter */
  vuint32_t R;
  struct {
    vuint32_t CYCLES:32;
  } B;
} IPUV_EXEC_COUNTER_tag;

typedef union IPUV_IMEM_ERROR_INJECT_ADDR_union_tag { /* IMEM Error Inject Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:6;
    vuint32_t _unused_6:26;
  } B;
} IPUV_IMEM_ERROR_INJECT_ADDR_tag;

typedef union IPUV_IMEM_ERROR_VECTOR0_union_tag { /* IMEM Error Inject Vector0 */
  vuint32_t R;
  struct {
    vuint32_t ERR_VEC0:32;
  } B;
} IPUV_IMEM_ERROR_VECTOR0_tag;

typedef union IPUV_IMEM_ERROR_VECTOR1_union_tag { /* IMEM Error Inject Vector1 */
  vuint32_t R;
  struct {
    vuint32_t ERR_VEC1:7;
    vuint32_t _unused_7:24;
    vuint32_t ERR_EN:1;
  } B;
} IPUV_IMEM_ERROR_VECTOR1_tag;

typedef union IPUV_IMEM_ERROR_INJECT_STAT_union_tag { /* IMEM Error Injection Status register */
  vuint32_t R;
  struct {
    vuint32_t SEC:1;
    vuint32_t DED:1;
    vuint32_t _unused_2:6;
    vuint32_t SYNDROME:7;
    vuint32_t _unused_15:16;
    vuint32_t LOC_ACC:1;
  } B;
} IPUV_IMEM_ERROR_INJECT_STAT_tag;

typedef union IPUV_RESET_REG_union_tag { /* Reset Register */
  vuint32_t R;
  struct {
    vuint32_t SOFT_RESET:1;
    vuint32_t HARD_RESET:1;
    vuint32_t _unused_2:30;
  } B;
} IPUV_RESET_REG_tag;

struct IPUV_tag {
  IPUV_HOST_START_tag HOST_START;      /* Command and Start Register */
  uint32_t IPUV_reserved0[3];
  IPUV_HOST_STATUS_tag HOST_STATUS;    /* Core Status Register */
  uint32_t IPUV_reserved1[3];
  IPUV_HOST_POS_tag HOST_POS;          /* Position Configuration Register */
  uint32_t IPUV_reserved2[3];
  IPUV_HOST_CURRPOS_tag HOST_CURRPOS;  /* Current Position Status Register */
  uint32_t IPUV_reserved3[3];
  IPUV_HOST_XCFG_tag HOST_XCFG;        /* Line Width and Step configuration Register */
  uint32_t IPUV_reserved4[3];
  IPUV_HOST_CURRXCFG_tag HOST_CURRXCFG; /* Current Line width and Step Status Register */
  uint32_t IPUV_reserved5[3];
  IPUV_HOST_INCFG_tag HOST_INCFG;      /* IN Matrix Configuration Register */
  uint32_t IPUV_reserved6[11];
  IPUV_HOST_OUTCFG_tag HOST_OUTCFG;    /* OUT Matrix Configuration Register */
  uint32_t IPUV_reserved7[27];
  IPUV_HOST_IMEMA_tag HOST_IMEMA;      /* Instruction Memory Address Register */
  uint32_t IPUV_reserved8[3];
  IPUV_HOST_IMEMD_tag HOST_IMEMD;      /* Instruction Memory Data Register */
  uint32_t IPUV_reserved9[3];
  IPUV_HOST_DREGA_tag HOST_DREGA;      /* Data Register-Bank Address Register */
  uint32_t IPUV_reserved10[3];
  IPUV_HOST_DREGD_tag HOST_DREGD;      /* Data Register-Bank Datum Register */
  uint32_t IPUV_reserved11[183];
  IPUV_S_LINE0_LEN_IN_tag S_LINE0_LEN_IN; /* IN Stream Line0 Length Register */
  uint32_t IPUV_reserved12[3];
  IPUV_S_CH0_CFG_IN_tag S_CH0_CFG_IN;  /* IN Stream Line0 Configuration Register */
  uint32_t IPUV_reserved13[3];
  IPUV_S_LINE0_ADDR_IN_tag S_LINE0_ADDR_IN; /* IN Stream Line0 Address Register */
  uint32_t IPUV_reserved14[3];
  IPUV_S_LINE1_LEN_IN_tag S_LINE1_LEN_IN; /* IN Stream Line1 Length Register */
  uint32_t IPUV_reserved15[3];
  IPUV_S_CH1_CFG_IN_tag S_CH1_CFG_IN;  /* IN Stream Line1 Configuration Register */
  uint32_t IPUV_reserved16[3];
  IPUV_S_LINE1_ADDR_IN_tag S_LINE1_ADDR_IN; /* IN Stream Line1 Address Register */
  uint32_t IPUV_reserved17[3];
  IPUV_S_LINE2_LEN_IN_tag S_LINE2_LEN_IN; /* IN Stream Line2 Length Register */
  uint32_t IPUV_reserved18[3];
  IPUV_S_CH2_CFG_IN_tag S_CH2_CFG_IN;  /* IN Stream Line2 Configuration Register */
  uint32_t IPUV_reserved19[3];
  IPUV_S_LINE2_ADDR_IN_tag S_LINE2_ADDR_IN; /* IN Stream Line2 Address Register */
  uint32_t IPUV_reserved20[31];
  IPUV_S_LINE3_LEN_IN_tag S_LINE3_LEN_IN; /* IN Stream Line3 Length Register */
  uint32_t IPUV_reserved21[3];
  IPUV_S_CH3_CFG_IN_tag S_CH3_CFG_IN;  /* IN Stream Line3 Configuration Register */
  uint32_t IPUV_reserved22[3];
  IPUV_S_LINE3_ADDR_IN_tag S_LINE3_ADDR_IN; /* IN Stream Line3 Address Register */
  uint32_t IPUV_reserved23[3];
  IPUV_S_LINE4_LEN_IN_tag S_LINE4_LEN_IN; /* IN Stream Line4 Length Register */
  uint32_t IPUV_reserved24[3];
  IPUV_S_CH4_CFG_IN_tag S_CH4_CFG_IN;  /* IN Stream Line4 Configuration Register */
  uint32_t IPUV_reserved25[3];
  IPUV_S_LINE4_ADDR_IN_tag S_LINE4_ADDR_IN; /* IN Stream Line4 Address Register */
  uint32_t IPUV_reserved26[107];
  IPUV_S_LINE0_LEN_OUT_tag S_LINE0_LEN_OUT; /* Stream Out0 Length Register */
  uint32_t IPUV_reserved27[3];
  IPUV_S_CH0_CFG_OUT_tag S_CH0_CFG_OUT; /* Stream Out0 Configuration Register */
  uint32_t IPUV_reserved28[3];
  IPUV_S_LINE0_ADDR_OUT_tag S_LINE0_ADDR_OUT; /* Stream Out0 Address Register */
  uint32_t IPUV_reserved29[3];
  IPUV_S_LINE1_LEN_OUT_tag S_LINE1_LEN_OUT; /* Stream Out1 Length Register */
  uint32_t IPUV_reserved30[3];
  IPUV_S_CH1_CFG_OUT_tag S_CH1_CFG_OUT; /* Stream Out1 Configuration Register */
  uint32_t IPUV_reserved31[3];
  IPUV_S_LINE1_ADDR_OUT_tag S_LINE1_ADDR_OUT; /* Stream Out1 Address Register */
  uint32_t IPUV_reserved32[3];
  IPUV_S_LINE2_LEN_OUT_tag S_LINE2_LEN_OUT; /* Stream Out2 Length Register */
  uint32_t IPUV_reserved33[3];
  IPUV_S_CH2_CFG_OUT_tag S_CH2_CFG_OUT; /* Stream Out2 Configuration Register */
  uint32_t IPUV_reserved34[3];
  IPUV_S_LINE2_ADDR_OUT_tag S_LINE2_ADDR_OUT; /* Stream Out2 Address Register */
  uint32_t IPUV_reserved35[31];
  IPUV_S_CURR_LINE0_LEN_IN_tag S_CURR_LINE0_LEN_IN; /* IN Stream Line0 Current Length Register */
  uint32_t IPUV_reserved36[3];
  IPUV_S_CURR_CH0_CFG_IN_tag S_CURR_CH0_CFG_IN; /* IN Stream Line0 Current Configuration Register */
  uint32_t IPUV_reserved37[3];
  IPUV_S_CURR_LINE0_ADDR_IN_tag S_CURR_LINE0_ADDR_IN; /* IN Stream Line0 Current Address Register */
  uint32_t IPUV_reserved38[3];
  IPUV_S_CURR_LINE1_LEN_IN_tag S_CURR_LINE1_LEN_IN; /* IN Stream Line1 Current Length Register */
  uint32_t IPUV_reserved39[3];
  IPUV_S_CURR_CH1_CFG_IN_tag S_CURR_CH1_CFG_IN; /* IN Stream Line1 Current Configuration Register */
  uint32_t IPUV_reserved40[3];
  IPUV_S_CURR_LINE1_ADDR_IN_tag S_CURR_LINE1_ADDR_IN; /* IN Stream Line1 Current Address Register */
  uint32_t IPUV_reserved41[3];
  IPUV_S_CURR_LINE2_LEN_IN_tag S_CURR_LINE2_LEN_IN; /* IN Stream Line2 Current Length Register */
  uint32_t IPUV_reserved42[3];
  IPUV_S_CURR_CH2_CFG_IN_tag S_CURR_CH2_CFG_IN; /* IN Stream Line2 Current Configuration Register */
  uint32_t IPUV_reserved43[3];
  IPUV_S_CURR_LINE2_ADDR_IN_tag S_CURR_LINE2_ADDR_IN; /* IN Stream Line2 Current Address Register */
  uint32_t IPUV_reserved44[31];
  IPUV_S_CURR_LINE3_LEN_IN_tag S_CURR_LINE3_LEN_IN; /* IN Stream Line3 Current Length Register */
  uint32_t IPUV_reserved45[3];
  IPUV_S_CURR_CH3_CFG_IN_tag S_CURR_CH3_CFG_IN; /* IN Stream Line3 Current Configuration Register */
  uint32_t IPUV_reserved46[3];
  IPUV_S_CURR_LINE3_ADDR_IN_tag S_CURR_LINE3_ADDR_IN; /* IN Stream Line3 Current Address Register */
  uint32_t IPUV_reserved47[3];
  IPUV_S_CURR_LINE4_LEN_IN_tag S_CURR_LINE4_LEN_IN; /* IN Stream Line4 Current Length Register */
  uint32_t IPUV_reserved48[3];
  IPUV_S_CURR_CH4_CFG_IN_tag S_CURR_CH4_CFG_IN; /* IN Stream Line4 Current Configuration Register */
  uint32_t IPUV_reserved49[3];
  IPUV_S_CURR_LINE4_ADDR_IN_tag S_CURR_LINE4_ADDR_IN; /* IN Stream Line4 Current Address Register */
  uint32_t IPUV_reserved50[107];
  IPUV_S_CURR_LINE0_LEN_OUT_tag S_CURR_LINE0_LEN_OUT; /* Stream Out0 Current Length Register */
  uint32_t IPUV_reserved51[3];
  IPUV_S_CURR_CH0_CFG_OUT_tag S_CURR_CH0_CFG_OUT; /* Stream Out0 Current Configuration Register */
  uint32_t IPUV_reserved52[3];
  IPUV_S_CURR_LINE0_ADDR_OUT_tag S_CURR_LINE0_ADDR_OUT; /* Stream Out0 Current Address Register */
  uint32_t IPUV_reserved53[3];
  IPUV_S_CURR_LINE1_LEN_OUT_tag S_CURR_LINE1_LEN_OUT; /* Stream Out1 Current Length Register */
  uint32_t IPUV_reserved54[3];
  IPUV_S_CURR_CH1_CFG_OUT_tag S_CURR_CH1_CFG_OUT; /* Stream Out1 Current Configuration Register */
  uint32_t IPUV_reserved55[3];
  IPUV_S_CURR_LINE1_ADDR_OUT_tag S_CURR_LINE1_ADDR_OUT; /* Stream Out1 Current Address Register */
  uint32_t IPUV_reserved56[3];
  IPUV_S_CURR_LINE2_LEN_OUT_tag S_CURR_LINE2_LEN_OUT; /* Stream Out2 Current Length Register */
  uint32_t IPUV_reserved57[3];
  IPUV_S_CURR_CH2_CFG_OUT_tag S_CURR_CH2_CFG_OUT; /* Stream Out2 Current Configuration Register */
  uint32_t IPUV_reserved58[3];
  IPUV_S_CURR_LINE2_ADDR_OUT_tag S_CURR_LINE2_ADDR_OUT; /* Stream Out2 Current Address Register */
  uint32_t IPUV_reserved59[283];
  IPUV_DEBUG_MS_tag DEBUG_MS;          /* Debug Mode and Step Register */
  uint32_t IPUV_reserved60[3];
  IPUV_DEBUG_BKPT_STAT_tag DEBUG_BKPT_STAT; /* Debug Breakpoint Status Register */
  uint32_t IPUV_reserved61[3];
  IPUV_DEBUG_BKPT_POS_tag DEBUG_BKPT_POS; /* Debug Breakpoint Position Register */
  uint32_t IPUV_reserved62[3];
  IPUV_DEBUG_BKPT_ADDR_tag DEBUG_BKPT_ADDR; /* Debug Breakpoint Address Register */
  uint32_t IPUV_reserved63[7];
  IPUV_DEBUG_CORE_STAT_tag DEBUG_CORE_STAT; /* Debug Core Status Register */
  uint32_t IPUV_reserved64[235];
  IPUV_PMONITOR_CTRL_tag PMONITOR_CTRL; /* Performance Monitor Control Register */
  uint32_t IPUV_reserved65[3];
  IPUV_PMONITOR_SAMPLE_tag PMONITOR_SAMPLE; /* Performance Monitor Sample Register */
  uint32_t IPUV_reserved66[3];
  IPUV_STALL_STREAMIN_tag STALL_STREAMIN; /* Stream-in Stall Counter */
  uint32_t IPUV_reserved67[3];
  IPUV_STALL_STREAMOUT_tag STALL_STREAMOUT; /* Stream-out Stall Counter */
  uint32_t IPUV_reserved68[3];
  IPUV_STALL_STREAMINOUT_tag STALL_STREAMINOUT; /* Stream-in and Stream-out Stall Counter */
  uint32_t IPUV_reserved69[3];
  IPUV_STALL_DATAHAZARD_tag STALL_DATAHAZARD; /* Data Hazard Stall Counter */
  uint32_t IPUV_reserved70[3];
  IPUV_EXEC_COUNTER_tag EXEC_COUNTER;  /* Execution Cycle Counter */
  uint32_t IPUV_reserved71[103];
  IPUV_IMEM_ERROR_INJECT_ADDR_tag IMEM_ERROR_INJECT_ADDR; /* IMEM Error Inject Address Register */
  uint32_t IPUV_reserved72[3];
  IPUV_IMEM_ERROR_VECTOR0_tag IMEM_ERROR_VECTOR0; /* IMEM Error Inject Vector0 */
  uint32_t IPUV_reserved73[3];
  IPUV_IMEM_ERROR_VECTOR1_tag IMEM_ERROR_VECTOR1; /* IMEM Error Inject Vector1 */
  uint32_t IPUV_reserved74[3];
  IPUV_IMEM_ERROR_INJECT_STAT_tag IMEM_ERROR_INJECT_STAT; /* IMEM Error Injection Status register */
  uint32_t IPUV_reserved75[115];
  IPUV_RESET_REG_tag RESET_REG;        /* Reset Register */
};


/* ============================================================================
   =============================== Module: JPEG ===============================
   ============================================================================ */

typedef union JPEG_ST1_SRAM_PTR_union_tag { /* Stream 1 SRAM Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST1_SRAM_PTR_tag;

typedef union JPEG_ST1_SRAM_LEN_VAL_union_tag { /* Stream 1 SRAM Length Value Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length. */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST1_SRAM_LEN_VAL_tag;

typedef union JPEG_ST1_PTR_FIFO_ST1_PTR_FIFO_union_tag { /* Stream 1 Pointer FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST1_PTR_FIFO_ST1_PTR_FIFO_tag;

typedef struct JPEG_ST1_PTR_FIFO_struct_tag {
  JPEG_ST1_PTR_FIFO_ST1_PTR_FIFO_tag ST1_PTR_FIFO; /* Stream 1 Pointer FIFO Register */
} JPEG_ST1_PTR_FIFO_tag;

typedef union JPEG_ST1_LEN_VAL_FIFO_ST1_LEN_VAL_FIFO_union_tag { /* Stream 1 Length Value FIFO register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST1_LEN_VAL_FIFO_ST1_LEN_VAL_FIFO_tag;

typedef struct JPEG_ST1_LEN_VAL_FIFO_struct_tag {
  JPEG_ST1_LEN_VAL_FIFO_ST1_LEN_VAL_FIFO_tag ST1_LEN_VAL_FIFO; /* Stream 1 Length Value FIFO register */
} JPEG_ST1_LEN_VAL_FIFO_tag;

typedef union JPEG_ST2_SRAM_PTR_union_tag { /* Stream 2 SRAM Pointer register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST2_SRAM_PTR_tag;

typedef union JPEG_ST2_SRAM_LEN_VAL_union_tag { /* Stream 2 SRAM Length Value Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST2_SRAM_LEN_VAL_tag;

typedef union JPEG_ST2_PTR_FIFO_ST2_PTR_FIFO_union_tag { /* Stream 2 Pointer FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST2_PTR_FIFO_ST2_PTR_FIFO_tag;

typedef struct JPEG_ST2_PTR_FIFO_struct_tag {
  JPEG_ST2_PTR_FIFO_ST2_PTR_FIFO_tag ST2_PTR_FIFO; /* Stream 2 Pointer FIFO Register */
} JPEG_ST2_PTR_FIFO_tag;

typedef union JPEG_ST2_LEN_VAL_FIFO_ST2_LEN_VAL_FIFO_union_tag { /* Stream 2 Length Value FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST2_LEN_VAL_FIFO_ST2_LEN_VAL_FIFO_tag;

typedef struct JPEG_ST2_LEN_VAL_FIFO_struct_tag {
  JPEG_ST2_LEN_VAL_FIFO_ST2_LEN_VAL_FIFO_tag ST2_LEN_VAL_FIFO; /* Stream 2 Length Value FIFO Register */
} JPEG_ST2_LEN_VAL_FIFO_tag;

typedef union JPEG_ST3_SRAM_PTR_union_tag { /* Stream 3 SRAM Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST3_SRAM_PTR_tag;

typedef union JPEG_ST3_SRAM_LEN_VAL_union_tag { /* Stream 3 SRAM Length Value Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST3_SRAM_LEN_VAL_tag;

typedef union JPEG_ST3_PTR_FIFO_ST3_PTR_FIFO_union_tag { /* Stream 3 Pointer FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST3_PTR_FIFO_ST3_PTR_FIFO_tag;

typedef struct JPEG_ST3_PTR_FIFO_struct_tag {
  JPEG_ST3_PTR_FIFO_ST3_PTR_FIFO_tag ST3_PTR_FIFO; /* Stream 3 Pointer FIFO Register */
} JPEG_ST3_PTR_FIFO_tag;

typedef union JPEG_ST3_LEN_VAL_FIFO_ST3_LEN_VAL_FIFO_union_tag { /* Stream 3 Length Value FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST3_LEN_VAL_FIFO_ST3_LEN_VAL_FIFO_tag;

typedef struct JPEG_ST3_LEN_VAL_FIFO_struct_tag {
  JPEG_ST3_LEN_VAL_FIFO_ST3_LEN_VAL_FIFO_tag ST3_LEN_VAL_FIFO; /* Stream 3 Length Value FIFO Register */
} JPEG_ST3_LEN_VAL_FIFO_tag;

typedef union JPEG_ST4_SRAM_PTR_union_tag { /* Stream 4 SRAM Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST4_SRAM_PTR_tag;

typedef union JPEG_ST4_SRAM_LEN_VAL_union_tag { /* Stream 4 SRAM Length Value Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST4_SRAM_LEN_VAL_tag;

typedef union JPEG_ST4_PTR_FIFO_ST4_PTR_FIFO_union_tag { /* Stream 4 Pointer FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t POINTER:32;              /* Pointer */
  } B;
} JPEG_ST4_PTR_FIFO_ST4_PTR_FIFO_tag;

typedef struct JPEG_ST4_PTR_FIFO_struct_tag {
  JPEG_ST4_PTR_FIFO_ST4_PTR_FIFO_tag ST4_PTR_FIFO; /* Stream 4 Pointer FIFO Register */
} JPEG_ST4_PTR_FIFO_tag;

typedef union JPEG_ST4_LEN_VAL_FIFO_ST4_LEN_VAL_FIFO_union_tag { /* Stream 4 Length Value FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t PKT_LENGTH:16;           /* Packet Length */
    vuint32_t _unused_16:16;
  } B;
} JPEG_ST4_LEN_VAL_FIFO_ST4_LEN_VAL_FIFO_tag;

typedef struct JPEG_ST4_LEN_VAL_FIFO_struct_tag {
  JPEG_ST4_LEN_VAL_FIFO_ST4_LEN_VAL_FIFO_tag ST4_LEN_VAL_FIFO; /* Stream 4 Length Value FIFO Register */
} JPEG_ST4_LEN_VAL_FIFO_tag;

typedef union JPEG_BUF_C1_ADDR_union_tag { /* Buffer Component 1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t C1_ADDR:32;              /* Component 1 Address */
  } B;
} JPEG_BUF_C1_ADDR_tag;

typedef union JPEG_BUF_C2_ADDR_union_tag { /* Buffer Component 2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t C2_ADDR:32;              /* Component 2 Address */
  } B;
} JPEG_BUF_C2_ADDR_tag;

typedef union JPEG_BUF_C3_ADDR_union_tag { /* Buffer Component 3 Address Register */
  vuint32_t R;
  struct {
    vuint32_t C3_ADDR:32;              /* Component 3 Address */
  } B;
} JPEG_BUF_C3_ADDR_tag;

typedef union JPEG_BUF_C4_ADDR_union_tag { /* Buffer Component 4 Address Register */
  vuint32_t R;
  struct {
    vuint32_t C4_ADDR:32;              /* Component 4 Address */
  } B;
} JPEG_BUF_C4_ADDR_tag;

typedef union JPEG_NRLINES_B2L_union_tag { /* Block to Lines Number of Lines Register */
  vuint32_t R;
  struct {
    vuint32_t NRLINES_B2L_C1:16;       /* Component 1 */
    vuint32_t NRLINES_B2L_C23:16;      /* Component 2 and 3 */
  } B;
} JPEG_NRLINES_B2L_tag;

typedef union JPEG_NRLINES_B2L_C4_union_tag { /* Block to Lines Number of Lines for Component 4 Register */
  vuint32_t R;
  struct {
    vuint32_t NRLINES_B2L_C4:16;       /* Component 4 */
    vuint32_t _unused_16:16;
  } B;
} JPEG_NRLINES_B2L_C4_tag;

typedef union JPEG_TIMEOUT_union_tag { /* Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t TIMEOUT_VAL:32;          /* Timeout Value */
  } B;
} JPEG_TIMEOUT_tag;

typedef union JPEG_W_CTRL1_union_tag { /* Wrapper Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t BNK_STRD:3;              /* Bank stride value */
    vuint32_t _unused_4:4;
    vuint32_t N_STREAM:3;              /* Number of streams */
    vuint32_t _unused_11:21;
  } B;
} JPEG_W_CTRL1_tag;

typedef union JPEG_W_CTRL2_union_tag { /* Wrapper Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t WRAPPER_CONF_ST1:1;
    vuint32_t NF_JPEG_ST1:3;
    vuint32_t P_JPEG_ST1:1;
    vuint32_t WRAPPER_CONF_ST2:1;
    vuint32_t NF_JPEG_ST2:3;
    vuint32_t P_JPEG_ST2:1;
    vuint32_t WRAPPER_CONF_ST3:1;
    vuint32_t NF_JPEG_ST3:3;
    vuint32_t P_JPEG_ST3:1;
    vuint32_t WRAPPER_CONF_ST4:1;
    vuint32_t NF_JPEG_ST4:3;
    vuint32_t P_JPEG_ST4:1;
    vuint32_t _unused_20:9;
    vuint32_t SMPL_O_BF:1;             /* Sample Output Buffers */
    vuint32_t COM_MODE:1;              /* Compatibility mode */
    vuint32_t _unused_31:1;
  } B;
} JPEG_W_CTRL2_tag;

typedef union JPEG_INTR_EN_union_tag { /* Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t PKT1_FIFO_WATERMARK:1;   /* Stream 1 Packet FIFO Watermark */
    vuint32_t _unused_1:5;
    vuint32_t PKT2_FIFO_WATERMARK:1;   /* Stream 2 Packet FIFO Watermark */
    vuint32_t _unused_7:5;
    vuint32_t PKT3_FIFO_WATERMARK:1;   /* Stream 3 Packet FIFO Watermark */
    vuint32_t _unused_13:5;
    vuint32_t PKT4_FIFO_WATERMARK:1;   /* Stream 4 Packet FIFO Watermark */
    vuint32_t _unused_19:5;
    vuint32_t MCU_ROW_DN_EN:1;         /* One MCU Row Done Enable */
    vuint32_t END_OF_FRME_DN_EN:1;     /* End of Frame Done Enable */
    vuint32_t STRT_OF_FRME_DN_EN:1;    /* Start of Frame Done Enable */
    vuint32_t WTR_MRK_LVL:4;           /* Water Mark Level */
    vuint32_t CONFIG_ERR_EN:1;         /* Config Error Enable */
  } B;
} JPEG_INTR_EN_tag;

typedef union JPEG_W_STATUS_union_tag { /* Wrapper Status Register */
  vuint32_t R;
  struct {
    vuint32_t PKT1_FIFO_WATERMARK:1;   /* Watermark for FIFO of ethernet packets information of stream 1 */
    vuint32_t PKT1_FIFO_SPACE:5;       /* Space in FIFO of Stream 1 */
    vuint32_t PKT2_FIFO_WATERMARK:1;   /* Watermark for FIFO of ethernet packets information of stream 2 */
    vuint32_t PKT2_FIFO_SPACE:5;       /* Space in FIFO of Stream 2 */
    vuint32_t PKT3_FIFO_WATERMARK:1;   /* Watermark for FIFO of ethernet packets information of stream 3 */
    vuint32_t PKT3_FIFO_SPACE:5;       /* Space in FIFO of Stream 3 */
    vuint32_t PKT4_FIFO_WATERMARK:1;   /* Watermark for FIFO of ethernet packets information of stream 4 */
    vuint32_t PKT4_FIFO_SPACE:5;       /* Space in FIFO of Stream 4 */
    vuint32_t MCU_ROW_DN:1;            /* One MCU Row Done */
    vuint32_t End_of_Frame:1;          /* End of Frame */
    vuint32_t STRT_OF_FRME:1;          /* Start of Frame */
    vuint32_t _unused_27:2;
    vuint32_t ST_WR:3;                 /* Stream Write */
  } B;
} JPEG_W_STATUS_tag;

typedef union JPEG_E_STATUS_union_tag { /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t CR_ERR:1;                /* Core Error */
    vuint32_t ST1_P_ERR:1;             /* Stream 1 Parameters Error */
    vuint32_t ST2_P_ERR:1;             /* Stream 2 Parameters Error */
    vuint32_t ST3_P_ERR:1;             /* Stream 3 Parameters Error */
    vuint32_t ST4_P_ERR:1;             /* Stream 4 Parameters Error */
    vuint32_t DRI_ERR:1;               /* DRI Error */
    vuint32_t TIMEOUT_ERR:1;           /* Timeout Error */
    vuint32_t _unused_7:24;
    vuint32_t CONFIG_ERR:1;            /* Config Error */
  } B;
} JPEG_E_STATUS_tag;

typedef union JPEG_RST_INTVL_union_tag { /* Restart Interval */
  vuint32_t R;
  struct {
    vuint32_t INTVAL:16;               /* Interval Val */
    vuint32_t _unused_16:16;
  } B;
} JPEG_RST_INTVL_tag;

typedef union JPEG_IMG_SZ_ST1_union_tag { /* Image Size of Stream 1 */
  vuint32_t R;
  struct {
    vuint32_t X_JPEG_ST1:16;           /* Number of pixels per line for stream 1 */
    vuint32_t Y_JPEG_ST1:16;           /* Number of lines per frame for stream 1 */
  } B;
} JPEG_IMG_SZ_ST1_tag;

typedef union JPEG_IMG_SZ_ST2_union_tag { /* Image Size of Stream 2 */
  vuint32_t R;
  struct {
    vuint32_t X_JPEG_ST2:16;           /* Number of Pixels per frame for stream 2 */
    vuint32_t Y_JPEG_ST2:16;           /* Number of lines per frame for stream 2 */
  } B;
} JPEG_IMG_SZ_ST2_tag;

typedef union JPEG_IMG_SZ_ST3_union_tag { /* Image Size of Stream 3 */
  vuint32_t R;
  struct {
    vuint32_t X_JPEG_ST3:16;           /* Number of Pixels per frame for stream 3 */
    vuint32_t Y_JPEG_ST3:16;           /* Number of lines per frame for stream 3 */
  } B;
} JPEG_IMG_SZ_ST3_tag;

typedef union JPEG_IMG_SZ_ST4_union_tag { /* Image Size of Stream 4 */
  vuint32_t R;
  struct {
    vuint32_t X_JPEG_ST4:16;           /* Number of Pixels per frame for stream 4 */
    vuint32_t Y_JPEG_ST4:16;           /* Number of lines per frame for stream 4 */
  } B;
} JPEG_IMG_SZ_ST4_tag;

typedef union JPEG_SMPL_FCTR_ST1_union_tag { /* Sampling Factor Stream 1 */
  vuint32_t R;
  struct {
    vuint32_t H1_JPEG_ST1:4;
    vuint32_t H2_JPEG_ST1:4;
    vuint32_t H3_JPEG_ST1:4;
    vuint32_t H4_JPEG_ST1:4;
    vuint32_t V1_JPEG_ST1:4;
    vuint32_t V2_JPEG_ST1:4;
    vuint32_t V3_JPEG_ST1:4;
    vuint32_t V4_JPEG_ST1:4;
  } B;
} JPEG_SMPL_FCTR_ST1_tag;

typedef union JPEG_SMPL_FCTR_ST2_union_tag { /* Sampling Factor Stream 2 */
  vuint32_t R;
  struct {
    vuint32_t H1_JPEG_ST2:4;
    vuint32_t H2_JPEG_ST2:4;
    vuint32_t H3_JPEG_ST2:4;
    vuint32_t H4_JPEG_ST2:4;
    vuint32_t V1_JPEG_ST2:4;
    vuint32_t V2_JPEG_ST2:4;
    vuint32_t V3_JPEG_ST2:4;
    vuint32_t V4_JPEG_ST2:4;
  } B;
} JPEG_SMPL_FCTR_ST2_tag;

typedef union JPEG_SMPL_FCTR_ST3_union_tag { /* Sampling Factor Stream 3 */
  vuint32_t R;
  struct {
    vuint32_t H1_JPEG_ST3:4;
    vuint32_t H2_JPEG_ST3:4;
    vuint32_t H3_JPEG_ST3:4;
    vuint32_t H4_JPEG_ST3:4;
    vuint32_t V1_JPEG_ST3:4;
    vuint32_t V2_JPEG_ST3:4;
    vuint32_t V3_JPEG_ST3:4;
    vuint32_t V4_JPEG_ST3:4;
  } B;
} JPEG_SMPL_FCTR_ST3_tag;

typedef union JPEG_SMPL_FCTR_ST4_union_tag { /* Sampling Factor Stream 4 */
  vuint32_t R;
  struct {
    vuint32_t H1_JPEG_ST4:4;
    vuint32_t H2_JPEG_ST4:4;
    vuint32_t H3_JPEG_ST4:4;
    vuint32_t H4_JPEG_ST4:4;
    vuint32_t V1_JPEG_ST4:4;
    vuint32_t V2_JPEG_ST4:4;
    vuint32_t V3_JPEG_ST4:4;
    vuint32_t V4_JPEG_ST4:4;
  } B;
} JPEG_SMPL_FCTR_ST4_tag;

typedef union JPEG_TST_PXL_LOC_union_tag { /* Test Pixel Location */
  vuint32_t R;
  struct {
    vuint32_t TST_BLK_PXL1:18;         /* MCU block location for test pixel 1 */
    vuint32_t _unused_18:8;
    vuint32_t TST_LINE:3;              /* Test line for pixel 1 and 2 */
    vuint32_t _unused_29:2;
    vuint32_t TST_LINE_EN:1;           /* Test line enable */
  } B;
} JPEG_TST_PXL_LOC_tag;

typedef union JPEG_TST_PXL_LOC1_union_tag { /* Test Pixel Location 1 */
  vuint32_t R;
  struct {
    vuint32_t TST_BLK_PXL2:18;         /* MCU block location for test pixel 2 */
    vuint32_t _unused_18:14;
  } B;
} JPEG_TST_PXL_LOC1_tag;

typedef union JPEG_TST_LINE_LUMA_ST1_union_tag { /* Test Line Luma Pixel Value for Stream 1 */
  vuint32_t R;
  struct {
    vuint32_t LUMA1_VAL:12;            /* Luma Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t LUMA2_VAL:12;            /* Luma Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_LUMA_ST1_tag;

typedef union JPEG_TST_LINE_Cb_ST1_union_tag { /* Test Line Cb Pixel Value for Stream 1 */
  vuint32_t R;
  struct {
    vuint32_t Cb1_VAL:12;              /* Cb Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cb2_VAL:12;              /* Cb Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cb_ST1_tag;

typedef union JPEG_TST_LINE_Cr_ST1_union_tag { /* Test Line Cr Pixel Value for Stream 1 */
  vuint32_t R;
  struct {
    vuint32_t Cr1_VAL:12;              /* Cr Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cr2_VAL:12;              /* Cr Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cr_ST1_tag;

typedef union JPEG_TST_LINE_LUMA_ST2_union_tag { /* Test Line Luma Pixel Value for Stream 2 */
  vuint32_t R;
  struct {
    vuint32_t LUMA1_VAL:12;            /* Luma Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t LUMA2_VAL:12;            /* Luma Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_LUMA_ST2_tag;

typedef union JPEG_TST_LINE_Cb_ST2_union_tag { /* Test Line Cb Pixel Value for Stream 2 */
  vuint32_t R;
  struct {
    vuint32_t Cb1_VAL:12;              /* Cb Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cb2_VAL:12;              /* Cb Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cb_ST2_tag;

typedef union JPEG_TST_LINE_Cr_ST2_union_tag { /* Test Line Cr Pixel Value for Stream 2 */
  vuint32_t R;
  struct {
    vuint32_t Cr1_VAL:12;              /* Cr Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cr2_VAL:12;              /* Cr Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cr_ST2_tag;

typedef union JPEG_TST_LINE_LUMA_ST3_union_tag { /* Test Line Luma Pixel Value for Stream 3 */
  vuint32_t R;
  struct {
    vuint32_t LUMA1_VAL:12;            /* Luma Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t LUMA2_VAL:12;            /* Luma Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_LUMA_ST3_tag;

typedef union JPEG_TST_LINE_Cb_ST3_union_tag { /* Test Line Cb Pixel Value for Stream 3 */
  vuint32_t R;
  struct {
    vuint32_t Cb1_VAL:12;              /* Cb Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cb2_VAL:12;              /* Cb Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cb_ST3_tag;

typedef union JPEG_TST_LINE_Cr_ST3_union_tag { /* Test Line Cr Pixel Value for Stream 3 */
  vuint32_t R;
  struct {
    vuint32_t Cr1_VAL:12;              /* Cr Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cr2_VAL:12;              /* Cr Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cr_ST3_tag;

typedef union JPEG_TST_LINE_LUMA_ST4_union_tag { /* Test Line Luma Pixel Value for Stream 4 */
  vuint32_t R;
  struct {
    vuint32_t LUMA1_VAL:12;            /* Luma Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t LUMA2_VAL:12;            /* Luma Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_LUMA_ST4_tag;

typedef union JPEG_TST_LINE_Cb_ST4_union_tag { /* Test Line Luma Cb Pixel Value for Stream 4 */
  vuint32_t R;
  struct {
    vuint32_t Cb1_VAL:12;              /* Cb Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cb2_VAL:12;              /* Cb Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cb_ST4_tag;

typedef union JPEG_TST_LINE_Cr_ST4_union_tag { /* Test Line Cr Pixel Value for Stream 4 */
  vuint32_t R;
  struct {
    vuint32_t Cr1_VAL:12;              /* Cr Value of Pixel 1 */
    vuint32_t _unused_12:4;
    vuint32_t Cr2_VAL:12;              /* Cr Value of Pixel 2 */
    vuint32_t _unused_28:4;
  } B;
} JPEG_TST_LINE_Cr_ST4_tag;

typedef union JPEG_CTRL_union_tag {    /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LP:1;                    /* Low Power */
    vuint32_t SWR:1;                   /* Soft reset */
    vuint32_t GO:1;                    /* Go */
    vuint32_t _unused_3:29;
  } B;
} JPEG_CTRL_tag;

typedef union JPEG_STATUS1_union_tag { /* Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t IMAGE_WIDTH:16;          /* Image width */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS1_tag;

typedef union JPEG_STATUS2_union_tag { /* Status 2 Register */
  vuint32_t R;
  struct {
    vuint32_t IMAGE_HEIGHT:16;         /* Image height */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS2_tag;

typedef union JPEG_STATUS3_union_tag { /* Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t HMCU:16;                 /* Horizontal MCUs */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS3_tag;

typedef union JPEG_STATUS4_union_tag { /* Status 4 Register */
  vuint32_t R;
  struct {
    vuint32_t VMCU:16;                 /* Vertical MCUs */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS4_tag;

typedef union JPEG_STATUS5_union_tag { /* Status 5 Register */
  vuint32_t R;
  struct {
    vuint32_t Tq0:2;                   /* Quantization table identifier for scan component 0 */
    vuint32_t V0:3;                    /* Vertical sampling for scan component 0 */
    vuint32_t H0:3;                    /* Horizontal sampling for scan component 0 */
    vuint32_t C0:8;                    /* Component identifier for scan component 0 */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS5_tag;

typedef union JPEG_STATUS6_union_tag { /* Status 6 Register */
  vuint32_t R;
  struct {
    vuint32_t TQ1:2;                   /* Quantization table identifier for scan component 1 */
    vuint32_t V1:3;                    /* Vertical sampling for scan component 1 */
    vuint32_t H1:3;                    /* Horizontal sampling for scan component 1 */
    vuint32_t C1:8;                    /* Component identifier for scan component 1 */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS6_tag;

typedef union JPEG_STATUS7_union_tag { /* Status 7 Register */
  vuint32_t R;
  struct {
    vuint32_t Tq2:2;                   /* Quantization table identifier for scan component 2 */
    vuint32_t V2:3;                    /* Vertical sampling for scan component 2 */
    vuint32_t H2:3;                    /* Horizontal sampling for scan component 2 */
    vuint32_t C2:8;                    /* Component identifier for scan component 2 */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS7_tag;

typedef union JPEG_STATUS8_union_tag { /* Status 8 Register */
  vuint32_t R;
  struct {
    vuint32_t TQ3:2;                   /* Quantization table identifier for scan component 3 */
    vuint32_t V3:3;                    /* Vertical sampling for scan component 3 */
    vuint32_t H3:3;                    /* Horizontal sampling for scan component 3 */
    vuint32_t C3:8;                    /* Component identifier for scan component 3 */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS8_tag;

typedef union JPEG_STATUS9_union_tag { /* Status 9 Register */
  vuint32_t R;
  struct {
    vuint32_t NF:8;                    /* Number of components in frame */
    vuint32_t SMPL_PRESN:8;            /* Sample Precision */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS9_tag;

typedef union JPEG_STATUS10_union_tag { /* Status 10 Register */
  vuint32_t R;
  struct {
    vuint32_t DRI:16;                  /* Restart interval */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS10_tag;

typedef union JPEG_STATUS11_union_tag { /* Status 11 Register */
  vuint32_t R;
  struct {
    vuint32_t Ns:4;                    /* Number of components in current scan */
    vuint32_t NBMCU:4;                 /* Number of blocks per MCU. */
    vuint32_t Vmax:4;                  /* Vertical Maximum */
    vuint32_t Hmax:4;                  /* Horizontal Maximum */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS11_tag;

typedef union JPEG_STATUS12_union_tag { /* Status 12 Register */
  vuint32_t R;
  struct {
    vuint32_t VHS0:4;                  /* This bitfield defines the number of blocks of second component in MCU. */
    vuint32_t VHS1:4;                  /* This bitfield defines the number of blocks of second component in MCU. */
    vuint32_t VHS2:4;                  /* This bitfield defines the number of blocks of third component in MCU. */
    vuint32_t VHS3:4;                  /* This bitfield defines the number of blocks of fourth component in MCU. */
    vuint32_t _unused_16:16;
  } B;
} JPEG_STATUS12_tag;

typedef union JPEG_STATUS13_union_tag { /* Status 13 Register */
  vuint32_t R;
  struct {
    vuint32_t COM_E:1;                 /* Comment Marker Error */
    vuint32_t APPn_E:1;                /* Application Data Marker Error */
    vuint32_t DRI_E:1;                 /* Define Restart Interval Marker Error */
    vuint32_t DNL_E:1;                 /* Define Number of Lines Marker Error */
    vuint32_t DHT_E:1;                 /* Define Huffman Table Marker Error */
    vuint32_t DQT_E:1;                 /* Define Quantization Table Marker Error */
    vuint32_t SOS_E:1;                 /* Start of Scan Marker Error */
    vuint32_t SOF_E:1;                 /* Start of Frame Marker Error */
    vuint32_t _unused_8:24;
  } B;
} JPEG_STATUS13_tag;

struct JPEG_tag {
  JPEG_ST1_SRAM_PTR_tag ST1_SRAM_PTR;  /* Stream 1 SRAM Pointer Register */
  uint32_t JPEG_reserved0[3];
  JPEG_ST1_SRAM_LEN_VAL_tag ST1_SRAM_LEN_VAL; /* Stream 1 SRAM Length Value Register */
  uint32_t JPEG_reserved1[3];
  JPEG_ST1_PTR_FIFO_tag ST1_PTR_FIFO[16];
  JPEG_ST1_LEN_VAL_FIFO_tag ST1_LEN_VAL_FIFO[16];
  JPEG_ST2_SRAM_PTR_tag ST2_SRAM_PTR;  /* Stream 2 SRAM Pointer register */
  uint32_t JPEG_reserved2[3];
  JPEG_ST2_SRAM_LEN_VAL_tag ST2_SRAM_LEN_VAL; /* Stream 2 SRAM Length Value Register */
  uint32_t JPEG_reserved3[3];
  JPEG_ST2_PTR_FIFO_tag ST2_PTR_FIFO[16];
  JPEG_ST2_LEN_VAL_FIFO_tag ST2_LEN_VAL_FIFO[16];
  JPEG_ST3_SRAM_PTR_tag ST3_SRAM_PTR;  /* Stream 3 SRAM Pointer Register */
  uint32_t JPEG_reserved4[3];
  JPEG_ST3_SRAM_LEN_VAL_tag ST3_SRAM_LEN_VAL; /* Stream 3 SRAM Length Value Register */
  uint32_t JPEG_reserved5[3];
  JPEG_ST3_PTR_FIFO_tag ST3_PTR_FIFO[16];
  JPEG_ST3_LEN_VAL_FIFO_tag ST3_LEN_VAL_FIFO[16];
  JPEG_ST4_SRAM_PTR_tag ST4_SRAM_PTR;  /* Stream 4 SRAM Pointer Register */
  uint32_t JPEG_reserved6[3];
  JPEG_ST4_SRAM_LEN_VAL_tag ST4_SRAM_LEN_VAL; /* Stream 4 SRAM Length Value Register */
  uint32_t JPEG_reserved7[3];
  JPEG_ST4_PTR_FIFO_tag ST4_PTR_FIFO[16];
  JPEG_ST4_LEN_VAL_FIFO_tag ST4_LEN_VAL_FIFO[16];
  uint32_t JPEG_reserved8[16];
  JPEG_BUF_C1_ADDR_tag BUF_C1_ADDR;    /* Buffer Component 1 Address Register */
  uint32_t JPEG_reserved9[3];
  JPEG_BUF_C2_ADDR_tag BUF_C2_ADDR;    /* Buffer Component 2 Address Register */
  uint32_t JPEG_reserved10[3];
  JPEG_BUF_C3_ADDR_tag BUF_C3_ADDR;    /* Buffer Component 3 Address Register */
  uint32_t JPEG_reserved11[3];
  JPEG_BUF_C4_ADDR_tag BUF_C4_ADDR;    /* Buffer Component 4 Address Register */
  uint32_t JPEG_reserved12[3];
  JPEG_NRLINES_B2L_tag NRLINES_B2L;    /* Block to Lines Number of Lines Register */
  uint32_t JPEG_reserved13[3];
  JPEG_NRLINES_B2L_C4_tag NRLINES_B2L_C4; /* Block to Lines Number of Lines for Component 4 Register */
  uint32_t JPEG_reserved14[3];
  JPEG_TIMEOUT_tag TIMEOUT;            /* Timeout Register */
  uint32_t JPEG_reserved15[7];
  JPEG_W_CTRL1_tag W_CTRL1;            /* Wrapper Control Register */
  uint32_t JPEG_reserved16[3];
  JPEG_W_CTRL2_tag W_CTRL2;            /* Wrapper Control Register 2 */
  uint32_t JPEG_reserved17[7];
  JPEG_INTR_EN_tag INTR_EN;            /* Interrupt Enable */
  uint32_t JPEG_reserved18[3];
  JPEG_W_STATUS_tag W_STATUS;          /* Wrapper Status Register */
  uint32_t JPEG_reserved19[3];
  JPEG_E_STATUS_tag E_STATUS;          /* Error Status Register */
  uint32_t JPEG_reserved20[3];
  JPEG_RST_INTVL_tag RST_INTVL;        /* Restart Interval */
  uint32_t JPEG_reserved21[3];
  JPEG_IMG_SZ_ST1_tag IMG_SZ_ST1;      /* Image Size of Stream 1 */
  uint32_t JPEG_reserved22[3];
  JPEG_IMG_SZ_ST2_tag IMG_SZ_ST2;      /* Image Size of Stream 2 */
  uint32_t JPEG_reserved23[3];
  JPEG_IMG_SZ_ST3_tag IMG_SZ_ST3;      /* Image Size of Stream 3 */
  uint32_t JPEG_reserved24[3];
  JPEG_IMG_SZ_ST4_tag IMG_SZ_ST4;      /* Image Size of Stream 4 */
  uint32_t JPEG_reserved25[3];
  JPEG_SMPL_FCTR_ST1_tag SMPL_FCTR_ST1; /* Sampling Factor Stream 1 */
  uint32_t JPEG_reserved26[3];
  JPEG_SMPL_FCTR_ST2_tag SMPL_FCTR_ST2; /* Sampling Factor Stream 2 */
  uint32_t JPEG_reserved27[3];
  JPEG_SMPL_FCTR_ST3_tag SMPL_FCTR_ST3; /* Sampling Factor Stream 3 */
  uint32_t JPEG_reserved28[3];
  JPEG_SMPL_FCTR_ST4_tag SMPL_FCTR_ST4; /* Sampling Factor Stream 4 */
  uint32_t JPEG_reserved29[3];
  JPEG_TST_PXL_LOC_tag TST_PXL_LOC;    /* Test Pixel Location */
  uint32_t JPEG_reserved30[3];
  JPEG_TST_PXL_LOC1_tag TST_PXL_LOC1;  /* Test Pixel Location 1 */
  uint32_t JPEG_reserved31[3];
  JPEG_TST_LINE_LUMA_ST1_tag TST_LINE_LUMA_ST1; /* Test Line Luma Pixel Value for Stream 1 */
  uint32_t JPEG_reserved32[3];
  JPEG_TST_LINE_Cb_ST1_tag TST_LINE_Cb_ST1; /* Test Line Cb Pixel Value for Stream 1 */
  uint32_t JPEG_reserved33[3];
  JPEG_TST_LINE_Cr_ST1_tag TST_LINE_Cr_ST1; /* Test Line Cr Pixel Value for Stream 1 */
  uint32_t JPEG_reserved34[3];
  JPEG_TST_LINE_LUMA_ST2_tag TST_LINE_LUMA_ST2; /* Test Line Luma Pixel Value for Stream 2 */
  uint32_t JPEG_reserved35[3];
  JPEG_TST_LINE_Cb_ST2_tag TST_LINE_Cb_ST2; /* Test Line Cb Pixel Value for Stream 2 */
  uint32_t JPEG_reserved36[3];
  JPEG_TST_LINE_Cr_ST2_tag TST_LINE_Cr_ST2; /* Test Line Cr Pixel Value for Stream 2 */
  uint32_t JPEG_reserved37[3];
  JPEG_TST_LINE_LUMA_ST3_tag TST_LINE_LUMA_ST3; /* Test Line Luma Pixel Value for Stream 3 */
  uint32_t JPEG_reserved38[3];
  JPEG_TST_LINE_Cb_ST3_tag TST_LINE_Cb_ST3; /* Test Line Cb Pixel Value for Stream 3 */
  uint32_t JPEG_reserved39[3];
  JPEG_TST_LINE_Cr_ST3_tag TST_LINE_Cr_ST3; /* Test Line Cr Pixel Value for Stream 3 */
  uint32_t JPEG_reserved40[3];
  JPEG_TST_LINE_LUMA_ST4_tag TST_LINE_LUMA_ST4; /* Test Line Luma Pixel Value for Stream 4 */
  uint32_t JPEG_reserved41[3];
  JPEG_TST_LINE_Cb_ST4_tag TST_LINE_Cb_ST4; /* Test Line Luma Cb Pixel Value for Stream 4 */
  uint32_t JPEG_reserved42[3];
  JPEG_TST_LINE_Cr_ST4_tag TST_LINE_Cr_ST4; /* Test Line Cr Pixel Value for Stream 4 */
  uint32_t JPEG_reserved43[31];
  JPEG_CTRL_tag CTRL;                  /* Control Register */
  uint32_t JPEG_reserved44[3];
  JPEG_STATUS1_tag STATUS1;            /* Status 1 Register */
  uint32_t JPEG_reserved45[3];
  JPEG_STATUS2_tag STATUS2;            /* Status 2 Register */
  uint32_t JPEG_reserved46[3];
  JPEG_STATUS3_tag STATUS3;            /* Status 3 Register */
  uint32_t JPEG_reserved47[3];
  JPEG_STATUS4_tag STATUS4;            /* Status 4 Register */
  uint32_t JPEG_reserved48[3];
  JPEG_STATUS5_tag STATUS5;            /* Status 5 Register */
  uint32_t JPEG_reserved49[3];
  JPEG_STATUS6_tag STATUS6;            /* Status 6 Register */
  uint32_t JPEG_reserved50[3];
  JPEG_STATUS7_tag STATUS7;            /* Status 7 Register */
  uint32_t JPEG_reserved51[3];
  JPEG_STATUS8_tag STATUS8;            /* Status 8 Register */
  uint32_t JPEG_reserved52[3];
  JPEG_STATUS9_tag STATUS9;            /* Status 9 Register */
  uint32_t JPEG_reserved53[3];
  JPEG_STATUS10_tag STATUS10;          /* Status 10 Register */
  uint32_t JPEG_reserved54[3];
  JPEG_STATUS11_tag STATUS11;          /* Status 11 Register */
  uint32_t JPEG_reserved55[3];
  JPEG_STATUS12_tag STATUS12;          /* Status 12 Register */
  uint32_t JPEG_reserved56[3];
  JPEG_STATUS13_tag STATUS13;          /* Status 13 Register */
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

typedef union LFAST_MCR_union_tag {    /* LFAST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DATAEN:1;
    vuint32_t DRFRST:1;
    vuint32_t _unused_2:1;
    vuint32_t CTSEN:1;
    vuint32_t TXARBD:1;
    vuint32_t _unused_5:8;
    vuint32_t TXEN:1;
    vuint32_t RXEN:1;
    vuint32_t DRFEN:1;
    vuint32_t LSSEL:1;
    vuint32_t _unused_17:7;
    vuint32_t IPGDBG:1;
    vuint32_t _unused_25:6;
    vuint32_t MSEN:1;
  } B;
} LFAST_MCR_tag;

typedef union LFAST_SCR_union_tag {    /* LFAST Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t TDR:1;
    vuint32_t _unused_1:7;
    vuint32_t RDR:1;
    vuint32_t _unused_9:7;
    vuint32_t DRMD:1;
    vuint32_t _unused_17:15;
  } B;
} LFAST_SCR_tag;

typedef union LFAST_COCR_union_tag {   /* LFAST Correlator Control Register */
  vuint32_t R;
  struct {
    vuint32_t PHSSEL:1;
    vuint32_t CORRTH:3;
    vuint32_t _unused_4:12;
    vuint32_t _unused_16:2;
    vuint32_t _unused_18:6;
    vuint32_t SMPSEL:8;
  } B;
} LFAST_COCR_tag;

typedef union LFAST_TMCR_union_tag {   /* LFAST Test Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t LPFRMTH:16;
    vuint32_t LPMOD:3;
    vuint32_t _unused_19:5;
    vuint32_t LPON:1;
    vuint32_t CLKTST:1;
    vuint32_t _unused_26:6;
  } B;
} LFAST_TMCR_tag;

typedef union LFAST_ALCR_union_tag {   /* LFAST Auto Loopback Control Register */
  vuint32_t R;
  struct {
    vuint32_t LPFMCNT:16;
    vuint32_t LPCNTEN:1;
    vuint32_t _unused_17:15;
  } B;
} LFAST_ALCR_tag;

typedef union LFAST_RCDCR_union_tag {  /* LFAST Rate Change Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DRCNT:4;
    vuint32_t _unused_20:12;
  } B;
} LFAST_RCDCR_tag;

typedef union LFAST_SLCR_union_tag {   /* LFAST Wakeup Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t LWKCNT:4;
    vuint32_t _unused_4:4;
    vuint32_t HWKCNT:8;
    vuint32_t LSCNT:4;
    vuint32_t _unused_20:4;
    vuint32_t HSCNT:8;
  } B;
} LFAST_SLCR_tag;

typedef union LFAST_ICR_union_tag {    /* LFAST ICLC Control Register */
  vuint32_t R;
  struct {
    vuint32_t ICLCPLD:8;
    vuint32_t _unused_8:8;
    vuint32_t SNDICLC:1;
    vuint32_t ICLCSEQ:1;
    vuint32_t _unused_18:14;
  } B;
} LFAST_ICR_tag;

typedef union LFAST_PICR_union_tag {   /* LFAST Ping Control Register */
  vuint32_t R;
  struct {
    vuint32_t PNGPYLD:8;
    vuint32_t _unused_8:7;
    vuint32_t PNGAUTO:1;
    vuint32_t PNGREQ:1;
    vuint32_t _unused_17:15;
  } B;
} LFAST_PICR_tag;

typedef union LFAST_RFCR_union_tag {   /* LFAST Rx FIFO CTS Control Register */
  vuint32_t R;
  struct {
    vuint32_t RCTSMN:6;
    vuint32_t _unused_6:10;
    vuint32_t RCTSMX:6;
    vuint32_t _unused_22:10;
  } B;
} LFAST_RFCR_tag;

typedef union LFAST_TIER_union_tag {   /* LFAST Tx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TXDTIE:1;
    vuint32_t TXICLCIE:1;
    vuint32_t TXUNSIE:1;
    vuint32_t _unused_3:1;
    vuint32_t TXPNGIE:1;
    vuint32_t _unused_5:11;
    vuint32_t TXOVIE:1;
    vuint32_t TXIIE:1;
    vuint32_t _unused_18:14;
  } B;
} LFAST_TIER_tag;

typedef union LFAST_RIER_union_tag {   /* LFAST Rx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t RXUNSIE:1;
    vuint32_t RXDIE:1;
    vuint32_t RXCTSIE:1;
    vuint32_t _unused_4:12;
    vuint32_t RXLCEIE:1;
    vuint32_t RXICIE:1;
    vuint32_t RXSZIE:1;
    vuint32_t RXOFIE:1;
    vuint32_t RXUFIE:1;
    vuint32_t RXMXIE:1;
    vuint32_t RXMNIE:1;
    vuint32_t RXUOIE:1;
    vuint32_t _unused_24:8;
  } B;
} LFAST_RIER_tag;

typedef union LFAST_RIIER_union_tag {  /* LFAST Rx ICLC Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t ICPONIE:1;
    vuint32_t ICPOFIE:1;
    vuint32_t ICTSIE:1;
    vuint32_t ICTFIE:1;
    vuint32_t ICRSIE:1;
    vuint32_t ICRFIE:1;
    vuint32_t ICTEIE:1;
    vuint32_t ICTDIE:1;
    vuint32_t ICCTIE:1;
    vuint32_t ICLPIE:1;
    vuint32_t ICTOIE:1;
    vuint32_t ICPRIE:1;
    vuint32_t ICPSIE:1;
    vuint32_t ICPFIE:1;
    vuint32_t _unused_14:18;
  } B;
} LFAST_RIIER_tag;

typedef union LFAST_PLLCR_union_tag {  /* LFAST PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t PREDIV:2;
    vuint32_t FBDIV:6;
    vuint32_t FDIVEN:1;
    vuint32_t _unused_9:2;
    vuint32_t _unused_11:2;
    vuint32_t _unused_13:2;
    vuint32_t REFINV:1;
    vuint32_t SWPON:1;
    vuint32_t SWPOFF:1;
    vuint32_t _unused_18:11;
    vuint32_t IPTMOD:3;
  } B;
} LFAST_PLLCR_tag;

typedef union LFAST_LCR_union_tag {    /* LFAST LVDS Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t LVRXOP_TR:1;
    vuint32_t _unused_6:5;
    vuint32_t LVLPEN:1;                /* Tx LVDS internal loopback enable */
    vuint32_t LVRFEN:1;
    vuint32_t TXCMUX:1;
    vuint32_t LVTXOE:1;
    vuint32_t LVRXOFF:1;
    vuint32_t SWONLR:1;
    vuint32_t SWOFFLR:1;
    vuint32_t SWONLD:1;
    vuint32_t SWOFFLD:1;
    vuint32_t SWSLPLR:1;
    vuint32_t SWWKLR:1;
    vuint32_t SWSLPLD:1;
    vuint32_t SWWKLD:1;
    vuint32_t _unused_24:8;
  } B;
} LFAST_LCR_tag;

typedef union LFAST_UNSTCR_union_tag { /* LFAST Unsolicited Tx Control Register */
  vuint32_t R;
  struct {
    vuint32_t UNSHDR:7;
    vuint32_t _unused_7:9;
    vuint32_t USNDRQ:1;
    vuint32_t _unused_17:15;
  } B;
} LFAST_UNSTCR_tag;

typedef union LFAST_UNSTDR_union_tag { /* LFAST Unsolicited Tx Data Registers */
  vuint32_t R;
  struct {
    vuint32_t UNTXD:32;
  } B;
} LFAST_UNSTDR_tag;

typedef union LFAST_GSR_union_tag {    /* LFAST Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t LPCSDV:1;
    vuint32_t LPCHDV:1;
    vuint32_t LPCPDV:1;
    vuint32_t LPFPDV:1;
    vuint32_t LPTXDN:1;
    vuint32_t _unused_5:11;
    vuint32_t DRSM:1;
    vuint32_t LDSM:1;
    vuint32_t LRMD:1;
    vuint32_t _unused_19:12;
    vuint32_t DUALMD:1;
  } B;
} LFAST_GSR_tag;

typedef union LFAST_PISR_union_tag {   /* LFAST Ping Status Register */
  vuint32_t R;
  struct {
    vuint32_t RXPNGD:8;
    vuint32_t _unused_8:24;
  } B;
} LFAST_PISR_tag;

typedef union LFAST_DFSR_union_tag {   /* LFAST Data Frame Status Register */
  vuint32_t R;
  struct {
    vuint32_t TXFCNT:3;
    vuint32_t _unused_3:5;
    vuint32_t TXDCNT:6;
    vuint32_t _unused_14:2;
    vuint32_t RXFCNT:3;
    vuint32_t _unused_19:5;
    vuint32_t RXDCNT:6;
    vuint32_t _unused_30:2;
  } B;
} LFAST_DFSR_tag;

typedef union LFAST_TISR_union_tag {   /* LFAST Tx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t TXDTF:1;
    vuint32_t TXICLCF:1;
    vuint32_t TXUNSF:1;
    vuint32_t _unused_3:1;
    vuint32_t TXPNGF:1;
    vuint32_t _unused_5:11;
    vuint32_t TXOVF:1;
    vuint32_t TXIEF:1;
    vuint32_t _unused_18:14;
  } B;
} LFAST_TISR_tag;

typedef union LFAST_RISR_union_tag {   /* LFAST Rx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t RXUNSF:1;
    vuint32_t RXDF:1;
    vuint32_t RXCTSF:1;
    vuint32_t _unused_4:12;
    vuint32_t RXLCEF:1;
    vuint32_t RXICF:1;
    vuint32_t RXSZF:1;
    vuint32_t RXOFF:1;
    vuint32_t RXUFF:1;
    vuint32_t RXMXF:1;
    vuint32_t RXMNF:1;
    vuint32_t RXUOF:1;
    vuint32_t _unused_24:8;
  } B;
} LFAST_RISR_tag;

typedef union LFAST_RIISR_union_tag {  /* LFAST Rx ICLC Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t ICPONF:1;
    vuint32_t ICPOFF:1;
    vuint32_t ICTSF:1;
    vuint32_t ICTFF:1;
    vuint32_t ICRSF:1;
    vuint32_t ICRFF:1;
    vuint32_t ICTEF:1;
    vuint32_t ICTDF:1;
    vuint32_t ICCTF:1;
    vuint32_t ICLPF:1;
    vuint32_t ICTOF:1;
    vuint32_t ICPRF:1;
    vuint32_t ICPSF:1;
    vuint32_t ICPFF:1;
    vuint32_t _unused_14:18;
  } B;
} LFAST_RIISR_tag;

typedef union LFAST_PLLLSR_union_tag { /* LFAST PLL and LVDS Status Register */
  vuint32_t R;
  struct {
    vuint32_t LRPDS:1;
    vuint32_t LDPDS:1;
    vuint32_t LDSLPS:1;
    vuint32_t LRSLPS:1;
    vuint32_t _unused_4:12;
    vuint32_t _unused_16:1;
    vuint32_t PLLDIS:1;
    vuint32_t _unused_18:14;
  } B;
} LFAST_PLLLSR_tag;

typedef union LFAST_UNSRSR_union_tag { /* LFAST Unsolicited Rx Status Register */
  vuint32_t R;
  struct {
    vuint32_t URPCNT:3;
    vuint32_t _unused_3:5;
    vuint32_t URXDV:1;
    vuint32_t _unused_9:23;
  } B;
} LFAST_UNSRSR_tag;

typedef union LFAST_UNSRDR_union_tag { /* LFAST Unsolicited Rx Data Register */
  vuint32_t R;
  struct {
    vuint32_t UNRXD:32;
  } B;
} LFAST_UNSRDR_tag;

struct LFAST_tag {
  LFAST_MCR_tag MCR;                   /* LFAST Mode Configuration Register */
  LFAST_SCR_tag SCR;                   /* LFAST Speed Control Register */
  LFAST_COCR_tag COCR;                 /* LFAST Correlator Control Register */
  LFAST_TMCR_tag TMCR;                 /* LFAST Test Mode Control Register */
  LFAST_ALCR_tag ALCR;                 /* LFAST Auto Loopback Control Register */
  LFAST_RCDCR_tag RCDCR;               /* LFAST Rate Change Delay Control Register */
  LFAST_SLCR_tag SLCR;                 /* LFAST Wakeup Delay Control Register */
  LFAST_ICR_tag ICR;                   /* LFAST ICLC Control Register */
  LFAST_PICR_tag PICR;                 /* LFAST Ping Control Register */
  uint8_t LFAST_reserved0[8];
  LFAST_RFCR_tag RFCR;                 /* LFAST Rx FIFO CTS Control Register */
  LFAST_TIER_tag TIER;                 /* LFAST Tx Interrupt Enable Register */
  LFAST_RIER_tag RIER;                 /* LFAST Rx Interrupt Enable Register */
  LFAST_RIIER_tag RIIER;               /* LFAST Rx ICLC Interrupt Enable Register */
  LFAST_PLLCR_tag PLLCR;               /* LFAST PLL Control Register */
  LFAST_LCR_tag LCR;                   /* LFAST LVDS Control Register */
  LFAST_UNSTCR_tag UNSTCR;             /* LFAST Unsolicited Tx Control Register */
  LFAST_UNSTDR_tag UNSTDR[9];          /* LFAST Unsolicited Tx Data Registers */
  uint8_t LFAST_reserved1[20];
  LFAST_GSR_tag GSR;                   /* LFAST Global Status Register */
  LFAST_PISR_tag PISR;                 /* LFAST Ping Status Register */
  uint8_t LFAST_reserved2[12];
  LFAST_DFSR_tag DFSR;                 /* LFAST Data Frame Status Register */
  LFAST_TISR_tag TISR;                 /* LFAST Tx Interrupt Status Register */
  LFAST_RISR_tag RISR;                 /* LFAST Rx Interrupt Status Register */
  LFAST_RIISR_tag RIISR;               /* LFAST Rx ICLC Interrupt Status Register */
  LFAST_PLLLSR_tag PLLLSR;             /* LFAST PLL and LVDS Status Register */
  LFAST_UNSRSR_tag UNSRSR;             /* LFAST Unsolicited Rx Status Register */
  LFAST_UNSRDR_tag UNSRDR[9];          /* LFAST Unsolicited Rx Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:1;
    vuint32_t SLEEP:1;
    vuint32_t RBLM:1;
    vuint32_t SSBL:1;
    vuint32_t MME:1;
    vuint32_t LBKM:1;
    vuint32_t _unused_6:1;
    vuint32_t BF:1;
    vuint32_t MBL:4;
    vuint32_t AUTOWU:1;
    vuint32_t LASE:1;
    vuint32_t CFD:1;
    vuint32_t CCD:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t HRIE:1;
    vuint32_t DTIE:1;
    vuint32_t DRIE:1;
    vuint32_t TOIE:1;
    vuint32_t _unused_4:1;
    vuint32_t WUIE:1;
    vuint32_t LSIE:1;
    vuint32_t BOIE:1;
    vuint32_t FEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t HEIE:1;
    vuint32_t CEIE:1;
    vuint32_t BEIE:1;
    vuint32_t OCIE:1;
    vuint32_t SZIE:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRF:1;
    vuint32_t DTF:1;
    vuint32_t DRF:1;
    vuint32_t _unused_3:2;
    vuint32_t WUF:1;
    vuint32_t RDI:1;
    vuint32_t RXbusy:1;
    vuint32_t DRBNE:1;
    vuint32_t RMB:1;
    vuint32_t _unused_10:2;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t RDC:3;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:12;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t NF:1;
    vuint32_t _unused_1:6;
    vuint32_t BOF:1;
    vuint32_t FEF:1;
    vuint32_t IDPEF:1;
    vuint32_t SDEF:1;
    vuint32_t SFEF:1;
    vuint32_t CEF:1;
    vuint32_t BEF:1;
    vuint32_t OCF:1;
    vuint32_t SZF:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t UART:1;
    vuint32_t WL0:1;
    vuint32_t PCE:1;
    vuint32_t PC0:1;
    vuint32_t TxEn:1;
    vuint32_t RxEn:1;
    vuint32_t PC1:1;
    vuint32_t WL1:1;
    vuint32_t TFBM:1;
    vuint32_t RFBM:1;
    vuint32_t RDFL_RFC:3;
    vuint32_t TDFL_TFC:3;
    vuint32_t _unused_16:1;
    vuint32_t SBUR:2;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t NEF:3;
    vuint32_t ROSE:1;
    vuint32_t OSR:4;
    vuint32_t CSP:3;
    vuint32_t MIS:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t NF:1;
    vuint32_t DTFTFF:1;
    vuint32_t DRFRFE:1;
    vuint32_t TO:1;
    vuint32_t RFNE:1;
    vuint32_t WUF:1;
    vuint32_t RDI:1;
    vuint32_t BOF:1;
    vuint32_t FEF:1;
    vuint32_t RMB:1;
    vuint32_t PE:4;
    vuint32_t OCF:1;
    vuint32_t SZF:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:8;
    vuint32_t TOCE:1;
    vuint32_t IOT:1;
    vuint32_t MODE:1;
    vuint32_t _unused_11:21;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t OC1:8;
    vuint32_t OC2:8;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t HTO:7;
    vuint32_t _unused_7:1;
    vuint32_t RTO:4;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t FBR:4;
    vuint32_t _unused_4:28;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t IBR:20;
    vuint32_t _unused_20:12;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t CF:8;
    vuint32_t _unused_8:24;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t HTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t DDRQ:1;
    vuint32_t WURQ:1;
    vuint32_t IOPE:1;
    vuint32_t IOBE:1;
    vuint32_t TBDE:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t ID:6;
    vuint32_t _unused_6:2;
    vuint32_t CCS:1;
    vuint32_t DIR:1;
    vuint32_t DFL:3;
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA0:8;
    vuint32_t DATA1:8;
    vuint32_t DATA2:8;
    vuint32_t DATA3:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA4:8;
    vuint32_t DATA5:8;
    vuint32_t DATA6:8;
    vuint32_t DATA7:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FACT:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t IFMI:5;
    vuint32_t _unused_5:27;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t IFM:8;
    vuint32_t _unused_8:24;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t ID:6;                    /* Identifier */
    vuint32_t _unused_6:2;
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t DFL:3;                   /* Data Field Length */
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t SR:1;
    vuint32_t STOP:1;
    vuint32_t RDLIS:1;
    vuint32_t TDLIS:1;
    vuint32_t RDFBM:1;
    vuint32_t TDFBM:1;
    vuint32_t _unused_6:26;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t PTO:12;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t CTO:12;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t DTE:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t DRE:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: LMEM ===============================
   ============================================================================ */

typedef union LMEM_PCCCR_union_tag {   /* Processor Code Cache Control Register */
  vuint32_t R;
  struct {
    vuint32_t ENCACHE:1;               /* Cache enable */
    vuint32_t ENWRBUF:1;               /* Enable Write Buffer */
    vuint32_t PCCR2:1;                 /* Forces all cacheable spaces to write through */
    vuint32_t PCCR3:1;                 /* Forces no allocation on cache misses (must also have the PCCR2 bit asserted) */
    vuint32_t _unused_4:20;
    vuint32_t INVW0:1;                 /* Invalidate Way 0 */
    vuint32_t PUSHW0:1;                /* Push Way 0 */
    vuint32_t INVW1:1;                 /* Invalidate Way 1 */
    vuint32_t PUSHW1:1;                /* Push Way 1 */
    vuint32_t _unused_28:3;
    vuint32_t GO:1;                    /* Initiate Cache Command */
  } B;
} LMEM_PCCCR_tag;

typedef union LMEM_PCCLCR_union_tag {  /* Processor Code Cache Line Control Register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t CACHEADDR:11;            /* Cache address */
    vuint32_t _unused_13:1;
    vuint32_t WSEL:1;                  /* Way select */
    vuint32_t _unused_15:1;
    vuint32_t TDSEL:1;                 /* Tag/Data Select */
    vuint32_t _unused_17:3;
    vuint32_t LCIVB:1;                 /* Line Command Initial Valid Bit */
    vuint32_t LCIMB:1;                 /* Line Command Initial Modified Bit */
    vuint32_t LCWAY:1;                 /* Line Command Way */
    vuint32_t _unused_23:1;
    vuint32_t LCMD:2;                  /* Line Command */
    vuint32_t LADSEL:1;                /* Line Address Select */
    vuint32_t LACC:1;                  /* Line access type */
    vuint32_t _unused_28:4;
  } B;
} LMEM_PCCLCR_tag;

typedef union LMEM_PCCSAR_union_tag {  /* Processor Code Cache Search Address Register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t PHYADDR:30;              /* Physical Address */
  } B;
} LMEM_PCCSAR_tag;

typedef union LMEM_PCCCVR_union_tag {  /* Processor Code Cache Read/Write Value Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Cache read/write Data */
  } B;
} LMEM_PCCCVR_tag;

typedef union LMEM_PSCCR_union_tag {   /* Processor System Cache Control Register */
  vuint32_t R;
  struct {
    vuint32_t ENCACHE:1;               /* Cache enable */
    vuint32_t ENWRBUF:1;               /* Enable Write Buffer */
    vuint32_t _unused_2:22;
    vuint32_t INVW0:1;                 /* Invalidate Way 0 */
    vuint32_t PUSHW0:1;                /* Push Way 0 */
    vuint32_t INVW1:1;                 /* Invalidate Way 1 */
    vuint32_t PUSHW1:1;                /* Push Way 1 */
    vuint32_t _unused_28:3;
    vuint32_t GO:1;                    /* Initiate Cache Command */
  } B;
} LMEM_PSCCR_tag;

typedef union LMEM_PSCLCR_union_tag {  /* Processor System Cache Line Control Register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t CACHEADDR:11;            /* Cache address */
    vuint32_t _unused_13:1;
    vuint32_t WSEL:1;                  /* Way select */
    vuint32_t _unused_15:1;
    vuint32_t TDSEL:1;                 /* Tag/Data Select */
    vuint32_t _unused_17:3;
    vuint32_t LCIVB:1;                 /* Line Command Initial Valid Bit */
    vuint32_t LCIMB:1;                 /* Line Command Initial Modified Bit */
    vuint32_t LCWAY:1;                 /* Line Command Way */
    vuint32_t _unused_23:1;
    vuint32_t LCMD:2;                  /* Line Command */
    vuint32_t LADSEL:1;                /* Line Address Select */
    vuint32_t LACC:1;                  /* Line access type */
    vuint32_t _unused_28:4;
  } B;
} LMEM_PSCLCR_tag;

typedef union LMEM_PSCSAR_union_tag {  /* Processor System Cache Search Address Register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t PHYADDR:30;              /* Physical Address */
  } B;
} LMEM_PSCSAR_tag;

typedef union LMEM_PSCCVR_union_tag {  /* Processor System Cache Read/Write Value Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Cache read/write Data */
  } B;
} LMEM_PSCCVR_tag;

struct LMEM_tag {
  LMEM_PCCCR_tag PCCCR;                /* Processor Code Cache Control Register */
  LMEM_PCCLCR_tag PCCLCR;              /* Processor Code Cache Line Control Register */
  LMEM_PCCSAR_tag PCCSAR;              /* Processor Code Cache Search Address Register */
  LMEM_PCCCVR_tag PCCCVR;              /* Processor Code Cache Read/Write Value Register */
  uint8_t LMEM_reserved0[2032];
  LMEM_PSCCR_tag PSCCR;                /* Processor System Cache Control Register */
  LMEM_PSCLCR_tag PSCLCR;              /* Processor System Cache Line Control Register */
  LMEM_PSCSAR_tag PSCSAR;              /* Processor System Cache Search Address Register */
  LMEM_PSCCVR_tag PSCCVR;              /* Processor System Cache Read/Write Value Register */
};


/* ============================================================================
   =============================== Module: MCM ================================
   ============================================================================ */

typedef union MCM_PLASC_union_tag {    /* Crossbar Switch (AXBS) Slave Configuration */
  vuint16_t R;
  struct {
    vuint16_t ASC:7;                   /* Each bit in the ASC field indicates whether there is a corresponding connection to the crossbar switch's slave input port. */
    vuint16_t _unused_7:9;
  } B;
} MCM_PLASC_tag;

typedef union MCM_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:9;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:14;
    vuint32_t SRAMUAP:2;               /* TCRAM_U arbitration priority */
    vuint32_t SRAMUWP:1;               /* TCRAM_U write protect */
    vuint32_t _unused_27:1;
    vuint32_t SRAMLAP:2;               /* TCRAM_L arbitration priority */
    vuint32_t SRAMLWP:1;               /* TCRAM_L Write Protect */
    vuint32_t _unused_31:1;
  } B;
} MCM_CR_tag;

typedef union MCM_ISCR_union_tag {     /* Interrupt Status and Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t _unused_3:1;
    vuint32_t CWBER:1;                 /* Cache write buffer error status */
    vuint32_t _unused_5:3;
    vuint32_t FIOC:1;                  /* FPU invalid operation interrupt status */
    vuint32_t FDZC:1;                  /* FPU divide-by-zero interrupt status */
    vuint32_t FOFC:1;                  /* FPU overflow interrupt status */
    vuint32_t FUFC:1;                  /* FPU underflow interrupt status */
    vuint32_t FIXC:1;                  /* FPU inexact interrupt status */
    vuint32_t _unused_13:2;
    vuint32_t FIDC:1;                  /* FPU input denormal interrupt status */
    vuint32_t _unused_16:4;
    vuint32_t CWBEE:1;                 /* Cache write buffer error enable */
    vuint32_t _unused_21:3;
    vuint32_t FIOCE:1;                 /* FPU invalid operation interrupt enable */
    vuint32_t FDZCE:1;                 /* FPU divide-by-zero interrupt enable */
    vuint32_t FOFCE:1;                 /* FPU overflow interrupt enable */
    vuint32_t FUFCE:1;                 /* FPU underflow interrupt enable */
    vuint32_t FIXCE:1;                 /* FPU inexact interrupt enable */
    vuint32_t _unused_29:2;
    vuint32_t FIDCE:1;                 /* FPU input denormal interrupt enable */
  } B;
} MCM_ISCR_tag;

typedef union MCM_FADR_union_tag {     /* Fault address register */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;              /* Fault address */
  } B;
} MCM_FADR_tag;

typedef union MCM_FATR_union_tag {     /* Fault attributes register */
  vuint32_t R;
  struct {
    vuint32_t BEDA:1;                  /* Bus error access type */
    vuint32_t BEMD:1;                  /* Bus error privilege level */
    vuint32_t _unused_2:2;
    vuint32_t BESZ:2;                  /* Bus error size */
    vuint32_t _unused_6:1;
    vuint32_t BEWT:1;                  /* Bus error write */
    vuint32_t BEMN:4;                  /* Bus error master number */
    vuint32_t _unused_12:19;
    vuint32_t BEOVR:1;                 /* Bus error overrun */
  } B;
} MCM_FATR_tag;

typedef union MCM_FDR_union_tag {      /* Fault data register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Fault data */
  } B;
} MCM_FDR_tag;

struct MCM_tag {
  uint8_t MCM_reserved0[8];
  MCM_PLASC_tag PLASC;                 /* Crossbar Switch (AXBS) Slave Configuration */
  uint8_t MCM_reserved1[2];
  MCM_CR_tag CR;                       /* Control Register */
  MCM_ISCR_tag ISCR;                   /* Interrupt Status and Control Register */
  uint8_t MCM_reserved2[12];
  MCM_FADR_tag FADR;                   /* Fault address register */
  MCM_FATR_tag FATR;                   /* Fault attributes register */
  MCM_FDR_tag FDR;                     /* Fault data register */
};


/* ============================================================================
   =============================== Module: MCT ================================
   ============================================================================ */

typedef union MCT_ALGOSEL_union_tag {  /* MCT Algorithm Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t MCMSIN:1;                /* March C- Single */
    vuint32_t MCMEX:1;                 /* March C minus 8x */
    vuint32_t MCPS:1;                  /* March C+ Single */
    vuint32_t MCPEX:1;                 /* March C+ 8x */
    vuint32_t MLRS:1;                  /* March LR single */
    vuint32_t MLREX:1;                 /* March LR 8x */
    vuint32_t MRCHMSS:1;               /* March MSS1 */
    vuint32_t BBREAD:1;                /* Back to back reads */
    vuint32_t WRCHK:1;                 /* Write checkerboard */
    vuint32_t RDCHK:1;                 /* Read Checkerboard */
    vuint32_t WRINVCHK:1;              /* Write Inverted Checkerboard */
    vuint32_t RDINVCHK:1;              /* Read Inverted Checkerboard */
    vuint32_t BSCCHK:1;                /* Basic Check */
    vuint32_t _unused_14:16;
    vuint32_t MCMAB:1;                 /* March C- Any Bit */
    vuint32_t MEMINIT:1;               /* Memory Initialisation */
  } B;
} MCT_ALGOSEL_tag;

typedef union MCT_BSTART_union_tag {   /* BIST Start register */
  vuint32_t R;
  struct {
    vuint32_t BSTRT:3;                 /* BIST start */
    vuint32_t _unused_3:28;
    vuint32_t CLKEN:1;                 /* IPS clock enable, enables the programming clock for the BISTs. */
  } B;
} MCT_BSTART_tag;

typedef union MCT_STAG_D_union_tag {   /* Stagger delay register */
  vuint32_t R;
  struct {
    vuint32_t STAG:32;                 /* Stagger delay value This value is the number of clock (SYS6_CLK) cycles between starting one BIST and going to next BIST. */
  } B;
} MCT_STAG_D_tag;

struct MCT_tag {
  uint8_t MCT_reserved0[8];
  MCT_ALGOSEL_tag ALGOSEL;             /* MCT Algorithm Select Register */
  uint8_t MCT_reserved1[80];
  MCT_BSTART_tag BSTART;               /* BIST Start register */
  MCT_STAG_D_tag STAG_D;               /* Stagger delay register */
};


/* ============================================================================
   =============================== Module: MC_CGM_0 ===========================
   ============================================================================ */

typedef union MC_CGM_0_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_0_PCS_SDUR_tag;

typedef union MC_CGM_0_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_0_PCS_DIVC2_tag;

typedef union MC_CGM_0_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_0_PCS_DIVE2_tag;

typedef union MC_CGM_0_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_0_PCS_DIVS2_tag;

typedef union MC_CGM_0_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:21;
    vuint32_t SYS_UPD_TYPE:1;
  } B;
} MC_CGM_0_DIV_UPD_TYPE_tag;

typedef union MC_CGM_0_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_0_DIV_UPD_TRIG_tag;

typedef union MC_CGM_0_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:21;
    vuint32_t SYS_UPD_STAT:1;
  } B;
} MC_CGM_0_DIV_UPD_STAT_tag;

typedef union MC_CGM_0_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SWIP:1;
    vuint32_t SWTRG:3;
    vuint32_t _unused_20:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_SC_SS_tag;

typedef union MC_CGM_0_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_SC_DC0_tag;

typedef union MC_CGM_0_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_SC_DC1_tag;

typedef union MC_CGM_0_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:3;
    vuint32_t _unused_19:12;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_SC_DC2_tag;

typedef union MC_CGM_0_AC0_SC_union_tag { /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC0_SC_tag;

typedef union MC_CGM_0_AC0_SS_union_tag { /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC0_SS_tag;

typedef union MC_CGM_0_AC0_DC0_union_tag { /* Auxiliary Clock 0 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC0_DC0_tag;

typedef union MC_CGM_0_AC1_SC_union_tag { /* Auxiliary Clock 1 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC1_SC_tag;

typedef union MC_CGM_0_AC1_SS_union_tag { /* Auxiliary Clock 1 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC1_SS_tag;

typedef union MC_CGM_0_AC1_DC0_union_tag { /* Auxiliary Clock 1 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC1_DC0_tag;

typedef union MC_CGM_0_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC2_SC_tag;

typedef union MC_CGM_0_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC2_SS_tag;

typedef union MC_CGM_0_AC2_DC0_union_tag { /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC2_DC0_tag;

typedef union MC_CGM_0_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC3_SC_tag;

typedef union MC_CGM_0_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC3_SS_tag;

typedef union MC_CGM_0_AC3_DC0_union_tag { /* Auxiliary Clock 3 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC3_DC0_tag;

typedef union MC_CGM_0_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC4_SC_tag;

typedef union MC_CGM_0_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC4_SS_tag;

typedef union MC_CGM_0_AC4_DC0_union_tag { /* Auxiliary Clock 4 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC4_DC0_tag;

typedef union MC_CGM_0_AC5_SC_union_tag { /* Auxiliary Clock 5 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:2;
    vuint32_t _unused_26:6;
  } B;
} MC_CGM_0_AC5_SC_tag;

typedef union MC_CGM_0_AC5_SS_union_tag { /* Auxiliary Clock 5 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:2;
    vuint32_t _unused_26:6;
  } B;
} MC_CGM_0_AC5_SS_tag;

typedef union MC_CGM_0_AC5_DC0_union_tag { /* Auxiliary Clock 5 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC5_DC0_tag;

typedef union MC_CGM_0_AC5_DC1_union_tag { /* Auxiliary Clock 5 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC5_DC1_tag;

typedef union MC_CGM_0_AC6_SC_union_tag { /* Auxiliary Clock 6 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:2;
    vuint32_t _unused_26:6;
  } B;
} MC_CGM_0_AC6_SC_tag;

typedef union MC_CGM_0_AC6_SS_union_tag { /* Auxiliary Clock 6 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:2;
    vuint32_t _unused_26:6;
  } B;
} MC_CGM_0_AC6_SS_tag;

typedef union MC_CGM_0_AC6_DC0_union_tag { /* Auxiliary Clock 6 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC6_DC0_tag;

typedef union MC_CGM_0_AC7_SC_union_tag { /* Auxiliary Clock 7 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC7_SC_tag;

typedef union MC_CGM_0_AC7_SS_union_tag { /* Auxiliary Clock 7 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC7_SS_tag;

typedef union MC_CGM_0_AC7_DC1_union_tag { /* Auxiliary Clock 7 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:5;
    vuint32_t _unused_21:10;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC7_DC1_tag;

typedef union MC_CGM_0_AC8_SC_union_tag { /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC8_SC_tag;

typedef union MC_CGM_0_AC8_SS_union_tag { /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_0_AC8_SS_tag;

typedef union MC_CGM_0_AC8_DC0_union_tag { /* Auxiliary Clock 8 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC8_DC0_tag;

typedef union MC_CGM_0_AC8_DC1_union_tag { /* Auxiliary Clock 8 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC8_DC1_tag;

typedef union MC_CGM_0_AC9_SC_union_tag { /* Auxiliary Clock 9 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC9_SC_tag;

typedef union MC_CGM_0_AC9_SS_union_tag { /* Auxiliary Clock 9 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC9_SS_tag;

typedef union MC_CGM_0_AC9_DC0_union_tag { /* Auxiliary Clock 9 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:3;
    vuint32_t _unused_19:12;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC9_DC0_tag;

typedef union MC_CGM_0_AC9_DC1_union_tag { /* Auxiliary Clock 9 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:3;
    vuint32_t _unused_19:12;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC9_DC1_tag;

typedef union MC_CGM_0_AC10_SC_union_tag { /* Auxiliary Clock 10 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC10_SC_tag;

typedef union MC_CGM_0_AC10_SS_union_tag { /* Auxiliary Clock 10 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC10_SS_tag;

typedef union MC_CGM_0_AC10_DC0_union_tag { /* Auxiliary Clock 10 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t _unused_4:12;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC10_DC0_tag;

typedef union MC_CGM_0_AC10_DC1_union_tag { /* Auxiliary Clock 10 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC10_DC1_tag;

typedef union MC_CGM_0_AC11_SC_union_tag { /* Auxiliary Clock 11 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:1;
    vuint32_t _unused_25:7;
  } B;
} MC_CGM_0_AC11_SC_tag;

typedef union MC_CGM_0_AC11_SS_union_tag { /* Auxiliary Clock 11 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_25:7;
  } B;
} MC_CGM_0_AC11_SS_tag;

typedef union MC_CGM_0_AC11_DC0_union_tag { /* Auxiliary Clock 11 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC11_DC0_tag;

typedef union MC_CGM_0_AC12_SC_union_tag { /* Auxiliary Clock 12 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC12_SC_tag;

typedef union MC_CGM_0_AC12_SS_union_tag { /* Auxiliary Clock 12 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC12_SS_tag;

typedef union MC_CGM_0_AC12_DC0_union_tag { /* Auxiliary Clock 12 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC12_DC0_tag;

typedef union MC_CGM_0_AC13_SC_union_tag { /* Auxiliary Clock 13 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC13_SC_tag;

typedef union MC_CGM_0_AC13_SS_union_tag { /* Auxiliary Clock 13 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC13_SS_tag;

typedef union MC_CGM_0_AC13_DC0_union_tag { /* Auxiliary Clock 13 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC13_DC0_tag;

typedef union MC_CGM_0_AC14_SC_union_tag { /* Auxiliary Clock 14 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC14_SC_tag;

typedef union MC_CGM_0_AC14_SS_union_tag { /* Auxiliary Clock 14 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC14_SS_tag;

typedef union MC_CGM_0_AC14_DC0_union_tag { /* Auxiliary Clock 14 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC14_DC0_tag;

typedef union MC_CGM_0_AC15_SC_union_tag { /* Auxiliary Clock 15 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC15_SC_tag;

typedef union MC_CGM_0_AC15_SS_union_tag { /* Auxiliary Clock 15 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_0_AC15_SS_tag;

typedef union MC_CGM_0_AC15_DC0_union_tag { /* Auxiliary Clock 15 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_0_AC15_DC0_tag;

struct MC_CGM_0_tag {
  uint8_t MC_CGM_0_reserved0[1795];
  MC_CGM_0_PCS_SDUR_tag PCS_SDUR;      /* PCS Switch Duration Register */
  uint8_t MC_CGM_0_reserved1[12];
  MC_CGM_0_PCS_DIVC2_tag PCS_DIVC2;    /* PCS Divider Change Register 2 */
  MC_CGM_0_PCS_DIVE2_tag PCS_DIVE2;    /* PCS Divider End Register 2 */
  MC_CGM_0_PCS_DIVS2_tag PCS_DIVS2;    /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_0_reserved2[184];
  MC_CGM_0_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_0_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_0_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_0_reserved3[4];
  MC_CGM_0_SC_SS_tag SC_SS;            /* System Clock Select Status Register */
  MC_CGM_0_SC_DC0_tag SC_DC0;          /* System Clock Divider 0 Configuration Register */
  MC_CGM_0_SC_DC1_tag SC_DC1;          /* System Clock Divider 1 Configuration Register */
  MC_CGM_0_SC_DC2_tag SC_DC2;          /* System Clock Divider 2 Configuration Register */
  uint8_t MC_CGM_0_reserved4[12];
  MC_CGM_0_AC0_SC_tag AC0_SC;          /* Auxiliary Clock 0 Select Control Register */
  MC_CGM_0_AC0_SS_tag AC0_SS;          /* Auxiliary Clock 0 Select Status Register */
  MC_CGM_0_AC0_DC0_tag AC0_DC0;        /* Auxiliary Clock 0 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved5[20];
  MC_CGM_0_AC1_SC_tag AC1_SC;          /* Auxiliary Clock 1 Select Control Register */
  MC_CGM_0_AC1_SS_tag AC1_SS;          /* Auxiliary Clock 1 Select Status Register */
  MC_CGM_0_AC1_DC0_tag AC1_DC0;        /* Auxiliary Clock 1 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved6[20];
  MC_CGM_0_AC2_SC_tag AC2_SC;          /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_0_AC2_SS_tag AC2_SS;          /* Auxiliary Clock 2 Select Status Register */
  MC_CGM_0_AC2_DC0_tag AC2_DC0;        /* Auxiliary Clock 2 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved7[20];
  MC_CGM_0_AC3_SC_tag AC3_SC;          /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_0_AC3_SS_tag AC3_SS;          /* Auxiliary Clock 3 Select Status Register */
  MC_CGM_0_AC3_DC0_tag AC3_DC0;        /* Auxiliary Clock 3 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved8[20];
  MC_CGM_0_AC4_SC_tag AC4_SC;          /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_0_AC4_SS_tag AC4_SS;          /* Auxiliary Clock 4 Select Status Register */
  MC_CGM_0_AC4_DC0_tag AC4_DC0;        /* Auxiliary Clock 4 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved9[20];
  MC_CGM_0_AC5_SC_tag AC5_SC;          /* Auxiliary Clock 5 Select Control Register */
  MC_CGM_0_AC5_SS_tag AC5_SS;          /* Auxiliary Clock 5 Select Status Register */
  MC_CGM_0_AC5_DC0_tag AC5_DC0;        /* Auxiliary Clock 5 Divider 0 Configuration Register */
  MC_CGM_0_AC5_DC1_tag AC5_DC1;        /* Auxiliary Clock 5 Divider 1 Configuration Register */
  uint8_t MC_CGM_0_reserved10[16];
  MC_CGM_0_AC6_SC_tag AC6_SC;          /* Auxiliary Clock 6 Select Control Register */
  MC_CGM_0_AC6_SS_tag AC6_SS;          /* Auxiliary Clock 6 Select Status Register */
  MC_CGM_0_AC6_DC0_tag AC6_DC0;        /* Auxiliary Clock 6 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved11[20];
  MC_CGM_0_AC7_SC_tag AC7_SC;          /* Auxiliary Clock 7 Select Control Register */
  MC_CGM_0_AC7_SS_tag AC7_SS;          /* Auxiliary Clock 7 Select Status Register */
  uint8_t MC_CGM_0_reserved12[4];
  MC_CGM_0_AC7_DC1_tag AC7_DC1;        /* Auxiliary Clock 7 Divider 1 Configuration Register */
  uint8_t MC_CGM_0_reserved13[16];
  MC_CGM_0_AC8_SC_tag AC8_SC;          /* Auxiliary Clock 8 Select Control Register */
  MC_CGM_0_AC8_SS_tag AC8_SS;          /* Auxiliary Clock 8 Select Status Register */
  MC_CGM_0_AC8_DC0_tag AC8_DC0;        /* Auxiliary Clock 8 Divider 0 Configuration Register */
  MC_CGM_0_AC8_DC1_tag AC8_DC1;        /* Auxiliary Clock 8 Divider 1 Configuration Register */
  uint8_t MC_CGM_0_reserved14[16];
  MC_CGM_0_AC9_SC_tag AC9_SC;          /* Auxiliary Clock 9 Select Control Register */
  MC_CGM_0_AC9_SS_tag AC9_SS;          /* Auxiliary Clock 9 Select Status Register */
  MC_CGM_0_AC9_DC0_tag AC9_DC0;        /* Auxiliary Clock 9 Divider 0 Configuration Register */
  MC_CGM_0_AC9_DC1_tag AC9_DC1;        /* Auxiliary Clock 9 Divider 1 Configuration Register */
  uint8_t MC_CGM_0_reserved15[16];
  MC_CGM_0_AC10_SC_tag AC10_SC;        /* Auxiliary Clock 10 Select Control Register */
  MC_CGM_0_AC10_SS_tag AC10_SS;        /* Auxiliary Clock 10 Select Status Register */
  MC_CGM_0_AC10_DC0_tag AC10_DC0;      /* Auxiliary Clock 10 Divider 0 Configuration Register */
  MC_CGM_0_AC10_DC1_tag AC10_DC1;      /* Auxiliary Clock 10 Divider 1 Configuration Register */
  uint8_t MC_CGM_0_reserved16[16];
  MC_CGM_0_AC11_SC_tag AC11_SC;        /* Auxiliary Clock 11 Select Control Register */
  MC_CGM_0_AC11_SS_tag AC11_SS;        /* Auxiliary Clock 11 Select Status Register */
  MC_CGM_0_AC11_DC0_tag AC11_DC0;      /* Auxiliary Clock 11 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved17[20];
  MC_CGM_0_AC12_SC_tag AC12_SC;        /* Auxiliary Clock 12 Select Control Register */
  MC_CGM_0_AC12_SS_tag AC12_SS;        /* Auxiliary Clock 12 Select Status Register */
  MC_CGM_0_AC12_DC0_tag AC12_DC0;      /* Auxiliary Clock 12 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved18[20];
  MC_CGM_0_AC13_SC_tag AC13_SC;        /* Auxiliary Clock 13 Select Control Register */
  MC_CGM_0_AC13_SS_tag AC13_SS;        /* Auxiliary Clock 13 Select Status Register */
  MC_CGM_0_AC13_DC0_tag AC13_DC0;      /* Auxiliary Clock 13 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved19[20];
  MC_CGM_0_AC14_SC_tag AC14_SC;        /* Auxiliary Clock 14 Select Control Register */
  MC_CGM_0_AC14_SS_tag AC14_SS;        /* Auxiliary Clock 14 Select Status Register */
  MC_CGM_0_AC14_DC0_tag AC14_DC0;      /* Auxiliary Clock 14 Divider 0 Configuration Register */
  uint8_t MC_CGM_0_reserved20[20];
  MC_CGM_0_AC15_SC_tag AC15_SC;        /* Auxiliary Clock 15 Select Control Register */
  MC_CGM_0_AC15_SS_tag AC15_SS;        /* Auxiliary Clock 15 Select Status Register */
  MC_CGM_0_AC15_DC0_tag AC15_DC0;      /* Auxiliary Clock 15 Divider 0 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_CGM_1 ===========================
   ============================================================================ */

typedef union MC_CGM_1_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_1_PCS_SDUR_tag;

typedef union MC_CGM_1_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_1_PCS_DIVC2_tag;

typedef union MC_CGM_1_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_1_PCS_DIVE2_tag;

typedef union MC_CGM_1_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_1_PCS_DIVS2_tag;

typedef union MC_CGM_1_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_TYPE:1;
  } B;
} MC_CGM_1_DIV_UPD_TYPE_tag;

typedef union MC_CGM_1_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_1_DIV_UPD_TRIG_tag;

typedef union MC_CGM_1_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_STAT:1;
  } B;
} MC_CGM_1_DIV_UPD_STAT_tag;

typedef union MC_CGM_1_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SWIP:1;
    vuint32_t SWTRG:3;
    vuint32_t _unused_20:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_1_SC_SS_tag;

typedef union MC_CGM_1_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_1_SC_DC0_tag;

typedef union MC_CGM_1_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_1_SC_DC1_tag;

typedef union MC_CGM_1_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_1_SC_DC2_tag;

struct MC_CGM_1_tag {
  uint8_t MC_CGM_1_reserved0[1795];
  MC_CGM_1_PCS_SDUR_tag PCS_SDUR;      /* PCS Switch Duration Register */
  uint8_t MC_CGM_1_reserved1[12];
  MC_CGM_1_PCS_DIVC2_tag PCS_DIVC2;    /* PCS Divider Change Register 2 */
  MC_CGM_1_PCS_DIVE2_tag PCS_DIVE2;    /* PCS Divider End Register 2 */
  MC_CGM_1_PCS_DIVS2_tag PCS_DIVS2;    /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_1_reserved2[184];
  MC_CGM_1_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_1_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_1_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_1_reserved3[4];
  MC_CGM_1_SC_SS_tag SC_SS;            /* System Clock Select Status Register */
  MC_CGM_1_SC_DC0_tag SC_DC0;          /* System Clock Divider 0 Configuration Register */
  MC_CGM_1_SC_DC1_tag SC_DC1;          /* System Clock Divider 1 Configuration Register */
  MC_CGM_1_SC_DC2_tag SC_DC2;          /* System Clock Divider 2 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_CGM_2 ===========================
   ============================================================================ */

typedef union MC_CGM_2_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_2_PCS_SDUR_tag;

typedef union MC_CGM_2_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_2_PCS_DIVC2_tag;

typedef union MC_CGM_2_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_2_PCS_DIVE2_tag;

typedef union MC_CGM_2_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_2_PCS_DIVS2_tag;

typedef union MC_CGM_2_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_TYPE:1;
  } B;
} MC_CGM_2_DIV_UPD_TYPE_tag;

typedef union MC_CGM_2_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_2_DIV_UPD_TRIG_tag;

typedef union MC_CGM_2_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_STAT:1;
  } B;
} MC_CGM_2_DIV_UPD_STAT_tag;

typedef union MC_CGM_2_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SWIP:1;
    vuint32_t SWTRG:3;
    vuint32_t _unused_20:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_2_SC_SS_tag;

typedef union MC_CGM_2_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_2_SC_DC0_tag;

typedef union MC_CGM_2_AC0_SC_union_tag { /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_2_AC0_SC_tag;

typedef union MC_CGM_2_AC0_SS_union_tag { /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_2_AC0_SS_tag;

typedef union MC_CGM_2_AC0_DC0_union_tag { /* Auxiliary Clock 0 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_2_AC0_DC0_tag;

typedef union MC_CGM_2_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_2_AC2_SC_tag;

typedef union MC_CGM_2_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_2_AC2_SS_tag;

typedef union MC_CGM_2_AC2_DC0_union_tag { /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_2_AC2_DC0_tag;

typedef union MC_CGM_2_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_2_AC3_SC_tag;

typedef union MC_CGM_2_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_2_AC3_SS_tag;

typedef union MC_CGM_2_AC3_DC0_union_tag { /* Auxiliary Clock 3 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_2_AC3_DC0_tag;

typedef union MC_CGM_2_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_2_AC4_SC_tag;

typedef union MC_CGM_2_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_2_AC4_SS_tag;

typedef union MC_CGM_2_AC4_DC0_union_tag { /* Auxiliary Clock 4 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_2_AC4_DC0_tag;

struct MC_CGM_2_tag {
  uint8_t MC_CGM_2_reserved0[1795];
  MC_CGM_2_PCS_SDUR_tag PCS_SDUR;      /* PCS Switch Duration Register */
  uint8_t MC_CGM_2_reserved1[12];
  MC_CGM_2_PCS_DIVC2_tag PCS_DIVC2;    /* PCS Divider Change Register 2 */
  MC_CGM_2_PCS_DIVE2_tag PCS_DIVE2;    /* PCS Divider End Register 2 */
  MC_CGM_2_PCS_DIVS2_tag PCS_DIVS2;    /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_2_reserved2[184];
  MC_CGM_2_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_2_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_2_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_2_reserved3[4];
  MC_CGM_2_SC_SS_tag SC_SS;            /* System Clock Select Status Register */
  MC_CGM_2_SC_DC0_tag SC_DC0;          /* System Clock Divider 0 Configuration Register */
  uint8_t MC_CGM_2_reserved4[20];
  MC_CGM_2_AC0_SC_tag AC0_SC;          /* Auxiliary Clock 0 Select Control Register */
  MC_CGM_2_AC0_SS_tag AC0_SS;          /* Auxiliary Clock 0 Select Status Register */
  MC_CGM_2_AC0_DC0_tag AC0_DC0;        /* Auxiliary Clock 0 Divider 0 Configuration Register */
  uint8_t MC_CGM_2_reserved5[52];
  MC_CGM_2_AC2_SC_tag AC2_SC;          /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_2_AC2_SS_tag AC2_SS;          /* Auxiliary Clock 2 Select Status Register */
  MC_CGM_2_AC2_DC0_tag AC2_DC0;        /* Auxiliary Clock 2 Divider 0 Configuration Register */
  uint8_t MC_CGM_2_reserved6[20];
  MC_CGM_2_AC3_SC_tag AC3_SC;          /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_2_AC3_SS_tag AC3_SS;          /* Auxiliary Clock 3 Select Status Register */
  MC_CGM_2_AC3_DC0_tag AC3_DC0;        /* Auxiliary Clock 3 Divider 0 Configuration Register */
  uint8_t MC_CGM_2_reserved7[20];
  MC_CGM_2_AC4_SC_tag AC4_SC;          /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_2_AC4_SS_tag AC4_SS;          /* Auxiliary Clock 4 Select Status Register */
  MC_CGM_2_AC4_DC0_tag AC4_DC0;        /* Auxiliary Clock 4 Divider 0 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_CGM_3 ===========================
   ============================================================================ */

typedef union MC_CGM_3_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_3_PCS_SDUR_tag;

typedef union MC_CGM_3_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_3_PCS_DIVC2_tag;

typedef union MC_CGM_3_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_3_PCS_DIVE2_tag;

typedef union MC_CGM_3_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_3_PCS_DIVS2_tag;

typedef union MC_CGM_3_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_TYPE:1;
  } B;
} MC_CGM_3_DIV_UPD_TYPE_tag;

typedef union MC_CGM_3_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_3_DIV_UPD_TRIG_tag;

typedef union MC_CGM_3_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t SYS_UPD_STAT:1;
  } B;
} MC_CGM_3_DIV_UPD_STAT_tag;

typedef union MC_CGM_3_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SWIP:1;
    vuint32_t SWTRG:3;
    vuint32_t _unused_20:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_3_SC_SS_tag;

typedef union MC_CGM_3_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_3_SC_DC0_tag;

typedef union MC_CGM_3_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_3_SC_DC1_tag;

struct MC_CGM_3_tag {
  uint8_t MC_CGM_3_reserved0[1795];
  MC_CGM_3_PCS_SDUR_tag PCS_SDUR;      /* PCS Switch Duration Register */
  uint8_t MC_CGM_3_reserved1[12];
  MC_CGM_3_PCS_DIVC2_tag PCS_DIVC2;    /* PCS Divider Change Register 2 */
  MC_CGM_3_PCS_DIVE2_tag PCS_DIVE2;    /* PCS Divider End Register 2 */
  MC_CGM_3_PCS_DIVS2_tag PCS_DIVS2;    /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_3_reserved2[184];
  MC_CGM_3_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_3_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_3_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_3_reserved3[4];
  MC_CGM_3_SC_SS_tag SC_SS;            /* System Clock Select Status Register */
  MC_CGM_3_SC_DC0_tag SC_DC0;          /* System Clock Divider 0 Configuration Register */
  MC_CGM_3_SC_DC1_tag SC_DC1;          /* System Clock Divider 1 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_SYSCLK:4;
    vuint32_t S_FIRC:1;
    vuint32_t S_FXOSC:1;
    vuint32_t S_ARMPLL:1;
    vuint32_t S_PERIPHPLL:1;
    vuint32_t S_ENETPLL:1;
    vuint32_t S_DDRPLL:1;
    vuint32_t S_VIDEOPLL:1;            /* Video PLL status */
    vuint32_t _unused_11:2;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:6;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:2;
    vuint32_t _unused_26:1;
    vuint32_t S_MTRANS:1;
    vuint32_t S_CURRENT_MODE:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:16;
    vuint32_t _unused_16:12;
    vuint32_t TARGET_MODE:4;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t RESET_FUNC:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:7;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_16:16;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t I_MTC:1;
    vuint32_t _unused_1:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_ICONF:1;
    vuint32_t _unused_4:1;
    vuint32_t I_ICONF_CC:1;
    vuint32_t I_ICONF_SCC:1;
    vuint32_t _unused_7:25;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t M_MTC:1;
    vuint32_t _unused_1:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_ICONF:1;
    vuint32_t _unused_4:1;
    vuint32_t M_ICONF_CC:1;
    vuint32_t M_ICONF_SCC:1;
    vuint32_t _unused_7:25;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t S_NMA:1;
    vuint32_t S_DMA:1;
    vuint32_t _unused_3:1;
    vuint32_t S_MTI:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:26;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t _unused_7:3;
    vuint32_t SYSCLK_SW:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t FIRC_SC:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t CDP_PRPH_0_255:1;
    vuint32_t _unused_16:1;
    vuint32_t PCS_PROG:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:4;
    vuint32_t PREVIOUS_MODE:4;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t FIRCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t ARMPLLON:1;
    vuint32_t PERIPHPLLON:1;
    vuint32_t ENETPLLON:1;
    vuint32_t DDRPLLON:1;
    vuint32_t VIDEOPLLON:1;
    vuint32_t _unused_11:3;
    vuint32_t _unused_14:6;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t FIRCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t ARMPLLON:1;
    vuint32_t PERIPHPLLON:1;
    vuint32_t ENETPLLON:1;
    vuint32_t DDRPLLON:1;
    vuint32_t VIDEOPLLON:1;
    vuint32_t _unused_11:3;
    vuint32_t _unused_14:6;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t FIRCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t ARMPLLON:1;
    vuint32_t PERIPHPLLON:1;
    vuint32_t ENETPLLON:1;
    vuint32_t DDRPLLON:1;
    vuint32_t VIDEOPLLON:1;
    vuint32_t _unused_11:3;
    vuint32_t _unused_14:6;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;
    vuint32_t S_DEC200_ENC:1;
    vuint32_t S_2D_ACE:1;
    vuint32_t _unused_9:7;
    vuint32_t S_CSI0:1;
    vuint32_t S_DMACHMUX0:1;
    vuint32_t S_ENET:1;
    vuint32_t _unused_19:1;
    vuint32_t S_FLEXRAY:1;
    vuint32_t _unused_21:1;
    vuint32_t S_MMDC0:1;
    vuint32_t _unused_23:3;
    vuint32_t S_PIT0:1;
    vuint32_t _unused_27:5;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:13;
    vuint32_t S_SARADC0:1;
    vuint32_t _unused_14:1;
    vuint32_t S_FlexTIMER0:1;
    vuint32_t _unused_16:1;
    vuint32_t S_IIC0:1;
    vuint32_t _unused_18:1;
    vuint32_t S_LINFLEX0:1;
    vuint32_t _unused_20:1;
    vuint32_t S_CANFD0:1;
    vuint32_t _unused_22:1;
    vuint32_t S_SPI0:1;
    vuint32_t _unused_24:1;
    vuint32_t S_SPI2:1;
    vuint32_t _unused_26:1;
    vuint32_t S_CRC0:1;
    vuint32_t _unused_28:1;
    vuint32_t S_SDHC:1;
    vuint32_t _unused_30:2;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t S_VIU0:1;
    vuint32_t _unused_5:3;
    vuint32_t S_HPSMI:1;
    vuint32_t _unused_9:11;
    vuint32_t S_SIPI:1;
    vuint32_t _unused_21:3;
    vuint32_t S_LFAST:1;
    vuint32_t _unused_25:7;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t S_CSI1:1;
    vuint32_t S_DMACHMUX1:1;
    vuint32_t S_MMDC1:1;
    vuint32_t _unused_3:3;
    vuint32_t S_QUADSPI0:1;
    vuint32_t _unused_7:3;
    vuint32_t S_PIT1:1;
    vuint32_t _unused_11:9;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:1;
    vuint32_t S_FlexTIMER1:1;
    vuint32_t _unused_23:1;
    vuint32_t S_IIC1:1;
    vuint32_t _unused_25:1;
    vuint32_t S_IIC2:1;
    vuint32_t _unused_27:1;
    vuint32_t S_LINFLEX1:1;
    vuint32_t _unused_29:1;
    vuint32_t S_CANFD1:1;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status Register 6 */
  vuint32_t R;
  struct {
    vuint32_t S_SPI1:1;
    vuint32_t _unused_1:1;
    vuint32_t S_SPI3:1;
    vuint32_t S_IPL:1;
    vuint32_t _unused_4:8;
    vuint32_t S_CRC1:1;
    vuint32_t _unused_13:1;
    vuint32_t S_TSENS:1;
    vuint32_t _unused_15:1;
    vuint32_t S_VIU1:1;
    vuint32_t _unused_17:3;
    vuint32_t S_JPEGDEC:1;
    vuint32_t _unused_21:3;
    vuint32_t S_H264DEC:1;
    vuint32_t _unused_25:3;
    vuint32_t S_H264ENC:1;
    vuint32_t _unused_29:3;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_PS7_union_tag {    /* Peripheral Status Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t MTR_IPS_Bridge:1;
    vuint32_t _unused_13:19;
  } B;
} MC_ME_PS7_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RESET:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:24;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_PCTL39_union_tag { /* DEC200 Encoder Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL39_tag;

typedef union MC_ME_PCTL40_union_tag { /* 2D-ACE Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL40_tag;

typedef union MC_ME_PCTL50_union_tag { /* ENET Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL50_tag;

typedef union MC_ME_PCTL49_union_tag { /* DMACHMUX0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL49_tag;

typedef union MC_ME_PCTL48_union_tag { /* CSI0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL48_tag;

typedef union MC_ME_PCTL54_union_tag { /* MMDC0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL54_tag;

typedef union MC_ME_PCTL52_union_tag { /* FlexRay Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL52_tag;

typedef union MC_ME_PCTL58_union_tag { /* PIT0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL58_tag;

typedef union MC_ME_PCTL79_union_tag { /* FlexTIMER0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL79_tag;

typedef union MC_ME_PCTL77_union_tag { /* SARADC0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL77_tag;

typedef union MC_ME_PCTL83_union_tag { /* LINFLEX0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL83_tag;

typedef union MC_ME_PCTL81_union_tag { /* IIC0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL81_tag;

typedef union MC_ME_PCTL87_union_tag { /* SPI0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL87_tag;

typedef union MC_ME_PCTL85_union_tag { /* CANFD0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL85_tag;

typedef union MC_ME_PCTL91_union_tag { /* CRC0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL91_tag;

typedef union MC_ME_PCTL89_union_tag { /* SPI2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL89_tag;

typedef union MC_ME_PCTL93_union_tag { /* SDHC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL93_tag;

typedef union MC_ME_PCTL100_union_tag { /* VIU0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL100_tag;

typedef union MC_ME_PCTL104_union_tag { /* HPSMI Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL104_tag;

typedef union MC_ME_PCTL116_union_tag { /* SIPI Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL116_tag;

typedef union MC_ME_PCTL120_union_tag { /* LFAST Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL120_tag;

typedef union MC_ME_PCTL162_union_tag { /* MMDC1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL162_tag;

typedef union MC_ME_PCTL161_union_tag { /* DMACHMUX1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL161_tag;

typedef union MC_ME_PCTL160_union_tag { /* CSI1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL160_tag;

typedef union MC_ME_PCTL166_union_tag { /* QUADSPI0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL166_tag;

typedef union MC_ME_PCTL170_union_tag { /* PIT1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL170_tag;

typedef union MC_ME_PCTL182_union_tag { /* FlexTIMER1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL182_tag;

typedef union MC_ME_PCTL186_union_tag { /* IIC2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL186_tag;

typedef union MC_ME_PCTL184_union_tag { /* IIC1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL184_tag;

typedef union MC_ME_PCTL190_union_tag { /* CANFD1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL190_tag;

typedef union MC_ME_PCTL188_union_tag { /* LINFLEX1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL188_tag;

typedef union MC_ME_PCTL194_union_tag { /* SPI3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL194_tag;

typedef union MC_ME_PCTL192_union_tag { /* SPI1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL192_tag;

typedef union MC_ME_PCTL206_union_tag { /* TSENS Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL206_tag;

typedef union MC_ME_PCTL204_union_tag { /* CRC1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL204_tag;

typedef union MC_ME_PCTL208_union_tag { /* VIU1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL208_tag;

typedef union MC_ME_PCTL212_union_tag { /* JPEG Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL212_tag;

typedef union MC_ME_PCTL216_union_tag { /* H264_DEC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL216_tag;

typedef union MC_ME_PCTL220_union_tag { /* H264_ENC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL220_tag;

typedef union MC_ME_PCTL236_union_tag { /* MBIST Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t _unused_3:3;
    vuint8_t _unused_6:1;
    vuint8_t _unused_7:1;
  } B;
} MC_ME_PCTL236_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CM4:1;
    vuint32_t S_CA53_CORE0:1;
    vuint32_t S_CA53_CORE1:1;
    vuint32_t S_CA53_CORE2:1;
    vuint32_t S_CA53_CORE3:1;
    vuint32_t _unused_5:27;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL1_union_tag {  /* Cortex-A53_CORE0 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:1;
    vuint16_t _unused_1:1;
    vuint16_t _unused_2:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:8;
  } B;
} MC_ME_CCTL1_tag;

typedef union MC_ME_CCTL0_union_tag {  /* Cortex-M4 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:1;
    vuint16_t _unused_1:1;
    vuint16_t _unused_2:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:8;
  } B;
} MC_ME_CCTL0_tag;

typedef union MC_ME_CCTL3_union_tag {  /* Cortex-A53_CORE2 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:1;
    vuint16_t _unused_1:1;
    vuint16_t _unused_2:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:8;
  } B;
} MC_ME_CCTL3_tag;

typedef union MC_ME_CCTL2_union_tag {  /* Cortex-A53_CORE1 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:1;
    vuint16_t _unused_1:1;
    vuint16_t _unused_2:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:8;
  } B;
} MC_ME_CCTL2_tag;

typedef union MC_ME_CCTL4_union_tag {  /* Cortex-A53_CORE3 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:1;
    vuint16_t _unused_1:1;
    vuint16_t _unused_2:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:8;
  } B;
} MC_ME_CCTL4_tag;

typedef union MC_ME_CADDR0_union_tag { /* Cortex-M4 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t RMC:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR0_tag;

typedef union MC_ME_CADDR1_union_tag { /* Cortex-A53_CORE0 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_EN:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR2_union_tag { /* Cortex-A53_CORE1 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_EN:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR2_tag;

typedef union MC_ME_CADDR3_union_tag { /* Cortex-A53_CORE2 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_EN:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR3_tag;

typedef union MC_ME_CADDR4_union_tag { /* Cortex-A53_CORE3 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_EN:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR4_tag;

typedef union MC_ME_DRUN_SEC_CC_I_union_tag { /* DRUN Secondary Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t SYSCLK1:4;
    vuint32_t SYSCLK2:4;
    vuint32_t SYSCLK3:4;
    vuint32_t _unused_16:4;
    vuint32_t PWRLVL1:3;
    vuint32_t _unused_23:1;
    vuint32_t PWRLVL2:3;
    vuint32_t _unused_27:1;
    vuint32_t PWRLVL3:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_DRUN_SEC_CC_I_tag;

typedef union MC_ME_RUN0_SEC_CC_I_union_tag { /* RUN0 Secondary Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t SYSCLK1:4;
    vuint32_t SYSCLK2:4;
    vuint32_t SYSCLK3:4;
    vuint32_t _unused_16:4;
    vuint32_t PWRLVL1:3;
    vuint32_t _unused_23:1;
    vuint32_t PWRLVL2:3;
    vuint32_t _unused_27:1;
    vuint32_t PWRLVL3:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN0_SEC_CC_I_tag;

typedef union MC_ME_RUN1_SEC_CC_I_union_tag { /* RUN1 Secondary Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t SYSCLK1:4;
    vuint32_t SYSCLK2:4;
    vuint32_t SYSCLK3:4;
    vuint32_t _unused_16:4;
    vuint32_t PWRLVL1:3;
    vuint32_t _unused_23:1;
    vuint32_t PWRLVL2:3;
    vuint32_t _unused_27:1;
    vuint32_t PWRLVL3:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN1_SEC_CC_I_tag;

typedef union MC_ME_RUN2_SEC_CC_I_union_tag { /* RUN2 Secondary Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t SYSCLK1:4;
    vuint32_t SYSCLK2:4;
    vuint32_t SYSCLK3:4;
    vuint32_t _unused_16:4;
    vuint32_t PWRLVL1:3;
    vuint32_t _unused_23:1;
    vuint32_t PWRLVL2:3;
    vuint32_t _unused_27:1;
    vuint32_t PWRLVL3:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN2_SEC_CC_I_tag;

typedef union MC_ME_RUN3_SEC_CC_I_union_tag { /* RUN3 Secondary Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t SYSCLK1:4;
    vuint32_t SYSCLK2:4;
    vuint32_t SYSCLK3:4;
    vuint32_t _unused_16:4;
    vuint32_t PWRLVL1:3;
    vuint32_t _unused_23:1;
    vuint32_t PWRLVL2:3;
    vuint32_t _unused_27:1;
    vuint32_t PWRLVL3:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN3_SEC_CC_I_tag;

typedef union MC_ME_SEC_CS_union_tag { /* Secondary Clock Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t S_SYSCLK1:4;
    vuint32_t S_SYSCLK2:4;
    vuint32_t S_SYSCLK3:4;
    vuint32_t _unused_16:16;
  } B;
} MC_ME_SEC_CS_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  uint8_t MC_ME_reserved1[8];
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN Mode Configuration Register */
  uint8_t MC_ME_reserved2[36];
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  uint8_t MC_ME_reserved3[4];
  MC_ME_PS5_tag PS5;                   /* Peripheral Status Register 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status Register 6 */
  MC_ME_PS7_tag PS7;                   /* Peripheral Status Register 7 */
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  uint8_t MC_ME_reserved4[68];
  MC_ME_PCTL39_tag PCTL39;             /* DEC200 Encoder Peripheral Control Register */
  uint8_t MC_ME_reserved5[6];
  MC_ME_PCTL40_tag PCTL40;             /* 2D-ACE Peripheral Control Register */
  uint8_t MC_ME_reserved6[5];
  MC_ME_PCTL50_tag PCTL50;             /* ENET Peripheral Control Register */
  MC_ME_PCTL49_tag PCTL49;             /* DMACHMUX0 Peripheral Control Register */
  MC_ME_PCTL48_tag PCTL48;             /* CSI0 Peripheral Control Register */
  uint8_t MC_ME_reserved7[1];
  MC_ME_PCTL54_tag PCTL54;             /* MMDC0 Peripheral Control Register */
  uint8_t MC_ME_reserved8[1];
  MC_ME_PCTL52_tag PCTL52;             /* FlexRay Peripheral Control Register */
  uint8_t MC_ME_reserved9[1];
  MC_ME_PCTL58_tag PCTL58;             /* PIT0 Peripheral Control Register */
  uint8_t MC_ME_reserved10[18];
  MC_ME_PCTL79_tag PCTL79;             /* FlexTIMER0 Peripheral Control Register */
  uint8_t MC_ME_reserved11[1];
  MC_ME_PCTL77_tag PCTL77;             /* SARADC0 Peripheral Control Register */
  uint8_t MC_ME_reserved12[1];
  MC_ME_PCTL83_tag PCTL83;             /* LINFLEX0 Peripheral Control Register */
  uint8_t MC_ME_reserved13[1];
  MC_ME_PCTL81_tag PCTL81;             /* IIC0 Peripheral Control Register */
  uint8_t MC_ME_reserved14[1];
  MC_ME_PCTL87_tag PCTL87;             /* SPI0 Peripheral Control Register */
  uint8_t MC_ME_reserved15[1];
  MC_ME_PCTL85_tag PCTL85;             /* CANFD0 Peripheral Control Register */
  uint8_t MC_ME_reserved16[1];
  MC_ME_PCTL91_tag PCTL91;             /* CRC0 Peripheral Control Register */
  uint8_t MC_ME_reserved17[1];
  MC_ME_PCTL89_tag PCTL89;             /* SPI2 Peripheral Control Register */
  uint8_t MC_ME_reserved18[3];
  MC_ME_PCTL93_tag PCTL93;             /* SDHC Peripheral Control Register */
  uint8_t MC_ME_reserved19[8];
  MC_ME_PCTL100_tag PCTL100;           /* VIU0 Peripheral Control Register */
  uint8_t MC_ME_reserved20[3];
  MC_ME_PCTL104_tag PCTL104;           /* HPSMI Peripheral Control Register */
  uint8_t MC_ME_reserved21[11];
  MC_ME_PCTL116_tag PCTL116;           /* SIPI Peripheral Control Register */
  uint8_t MC_ME_reserved22[3];
  MC_ME_PCTL120_tag PCTL120;           /* LFAST Peripheral Control Register */
  uint8_t MC_ME_reserved23[37];
  MC_ME_PCTL162_tag PCTL162;           /* MMDC1 Peripheral Control Register */
  MC_ME_PCTL161_tag PCTL161;           /* DMACHMUX1 Peripheral Control Register */
  MC_ME_PCTL160_tag PCTL160;           /* CSI1 Peripheral Control Register */
  uint8_t MC_ME_reserved24[1];
  MC_ME_PCTL166_tag PCTL166;           /* QUADSPI0 Peripheral Control Register */
  uint8_t MC_ME_reserved25[3];
  MC_ME_PCTL170_tag PCTL170;           /* PIT1 Peripheral Control Register */
  uint8_t MC_ME_reserved26[11];
  MC_ME_PCTL182_tag PCTL182;           /* FlexTIMER1 Peripheral Control Register */
  uint8_t MC_ME_reserved27[3];
  MC_ME_PCTL186_tag PCTL186;           /* IIC2 Peripheral Control Register */
  uint8_t MC_ME_reserved28[1];
  MC_ME_PCTL184_tag PCTL184;           /* IIC1 Peripheral Control Register */
  uint8_t MC_ME_reserved29[1];
  MC_ME_PCTL190_tag PCTL190;           /* CANFD1 Peripheral Control Register */
  uint8_t MC_ME_reserved30[1];
  MC_ME_PCTL188_tag PCTL188;           /* LINFLEX1 Peripheral Control Register */
  uint8_t MC_ME_reserved31[1];
  MC_ME_PCTL194_tag PCTL194;           /* SPI3 Peripheral Control Register */
  uint8_t MC_ME_reserved32[1];
  MC_ME_PCTL192_tag PCTL192;           /* SPI1 Peripheral Control Register */
  uint8_t MC_ME_reserved33[9];
  MC_ME_PCTL206_tag PCTL206;           /* TSENS Peripheral Control Register */
  uint8_t MC_ME_reserved34[1];
  MC_ME_PCTL204_tag PCTL204;           /* CRC1 Peripheral Control Register */
  uint8_t MC_ME_reserved35[3];
  MC_ME_PCTL208_tag PCTL208;           /* VIU1 Peripheral Control Register */
  uint8_t MC_ME_reserved36[3];
  MC_ME_PCTL212_tag PCTL212;           /* JPEG Peripheral Control Register */
  uint8_t MC_ME_reserved37[3];
  MC_ME_PCTL216_tag PCTL216;           /* H264_DEC Peripheral Control Register */
  uint8_t MC_ME_reserved38[3];
  MC_ME_PCTL220_tag PCTL220;           /* H264_ENC Peripheral Control Register */
  uint8_t MC_ME_reserved39[15];
  MC_ME_PCTL236_tag PCTL236;           /* MBIST Peripheral Control Register */
  uint8_t MC_ME_reserved40[16];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  MC_ME_CCTL1_tag CCTL1;               /* Cortex-A53_CORE0 Control Register */
  MC_ME_CCTL0_tag CCTL0;               /* Cortex-M4 Core Control Register */
  MC_ME_CCTL3_tag CCTL3;               /* Cortex-A53_CORE2 Control Register */
  MC_ME_CCTL2_tag CCTL2;               /* Cortex-A53_CORE1 Control Register */
  uint8_t MC_ME_reserved41[2];
  MC_ME_CCTL4_tag CCTL4;               /* Cortex-A53_CORE3 Control Register */
  uint8_t MC_ME_reserved42[16];
  MC_ME_CADDR0_tag CADDR0;             /* Cortex-M4 Core Address Register */
  MC_ME_CADDR1_tag CADDR1;             /* Cortex-A53_CORE0 Core Address Register */
  MC_ME_CADDR2_tag CADDR2;             /* Cortex-A53_CORE1 Core Address Register */
  MC_ME_CADDR3_tag CADDR3;             /* Cortex-A53_CORE2 Core Address Register */
  MC_ME_CADDR4_tag CADDR4;             /* Cortex-A53_CORE3 Core Address Register */
  uint8_t MC_ME_reserved43[108];
  MC_ME_DRUN_SEC_CC_I_tag DRUN_SEC_CC_I; /* DRUN Secondary Clock Configuration Register */
  uint8_t MC_ME_reserved44[12];
  MC_ME_RUN0_SEC_CC_I_tag RUN0_SEC_CC_I; /* RUN0 Secondary Clock Configuration Register */
  uint8_t MC_ME_reserved45[12];
  MC_ME_RUN1_SEC_CC_I_tag RUN1_SEC_CC_I; /* RUN1 Secondary Clock Configuration Register */
  uint8_t MC_ME_reserved46[12];
  MC_ME_RUN2_SEC_CC_I_tag RUN2_SEC_CC_I; /* RUN2 Secondary Clock Configuration Register */
  uint8_t MC_ME_reserved47[12];
  MC_ME_RUN3_SEC_CC_I_tag RUN3_SEC_CC_I; /* RUN3 Secondary Clock Configuration Register */
  uint8_t MC_ME_reserved48[44];
  MC_ME_SEC_CS_tag SEC_CS;             /* Secondary Clock Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t F_POR:1;
    vuint32_t _unused_1:2;
    vuint32_t F_SOFT_DEST:1;
    vuint32_t F_FFRR:1;
    vuint32_t F_SUF:1;
    vuint32_t F_DDR_HNDSHK_TO:1;
    vuint32_t _unused_7:1;
    vuint32_t F_EFR:1;
    vuint32_t _unused_9:3;
    vuint32_t F_DBGRST:1;
    vuint32_t _unused_13:11;
    vuint32_t _unused_24:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t F_HVD_CORE:1;
    vuint32_t F_LVD_CORE:1;
    vuint32_t F_LVD_33_PMC:1;
    vuint32_t F_HVD_18:1;
    vuint32_t _unused_31:1;
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_FES_union_tag {   /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t F_EXT_RST:1;
    vuint32_t _unused_1:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t _unused_4:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t _unused_7:3;
    vuint32_t F_JTAG_OR_DBG:1;
    vuint32_t _unused_11:4;
    vuint32_t F_SWT4:1;
    vuint32_t _unused_16:16;
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t D_JTAG_OR_DBG:1;
    vuint32_t _unused_11:4;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:16;
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FBRE_union_tag {  /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t BE_EXT_RST:1;
    vuint32_t _unused_1:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t _unused_4:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t _unused_7:3;
    vuint32_t BE_JTAG_OR_DBG:1;
    vuint32_t _unused_11:4;
    vuint32_t BE_SWT4:1;
    vuint32_t _unused_16:16;
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t SS_EXT_RST:1;
    vuint32_t _unused_1:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t _unused_4:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t _unused_7:3;
    vuint32_t SS_JTAG_OR_DBG:1;
    vuint32_t _unused_11:4;
    vuint32_t SS_SWT4:1;
    vuint32_t _unused_16:16;
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_DDR_HE_union_tag { /* DDR Handshake Enable Register */
  vuint32_t R;
  struct {
    vuint32_t HANDSHK_EN:1;
    vuint32_t _unused_1:15;
    vuint32_t HNDSHK_TO_VAL:16;
  } B;
} MC_RGM_DDR_HE_tag;

typedef union MC_RGM_DDR_HS_union_tag { /* DDR Handshake Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t HNDSHK_DONE:1;
    vuint32_t _unused_2:30;
  } B;
} MC_RGM_DDR_HS_tag;

typedef union MC_RGM_FRHE_union_tag {  /* Functional Reset Handshake Enable */
  vuint32_t R;
  struct {
    vuint32_t HE_EXT_RST:1;
    vuint32_t _unused_1:1;
    vuint32_t HE_ST_DONE:1;
    vuint32_t HE_SOFT_FUNC:1;
    vuint32_t _unused_4:1;
    vuint32_t HE_FCCU_HARD:1;
    vuint32_t HE_FCCU_SOFT:1;
    vuint32_t _unused_7:3;
    vuint32_t HE_JTAG_OR_DBG:1;
    vuint32_t _unused_11:4;
    vuint32_t HE_SWT4:1;
    vuint32_t _unused_16:16;
  } B;
} MC_RGM_FRHE_tag;

typedef union MC_RGM_FREC_union_tag {  /* Functional Reset Escalation Counter */
  vuint32_t R;
  struct {
    vuint32_t FREC:4;
    vuint32_t _unused_4:28;
  } B;
} MC_RGM_FREC_tag;

typedef union MC_RGM_FRET_union_tag {  /* 'Functional' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t FRET:4;
    vuint8_t _unused_4:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* 'Destructive' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t DRET:4;
    vuint8_t _unused_4:4;
  } B;
} MC_RGM_DRET_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* 'Destructive' Event Status Register */
  uint8_t MC_RGM_reserved0[764];
  MC_RGM_FES_tag FES;                  /* 'Functional' Event Status Register */
  uint8_t MC_RGM_reserved1[12];
  MC_RGM_FERD_tag FERD;                /* 'Functional' Event Reset Disable Register */
  uint8_t MC_RGM_reserved2[28];
  MC_RGM_FBRE_tag FBRE;                /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved3[12];
  MC_RGM_FESS_tag FESS;                /* Functional' Event Short Sequence Register */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_DDR_HE_tag DDR_HE;            /* DDR Handshake Enable Register */
  MC_RGM_DDR_HS_tag DDR_HS;            /* DDR Handshake Status Register */
  MC_RGM_FRHE_tag FRHE;                /* Functional Reset Handshake Enable */
  uint8_t MC_RGM_reserved5[676];
  MC_RGM_FREC_tag FREC;                /* Functional Reset Escalation Counter */
  uint8_t MC_RGM_reserved6[3];
  MC_RGM_FRET_tag FRET;                /* 'Functional' Reset Escalation Threshold Register */
  uint8_t MC_RGM_reserved7[3];
  MC_RGM_DRET_tag DRET;                /* 'Destructive' Reset Escalation Threshold Register */
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

typedef union MEMU_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:15;
    vuint32_t SWR:1;
    vuint32_t _unused_16:16;
  } B;
} MEMU_CTRL_tag;

typedef union MEMU_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t _unused_5:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_13:3;
    vuint32_t PR_EBO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CE:1;
    vuint32_t _unused_21:11;
  } B;
} MEMU_ERR_FLAG_tag;

typedef union MEMU_DEBUG_union_tag {   /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t _unused_5:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_13:3;
    vuint32_t FR_PR_EBO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CE:1;
    vuint32_t _unused_21:11;
  } B;
} MEMU_DEBUG_tag;

typedef union MEMU_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t BAD_BIT:8;
    vuint32_t _unused_8:23;
    vuint32_t VLD:1;
  } B;
} MEMU_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_PERIPH_RAM_CERR_struct_tag {
  MEMU_PERIPH_RAM_CERR_STS_tag STS;    /* Peripheral RAM correctable error reporting table status register */
  MEMU_PERIPH_RAM_CERR_ADDR_tag ADDR;  /* Peripheral RAM correctable error reporting table address register */
} MEMU_PERIPH_RAM_CERR_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t VLD:1;
  } B;
} MEMU_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_PERIPH_RAM_OFLW0_tag;

struct MEMU_tag {
  MEMU_CTRL_tag CTRL;                  /* Control register */
  MEMU_ERR_FLAG_tag ERR_FLAG;          /* Error flag register */
  uint8_t MEMU_reserved0[4];
  MEMU_DEBUG_tag DEBUG;                /* Debug register */
  uint8_t MEMU_reserved1[1552];
  MEMU_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
};


/* ============================================================================
   =============================== Module: MEW_AXI ============================
   ============================================================================ */

typedef union MEW_AXI_ECC_GLBL_CTRL_union_tag { /* AXI ECC Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t RD_EN:1;
    vuint32_t _unused_1:2;
    vuint32_t RD_EDCEN:1;
    vuint32_t _unused_4:12;
    vuint32_t WR_EN:1;
    vuint32_t _unused_17:2;
    vuint32_t WR_EDCEN:1;
    vuint32_t _unused_20:12;
  } B;
} MEW_AXI_ECC_GLBL_CTRL_tag;

typedef union MEW_AXI_ECC_MX_EPA_union_tag { /* AXI ECC Maximum ECC protected address register */
  vuint32_t R;
  struct {
    vuint32_t MX_EPA:32;
  } B;
} MEW_AXI_ECC_MX_EPA_tag;

typedef union MEW_AXI_ECC_MN_EPA_union_tag { /* AXI ECC Minimum ECC protected address register */
  vuint32_t R;
  struct {
    vuint32_t MN_EPA:32;
  } B;
} MEW_AXI_ECC_MN_EPA_tag;

typedef union MEW_AXI_ECC_LK_PTN_union_tag { /* AXI ECC Lock Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t LK_PTN:32;
  } B;
} MEW_AXI_ECC_LK_PTN_tag;

typedef union MEW_AXI_ECC_ULK_PTN_union_tag { /* AXI ECC Unlock Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t ULK_PTN:32;
  } B;
} MEW_AXI_ECC_ULK_PTN_tag;

typedef union MEW_AXI_ECC_EERAR_union_tag { /* ECC Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t EERA:32;
  } B;
} MEW_AXI_ECC_EERAR_tag;

typedef union MEW_AXI_ECC_EERDSR_union_tag { /* AXI ECC Error Report Data and Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t EERD:8;
    vuint32_t EECC:8;                  /* This register gives ECC bits which caused ECC Error. */
    vuint32_t EERS:8;
    vuint32_t _unused_24:8;
  } B;
} MEW_AXI_ECC_EERDSR_tag;

typedef union MEW_AXI_ECC_ERR_IE_union_tag { /* AXI ECC error interrupt enable */
  vuint32_t R;
  struct {
    vuint32_t NCE_IE1:1;               /* Non-Correctable Error logging and Interrupt Enable for ECC module1 */
    vuint32_t NCE_IE2:1;               /* Non-Correctable Error logging and Interrupt Enable for ECC module2 */
    vuint32_t NCE_IE3:1;               /* Non-Correctable Error logging and Interrupt Enable for ECC module3 */
    vuint32_t NCE_IE4:1;               /* Non-Correctable Error logging and Interrupt Enable for ECC module4 */
    vuint32_t _unused_4:12;
    vuint32_t CE_IE1:1;                /* Correctable Error logging and Interrupt Enable for ECC module1 */
    vuint32_t CE_IE2:1;                /* Correctable Error logging and Interrupt Enable for ECC module2 */
    vuint32_t CE_IE3:1;                /* Correctable Error logging and Interrupt Enable for ECC module3 */
    vuint32_t CE_IE4:1;                /* Correctable Error logging and Interrupt Enable for ECC module4 */
    vuint32_t _unused_20:12;
  } B;
} MEW_AXI_ECC_ERR_IE_tag;

typedef union MEW_AXI_ECC_ERR_IN_STCLR_union_tag { /* AXI ECC error Interupt status and clear register */
  vuint32_t R;
  struct {
    vuint32_t NCE_IF1:1;               /* Non-Corrected Error Interrupt Flag for ECC module1 */
    vuint32_t NCE_IF2:1;               /* Non-Corrected Error Interrupt Flag for ECC module2 */
    vuint32_t NCE_IF3:1;               /* Non-Corrected Error Interrupt Flag for ECC module3 */
    vuint32_t NCE_IF4:1;               /* Non-Corrected Error Interrupt Flag for ECC module4 */
    vuint32_t _unused_4:12;
    vuint32_t CE_IF1:1;                /* Corrected Error Interrupt Flag for ECC module1 */
    vuint32_t CE_IF2:1;                /* Corrected Error Interrupt Flag for ECC module2 */
    vuint32_t CE_IF3:1;                /* Corrected Error Interrupt Flag for ECC module3 */
    vuint32_t CE_IF4:1;                /* Corrected Error Interrupt Flag for ECC module4 */
    vuint32_t _unused_20:12;
  } B;
} MEW_AXI_ECC_ERR_IN_STCLR_tag;

typedef union MEW_AXI_EDC_ERR_IE_union_tag { /* AXI EDC Error interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t EDC_EIE1:1;              /* EDC Encoder Error Interrupt Enable */
    vuint32_t EDC_EIE2:1;              /* EDC Encoder Error Interrupt Enable */
    vuint32_t EDC_EIE3:1;              /* EDC Encoder Error Interrupt Enable */
    vuint32_t EDC_EIE4:1;              /* EDC Encoder Error Interrupt Enable */
    vuint32_t _unused_4:12;
    vuint32_t EDC_DIE1:1;              /* EDC Decoder Error Interrupt Enable */
    vuint32_t EDC_DIE2:1;              /* EDC Decoder Error Interrupt Enable */
    vuint32_t EDC_DIE3:1;              /* EDC Decoder Error Interrupt Enable */
    vuint32_t EDC_DIE4:1;              /* EDC Decoder Error Interrupt Enable */
    vuint32_t _unused_20:12;
  } B;
} MEW_AXI_EDC_ERR_IE_tag;

typedef union MEW_AXI_EDC_ERR_IN_STCLR_union_tag { /* AXI EDC Error Interrupt Status and Clear register */
  vuint32_t R;
  struct {
    vuint32_t EDC_ENC1:1;
    vuint32_t EDC_ENC2:1;
    vuint32_t EDC_ENC3:1;
    vuint32_t EDC_ENC4:1;
    vuint32_t _unused_4:12;
    vuint32_t EDC_DEC1:1;
    vuint32_t EDC_DEC2:1;
    vuint32_t EDC_DEC3:1;
    vuint32_t EDC_DEC4:1;
    vuint32_t _unused_20:12;
  } B;
} MEW_AXI_EDC_ERR_IN_STCLR_tag;

typedef union MEW_AXI_ECC_SHD_STAT_CTRL_union_tag { /* Shadow Control, RW path Status and Status Clear Register */
  vuint32_t R;
  struct {
    vuint32_t STAT_CLR:1;              /* All Stat Clear */
    vuint32_t COUNT_CLR:1;             /* All-Counter Clear */
    vuint32_t _unused_2:6;
    vuint32_t RD_TX_FULL:1;            /* Read Region Tx-Table Full */
    vuint32_t WR_TX_FULL:1;            /* Write Region Tx-Table Full */
    vuint32_t WR_RES_FULL:1;           /* Write Region Resp-Table Full */
    vuint32_t _unused_11:5;
    vuint32_t RD_TX_EMP:1;             /* Read Region Tx-Table Empty */
    vuint32_t WR_TX_EMP:1;             /* Write Region Tx-Table Empty */
    vuint32_t WR_RES_EMP:1;            /* Write Region Resp-Table Empty */
    vuint32_t _unused_19:5;
    vuint32_t SHD_RGN_SLT:1;           /* Shadow-Region-Select */
    vuint32_t _unused_25:7;
  } B;
} MEW_AXI_ECC_SHD_STAT_CTRL_tag;

typedef union MEW_AXI_ECC_CBL_UNCBL_BIT_EC_union_tag { /* Correctable and un-correctable bit error counter */
  vuint32_t R;
  struct {
    vuint32_t CLB_BIT_EC:15;           /* Correctable bit error count */
    vuint32_t CBL_BIT_OF:1;            /* Correctable Bit Over-Flow */
    vuint32_t UCBL_BIT_EC:15;          /* Un-correctable bit error count */
    vuint32_t UCBL_BIT_OF:1;           /* Un-correctable Bit Over-Flow */
  } B;
} MEW_AXI_ECC_CBL_UNCBL_BIT_EC_tag;

typedef union MEW_AXI_ECC_CBL_UCBL_BEAT_EC_union_tag { /* Correctable and un-correctable beat error counter */
  vuint32_t R;
  struct {
    vuint32_t CBL_BEAT_EC:15;          /* Correctable beat error count */
    vuint32_t CBL_BEAT_OF:1;           /* Correctable Beat Over-Flow */
    vuint32_t UCBL_BEAT_EC:15;         /* Un-correctable beat error count */
    vuint32_t UCBL_BEAT_OF:1;          /* Un-correctable Beat Over-Flow */
  } B;
} MEW_AXI_ECC_CBL_UCBL_BEAT_EC_tag;

typedef union MEW_AXI_ECC_DBG_CTRL_union_tag { /* Debug and Debug Control Register */
  vuint32_t R;
  struct {
    vuint32_t ADD_EN_ECC_DIS:1;        /* Address Mapper Enabled but ECC Disabled */
    vuint32_t _unused_1:31;
  } B;
} MEW_AXI_ECC_DBG_CTRL_tag;

struct MEW_AXI_tag {
  MEW_AXI_ECC_GLBL_CTRL_tag ECC_GLBL_CTRL; /* AXI ECC Global Control Register */
  MEW_AXI_ECC_MX_EPA_tag ECC_MX_EPA;   /* AXI ECC Maximum ECC protected address register */
  MEW_AXI_ECC_MN_EPA_tag ECC_MN_EPA;   /* AXI ECC Minimum ECC protected address register */
  MEW_AXI_ECC_LK_PTN_tag ECC_LK_PTN;   /* AXI ECC Lock Pattern Register */
  MEW_AXI_ECC_ULK_PTN_tag ECC_ULK_PTN; /* AXI ECC Unlock Pattern Register */
  uint8_t MEW_AXI_reserved0[4];
  MEW_AXI_ECC_EERAR_tag ECC_EERAR;     /* ECC Error Report Address Register */
  MEW_AXI_ECC_EERDSR_tag ECC_EERDSR[4]; /* AXI ECC Error Report Data and Syndrome Register */
  MEW_AXI_ECC_ERR_IE_tag ECC_ERR_IE;   /* AXI ECC error interrupt enable */
  MEW_AXI_ECC_ERR_IN_STCLR_tag ECC_ERR_IN_STCLR; /* AXI ECC error Interupt status and clear register */
  MEW_AXI_EDC_ERR_IE_tag EDC_ERR_IE;   /* AXI EDC Error interrupt enable register */
  MEW_AXI_EDC_ERR_IN_STCLR_tag EDC_ERR_IN_STCLR; /* AXI EDC Error Interrupt Status and Clear register */
  uint8_t MEW_AXI_reserved1[4];
  MEW_AXI_ECC_SHD_STAT_CTRL_tag ECC_SHD_STAT_CTRL; /* Shadow Control, RW path Status and Status Clear Register */
  MEW_AXI_ECC_CBL_UNCBL_BIT_EC_tag ECC_CBL_UNCBL_BIT_EC; /* Correctable and un-correctable bit error counter */
  MEW_AXI_ECC_CBL_UCBL_BEAT_EC_tag ECC_CBL_UCBL_BEAT_EC; /* Correctable and un-correctable beat error counter */
  uint8_t MEW_AXI_reserved2[52];
  MEW_AXI_ECC_DBG_CTRL_tag ECC_DBG_CTRL; /* Debug and Debug Control Register */
};


/* ============================================================================
   =============================== Module: MEW_WPT ============================
   ============================================================================ */

typedef union MEW_WPT_CTRL_union_tag { /* Watchpoint Control register */
  vuint32_t R;
  struct {
    vuint32_t TR_EN:1;                 /* Trace Enable */
    vuint32_t TR_RW_SEL:1;             /* Trace transaction select. */
    vuint32_t COMP_MOD:1;              /* Comparator Mode */
    vuint32_t RD_CTRL:2;               /* FIFO Read Control */
    vuint32_t _unused_5:27;
  } B;
} MEW_WPT_CTRL_tag;

typedef union MEW_WPT_MST_ID_COM_union_tag { /* Master ID reference register */
  vuint32_t R;
  struct {
    vuint32_t MID_REF:16;              /* Master ID reference */
    vuint32_t _unused_16:16;
  } B;
} MEW_WPT_MST_ID_COM_tag;

typedef union MEW_WPT_MST_ID_MSK_union_tag { /* Master ID compare mask register */
  vuint32_t R;
  struct {
    vuint32_t ID_COM_MSK:16;           /* ID comparison mask */
    vuint32_t _unused_16:16;
  } B;
} MEW_WPT_MST_ID_MSK_tag;

typedef union MEW_WPT_MST_ID_SEL_union_tag { /* Master ID select register */
  vuint32_t R;
  struct {
    vuint32_t MID_SEL0:4;              /* Master ID select0 */
    vuint32_t MID_SEL1:4;              /* Master ID select1 */
    vuint32_t MID_SEL2:4;              /* Master ID select2 */
    vuint32_t MID_SEL3:4;              /* Master ID select3 */
    vuint32_t _unused_16:16;
  } B;
} MEW_WPT_MST_ID_SEL_tag;

typedef union MEW_WPT_ADDR_R1_union_tag { /* Address Range1 Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_ST:32;              /* Address Trace Start */
  } B;
} MEW_WPT_ADDR_R1_tag;

typedef union MEW_WPT_ADDR_R1_MASK_union_tag { /* Address Range1 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MASK_R1:32;              /* Start address mask */
  } B;
} MEW_WPT_ADDR_R1_MASK_tag;

typedef union MEW_WPT_ADDR_R2_union_tag { /* Address Range2 Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR_END:32;             /* Address Trace End */
  } B;
} MEW_WPT_ADDR_R2_tag;

typedef union MEW_WPT_ADDR_R2_MASK_union_tag { /* Address Range2 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MASK_R2:32;              /* End address mask */
  } B;
} MEW_WPT_ADDR_R2_MASK_tag;

typedef union MEW_WPT_FIFO_EMPTY_TH_union_tag { /* FIFO Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t EMP_TH:6;                /* FIFO Empty Threshold */
    vuint32_t _unused_6:26;
  } B;
} MEW_WPT_FIFO_EMPTY_TH_tag;

typedef union MEW_WPT_INT_EN_union_tag { /* Watchpoint Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t EXTOUTST_IE:1;           /* External Event Out interrupt enable */
    vuint32_t _unused_1:31;
  } B;
} MEW_WPT_INT_EN_tag;

typedef union MEW_WPT_STATUS_union_tag { /* Watchpoint Status register */
  vuint32_t R;
  struct {
    vuint32_t FIFO_OVF:1;              /* FIFO overflow status */
    vuint32_t EXTOUTST:1;              /* External Event Out Status */
    vuint32_t FIFO_EMPTY:1;            /* FIFO Empty Status */
    vuint32_t _unused_3:29;
  } B;
} MEW_WPT_STATUS_tag;

struct MEW_WPT_tag {
  uint8_t MEW_WPT_reserved0[1280];
  MEW_WPT_CTRL_tag CTRL;               /* Watchpoint Control register */
  MEW_WPT_MST_ID_COM_tag MST_ID_COM[4]; /* Master ID reference register */
  MEW_WPT_MST_ID_MSK_tag MST_ID_MSK[4]; /* Master ID compare mask register */
  MEW_WPT_MST_ID_SEL_tag MST_ID_SEL[4]; /* Master ID select register */
  MEW_WPT_ADDR_R1_tag ADDR_R1;         /* Address Range1 Register */
  MEW_WPT_ADDR_R1_MASK_tag ADDR_R1_MASK; /* Address Range1 Mask Register */
  MEW_WPT_ADDR_R2_tag ADDR_R2;         /* Address Range2 Register */
  MEW_WPT_ADDR_R2_MASK_tag ADDR_R2_MASK; /* Address Range2 Mask Register */
  MEW_WPT_FIFO_EMPTY_TH_tag FIFO_EMPTY_TH; /* FIFO Empty Threshold */
  MEW_WPT_INT_EN_tag INT_EN;           /* Watchpoint Interrupt Enable register */
  MEW_WPT_STATUS_tag STATUS;           /* Watchpoint Status register */
};


/* ============================================================================
   =============================== Module: MIPICSI2 ===========================
   ============================================================================ */

typedef union MIPICSI2_CONC_union_tag { /* RX Controller Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NULANE:1;                /* Number Of active Lanes being used to receive MIPICSI2 Data */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} MIPICSI2_CONC_tag;

typedef union MIPICSI2_PHYC_union_tag { /* PHY Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HSEL:1;                  /* High Speed Select */
    vuint32_t PDRX:1;                  /* Power Down Receiver */
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} MIPICSI2_PHYC_tag;

typedef union MIPICSI2_CLKCS_union_tag { /* Clock Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t HSRA:1;                  /* High Speed Clock Receive Active */
    vuint32_t ULPSC:1;                 /* Clock Lane ULPS */
    vuint32_t CSTOP:1;                 /* Clock Lane Stop State */
    vuint32_t CULPSA:1;                /* Clock Lane ULPS Active */
    vuint32_t CULPMA:1;                /* Clock Lane ULPS mark Active State */
    vuint32_t HSSETL:6;                /* Clock Lane Program RX HS Settle */
    vuint32_t _unused_11:21;           /* Reserved */
  } B;
} MIPICSI2_CLKCS_tag;

typedef union MIPICSI2_LAN0CS_union_tag { /* D-PHY Lane 0 Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t RXVALH:1;                /* Data Lane 0 RX Valid HS */
    vuint32_t RXACTH:1;                /* D-PHY Data lane 0 RX active High Speed data */
    vuint32_t _unused_2:1;
    vuint32_t D0STOP:1;                /* Data Lane 0 Stop State */
    vuint32_t D0ULPA:1;                /* Data lane 0 ULPS Active */
    vuint32_t D0ULMA:1;                /* Data Lane 0 ULPS Mark Active */
    vuint32_t D0HSET:6;                /* Data lane 0 Program RX HS Settle time */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} MIPICSI2_LAN0CS_tag;

typedef union MIPICSI2_LAN1CS_union_tag { /* D-PHY Data LANE 1 Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t RXVALH:1;                /* D-PHY Data lane 1 Receive Valid High speed */
    vuint32_t RXACTH:1;                /* D-PHY Data lane 1 Active HS */
    vuint32_t _unused_2:1;
    vuint32_t D1STOP:1;                /* D-PHY Data Lane 1 Stop */
    vuint32_t D1ULPA:1;                /* D-PHY Data Lane 1 ULPS Active */
    vuint32_t D1ULMA:1;                /* D_PHY Data Lane 1 ULPS Mark active */
    vuint32_t D1HSET:6;                /* D_PHY Data Lane 1 PRG HS Settle time */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} MIPICSI2_LAN1CS_tag;

typedef union MIPICSI2_LAN2CS_union_tag { /* LANE 2 Configuration/Status Register */
  vuint32_t R;
  struct {
    vuint32_t RXVALH:1;                /* High Speed Receive Data Valid */
    vuint32_t RXACTH:1;                /* DPHY Data Lane 2 High Speed Receive Active */
    vuint32_t _unused_2:1;
    vuint32_t D2STOP:1;                /* DPHY Data Lane 2 Stop State */
    vuint32_t D2ULPA:1;                /* DPHY Dat aLane 2 in Ulps State */
    vuint32_t D2ULMA:1;                /* DPHY Data Lane 2 Mark One state */
    vuint32_t D2HSET:6;                /* DPHY Data Lane 2 Sette Time */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} MIPICSI2_LAN2CS_tag;

typedef union MIPICSI2_LAN3CS_union_tag { /* LANE3 Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t RXVALH:1;                /* High Speed Receive Data Vaild */
    vuint32_t RXACTH:1;                /* DPHY Data Lane3 High Speed Receive Active */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t D3STOP:1;                /* DPHY Data Lane 3 Stop State */
    vuint32_t D3ULPA:1;                /* DPHY Data Lane 3 ULPS State */
    vuint32_t D3ULMA:1;                /* DPHY Data Lane 3 Mark One State */
    vuint32_t D3HSET:6;                /* DPHY Data Lane 3 High Speed Receive Settle Time */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} MIPICSI2_LAN3CS_tag;

typedef union MIPICSI2_RESCS_union_tag { /* External Resistor Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t NOCAL:1;                 /* No Calibration */
    vuint32_t _unused_1:2;
    vuint32_t RCALI:2;                 /* Resistor Calibration Input */
    vuint32_t CALCOM:1;                /* Calibration Complete */
    vuint32_t CALOUT:2;                /* Calibrator output */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} MIPICSI2_RESCS_tag;

typedef union MIPICSI2_SR_union_tag {  /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;            /* Reserved */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:19;           /* Reserved */
    vuint32_t SOFRST:1;                /* Software reset */
  } B;
} MIPICSI2_SR_tag;

typedef union MIPICSI2_DATAVCR_union_tag { /* DATAID VC Report Register */
  vuint32_t R;
  struct {
    vuint32_t DATAID:6;                /* Data ID of the data being currently received from the controller */
    vuint32_t VCID:2;                  /* VC ID of the currently received data */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} MIPICSI2_DATAVCR_tag;

typedef union MIPICSI2_ERRPPREG_union_tag { /* Protocol and Packet Error Register */
  vuint32_t R;
  struct {
    vuint32_t ECCONE:1;                /* ECC one bit error */
    vuint32_t ECCTWO:1;                /* ECC Two Bit Error */
    vuint32_t _unused_2:1;
    vuint32_t ERFDAT:1;                /* Frame data error */
    vuint32_t CRCERR:1;                /* CRC Error */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} MIPICSI2_ERRPPREG_tag;

typedef union MIPICSI2_ERRPOS_union_tag { /* Error Position */
  vuint32_t R;
  struct {
    vuint32_t ERRPOS:5;                /* Error Position */
    vuint32_t _unused_5:27;            /* Reserved */
  } B;
} MIPICSI2_ERRPOS_tag;

typedef union MIPICSI2_ERPPINTEN_union_tag { /* Protocol Packet Error Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t ECCOIE:1;                /* ECC One Interrupt Enable */
    vuint32_t ECCTIE:1;                /* ECC Two Interrupt Enable */
    vuint32_t _unused_2:1;
    vuint32_t ERFDIE:1;                /* Error Frame Data Interrupt Enable */
    vuint32_t CRCEIE:1;                /* CRC Error Interrupt Enable */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t _unused_7:25;            /* Reserved */
  } B;
} MIPICSI2_ERPPINTEN_tag;

typedef union MIPICSI2_ERRPHY_union_tag { /* PHY Error Report Register */
  vuint32_t R;
  struct {
    vuint32_t ERRSY0:1;                /* Error in the synchronization pattern detected by PHY in lane0 */
    vuint32_t NOSYN0:1;                /* No Synchronization Error Lane 0 on HS entry */
    vuint32_t ERRESC0:1;               /* Escape Mode Entry Error on lane 0 */
    vuint32_t ERSYES0:1;               /* Synchronization error in Escape mode on lane 0 */
    vuint32_t ERCTRL0:1;               /* Control Error on lane 0 */
    vuint32_t ERRSYN1:1;               /* Error in the synchronization pattern detected by PHY in lane1 */
    vuint32_t NOSYN1:1;                /* No Synchronization Error Lane 1 */
    vuint32_t ERRESC1:1;               /* Escape Mode Entry Error on lane 1 */
    vuint32_t ERSYES1:1;               /* Synchronization error in Escape mode on lane 1 */
    vuint32_t ERCTRL1:1;               /* Control Error on lane 1 */
    vuint32_t ERRSY2:1;                /* Error in the synchronization pattern detected by PHY in lane2 */
    vuint32_t NOSYN2:1;                /* No Synchronization Error Lane 2 */
    vuint32_t ERRESC2:1;               /* Escape Mode Entry Error on lane 2 */
    vuint32_t ERSYES2:1;               /* Synchronization error in Escape mode on lane 2 */
    vuint32_t ERCTRL2:1;               /* Control Error on lane 2 */
    vuint32_t ERRSY3:1;                /* Error in the synchronization pattern detected by PHY in lane3 */
    vuint32_t NOSYN3:1;                /* No Synchronization Error Lane 3 */
    vuint32_t ERRESC3:1;               /* Escape Mode Entry Error on lane 3 */
    vuint32_t ERSYES3:1;               /* Synchronization error in Escape mode on lane 3 */
    vuint32_t ERCTRL3:1;               /* Control Error on lane 3 */
    vuint32_t _unused_20:12;           /* Reserved */
  } B;
} MIPICSI2_ERRPHY_tag;

typedef union MIPICSI2_ERPHYIE_union_tag { /* Phy Error Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t ERSIE0:1;
    vuint32_t NOSIE0:1;
    vuint32_t ESERIE0:1;
    vuint32_t ERSYIE0:1;
    vuint32_t ERCLIE0:1;
    vuint32_t ERSIE1:1;
    vuint32_t NOSIE1:1;
    vuint32_t ESERIE1:1;
    vuint32_t ERSYIE1:1;
    vuint32_t ERCLIE1:1;
    vuint32_t ERSIE2:1;
    vuint32_t NOSIE2:1;
    vuint32_t ESERIE2:1;
    vuint32_t ERSYIE2:1;
    vuint32_t ERCLIE2:1;
    vuint32_t ERSIE3:1;
    vuint32_t NOSIE3:1;
    vuint32_t ESERIE3:1;
    vuint32_t ERSYIE3:1;
    vuint32_t ERCLIE3:1;
    vuint32_t _unused_20:12;           /* Reserved */
  } B;
} MIPICSI2_ERPHYIE_tag;

typedef union MIPICSI2_RXEN_union_tag { /* RX Enable Register */
  vuint32_t R;
  struct {
    vuint32_t RXEN:1;                  /* Receive enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} MIPICSI2_RXEN_tag;

typedef union MIPICSI2_ALPHAVAL_union_tag { /* Alpha Value Register */
  vuint32_t R;
  struct {
    vuint32_t ALPHA:8;                 /* Alpha Value */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} MIPICSI2_ALPHAVAL_tag;

typedef union MIPICSI2_CH_SRTPTR_union_tag { /* Start Pointer for Virtual Channel data in SRAM */
  vuint32_t R;
  struct {
    vuint32_t SRTPTR:22;               /* Start Pointer for a Virtual Channel */
    vuint32_t _unused_22:10;           /* Reserved */
  } B;
} MIPICSI2_CH_SRTPTR_tag;

typedef union MIPICSI2_CH_BUFLLEN_union_tag { /* Buffer Line Length for Virtual Channel Data */
  vuint32_t R;
  struct {
    vuint32_t BUFLLEN:16;              /* Buffer Line length */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_BUFLLEN_tag;

typedef union MIPICSI2_CH_LINLEN_union_tag { /* LINE LENGTH for Virtual Channel data */
  vuint32_t R;
  struct {
    vuint32_t LINLEN:16;               /* LINE LENGTH of an image line for a particular virtual channel */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_LINLEN_tag;

typedef union MIPICSI2_CH_NUMLINE_union_tag { /* NUMBER OF LINES ON A VC */
  vuint32_t R;
  struct {
    vuint32_t NULINE:10;               /* Number of Lines in Circular buffer for each Virtual Channel */
    vuint32_t _unused_10:22;           /* Reserved */
  } B;
} MIPICSI2_CH_NUMLINE_tag;

typedef union MIPICSI2_CH_NXTLIN_union_tag { /* Next Line In SRAM for a particular VC */
  vuint32_t R;
  struct {
    vuint32_t NXTLINE:10;              /* Next line indicator in Cicrcular buffer for a virtual channel */
    vuint32_t _unused_10:22;           /* Reserved */
  } B;
} MIPICSI2_CH_NXTLIN_tag;

typedef union MIPICSI2_CH_TOTLIN_union_tag { /* Total Lines received for Virtual Channel */
  vuint32_t R;
  struct {
    vuint32_t TOTLINE:16;              /* Total number of image lines received for a virtual channel */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_TOTLIN_tag;

typedef union MIPICSI2_CH_EXPCTDL_union_tag { /* Expected Number of Lines on a VC */
  vuint32_t R;
  struct {
    vuint32_t EXPLINES:16;             /* Expected Number Of Lines In a Frame */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_EXPCTDL_tag;

typedef union MIPICSI2_CH_LPDI_union_tag { /* Lines Per Done Indication for a VC */
  vuint32_t R;
  struct {
    vuint32_t LPDI:8;                  /* Lines Per Done Indication */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} MIPICSI2_CH_LPDI_tag;

typedef union MIPICSI2_CH_STRMDT_union_tag { /* Stream Data Type for VC */
  vuint32_t R;
  struct {
    vuint32_t STRMDT:6;                /* Stream Data Type */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} MIPICSI2_CH_STRMDT_tag;

typedef union MIPICSI2_CH_ERRLEN_union_tag { /* ERROR LENGTH */
  vuint32_t R;
  struct {
    vuint32_t ERRLEN:16;               /* Error Length */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_ERRLEN_tag;

typedef union MIPICSI2_CH_ERRLINE_union_tag { /* Error Line */
  vuint32_t R;
  struct {
    vuint32_t LINNUM:16;               /* Line Number */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_CH_ERRLINE_tag;

typedef struct MIPICSI2_CH_struct_tag {
  MIPICSI2_CH_SRTPTR_tag SRTPTR;       /* Start Pointer for Virtual Channel data in SRAM */
  uint32_t CH_reserved0[3];
  MIPICSI2_CH_BUFLLEN_tag BUFLLEN;     /* Buffer Line Length for Virtual Channel Data */
  uint32_t CH_reserved1[3];
  MIPICSI2_CH_LINLEN_tag LINLEN;       /* LINE LENGTH for Virtual Channel data */
  uint32_t CH_reserved2[3];
  MIPICSI2_CH_NUMLINE_tag NUMLINE;     /* NUMBER OF LINES ON A VC */
  uint32_t CH_reserved3[3];
  MIPICSI2_CH_NXTLIN_tag NXTLIN;       /* Next Line In SRAM for a particular VC */
  uint32_t CH_reserved4[3];
  MIPICSI2_CH_TOTLIN_tag TOTLIN;       /* Total Lines received for Virtual Channel */
  uint32_t CH_reserved5[3];
  MIPICSI2_CH_EXPCTDL_tag EXPCTDL;     /* Expected Number of Lines on a VC */
  uint32_t CH_reserved6[3];
  MIPICSI2_CH_LPDI_tag LPDI;           /* Lines Per Done Indication for a VC */
  uint32_t CH_reserved7[3];
  MIPICSI2_CH_STRMDT_tag STRMDT;       /* Stream Data Type for VC */
  uint32_t CH_reserved8[3];
  MIPICSI2_CH_ERRLEN_tag ERRLEN;       /* ERROR LENGTH */
  uint32_t CH_reserved9[3];
  MIPICSI2_CH_ERRLINE_tag ERRLINE;     /* Error Line */
} MIPICSI2_CH_tag;

typedef union MIPICSI2_ENABLECH_union_tag { /* Enable Channel */
  vuint32_t R;
  struct {
    vuint32_t CHOEN:1;                 /* Enable Virtual Channel Zero */
    vuint32_t CH1EN:1;                 /* Channel One Enable */
    vuint32_t CH2EN:1;                 /* Channel Two Enable */
    vuint32_t CH3EN:1;                 /* Channel Three Enable */
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} MIPICSI2_ENABLECH_tag;

typedef union MIPICSI2_INTRENVC_union_tag { /* Interrupt Enable on Virtual Channel */
  vuint32_t R;
  struct {
    vuint32_t FS0IE:1;                 /* Frame Satrt Virtual Channel0 Interrupt Enable */
    vuint32_t FE0IE:1;                 /* Frame End Virtual channel 0 Inetrrupt Enable */
    vuint32_t LINERR0IE:1;             /* Line Length Error On Virtual Channel Zero Interrupt Enable */
    vuint32_t LNCNT0IE:1;              /* Line Count Error On Virtual Channel0 Interrupt Enable */
    vuint32_t FS1IE:1;                 /* Frame Start Error on Virtual Channel one Interrupt Enable */
    vuint32_t FE1IE:1;                 /* Frame End On Virtual Channel One Interrupt Enable */
    vuint32_t LINERR1IE:1;             /* Incorrect Line Length On Virtual Channel One Interrupt Enable */
    vuint32_t LNCNT1IE:1;              /* Line Count Error On Virtual Channel One Interrupt Enable */
    vuint32_t FS2IE:1;                 /* Frame Start On Virtual channel two Interrupt Enable */
    vuint32_t FE2IE:1;                 /* Frmae End On Virtual Channel One Interrupt Enable */
    vuint32_t LINERR2IE:1;             /* Line Length Error on Virtual Channel two Interrupt Enable */
    vuint32_t LNCNT2IE:1;              /* Number Of Line Error on Virtual Channel two Interrupt Enable */
    vuint32_t FS3IE:1;                 /* Frma eStart on Virtual Channel 3 Interrupt Enable */
    vuint32_t FE3IE:1;                 /* Frame End on Virtual Channel 3 Interrupt Enable */
    vuint32_t LINERR3IE:1;             /* Line Length Error on Virtual Channel Tghree Interrupt Enable */
    vuint32_t LNCNT3IE:1;              /* Number Of Line Error on Virtual Channel three Interrupt Enable */
    vuint32_t _unused_16:16;           /* RESERVED */
  } B;
} MIPICSI2_INTRENVC_tag;

typedef union MIPICSI2_INTRSVC_union_tag { /* Interrupt Status For Virtual Channel */
  vuint32_t R;
  struct {
    vuint32_t FS0:1;                   /* Frame Start On Virtual Channel Zero */
    vuint32_t FE0:1;                   /* Frmae End On Virtual Channel Zero */
    vuint32_t LLENE0:1;                /* Line Length Error Virtual Channel Zero */
    vuint32_t LCNTE0:1;                /* Line Count Error On Virtual Channel Zero */
    vuint32_t FS1:1;                   /* Frame Start on Virtual Channel One */
    vuint32_t FE1:1;                   /* Frame End On Virtual Channel 1 */
    vuint32_t LLENE1:1;                /* Line Length Error On Virtual Channel One */
    vuint32_t LCNTE1:1;                /* Line Count error On Virtual Channel One */
    vuint32_t FS2:1;                   /* Frame Start On Virtual Channel Two */
    vuint32_t FE2:1;                   /* Frma eEnd On Virtual Channel Two */
    vuint32_t LLENE2:1;                /* Line Length error On Virtual Channel Two */
    vuint32_t LCNTE2:1;                /* Line Count Error On Virtual Channel Two */
    vuint32_t FS3:1;                   /* Frame Start on virtual Channel 3 */
    vuint32_t FE3:1;                   /* Frma end On Virtual Channel Three */
    vuint32_t LLENE3:1;                /* Line Length Error on Virtual Channel Three */
    vuint32_t LCNTE3:1;                /* Line Count error on Virtual Channel Three */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} MIPICSI2_INTRSVC_tag;

typedef union MIPICSI2_EMBEDSP_union_tag { /* Embedded Data Start Pointer */
  vuint32_t R;
  struct {
    vuint32_t STRPTR:22;               /* Start Pointer for Embedded data */
    vuint32_t _unused_22:10;           /* Reserved */
  } B;
} MIPICSI2_EMBEDSP_tag;

typedef union MIPICSI2_EMBEDLEN_union_tag { /* Embedded Data Length */
  vuint32_t R;
  struct {
    vuint32_t LENSTP:22;               /* Length Of Embedded Data chunk Written to SRAM */
    vuint32_t _unused_22:10;           /* Reserved */
  } B;
} MIPICSI2_EMBEDLEN_tag;

typedef union MIPICSI2_EMBEDNP_union_tag { /* Embedded Data Next Pointer */
  vuint32_t R;
  struct {
    vuint32_t NXTPTR:22;               /* Next Pointer For Embedded Data */
    vuint32_t _unused_22:10;           /* Reserved */
  } B;
} MIPICSI2_EMBEDNP_tag;

typedef union MIPICSI2_EMBEDENB_union_tag { /* Embedded Data Enable */
  vuint32_t R;
  struct {
    vuint32_t ENABLEVC:4;              /* Enable Embedded Data reception for Virtual Channel */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;            /* Reserved */
  } B;
} MIPICSI2_EMBEDENB_tag;

typedef union MIPICSI2_EMBEDRCVD_union_tag { /* Embedded data Received Count */
  vuint32_t R;
  struct {
    vuint32_t DATARCVD:4;              /* Embedded data received */
    vuint32_t ERROR:1;                 /* Error in embedded data capture */
    vuint32_t _unused_5:27;            /* Reserved */
  } B;
} MIPICSI2_EMBEDRCVD_tag;

typedef union MIPICSI2_EMBMSTR_union_tag { /* Embedded Data Master Channel */
  vuint32_t R;
  struct {
    vuint32_t MSTRCHNL:2;              /* Master Channel Selection For Embedded Data Capture */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} MIPICSI2_EMBMSTR_tag;

typedef union MIPICSI2_EMBEDIE_union_tag { /* Embedded Data Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t EMBIE1:1;                /* Embedded Data Intrerrupt Enable 1 */
    vuint32_t EMBIE2:1;                /* Embedded Data Interrupt Enable 2 */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} MIPICSI2_EMBEDIE_tag;

typedef union MIPICSI2_EMBEDINTS_union_tag { /* Embedded Data Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t EMBIS0:1;                /* Embedded Data Interrupt Status 0 */
    vuint32_t EMBIS1:1;                /* Embedded Data Interrupt Status 1 */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} MIPICSI2_EMBEDINTS_tag;

typedef union MIPICSI2_EMBEDIRQ1_union_tag { /* Embedded Lines for genertaion of first interrupt */
  vuint32_t R;
  struct {
    vuint32_t LINESIRQ1:4;             /* Embedded lines after which first interrupt is generated */
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} MIPICSI2_EMBEDIRQ1_tag;

typedef union MIPICSI2_EMBEDIRQ2_union_tag { /* Embedded Lines after which second interrpt is generated */
  vuint32_t R;
  struct {
    vuint32_t LINESIRQ2:4;             /* Embedded Lines after which second interrupt is generated */
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} MIPICSI2_EMBEDIRQ2_tag;

struct MIPICSI2_tag {
  MIPICSI2_CONC_tag CONC;              /* RX Controller Configuration Register */
  uint32_t MIPICSI2_reserved0[3];
  MIPICSI2_PHYC_tag PHYC;              /* PHY Configuration Register */
  uint32_t MIPICSI2_reserved1[3];
  MIPICSI2_CLKCS_tag CLKCS;            /* Clock Configuration Status Register */
  uint32_t MIPICSI2_reserved2[3];
  MIPICSI2_LAN0CS_tag LAN0CS;          /* D-PHY Lane 0 Configuration Status Register */
  uint32_t MIPICSI2_reserved3[3];
  MIPICSI2_LAN1CS_tag LAN1CS;          /* D-PHY Data LANE 1 Configuration Status Register */
  uint32_t MIPICSI2_reserved4[3];
  MIPICSI2_LAN2CS_tag LAN2CS;          /* LANE 2 Configuration/Status Register */
  uint32_t MIPICSI2_reserved5[3];
  MIPICSI2_LAN3CS_tag LAN3CS;          /* LANE3 Configuration Status Register */
  uint32_t MIPICSI2_reserved6[7];
  MIPICSI2_RESCS_tag RESCS;            /* External Resistor Configuration Status Register */
  uint32_t MIPICSI2_reserved7[7];
  MIPICSI2_SR_tag SR;                  /* Status Register */
  uint32_t MIPICSI2_reserved8[3];
  MIPICSI2_DATAVCR_tag DATAVCR;        /* DATAID VC Report Register */
  uint32_t MIPICSI2_reserved9[7];
  MIPICSI2_ERRPPREG_tag ERRPPREG;      /* Protocol and Packet Error Register */
  uint32_t MIPICSI2_reserved10[3];
  MIPICSI2_ERRPOS_tag ERRPOS;          /* Error Position */
  uint32_t MIPICSI2_reserved11[3];
  MIPICSI2_ERPPINTEN_tag ERPPINTEN;    /* Protocol Packet Error Interrupt Enable */
  uint32_t MIPICSI2_reserved12[7];
  MIPICSI2_ERRPHY_tag ERRPHY;          /* PHY Error Report Register */
  uint32_t MIPICSI2_reserved13[3];
  MIPICSI2_ERPHYIE_tag ERPHYIE;        /* Phy Error Interrupt Enable Register */
  uint32_t MIPICSI2_reserved14[3];
  MIPICSI2_RXEN_tag RXEN;              /* RX Enable Register */
  uint32_t MIPICSI2_reserved15[11];
  MIPICSI2_ALPHAVAL_tag ALPHAVAL;      /* Alpha Value Register */
  uint32_t MIPICSI2_reserved16[3];
  MIPICSI2_CH_tag CH[4];
  MIPICSI2_ENABLECH_tag ENABLECH;      /* Enable Channel */
  uint32_t MIPICSI2_reserved17[3];
  MIPICSI2_INTRENVC_tag INTRENVC;      /* Interrupt Enable on Virtual Channel */
  uint32_t MIPICSI2_reserved18[3];
  MIPICSI2_INTRSVC_tag INTRSVC;        /* Interrupt Status For Virtual Channel */
  uint32_t MIPICSI2_reserved19[3];
  MIPICSI2_EMBEDSP_tag EMBEDSP;        /* Embedded Data Start Pointer */
  uint32_t MIPICSI2_reserved20[3];
  MIPICSI2_EMBEDLEN_tag EMBEDLEN;      /* Embedded Data Length */
  uint32_t MIPICSI2_reserved21[3];
  MIPICSI2_EMBEDNP_tag EMBEDNP;        /* Embedded Data Next Pointer */
  uint32_t MIPICSI2_reserved22[3];
  MIPICSI2_EMBEDENB_tag EMBEDENB;      /* Embedded Data Enable */
  uint32_t MIPICSI2_reserved23[3];
  MIPICSI2_EMBEDRCVD_tag EMBEDRCVD;    /* Embedded data Received Count */
  uint32_t MIPICSI2_reserved24[3];
  MIPICSI2_EMBMSTR_tag EMBMSTR;        /* Embedded Data Master Channel */
  uint32_t MIPICSI2_reserved25[3];
  MIPICSI2_EMBEDIE_tag EMBEDIE;        /* Embedded Data Interrupt Enable */
  uint32_t MIPICSI2_reserved26[3];
  MIPICSI2_EMBEDINTS_tag EMBEDINTS;    /* Embedded Data Interrupt Status Register */
  uint32_t MIPICSI2_reserved27[3];
  MIPICSI2_EMBEDIRQ1_tag EMBEDIRQ1;    /* Embedded Lines for genertaion of first interrupt */
  uint32_t MIPICSI2_reserved28[3];
  MIPICSI2_EMBEDIRQ2_tag EMBEDIRQ2;    /* Embedded Lines after which second interrpt is generated */
};


/* ============================================================================
   =============================== Module: MMDC ===============================
   ============================================================================ */

typedef union MMDC_MDCTL_union_tag {   /* MMDC Core Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DSIZ:2;
    vuint32_t _unused_18:1;
    vuint32_t BL:1;
    vuint32_t COL:3;
    vuint32_t _unused_23:1;
    vuint32_t ROW:3;
    vuint32_t _unused_27:3;
    vuint32_t SDE_1:1;
    vuint32_t SDE_0:1;
  } B;
} MMDC_MDCTL_tag;

typedef union MMDC_MDPDC_union_tag {   /* MMDC Core Power Down Control Register */
  vuint32_t R;
  struct {
    vuint32_t tCKSRE:3;
    vuint32_t tCKSRX:3;
    vuint32_t BOTH_CS_PD:1;
    vuint32_t SLOW_PD:1;
    vuint32_t PWDT_0:4;
    vuint32_t PWDT_1:4;
    vuint32_t tCKE:3;
    vuint32_t _unused_19:5;
    vuint32_t PRCT_0:3;
    vuint32_t _unused_27:1;
    vuint32_t PRCT_1:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MDPDC_tag;

typedef union MMDC_MDOTC_union_tag {   /* MMDC Core ODT Timing Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t tODT_idle_off:5;
    vuint32_t _unused_9:3;
    vuint32_t tODTLon:3;
    vuint32_t _unused_15:1;
    vuint32_t tAXPD:4;
    vuint32_t tANPD:4;
    vuint32_t tAONPD:3;
    vuint32_t tAOFPD:3;
    vuint32_t _unused_30:2;
  } B;
} MMDC_MDOTC_tag;

typedef union MMDC_MDCFG0_union_tag {  /* MMDC Core Timing Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t tCL:4;
    vuint32_t tFAW:5;
    vuint32_t tXPDLL:4;
    vuint32_t tXP:3;
    vuint32_t tXS:8;
    vuint32_t tRFC:8;
  } B;
} MMDC_MDCFG0_tag;

typedef union MMDC_MDCFG1_union_tag {  /* MMDC Core Timing Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t tCWL:3;
    vuint32_t _unused_3:2;
    vuint32_t tMRD:4;
    vuint32_t tWR:3;
    vuint32_t _unused_12:3;
    vuint32_t tRPA:1;
    vuint32_t tRAS:5;
    vuint32_t tRC:5;
    vuint32_t tRP:3;
    vuint32_t tRCD:3;
  } B;
} MMDC_MDCFG1_tag;

typedef union MMDC_MDCFG2_union_tag {  /* MMDC Core Timing Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t tRRD:3;
    vuint32_t tWTR:3;
    vuint32_t tRTP:3;
    vuint32_t _unused_9:7;
    vuint32_t tDLLK:9;
    vuint32_t _unused_25:7;
  } B;
} MMDC_MDCFG2_tag;

typedef union MMDC_MDMISC_union_tag {  /* MMDC Core Miscellaneous Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t RST:1;
    vuint32_t _unused_2:1;
    vuint32_t DDR_TYPE:2;
    vuint32_t DDR_4_BANK:1;
    vuint32_t RALAT:3;
    vuint32_t MIF3_MODE:2;
    vuint32_t LPDDR2_S2:1;
    vuint32_t BI_ON:1;
    vuint32_t _unused_13:3;
    vuint32_t WALAT:2;
    vuint32_t LHD:1;
    vuint32_t ADDR_MIRROR:1;
    vuint32_t CALIB_PER_CS:1;
    vuint32_t _unused_21:9;
    vuint32_t CS1_RDY:1;
    vuint32_t CS0_RDY:1;
  } B;
} MMDC_MDMISC_tag;

typedef union MMDC_MDSCR_union_tag {   /* MMDC Core Special Command Register */
  vuint32_t R;
  struct {
    vuint32_t CMD_BA:3;
    vuint32_t CMD_CS:1;
    vuint32_t CMD:3;
    vuint32_t _unused_7:2;
    vuint32_t WL_EN:1;
    vuint32_t MRR_READ_DATA_VALID:1;
    vuint32_t _unused_11:3;
    vuint32_t CON_ACK:1;
    vuint32_t CON_REQ:1;
    vuint32_t CMD_ADDR_LSB_MR_ADDR:8;
    vuint32_t CMD_ADDR_MSB_MR_OP:8;
  } B;
} MMDC_MDSCR_tag;

typedef union MMDC_MDREF_union_tag {   /* MMDC Core Refresh Control Register */
  vuint32_t R;
  struct {
    vuint32_t START_REF:1;
    vuint32_t _unused_1:10;
    vuint32_t REFR:3;
    vuint32_t REF_SEL:2;
    vuint32_t REF_CNT:16;
  } B;
} MMDC_MDREF_tag;

typedef union MMDC_MDRWD_union_tag {   /* MMDC Core Read/Write Command Delay Register */
  vuint32_t R;
  struct {
    vuint32_t RTR_DIFF:3;
    vuint32_t RTW_DIFF:3;
    vuint32_t WTW_DIFF:3;
    vuint32_t WTR_DIFF:3;
    vuint32_t RTW_SAME:3;
    vuint32_t _unused_15:1;
    vuint32_t tDAI:13;
    vuint32_t _unused_29:3;
  } B;
} MMDC_MDRWD_tag;

typedef union MMDC_MDOR_union_tag {    /* MMDC Core Out of Reset Delays Register */
  vuint32_t R;
  struct {
    vuint32_t RST_to_CKE:6;
    vuint32_t _unused_6:2;
    vuint32_t SDE_to_RST:6;
    vuint32_t _unused_14:2;
    vuint32_t tXPR:8;
    vuint32_t _unused_24:8;
  } B;
} MMDC_MDOR_tag;

typedef union MMDC_MDMRR_union_tag {   /* MMDC Core MRR Data Register */
  vuint32_t R;
  struct {
    vuint32_t MRR_READ_DATA0:8;
    vuint32_t MRR_READ_DATA1:8;
    vuint32_t MRR_READ_DATA2:8;
    vuint32_t MRR_READ_DATA3:8;
  } B;
} MMDC_MDMRR_tag;

typedef union MMDC_MDCFG3LP_union_tag { /* MMDC Core Timing Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t tRPab_LP:4;
    vuint32_t tRPpb_LP:4;
    vuint32_t tRCD_LP:4;
    vuint32_t _unused_12:4;
    vuint32_t RC_LP:6;
    vuint32_t _unused_22:10;
  } B;
} MMDC_MDCFG3LP_tag;

typedef union MMDC_MDMR4_union_tag {   /* MMDC Core MR4 Derating Register */
  vuint32_t R;
  struct {
    vuint32_t UPDATE_DE_REQ:1;
    vuint32_t UPDATE_DE_ACK:1;
    vuint32_t _unused_2:2;
    vuint32_t tRCD_DE:1;
    vuint32_t tRC_DE:1;
    vuint32_t tRAS_DE:1;
    vuint32_t tRP_DE:1;
    vuint32_t tRRD_DE:1;
    vuint32_t _unused_9:23;
  } B;
} MMDC_MDMR4_tag;

typedef union MMDC_MDASP_union_tag {   /* MMDC Core Address Space Partition Register */
  vuint32_t R;
  struct {
    vuint32_t CS0_END:7;
    vuint32_t _unused_7:25;
  } B;
} MMDC_MDASP_tag;

typedef union MMDC_MAARCR_union_tag {  /* MMDC Core AXI Reordering Control Regsiter */
  vuint32_t R;
  struct {
    vuint32_t ARCR_GUARD:4;
    vuint32_t ARCR_DYN_MAX:4;
    vuint32_t ARCR_DYN_JMP:4;
    vuint32_t _unused_12:4;
    vuint32_t ARCR_ACC_HIT:3;
    vuint32_t _unused_19:1;
    vuint32_t ARCR_PAG_HIT:3;
    vuint32_t _unused_23:1;
    vuint32_t ARCR_RCH_EN:1;
    vuint32_t _unused_25:3;
    vuint32_t ARCR_EXC_ERR_EN:1;
    vuint32_t _unused_29:1;
    vuint32_t ARCR_SEC_ERR_EN:1;
    vuint32_t ARCR_SEC_ERR_LOCK:1;
  } B;
} MMDC_MAARCR_tag;

typedef union MMDC_MAPSR_union_tag {   /* MMDC Core Power Saving Control and Status Register */
  vuint32_t R;
  struct {
    vuint32_t PSD:1;
    vuint32_t _unused_1:3;
    vuint32_t PSS:1;
    vuint32_t RIS:1;
    vuint32_t WIS:1;
    vuint32_t _unused_7:1;
    vuint32_t PST:8;
    vuint32_t _unused_16:4;
    vuint32_t LPMD:1;
    vuint32_t DVFS:1;
    vuint32_t _unused_22:2;
    vuint32_t LPACK:1;
    vuint32_t DVACK:1;
    vuint32_t _unused_26:6;
  } B;
} MMDC_MAPSR_tag;

typedef union MMDC_MAEXIDR0_union_tag { /* MMDC Core Exclusive ID Monitor Register0 */
  vuint32_t R;
  struct {
    vuint32_t EXC_ID_MONITOR0:16;
    vuint32_t EXC_ID_MONITOR1:16;
  } B;
} MMDC_MAEXIDR0_tag;

typedef union MMDC_MAEXIDR1_union_tag { /* MMDC Core Exclusive ID Monitor Register1 */
  vuint32_t R;
  struct {
    vuint32_t EXC_ID_MONITOR2:16;
    vuint32_t EXC_ID_MONITOR3:16;
  } B;
} MMDC_MAEXIDR1_tag;

typedef union MMDC_MADPCR0_union_tag { /* MMDC Core Debug and Profiling Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DBG_EN:1;
    vuint32_t DBG_RST:1;
    vuint32_t PRF_FRZ:1;
    vuint32_t CYC_OVF:1;
    vuint32_t _unused_4:4;
    vuint32_t SBS_EN:1;
    vuint32_t SBS:1;
    vuint32_t _unused_10:22;
  } B;
} MMDC_MADPCR0_tag;

typedef union MMDC_MADPCR1_union_tag { /* MMDC Core Debug and Profiling Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRF_AXI_ID:16;
    vuint32_t PRF_AXI_ID_MASK:16;
  } B;
} MMDC_MADPCR1_tag;

typedef union MMDC_MADPSR0_union_tag { /* MMDC Core Debug and Profiling Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CYC_COUNT:32;
  } B;
} MMDC_MADPSR0_tag;

typedef union MMDC_MADPSR1_union_tag { /* MMDC Core Debug and Profiling Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BUSY_COUNT:32;
  } B;
} MMDC_MADPSR1_tag;

typedef union MMDC_MADPSR2_union_tag { /* MMDC Core Debug and Profiling Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RD_ACC_COUNT:32;
  } B;
} MMDC_MADPSR2_tag;

typedef union MMDC_MADPSR3_union_tag { /* MMDC Core Debug and Profiling Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t WR_ACC_COUNT:32;
  } B;
} MMDC_MADPSR3_tag;

typedef union MMDC_MADPSR4_union_tag { /* MMDC Core Debug and Profiling Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t RD_BYTES_COUNT:32;
  } B;
} MMDC_MADPSR4_tag;

typedef union MMDC_MADPSR5_union_tag { /* MMDC Core Debug and Profiling Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t WR_BYTES_COUNT:32;
  } B;
} MMDC_MADPSR5_tag;

typedef union MMDC_MASBS0_union_tag {  /* MMDC Core Step By Step Address Register */
  vuint32_t R;
  struct {
    vuint32_t SBS_ADDR:32;
  } B;
} MMDC_MASBS0_tag;

typedef union MMDC_MASBS1_union_tag {  /* MMDC Core Step By Step Address Attributes Register */
  vuint32_t R;
  struct {
    vuint32_t SBS_VLD:1;
    vuint32_t SBS_TYPE:1;
    vuint32_t SBS_LOCK:2;
    vuint32_t SBS_PROT:3;
    vuint32_t SBS_SIZE:3;
    vuint32_t SBS_BURST:2;
    vuint32_t SBS_BUFF:1;
    vuint32_t SBS_LEN:3;
    vuint32_t SBS_AXI_ID:16;
  } B;
} MMDC_MASBS1_tag;

typedef union MMDC_MAGENP_union_tag {  /* MMDC Core General Purpose Register */
  vuint32_t R;
  struct {
    vuint32_t GP31_GP0:32;
  } B;
} MMDC_MAGENP_tag;

typedef union MMDC_MPZQHWCTRL_union_tag { /* MMDC PHY ZQ HW control register */
  vuint32_t R;
  struct {
    vuint32_t ZQ_MODE:2;
    vuint32_t ZQ_HW_PER:4;
    vuint32_t ZQ_HW_PU_RES:5;
    vuint32_t ZQ_HW_PD_RES:5;
    vuint32_t ZQ_HW_FOR:1;
    vuint32_t TZQ_INIT:3;
    vuint32_t TZQ_OPER:3;
    vuint32_t TZQ_CS:3;
    vuint32_t _unused_26:1;
    vuint32_t ZQ_EARLY_COMPARATOR_EN_TIMER:5;
  } B;
} MMDC_MPZQHWCTRL_tag;

typedef union MMDC_MPZQSWCTRL_union_tag { /* MMDC PHY ZQ SW control register */
  vuint32_t R;
  struct {
    vuint32_t ZQ_SW_FOR:1;
    vuint32_t ZQ_SW_RES:1;
    vuint32_t ZQ_SW_PU_VAL:5;
    vuint32_t ZQ_SW_PD_VAL:5;
    vuint32_t ZQ_SW_PD:1;
    vuint32_t USE_ZQ_SW_VAL:1;
    vuint32_t _unused_14:2;
    vuint32_t ZQ_CMP_OUT_SMP:2;
    vuint32_t _unused_18:14;
  } B;
} MMDC_MPZQSWCTRL_tag;

typedef union MMDC_MPWLGCR_union_tag { /* MMDC PHY Write Leveling Configuration and Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t HW_WL_EN:1;
    vuint32_t SW_WL_EN:1;
    vuint32_t SW_WL_CNT_EN:1;
    vuint32_t _unused_3:1;
    vuint32_t WL_SW_RES0:1;
    vuint32_t WL_SW_RES1:1;
    vuint32_t WL_SW_RES2:1;
    vuint32_t WL_SW_RES3:1;
    vuint32_t WL_HW_ERR0:1;
    vuint32_t WL_HW_ERR1:1;
    vuint32_t WL_HW_ERR2:1;
    vuint32_t WL_HW_ERR3:1;
    vuint32_t _unused_12:20;
  } B;
} MMDC_MPWLGCR_tag;

typedef union MMDC_MPWLDECTRL0_union_tag { /* MMDC PHY Write Leveling Delay Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WL_DL_ABS_OFFSET0:7;
    vuint32_t _unused_7:1;
    vuint32_t WL_HC_DEL0:1;
    vuint32_t WL_CYC_DEL0:2;
    vuint32_t _unused_11:5;
    vuint32_t WL_DL_ABS_OFFSET1:7;
    vuint32_t _unused_23:1;
    vuint32_t WL_HC_DEL1:1;
    vuint32_t WL_CYC_DEL1:2;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPWLDECTRL0_tag;

typedef union MMDC_MPWLDECTRL1_union_tag { /* MMDC PHY Write Leveling Delay Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WL_DL_ABS_OFFSET2:7;
    vuint32_t _unused_7:1;
    vuint32_t WL_HC_DEL2:1;
    vuint32_t WL_CYC_DEL2:2;
    vuint32_t _unused_11:5;
    vuint32_t WL_DL_ABS_OFFSET3:7;
    vuint32_t _unused_23:1;
    vuint32_t WL_HC_DEL3:1;
    vuint32_t WL_CYC_DEL3:2;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPWLDECTRL1_tag;

typedef union MMDC_MPWLDLST_union_tag { /* MMDC PHY Write Leveling delay-line Status Register */
  vuint32_t R;
  struct {
    vuint32_t WL_DL_UNIT_NUM0:7;
    vuint32_t _unused_7:1;
    vuint32_t WL_DL_UNIT_NUM1:7;
    vuint32_t _unused_15:1;
    vuint32_t WL_DL_UNIT_NUM2:7;
    vuint32_t _unused_23:1;
    vuint32_t WL_DL_UNIT_NUM3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPWLDLST_tag;

typedef union MMDC_MPODTCTRL_union_tag { /* MMDC PHY ODT control register */
  vuint32_t R;
  struct {
    vuint32_t ODT_WR_PAS_EN:1;
    vuint32_t ODT_WR_ACT_EN:1;
    vuint32_t ODT_RD_PAS_EN:1;
    vuint32_t ODT_RD_ACT_EN:1;
    vuint32_t ODT0_INT_RES:3;
    vuint32_t _unused_7:1;
    vuint32_t ODT1_INT_RES:3;
    vuint32_t _unused_11:1;
    vuint32_t ODT2_INT_RES:3;
    vuint32_t _unused_15:1;
    vuint32_t ODT3_INT_RES:3;
    vuint32_t _unused_19:13;
  } B;
} MMDC_MPODTCTRL_tag;

typedef union MMDC_MPRDDQBY0DL_union_tag { /* MMDC PHY Read DQ Byte0 Delay Register */
  vuint32_t R;
  struct {
    vuint32_t rd_dq0_del:3;
    vuint32_t _unused_3:1;
    vuint32_t rd_dq1_del:3;
    vuint32_t _unused_7:1;
    vuint32_t rd_dq2_del:3;
    vuint32_t _unused_11:1;
    vuint32_t rd_dq3_del:3;
    vuint32_t _unused_15:1;
    vuint32_t rd_dq4_del:3;
    vuint32_t _unused_19:1;
    vuint32_t rd_dq5_del:3;
    vuint32_t _unused_23:1;
    vuint32_t rd_dq6_del:3;
    vuint32_t _unused_27:1;
    vuint32_t rd_dq7_del:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDQBY0DL_tag;

typedef union MMDC_MPRDDQBY1DL_union_tag { /* MMDC PHY Read DQ Byte1 Delay Register */
  vuint32_t R;
  struct {
    vuint32_t rd_dq8_del:3;
    vuint32_t _unused_3:1;
    vuint32_t rd_dq9_del:3;
    vuint32_t _unused_7:1;
    vuint32_t rd_dq10_del:3;
    vuint32_t _unused_11:1;
    vuint32_t rd_dq11_del:3;
    vuint32_t _unused_15:1;
    vuint32_t rd_dq12_del:3;
    vuint32_t _unused_19:1;
    vuint32_t rd_dq13_del:3;
    vuint32_t _unused_23:1;
    vuint32_t rd_dq14_del:3;
    vuint32_t _unused_27:1;
    vuint32_t rd_dq15_del:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDQBY1DL_tag;

typedef union MMDC_MPRDDQBY2DL_union_tag { /* MMDC PHY Read DQ Byte2 Delay Register */
  vuint32_t R;
  struct {
    vuint32_t rd_dq16_del:3;
    vuint32_t _unused_3:1;
    vuint32_t rd_dq17_del:3;
    vuint32_t _unused_7:1;
    vuint32_t rd_dq18_del:3;
    vuint32_t _unused_11:1;
    vuint32_t rd_dq19_del:3;
    vuint32_t _unused_15:1;
    vuint32_t rd_dq20_del:3;
    vuint32_t _unused_19:1;
    vuint32_t rd_dq21_del:3;
    vuint32_t _unused_23:1;
    vuint32_t rd_dq22_del:3;
    vuint32_t _unused_27:1;
    vuint32_t rd_dq23_del:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDQBY2DL_tag;

typedef union MMDC_MPRDDQBY3DL_union_tag { /* MMDC PHY Read DQ Byte3 Delay Register */
  vuint32_t R;
  struct {
    vuint32_t rd_dq24_del:3;
    vuint32_t _unused_3:1;
    vuint32_t rd_dq25_del:3;
    vuint32_t _unused_7:1;
    vuint32_t rd_dq26_del:3;
    vuint32_t _unused_11:1;
    vuint32_t rd_dq27_del:3;
    vuint32_t _unused_15:1;
    vuint32_t rd_dq28_del:3;
    vuint32_t _unused_19:1;
    vuint32_t rd_dq29_del:3;
    vuint32_t _unused_23:1;
    vuint32_t rd_dq30_del:3;
    vuint32_t _unused_27:1;
    vuint32_t rd_dq31_del:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDQBY3DL_tag;

typedef union MMDC_MPDGCTRL0_union_tag { /* MMDC PHY Read DQS Gating Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DG_DL_ABS_OFFSET0:7;
    vuint32_t _unused_7:1;
    vuint32_t DG_HC_DEL0:4;
    vuint32_t HW_DG_ERR:1;
    vuint32_t _unused_13:3;
    vuint32_t DG_DL_ABS_OFFSET1:7;
    vuint32_t DG_EXT_UP:1;
    vuint32_t DG_HC_DEL1:4;
    vuint32_t HW_DG_EN:1;
    vuint32_t DG_DIS:1;
    vuint32_t DG_CMP_CYC:1;
    vuint32_t RST_RD_FIFO:1;
  } B;
} MMDC_MPDGCTRL0_tag;

typedef union MMDC_MPDGCTRL1_union_tag { /* MMDC PHY Read DQS Gating Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DG_DL_ABS_OFFSET2:7;
    vuint32_t _unused_7:1;
    vuint32_t DG_HC_DEL2:4;
    vuint32_t _unused_12:4;
    vuint32_t DG_DL_ABS_OFFSET3:7;
    vuint32_t _unused_23:1;
    vuint32_t DG_HC_DEL3:4;
    vuint32_t _unused_28:4;
  } B;
} MMDC_MPDGCTRL1_tag;

typedef union MMDC_MPDGDLST0_union_tag { /* MMDC PHY Read DQS Gating delay-line Status Register */
  vuint32_t R;
  struct {
    vuint32_t DG_DL_UNIT_NUM0:7;
    vuint32_t _unused_7:1;
    vuint32_t DG_DL_UNIT_NUM1:7;
    vuint32_t _unused_15:1;
    vuint32_t DG_DL_UNIT_NUM2:7;
    vuint32_t _unused_23:1;
    vuint32_t DG_DL_UNIT_NUM3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPDGDLST0_tag;

typedef union MMDC_MPRDDLCTL_union_tag { /* MMDC PHY Read delay-lines Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RD_DL_ABS_OFFSET0:7;
    vuint32_t _unused_7:1;
    vuint32_t RD_DL_ABS_OFFSET1:7;
    vuint32_t _unused_15:1;
    vuint32_t RD_DL_ABS_OFFSET2:7;
    vuint32_t _unused_23:1;
    vuint32_t RD_DL_ABS_OFFSET3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDLCTL_tag;

typedef union MMDC_MPRDDLST_union_tag { /* MMDC PHY Read delay-lines Status Register */
  vuint32_t R;
  struct {
    vuint32_t RD_DL_UNIT_NUM0:7;
    vuint32_t _unused_7:1;
    vuint32_t RD_DL_UNIT_NUM1:7;
    vuint32_t _unused_15:1;
    vuint32_t RD_DL_UNIT_NUM2:7;
    vuint32_t _unused_23:1;
    vuint32_t RD_DL_UNIT_NUM3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDLST_tag;

typedef union MMDC_MPWRDLCTL_union_tag { /* MMDC PHY Write delay-lines Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t WR_DL_ABS_OFFSET0:7;
    vuint32_t _unused_7:1;
    vuint32_t WR_DL_ABS_OFFSET1:7;
    vuint32_t _unused_15:1;
    vuint32_t WR_DL_ABS_OFFSET2:7;
    vuint32_t _unused_23:1;
    vuint32_t WR_DL_ABS_OFFSET3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPWRDLCTL_tag;

typedef union MMDC_MPWRDLST_union_tag { /* MMDC PHY Write delay-lines Status Register */
  vuint32_t R;
  struct {
    vuint32_t WR_DL_UNIT_NUM0:7;
    vuint32_t _unused_7:1;
    vuint32_t WR_DL_UNIT_NUM1:7;
    vuint32_t _unused_15:1;
    vuint32_t WR_DL_UNIT_NUM2:7;
    vuint32_t _unused_23:1;
    vuint32_t WR_DL_UNIT_NUM3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPWRDLST_tag;

typedef union MMDC_MPZQLP2CTL_union_tag { /* MMDC ZQ LPDDR2 HW Control Register */
  vuint32_t R;
  struct {
    vuint32_t ZQ_LP2_HW_ZQINIT:9;
    vuint32_t _unused_9:7;
    vuint32_t ZQ_LP2_HW_ZQCL:8;
    vuint32_t ZQ_LP2_HW_ZQCS:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPZQLP2CTL_tag;

typedef union MMDC_MPRDDLHWCTL_union_tag { /* MMDC PHY Read Delay HW Calibration Control Register */
  vuint32_t R;
  struct {
    vuint32_t HW_RD_DL_ERR0:1;
    vuint32_t HW_RD_DL_ERR1:1;
    vuint32_t HW_RD_DL_ERR2:1;
    vuint32_t HW_RD_DL_ERR3:1;
    vuint32_t HW_RD_DL_EN:1;
    vuint32_t HW_RD_DL_CMP_CYC:1;
    vuint32_t _unused_6:26;
  } B;
} MMDC_MPRDDLHWCTL_tag;

typedef union MMDC_MPWRDLHWCTL_union_tag { /* MMDC PHY Write Delay HW Calibration Control Register */
  vuint32_t R;
  struct {
    vuint32_t HW_WR_DL_ERR0:1;
    vuint32_t HW_WR_DL_ERR1:1;
    vuint32_t HW_WR_DL_ERR2:1;
    vuint32_t HW_WR_DL_ERR3:1;
    vuint32_t HW_WR_DL_EN:1;
    vuint32_t HW_WR_DL_CMP_CYC:1;
    vuint32_t _unused_6:26;
  } B;
} MMDC_MPWRDLHWCTL_tag;

typedef union MMDC_MPRDDLHWST0_union_tag { /* MMDC PHY Read Delay HW Calibration Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t HW_RD_DL_LOW0:7;
    vuint32_t _unused_7:1;
    vuint32_t HW_RD_DL_UP0:7;
    vuint32_t _unused_15:1;
    vuint32_t HW_RD_DL_LOW1:7;
    vuint32_t _unused_23:1;
    vuint32_t HW_RD_DL_UP1:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDLHWST0_tag;

typedef union MMDC_MPRDDLHWST1_union_tag { /* MMDC PHY Read Delay HW Calibration Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t HW_RD_DL_LOW2:7;
    vuint32_t _unused_7:1;
    vuint32_t HW_RD_DL_UP2:7;
    vuint32_t _unused_15:1;
    vuint32_t HW_RD_DL_LOW3:7;
    vuint32_t _unused_23:1;
    vuint32_t HW_RD_DL_UP3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPRDDLHWST1_tag;

typedef union MMDC_MPWRDLHWST0_union_tag { /* MMDC PHY Write Delay HW Calibration Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t HW_WR_DL_LOW0:7;
    vuint32_t _unused_7:1;
    vuint32_t HW_WR_DL_UP0:7;
    vuint32_t _unused_15:1;
    vuint32_t HW_WR_DL_LOW1:7;
    vuint32_t _unused_23:1;
    vuint32_t HW_WR_DL_UP1:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPWRDLHWST0_tag;

typedef union MMDC_MPWRDLHWST1_union_tag { /* MMDC PHY Write Delay HW Calibration Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t HW_WR_DL_LOW2:7;
    vuint32_t _unused_7:1;
    vuint32_t HW_WR_DL_UP2:7;
    vuint32_t _unused_15:1;
    vuint32_t HW_WR_DL_LOW3:7;
    vuint32_t _unused_23:1;
    vuint32_t HW_WR_DL_UP3:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPWRDLHWST1_tag;

typedef union MMDC_MPWLHWERR_union_tag { /* MMDC PHY Write Leveling HW Error Register */
  vuint32_t R;
  struct {
    vuint32_t HW_WL0_DQ:8;
    vuint32_t HW_WL1_DQ:8;
    vuint32_t HW_WL2_DQ:8;
    vuint32_t HW_WL3_DQ:8;
  } B;
} MMDC_MPWLHWERR_tag;

typedef union MMDC_MPDGHWST0_union_tag { /* MMDC PHY Read DQS Gating HW Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t HW_DG_LOW0:11;
    vuint32_t _unused_11:5;
    vuint32_t HW_DG_UP0:11;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPDGHWST0_tag;

typedef union MMDC_MPDGHWST1_union_tag { /* MMDC PHY Read DQS Gating HW Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t HW_DG_LOW1:11;
    vuint32_t _unused_11:5;
    vuint32_t HW_DG_UP1:11;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPDGHWST1_tag;

typedef union MMDC_MPDGHWST2_union_tag { /* MMDC PHY Read DQS Gating HW Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t HW_DG_LOW2:11;
    vuint32_t _unused_11:5;
    vuint32_t HW_DG_UP2:11;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPDGHWST2_tag;

typedef union MMDC_MPDGHWST3_union_tag { /* MMDC PHY Read DQS Gating HW Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t HW_DG_LOW3:11;
    vuint32_t _unused_11:5;
    vuint32_t HW_DG_UP3:11;
    vuint32_t _unused_27:5;
  } B;
} MMDC_MPDGHWST3_tag;

typedef union MMDC_MPPDCMPR1_union_tag { /* MMDC PHY Pre-defined Compare Register 1 */
  vuint32_t R;
  struct {
    vuint32_t PDV1:16;
    vuint32_t PDV2:16;
  } B;
} MMDC_MPPDCMPR1_tag;

typedef union MMDC_MPPDCMPR2_union_tag { /* MMDC PHY Pre-defined Compare and CA delay-line Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MPR_CMP:1;
    vuint32_t MPR_FULL_CMP:1;
    vuint32_t READ_LEVEL_PATTERN:1;
    vuint32_t _unused_3:13;
    vuint32_t CA_DL_ABS_OFFSET:7;
    vuint32_t _unused_23:1;
    vuint32_t PHY_CA_DL_UNIT:7;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPPDCMPR2_tag;

typedef union MMDC_MPSWDAR0_union_tag { /* MMDC PHY SW Dummy Access Register */
  vuint32_t R;
  struct {
    vuint32_t SW_DUMMY_WR:1;
    vuint32_t SW_DUMMY_RD:1;
    vuint32_t SW_DUM_CMP0:1;
    vuint32_t SW_DUM_CMP1:1;
    vuint32_t SW_DUM_CMP2:1;
    vuint32_t SW_DUM_CMP3:1;
    vuint32_t _unused_6:26;
  } B;
} MMDC_MPSWDAR0_tag;

typedef union MMDC_MPSWDRDR0_union_tag { /* MMDC PHY SW Dummy Read Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD0:32;
  } B;
} MMDC_MPSWDRDR0_tag;

typedef union MMDC_MPSWDRDR1_union_tag { /* MMDC PHY SW Dummy Read Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD1:32;
  } B;
} MMDC_MPSWDRDR1_tag;

typedef union MMDC_MPSWDRDR2_union_tag { /* MMDC PHY SW Dummy Read Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD2:32;
  } B;
} MMDC_MPSWDRDR2_tag;

typedef union MMDC_MPSWDRDR3_union_tag { /* MMDC PHY SW Dummy Read Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD3:32;
  } B;
} MMDC_MPSWDRDR3_tag;

typedef union MMDC_MPSWDRDR4_union_tag { /* MMDC PHY SW Dummy Read Data Register 4 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD4:32;
  } B;
} MMDC_MPSWDRDR4_tag;

typedef union MMDC_MPSWDRDR5_union_tag { /* MMDC PHY SW Dummy Read Data Register 5 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD5:32;
  } B;
} MMDC_MPSWDRDR5_tag;

typedef union MMDC_MPSWDRDR6_union_tag { /* MMDC PHY SW Dummy Read Data Register 6 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD6:32;
  } B;
} MMDC_MPSWDRDR6_tag;

typedef union MMDC_MPSWDRDR7_union_tag { /* MMDC PHY SW Dummy Read Data Register 7 */
  vuint32_t R;
  struct {
    vuint32_t DUM_RD7:32;
  } B;
} MMDC_MPSWDRDR7_tag;

typedef union MMDC_MPMUR0_union_tag {  /* MMDC PHY Measure Unit Register */
  vuint32_t R;
  struct {
    vuint32_t MU_BYP_VAL:10;
    vuint32_t MU_BYP_EN:1;
    vuint32_t FRC_MSR:1;
    vuint32_t _unused_12:4;
    vuint32_t MU_UNIT_DEL_NUM:10;
    vuint32_t _unused_26:6;
  } B;
} MMDC_MPMUR0_tag;

typedef union MMDC_MPDCCR_union_tag {  /* MMDC Duty Cycle Control Register */
  vuint32_t R;
  struct {
    vuint32_t WR_DQS0_FT_DCC:3;
    vuint32_t WR_DQS1_FT_DCC:3;
    vuint32_t WR_DQS2_FT_DCC:3;
    vuint32_t WR_DQS3_FT_DCC:3;
    vuint32_t CK_FT0_DCC:3;
    vuint32_t _unused_15:1;
    vuint32_t CK_FT1_DCC:3;
    vuint32_t RD_DQS0_FT_DCC:3;
    vuint32_t RD_DQS1_FT_DCC:3;
    vuint32_t RD_DQS2_FT_DCC:3;
    vuint32_t RD_DQS3_FT_DCC:3;
    vuint32_t _unused_31:1;
  } B;
} MMDC_MPDCCR_tag;

struct MMDC_tag {
  MMDC_MDCTL_tag MDCTL;                /* MMDC Core Control Register */
  MMDC_MDPDC_tag MDPDC;                /* MMDC Core Power Down Control Register */
  MMDC_MDOTC_tag MDOTC;                /* MMDC Core ODT Timing Control Register */
  MMDC_MDCFG0_tag MDCFG0;              /* MMDC Core Timing Configuration Register 0 */
  MMDC_MDCFG1_tag MDCFG1;              /* MMDC Core Timing Configuration Register 1 */
  MMDC_MDCFG2_tag MDCFG2;              /* MMDC Core Timing Configuration Register 2 */
  MMDC_MDMISC_tag MDMISC;              /* MMDC Core Miscellaneous Register */
  MMDC_MDSCR_tag MDSCR;                /* MMDC Core Special Command Register */
  MMDC_MDREF_tag MDREF;                /* MMDC Core Refresh Control Register */
  uint8_t MMDC_reserved0[8];
  MMDC_MDRWD_tag MDRWD;                /* MMDC Core Read/Write Command Delay Register */
  MMDC_MDOR_tag MDOR;                  /* MMDC Core Out of Reset Delays Register */
  MMDC_MDMRR_tag MDMRR;                /* MMDC Core MRR Data Register */
  MMDC_MDCFG3LP_tag MDCFG3LP;          /* MMDC Core Timing Configuration Register 3 */
  MMDC_MDMR4_tag MDMR4;                /* MMDC Core MR4 Derating Register */
  MMDC_MDASP_tag MDASP;                /* MMDC Core Address Space Partition Register */
  uint8_t MMDC_reserved1[956];
  MMDC_MAARCR_tag MAARCR;              /* MMDC Core AXI Reordering Control Regsiter */
  MMDC_MAPSR_tag MAPSR;                /* MMDC Core Power Saving Control and Status Register */
  MMDC_MAEXIDR0_tag MAEXIDR0;          /* MMDC Core Exclusive ID Monitor Register0 */
  MMDC_MAEXIDR1_tag MAEXIDR1;          /* MMDC Core Exclusive ID Monitor Register1 */
  MMDC_MADPCR0_tag MADPCR0;            /* MMDC Core Debug and Profiling Control Register 0 */
  MMDC_MADPCR1_tag MADPCR1;            /* MMDC Core Debug and Profiling Control Register 1 */
  MMDC_MADPSR0_tag MADPSR0;            /* MMDC Core Debug and Profiling Status Register 0 */
  MMDC_MADPSR1_tag MADPSR1;            /* MMDC Core Debug and Profiling Status Register 1 */
  MMDC_MADPSR2_tag MADPSR2;            /* MMDC Core Debug and Profiling Status Register 2 */
  MMDC_MADPSR3_tag MADPSR3;            /* MMDC Core Debug and Profiling Status Register 3 */
  MMDC_MADPSR4_tag MADPSR4;            /* MMDC Core Debug and Profiling Status Register 4 */
  MMDC_MADPSR5_tag MADPSR5;            /* MMDC Core Debug and Profiling Status Register 5 */
  MMDC_MASBS0_tag MASBS0;              /* MMDC Core Step By Step Address Register */
  MMDC_MASBS1_tag MASBS1;              /* MMDC Core Step By Step Address Attributes Register */
  uint8_t MMDC_reserved2[8];
  MMDC_MAGENP_tag MAGENP;              /* MMDC Core General Purpose Register */
  uint8_t MMDC_reserved3[956];
  MMDC_MPZQHWCTRL_tag MPZQHWCTRL;      /* MMDC PHY ZQ HW control register */
  MMDC_MPZQSWCTRL_tag MPZQSWCTRL;      /* MMDC PHY ZQ SW control register */
  MMDC_MPWLGCR_tag MPWLGCR;            /* MMDC PHY Write Leveling Configuration and Error Status Register */
  MMDC_MPWLDECTRL0_tag MPWLDECTRL0;    /* MMDC PHY Write Leveling Delay Control Register 0 */
  MMDC_MPWLDECTRL1_tag MPWLDECTRL1;    /* MMDC PHY Write Leveling Delay Control Register 1 */
  MMDC_MPWLDLST_tag MPWLDLST;          /* MMDC PHY Write Leveling delay-line Status Register */
  MMDC_MPODTCTRL_tag MPODTCTRL;        /* MMDC PHY ODT control register */
  MMDC_MPRDDQBY0DL_tag MPRDDQBY0DL;    /* MMDC PHY Read DQ Byte0 Delay Register */
  MMDC_MPRDDQBY1DL_tag MPRDDQBY1DL;    /* MMDC PHY Read DQ Byte1 Delay Register */
  MMDC_MPRDDQBY2DL_tag MPRDDQBY2DL;    /* MMDC PHY Read DQ Byte2 Delay Register */
  MMDC_MPRDDQBY3DL_tag MPRDDQBY3DL;    /* MMDC PHY Read DQ Byte3 Delay Register */
  uint8_t MMDC_reserved4[16];
  MMDC_MPDGCTRL0_tag MPDGCTRL0;        /* MMDC PHY Read DQS Gating Control Register 0 */
  MMDC_MPDGCTRL1_tag MPDGCTRL1;        /* MMDC PHY Read DQS Gating Control Register 1 */
  MMDC_MPDGDLST0_tag MPDGDLST0;        /* MMDC PHY Read DQS Gating delay-line Status Register */
  MMDC_MPRDDLCTL_tag MPRDDLCTL;        /* MMDC PHY Read delay-lines Configuration Register */
  MMDC_MPRDDLST_tag MPRDDLST;          /* MMDC PHY Read delay-lines Status Register */
  MMDC_MPWRDLCTL_tag MPWRDLCTL;        /* MMDC PHY Write delay-lines Configuration Register */
  MMDC_MPWRDLST_tag MPWRDLST;          /* MMDC PHY Write delay-lines Status Register */
  uint8_t MMDC_reserved5[4];
  MMDC_MPZQLP2CTL_tag MPZQLP2CTL;      /* MMDC ZQ LPDDR2 HW Control Register */
  MMDC_MPRDDLHWCTL_tag MPRDDLHWCTL;    /* MMDC PHY Read Delay HW Calibration Control Register */
  MMDC_MPWRDLHWCTL_tag MPWRDLHWCTL;    /* MMDC PHY Write Delay HW Calibration Control Register */
  MMDC_MPRDDLHWST0_tag MPRDDLHWST0;    /* MMDC PHY Read Delay HW Calibration Status Register 0 */
  MMDC_MPRDDLHWST1_tag MPRDDLHWST1;    /* MMDC PHY Read Delay HW Calibration Status Register 1 */
  MMDC_MPWRDLHWST0_tag MPWRDLHWST0;    /* MMDC PHY Write Delay HW Calibration Status Register 0 */
  MMDC_MPWRDLHWST1_tag MPWRDLHWST1;    /* MMDC PHY Write Delay HW Calibration Status Register 1 */
  MMDC_MPWLHWERR_tag MPWLHWERR;        /* MMDC PHY Write Leveling HW Error Register */
  MMDC_MPDGHWST0_tag MPDGHWST0;        /* MMDC PHY Read DQS Gating HW Status Register 0 */
  MMDC_MPDGHWST1_tag MPDGHWST1;        /* MMDC PHY Read DQS Gating HW Status Register 1 */
  MMDC_MPDGHWST2_tag MPDGHWST2;        /* MMDC PHY Read DQS Gating HW Status Register 2 */
  MMDC_MPDGHWST3_tag MPDGHWST3;        /* MMDC PHY Read DQS Gating HW Status Register 3 */
  MMDC_MPPDCMPR1_tag MPPDCMPR1;        /* MMDC PHY Pre-defined Compare Register 1 */
  MMDC_MPPDCMPR2_tag MPPDCMPR2;        /* MMDC PHY Pre-defined Compare and CA delay-line Configuration Register */
  MMDC_MPSWDAR0_tag MPSWDAR0;          /* MMDC PHY SW Dummy Access Register */
  MMDC_MPSWDRDR0_tag MPSWDRDR0;        /* MMDC PHY SW Dummy Read Data Register 0 */
  MMDC_MPSWDRDR1_tag MPSWDRDR1;        /* MMDC PHY SW Dummy Read Data Register 1 */
  MMDC_MPSWDRDR2_tag MPSWDRDR2;        /* MMDC PHY SW Dummy Read Data Register 2 */
  MMDC_MPSWDRDR3_tag MPSWDRDR3;        /* MMDC PHY SW Dummy Read Data Register 3 */
  MMDC_MPSWDRDR4_tag MPSWDRDR4;        /* MMDC PHY SW Dummy Read Data Register 4 */
  MMDC_MPSWDRDR5_tag MPSWDRDR5;        /* MMDC PHY SW Dummy Read Data Register 5 */
  MMDC_MPSWDRDR6_tag MPSWDRDR6;        /* MMDC PHY SW Dummy Read Data Register 6 */
  MMDC_MPSWDRDR7_tag MPSWDRDR7;        /* MMDC PHY SW Dummy Read Data Register 7 */
  MMDC_MPMUR0_tag MPMUR0;              /* MMDC PHY Measure Unit Register */
  uint8_t MMDC_reserved6[4];
  MMDC_MPDCCR_tag MPDCCR;              /* MMDC Duty Cycle Control Register */
};


/* ============================================================================
   =============================== Module: MSCM ===============================
   ============================================================================ */

typedef union MSCM_CPXTYPE_union_tag { /* Processor x Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CPXTYPE_tag;

typedef union MSCM_CPXNUM_union_tag {  /* Processor x Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CPXNUM_tag;

typedef union MSCM_CPXMASTER_union_tag { /* Processor x Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CPXMASTER_tag;

typedef union MSCM_CPXCOUNT_union_tag { /* Processor x Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CPXCOUNT_tag;

typedef union MSCM_CPXCFG0_union_tag { /* Processor x Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CPXCFG0_tag;

typedef union MSCM_CPXCFG1_union_tag { /* Processor x Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CPXCFG1_tag;

typedef union MSCM_CPXCFG2_union_tag { /* Processor x Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CPXCFG2_tag;

typedef union MSCM_CPXCFG3_union_tag { /* Processor x Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CPXCFG3_tag;

typedef union MSCM_CP0TYPE_union_tag { /* Processor 0 Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CP0TYPE_tag;

typedef union MSCM_CP0NUM_union_tag {  /* Processor 0 Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP0NUM_tag;

typedef union MSCM_CP0MASTER_union_tag { /* Processor 0 Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CP0MASTER_tag;

typedef union MSCM_CP0COUNT_union_tag { /* Processor 0 Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP0COUNT_tag;

typedef union MSCM_CP0CFG0_union_tag { /* Processor 0 Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CP0CFG0_tag;

typedef union MSCM_CP0CFG1_union_tag { /* Processor 0 Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CP0CFG1_tag;

typedef union MSCM_CP0CFG2_union_tag { /* Processor 0 Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CP0CFG2_tag;

typedef union MSCM_CP0CFG3_union_tag { /* Processor 0 Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CP0CFG3_tag;

typedef union MSCM_CP1TYPE_union_tag { /* Processor 1 Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CP1TYPE_tag;

typedef union MSCM_CP1NUM_union_tag {  /* Processor 1 Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP1NUM_tag;

typedef union MSCM_CP1MASTER_union_tag { /* Processor 1 Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CP1MASTER_tag;

typedef union MSCM_CP1COUNT_union_tag { /* Processor 1 Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP1COUNT_tag;

typedef union MSCM_CP1CFG0_union_tag { /* Processor 1 Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CP1CFG0_tag;

typedef union MSCM_CP1CFG1_union_tag { /* Processor 1 Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CP1CFG1_tag;

typedef union MSCM_CP1CFG2_union_tag { /* Processor 1 Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CP1CFG2_tag;

typedef union MSCM_CP1CFG3_union_tag { /* Processor 1 Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CP1CFG3_tag;

typedef union MSCM_OCMDR_OCMDR_union_tag { /* On-Chip Memory Descriptor Register */
  vuint32_t R;
  struct {
    vuint32_t OCMC0:4;
    vuint32_t OCMC1:4;
    vuint32_t OCMC2:4;
    vuint32_t OCMPU:1;
    vuint32_t OCMTZ:1;
    vuint32_t OCMT:2;
    vuint32_t RO:1;
    vuint32_t OCMW:3;
    vuint32_t _unused_20:4;
    vuint32_t OCMSZ:4;
    vuint32_t OCMSZH:1;
    vuint32_t _unused_29:2;
    vuint32_t V:1;
  } B;
} MSCM_OCMDR_OCMDR_tag;

typedef struct MSCM_OCMDR_struct_tag {
  MSCM_OCMDR_OCMDR_tag OCMDR;          /* On-Chip Memory Descriptor Register */
  uint8_t OCMDR_reserved0[8];
} MSCM_OCMDR_tag;

typedef union MSCM_TCMDR0_union_tag {  /* Generic Tightly Coupled Memory Descriptor Register */
  vuint32_t R;
  struct {
    vuint32_t TCMC0:4;
    vuint32_t _unused_4:4;
    vuint32_t _unused_8:4;
    vuint32_t TCMPU:1;
    vuint32_t TCMTZ:1;
    vuint32_t _unused_14:2;
    vuint32_t RO:1;
    vuint32_t TCMW:3;
    vuint32_t TCMLSZ:4;
    vuint32_t TCMUSZ:4;
    vuint32_t _unused_28:3;
    vuint32_t V:1;
  } B;
} MSCM_TCMDR0_tag;

typedef union MSCM_CPCE0_union_tag {   /* Core Parity Checking Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CPRE_M0:1;
    vuint32_t _unused_1:3;
    vuint32_t CPRE_M4:1;
    vuint32_t CPRE_M5:1;
    vuint32_t _unused_6:2;
    vuint32_t CPRE_M8:1;
    vuint32_t CPRE_M9:1;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CPCE0_tag;

typedef union MSCM_IRCP0IR_union_tag { /* Interrupt Router CP0 Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;
    vuint32_t INT1:1;
    vuint32_t INT2:1;
    vuint32_t INT3:1;
    vuint32_t _unused_4:28;
  } B;
} MSCM_IRCP0IR_tag;

typedef union MSCM_IRCP1IR_union_tag { /* Interrupt Router CP1 Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;
    vuint32_t INT1:1;
    vuint32_t INT2:1;
    vuint32_t INT3:1;
    vuint32_t _unused_4:28;
  } B;
} MSCM_IRCP1IR_tag;

typedef union MSCM_IRCPGIR_union_tag { /* Interrupt Router CPU Generate Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INTID:2;
    vuint32_t _unused_2:14;
    vuint32_t CPUTL:2;
    vuint32_t _unused_18:6;
    vuint32_t TLF:2;
    vuint32_t _unused_26:6;
  } B;
} MSCM_IRCPGIR_tag;

typedef union MSCM_IRSPRC_union_tag {  /* Interrupt Router Shared Peripheral Routing Control Register */
  vuint16_t R;
  struct {
    vuint16_t CP0E:1;
    vuint16_t CP1E:1;
    vuint16_t _unused_2:13;
    vuint16_t RO:1;
  } B;
} MSCM_IRSPRC_tag;

typedef union MSCM_IPCGE_union_tag {   /* Interconnect Parity Checking Global Enable Register */
  vuint32_t R;
  struct {
    vuint32_t GE:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_IPCGE_tag;

typedef union MSCM_IPCE0_union_tag {   /* Interconnect Parity Checking Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t IPRE_M2:1;
    vuint32_t IPRE_M3:1;
    vuint32_t IPRE_M4:1;
    vuint32_t IPRE_M5:1;
    vuint32_t IPRE_M6:1;
    vuint32_t IPRE_M7:1;
    vuint32_t IPRE_M8:1;
    vuint32_t IPRE_M9:1;
    vuint32_t IPRE_M10:1;
    vuint32_t IPRE_M11:1;
    vuint32_t IPRE_M12:1;
    vuint32_t IPRE_M13:1;
    vuint32_t IPRE_M14:1;
    vuint32_t IPRE_M15:1;
    vuint32_t IPRE_M16:1;
    vuint32_t IPRE_M17:1;
    vuint32_t IPRE_M18:1;
    vuint32_t IPRE_M19:1;
    vuint32_t IPRE_M20:1;
    vuint32_t IPRE_M21:1;
    vuint32_t IPRE_M22:1;
    vuint32_t IPRE_M23:1;
    vuint32_t IPRE_M24:1;
    vuint32_t IPRE_M25:1;
    vuint32_t IPRE_M26:1;
    vuint32_t IPRE_CCI_M0:1;           /* CCI Interconnect Parity read data checking enable for Cortex-A53 cluster 0 */
    vuint32_t IPRE_CCI_M1:1;           /* CCI Interconnect Parity read data checking enable for Cortex-A53 cluster 1 */
    vuint32_t _unused_29:3;
  } B;
} MSCM_IPCE0_tag;

typedef union MSCM_IPCE1_union_tag {   /* Interconnect Parity Checking Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t IPWE_S0:1;
    vuint32_t IPWE_S1:1;
    vuint32_t IPWE_S2:1;
    vuint32_t IPWE_S3:1;
    vuint32_t IPWE_S4:1;
    vuint32_t IPWE_S5:1;
    vuint32_t IPWE_S6:1;
    vuint32_t IPWE_S7:1;
    vuint32_t IPWE_S8:1;
    vuint32_t IPWE_S9:1;
    vuint32_t IPWE_S10:1;
    vuint32_t IPWE_S11:1;
    vuint32_t IPWE_S12:1;
    vuint32_t IPWE_S13:1;
    vuint32_t IPWE_S14:1;
    vuint32_t _unused_15:1;
    vuint32_t IPWE_S16:1;
    vuint32_t IPWE_S17:1;
    vuint32_t IPWE_S18:1;
    vuint32_t IPWE_S19:1;
    vuint32_t IPWE_S20:1;
    vuint32_t IPWE_S21:1;
    vuint32_t IPWE_CCI_S0:1;           /* CCI Interconnect Parity write data checking enable for CA53_CCI_0 */
    vuint32_t IPWE_CCI_S1:1;           /* CCI Interconnect Parity write data checking enable for CA53_CCI_1 */
    vuint32_t _unused_24:8;
  } B;
} MSCM_IPCE1_tag;

typedef union MSCM_IPCE2_union_tag {   /* Interconnect Parity Checking Enable Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IPRAE_S0:1;
    vuint32_t IPRAE_S1:1;
    vuint32_t IPRAE_S2:1;
    vuint32_t IPRAE_S3:1;
    vuint32_t IPRAE_S4:1;
    vuint32_t IPRAE_S5:1;
    vuint32_t IPRAE_S6:1;
    vuint32_t IPRAE_S7:1;
    vuint32_t IPRAE_S8:1;
    vuint32_t IPRAE_S9:1;
    vuint32_t IPRAE_S10:1;
    vuint32_t IPRAE_S11:1;
    vuint32_t IPRAE_S12:1;
    vuint32_t IPRAE_S13:1;
    vuint32_t IPRAE_S14:1;
    vuint32_t IPRAE_CCI_S0:1;          /* CCI Interconnect Parity read address checking enable for CA53_CCI_0 */
    vuint32_t IPRAE_CCI_S1:1;          /* CCI Interconnect Parity read address checking enable for CA53_CCI_1 */
    vuint32_t _unused_17:15;
  } B;
} MSCM_IPCE2_tag;

typedef union MSCM_IPCE3_union_tag {   /* Interconnect Parity Checking Enable Register 3 */
  vuint32_t R;
  struct {
    vuint32_t IPWAE_S0:1;
    vuint32_t IPWAE_S1:1;
    vuint32_t IPWAE_S2:1;
    vuint32_t IPWAE_S3:1;
    vuint32_t IPWAE_S4:1;
    vuint32_t IPWAE_S5:1;
    vuint32_t IPWAE_S6:1;
    vuint32_t IPWAE_S7:1;
    vuint32_t IPWAE_S8:1;
    vuint32_t IPWAE_S9:1;
    vuint32_t IPWAE_S10:1;
    vuint32_t IPWAE_S11:1;
    vuint32_t _unused_12:1;
    vuint32_t IPWAE_S13:1;
    vuint32_t _unused_14:1;
    vuint32_t IPWAE_CCI_S0:1;          /* CCI Interconnect Parity write address checking enable for CA53_CCI_0 */
    vuint32_t IPWAE_CCI_S1:1;          /* CCI Interconnect Parity write address checking enable for CA53_CCI_1 */
    vuint32_t _unused_17:15;
  } B;
} MSCM_IPCE3_tag;

typedef union MSCM_IPCGIE_union_tag {  /* Interconnect Parity Checking Global Injection Enable Register */
  vuint32_t R;
  struct {
    vuint32_t GIE:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_IPCGIE_tag;

typedef union MSCM_IPCIE0_union_tag {  /* Interconnect Parity Checking Injection Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t IPRIE_M2:1;
    vuint32_t IPRIE_M3:1;
    vuint32_t IPRIE_M4:1;
    vuint32_t IPRIE_M5:1;
    vuint32_t IPRIE_M6:1;
    vuint32_t IPRIE_M7:1;
    vuint32_t IPRIE_M8:1;
    vuint32_t IPRIE_M9:1;
    vuint32_t IPRIE_M10:1;
    vuint32_t IPRIE_M11:1;
    vuint32_t IPRIE_M12:1;
    vuint32_t IPRIE_M13:1;
    vuint32_t IPRIE_M14:1;
    vuint32_t IPRIE_M15:1;
    vuint32_t IPRIE_M16:1;
    vuint32_t IPRIE_M17:1;
    vuint32_t IPRIE_M18:1;
    vuint32_t IPRIE_M19:1;
    vuint32_t IPRIE_M20:1;
    vuint32_t IPRIE_M21:1;
    vuint32_t IPRIE_M22:1;
    vuint32_t IPRIE_M23:1;
    vuint32_t IPRIE_M24:1;
    vuint32_t IPRIE_M25:1;
    vuint32_t IPRIE_M26:1;
    vuint32_t IPRIE_CCI_M0:1;          /* CCI Interconnect Parity read data checking injection enable for Cortex-A53 cluster 0 */
    vuint32_t IPRIE_CCI_M1:1;          /* CCI Interconnect Parity read data checking injection enable for Cortex-A53 cluster 1 */
    vuint32_t _unused_29:3;
  } B;
} MSCM_IPCIE0_tag;

typedef union MSCM_IPCIE1_union_tag {  /* Interconnect Parity Checking Injection Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t IPWIE_S0:1;
    vuint32_t IPWIE_S1:1;
    vuint32_t IPWIE_S2:1;
    vuint32_t IPWIE_S3:1;
    vuint32_t IPWIE_S4:1;
    vuint32_t IPWIE_S5:1;
    vuint32_t IPWIE_S6:1;
    vuint32_t IPWIE_S7:1;
    vuint32_t IPWIE_S8:1;
    vuint32_t IPWIE_S9:1;
    vuint32_t IPWIE_S10:1;
    vuint32_t IPWIE_S11:1;
    vuint32_t IPWIE_S12:1;
    vuint32_t IPWIE_S13:1;
    vuint32_t IPWIE_S14:1;
    vuint32_t _unused_15:1;
    vuint32_t IPWIE_S16:1;
    vuint32_t IPWIE_S17:1;
    vuint32_t IPWIE_S18:1;
    vuint32_t IPWIE_S19:1;
    vuint32_t IPWIE_S20:1;
    vuint32_t IPWIE_S21:1;
    vuint32_t IPWIE_CCI_S0:1;          /* CCI Interconnect Parity write data checking injection enable for CA53_CCI_0 */
    vuint32_t IPWIE_CCI_S1:1;          /* CCI Interconnect Parity write data checking injection enable for CA53_CCI_1 */
    vuint32_t _unused_24:8;
  } B;
} MSCM_IPCIE1_tag;

typedef union MSCM_IPCIE2_union_tag {  /* Interconnect Parity Checking Injection Enable Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IPRAIE_S0:1;
    vuint32_t IPRAIE_S1:1;
    vuint32_t IPRAIE_S2:1;
    vuint32_t IPRAIE_S3:1;
    vuint32_t IPRAIE_S4:1;
    vuint32_t IPRAIE_S5:1;
    vuint32_t IPRAIE_S6:1;
    vuint32_t IPRAIE_S7:1;
    vuint32_t IPRAIE_S8:1;
    vuint32_t IPRAIE_S9:1;
    vuint32_t IPRAIE_S10:1;
    vuint32_t IPRAIE_S11:1;
    vuint32_t IPRAIE_S12:1;
    vuint32_t IPRAIE_S13:1;
    vuint32_t IPRAIE_S14:1;
    vuint32_t IPRAIE_CCI_S0:1;         /* CCI Interconnect Parity read address checking injection enable for CA53_CCI_0 */
    vuint32_t IPRAIE_CCI_S1:1;         /* CCI Interconnect Parity read address checking injection enable for CA53_CCI_1 */
    vuint32_t _unused_17:15;
  } B;
} MSCM_IPCIE2_tag;

typedef union MSCM_IPCIE3_union_tag {  /* Interconnect Parity Checking Injection Enable Register 3 */
  vuint32_t R;
  struct {
    vuint32_t IPWAIE_S0:1;
    vuint32_t IPWAIE_S1:1;
    vuint32_t IPWAIE_S2:1;
    vuint32_t IPWAIE_S3:1;
    vuint32_t IPWAIE_S4:1;
    vuint32_t IPWAIE_S5:1;
    vuint32_t IPWAIE_S6:1;
    vuint32_t IPWAIE_S7:1;
    vuint32_t IPWAIE_S8:1;
    vuint32_t IPWAIE_S9:1;
    vuint32_t IPWAIE_S10:1;
    vuint32_t IPWAIE_S11:1;
    vuint32_t _unused_12:1;
    vuint32_t IPWAIE_S13:1;
    vuint32_t _unused_14:1;
    vuint32_t IPWAIE_CCI_S0:1;         /* CCI Interconnect Parity write address checking injection enable for CA53_CCI_0 */
    vuint32_t IPWAIE_CCI_S1:1;         /* CCI Interconnect Parity write address checking injection enable for CA53_CCI_1 */
    vuint32_t _unused_17:15;
  } B;
} MSCM_IPCIE3_tag;

struct MSCM_tag {
  MSCM_CPXTYPE_tag CPXTYPE;            /* Processor x Type Register */
  MSCM_CPXNUM_tag CPXNUM;              /* Processor x Number Register */
  MSCM_CPXMASTER_tag CPXMASTER;        /* Processor x Master Number Register */
  MSCM_CPXCOUNT_tag CPXCOUNT;          /* Processor x Count Register */
  MSCM_CPXCFG0_tag CPXCFG0;            /* Processor x Configuration 0 Register */
  MSCM_CPXCFG1_tag CPXCFG1;            /* Processor x Configuration 1 Register */
  MSCM_CPXCFG2_tag CPXCFG2;            /* Processor x Configuration 2 Register */
  MSCM_CPXCFG3_tag CPXCFG3;            /* Processor x Configuration 3 Register */
  MSCM_CP0TYPE_tag CP0TYPE;            /* Processor 0 Type Register */
  MSCM_CP0NUM_tag CP0NUM;              /* Processor 0 Number Register */
  MSCM_CP0MASTER_tag CP0MASTER;        /* Processor 0 Master Number Register */
  MSCM_CP0COUNT_tag CP0COUNT;          /* Processor 0 Count Register */
  MSCM_CP0CFG0_tag CP0CFG0;            /* Processor 0 Configuration 0 Register */
  MSCM_CP0CFG1_tag CP0CFG1;            /* Processor 0 Configuration 1 Register */
  MSCM_CP0CFG2_tag CP0CFG2;            /* Processor 0 Configuration 2 Register */
  MSCM_CP0CFG3_tag CP0CFG3;            /* Processor 0 Configuration 3 Register */
  MSCM_CP1TYPE_tag CP1TYPE;            /* Processor 1 Type Register */
  MSCM_CP1NUM_tag CP1NUM;              /* Processor 1 Number Register */
  MSCM_CP1MASTER_tag CP1MASTER;        /* Processor 1 Master Number Register */
  MSCM_CP1COUNT_tag CP1COUNT;          /* Processor 1 Count Register */
  MSCM_CP1CFG0_tag CP1CFG0;            /* Processor 1 Configuration 0 Register */
  MSCM_CP1CFG1_tag CP1CFG1;            /* Processor 1 Configuration 1 Register */
  MSCM_CP1CFG2_tag CP1CFG2;            /* Processor 1 Configuration 2 Register */
  MSCM_CP1CFG3_tag CP1CFG3;            /* Processor 1 Configuration 3 Register */
  uint8_t MSCM_reserved0[928];
  MSCM_OCMDR_tag OCMDR[2];
  uint8_t MSCM_reserved1[104];
  MSCM_TCMDR0_tag TCMDR0;              /* Generic Tightly Coupled Memory Descriptor Register */
  uint8_t MSCM_reserved2[124];
  MSCM_CPCE0_tag CPCE0;                /* Core Parity Checking Enable Register 0 */
  uint8_t MSCM_reserved3[764];
  MSCM_IRCP0IR_tag IRCP0IR;            /* Interrupt Router CP0 Interrupt Register */
  MSCM_IRCP1IR_tag IRCP1IR;            /* Interrupt Router CP1 Interrupt Register */
  uint8_t MSCM_reserved4[24];
  MSCM_IRCPGIR_tag IRCPGIR;            /* Interrupt Router CPU Generate Interrupt Register */
  uint8_t MSCM_reserved5[92];
  MSCM_IRSPRC_tag IRSPRC[176];         /* Interrupt Router Shared Peripheral Routing Control Register */
  uint8_t MSCM_reserved6[800];
  MSCM_IPCGE_tag IPCGE;                /* Interconnect Parity Checking Global Enable Register */
  uint8_t MSCM_reserved7[12];
  MSCM_IPCE0_tag IPCE0;                /* Interconnect Parity Checking Enable Register 0 */
  MSCM_IPCE1_tag IPCE1;                /* Interconnect Parity Checking Enable Register 1 */
  MSCM_IPCE2_tag IPCE2;                /* Interconnect Parity Checking Enable Register 2 */
  MSCM_IPCE3_tag IPCE3;                /* Interconnect Parity Checking Enable Register 3 */
  uint8_t MSCM_reserved8[32];
  MSCM_IPCGIE_tag IPCGIE;              /* Interconnect Parity Checking Global Injection Enable Register */
  uint8_t MSCM_reserved9[12];
  MSCM_IPCIE0_tag IPCIE0;              /* Interconnect Parity Checking Injection Enable Register 0 */
  MSCM_IPCIE1_tag IPCIE1;              /* Interconnect Parity Checking Injection Enable Register 1 */
  MSCM_IPCIE2_tag IPCIE2;              /* Interconnect Parity Checking Injection Enable Register 2 */
  MSCM_IPCIE3_tag IPCIE3;              /* Interconnect Parity Checking Injection Enable Register 3 */
};


/* ============================================================================
   =============================== Module: OCOTP ==============================
   ============================================================================ */

typedef union OCOTP_CTRL_union_tag {   /* OTP Controller Control Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:8;
    vuint32_t BUSY:1;
    vuint32_t ERROR:1;
    vuint32_t RELOAD_SHADOWS:1;
    vuint32_t _unused_11:1;
    vuint32_t CRC_TEST:1;
    vuint32_t CRC_FAIL:1;
    vuint32_t _unused_14:2;
    vuint32_t WR_UNLOCK:16;
  } B;
} OCOTP_CTRL_tag;

typedef union OCOTP_TIMING_union_tag { /* OTP Controller Timing Register */
  vuint32_t R;
  struct {
    vuint32_t STROBE_PROG:12;
    vuint32_t RELAX:4;
    vuint32_t STROBE_READ:6;
    vuint32_t WAIT:6;
    vuint32_t RSRVD0:4;
  } B;
} OCOTP_TIMING_tag;

typedef union OCOTP_DATA_union_tag {   /* OTP Controller Write Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} OCOTP_DATA_tag;

typedef union OCOTP_READ_CTRL_union_tag { /* OTP Controller Read Control Register */
  vuint32_t R;
  struct {
    vuint32_t READ_FUSE:1;
    vuint32_t _unused_1:2;
    vuint32_t _unused_3:29;
  } B;
} OCOTP_READ_CTRL_tag;

typedef union OCOTP_READ_FUSE_DATA_union_tag { /* OTP Controller Read Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} OCOTP_READ_FUSE_DATA_tag;

typedef union OCOTP_SW_STICKY_union_tag { /* Sticky bit Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t FIELD_RETURN_LOCK:1;
    vuint32_t _unused_3:29;
  } B;
} OCOTP_SW_STICKY_tag;

typedef union OCOTP_CRC_ADDR_union_tag { /* OTP Controller CRC test address */
  vuint32_t R;
  struct {
    vuint32_t DATA_START_ADDR:8;
    vuint32_t DATA_END_ADDR:8;
    vuint32_t CRC_ADDR:3;
    vuint32_t _unused_19:13;
  } B;
} OCOTP_CRC_ADDR_tag;

typedef union OCOTP_CRC_VALUE_union_tag { /* OTP Controller CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} OCOTP_CRC_VALUE_tag;

typedef union OCOTP_VERSION_union_tag { /* OTP Controller Version Register */
  vuint32_t R;
  struct {
    vuint32_t STEP:16;
    vuint32_t MINOR:8;
    vuint32_t MAJOR:8;
  } B;
} OCOTP_VERSION_tag;

typedef union OCOTP_CFG0_union_tag {   /* Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.) */
  vuint32_t R;
  struct {
    vuint32_t SJC_CHALL31_0:32;
  } B;
} OCOTP_CFG0_tag;

typedef union OCOTP_CFG1_union_tag {   /* Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.) CFG1 */
  vuint32_t R;
  struct {
    vuint32_t SJC_CHALL63_32:32;
  } B;
} OCOTP_CFG1_tag;

typedef union OCOTP_CFG2_union_tag {   /* Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.) CFG2 */
  vuint32_t R;
  struct {
    vuint32_t MANU_1:8;
    vuint32_t _unused_8:8;             /* Thermal Resistor Calibration Point */
    vuint32_t SI_REV:4;                /* Silicon Revision number */
    vuint32_t PKG_0:1;                 /* Package type */
    vuint32_t _unused_21:3;            /* RESERVED */
    vuint32_t PART_DIFFERENTIATOR:4;   /* Part differentiator */
    vuint32_t _unused_28:1;
    vuint32_t IPL_DISABLE:1;
    vuint32_t A53_CPU34_DISABLE:1;
    vuint32_t _unused_31:1;            /* RESERVED */
  } B;
} OCOTP_CFG2_tag;

typedef union OCOTP_CFG3_union_tag {   /* Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.) CFG3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;             /* RESERVED */
    vuint32_t _unused_3:16;            /* RESERVED */
    vuint32_t SPEED_GRADING:4;         /* Speed Grading */
    vuint32_t _unused_23:2;            /* RESERVED */
    vuint32_t MANU_2:7;                /* RESERVED for manufacturing use */
  } B;
} OCOTP_CFG3_tag;

typedef union OCOTP_CFG4_union_tag {   /* Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.) CFG4 */
  vuint32_t R;
  struct {
    vuint32_t BOOT_CFG1:8;
    vuint32_t BOOT_CFG2:8;
    vuint32_t BOOT_CFG3:8;
    vuint32_t BOOT_d:8;
  } B;
} OCOTP_CFG4_tag;

typedef union OCOTP_CFG5_union_tag {   /* Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.) CFG5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t BT_FUSE_SEL:1;           /* Determines, whether using fuses for boot configuration, or GPIO /Serial loader. */
    vuint32_t _unused_5:16;
    vuint32_t WDOG_ENABLE:1;           /* Watchdog Enable. */
    vuint32_t JTAG_SMODE:2;            /* JTAG Security Mode. */
    vuint32_t _unused_24:3;
    vuint32_t JTAG_HEO:1;              /* JTAG HAB Enable Override. */
    vuint32_t _unused_28:4;
  } B;
} OCOTP_CFG5_tag;

typedef union OCOTP_CFG6_union_tag {   /* Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.) */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:17;
    vuint32_t FXOSC_EN:1;
    vuint32_t NO_PLL:1;
    vuint32_t FAST_BOOT_ENABLE:1;
    vuint32_t _unused_20:12;
  } B;
} OCOTP_CFG6_tag;

typedef union OCOTP_MAC0_union_tag {   /* Value of OTP Bank4 Word2 (MAC Address0) */
  vuint32_t R;
  struct {
    vuint32_t MAC_ADDR31_0:32;
  } B;
} OCOTP_MAC0_tag;

typedef union OCOTP_MAC1_union_tag {   /* Value of OTP Bank4 Word3 (MAC Address) */
  vuint32_t R;
  struct {
    vuint32_t MAC_ADDR47_32:16;
    vuint32_t _unused_16:16;
  } B;
} OCOTP_MAC1_tag;

typedef union OCOTP_GP1_union_tag {    /* Value of OTP Bank4 Word6 (HW Capabilities) */
  vuint32_t R;
  struct {
    vuint32_t BITS:32;
  } B;
} OCOTP_GP1_tag;

typedef union OCOTP_GP2_union_tag {    /* Value of OTP Bank4 Word7 (HW Capabilities) */
  vuint32_t R;
  struct {
    vuint32_t BITS:32;
  } B;
} OCOTP_GP2_tag;

typedef union OCOTP_MISC_CONF_union_tag { /* Value of OTP Bank5 Word2 */
  vuint32_t R;
  struct {
    vuint32_t PAD_SETTINGS:6;
    vuint32_t _unused_6:26;
  } B;
} OCOTP_MISC_CONF_tag;

typedef union OCOTP_FIELD_RTN_union_tag { /* Value of OTP Bank5 Word3 */
  vuint32_t R;
  struct {
    vuint32_t FIELD_RETURN:1;
    vuint32_t FIELD_RETURN_Copy:1;
    vuint32_t _unused_2:30;
  } B;
} OCOTP_FIELD_RTN_tag;

typedef union OCOTP_MISC2_union_tag {  /* Value of OTP Bank5 Word4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} OCOTP_MISC2_tag;

typedef union OCOTP_CRC0_union_tag {   /* Value of OTP Bank5 Word5 (CRC0) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC0_tag;

typedef union OCOTP_CRC1_union_tag {   /* Value of OTP Bank5 Word6 (CRC1) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC1_tag;

typedef union OCOTP_CRC2_union_tag {   /* Value of OTP Bank5 Word7 (CRC2) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC2_tag;

typedef union OCOTP_CRC3_union_tag {   /* Value of OTP Bank6 Word0 (CRC3) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC3_tag;

typedef union OCOTP_CRC4_union_tag {   /* Value of OTP Bank6 Word1 (CRC4) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC4_tag;

typedef union OCOTP_CRC5_union_tag {   /* Value of OTP Bank6 Word2 (CRC5) */
  vuint32_t R;
  struct {
    vuint32_t CRC32:32;
  } B;
} OCOTP_CRC5_tag;

typedef union OCOTP_ECC_FUSE_ECC_FUSE_union_tag { /* ECC Fuse words */
  vuint32_t R;
  struct {
    vuint32_t ECC:32;                  /* ECC Fuse bits */
  } B;
} OCOTP_ECC_FUSE_ECC_FUSE_tag;

typedef struct OCOTP_ECC_FUSE_struct_tag {
  OCOTP_ECC_FUSE_ECC_FUSE_tag ECC_FUSE; /* ECC Fuse words */
  uint8_t ECC_FUSE_reserved0[12];
} OCOTP_ECC_FUSE_tag;

typedef union OCOTP_REDUNDANT_FUSE_REDUNDANT_FUSE_union_tag { /* ECC Fuse words */
  vuint32_t R;
  struct {
    vuint32_t Redundant:32;            /* ECC Fuse bits */
  } B;
} OCOTP_REDUNDANT_FUSE_REDUNDANT_FUSE_tag;

typedef struct OCOTP_REDUNDANT_FUSE_struct_tag {
  OCOTP_REDUNDANT_FUSE_REDUNDANT_FUSE_tag REDUNDANT_FUSE; /* ECC Fuse words */
  uint8_t REDUNDANT_FUSE_reserved0[12];
} OCOTP_REDUNDANT_FUSE_tag;

typedef union OCOTP_SEC0_union_tag {   /* Single Bit ECC Error status */
  vuint32_t R;
  struct {
    vuint32_t FUSE_WRD_SECC31_0:32;
  } B;
} OCOTP_SEC0_tag;

typedef union OCOTP_SEC1_union_tag {   /* Single Bit ECC Error status */
  vuint32_t R;
  struct {
    vuint32_t FUSE_WRD_SECC50_32:19;
    vuint32_t _unused_19:13;
  } B;
} OCOTP_SEC1_tag;

typedef union OCOTP_DEC0_union_tag {   /* Single Bit ECC Error status */
  vuint32_t R;
  struct {
    vuint32_t FUSE_WRD_DECC31_0:32;
  } B;
} OCOTP_DEC0_tag;

typedef union OCOTP_DEC1_union_tag {   /* Double Bit ECC Error status */
  vuint32_t R;
  struct {
    vuint32_t FUSE_WRD_DECC50_32:19;
    vuint32_t _unused_19:13;
  } B;
} OCOTP_DEC1_tag;

struct OCOTP_tag {
  OCOTP_CTRL_tag CTRL[4];              /* OTP Controller Control Register */
  OCOTP_TIMING_tag TIMING;             /* OTP Controller Timing Register */
  uint8_t OCOTP_reserved0[12];
  OCOTP_DATA_tag DATA;                 /* OTP Controller Write Data Register */
  uint8_t OCOTP_reserved1[12];
  OCOTP_READ_CTRL_tag READ_CTRL;       /* OTP Controller Read Control Register */
  uint8_t OCOTP_reserved2[12];
  OCOTP_READ_FUSE_DATA_tag READ_FUSE_DATA; /* OTP Controller Read Data Register */
  uint8_t OCOTP_reserved3[12];
  OCOTP_SW_STICKY_tag SW_STICKY;       /* Sticky bit Register */
  uint8_t OCOTP_reserved4[28];
  OCOTP_CRC_ADDR_tag CRC_ADDR;         /* OTP Controller CRC test address */
  uint8_t OCOTP_reserved5[12];
  OCOTP_CRC_VALUE_tag CRC_VALUE;       /* OTP Controller CRC Value Register */
  uint8_t OCOTP_reserved6[12];
  OCOTP_VERSION_tag VERSION;           /* OTP Controller Version Register */
  uint8_t OCOTP_reserved7[892];
  OCOTP_CFG0_tag CFG0;                 /* Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.) */
  uint8_t OCOTP_reserved8[12];
  OCOTP_CFG1_tag CFG1;                 /* Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.) CFG1 */
  uint8_t OCOTP_reserved9[12];
  OCOTP_CFG2_tag CFG2;                 /* Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.) CFG2 */
  uint8_t OCOTP_reserved10[12];
  OCOTP_CFG3_tag CFG3;                 /* Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.) CFG3 */
  uint8_t OCOTP_reserved11[12];
  OCOTP_CFG4_tag CFG4;                 /* Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.) CFG4 */
  uint8_t OCOTP_reserved12[12];
  OCOTP_CFG5_tag CFG5;                 /* Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.) CFG5 */
  uint8_t OCOTP_reserved13[12];
  OCOTP_CFG6_tag CFG6;                 /* Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.) */
  uint8_t OCOTP_reserved14[428];
  OCOTP_MAC0_tag MAC0;                 /* Value of OTP Bank4 Word2 (MAC Address0) */
  uint8_t OCOTP_reserved15[12];
  OCOTP_MAC1_tag MAC1;                 /* Value of OTP Bank4 Word3 (MAC Address) */
  uint8_t OCOTP_reserved16[44];
  OCOTP_GP1_tag GP1;                   /* Value of OTP Bank4 Word6 (HW Capabilities) */
  uint8_t OCOTP_reserved17[12];
  OCOTP_GP2_tag GP2;                   /* Value of OTP Bank4 Word7 (HW Capabilities) */
  uint8_t OCOTP_reserved18[44];
  OCOTP_MISC_CONF_tag MISC_CONF;       /* Value of OTP Bank5 Word2 */
  uint8_t OCOTP_reserved19[12];
  OCOTP_FIELD_RTN_tag FIELD_RTN;       /* Value of OTP Bank5 Word3 */
  uint8_t OCOTP_reserved20[12];
  OCOTP_MISC2_tag MISC2;               /* Value of OTP Bank5 Word4 */
  uint8_t OCOTP_reserved21[12];
  OCOTP_CRC0_tag CRC0;                 /* Value of OTP Bank5 Word5 (CRC0) */
  uint8_t OCOTP_reserved22[12];
  OCOTP_CRC1_tag CRC1;                 /* Value of OTP Bank5 Word6 (CRC1) */
  uint8_t OCOTP_reserved23[12];
  OCOTP_CRC2_tag CRC2;                 /* Value of OTP Bank5 Word7 (CRC2) */
  uint8_t OCOTP_reserved24[12];
  OCOTP_CRC3_tag CRC3;                 /* Value of OTP Bank6 Word0 (CRC3) */
  uint8_t OCOTP_reserved25[12];
  OCOTP_CRC4_tag CRC4;                 /* Value of OTP Bank6 Word1 (CRC4) */
  uint8_t OCOTP_reserved26[12];
  OCOTP_CRC5_tag CRC5;                 /* Value of OTP Bank6 Word2 (CRC5) */
  uint8_t OCOTP_reserved27[12];
  OCOTP_ECC_FUSE_tag ECC_FUSE[13];
  OCOTP_REDUNDANT_FUSE_tag REDUNDANT_FUSE[64];
  OCOTP_SEC0_tag SEC0;                 /* Single Bit ECC Error status */
  uint8_t OCOTP_reserved28[12];
  OCOTP_SEC1_tag SEC1;                 /* Single Bit ECC Error status */
  uint8_t OCOTP_reserved29[12];
  OCOTP_DEC0_tag DEC0;                 /* Single Bit ECC Error status */
  uint8_t OCOTP_reserved30[12];
  OCOTP_DEC1_tag DEC1;                 /* Double Bit ECC Error status */
};


/* ============================================================================
   =============================== Module: OTFAD ==============================
   ============================================================================ */

typedef union OTFAD_CR_union_tag {     /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t IRQE:1;
    vuint32_t FERR:1;                  /* Force Error */
    vuint32_t _unused_2:1;
    vuint32_t FLDM:1;                  /* Force Logically Disabled Mode */
    vuint32_t KBSE:1;                  /* Key Blob Scramble Enable */
    vuint32_t KBPE:1;                  /* Key Blob Processing Enable */
    vuint32_t KBCE:1;                  /* Key Blob CRC Enable */
    vuint32_t RRAE:1;                  /* Restricted Register Access Enable */
    vuint32_t _unused_8:8;
    vuint32_t CCTX:2;                  /* CRC Context */
    vuint32_t _unused_18:2;
    vuint32_t CRCE:1;                  /* CRC Enable */
    vuint32_t CRCI:1;                  /* CRC Initialization */
    vuint32_t _unused_22:8;
    vuint32_t SKBP:1;                  /* Start key blob processing */
    vuint32_t GE:1;                    /* Global OTFAD Enable */
  } B;
} OTFAD_CR_tag;

typedef union OTFAD_SR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t KBERR:1;                 /* Key Blob Error */
    vuint32_t MDPCP:1;                 /* MDPC Present */
    vuint32_t MODE:2;                  /* Operating Mode */
    vuint32_t NCTX:4;                  /* Number of Contexts */
    vuint32_t CTXER:4;                 /* Context Error */
    vuint32_t _unused_12:4;
    vuint32_t CTXIE:4;                 /* Context Integrity Error */
    vuint32_t _unused_20:4;
    vuint32_t HRL:4;                   /* Hardware Revision Level */
    vuint32_t RRAM:1;                  /* Restricted Register Access Mode */
    vuint32_t GEM:1;                   /* Global Enable Mode */
    vuint32_t KBPE:1;                  /* Key Blob Processing Enable */
    vuint32_t KBD:1;                   /* Key Blob Processing Done */
  } B;
} OTFAD_SR_tag;

typedef union OTFAD_CRC_union_tag {    /* Cyclic Redundancy Check Register */
  vuint32_t R;
  struct {
    vuint32_t CRCD:32;                 /* CRC Data. */
  } B;
} OTFAD_CRC_tag;

typedef union OTFAD_CTX_CTX_KEY_W0_union_tag { /* AES Key Word0 */
  vuint32_t R;
  struct {
    vuint32_t W0KEY:32;                /* AES Key */
  } B;
} OTFAD_CTX_CTX_KEY_W0_tag;

typedef union OTFAD_CTX_CTX_KEY_W1_union_tag { /* AES Key Word1 */
  vuint32_t R;
  struct {
    vuint32_t W1KEY:32;                /* AES Key */
  } B;
} OTFAD_CTX_CTX_KEY_W1_tag;

typedef union OTFAD_CTX_CTX_KEY_W2_union_tag { /* AES Key Word2 */
  vuint32_t R;
  struct {
    vuint32_t W2KEY:32;                /* AES Key */
  } B;
} OTFAD_CTX_CTX_KEY_W2_tag;

typedef union OTFAD_CTX_CTX_KEY_W3_union_tag { /* AES Key Word3 */
  vuint32_t R;
  struct {
    vuint32_t W3KEY:32;                /* AES Key */
  } B;
} OTFAD_CTX_CTX_KEY_W3_tag;

typedef union OTFAD_CTX_CTX_CTR_W0_union_tag { /* AES Counter Word0 */
  vuint32_t R;
  struct {
    vuint32_t W0CTR:32;                /* AES Counter */
  } B;
} OTFAD_CTX_CTX_CTR_W0_tag;

typedef union OTFAD_CTX_CTX_CTR_W1_union_tag { /* AES Counter Word1 */
  vuint32_t R;
  struct {
    vuint32_t W1CTR:32;                /* AES Counter */
  } B;
} OTFAD_CTX_CTX_CTR_W1_tag;

typedef union OTFAD_CTX_CTX_RGD_W0_union_tag { /* AES Region Descriptor Word0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t SRTADDR:22;              /* Start Address */
  } B;
} OTFAD_CTX_CTX_RGD_W0_tag;

typedef union OTFAD_CTX_CTX_RGD_W1_union_tag { /* AES Region Descriptor Word1 */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;                   /* Valid */
    vuint32_t ADE:1;                   /* Aes Decryption Enable. */
    vuint32_t RO:1;                    /* Read-Only */
    vuint32_t _unused_3:7;
    vuint32_t ENDADDR:22;              /* End Address */
  } B;
} OTFAD_CTX_CTX_RGD_W1_tag;

typedef struct OTFAD_CTX_struct_tag {
  OTFAD_CTX_CTX_KEY_W0_tag CTX_KEY_W0; /* AES Key Word0 */
  OTFAD_CTX_CTX_KEY_W1_tag CTX_KEY_W1; /* AES Key Word1 */
  OTFAD_CTX_CTX_KEY_W2_tag CTX_KEY_W2; /* AES Key Word2 */
  OTFAD_CTX_CTX_KEY_W3_tag CTX_KEY_W3; /* AES Key Word3 */
  OTFAD_CTX_CTX_CTR_W0_tag CTX_CTR_W0; /* AES Counter Word0 */
  OTFAD_CTX_CTX_CTR_W1_tag CTX_CTR_W1; /* AES Counter Word1 */
  OTFAD_CTX_CTX_RGD_W0_tag CTX_RGD_W0; /* AES Region Descriptor Word0 */
  OTFAD_CTX_CTX_RGD_W1_tag CTX_RGD_W1; /* AES Region Descriptor Word1 */
  uint8_t CTX_reserved0[32];
} OTFAD_CTX_tag;

typedef union OTFAD_MDPC_CSR_union_tag { /* MDPC Control and Status Register */
  vuint32_t R;
  struct {
    vuint32_t OPMODE:3;                /* OPeration MODE. */
    vuint32_t _unused_3:1;
    vuint32_t E23:1;                   /* Enable a hardware-controlled transition from OPMODE = 2 -> 3. */
    vuint32_t E34:1;                   /* Enable a hardware-controlled transition from OPMODE = 3 -> 4. */
    vuint32_t E45:1;                   /* Enable a hardware-controlled transition from OPMODE = 4 -> 5 */
    vuint32_t _unused_7:9;
    vuint32_t HCFG:4;                  /* Hardware Configuration */
    vuint32_t HRL:3;                   /* Hardware Revision Level */
    vuint32_t BSY:1;                   /* Busy */
    vuint32_t _unused_24:4;
    vuint32_t SYNDST:4;                /* Syndrome State */
  } B;
} OTFAD_MDPC_CSR_tag;

typedef union OTFAD_MDPC_SRTAR_union_tag { /* MDPC Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t MNUM:6;                  /* Master Number */
    vuint32_t _unused_6:2;
    vuint32_t DMNC:1;                  /* Disable Master Number Comparison */
    vuint32_t _unused_9:1;
    vuint32_t SRTADDR:22;              /* Start Address */
  } B;
} OTFAD_MDPC_SRTAR_tag;

typedef union OTFAD_MDPC_ENDAR_union_tag { /* MDPC End Address Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;                   /* Valid */
    vuint32_t _unused_1:9;
    vuint32_t ENDADDR:22;              /* End Address */
  } B;
} OTFAD_MDPC_ENDAR_tag;

typedef union OTFAD_MDPC_COLP_union_tag { /* MDPC Column Parity Register */
  vuint32_t R;
  struct {
    vuint32_t EPAR:32;                 /* Even Parity */
  } B;
} OTFAD_MDPC_COLP_tag;

typedef union OTFAD_MDPC_ROWP_union_tag { /* MDPC Row Parity Register */
  vuint32_t R;
  struct {
    vuint32_t EPAR:32;                 /* Even Parity */
  } B;
} OTFAD_MDPC_ROWP_tag;

struct OTFAD_tag {
  uint8_t OTFAD_reserved0[3072];
  OTFAD_CR_tag CR;                     /* Control Register */
  OTFAD_SR_tag SR;                     /* Status Register */
  OTFAD_CRC_tag CRC;                   /* Cyclic Redundancy Check Register */
  uint8_t OTFAD_reserved1[244];
  OTFAD_CTX_tag CTX[4];
  uint8_t OTFAD_reserved2[240];
  OTFAD_MDPC_CSR_tag MDPC_CSR;         /* MDPC Control and Status Register */
  OTFAD_MDPC_SRTAR_tag MDPC_SRTAR;     /* MDPC Start Address Register */
  OTFAD_MDPC_ENDAR_tag MDPC_ENDAR;     /* MDPC End Address Register */
  uint8_t OTFAD_reserved3[4];
  OTFAD_MDPC_COLP_tag MDPC_COLP[32];   /* MDPC Column Parity Register */
  OTFAD_MDPC_ROWP_tag MDPC_ROWP[32];   /* MDPC Row Parity Register */
};


/* ============================================================================
   =============================== Module: PCIE_EP ============================
   ============================================================================ */

typedef union PCIE_EP_DeviceID_union_tag { /* Device ID and Vendor ID Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t Vendor_ID:16;
  } B;
} PCIE_EP_DeviceID_tag;

typedef union PCIE_EP_Command_union_tag { /* Command and Status Register */
  vuint32_t R;
  struct {
    vuint32_t I_O_Space_Enable:1;
    vuint32_t Memory_Space_Enable:1;
    vuint32_t Bus_Master_Enable:1;
    vuint32_t Special_Cycle_Enable:1;
    vuint32_t Memory_Write_and_Invalidate:1;
    vuint32_t VGA_Palette_Snoop:1;
    vuint32_t Parity_Error_Response:1;
    vuint32_t IDSEL_Stepping:1;
    vuint32_t SERR_Enable:1;
    vuint32_t Fast_Back_to_Back_Enable:1;
    vuint32_t INTx_Assertion_Disable:1;
    vuint32_t _unused_11:5;
    vuint32_t _unused_16:3;
    vuint32_t INTx_Status:1;
    vuint32_t Capabilities_List:1;
    vuint32_t SixtySix_MHz_Capable:1;
    vuint32_t _unused_22:1;
    vuint32_t Fast_Back_to_Back_Capable:1;
    vuint32_t Master_Data_Parity_Error:1;
    vuint32_t DEVSEL_Timing:2;
    vuint32_t Signaled_Target_Abort:1;
    vuint32_t Received_Target_Abort:1;
    vuint32_t Received_Master_Abort:1;
    vuint32_t Detected_Parity_Error:1;
    vuint32_t Signaled_System_Error:1;
  } B;
} PCIE_EP_Command_tag;

typedef union PCIE_EP_Revision_ID_union_tag { /* PCI Express Revision ID Register */
  vuint8_t R;
  struct {
    vuint8_t Revision_ID:8;
  } B;
} PCIE_EP_Revision_ID_tag;

typedef union PCIE_EP_BIST_union_tag { /* BIST Register */
  vuint32_t R;
  struct {
    vuint32_t Cache_Line_Size:8;
    vuint32_t Master_Latency_Timer:8;
    vuint32_t Configuration_Header_Format:7;
    vuint32_t Multi_Function_Device:1;
    vuint32_t Not_supported_by_core:8;
  } B;
} PCIE_EP_BIST_tag;

typedef union PCIE_EP_BAR0_union_tag { /* Base Address 0 */
  vuint32_t R;
  struct {
    vuint32_t Mem_I_O:1;
    vuint32_t TYPE:2;
    vuint32_t PREF:1;
    vuint32_t ADDRESS:28;
  } B;
} PCIE_EP_BAR0_tag;

typedef union PCIE_EP_BAR1_union_tag { /* Base Address 1 */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} PCIE_EP_BAR1_tag;

typedef union PCIE_EP_BAR2_union_tag { /* Base Address 2 */
  vuint32_t R;
  struct {
    vuint32_t MEM_I_O:1;
    vuint32_t TYPE:2;
    vuint32_t PREF:1;
    vuint32_t ADDRESS:28;
  } B;
} PCIE_EP_BAR2_tag;

typedef union PCIE_EP_BAR3_union_tag { /* Base Address 3 */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} PCIE_EP_BAR3_tag;

typedef union PCIE_EP_CISP_union_tag { /* CardBus CIS Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t CARDBUS_CIS_PTR_N:32;
  } B;
} PCIE_EP_CISP_tag;

typedef union PCIE_EP_SSID_union_tag { /* Subsystem ID and Subsystem Vendor ID Register */
  vuint32_t R;
  struct {
    vuint32_t SUBSYS_VENDOR_ID_N:16;
    vuint32_t SUBSYS_DEV_ID_N:16;
  } B;
} PCIE_EP_SSID_tag;

typedef union PCIE_EP_EROMBAR_union_tag { /* Expansion ROM Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t _unused_1:10;
    vuint32_t ADDRESS:21;
  } B;
} PCIE_EP_EROMBAR_tag;

typedef union PCIE_EP_CAPPR_union_tag { /* Capability Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t CFG_NEXT_PTR:8;
    vuint32_t _unused_8:24;
  } B;
} PCIE_EP_CAPPR_tag;

typedef union PCIE_EP_ILR_union_tag {  /* Interrupt Line and Pin Register */
  vuint32_t R;
  struct {
    vuint32_t INTERRUPT_LINE:8;
    vuint32_t INT_PIN_MAPPING_N:8;
    vuint32_t _unused_16:16;
  } B;
} PCIE_EP_ILR_tag;

typedef union PCIE_EP_PMCIDR_union_tag { /* Power Management Capability ID Register */
  vuint8_t R;
  struct {
    vuint8_t Power_Mgmt_Capability_ID:8;
  } B;
} PCIE_EP_PMCIDR_tag;

typedef union PCIE_EP_PMCR_union_tag { /* Power Management Capabilities Register */
  vuint16_t R;
  struct {
    vuint16_t Version:3;
    vuint16_t PME_CLK:1;
    vuint16_t _unused_4:1;
    vuint16_t DSI:1;
    vuint16_t AUX_Curr:3;
    vuint16_t D1:1;
    vuint16_t D2:1;
    vuint16_t PME_Support:5;
  } B;
} PCIE_EP_PMCR_tag;

typedef union PCIE_EP_PMSCR_union_tag { /* Power Management Status and Control Register */
  vuint16_t R;
  struct {
    vuint16_t Power_State:2;
    vuint16_t _unused_2:6;
    vuint16_t PME_EN:1;
    vuint16_t Data_Select:4;
    vuint16_t Data_Scale:2;
    vuint16_t PME_STAT:1;
  } B;
} PCIE_EP_PMSCR_tag;

typedef union PCIE_EP_MSI_MCIDR_union_tag { /* PCI Express MSI Message Capability ID Register */
  vuint8_t R;
  struct {
    vuint8_t MSI_Message_Capability_ID:8;
  } B;
} PCIE_EP_MSI_MCIDR_tag;

typedef union PCIE_EP_MSI_MCR_union_tag { /* PCI Express MSI Message Control Register */
  vuint16_t R;
  struct {
    vuint16_t MSIE:1;
    vuint16_t MMC:3;
    vuint16_t MME:3;
    vuint16_t AC64:1;
    vuint16_t _unused_8:8;
  } B;
} PCIE_EP_MSI_MCR_tag;

typedef union PCIE_EP_MSI_MADDR_union_tag { /* PCI Express MSI Message Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t Message_Address:30;
  } B;
} PCIE_EP_MSI_MADDR_tag;

typedef union PCIE_EP_MSI_MUADDR_union_tag { /* PCI Express MSI Message Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t Message_Upper_Address:32;
  } B;
} PCIE_EP_MSI_MUADDR_tag;

typedef union PCIE_EP_MSI_MDATR_union_tag { /* PCI Express MSI Message Data Register */
  vuint16_t R;
  struct {
    vuint16_t Message_Data:16;
  } B;
} PCIE_EP_MSI_MDATR_tag;

typedef union PCIE_EP_CIDR_union_tag { /* Capability ID Register */
  vuint8_t R;
  struct {
    vuint8_t PCI_Express_Capability_ID:8;
  } B;
} PCIE_EP_CIDR_tag;

typedef union PCIE_EP_CR_union_tag {   /* PCI Express Capabilities Register */
  vuint16_t R;
  struct {
    vuint16_t Capability_Version:4;
    vuint16_t Device_Port_Type:4;
    vuint16_t Slot:1;
    vuint16_t Interrupt_Message_Number:5;
    vuint16_t _unused_14:2;
  } B;
} PCIE_EP_CR_tag;

typedef union PCIE_EP_DCR_union_tag {  /* PCI Express Device Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t MAX_PL_SIZE_SUP:3;
    vuint32_t PHAN_FCT:2;
    vuint32_t ET:1;
    vuint32_t EP_L0s_LAT:3;
    vuint32_t EP_L1_LAT:3;
    vuint32_t ABP:1;
    vuint32_t AIP:1;
    vuint32_t PIP:1;
    vuint32_t RBER:1;
    vuint32_t _unused_16:2;
    vuint32_t CSPLV:8;
    vuint32_t CSPLS:2;
    vuint32_t FLRC:1;
    vuint32_t _unused_29:3;
  } B;
} PCIE_EP_DCR_tag;

typedef union PCIE_EP_DCTRLR_union_tag { /* PCI Express Device Control Register */
  vuint16_t R;
  struct {
    vuint16_t CER:1;
    vuint16_t NFER:1;
    vuint16_t FER:1;
    vuint16_t URR:1;
    vuint16_t RO:1;
    vuint16_t MAX_PAYLOAD_SIZE:3;
    vuint16_t ETE:1;
    vuint16_t PFE:1;
    vuint16_t APE:1;
    vuint16_t NSE:1;
    vuint16_t MAX_READ_SIZE:3;
    vuint16_t IFLR:1;
  } B;
} PCIE_EP_DCTRLR_tag;

typedef union PCIE_EP_DSR_union_tag {  /* PCI Express Device Status Register */
  vuint16_t R;
  struct {
    vuint16_t CED:1;
    vuint16_t NFED:1;
    vuint16_t FED:1;
    vuint16_t URD:1;
    vuint16_t APD:1;
    vuint16_t TP:1;
    vuint16_t _unused_6:10;
  } B;
} PCIE_EP_DSR_tag;

typedef union PCIE_EP_LCR_union_tag {  /* PCI Express Link Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t MAX_LINK_SP:4;
    vuint32_t MAX_LINK_W:6;
    vuint32_t ASPM:2;
    vuint32_t L0s_EX_LAT:3;
    vuint32_t L1_EX_LAT:3;
    vuint32_t CPM:1;
    vuint32_t _unused_19:1;
    vuint32_t DLLARC:1;
    vuint32_t LBWN:1;
    vuint32_t AOC:1;
    vuint32_t _unused_23:1;
    vuint32_t Port_Number:8;
  } B;
} PCIE_EP_LCR_tag;

typedef union PCIE_EP_CTRLR_union_tag { /* PCI Express Link Control Register */
  vuint16_t R;
  struct {
    vuint16_t ASPM_CTL:2;
    vuint16_t _unused_2:1;
    vuint16_t RCB:1;
    vuint16_t LD:1;
    vuint16_t RL:1;
    vuint16_t CCC:1;
    vuint16_t EXT_SYNC:1;
    vuint16_t ECPM:1;
    vuint16_t _unused_9:1;
    vuint16_t LBMIE:1;
    vuint16_t LABIE:1;
    vuint16_t _unused_12:4;
  } B;
} PCIE_EP_CTRLR_tag;

typedef union PCIE_EP_SR_union_tag {   /* PCI Express Link Status Register */
  vuint16_t R;
  struct {
    vuint16_t LINK_SP:4;
    vuint16_t NEG_LINK_W:6;
    vuint16_t _unused_10:1;
    vuint16_t LT:1;
    vuint16_t SCC:1;
    vuint16_t _unused_13:1;
    vuint16_t LBMS:1;
    vuint16_t LABS:1;
  } B;
} PCIE_EP_SR_tag;

typedef union PCIE_EP_SCR_union_tag {  /* PCI Express Slot Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t ABP:1;
    vuint32_t PCP:1;
    vuint32_t MRLSP:1;
    vuint32_t AIP:1;
    vuint32_t PIP:1;
    vuint32_t HPS:1;
    vuint32_t HPD:1;
    vuint32_t SPLV:8;
    vuint32_t SPLS:2;
    vuint32_t _unused_17:2;
    vuint32_t Physical_Slot_Number:13;
  } B;
} PCIE_EP_SCR_tag;

typedef union PCIE_EP_SCTRLR_union_tag { /* PCI Express Slot Control Register */
  vuint16_t R;
  struct {
    vuint16_t ABPE:1;
    vuint16_t PFDE:1;
    vuint16_t MRLSCE:1;
    vuint16_t PDCE:1;
    vuint16_t CCIE:1;
    vuint16_t HPIE:1;
    vuint16_t AIC:2;
    vuint16_t PIC:2;
    vuint16_t PCC:1;
    vuint16_t _unused_11:5;
  } B;
} PCIE_EP_SCTRLR_tag;

typedef union PCIE_EP_SSR_union_tag {  /* PCI Express Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t ABP:1;
    vuint16_t PFD:1;
    vuint16_t MRLSC:1;
    vuint16_t PDC:1;
    vuint16_t CC:1;
    vuint16_t MRLSS:1;
    vuint16_t PDS:1;
    vuint16_t _unused_7:9;
  } B;
} PCIE_EP_SSR_tag;

typedef union PCIE_EP_RCR_union_tag {  /* Root Control Register */
  vuint16_t R;
  struct {
    vuint16_t SECEE:1;
    vuint16_t SENFEE:1;
    vuint16_t SEFEE:1;
    vuint16_t PMEIE:1;
    vuint16_t _unused_4:12;
  } B;
} PCIE_EP_RCR_tag;

typedef union PCIE_EP_RSR_union_tag {  /* PCI Express Root Status Register */
  vuint32_t R;
  struct {
    vuint32_t PME_requester_ID:16;
    vuint32_t PMES:1;
    vuint32_t PMEP:1;
    vuint32_t _unused_18:14;
  } B;
} PCIE_EP_RSR_tag;

typedef union PCIE_EP_DC_2_union_tag { /* PCI Express Device Capabilities 2 Register */
  vuint32_t R;
  struct {
    vuint32_t CPL_TO_RS:4;
    vuint32_t CPL_TO_DS:1;
    vuint32_t _unused_5:27;
  } B;
} PCIE_EP_DC_2_tag;

typedef union PCIE_EP_DCTR_2_union_tag { /* PCI Express Device Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t CPL_TO_VAL:4;
    vuint16_t CPL_TOD:1;
    vuint16_t ARIFE:1;
    vuint16_t _unused_6:10;
  } B;
} PCIE_EP_DCTR_2_tag;

typedef union PCIE_EP_LC_2_union_tag { /* PCI Express Link Capabilities 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t Support_Link_Speed_Vector:6;
    vuint32_t _unused_7:25;
  } B;
} PCIE_EP_LC_2_tag;

typedef union PCIE_EP_LCTR_2_union_tag { /* PCI Express Link Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t T_LS:4;
    vuint16_t EC:1;
    vuint16_t HWASD:1;
    vuint16_t SDE:1;
    vuint16_t TxM:3;
    vuint16_t EMC:1;
    vuint16_t CSOS:1;
    vuint16_t CDE:4;
  } B;
} PCIE_EP_LCTR_2_tag;

typedef union PCIE_EP_LS_2_union_tag { /* PCI Express Link Status 2 Register */
  vuint16_t R;
  struct {
    vuint16_t DE_LVL:1;
    vuint16_t EC:1;
    vuint16_t EP1S:1;
    vuint16_t EP2S:1;
    vuint16_t EP3S:1;
    vuint16_t LER:1;
    vuint16_t _unused_6:10;
  } B;
} PCIE_EP_LS_2_tag;

typedef union PCIE_EP_AER_union_tag {  /* AER Capability Header */
  vuint32_t R;
  struct {
    vuint32_t PCI_Express_Extended_Capability_ID:16;
    vuint32_t Capability_Version:4;
    vuint32_t Next_Capability_Offset:12;
  } B;
} PCIE_EP_AER_tag;

typedef union PCIE_EP_UESR_union_tag { /* Uncorrectable Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Status:1;
    vuint32_t Surprise_Down_Error_Status_:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Status:1;
    vuint32_t Flow_Control_Protocol_Error_Status:1;
    vuint32_t Completion_Timeout_Status:1;
    vuint32_t Completer_Abort_Status:1;
    vuint32_t Unexpected_Completion_Status:1;
    vuint32_t Receiver_Overflow_Status:1;
    vuint32_t Malformed_TLP_Status:1;
    vuint32_t ECRC_Error_Status:1;
    vuint32_t Unsupported_Request_Error_Status:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_EP_UESR_tag;

typedef union PCIE_EP_UEMR_union_tag { /* Uncorrectable Error Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Mask:1;
    vuint32_t Surprise_Down_Error_Mask:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Mask:1;
    vuint32_t Flow_Control_Protocol_Error_Mask:1;
    vuint32_t Completion_Timeout_Mask:1;
    vuint32_t Completer_Abort_Mask:1;
    vuint32_t Unexpected_Completion_Mask:1;
    vuint32_t Receiver_Overflow_Mask:1;
    vuint32_t Malformed_TLP_Mask:1;
    vuint32_t ECRC_Error_Mask:1;
    vuint32_t Unsupported_Request_Error_Mask:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_EP_UEMR_tag;

typedef union PCIE_EP_UESevR_union_tag { /* Uncorrectable Error Severity Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Severity:1;
    vuint32_t Surprise_Down_Error_Severity:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Severity:1;
    vuint32_t Flow_Control_Protocol_Error_Severity:1;
    vuint32_t Completion_Timeout_Severity:1;
    vuint32_t Completer_Abort_Severity:1;
    vuint32_t Unexpected_Completion_Severity:1;
    vuint32_t Receiver_Overflow_Severity:1;
    vuint32_t Malformed_TLP_Severity:1;
    vuint32_t ECRC_Error_Severity:1;
    vuint32_t Unsupported_Request_Error_Severity:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_EP_UESevR_tag;

typedef union PCIE_EP_CESR_union_tag { /* Correctable Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t Receiver_Error_Status:1;
    vuint32_t _unused_1:5;
    vuint32_t Bad_TLP_Status:1;
    vuint32_t Bad_DLLP_Status:1;
    vuint32_t REPLAY_NUM_Rollover_Status:1;
    vuint32_t _unused_9:3;
    vuint32_t Reply_Timer_Timeout_Status:1;
    vuint32_t Advisory_Non_Fatal_Error_Status:1;
    vuint32_t _unused_14:18;
  } B;
} PCIE_EP_CESR_tag;

typedef union PCIE_EP_CEMR_union_tag { /* Correctable Error Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Receiver_Error_Mask:1;
    vuint32_t _unused_1:5;
    vuint32_t Bad_TLP_Mask:1;
    vuint32_t Bad_DLLP_Mask:1;
    vuint32_t REPLAY_NUM_Rollover_Mask:1;
    vuint32_t _unused_9:3;
    vuint32_t Reply_Timer_Timeout_Mask:1;
    vuint32_t Advisory_Non_Fatal_Error_Mask:1;
    vuint32_t _unused_14:18;
  } B;
} PCIE_EP_CEMR_tag;

typedef union PCIE_EP_ACCR_union_tag { /* Advanced Capabilities and Control Register */
  vuint32_t R;
  struct {
    vuint32_t First_Error_Pointer:5;
    vuint32_t ECRC_Generation_Capability:1;
    vuint32_t ECRC_Generation_Enable:1;
    vuint32_t ECRC_Check_Capable:1;
    vuint32_t ECRC_Check_Enable:1;
    vuint32_t _unused_9:23;
  } B;
} PCIE_EP_ACCR_tag;

typedef union PCIE_EP_Header_Log_Register_DWORD1_union_tag { /* PCI Express Header Log Register 1 */
  vuint32_t R;
  struct {
    vuint32_t Byte_3:8;
    vuint32_t Byte_2:8;
    vuint32_t Byte_1:8;
    vuint32_t Byte_0:8;
  } B;
} PCIE_EP_Header_Log_Register_DWORD1_tag;

typedef union PCIE_EP_Header_Log_Register_DWORD2_union_tag { /* PCI Express Header Log Register 2 */
  vuint32_t R;
  struct {
    vuint32_t Byte_7:8;
    vuint32_t Byte_6:8;
    vuint32_t Byte_5:8;
    vuint32_t Byte_4:8;
  } B;
} PCIE_EP_Header_Log_Register_DWORD2_tag;

typedef union PCIE_EP_Header_Log_Register_DWORD3_union_tag { /* PCI Express Header Log Register 3 */
  vuint32_t R;
  struct {
    vuint32_t Byte_B:8;
    vuint32_t Byte_A:8;
    vuint32_t Byte_9:8;
    vuint32_t Byte_8:8;
  } B;
} PCIE_EP_Header_Log_Register_DWORD3_tag;

typedef union PCIE_EP_Header_Log_Register_DWORD4_union_tag { /* PCI Express Header Log Register 4 */
  vuint32_t R;
  struct {
    vuint32_t Byte_F:8;
    vuint32_t Byte_E:8;
    vuint32_t Byte_D:8;
    vuint32_t Byte_C:8;
  } B;
} PCIE_EP_Header_Log_Register_DWORD4_tag;

typedef union PCIE_EP_MASK0_union_tag { /* BAR 0 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t MASK:31;
  } B;
} PCIE_EP_MASK0_tag;

typedef union PCIE_EP_MASK1_union_tag { /* BAR 1 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;
  } B;
} PCIE_EP_MASK1_tag;

typedef union PCIE_EP_MASK2_union_tag { /* BAR 2 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t BAR2_ENABLED_N:1;
    vuint32_t BAR2_MASK_N:31;
  } B;
} PCIE_EP_MASK2_tag;

typedef union PCIE_EP_MASK3_union_tag { /* BAR 3 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;
  } B;
} PCIE_EP_MASK3_tag;

typedef union PCIE_EP_EROMMASK_union_tag { /* Expansion ROM BAR Mask Register */
  vuint32_t R;
  struct {
    vuint32_t ROM_BAR_ENABLED_N:1;
    vuint32_t ROM_MASK_N:31;
  } B;
} PCIE_EP_EROMMASK_tag;

struct PCIE_EP_tag {
  PCIE_EP_DeviceID_tag DeviceID;       /* Device ID and Vendor ID Register */
  PCIE_EP_Command_tag Command;         /* Command and Status Register */
  PCIE_EP_Revision_ID_tag Revision_ID; /* PCI Express Revision ID Register */
  uint8_t PCIE_EP_reserved0[3];
  PCIE_EP_BIST_tag BIST;               /* BIST Register */
  PCIE_EP_BAR0_tag BAR0;               /* Base Address 0 */
  PCIE_EP_BAR1_tag BAR1;               /* Base Address 1 */
  PCIE_EP_BAR2_tag BAR2;               /* Base Address 2 */
  PCIE_EP_BAR3_tag BAR3;               /* Base Address 3 */
  uint8_t PCIE_EP_reserved1[8];
  PCIE_EP_CISP_tag CISP;               /* CardBus CIS Pointer Register */
  PCIE_EP_SSID_tag SSID;               /* Subsystem ID and Subsystem Vendor ID Register */
  PCIE_EP_EROMBAR_tag EROMBAR;         /* Expansion ROM Base Address Register */
  PCIE_EP_CAPPR_tag CAPPR;             /* Capability Pointer Register */
  uint8_t PCIE_EP_reserved2[4];
  PCIE_EP_ILR_tag ILR;                 /* Interrupt Line and Pin Register */
  PCIE_EP_PMCIDR_tag PMCIDR;           /* Power Management Capability ID Register */
  uint8_t PCIE_EP_reserved3[1];
  PCIE_EP_PMCR_tag PMCR;               /* Power Management Capabilities Register */
  PCIE_EP_PMSCR_tag PMSCR;             /* Power Management Status and Control Register */
  uint8_t PCIE_EP_reserved4[10];
  PCIE_EP_MSI_MCIDR_tag MSI_MCIDR;     /* PCI Express MSI Message Capability ID Register */
  uint8_t PCIE_EP_reserved5[1];
  PCIE_EP_MSI_MCR_tag MSI_MCR;         /* PCI Express MSI Message Control Register */
  PCIE_EP_MSI_MADDR_tag MSI_MADDR;     /* PCI Express MSI Message Address Register */
  PCIE_EP_MSI_MUADDR_tag MSI_MUADDR;   /* PCI Express MSI Message Upper Address Register */
  PCIE_EP_MSI_MDATR_tag MSI_MDATR;     /* PCI Express MSI Message Data Register */
  uint8_t PCIE_EP_reserved6[18];
  PCIE_EP_CIDR_tag CIDR;               /* Capability ID Register */
  uint8_t PCIE_EP_reserved7[1];
  PCIE_EP_CR_tag CR;                   /* PCI Express Capabilities Register */
  PCIE_EP_DCR_tag DCR;                 /* PCI Express Device Capabilities Register */
  PCIE_EP_DCTRLR_tag DCTRLR;           /* PCI Express Device Control Register */
  PCIE_EP_DSR_tag DSR;                 /* PCI Express Device Status Register */
  PCIE_EP_LCR_tag LCR;                 /* PCI Express Link Capabilities Register */
  PCIE_EP_CTRLR_tag CTRLR;             /* PCI Express Link Control Register */
  PCIE_EP_SR_tag SR;                   /* PCI Express Link Status Register */
  PCIE_EP_SCR_tag SCR;                 /* PCI Express Slot Capabilities Register */
  PCIE_EP_SCTRLR_tag SCTRLR;           /* PCI Express Slot Control Register */
  PCIE_EP_SSR_tag SSR;                 /* PCI Express Slot Status Register */
  PCIE_EP_RCR_tag RCR;                 /* Root Control Register */
  uint8_t PCIE_EP_reserved8[2];
  PCIE_EP_RSR_tag RSR;                 /* PCI Express Root Status Register */
  PCIE_EP_DC_2_tag DC_2;               /* PCI Express Device Capabilities 2 Register */
  PCIE_EP_DCTR_2_tag DCTR_2;           /* PCI Express Device Control 2 Register */
  uint8_t PCIE_EP_reserved9[2];
  PCIE_EP_LC_2_tag LC_2;               /* PCI Express Link Capabilities 2 Register */
  PCIE_EP_LCTR_2_tag LCTR_2;           /* PCI Express Link Control 2 Register */
  PCIE_EP_LS_2_tag LS_2;               /* PCI Express Link Status 2 Register */
  uint8_t PCIE_EP_reserved10[92];
  PCIE_EP_AER_tag AER;                 /* AER Capability Header */
  PCIE_EP_UESR_tag UESR;               /* Uncorrectable Error Status Register */
  PCIE_EP_UEMR_tag UEMR;               /* Uncorrectable Error Mask Register */
  PCIE_EP_UESevR_tag UESevR;           /* Uncorrectable Error Severity Register */
  PCIE_EP_CESR_tag CESR;               /* Correctable Error Status Register */
  PCIE_EP_CEMR_tag CEMR;               /* Correctable Error Mask Register */
  PCIE_EP_ACCR_tag ACCR;               /* Advanced Capabilities and Control Register */
  PCIE_EP_Header_Log_Register_DWORD1_tag Header_Log_Register_DWORD1; /* PCI Express Header Log Register 1 */
  PCIE_EP_Header_Log_Register_DWORD2_tag Header_Log_Register_DWORD2; /* PCI Express Header Log Register 2 */
  PCIE_EP_Header_Log_Register_DWORD3_tag Header_Log_Register_DWORD3; /* PCI Express Header Log Register 3 */
  PCIE_EP_Header_Log_Register_DWORD4_tag Header_Log_Register_DWORD4; /* PCI Express Header Log Register 4 */
  uint8_t PCIE_EP_reserved11[3812];
  PCIE_EP_MASK0_tag MASK0;             /* BAR 0 Mask Register */
  PCIE_EP_MASK1_tag MASK1;             /* BAR 1 Mask Register */
  PCIE_EP_MASK2_tag MASK2;             /* BAR 2 Mask Register */
  PCIE_EP_MASK3_tag MASK3;             /* BAR 3 Mask Register */
  uint8_t PCIE_EP_reserved12[16];
  PCIE_EP_EROMMASK_tag EROMMASK;       /* Expansion ROM BAR Mask Register */
};


/* ============================================================================
   =============================== Module: PCIE_PL ============================
   ============================================================================ */

typedef union PCIE_PL_ALTRTR_union_tag { /* Ack Latency Timer and Replay Timer Register */
  vuint32_t R;
  struct {
    vuint32_t Round_Trip_Latency_Time_Limit:16;
    vuint32_t Replay_Time_Limit:16;
  } B;
} PCIE_PL_ALTRTR_tag;

typedef union PCIE_PL_VSDR_union_tag { /* Vendor Specific DLLP Register */
  vuint32_t R;
  struct {
    vuint32_t Vendor_Specific_DLLP:32;
  } B;
} PCIE_PL_VSDR_tag;

typedef union PCIE_PL_PFLR_union_tag { /* Port Force Link Register */
  vuint32_t R;
  struct {
    vuint32_t Link_Number:8;
    vuint32_t _unused_8:7;
    vuint32_t Force_Link:1;
    vuint32_t Link_State:6;
    vuint32_t _unused_22:2;
    vuint32_t Low_Power_Entrance_Count:8;
  } B;
} PCIE_PL_PFLR_tag;

typedef union PCIE_PL_AFLACR_union_tag { /* Ack Frequency and L0-L1 ASPM Control Register */
  vuint32_t R;
  struct {
    vuint32_t Ack_Frequency:8;
    vuint32_t N_FTS:8;
    vuint32_t Common_Clock_N_FTS:8;
    vuint32_t L0s_Entrance_Latency:3;
    vuint32_t L1_Entrance_Latency:3;
    vuint32_t Enter_ASPM_L1:1;
    vuint32_t _unused_31:1;
  } B;
} PCIE_PL_AFLACR_tag;

typedef union PCIE_PL_PLCR_union_tag { /* Port Link Control Register */
  vuint32_t R;
  struct {
    vuint32_t Vendor_Specific_DLLP_Request:1;
    vuint32_t Scramble_Disable:1;
    vuint32_t Loopback_Enable:1;
    vuint32_t Reset_Assert:1;
    vuint32_t _unused_4:1;
    vuint32_t DLL_Link_Enable:1;
    vuint32_t _unused_6:1;
    vuint32_t Fast_Link_Mode:1;
    vuint32_t _unused_8:8;
    vuint32_t Link_Mode_Enable:6;
    vuint32_t Crosslink_Enable:1;
    vuint32_t Crosslink_Active:1;
    vuint32_t _unused_24:8;
  } B;
} PCIE_PL_PLCR_tag;

typedef union PCIE_PL_LSR_union_tag {  /* Lane Skew Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t Flow_Control_Disable:1;
    vuint32_t Ack_Nak_Disable:1;
    vuint32_t _unused_26:5;
    vuint32_t Disable_Lane_to_Lane_Deskew:1;
  } B;
} PCIE_PL_LSR_tag;

typedef union PCIE_PL_TIMER_CTRL_MAX_NUM_union_tag { /* Timer Control and Max Function Number Register */
  vuint32_t R;
  struct {
    vuint32_t MAX_FUNC_NUM:8;
    vuint32_t _unused_8:6;
    vuint32_t TIMER_MOD_REPLAY_TIMER:5;
    vuint32_t TIMER_MOD_ACK_NAK:5;
    vuint32_t UPDATE_FREQ_TIMER:5;
    vuint32_t _unused_29:3;
  } B;
} PCIE_PL_TIMER_CTRL_MAX_NUM_tag;

typedef union PCIE_PL_STRFM1_union_tag { /* Symbol Timer Register and Filter Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SKP_Interval_Value:11;
    vuint32_t _unused_11:4;
    vuint32_t Disable_FC_Watchdog_Timer:1;
    vuint32_t Mask_RX_SSM_Filtering_and_Error_Handling_Rules:16;
  } B;
} PCIE_PL_STRFM1_tag;

typedef union PCIE_PL_STRFM2_union_tag { /* Filter Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t Mask_RX_SSM_Filtering_and_Error_Handling_Rules:32;
  } B;
} PCIE_PL_STRFM2_tag;

typedef union PCIE_PL_AMODNPSR_union_tag { /* AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register */
  vuint32_t R;
  struct {
    vuint32_t Enable_AMBA_Multiple_Outbound_Decomposed_NP_SubRequests:1;
    vuint32_t _unused_1:31;
  } B;
} PCIE_PL_AMODNPSR_tag;

typedef union PCIE_PL_DEBUG0_union_tag { /* Debug Register 0 */
  vuint32_t R;
  struct {
    vuint32_t VALUE:32;
  } B;
} PCIE_PL_DEBUG0_tag;

typedef union PCIE_PL_DEBUG1_union_tag { /* Debug Register 1 */
  vuint32_t R;
  struct {
    vuint32_t VALUE:32;
  } B;
} PCIE_PL_DEBUG1_tag;

typedef union PCIE_PL_TPFCSR_union_tag { /* Transmit Posted FC Credit Status Register */
  vuint32_t R;
  struct {
    vuint32_t Transmit_Posted_Data_FC_Credits:12;
    vuint32_t Transmit_Posted_Header_FC_Credits:8;
    vuint32_t _unused_20:12;
  } B;
} PCIE_PL_TPFCSR_tag;

typedef union PCIE_PL_TNFCSR_union_tag { /* Transmit Non-Posted FC Credit Status Register */
  vuint32_t R;
  struct {
    vuint32_t Transmit_Non_Posted_Data_FC_Credits:12;
    vuint32_t Transmit_Non_Posted_Header_FC_Credits:8;
    vuint32_t _unused_20:12;
  } B;
} PCIE_PL_TNFCSR_tag;

typedef union PCIE_PL_TCFCSR_union_tag { /* Transmit Completion FC Credit Status Register */
  vuint32_t R;
  struct {
    vuint32_t Transmit_Completion_Data_FC_Credits:12;
    vuint32_t Transmit_Completion_Header_FC_Credits:8;
    vuint32_t _unused_20:12;
  } B;
} PCIE_PL_TCFCSR_tag;

typedef union PCIE_PL_QSR_union_tag {  /* Queue Status Register */
  vuint32_t R;
  struct {
    vuint32_t Received_TLP_FC_Credits_Not_Returned:1;
    vuint32_t Transmit_Retry_Buffer_Not_Empty:1;
    vuint32_t Received_Queue_Not_Empty:1;
    vuint32_t _unused_3:29;
  } B;
} PCIE_PL_QSR_tag;

typedef union PCIE_PL_G2CR_union_tag { /* Gen2 Control Register */
  vuint32_t R;
  struct {
    vuint32_t N_FTS:8;
    vuint32_t Predetermined_Number_of_Lanes:9;
    vuint32_t Directed_Speed_Change:1;
    vuint32_t Config_PHY_Tx_Swing:1;
    vuint32_t Config_Tx_Compliance_Receive_Bit:1;
    vuint32_t De_emphasis_level:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_PL_G2CR_tag;

typedef union PCIE_PL_PHY_STATUS_union_tag { /* PHY Status */
  vuint32_t R;
  struct {
    vuint32_t PHY_Status:32;
  } B;
} PCIE_PL_PHY_STATUS_tag;

typedef union PCIE_PL_PHY_CTRL_union_tag { /* PHY Control */
  vuint32_t R;
  struct {
    vuint32_t PHY_Control:32;
  } B;
} PCIE_PL_PHY_CTRL_tag;

typedef union PCIE_PL_MRCCR0_union_tag { /* Master Response Composer Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t Remote_Read_Request_Size:3;
    vuint32_t _unused_3:5;
    vuint32_t Remote_Max_Bridge_Tag:8;
    vuint32_t _unused_16:16;
  } B;
} PCIE_PL_MRCCR0_tag;

typedef union PCIE_PL_MRCCR1_union_tag { /* Master Response Composer Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t Segmented_Buffer_Controller_Initialize:1;
    vuint32_t _unused_1:31;
  } B;
} PCIE_PL_MRCCR1_tag;

typedef union PCIE_PL_MSICA_union_tag { /* MSI Controller Address */
  vuint32_t R;
  struct {
    vuint32_t MSI_Controller_Address:32;
  } B;
} PCIE_PL_MSICA_tag;

typedef union PCIE_PL_MSICUA_union_tag { /* MSI Controller Upper Address */
  vuint32_t R;
  struct {
    vuint32_t MSI_Controller_Upper_Address:32;
  } B;
} PCIE_PL_MSICUA_tag;

typedef union PCIE_PL_MSICIn_ENB_union_tag { /* MSI Controller Interrupt n Enable */
  vuint32_t R;
  struct {
    vuint32_t MSI_Interrupt0_Enable:32;
  } B;
} PCIE_PL_MSICIn_ENB_tag;

typedef union PCIE_PL_MSICIn_MASK_union_tag { /* MSI Controller Interrupt n Mask */
  vuint32_t R;
  struct {
    vuint32_t MSI_Interrupt0_Mask:32;
  } B;
} PCIE_PL_MSICIn_MASK_tag;

typedef union PCIE_PL_MSICIn_STATUS_union_tag { /* MSI Controller Interrupt nStatus */
  vuint32_t R;
  struct {
    vuint32_t MSI_Interrupt0_Status:32;
  } B;
} PCIE_PL_MSICIn_STATUS_tag;

typedef union PCIE_PL_MSICGPIO_union_tag { /* MSI Controller General Purpose IO Register */
  vuint32_t R;
  struct {
    vuint32_t MSI_GPIO_Register:32;
  } B;
} PCIE_PL_MSICGPIO_tag;

typedef union PCIE_PL_iATMVR_union_tag { /* iATM Viewport Register */
  vuint32_t R;
  struct {
    vuint32_t Region_Index:4;
    vuint32_t _unused_4:27;
    vuint32_t Region_Direction:1;
  } B;
} PCIE_PL_iATMVR_tag;

typedef union PCIE_PL_iATMRC1_union_tag { /* iATM Region Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t TYPE:5;
    vuint32_t TC:3;
    vuint32_t TD:1;
    vuint32_t ATTR:2;
    vuint32_t _unused_11:5;
    vuint32_t AT:2;
    vuint32_t _unused_18:2;
    vuint32_t Function_Number:3;
    vuint32_t _unused_23:9;
  } B;
} PCIE_PL_iATMRC1_tag;

typedef union PCIE_PL_iATMRC2_union_tag { /* iATM Region Control 2 Register */
  vuint32_t R;
  struct {
    vuint32_t Message_Code:8;
    vuint32_t BAR_Number:3;
    vuint32_t _unused_11:3;
    vuint32_t TC_Match_Enable:1;
    vuint32_t TD_Match_Enable:1;
    vuint32_t ATTR_Match_Enable:1;
    vuint32_t _unused_17:1;
    vuint32_t AT_Match_Enable:1;
    vuint32_t Function_Number_Match_Enable:1;
    vuint32_t Virtual_Function_Number_Match_Enable:1;
    vuint32_t Message_Code_Match_Enable:1;
    vuint32_t _unused_22:2;
    vuint32_t Response_Code:2;
    vuint32_t _unused_26:1;
    vuint32_t Fuzzy_Type_Match_Mode:1;
    vuint32_t CFG_Shift_Mode:1;
    vuint32_t Invert_Mode:1;
    vuint32_t Match_Mode:1;
    vuint32_t Region_Enable:1;
  } B;
} PCIE_PL_iATMRC2_tag;

typedef union PCIE_PL_iATMRLBA_union_tag { /* iATM Region Lower Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t Address_lower:16;
    vuint32_t Address_upper:16;
  } B;
} PCIE_PL_iATMRLBA_tag;

typedef union PCIE_PL_iATMRUBA_union_tag { /* iATM Region Upper Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t Address:32;
  } B;
} PCIE_PL_iATMRUBA_tag;

typedef union PCIE_PL_iATMRLA_union_tag { /* iATM Region Limit Address Register */
  vuint32_t R;
  struct {
    vuint32_t Address_lower:16;
    vuint32_t Address_upper:16;
  } B;
} PCIE_PL_iATMRLA_tag;

typedef union PCIE_PL_iATMRLTA_union_tag { /* iATM Region Lower Target Address Register */
  vuint32_t R;
  struct {
    vuint32_t Address_lower:16;
    vuint32_t Address_upper:16;
  } B;
} PCIE_PL_iATMRLTA_tag;

typedef union PCIE_PL_iATMRUTA_union_tag { /* iATM Region Upper Target Address Register */
  vuint32_t R;
  struct {
    vuint32_t Address:32;
  } B;
} PCIE_PL_iATMRUTA_tag;

struct PCIE_PL_tag {
  uint8_t PCIE_PL_reserved0[1792];
  PCIE_PL_ALTRTR_tag ALTRTR;           /* Ack Latency Timer and Replay Timer Register */
  PCIE_PL_VSDR_tag VSDR;               /* Vendor Specific DLLP Register */
  PCIE_PL_PFLR_tag PFLR;               /* Port Force Link Register */
  PCIE_PL_AFLACR_tag AFLACR;           /* Ack Frequency and L0-L1 ASPM Control Register */
  PCIE_PL_PLCR_tag PLCR;               /* Port Link Control Register */
  PCIE_PL_LSR_tag LSR;                 /* Lane Skew Register */
  PCIE_PL_TIMER_CTRL_MAX_NUM_tag TIMER_CTRL_MAX_NUM; /* Timer Control and Max Function Number Register */
  PCIE_PL_STRFM1_tag STRFM1;           /* Symbol Timer Register and Filter Mask Register 1 */
  PCIE_PL_STRFM2_tag STRFM2;           /* Filter Mask Register 2 */
  PCIE_PL_AMODNPSR_tag AMODNPSR;       /* AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register */
  PCIE_PL_DEBUG0_tag DEBUG0;           /* Debug Register 0 */
  PCIE_PL_DEBUG1_tag DEBUG1;           /* Debug Register 1 */
  PCIE_PL_TPFCSR_tag TPFCSR;           /* Transmit Posted FC Credit Status Register */
  PCIE_PL_TNFCSR_tag TNFCSR;           /* Transmit Non-Posted FC Credit Status Register */
  PCIE_PL_TCFCSR_tag TCFCSR;           /* Transmit Completion FC Credit Status Register */
  PCIE_PL_QSR_tag QSR;                 /* Queue Status Register */
  uint8_t PCIE_PL_reserved1[204];
  PCIE_PL_G2CR_tag G2CR;               /* Gen2 Control Register */
  PCIE_PL_PHY_STATUS_tag PHY_STATUS;   /* PHY Status */
  PCIE_PL_PHY_CTRL_tag PHY_CTRL;       /* PHY Control */
  PCIE_PL_MRCCR0_tag MRCCR0;           /* Master Response Composer Control Register 0 */
  PCIE_PL_MRCCR1_tag MRCCR1;           /* Master Response Composer Control Register 1 */
  PCIE_PL_MSICA_tag MSICA;             /* MSI Controller Address */
  PCIE_PL_MSICUA_tag MSICUA;           /* MSI Controller Upper Address */
  PCIE_PL_MSICIn_ENB_tag MSICIn_ENB;   /* MSI Controller Interrupt n Enable */
  PCIE_PL_MSICIn_MASK_tag MSICIn_MASK; /* MSI Controller Interrupt n Mask */
  PCIE_PL_MSICIn_STATUS_tag MSICIn_STATUS[8]; /* MSI Controller Interrupt nStatus */
  uint8_t PCIE_PL_reserved2[56];
  PCIE_PL_MSICGPIO_tag MSICGPIO;       /* MSI Controller General Purpose IO Register */
  uint8_t PCIE_PL_reserved3[116];
  PCIE_PL_iATMVR_tag iATMVR;           /* iATM Viewport Register */
  PCIE_PL_iATMRC1_tag iATMRC1;         /* iATM Region Control 1 Register */
  PCIE_PL_iATMRC2_tag iATMRC2;         /* iATM Region Control 2 Register */
  PCIE_PL_iATMRLBA_tag iATMRLBA;       /* iATM Region Lower Base Address Register */
  PCIE_PL_iATMRUBA_tag iATMRUBA;       /* iATM Region Upper Base Address Register */
  PCIE_PL_iATMRLA_tag iATMRLA;         /* iATM Region Limit Address Register */
  PCIE_PL_iATMRLTA_tag iATMRLTA;       /* iATM Region Lower Target Address Register */
  PCIE_PL_iATMRUTA_tag iATMRUTA;       /* iATM Region Upper Target Address Register */
};


/* ============================================================================
   =============================== Module: PCIE_RC ============================
   ============================================================================ */

typedef union PCIE_RC_DeviceID_union_tag { /* Device ID and Vendor ID Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t Vendor_ID:16;
  } B;
} PCIE_RC_DeviceID_tag;

typedef union PCIE_RC_Command_union_tag { /* Command and Status Register */
  vuint32_t R;
  struct {
    vuint32_t I_O_Space_Enable:1;
    vuint32_t Memory_Space_Enable:1;
    vuint32_t Bus_Master_Enable:1;
    vuint32_t Special_Cycle_Enable:1;
    vuint32_t Memory_Write_and_Invalidate:1;
    vuint32_t VGA_Palette_Snoop:1;
    vuint32_t Parity_Error_Response:1;
    vuint32_t IDSEL_Stepping:1;
    vuint32_t SERR_Enable:1;
    vuint32_t Fast_Back_to_Back_Enable:1;
    vuint32_t INTx_Assertion_Disable:1;
    vuint32_t _unused_11:5;
    vuint32_t _unused_16:3;
    vuint32_t INTx_Status:1;
    vuint32_t Capabilities_List:1;
    vuint32_t SixtySix_MHz_Capable:1;
    vuint32_t _unused_22:1;
    vuint32_t Fast_Back_to_Back_Capable:1;
    vuint32_t Master_Data_Parity_Error:1;
    vuint32_t DEVSEL_Timing:2;
    vuint32_t Signaled_Target_Abort:1;
    vuint32_t Received_Target_Abort:1;
    vuint32_t Received_Master_Abort:1;
    vuint32_t Detected_Parity_Error:1;
    vuint32_t Signaled_System_Error:1;
  } B;
} PCIE_RC_Command_tag;

typedef union PCIE_RC_BIST_union_tag { /* BIST Register */
  vuint32_t R;
  struct {
    vuint32_t Cache_Line_Size:8;
    vuint32_t Master_Latency_Timer:8;
    vuint32_t Configuration_Header_Format:7;
    vuint32_t Multi_Function_Device:1;
    vuint32_t Not_supported_by__core:8;
  } B;
} PCIE_RC_BIST_tag;

typedef union PCIE_RC_BAR0_union_tag { /* Base Address 0 */
  vuint32_t R;
  struct {
    vuint32_t Mem_I_O:1;
    vuint32_t TYPE:2;
    vuint32_t PREF:1;
    vuint32_t ADDRESS:28;
  } B;
} PCIE_RC_BAR0_tag;

typedef union PCIE_RC_BAR1_union_tag { /* Base Address 1 */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;
  } B;
} PCIE_RC_BAR1_tag;

typedef union PCIE_RC_BNR_union_tag {  /* Bus Number Registers */
  vuint32_t R;
  struct {
    vuint32_t PRIMARY_BUS_NUM:8;
    vuint32_t SECONDARY_BUS_NUM:8;
    vuint32_t SUBORD_BUS_NUM:8;
    vuint32_t SECONDARY_LAT_TMR:8;
  } B;
} PCIE_RC_BNR_tag;

typedef union PCIE_RC_IOBLSSR_union_tag { /* I/O Base Limit Secondary Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t IO_SB:4;
    vuint32_t _unused_8:4;
    vuint32_t IO_SL:4;
    vuint32_t _unused_16:5;
    vuint32_t CAP66M:1;
    vuint32_t _unused_22:1;
    vuint32_t FAST_B2B_CAP:1;
    vuint32_t MSTR_DAT_PARITY_ERR:1;
    vuint32_t _unused_25:2;
    vuint32_t SIG_TARGET_ABORT:1;
    vuint32_t RX_TARGET_ABORT:1;
    vuint32_t RX_MASTER_ABORT:1;
    vuint32_t RX_SYS_ERR:1;
    vuint32_t DET_PARITY_ERR:1;
  } B;
} PCIE_RC_IOBLSSR_tag;

typedef union PCIE_RC_MEM_BLR_union_tag { /* Memory Base and Memory Limit Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t MEM_BASE_ADD:8;
    vuint32_t _unused_16:8;
    vuint32_t MEM_LIM_ADD:8;
  } B;
} PCIE_RC_MEM_BLR_tag;

typedef union PCIE_RC_PREF_MEM_BLR_union_tag { /* Prefetchable Memory Base and Limit Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t UPPER12_START_ADD:12;
    vuint32_t _unused_16:4;
    vuint32_t UPPER12_END_ADD:12;
  } B;
} PCIE_RC_PREF_MEM_BLR_tag;

typedef union PCIE_RC_PREF_BASE_U32_union_tag { /* Prefetchable Base Upper 32 Bits Register */
  vuint32_t R;
  struct {
    vuint32_t UPPER32_BASE_PREF_MEM_ADD:32;
  } B;
} PCIE_RC_PREF_BASE_U32_tag;

typedef union PCIE_RC_PREF_LIM_U32_union_tag { /* Prefetchable Limit Upper 32 Bits Register */
  vuint32_t R;
  struct {
    vuint32_t UPPER32_LIM_PREF_MEM_ADD:32;
  } B;
} PCIE_RC_PREF_LIM_U32_tag;

typedef union PCIE_RC_IO_BASE_LIM_U16_union_tag { /* I/O Base and Limit Upper 16 Bits Register */
  vuint32_t R;
  struct {
    vuint32_t UPPER16_IO_BASE:16;
    vuint32_t UPPER16_IO_LIM:16;
  } B;
} PCIE_RC_IO_BASE_LIM_U16_tag;

typedef union PCIE_RC_CAPPR_union_tag { /* Capability Pointer Register */
  vuint32_t R;
  struct {
    vuint32_t CFG_NEXT_PTR:8;
    vuint32_t _unused_8:24;
  } B;
} PCIE_RC_CAPPR_tag;

typedef union PCIE_RC_EROMBAR_union_tag { /* Expansion ROM Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t _unused_1:10;
    vuint32_t ADDRESS:21;
  } B;
} PCIE_RC_EROMBAR_tag;

typedef union PCIE_RC_Interrupt_Line_Register_union_tag { /* PCI Express Interrupt Line Register */
  vuint32_t R;
  struct {
    vuint32_t Interrupt_Line:8;
    vuint32_t _unused_8:24;
  } B;
} PCIE_RC_Interrupt_Line_Register_tag;

typedef union PCIE_RC_PMCR_union_tag { /* Power Management Capability Register */
  vuint32_t R;
  struct {
    vuint32_t Power_Management_Capability_ID:8;
    vuint32_t Next_Capability_Pointer:8;
    vuint32_t Power_Management_specification_version:3;
    vuint32_t PME_Clock:1;
    vuint32_t _unused_20:1;
    vuint32_t DSI:1;
    vuint32_t AUX_Current:3;
    vuint32_t D1_Support:1;
    vuint32_t D2_Support:1;
    vuint32_t PME_Support:5;
  } B;
} PCIE_RC_PMCR_tag;

typedef union PCIE_RC_PMCSR_union_tag { /* Power Management Control and Status Register */
  vuint32_t R;
  struct {
    vuint32_t Power_State:2;
    vuint32_t _unused_2:1;
    vuint32_t No_Soft_Reset:1;
    vuint32_t _unused_4:4;
    vuint32_t PME_Enable:1;
    vuint32_t Data_Select:4;
    vuint32_t Data_Scale:2;
    vuint32_t PME_Status:1;
    vuint32_t _unused_16:6;
    vuint32_t B2_B3_Support:1;
    vuint32_t Bus_Power_Clock_Control_Enable:1;
    vuint32_t Data_register_for_additional_information:8;
  } B;
} PCIE_RC_PMCSR_tag;

typedef union PCIE_RC_CIDR_union_tag { /* PCI Express Capability ID Register */
  vuint32_t R;
  struct {
    vuint32_t PCI_Express_Capability_ID:8;
    vuint32_t Next_Capability_Pointer:8;
    vuint32_t PCI_Express_Capability_Version:4;
    vuint32_t Device_Port_Type:4;
    vuint32_t Slot_Implemented:1;
    vuint32_t Interrupt_Message_Number:5;
    vuint32_t _unused_30:2;
  } B;
} PCIE_RC_CIDR_tag;

typedef union PCIE_RC_DCR_union_tag {  /* Device Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t Max_Payload_Size_Supported:3;
    vuint32_t Phantom_Function_Supported:2;
    vuint32_t Extended_Tag_Field_Supported:1;
    vuint32_t Endpoint_L0s_Acceptable_Latency:3;
    vuint32_t Endpoint_L1_Acceptable_Latency:3;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t Role_Based_Error_Reporting:1;
    vuint32_t _unused_16:2;
    vuint32_t Captured_Slot_Power_Limit_Value:8;
    vuint32_t Captured_Slot_Power_Limit_Scale:2;
    vuint32_t _unused_28:4;
  } B;
} PCIE_RC_DCR_tag;

typedef union PCIE_RC_DConR_union_tag { /* Device Control Register */
  vuint32_t R;
  struct {
    vuint32_t Correctable_Error_Reporting_Enable:1;
    vuint32_t Non_Fatal_Error_Reporting_Enable:1;
    vuint32_t Fatal_Error_Reporting_Enable:1;
    vuint32_t Unsupported_Request_Reporting_Enable:1;
    vuint32_t Enable_Relaxed_Ordering:1;
    vuint32_t Max_Payload_Size:3;
    vuint32_t Extended_Tag_Field_Enable:1;
    vuint32_t Phantom_Function_Enable:1;
    vuint32_t AUX_Power_PM_Enable:1;
    vuint32_t Enable_No_Snoop:1;
    vuint32_t Max_Read_Request_Size:3;
    vuint32_t _unused_15:1;
    vuint32_t Correctable_Error_Detected:1;
    vuint32_t Non_Fatal_Error_detected:1;
    vuint32_t Fatal_Error_Detected:1;
    vuint32_t Unsupported_Request_Detected:1;
    vuint32_t Aux_Power_Detected:1;
    vuint32_t Transaction_Pending:1;
    vuint32_t _unused_22:10;
  } B;
} PCIE_RC_DConR_tag;

typedef union PCIE_RC_LCR_union_tag {  /* Link Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t Max_Link_Speeds:4;
    vuint32_t Maximum_Link_Width:6;
    vuint32_t Active_State_Link_PM_Support:2;
    vuint32_t L0s_Exit_Latency:3;
    vuint32_t L1_Exit_Latency:3;
    vuint32_t Clock_Power_Management:1;
    vuint32_t Surprise_Down_Error_Reporting_Capable:1;
    vuint32_t Data_Link_Layer_Active_Reporting_Capable:1;
    vuint32_t Link_Bandwidth_Notification_Capability:1;
    vuint32_t _unused_22:2;
    vuint32_t Port_Number:8;
  } B;
} PCIE_RC_LCR_tag;

typedef union PCIE_RC_LCSR_union_tag { /* Link Control and Status Register */
  vuint32_t R;
  struct {
    vuint32_t Active_State_Link_PM_Control:2;
    vuint32_t _unused_2:1;
    vuint32_t RCB:1;
    vuint32_t Link_Disable:1;
    vuint32_t Retrain_Link:1;
    vuint32_t Common_Clock_Configuration:1;
    vuint32_t Extended_Synch:1;
    vuint32_t Enable_Clock_Power_Management:1;
    vuint32_t Hardware_Autonomous_Width_Disable:1;
    vuint32_t Link_Bandwidth_Management_Interrupt_Enable:1;
    vuint32_t Link_Autonomous_Bandwidth_Interrupt_Enable:1;
    vuint32_t _unused_12:4;
    vuint32_t Link_Speed:4;
    vuint32_t Negotiated_Link_Width:6;
    vuint32_t _unused_26:1;
    vuint32_t Link_Training:1;
    vuint32_t Slot_Clock_Configuration:1;
    vuint32_t Data_Link_Layer_Active:1;
    vuint32_t Link_Bandwidth_Management_Status:1;
    vuint32_t Link_Autonomous_Bandwidth_Status:1;
  } B;
} PCIE_RC_LCSR_tag;

typedef union PCIE_RC_SCR_union_tag {  /* Slot Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t Attention_Indicator_Present:1;
    vuint32_t Power_Controller_Present_0:1;
    vuint32_t MRL_Sensor_Present:1;
    vuint32_t Attention_Indicator_Present_1:1;
    vuint32_t Power_Indicator_Present:1;
    vuint32_t Hot_Plug_Surprise:1;
    vuint32_t Hot_Plug_Capable:1;
    vuint32_t Slot_Power_Limit_Value:8;
    vuint32_t Slot_Power_Limit_Scale:2;
    vuint32_t Electromechanical_Interlock_Present:1;
    vuint32_t No_Command_Complete_Support:1;
    vuint32_t Physical_Slot_Number:13;
  } B;
} PCIE_RC_SCR_tag;

typedef union PCIE_RC_SCSR_union_tag { /* Slot Control and Status Register */
  vuint32_t R;
  struct {
    vuint32_t Attention_Button_Pressed_Enable:1;
    vuint32_t Power_Fault_Detected_Enable:1;
    vuint32_t MRL_Sensor_Changed_Enable:1;
    vuint32_t Presence_Detect_Changed_Enable:1;
    vuint32_t Command_Completed_Interrupt_Enable:1;
    vuint32_t Hot_Plug_Interrupt_Enable:1;
    vuint32_t Attention_Indicator_Control:2;
    vuint32_t Power_Indicator_Control:2;
    vuint32_t Power_Controller_Control:1;
    vuint32_t Electromechanical_Interlock_Control:1;
    vuint32_t Data_Link_Layer_State_Changed_Enable:1;
    vuint32_t _unused_13:3;
    vuint32_t Attention_Button_Pressed:1;
    vuint32_t Power_Fault_Detected:1;
    vuint32_t MRL_Sensor_Changed:1;
    vuint32_t Presence_Detect_Changed:1;
    vuint32_t Command_Completed:1;
    vuint32_t MRL_Sensor_State:1;
    vuint32_t Presence_Detect_State:1;
    vuint32_t Electromechanical_Interlock_Status:1;
    vuint32_t Data_Link_Layer_State_Changed:1;
    vuint32_t _unused_25:7;
  } B;
} PCIE_RC_SCSR_tag;

typedef union PCIE_RC_RCCR_union_tag { /* Root Control and Capabilities Register */
  vuint32_t R;
  struct {
    vuint32_t System_Error_on_Correctable_Error_Enable:1;
    vuint32_t System_Error_on_Non_fatal_Error_Enable:1;
    vuint32_t System_Error_on_Fatal_Error_Enable:1;
    vuint32_t PME_Interrupt_Enable:1;
    vuint32_t CRS_Software_Visibility_Enable:1;
    vuint32_t _unused_5:11;
    vuint32_t CRS_Software_Visibility:1;
    vuint32_t _unused_17:15;
  } B;
} PCIE_RC_RCCR_tag;

typedef union PCIE_RC_RSR_union_tag {  /* Root Status Register */
  vuint32_t R;
  struct {
    vuint32_t PME_Requester_ID:16;
    vuint32_t PME_Status:1;
    vuint32_t PME_Pending:1;
    vuint32_t _unused_18:14;
  } B;
} PCIE_RC_RSR_tag;

typedef union PCIE_RC_DCR2_union_tag { /* Device Capabilities 2 Register */
  vuint32_t R;
  struct {
    vuint32_t Completion_Timeout_Ranges_Supported:4;
    vuint32_t Completion_Timeout_Disable_Supported:1;
    vuint32_t _unused_5:27;
  } B;
} PCIE_RC_DCR2_tag;

typedef union PCIE_RC_DCSR2_union_tag { /* Device Control and Status 2 Register */
  vuint32_t R;
  struct {
    vuint32_t Completion_Timeout_Value:4;
    vuint32_t Completion_Timeout_Disable:1;
    vuint32_t _unused_5:27;
  } B;
} PCIE_RC_DCSR2_tag;

typedef union PCIE_RC_LCR2_union_tag { /* Link Capabilities 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t Supported_Link_Speeds_Vector:7;
    vuint32_t Crosslink_Supported:1;
    vuint32_t _unused_9:23;
  } B;
} PCIE_RC_LCR2_tag;

typedef union PCIE_RC_LCSR2_union_tag { /* Link Control and Status 2 Register */
  vuint32_t R;
  struct {
    vuint32_t Target_Link_Speed:4;
    vuint32_t Enter_Compliance:1;
    vuint32_t Hardware_Autonomous_Speed_Disable:1;
    vuint32_t Selectable_Deemphasis:1;
    vuint32_t Transmit_Margin:3;
    vuint32_t Enter_Modified_Compliance:1;
    vuint32_t Compliance_SOS:1;
    vuint32_t Compliance_Pre_set_Deemphasis:4;
    vuint32_t Current_Deemphasis_Level:1;
    vuint32_t Equalization_Complete:1;
    vuint32_t Equalization_Phase_1_Successful:1;
    vuint32_t Equalization_Phase_2_Successful:1;
    vuint32_t Equalization_Phase_3_Successful:1;
    vuint32_t Link_Equalization_Request:1;
    vuint32_t _unused_22:10;
  } B;
} PCIE_RC_LCSR2_tag;

typedef union PCIE_RC_AER_union_tag {  /* AER Capability Header */
  vuint32_t R;
  struct {
    vuint32_t PCI_Express_Extended_Capability_ID:16;
    vuint32_t Capability_Version:4;
    vuint32_t Next_Capability_Offset:12;
  } B;
} PCIE_RC_AER_tag;

typedef union PCIE_RC_UESR_union_tag { /* Uncorrectable Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Status:1;
    vuint32_t Surprise_Down_Error_Status:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Status:1;
    vuint32_t Flow_Control_Protocol_Error_Status:1;
    vuint32_t Completion_Timeout_Status:1;
    vuint32_t Completer_Abort_Status:1;
    vuint32_t Unexpected_Completion_Status:1;
    vuint32_t Receiver_Overflow_Status:1;
    vuint32_t Malformed_TLP_Status:1;
    vuint32_t ECRC_Error_Status:1;
    vuint32_t Unsupported_Request_Error_Status:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_RC_UESR_tag;

typedef union PCIE_RC_UEMR_union_tag { /* Uncorrectable Error Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Mask:1;
    vuint32_t Surprise_Down_Error_Mask:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Mask:1;
    vuint32_t Flow_Control_Protocol_Error_Mask:1;
    vuint32_t Completion_Timeout_Mask:1;
    vuint32_t Completer_Abort_Mask:1;
    vuint32_t Unexpected_Completion_Mask:1;
    vuint32_t Receiver_Overflow_Mask:1;
    vuint32_t Malformed_TLP_Mask:1;
    vuint32_t ECRC_Error_Mask:1;
    vuint32_t Unsupported_Request_Error_Mask:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_RC_UEMR_tag;

typedef union PCIE_RC_UESevR_union_tag { /* Uncorrectable Error Severity Register */
  vuint32_t R;
  struct {
    vuint32_t Undefined:1;
    vuint32_t _unused_1:3;
    vuint32_t Data_Link_Protocol_Error_Severity:1;
    vuint32_t Surprise_Down_Error_Severity:1;
    vuint32_t _unused_6:6;
    vuint32_t Poisoned_TLP_Severity:1;
    vuint32_t Flow_Control_Protocol_Error_Severity:1;
    vuint32_t Completion_Timeout_Severity:1;
    vuint32_t Completer_Abort_Severity:1;
    vuint32_t Unexpected_Completion_Severity:1;
    vuint32_t Receiver_Overflow_Severity:1;
    vuint32_t Malformed_TLP_Severity:1;
    vuint32_t ECRC_Error_Severity:1;
    vuint32_t Unsupported_Request_Error_Severity:1;
    vuint32_t _unused_21:11;
  } B;
} PCIE_RC_UESevR_tag;

typedef union PCIE_RC_CESR_union_tag { /* Correctable Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t Receiver_Error_Status:1;
    vuint32_t _unused_1:5;
    vuint32_t Bad_TLP_Status:1;
    vuint32_t Bad_DLLP_Status:1;
    vuint32_t REPLAY_NUM_Rollover_Status:1;
    vuint32_t _unused_9:3;
    vuint32_t Reply_Timer_Timeout_Status:1;
    vuint32_t Advisory_Non_Fatal_Error_Status:1;
    vuint32_t _unused_14:18;
  } B;
} PCIE_RC_CESR_tag;

typedef union PCIE_RC_CEMR_union_tag { /* Correctable Error Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Receiver_Error_Mask:1;
    vuint32_t _unused_1:5;
    vuint32_t Bad_TLP_Mask:1;
    vuint32_t Bad_DLLP_Mask:1;
    vuint32_t REPLAY_NUM_Rollover_Mask:1;
    vuint32_t _unused_9:3;
    vuint32_t Reply_Timer_Timeout_Mask:1;
    vuint32_t Advisory_Non_Fatal_Error_Mask:1;
    vuint32_t _unused_14:18;
  } B;
} PCIE_RC_CEMR_tag;

typedef union PCIE_RC_AECCR_union_tag { /* Advanced Error Capabilities and Control Register */
  vuint32_t R;
  struct {
    vuint32_t First_Error_Pointer:5;
    vuint32_t ECRC_Generation_Capability:1;
    vuint32_t ECRC_Generation_Enable:1;
    vuint32_t ECRC_Check_Capable:1;
    vuint32_t ECRC_Check_Enable:1;
    vuint32_t _unused_9:23;
  } B;
} PCIE_RC_AECCR_tag;

typedef union PCIE_RC_Header_Log_Register_DWORD1_union_tag { /* PCI Express Header Log Register 1 */
  vuint32_t R;
  struct {
    vuint32_t Byte_3:8;
    vuint32_t Byte_2:8;
    vuint32_t Byte_1:8;
    vuint32_t Byte_0:8;
  } B;
} PCIE_RC_Header_Log_Register_DWORD1_tag;

typedef union PCIE_RC_Header_Log_Register_DWORD2_union_tag { /* PCI Express Header Log Register 2 */
  vuint32_t R;
  struct {
    vuint32_t Byte_7:8;
    vuint32_t Byte_6:8;
    vuint32_t Byte_5:8;
    vuint32_t Byte_4:8;
  } B;
} PCIE_RC_Header_Log_Register_DWORD2_tag;

typedef union PCIE_RC_Header_Log_Register_DWORD3_union_tag { /* PCI Express Header Log Register 3 */
  vuint32_t R;
  struct {
    vuint32_t Byte_B:8;
    vuint32_t Byte_A:8;
    vuint32_t Byte_9:8;
    vuint32_t Byte_8:8;
  } B;
} PCIE_RC_Header_Log_Register_DWORD3_tag;

typedef union PCIE_RC_Header_Log_Register_DWORD4_union_tag { /* PCI Express Header Log Register 4 */
  vuint32_t R;
  struct {
    vuint32_t Byte_F:8;
    vuint32_t Byte_E:8;
    vuint32_t Byte_D:8;
    vuint32_t Byte_C:8;
  } B;
} PCIE_RC_Header_Log_Register_DWORD4_tag;

typedef union PCIE_RC_RECR_union_tag { /* Root Error Command Register */
  vuint32_t R;
  struct {
    vuint32_t Correctable_Error_Reporting_Enable:1;
    vuint32_t Non_Fatal_Error_Reporting_Enable:1;
    vuint32_t Fatal_Error_Reporting_Enable:1;
    vuint32_t _unused_3:29;
  } B;
} PCIE_RC_RECR_tag;

typedef union PCIE_RC_RESR_union_tag { /* Root Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_COR_Received:1;
    vuint32_t Multiple_ERR_COR_Received:1;
    vuint32_t ERR_FATAL_NONFATAL_Received:1;
    vuint32_t Multiple_ERR_FATAL_NONFATAL_Received:1;
    vuint32_t First_Uncorrectable_Fatal:1;
    vuint32_t Non_Fatal_Error_Messages_Received:1;
    vuint32_t Fatal_Error_Messages_Received:1;
    vuint32_t _unused_7:20;
    vuint32_t Advanced_Error_Interrupt_Message_Number:5;
  } B;
} PCIE_RC_RESR_tag;

typedef union PCIE_RC_ESIR_union_tag { /* Error Source Identification Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_COR_SID:16;
    vuint32_t ERR_FATAL_NONFATAL_SID:16;
  } B;
} PCIE_RC_ESIR_tag;

typedef union PCIE_RC_MASK0_union_tag { /* BAR 0 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t MASK:31;
  } B;
} PCIE_RC_MASK0_tag;

typedef union PCIE_RC_MASK1_union_tag { /* BAR 1 Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;
  } B;
} PCIE_RC_MASK1_tag;

typedef union PCIE_RC_EROMMASK_union_tag { /* Expansion ROM BAR Mask Register */
  vuint32_t R;
  struct {
    vuint32_t ROM_BAR_ENABLED_N:1;
    vuint32_t ROM_MASK_N:31;
  } B;
} PCIE_RC_EROMMASK_tag;

struct PCIE_RC_tag {
  PCIE_RC_DeviceID_tag DeviceID;       /* Device ID and Vendor ID Register */
  PCIE_RC_Command_tag Command;         /* Command and Status Register */
  uint8_t PCIE_RC_reserved0[4];
  PCIE_RC_BIST_tag BIST;               /* BIST Register */
  PCIE_RC_BAR0_tag BAR0;               /* Base Address 0 */
  PCIE_RC_BAR1_tag BAR1;               /* Base Address 1 */
  PCIE_RC_BNR_tag BNR;                 /* Bus Number Registers */
  PCIE_RC_IOBLSSR_tag IOBLSSR;         /* I/O Base Limit Secondary Status Register */
  PCIE_RC_MEM_BLR_tag MEM_BLR;         /* Memory Base and Memory Limit Register */
  PCIE_RC_PREF_MEM_BLR_tag PREF_MEM_BLR; /* Prefetchable Memory Base and Limit Register */
  PCIE_RC_PREF_BASE_U32_tag PREF_BASE_U32; /* Prefetchable Base Upper 32 Bits Register */
  PCIE_RC_PREF_LIM_U32_tag PREF_LIM_U32; /* Prefetchable Limit Upper 32 Bits Register */
  PCIE_RC_IO_BASE_LIM_U16_tag IO_BASE_LIM_U16; /* I/O Base and Limit Upper 16 Bits Register */
  PCIE_RC_CAPPR_tag CAPPR;             /* Capability Pointer Register */
  PCIE_RC_EROMBAR_tag EROMBAR;         /* Expansion ROM Base Address Register */
  PCIE_RC_Interrupt_Line_Register_tag Interrupt_Line_Register; /* PCI Express Interrupt Line Register */
  PCIE_RC_PMCR_tag PMCR;               /* Power Management Capability Register */
  PCIE_RC_PMCSR_tag PMCSR;             /* Power Management Control and Status Register */
  uint8_t PCIE_RC_reserved1[40];
  PCIE_RC_CIDR_tag CIDR;               /* PCI Express Capability ID Register */
  PCIE_RC_DCR_tag DCR;                 /* Device Capabilities Register */
  PCIE_RC_DConR_tag DConR;             /* Device Control Register */
  PCIE_RC_LCR_tag LCR;                 /* Link Capabilities Register */
  PCIE_RC_LCSR_tag LCSR;               /* Link Control and Status Register */
  PCIE_RC_SCR_tag SCR;                 /* Slot Capabilities Register */
  PCIE_RC_SCSR_tag SCSR;               /* Slot Control and Status Register */
  PCIE_RC_RCCR_tag RCCR;               /* Root Control and Capabilities Register */
  PCIE_RC_RSR_tag RSR;                 /* Root Status Register */
  PCIE_RC_DCR2_tag DCR2;               /* Device Capabilities 2 Register */
  PCIE_RC_DCSR2_tag DCSR2;             /* Device Control and Status 2 Register */
  PCIE_RC_LCR2_tag LCR2;               /* Link Capabilities 2 Register */
  PCIE_RC_LCSR2_tag LCSR2;             /* Link Control and Status 2 Register */
  uint8_t PCIE_RC_reserved2[92];
  PCIE_RC_AER_tag AER;                 /* AER Capability Header */
  PCIE_RC_UESR_tag UESR;               /* Uncorrectable Error Status Register */
  PCIE_RC_UEMR_tag UEMR;               /* Uncorrectable Error Mask Register */
  PCIE_RC_UESevR_tag UESevR;           /* Uncorrectable Error Severity Register */
  PCIE_RC_CESR_tag CESR;               /* Correctable Error Status Register */
  PCIE_RC_CEMR_tag CEMR;               /* Correctable Error Mask Register */
  PCIE_RC_AECCR_tag AECCR;             /* Advanced Error Capabilities and Control Register */
  PCIE_RC_Header_Log_Register_DWORD1_tag Header_Log_Register_DWORD1; /* PCI Express Header Log Register 1 */
  PCIE_RC_Header_Log_Register_DWORD2_tag Header_Log_Register_DWORD2; /* PCI Express Header Log Register 2 */
  PCIE_RC_Header_Log_Register_DWORD3_tag Header_Log_Register_DWORD3; /* PCI Express Header Log Register 3 */
  PCIE_RC_Header_Log_Register_DWORD4_tag Header_Log_Register_DWORD4; /* PCI Express Header Log Register 4 */
  PCIE_RC_RECR_tag RECR;               /* Root Error Command Register */
  PCIE_RC_RESR_tag RESR;               /* Root Error Status Register */
  PCIE_RC_ESIR_tag ESIR;               /* Error Source Identification Register */
  uint8_t PCIE_RC_reserved3[3800];
  PCIE_RC_MASK0_tag MASK0;             /* BAR 0 Mask Register */
  PCIE_RC_MASK1_tag MASK1;             /* BAR 1 Mask Register */
  uint8_t PCIE_RC_reserved4[32];
  PCIE_RC_EROMMASK_tag EROMMASK;       /* Expansion ROM BAR Mask Register */
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:29;
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t TEN:1;                   /* Timer Enable */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t _unused_3:29;
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  uint32_t TIMER_reserved0[3];
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  uint32_t TIMER_reserved1[3];
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  uint32_t TIMER_reserved2[3];
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint32_t PIT_reserved0[223];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  uint32_t PIT_reserved1[3];
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint32_t PIT_reserved2[27];
  PIT_TIMER_tag TIMER[6];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLLCR_union_tag { /* PLLDIG PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:21;
  } B;
} PLLDIG_PLLCR_tag;

typedef union PLLDIG_PLLSR_union_tag { /* PLLDIG PLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t LOCK:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:22;
  } B;
} PLLDIG_PLLSR_tag;

typedef union PLLDIG_PLLDV_union_tag { /* PLLDIG PLL Divider Register */
  vuint32_t R;
  struct {
    vuint32_t MFD:8;                   /* Loop multiplication factor divider. */
    vuint32_t _unused_8:3;
    vuint32_t _unused_11:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_15:1;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_22:3;
    vuint32_t RFDPHI1:6;               /* PHI1 reduced frequency divider. */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLDV_tag;

typedef union PLLDIG_PLLFM_union_tag { /* PLLDIG PLL Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t STEPNO:11;               /* Increment step. */
    vuint32_t _unused_11:5;
    vuint32_t STEPSIZE:10;             /* Modulation period. */
    vuint32_t _unused_26:3;
    vuint32_t MODSEL:1;                /* Modulation selection. */
    vuint32_t SSCGBYP:1;               /* Modulation enable. */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLFM_tag;

typedef union PLLDIG_PLLFD_union_tag { /* PLLDIG PLL Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t MFN:15;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:2;
    vuint32_t _unused_18:4;
    vuint32_t _unused_22:6;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t SMDEN:1;                 /* Sigma Delta Modulation Enable */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLFD_tag;

typedef union PLLDIG_PLLCAL1_union_tag { /* PLL Calibration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t NDAC1:7;                 /* This field sets the limit for calibration DAC in multiple calibration mode. */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLCAL1_tag;

struct PLLDIG_tag {
  uint8_t PLLDIG_reserved0[32];
  PLLDIG_PLLCR_tag PLLCR;              /* PLLDIG PLL Control Register */
  PLLDIG_PLLSR_tag PLLSR;              /* PLLDIG PLL Status Register */
  PLLDIG_PLLDV_tag PLLDV;              /* PLLDIG PLL Divider Register */
  PLLDIG_PLLFM_tag PLLFM;              /* PLLDIG PLL Frequency Modulation Register */
  PLLDIG_PLLFD_tag PLLFD;              /* PLLDIG PLL Fractional Divide Register */
  uint8_t PLLDIG_reserved1[4];
  PLLDIG_PLLCAL1_tag PLLCAL1;          /* PLL Calibration Register 1 */
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

typedef union PMC_CR_union_tag {       /* PMC Control Register */
  vuint32_t R;
  struct {
    vuint32_t LVD_HPVDD_ENABLE:1;      /* LVD enable control bit */
    vuint32_t HVD_HPVDD_ENABLE:1;      /* HVD enable control bit */
    vuint32_t LVD_VDDPMC_ENABLE:1;     /* LVD enable control bit */
    vuint32_t HVD_VDDPMC_ENABLE:1;     /* HVD enable control bit */
    vuint32_t LVD_VDD3p3_ENABLE:1;     /* LVD enable control bit */
    vuint32_t LVD_VDDOSC_ENABLE:1;     /* LVD enable control bit */
    vuint32_t _unused_6:25;            /* Reserved */
    vuint32_t VM_PMC_ENABLE:1;         /* PMC voltage monitor enable control bit */
  } B;
} PMC_CR_tag;

typedef union PMC_REE_union_tag {      /* PMC Reset Event Enable */
  vuint32_t R;
  struct {
    vuint32_t LVD_HPVDD_RST_EN:1;      /* LVD Reset Event Enable control bit. */
    vuint32_t HVD_HPVDD_RST_EN:1;      /* HVD Reset Event enable control bit */
    vuint32_t LVD_VDDPMC_RST_EN:1;     /* LVD Reset Event enable control bit */
    vuint32_t HVD_VDDPMC_RST_EN:1;     /* HVD Reset Event enable control bit */
    vuint32_t LVD_VDD3p3_RST_EN:1;     /* LVD Reset Event enable control bit */
    vuint32_t LVD_VDDOSC_RST_EN:1;     /* LVD Reset Event enable control bit */
    vuint32_t _unused_6:25;            /* Reserved */
    vuint32_t VM_PMC_RST_EN:1;         /* PMC voltage monitor Reset Event enable control bit */
  } B;
} PMC_REE_tag;

typedef union PMC_FEE_union_tag {      /* PMC Fault Event Enable */
  vuint32_t R;
  struct {
    vuint32_t LVD_HPVDD_FAULT_EN:1;    /* LVD Fault Event Enable control bit. */
    vuint32_t HVD_HPVDD_FAULT_EN:1;    /* HVD Fault Event enable control bit */
    vuint32_t LVD_VDDPMC_FAULT_EN:1;   /* LVD Fault Event enable control bit */
    vuint32_t HVD_VDDPMC_FAULT_EN:1;   /* HVD fault Event enable control bit */
    vuint32_t LVD_VDD3p3_FAULT_EN:1;   /* LVD Fault Event enable control bit */
    vuint32_t LVD_VDDOSC_FAULT_EN:1;   /* LVD Fault Event enable control bit */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} PMC_FEE_tag;

typedef union PMC_IEE_union_tag {      /* PMC Interrupt Event Enable */
  vuint32_t R;
  struct {
    vuint32_t LVD_HPVDD_INT_EN:1;      /* LVD Interrupt Event Enable control bit. */
    vuint32_t HVD_HPVDD_INT_EN:1;      /* HVD Interrupt Event enable control bit */
    vuint32_t LVD_VDDPMC_INT_EN:1;     /* LVD Interrupt Event enable control bit */
    vuint32_t HVD_VDDPMC_INT_EN:1;     /* HVD Interrupt Event enable control bit */
    vuint32_t LVD_VDD3p3_INT_EN:1;     /* LVD Interrupt Event enable control bit */
    vuint32_t LVD_VDDOSC_INT_EN:1;     /* LVD Interrupt Event enable control bit */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} PMC_IEE_tag;

typedef union PMC_FIR_union_tag {      /* PMC Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t LVD_FAULT:1;             /* Low Voltage Detect Fault injection. */
    vuint32_t HVD_FAULT:1;             /* High Voltage Detect Fault injection. */
    vuint32_t STEST_FAULT:1;           /* LVD Selftest Fault injection */
    vuint32_t _unused_3:29;            /* Reserved */
  } B;
} PMC_FIR_tag;

typedef union PMC_ADC_CS_union_tag {   /* PMC ADC Channel Select Register */
  vuint32_t R;
  struct {
    vuint32_t ADC_CS:7;                /* ADC Channel Select */
    vuint32_t _unused_7:25;            /* Reserved */
  } B;
} PMC_ADC_CS_tag;

typedef union PMC_STCR_union_tag {     /* PMC Self Test Control Register */
  vuint32_t R;
  struct {
    vuint32_t VD_ST_CTRL:4;            /* Voltage Detect Self Test Control. */
    vuint32_t ST_MODE:2;               /* Self Test mode bits for testing of LVDs and HVDs. */
    vuint32_t ST_SINGLE_VD_ABORT_RESULT:1; /* Single Voltage Detect Mode Selftest Abort Result */
    vuint32_t ST_FULL_SW_VD_ABORT_RESULT:1; /* Software triggered Full Voltage Detect Selftest Abort Result */
    vuint32_t ST_SINGLE_VD_FALL_RESULT:11; /* Single LVD Voltage detect fall result status */
    vuint32_t ST_SINGLE_VD_RISE_RESULT:11; /* Single LVD Voltage detect rise result status */
    vuint32_t ST_RESULT:1;             /* ST_RESULT. Self Test result status. */
    vuint32_t ST_DONE:1;               /* Self Test Done status. */
  } B;
} PMC_STCR_tag;

struct PMC_tag {
  uint8_t PMC_reserved0[4];
  PMC_CR_tag CR;                       /* PMC Control Register */
  PMC_REE_tag REE;                     /* PMC Reset Event Enable */
  PMC_FEE_tag FEE;                     /* PMC Fault Event Enable */
  PMC_IEE_tag IEE;                     /* PMC Interrupt Event Enable */
  PMC_FIR_tag FIR;                     /* PMC Fault Injection Register */
  PMC_ADC_CS_tag ADC_CS;               /* PMC ADC Channel Select Register */
  uint8_t PMC_reserved1[4];
  PMC_STCR_tag STCR;                   /* PMC Self Test Control Register */
};


/* ============================================================================
   =============================== Module: QuadSPI ============================
   ============================================================================ */

typedef union QuadSPI_MCR_union_tag {  /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRSTSD:1;
    vuint32_t SWRSTHD:1;
    vuint32_t END_CFG:2;
    vuint32_t _unused_4:1;
    vuint32_t DQS_LAT_EN:1;
    vuint32_t DQS_EN:1;
    vuint32_t DDR_EN:1;
    vuint32_t _unused_8:2;
    vuint32_t CLR_RXF:1;
    vuint32_t CLR_TXF:1;
    vuint32_t _unused_12:2;
    vuint32_t MDIS:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:4;
    vuint32_t _unused_20:4;
    vuint32_t DQS_MDSL:1;
    vuint32_t CFG_BIT:1;
    vuint32_t REFCLK_SEL:1;
    vuint32_t _unused_27:2;
    vuint32_t DQS_CD:3;
  } B;
} QuadSPI_MCR_tag;

typedef union QuadSPI_IPCR_union_tag { /* IP Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t IDATSZ:16;
    vuint32_t PAR_EN:1;
    vuint32_t _unused_17:7;
    vuint32_t SEQID:4;
    vuint32_t _unused_28:4;
  } B;
} QuadSPI_IPCR_tag;

typedef union QuadSPI_FLSHCR_union_tag { /* Flash Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCSS:4;
    vuint32_t _unused_4:4;
    vuint32_t TCSH:4;
    vuint32_t _unused_12:4;
    vuint32_t TDH:2;
    vuint32_t _unused_18:14;
  } B;
} QuadSPI_FLSHCR_tag;

typedef union QuadSPI_BUF0CR_union_tag { /* Buffer0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:5;
    vuint32_t _unused_5:3;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:15;
    vuint32_t HP_EN:1;
  } B;
} QuadSPI_BUF0CR_tag;

typedef union QuadSPI_BUF1CR_union_tag { /* Buffer1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:5;
    vuint32_t _unused_5:3;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_BUF1CR_tag;

typedef union QuadSPI_BUF2CR_union_tag { /* Buffer2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:5;
    vuint32_t _unused_5:3;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_BUF2CR_tag;

typedef union QuadSPI_BUF3CR_union_tag { /* Buffer3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:5;
    vuint32_t _unused_5:3;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:15;
    vuint32_t ALLMST:1;
  } B;
} QuadSPI_BUF3CR_tag;

typedef union QuadSPI_BFGENCR_union_tag { /* Buffer Generic Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t SEQID:4;
    vuint32_t PAR_EN:1;
    vuint32_t _unused_17:15;
  } B;
} QuadSPI_BFGENCR_tag;

typedef union QuadSPI_SOCCR_union_tag { /* SOC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FDCC_FA:8;
    vuint32_t _unused_8:8;
    vuint32_t FDCC_FB:8;
    vuint32_t _unused_24:8;
  } B;
} QuadSPI_SOCCR_tag;

typedef union QuadSPI_BUF0IND_union_tag { /* Buffer0 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX0:29;
  } B;
} QuadSPI_BUF0IND_tag;

typedef union QuadSPI_BUF1IND_union_tag { /* Buffer1 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX1:29;
  } B;
} QuadSPI_BUF1IND_tag;

typedef union QuadSPI_BUF2IND_union_tag { /* Buffer2 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX2:29;
  } B;
} QuadSPI_BUF2IND_tag;

typedef union QuadSPI_SFAR_union_tag { /* Serial Flash Address Register */
  vuint32_t R;
  struct {
    vuint32_t SFADR:32;
  } B;
} QuadSPI_SFAR_tag;

typedef union QuadSPI_SFACR_union_tag { /* Serial Flash Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CAS:4;                   /* Column Address Space */
    vuint32_t _unused_4:12;
    vuint32_t WA:1;                    /* Word Addressable */
    vuint32_t _unused_17:15;
  } B;
} QuadSPI_SFACR_tag;

typedef union QuadSPI_SMPR_union_tag { /* Sampling Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:2;
    vuint32_t FSPHS:1;                 /* Full Speed Phase selection for SDR instructions. */
    vuint32_t FSDLY:1;                 /* Full Speed Delay selection for SDR instructions. Select the delay with respect to the reference edge for the sample point valid for full speed commands. */
    vuint32_t _unused_7:9;
    vuint32_t _unused_16:3;
    vuint32_t _unused_19:13;
  } B;
} QuadSPI_SMPR_tag;

typedef union QuadSPI_RBSR_union_tag { /* RX Buffer Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t RDBFL:6;
    vuint32_t _unused_14:2;
    vuint32_t RDCTR:16;
  } B;
} QuadSPI_RBSR_tag;

typedef union QuadSPI_RBCT_union_tag { /* RX Buffer Control Register */
  vuint32_t R;
  struct {
    vuint32_t WMRK:5;
    vuint32_t _unused_5:3;
    vuint32_t RXBRD:1;
    vuint32_t _unused_9:23;
  } B;
} QuadSPI_RBCT_tag;

typedef union QuadSPI_TBSR_union_tag { /* TX Buffer Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t TRBFL:6;
    vuint32_t _unused_14:2;
    vuint32_t TRCTR:16;
  } B;
} QuadSPI_TBSR_tag;

typedef union QuadSPI_TBDR_union_tag { /* TX Buffer Data Register */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:32;
  } B;
} QuadSPI_TBDR_tag;

typedef union QuadSPI_TBCT_union_tag { /* Tx Buffer Control Register */
  vuint32_t R;
  struct {
    vuint32_t WMRK:5;
    vuint32_t _unused_5:27;
  } B;
} QuadSPI_TBCT_tag;

typedef union QuadSPI_SR_union_tag {   /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t BUSY:1;
    vuint32_t IP_ACC:1;
    vuint32_t AHB_ACC:1;
    vuint32_t KEY_FET:1;
    vuint32_t _unused_4:1;
    vuint32_t AHBGNT:1;
    vuint32_t AHBTRN:1;
    vuint32_t AHB0NE:1;
    vuint32_t AHB1NE:1;
    vuint32_t AHB2NE:1;
    vuint32_t AHB3NE:1;
    vuint32_t AHB0FUL:1;
    vuint32_t AHB1FUL:1;
    vuint32_t AHB2FUL:1;
    vuint32_t AHB3FUL:1;
    vuint32_t _unused_15:1;
    vuint32_t RXWE:1;
    vuint32_t _unused_17:2;
    vuint32_t RXFULL:1;
    vuint32_t _unused_20:3;
    vuint32_t RXDMA:1;
    vuint32_t TXEDA:1;                 /* Tx Buffer Enough Data Available */
    vuint32_t TXWA:1;                  /* TX Buffer watermark Available */
    vuint32_t TXDMA:1;                 /* TXDMA */
    vuint32_t TXFULL:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:3;
  } B;
} QuadSPI_SR_tag;

typedef union QuadSPI_FR_union_tag {   /* Flag Register */
  vuint32_t R;
  struct {
    vuint32_t TFF:1;
    vuint32_t _unused_1:3;
    vuint32_t IPGEF:1;
    vuint32_t _unused_5:1;
    vuint32_t IPIEF:1;
    vuint32_t IPAEF:1;
    vuint32_t _unused_8:3;
    vuint32_t IUEF:1;
    vuint32_t ABOF:1;
    vuint32_t AIBSEF:1;
    vuint32_t AITEF:1;
    vuint32_t ABSEF:1;
    vuint32_t RBDF:1;
    vuint32_t RBOF:1;
    vuint32_t _unused_18:5;
    vuint32_t ILLINE:1;
    vuint32_t _unused_24:2;
    vuint32_t TBUF:1;
    vuint32_t TBFF:1;
    vuint32_t _unused_28:1;
    vuint32_t KFEF:1;                  /* Key Fetch Error Flag */
    vuint32_t IAKFEF:1;
    vuint32_t _unused_31:1;
  } B;
} QuadSPI_FR_tag;

typedef union QuadSPI_RSER_union_tag { /* Interrupt and DMA Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TFIE:1;
    vuint32_t _unused_1:3;
    vuint32_t IPGEIE:1;
    vuint32_t _unused_5:1;
    vuint32_t IPIEIE:1;
    vuint32_t IPAEIE:1;
    vuint32_t _unused_8:3;
    vuint32_t IUEIE:1;
    vuint32_t ABOIE:1;
    vuint32_t AIBSIE:1;
    vuint32_t AITIE:1;
    vuint32_t ABSEIE:1;
    vuint32_t RBDIE:1;
    vuint32_t RBOIE:1;
    vuint32_t _unused_18:3;
    vuint32_t RBDDE:1;
    vuint32_t _unused_22:1;
    vuint32_t ILLINIE:1;
    vuint32_t _unused_24:1;
    vuint32_t TBFDE:1;                 /* TX Buffer Fill DMA Enable */
    vuint32_t TBUIE:1;
    vuint32_t TBFIE:1;
    vuint32_t _unused_28:1;
    vuint32_t KFEIE:1;
    vuint32_t IAKFIE:1;
    vuint32_t _unused_31:1;
  } B;
} QuadSPI_RSER_tag;

typedef union QuadSPI_SPNDST_union_tag { /* Sequence Suspend Status Register */
  vuint32_t R;
  struct {
    vuint32_t SUSPND:1;
    vuint32_t _unused_1:5;
    vuint32_t SPDBUF:2;
    vuint32_t _unused_8:1;
    vuint32_t DATLFT:7;
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_SPNDST_tag;

typedef union QuadSPI_SPTRCLR_union_tag { /* Sequence Pointer Clear Register */
  vuint32_t R;
  struct {
    vuint32_t BFPTRC:1;
    vuint32_t _unused_1:7;
    vuint32_t IPPTRC:1;
    vuint32_t _unused_9:23;
  } B;
} QuadSPI_SPTRCLR_tag;

typedef union QuadSPI_SFA1AD_union_tag { /* Serial Flash A1 Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADA1:22;
  } B;
} QuadSPI_SFA1AD_tag;

typedef union QuadSPI_SFA2AD_union_tag { /* Serial Flash A2 Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADA2:22;
  } B;
} QuadSPI_SFA2AD_tag;

typedef union QuadSPI_SFB1AD_union_tag { /* Serial Flash B1Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADB1:22;
  } B;
} QuadSPI_SFB1AD_tag;

typedef union QuadSPI_SFB2AD_union_tag { /* Serial Flash B2Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADB2:22;
  } B;
} QuadSPI_SFB2AD_tag;

typedef union QuadSPI_RBDR_union_tag { /* RX Buffer Data Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;
  } B;
} QuadSPI_RBDR_tag;

typedef union QuadSPI_LUTKEY_union_tag { /* LUT Key Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:32;
  } B;
} QuadSPI_LUTKEY_tag;

typedef union QuadSPI_LCKCR_union_tag { /* LUT Lock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;
    vuint32_t UNLOCK:1;
    vuint32_t _unused_2:30;
  } B;
} QuadSPI_LCKCR_tag;

typedef union QuadSPI_LUT_union_tag {  /* Look-up Table register */
  vuint32_t R;
  struct {
    vuint32_t OPRND0:8;                /* Operand for INSTR0. */
    vuint32_t PAD0:2;                  /* Pad information for INSTR0. */
    vuint32_t INSTR0:6;                /* Instruction 0 */
    vuint32_t OPRND1:8;                /* Operand for INSTR1. */
    vuint32_t PAD1:2;                  /* Pad information for INSTR1. */
    vuint32_t INSTR1:6;                /* Instruction 1 */
  } B;
} QuadSPI_LUT_tag;

struct QuadSPI_tag {
  QuadSPI_MCR_tag MCR;                 /* Module Configuration Register */
  uint8_t QuadSPI_reserved0[4];
  QuadSPI_IPCR_tag IPCR;               /* IP Configuration Register */
  QuadSPI_FLSHCR_tag FLSHCR;           /* Flash Configuration Register */
  QuadSPI_BUF0CR_tag BUF0CR;           /* Buffer0 Configuration Register */
  QuadSPI_BUF1CR_tag BUF1CR;           /* Buffer1 Configuration Register */
  QuadSPI_BUF2CR_tag BUF2CR;           /* Buffer2 Configuration Register */
  QuadSPI_BUF3CR_tag BUF3CR;           /* Buffer3 Configuration Register */
  QuadSPI_BFGENCR_tag BFGENCR;         /* Buffer Generic Configuration Register */
  QuadSPI_SOCCR_tag SOCCR;             /* SOC Configuration Register */
  uint8_t QuadSPI_reserved1[8];
  QuadSPI_BUF0IND_tag BUF0IND;         /* Buffer0 Top Index Register */
  QuadSPI_BUF1IND_tag BUF1IND;         /* Buffer1 Top Index Register */
  QuadSPI_BUF2IND_tag BUF2IND;         /* Buffer2 Top Index Register */
  uint8_t QuadSPI_reserved2[196];
  QuadSPI_SFAR_tag SFAR;               /* Serial Flash Address Register */
  QuadSPI_SFACR_tag SFACR;             /* Serial Flash Address Configuration Register */
  QuadSPI_SMPR_tag SMPR;               /* Sampling Register */
  QuadSPI_RBSR_tag RBSR;               /* RX Buffer Status Register */
  QuadSPI_RBCT_tag RBCT;               /* RX Buffer Control Register */
  uint8_t QuadSPI_reserved3[60];
  QuadSPI_TBSR_tag TBSR;               /* TX Buffer Status Register */
  QuadSPI_TBDR_tag TBDR;               /* TX Buffer Data Register */
  QuadSPI_TBCT_tag TBCT;               /* Tx Buffer Control Register */
  QuadSPI_SR_tag SR;                   /* Status Register */
  QuadSPI_FR_tag FR;                   /* Flag Register */
  QuadSPI_RSER_tag RSER;               /* Interrupt and DMA Request Select and Enable Register */
  QuadSPI_SPNDST_tag SPNDST;           /* Sequence Suspend Status Register */
  QuadSPI_SPTRCLR_tag SPTRCLR;         /* Sequence Pointer Clear Register */
  uint8_t QuadSPI_reserved4[16];
  QuadSPI_SFA1AD_tag SFA1AD;           /* Serial Flash A1 Top Address */
  QuadSPI_SFA2AD_tag SFA2AD;           /* Serial Flash A2 Top Address */
  QuadSPI_SFB1AD_tag SFB1AD;           /* Serial Flash B1Top Address */
  QuadSPI_SFB2AD_tag SFB2AD;           /* Serial Flash B2Top Address */
  uint8_t QuadSPI_reserved5[112];
  QuadSPI_RBDR_tag RBDR[32];           /* RX Buffer Data Register */
  uint8_t QuadSPI_reserved6[128];
  QuadSPI_LUTKEY_tag LUTKEY;           /* LUT Key Register */
  QuadSPI_LCKCR_tag LCKCR;             /* LUT Lock Configuration Register */
  uint8_t QuadSPI_reserved7[8];
  QuadSPI_LUT_tag LUT[64];             /* Look-up Table register */
};


/* ============================================================================
   =============================== Module: SAR_ADC ============================
   ============================================================================ */

typedef union SAR_ADC_MCR_union_tag {  /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t PWDN:1;                  /* Power down enable */
    vuint32_t _unused_1:3;
    vuint32_t ADCLKDIV:1;              /* Analog Clock Divide Factor */
    vuint32_t ACKO:1;                  /* Auto-Clock-Off Mode Enable */
    vuint32_t ABORT:1;                 /* Abort Conversion */
    vuint32_t ABORTCHAIN:1;            /* Abort Conversion Chain */
    vuint32_t ADCLKSE:1;               /* Analog Clock Frequency Select */
    vuint32_t TSAMP:2;                 /* Sample Period of Calibration Conversions */
    vuint32_t NRSMPL:2;                /* Number of Averaging Samples. */
    vuint32_t AVGEN:1;                 /* Average Enable */
    vuint32_t CALSTART:1;              /* Calibration Start */
    vuint32_t STCL:1;                  /* Self-Testing Configuration Lock */
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:2;
    vuint32_t JSTART:1;                /* Start Injection Conversion */
    vuint32_t JEDGE:1;                 /* Injection Trigger Edge Selection */
    vuint32_t JTRGEN:1;                /* Injection External Trigger Enable */
    vuint32_t _unused_23:1;
    vuint32_t NSTART:1;                /* Normal Conversion Start */
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_28:1;
    vuint32_t MODE:1;                  /* Normal Scan Mode Select */
    vuint32_t WLSIDE:1;
    vuint32_t OWREN:1;                 /* Overwrite Enable */
  } B;
} SAR_ADC_MCR_tag;

typedef union SAR_ADC_MSR_union_tag {  /* Main Status Register */
  vuint32_t R;
  struct {
    vuint32_t ADCSTATUS:3;             /* ADC Status */
    vuint32_t _unused_3:2;
    vuint32_t ACKO:1;                  /* >Auto Clock Off Enable */
    vuint32_t _unused_6:3;
    vuint32_t CHADDR:7;                /* Channel Address */
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t SELF_TEST_S:1;
    vuint32_t _unused_19:1;
    vuint32_t JSTART:1;                /* Injected Conversion Status */
    vuint32_t _unused_21:2;
    vuint32_t JABORT:1;                /* Injected conversion Abort Status */
    vuint32_t NSTART:1;                /* Normal Conversion Status */
    vuint32_t _unused_25:4;
    vuint32_t CALBUSY:1;               /* Calibration busy */
    vuint32_t CALFAIL:1;               /* Calibration Failed */
    vuint32_t CALIBRTD:1;              /* SAR_ADC Calibration Status */
  } B;
} SAR_ADC_MSR_tag;

typedef union SAR_ADC_ISR_union_tag {  /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t ECH:1;                   /* End of Conversion Chain */
    vuint32_t EOC:1;                   /* End of Channel Conversion */
    vuint32_t JECH:1;                  /* Injected End Of Conversion Chain */
    vuint32_t JEOC:1;                  /* Injected Channel End Of Conversion */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} SAR_ADC_ISR_tag;

typedef union SAR_ADC_IMR_union_tag {  /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKECH:1;                /* End of Chain Conversion Interrupt Mask */
    vuint32_t MSKEOC:1;                /* End of Conversion Interrupt Mask */
    vuint32_t MSKJECH:1;               /* End of Injected Chain Conversion Interrupt Mask */
    vuint32_t MSKJEOC:1;               /* End of Injected Conversion Interrupt Mask */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} SAR_ADC_IMR_tag;

typedef union SAR_ADC_CIMR0_union_tag { /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CIM0:1;
    vuint32_t CIM1:1;
    vuint32_t CIM2:1;
    vuint32_t CIM3:1;
    vuint32_t CIM4:1;
    vuint32_t CIM5:1;
    vuint32_t CIM6:1;
    vuint32_t CIM7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_CIMR0_tag;

typedef union SAR_ADC_CIMR1_union_tag { /* Channel Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CIM32:1;
    vuint32_t CIM33:1;
    vuint32_t CIM34:1;
    vuint32_t CIM35:1;
    vuint32_t CIM36:1;
    vuint32_t CIM37:1;
    vuint32_t CIM38:1;
    vuint32_t CIM39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_CIMR1_tag;

typedef union SAR_ADC_WTISR_union_tag { /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t WDG0L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG5H:1;
    vuint32_t WDG6L:1;
    vuint32_t WDG6H:1;
    vuint32_t WDG7L:1;
    vuint32_t WDG7H:1;
    vuint32_t _unused_16:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:2;
    vuint32_t _unused_22:2;
    vuint32_t _unused_24:2;
    vuint32_t _unused_26:2;
    vuint32_t _unused_28:2;
    vuint32_t _unused_30:2;
  } B;
} SAR_ADC_WTISR_tag;

typedef union SAR_ADC_WTIMR_union_tag { /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKWDG0L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG6L:1;
    vuint32_t MSKWDG6H:1;
    vuint32_t MSKWDG7L:1;
    vuint32_t MSKWDG7H:1;
    vuint32_t _unused_16:2;
    vuint32_t _unused_18:2;
    vuint32_t _unused_20:2;
    vuint32_t _unused_22:2;
    vuint32_t _unused_24:2;
    vuint32_t _unused_26:2;
    vuint32_t _unused_28:2;
    vuint32_t _unused_30:2;
  } B;
} SAR_ADC_WTIMR_tag;

typedef union SAR_ADC_DMAE_union_tag { /* DMAE Register */
  vuint32_t R;
  struct {
    vuint32_t DMAEN:1;
    vuint32_t DCLR:1;
    vuint32_t _unused_2:30;
  } B;
} SAR_ADC_DMAE_tag;

typedef union SAR_ADC_DMAR0_union_tag { /* DMA Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DMA0:1;
    vuint32_t DMA1:1;
    vuint32_t DMA2:1;
    vuint32_t DMA3:1;
    vuint32_t DMA4:1;
    vuint32_t DMA5:1;
    vuint32_t DMA6:1;
    vuint32_t DMA7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_DMAR0_tag;

typedef union SAR_ADC_DMAR1_union_tag { /* DMA Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DMA32:1;
    vuint32_t DMA33:1;
    vuint32_t DMA34:1;
    vuint32_t DMA35:1;
    vuint32_t DMA36:1;
    vuint32_t DMA37:1;
    vuint32_t DMA38:1;
    vuint32_t DMA39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_DMAR1_tag;

typedef union SAR_ADC_THRHLR0_union_tag { /* Analog Watchdog Threshold Register 0 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR0_tag;

typedef union SAR_ADC_THRHLR1_union_tag { /* Analog Watchdog Threshold Register 1 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR1_tag;

typedef union SAR_ADC_THRHLR2_union_tag { /* Analog Watchdog Threshold Register 2 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR2_tag;

typedef union SAR_ADC_THRHLR3_union_tag { /* Analog Watchdog Threshold Register 2 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR3_tag;

typedef union SAR_ADC_PSCR_union_tag { /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t PRECONV:1;
    vuint32_t PREVAL0:2;               /* Internal Presampling voltage selection. */
    vuint32_t PREVAL1:2;               /* Internal Presampling voltage selection. */
    vuint32_t _unused_5:2;
    vuint32_t _unused_7:25;
  } B;
} SAR_ADC_PSCR_tag;

typedef union SAR_ADC_PSR0_union_tag { /* Presampling Register 0 */
  vuint32_t R;
  struct {
    vuint32_t PRES0:1;
    vuint32_t PRES1:1;
    vuint32_t PRES2:1;
    vuint32_t PRES3:1;
    vuint32_t PRES4:1;
    vuint32_t PRES5:1;
    vuint32_t PRES6:1;
    vuint32_t PRES7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_PSR0_tag;

typedef union SAR_ADC_PSR1_union_tag { /* Presampling Register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRES32:1;
    vuint32_t PRES33:1;
    vuint32_t PRES34:1;
    vuint32_t PRES35:1;
    vuint32_t PRES36:1;
    vuint32_t PRES37:1;
    vuint32_t PRES38:1;
    vuint32_t PRES39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_PSR1_tag;

typedef union SAR_ADC_CTR0_union_tag { /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP:8;               /* Sampling Phase Duration */
    vuint32_t _unused_8:24;
  } B;
} SAR_ADC_CTR0_tag;

typedef union SAR_ADC_CTR1_union_tag { /* Conversion Timing Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP:8;               /* Sampling Phase Duration */
    vuint32_t _unused_8:24;
  } B;
} SAR_ADC_CTR1_tag;

typedef union SAR_ADC_NCMR0_union_tag { /* Normal Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t CH0:1;
    vuint32_t CH1:1;
    vuint32_t CH2:1;
    vuint32_t CH3:1;
    vuint32_t CH4:1;
    vuint32_t CH5:1;
    vuint32_t CH6:1;
    vuint32_t CH7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_NCMR0_tag;

typedef union SAR_ADC_NCMR1_union_tag { /* Normal Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t CH32:1;
    vuint32_t CH33:1;
    vuint32_t CH34:1;
    vuint32_t CH35:1;
    vuint32_t CH36:1;
    vuint32_t CH37:1;
    vuint32_t CH38:1;
    vuint32_t CH39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_NCMR1_tag;

typedef union SAR_ADC_JCMR0_union_tag { /* Injected Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t CH0:1;
    vuint32_t CH1:1;
    vuint32_t CH2:1;
    vuint32_t CH3:1;
    vuint32_t CH4:1;
    vuint32_t CH5:1;
    vuint32_t CH6:1;
    vuint32_t CH7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_JCMR0_tag;

typedef union SAR_ADC_JCMR1_union_tag { /* Injected Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t CH32:1;
    vuint32_t CH33:1;
    vuint32_t CH34:1;
    vuint32_t CH35:1;
    vuint32_t CH36:1;
    vuint32_t CH37:1;
    vuint32_t CH38:1;
    vuint32_t CH39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_JCMR1_tag;

typedef union SAR_ADC_USROFSGN_union_tag { /* User OFFSET and Gain Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSUSER:8;              /* User Defined Offset */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t GAINUSER:10;             /* User Defined Gain value */
    vuint32_t _unused_26:6;            /* Reserved */
  } B;
} SAR_ADC_USROFSGN_tag;

typedef union SAR_ADC_PDEDR_union_tag { /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t PDED:8;
    vuint32_t _unused_8:24;
  } B;
} SAR_ADC_PDEDR_tag;

typedef union SAR_ADC_CDR0_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR0_tag;

typedef union SAR_ADC_CDR1_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR1_tag;

typedef union SAR_ADC_CDR2_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR2_tag;

typedef union SAR_ADC_CDR3_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR3_tag;

typedef union SAR_ADC_CDR4_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR4_tag;

typedef union SAR_ADC_CDR5_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR5_tag;

typedef union SAR_ADC_CDR6_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR6_tag;

typedef union SAR_ADC_CDR7_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR7_tag;

typedef union SAR_ADC_CDR32_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR32_tag;

typedef union SAR_ADC_CDR33_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR33_tag;

typedef union SAR_ADC_CDR34_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR34_tag;

typedef union SAR_ADC_CDR35_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR35_tag;

typedef union SAR_ADC_CDR36_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR36_tag;

typedef union SAR_ADC_CDR37_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR37_tag;

typedef union SAR_ADC_CDR38_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR38_tag;

typedef union SAR_ADC_CDR39_union_tag { /* Channel n Data Register */
  vuint32_t R;
  struct {
    vuint32_t CDATA:12;
    vuint32_t _unused_12:4;
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Data Overwrite */
    vuint32_t VALID:1;                 /* Conversion data valid */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_CDR39_tag;

typedef union SAR_ADC_THRHLR4_union_tag { /* Analog Watchdog Threshold Register 4 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR4_tag;

typedef union SAR_ADC_THRHLR5_union_tag { /* Analog Watchdog Threshold Register 5 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR5_tag;

typedef union SAR_ADC_THRHLR6_union_tag { /* Analog Watchdog Threshold Register 6 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR6_tag;

typedef union SAR_ADC_THRHLR7_union_tag { /* Analog Watchdog Threshold Register 7 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_THRHLR7_tag;

typedef union SAR_ADC_CWSELR0_union_tag { /* Channel Watchdog Select Register */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH0:4;
    vuint32_t WSEL_CH1:4;
    vuint32_t WSEL_CH2:4;
    vuint32_t WSEL_CH3:4;
    vuint32_t WSEL_CH4:4;
    vuint32_t WSEL_CH5:4;
    vuint32_t WSEL_CH6:4;
    vuint32_t WSEL_CH7:4;
  } B;
} SAR_ADC_CWSELR0_tag;

typedef union SAR_ADC_CWSELR4_union_tag { /* Channel Watchdog Select Register */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH32:4;
    vuint32_t WSEL_CH33:4;
    vuint32_t WSEL_CH34:4;
    vuint32_t WSEL_CH35:4;
    vuint32_t WSEL_CH36:4;
    vuint32_t WSEL_CH37:4;
    vuint32_t WSEL_CH38:4;
    vuint32_t WSEL_CH39:4;
  } B;
} SAR_ADC_CWSELR4_tag;

typedef union SAR_ADC_CWENR0_union_tag { /* Channel Watchdog Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CWEN0:1;
    vuint32_t CWEN1:1;
    vuint32_t CWEN2:1;
    vuint32_t CWEN3:1;
    vuint32_t CWEN4:1;
    vuint32_t CWEN5:1;
    vuint32_t CWEN6:1;
    vuint32_t CWEN7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_CWENR0_tag;

typedef union SAR_ADC_CWENR1_union_tag { /* Channel Watchdog Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CWEN32:1;
    vuint32_t CWEN33:1;
    vuint32_t CWEN34:1;
    vuint32_t CWEN35:1;
    vuint32_t CWEN36:1;
    vuint32_t CWEN37:1;
    vuint32_t CWEN38:1;
    vuint32_t CWEN39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_CWENR1_tag;

typedef union SAR_ADC_AWORR0_union_tag { /* Analog Watchdog Out of Range Register */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH0:1;
    vuint32_t AWOR_CH1:1;
    vuint32_t AWOR_CH2:1;
    vuint32_t AWOR_CH3:1;
    vuint32_t AWOR_CH4:1;
    vuint32_t AWOR_CH5:1;
    vuint32_t AWOR_CH6:1;
    vuint32_t AWOR_CH7:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_AWORR0_tag;

typedef union SAR_ADC_AWORR1_union_tag { /* Analog Watchdog Out of Range Register */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH32:1;
    vuint32_t AWOR_CH33:1;
    vuint32_t AWOR_CH34:1;
    vuint32_t AWOR_CH35:1;
    vuint32_t AWOR_CH36:1;
    vuint32_t AWOR_CH37:1;
    vuint32_t AWOR_CH38:1;
    vuint32_t AWOR_CH39:1;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SAR_ADC_AWORR1_tag;

typedef union SAR_ADC_STCR1_union_tag { /* Self-Test Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t INPSAMP_S:8;
    vuint32_t _unused_16:8;
    vuint32_t INPSAMP_C:8;
  } B;
} SAR_ADC_STCR1_tag;

typedef union SAR_ADC_STCR2_union_tag { /* Self-Test Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FMA_S:1;                 /* Fault Mapping for BGAP Algorithm */
    vuint32_t _unused_1:1;
    vuint32_t FMA_C:1;                 /* Fault Mapping for Algorithm C */
    vuint32_t FMA_WDTERR:1;            /* Fault Mapping for Watchdog Timer Error */
    vuint32_t FMA_WDSERR:1;            /* Fault Mapping for Watchdog Sequence Error */
    vuint32_t _unused_5:2;
    vuint32_t EN:1;                    /* Self-Testing Channel Enable */
    vuint32_t _unused_8:3;
    vuint32_t MSKERR_S0:1;             /* Error on Algorithm S0 Channel Interrupt Mask */
    vuint32_t MSKERR_S1:1;             /* Error on Algorithm S1 Channel Interrupt Mask */
    vuint32_t MSKERR_S2:1;             /* Error on Algorithm S2 Channel Interrupt Mask */
    vuint32_t _unused_14:1;
    vuint32_t MSKERR_C:1;              /* Error on Algorithm C Channel Interrupt Mask */
    vuint32_t MSKWDG_EOA_S:1;          /* End of Algorithm S Interrupt Mask */
    vuint32_t _unused_17:1;
    vuint32_t MSKWDG_EOA_C:1;          /* End of Algorithm C Interrupt Mask */
    vuint32_t _unused_19:4;
    vuint32_t MSKST_EOC:1;             /* Self-Test EOC Interrupt Mask */
    vuint32_t _unused_24:1;
    vuint32_t MSKWDTERR:1;             /* Watchdog Timer Error Interrupt Mask */
    vuint32_t SERR:1;
    vuint32_t MSKWDSERR:1;             /* Watchdog Sequence Error Interrupt mask */
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STCR2_tag;

typedef union SAR_ADC_STCR3_union_tag { /* Self-Test Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t MSTEP:5;
    vuint32_t _unused_5:3;
    vuint32_t ALG:2;
    vuint32_t _unused_10:22;
  } B;
} SAR_ADC_STCR3_tag;

typedef union SAR_ADC_STBRR_union_tag { /* Self-Test Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t BR:8;                    /* Algorithm Baud Rate */
    vuint32_t _unused_8:8;
    vuint32_t WDT:3;
    vuint32_t _unused_19:13;
  } B;
} SAR_ADC_STBRR_tag;

typedef union SAR_ADC_STSR1_union_tag { /* Self-Test Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t STEP_C:5;                /* Algorithm C Step Number Error */
    vuint32_t _unused_10:1;
    vuint32_t ERR_S0:1;
    vuint32_t ERR_S1:1;
    vuint32_t ERR_S2:1;
    vuint32_t _unused_14:1;
    vuint32_t ERR_C:1;                 /* Algorithm C Error */
    vuint32_t WDG_EOA_S:1;
    vuint32_t _unused_17:1;
    vuint32_t WDG_EOA_C:1;
    vuint32_t _unused_19:4;
    vuint32_t ST_EOC:1;                /* Self-Test EOC */
    vuint32_t OVERWR:1;                /* Overwrite Error */
    vuint32_t WDTERR:1;                /* Watchdog Timer Error */
    vuint32_t _unused_26:1;
    vuint32_t WDSERR:1;                /* Watchdog Sequence Errors */
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STSR1_tag;

typedef union SAR_ADC_STSR2_union_tag { /* Self-Test Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DATA0:12;
    vuint32_t _unused_12:4;
    vuint32_t DATA1:12;
    vuint32_t _unused_28:3;
    vuint32_t OVFL:1;
  } B;
} SAR_ADC_STSR2_tag;

typedef union SAR_ADC_STSR3_union_tag { /* Self-Test Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t DATA0:12;
    vuint32_t _unused_12:4;
    vuint32_t DATA1:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STSR3_tag;

typedef union SAR_ADC_STSR4_union_tag { /* Self-Test Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t DATA0:12;
    vuint32_t _unused_12:4;
    vuint32_t DATA1:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STSR4_tag;

typedef union SAR_ADC_STDR1_union_tag { /* Self-Test Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TCDATA:12;               /* Test Channel Converted Data */
    vuint32_t _unused_12:6;
    vuint32_t OWERWR:1;                /* Overwrite Data */
    vuint32_t VALID:1;                 /* Valid Data */
    vuint32_t _unused_20:12;
  } B;
} SAR_ADC_STDR1_tag;

typedef union SAR_ADC_STDR2_union_tag { /* Self-Test Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IDATA:12;                /* Integer Data */
    vuint32_t _unused_12:6;
    vuint32_t OVERWR:1;                /* Overwrite Data */
    vuint32_t VALID:1;                 /* Valid Data */
    vuint32_t FDATA:12;                /* Fractional Data */
  } B;
} SAR_ADC_STDR2_tag;

typedef union SAR_ADC_STAW0R_union_tag { /* Self-Test Analog Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for Algorithm S Step0 */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for Algorithm S Step0 */
    vuint32_t _unused_28:2;
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the Algorithm S) */
    vuint32_t AWDE:1;
  } B;
} SAR_ADC_STAW0R_tag;

typedef union SAR_ADC_STAW1AR_union_tag { /* Self-Test Analog Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:3;
    vuint32_t AWDE:1;
  } B;
} SAR_ADC_STAW1AR_tag;

typedef union SAR_ADC_STAW1BR_union_tag { /* Self-Test Analog Watchdog Register 1B */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STAW1BR_tag;

typedef union SAR_ADC_STAW2R_union_tag { /* Self-Test Analog Watchdog Register 2 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Threshold Level Low */
    vuint32_t _unused_12:19;
    vuint32_t AWDE:1;
  } B;
} SAR_ADC_STAW2R_tag;

typedef union SAR_ADC_STAW3R_union_tag { /* Self-Test Analog Watchdog Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} SAR_ADC_STAW3R_tag;

typedef union SAR_ADC_STAW4R_union_tag { /* Self-Test Analog Watchdog Register 4 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for Step0 of Algorithm C. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for Step0 of Algorithm C. */
    vuint32_t _unused_28:2;
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the Algorithm C). */
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the Algorithm C) */
  } B;
} SAR_ADC_STAW4R_tag;

typedef union SAR_ADC_STAW5R_union_tag { /* Self-Test Analog Watchdog Register 5 */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for Step0 of Algorithm C. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for step N of Algorithm C (N = 1 to CS-1). */
    vuint32_t _unused_28:4;
  } B;
} SAR_ADC_STAW5R_tag;

typedef union SAR_ADC_CALSTAT_union_tag { /* Calibration Status register */
  vuint32_t R;
  struct {
    vuint32_t STAT_1:1;                /* Status of calibration step 1 */
    vuint32_t STAT_2:1;                /* Status of calibration step 2 */
    vuint32_t STAT_3:1;                /* Status of calibration step 3 */
    vuint32_t STAT_4:1;                /* Status of calibration step 4 */
    vuint32_t STAT_5:1;                /* Status of calibration step 5 */
    vuint32_t STAT_6:1;                /* Status of calibration step 6 */
    vuint32_t STAT_7:1;                /* Status of calibration step 7 */
    vuint32_t STAT_8:1;                /* Status of calibration step 8 */
    vuint32_t STAT_9:1;                /* Status of calibration step 9 */
    vuint32_t STAT_10:1;               /* Status of calibration step 10 */
    vuint32_t STAT_11:1;               /* Status of calibration step 11 */
    vuint32_t STAT_12:1;               /* Status of Calibration step 12 */
    vuint32_t STAT_13:1;               /* Status of calibration step 13 */
    vuint32_t STAT_14:1;               /* Status of calibration step 14 */
    vuint32_t _unused_14:2;
    vuint32_t TEST_RESULT:16;
  } B;
} SAR_ADC_CALSTAT_tag;

struct SAR_ADC_tag {
  SAR_ADC_MCR_tag MCR;                 /* Main Configuration Register */
  SAR_ADC_MSR_tag MSR;                 /* Main Status Register */
  uint8_t SAR_ADC_reserved0[8];
  SAR_ADC_ISR_tag ISR;                 /* Interrupt Status Register */
  uint8_t SAR_ADC_reserved1[12];
  SAR_ADC_IMR_tag IMR;                 /* Interrupt Mask Register */
  SAR_ADC_CIMR0_tag CIMR0;             /* Channel Interrupt Mask Register 0 */
  SAR_ADC_CIMR1_tag CIMR1;             /* Channel Interrupt Mask Register 1 */
  uint8_t SAR_ADC_reserved2[4];
  SAR_ADC_WTISR_tag WTISR;             /* Watchdog Threshold Interrupt Status Register */
  SAR_ADC_WTIMR_tag WTIMR;             /* Watchdog Threshold Interrupt Mask Register */
  uint8_t SAR_ADC_reserved3[8];
  SAR_ADC_DMAE_tag DMAE;               /* DMAE Register */
  SAR_ADC_DMAR0_tag DMAR0;             /* DMA Register 0 */
  SAR_ADC_DMAR1_tag DMAR1;             /* DMA Register 1 */
  uint8_t SAR_ADC_reserved4[20];
  SAR_ADC_THRHLR0_tag THRHLR0;         /* Analog Watchdog Threshold Register 0 */
  SAR_ADC_THRHLR1_tag THRHLR1;         /* Analog Watchdog Threshold Register 1 */
  SAR_ADC_THRHLR2_tag THRHLR2;         /* Analog Watchdog Threshold Register 2 */
  SAR_ADC_THRHLR3_tag THRHLR3;         /* Analog Watchdog Threshold Register 2 */
  uint8_t SAR_ADC_reserved5[16];
  SAR_ADC_PSCR_tag PSCR;               /* Presampling Control Register */
  SAR_ADC_PSR0_tag PSR0;               /* Presampling Register 0 */
  SAR_ADC_PSR1_tag PSR1;               /* Presampling Register 1 */
  uint8_t SAR_ADC_reserved6[8];
  SAR_ADC_CTR0_tag CTR0;               /* Conversion Timing Register 0 */
  SAR_ADC_CTR1_tag CTR1;               /* Conversion Timing Register 2 */
  uint8_t SAR_ADC_reserved7[8];
  SAR_ADC_NCMR0_tag NCMR0;             /* Normal Conversion Mask Register */
  SAR_ADC_NCMR1_tag NCMR1;             /* Normal Conversion Mask Register */
  uint8_t SAR_ADC_reserved8[8];
  SAR_ADC_JCMR0_tag JCMR0;             /* Injected Conversion Mask Register */
  SAR_ADC_JCMR1_tag JCMR1;             /* Injected Conversion Mask Register */
  uint8_t SAR_ADC_reserved9[4];
  SAR_ADC_USROFSGN_tag USROFSGN;       /* User OFFSET and Gain Register */
  uint8_t SAR_ADC_reserved10[4];
  SAR_ADC_PDEDR_tag PDEDR;             /* Power Down Exit Delay Register */
  uint8_t SAR_ADC_reserved11[52];
  SAR_ADC_CDR0_tag CDR0;               /* Channel n Data Register */
  SAR_ADC_CDR1_tag CDR1;               /* Channel n Data Register */
  SAR_ADC_CDR2_tag CDR2;               /* Channel n Data Register */
  SAR_ADC_CDR3_tag CDR3;               /* Channel n Data Register */
  SAR_ADC_CDR4_tag CDR4;               /* Channel n Data Register */
  SAR_ADC_CDR5_tag CDR5;               /* Channel n Data Register */
  SAR_ADC_CDR6_tag CDR6;               /* Channel n Data Register */
  SAR_ADC_CDR7_tag CDR7;               /* Channel n Data Register */
  uint8_t SAR_ADC_reserved12[96];
  SAR_ADC_CDR32_tag CDR32;             /* Channel n Data Register */
  SAR_ADC_CDR33_tag CDR33;             /* Channel n Data Register */
  SAR_ADC_CDR34_tag CDR34;             /* Channel n Data Register */
  SAR_ADC_CDR35_tag CDR35;             /* Channel n Data Register */
  SAR_ADC_CDR36_tag CDR36;             /* Channel n Data Register */
  SAR_ADC_CDR37_tag CDR37;             /* Channel n Data Register */
  SAR_ADC_CDR38_tag CDR38;             /* Channel n Data Register */
  SAR_ADC_CDR39_tag CDR39;             /* Channel n Data Register */
  uint8_t SAR_ADC_reserved13[224];
  SAR_ADC_THRHLR4_tag THRHLR4;         /* Analog Watchdog Threshold Register 4 */
  SAR_ADC_THRHLR5_tag THRHLR5;         /* Analog Watchdog Threshold Register 5 */
  SAR_ADC_THRHLR6_tag THRHLR6;         /* Analog Watchdog Threshold Register 6 */
  SAR_ADC_THRHLR7_tag THRHLR7;         /* Analog Watchdog Threshold Register 7 */
  uint8_t SAR_ADC_reserved14[32];
  SAR_ADC_CWSELR0_tag CWSELR0;         /* Channel Watchdog Select Register */
  uint8_t SAR_ADC_reserved15[12];
  SAR_ADC_CWSELR4_tag CWSELR4;         /* Channel Watchdog Select Register */
  uint8_t SAR_ADC_reserved16[28];
  SAR_ADC_CWENR0_tag CWENR0;           /* Channel Watchdog Enable Register */
  SAR_ADC_CWENR1_tag CWENR1;           /* Channel Watchdog Enable Register */
  uint8_t SAR_ADC_reserved17[8];
  SAR_ADC_AWORR0_tag AWORR0;           /* Analog Watchdog Out of Range Register */
  SAR_ADC_AWORR1_tag AWORR1;           /* Analog Watchdog Out of Range Register */
  uint8_t SAR_ADC_reserved18[72];
  SAR_ADC_STCR1_tag STCR1;             /* Self-Test Configuration Register 1 */
  SAR_ADC_STCR2_tag STCR2;             /* Self-Test Configuration Register 2 */
  SAR_ADC_STCR3_tag STCR3;             /* Self-Test Configuration Register 3 */
  SAR_ADC_STBRR_tag STBRR;             /* Self-Test Baud Rate Register */
  SAR_ADC_STSR1_tag STSR1;             /* Self-Test Status Register 1 */
  SAR_ADC_STSR2_tag STSR2;             /* Self-Test Status Register 2 */
  SAR_ADC_STSR3_tag STSR3;             /* Self-Test Status Register 3 */
  SAR_ADC_STSR4_tag STSR4;             /* Self-Test Status Register 4 */
  uint8_t SAR_ADC_reserved19[16];
  SAR_ADC_STDR1_tag STDR1;             /* Self-Test Data Register 1 */
  SAR_ADC_STDR2_tag STDR2;             /* Self-Test Data Register 2 */
  uint8_t SAR_ADC_reserved20[8];
  SAR_ADC_STAW0R_tag STAW0R;           /* Self-Test Analog Watchdog Register */
  SAR_ADC_STAW1AR_tag STAW1AR;         /* Self-Test Analog Watchdog Register */
  SAR_ADC_STAW1BR_tag STAW1BR;         /* Self-Test Analog Watchdog Register 1B */
  SAR_ADC_STAW2R_tag STAW2R;           /* Self-Test Analog Watchdog Register 2 */
  SAR_ADC_STAW3R_tag STAW3R;           /* Self-Test Analog Watchdog Register 3 */
  SAR_ADC_STAW4R_tag STAW4R;           /* Self-Test Analog Watchdog Register 4 */
  SAR_ADC_STAW5R_tag STAW5R;           /* Self-Test Analog Watchdog Register 5 */
  SAR_ADC_CALSTAT_tag CALSTAT;         /* Calibration Status register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t RSTGTN:8;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGSM:2;
    vuint16_t ROZ:2;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGTN:8;
    vuint16_t RSTGDP:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[50];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

typedef union SIPI_CCR0_union_tag {    /* SIPI Channel Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DEN:1;                   /* DMA Enable. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t _unused_8:8;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_17:15;
  } B;
} SIPI_CCR0_tag;

typedef union SIPI_CSR0_union_tag {    /* SIPI Channel Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t ACKR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t RAR:1;
    vuint32_t _unused_8:24;
  } B;
} SIPI_CSR0_tag;

typedef union SIPI_CIR0_union_tag {    /* SIPI Channel Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ACKIE:1;                 /* Acknowledge Error Interrupt Enable. */
    vuint32_t TIDIE:1;                 /* Transaction ID Error Interrupt Enable. */
    vuint32_t TOIE:1;                  /* Timeout Error Interrupt Enabled. */
    vuint32_t TCIE:1;                  /* Trigger Command Interrupt Enable. */
    vuint32_t RAIE:1;                  /* Read Answer Interrupt Enable. */
    vuint32_t WAIE:1;                  /* Write Acknowledge Interrupt Enable. */
    vuint32_t _unused_6:26;
  } B;
} SIPI_CIR0_tag;

typedef union SIPI_CTOR0_union_tag {   /* SIPI Channel Timeout Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
    vuint32_t _unused_8:24;
  } B;
} SIPI_CTOR0_tag;

typedef union SIPI_CCRC0_union_tag {   /* SIPI Channel CRC Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CRCT:16;
    vuint32_t CRCI:16;
  } B;
} SIPI_CCRC0_tag;

typedef union SIPI_CAR0_union_tag {    /* SIPI Channel Address Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR0_tag;

typedef union SIPI_CDR0_union_tag {    /* SIPI Channel Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR0_tag;

typedef union SIPI_CCR1_union_tag {    /* SIPI Channel Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DEN:1;                   /* DMA Enable. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t RRT:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t ST:1;
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t _unused_8:8;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_17:15;
  } B;
} SIPI_CCR1_tag;

typedef union SIPI_CSR1_union_tag {    /* SIPI Channel Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t ACKR:1;
    vuint32_t TID:3;
    vuint32_t RAR:1;
    vuint32_t _unused_8:24;
  } B;
} SIPI_CSR1_tag;

typedef union SIPI_CIR1_union_tag {    /* SIPI Channel Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t ACKIE:1;
    vuint32_t TIDIE:1;
    vuint32_t TOIE:1;
    vuint32_t TCIE:1;
    vuint32_t RAIE:1;
    vuint32_t WAIE:1;
    vuint32_t _unused_6:26;
  } B;
} SIPI_CIR1_tag;

typedef union SIPI_CTOR1_union_tag {   /* SIPI Channel Timeout Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
    vuint32_t _unused_8:24;
  } B;
} SIPI_CTOR1_tag;

typedef union SIPI_CCRC1_union_tag {   /* SIPI Channel CRC Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CRCT:16;
    vuint32_t CRCI:16;
  } B;
} SIPI_CCRC1_tag;

typedef union SIPI_CAR1_union_tag {    /* SIPI Channel Address Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR1_tag;

typedef union SIPI_CDR1_union_tag {    /* SIPI Channel Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR1_tag;

typedef union SIPI_CCR2_union_tag {    /* SIPI Channel Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DEN:1;                   /* DMA Enable. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t ST:1;
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t _unused_8:8;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_17:15;
  } B;
} SIPI_CCR2_tag;

typedef union SIPI_CSR2_union_tag {    /* SIPI Channel Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t ACKR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t RAR:1;
    vuint32_t _unused_8:24;
  } B;
} SIPI_CSR2_tag;

typedef union SIPI_CIR2_union_tag {    /* SIPI Channel Interrupt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t ACKIE:1;
    vuint32_t TIDIE:1;
    vuint32_t TOIE:1;
    vuint32_t TCIE:1;
    vuint32_t RAIE:1;
    vuint32_t WAIE:1;
    vuint32_t _unused_6:26;
  } B;
} SIPI_CIR2_tag;

typedef union SIPI_CTOR2_union_tag {   /* SIPI Channel Timeout Register 2 */
  vuint32_t R;
  struct {
    vuint32_t TOR:8;
    vuint32_t _unused_8:24;
  } B;
} SIPI_CTOR2_tag;

typedef union SIPI_CCRC2_union_tag {   /* SIPI Channel CRC Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CRCT:16;
    vuint32_t CRCI:16;
  } B;
} SIPI_CCRC2_tag;

typedef union SIPI_CAR2_union_tag {    /* SIPI Channel Address Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR2_tag;

typedef union SIPI_CDR2__union_tag {   /* SIPI Channel Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CDR2:32;
  } B;
} SIPI_CDR2__tag;

typedef union SIPI_CCR3_union_tag {    /* SIPI Channel Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t DEN:1;                   /* DMA Enable. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t _unused_8:8;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_17:15;
  } B;
} SIPI_CCR3_tag;

typedef union SIPI_CSR3_union_tag {    /* SIPI Channel Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t ACKR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t RAR:1;
    vuint32_t _unused_8:24;
  } B;
} SIPI_CSR3_tag;

typedef union SIPI_CIR3_union_tag {    /* SIPI Channel Interrupt Register 3 */
  vuint32_t R;
  struct {
    vuint32_t ACKIE:1;
    vuint32_t TIDIE:1;
    vuint32_t TOIE:1;
    vuint32_t TCIE:1;
    vuint32_t RAIE:1;
    vuint32_t WAIE:1;
    vuint32_t _unused_6:26;
  } B;
} SIPI_CIR3_tag;

typedef union SIPI_CTOR3_union_tag {   /* SIPI Channel Timeout Register 3 */
  vuint32_t R;
  struct {
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
    vuint32_t _unused_8:24;
  } B;
} SIPI_CTOR3_tag;

typedef union SIPI_CCRC3_union_tag {   /* SIPI Channel CRC Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CRCT:16;
    vuint32_t CRCI:16;
  } B;
} SIPI_CCRC3_tag;

typedef union SIPI_CAR3_union_tag {    /* SIPI Channel Address Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR3_tag;

typedef union SIPI_CDR3_union_tag {    /* SIPI Channel Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR3_tag;

typedef union SIPI_MCR_union_tag {     /* SIPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SR:1;                    /* Soft Reset */
    vuint32_t MOEN:1;                  /* Module Enable */
    vuint32_t INIT:1;                  /* Initialization Mode */
    vuint32_t TEN:1;                   /* Target Enable */
    vuint32_t CHNSB:1;                 /* Channel coding select bit. */
    vuint32_t _unused_5:4;
    vuint32_t MCRIE:1;                 /* Max Count Reached Interrupt Enable */
    vuint32_t CRCIE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t _unused_11:3;
    vuint32_t AID:2;                   /* Address Increment/Decrement */
    vuint32_t PRSCLR:11;               /* Timeout counter prescaler */
    vuint32_t _unused_27:2;
    vuint32_t HALT:1;                  /* Halt Mode Enable */
    vuint32_t _unused_30:1;
    vuint32_t FRZ:1;                   /* Freeze Enable */
  } B;
} SIPI_MCR_tag;

typedef union SIPI_SR_union_tag {      /* SIPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t STATE:4;
    vuint32_t TE:4;
    vuint32_t _unused_8:1;
    vuint32_t MCR:1;                   /* Maximum Count Reached. */
    vuint32_t GCRCE:1;
    vuint32_t _unused_11:19;
    vuint32_t LPMACK:1;                /* Low Power Mode Acknowledge. */
    vuint32_t FRZACK:1;
  } B;
} SIPI_SR_tag;

typedef union SIPI_MAXCR_union_tag {   /* SIPI Max Count Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t MXCNT:30;
  } B;
} SIPI_MAXCR_tag;

typedef union SIPI_ARR_union_tag {     /* SIPI Address Reload Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t ADRLD:30;
  } B;
} SIPI_ARR_tag;

typedef union SIPI_ACR_union_tag {     /* SIPI Address Count Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t ADCNT:30;                /* Feflects the count value of address counter at target node. */
  } B;
} SIPI_ACR_tag;

typedef union SIPI_ERR_union_tag {     /* SIPI Error Register */
  vuint32_t R;
  struct {
    vuint32_t ACKE0:1;
    vuint32_t TIDE0:1;
    vuint32_t TOE0:1;
    vuint32_t _unused_3:5;
    vuint32_t ACKE1:1;
    vuint32_t TIDE1:1;
    vuint32_t TOE1:1;
    vuint32_t _unused_11:5;
    vuint32_t ACKE2:1;
    vuint32_t TIDE2:1;
    vuint32_t TOE2:1;
    vuint32_t _unused_19:5;
    vuint32_t ACKE3:1;
    vuint32_t TIDE3:1;
    vuint32_t TOE3:1;
    vuint32_t _unused_27:5;
  } B;
} SIPI_ERR_tag;

struct SIPI_tag {
  SIPI_CCR0_tag CCR0;                  /* SIPI Channel Control Register 0 */
  SIPI_CSR0_tag CSR0;                  /* SIPI Channel Status Register 0 */
  uint8_t SIPI_reserved0[4];
  SIPI_CIR0_tag CIR0;                  /* SIPI Channel Interrupt Register 0 */
  SIPI_CTOR0_tag CTOR0;                /* SIPI Channel Timeout Register 0 */
  SIPI_CCRC0_tag CCRC0;                /* SIPI Channel CRC Register 0 */
  SIPI_CAR0_tag CAR0;                  /* SIPI Channel Address Register 0 */
  SIPI_CDR0_tag CDR0;                  /* SIPI Channel Data Register 0 */
  SIPI_CCR1_tag CCR1;                  /* SIPI Channel Control Register 1 */
  SIPI_CSR1_tag CSR1;                  /* SIPI Channel Status Register 1 */
  uint8_t SIPI_reserved1[4];
  SIPI_CIR1_tag CIR1;                  /* SIPI Channel Interrupt Register 1 */
  SIPI_CTOR1_tag CTOR1;                /* SIPI Channel Timeout Register 1 */
  SIPI_CCRC1_tag CCRC1;                /* SIPI Channel CRC Register 1 */
  SIPI_CAR1_tag CAR1;                  /* SIPI Channel Address Register 1 */
  SIPI_CDR1_tag CDR1;                  /* SIPI Channel Data Register 1 */
  SIPI_CCR2_tag CCR2;                  /* SIPI Channel Control Register 2 */
  SIPI_CSR2_tag CSR2;                  /* SIPI Channel Status Register 2 */
  uint8_t SIPI_reserved2[4];
  SIPI_CIR2_tag CIR2;                  /* SIPI Channel Interrupt Register 2 */
  SIPI_CTOR2_tag CTOR2;                /* SIPI Channel Timeout Register 2 */
  SIPI_CCRC2_tag CCRC2;                /* SIPI Channel CRC Register 2 */
  SIPI_CAR2_tag CAR2;                  /* SIPI Channel Address Register 2 */
  SIPI_CDR2__tag CDR2_[8];             /* SIPI Channel Data Register 2 */
  SIPI_CCR3_tag CCR3;                  /* SIPI Channel Control Register 3 */
  SIPI_CSR3_tag CSR3;                  /* SIPI Channel Status Register 3 */
  uint8_t SIPI_reserved3[4];
  SIPI_CIR3_tag CIR3;                  /* SIPI Channel Interrupt Register 3 */
  SIPI_CTOR3_tag CTOR3;                /* SIPI Channel Timeout Register 3 */
  SIPI_CCRC3_tag CCRC3;                /* SIPI Channel CRC Register 3 */
  SIPI_CAR3_tag CAR3;                  /* SIPI Channel Address Register 3 */
  SIPI_CDR3_tag CDR3;                  /* SIPI Channel Data Register 3 */
  SIPI_MCR_tag MCR;                    /* SIPI Module Configuration Register */
  SIPI_SR_tag SR;                      /* SIPI Status Register */
  SIPI_MAXCR_tag MAXCR;                /* SIPI Max Count Register */
  SIPI_ARR_tag ARR;                    /* SIPI Address Reload Register */
  SIPI_ACR_tag ACR;                    /* SIPI Address Count Register */
  SIPI_ERR_tag ERR;                    /* SIPI Error Register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t _unused_8:2;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t CSP:1;                   /* Always reads back zero */
    vuint32_t PARTNUM:16;              /* MCU Part Number */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t FR:1;                    /* FlexRay present */
    vuint32_t _unused_1:3;
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t PARTNUM:12;              /* ASCII character in MCU Part Number */
    vuint32_t _unused_20:3;
    vuint32_t SPEED_GRADING:4;         /* Speed Grading */
    vuint32_t PART_DIFFERENTIATOR:4;   /* Part Differentiator */
    vuint32_t SF:1;                    /* Manufacturer */
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* SIUL2 DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag 0 */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag 1 */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag 2 */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag 3 */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag 4 */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag 5 */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag 6 */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag 7 */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag 8 */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag 9 */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag 10 */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag 11 */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag 12 */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag 13 */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag 14 */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag 15 */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag 16 */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag 17 */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag 18 */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag 19 */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag 20 */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag 21 */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag 22 */
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag 23 */
    vuint32_t EIF24:1;                 /* External Interrupt Status Flag 24 */
    vuint32_t EIF25:1;                 /* External Interrupt Status Flag 25 */
    vuint32_t EIF26:1;                 /* External Interrupt Status Flag 26 */
    vuint32_t EIF27:1;                 /* External Interrupt Status Flag 27 */
    vuint32_t EIF28:1;                 /* External Interrupt Status Flag 28 */
    vuint32_t EIF29:1;                 /* External Interrupt Status Flag 29 */
    vuint32_t EIF30:1;                 /* External Interrupt Status Flag 30 */
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag 31 */
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* SIUL2 DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE0:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE23:1;
    vuint32_t EIRE24:1;
    vuint32_t EIRE25:1;
    vuint32_t EIRE26:1;
    vuint32_t EIRE27:1;
    vuint32_t EIRE28:1;
    vuint32_t EIRE29:1;
    vuint32_t EIRE30:1;
    vuint32_t EIRE31:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* SIUL2 DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR0:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR24:1;
    vuint32_t DIRSR25:1;
    vuint32_t DIRSR26:1;
    vuint32_t DIRSR27:1;
    vuint32_t DIRSR28:1;
    vuint32_t DIRSR29:1;
    vuint32_t DIRSR30:1;
    vuint32_t DIRSR31:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE0:1;
    vuint32_t IREE1:1;
    vuint32_t IREE2:1;
    vuint32_t IREE3:1;
    vuint32_t IREE4:1;
    vuint32_t IREE5:1;
    vuint32_t IREE6:1;
    vuint32_t IREE7:1;
    vuint32_t IREE8:1;
    vuint32_t IREE9:1;
    vuint32_t IREE10:1;
    vuint32_t IREE11:1;
    vuint32_t IREE12:1;
    vuint32_t IREE13:1;
    vuint32_t IREE14:1;
    vuint32_t IREE15:1;
    vuint32_t IREE16:1;
    vuint32_t IREE17:1;
    vuint32_t IREE18:1;
    vuint32_t IREE19:1;
    vuint32_t IREE20:1;
    vuint32_t IREE21:1;
    vuint32_t IREE22:1;
    vuint32_t IREE23:1;
    vuint32_t IREE24:1;
    vuint32_t IREE25:1;
    vuint32_t IREE26:1;
    vuint32_t IREE27:1;
    vuint32_t IREE28:1;
    vuint32_t IREE29:1;
    vuint32_t IREE30:1;
    vuint32_t IREE31:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE0:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE23:1;
    vuint32_t IFEE24:1;
    vuint32_t IFEE25:1;
    vuint32_t IFEE26:1;
    vuint32_t IFEE27:1;
    vuint32_t IFEE28:1;
    vuint32_t IFEE29:1;
    vuint32_t IFEE30:1;
    vuint32_t IFEE31:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE0:1;
    vuint32_t IFE1:1;
    vuint32_t IFE2:1;
    vuint32_t IFE3:1;
    vuint32_t IFE4:1;
    vuint32_t IFE5:1;
    vuint32_t IFE6:1;
    vuint32_t IFE7:1;
    vuint32_t IFE8:1;
    vuint32_t IFE9:1;
    vuint32_t IFE10:1;
    vuint32_t IFE11:1;
    vuint32_t IFE12:1;
    vuint32_t IFE13:1;
    vuint32_t IFE14:1;
    vuint32_t IFE15:1;
    vuint32_t IFE16:1;
    vuint32_t IFE17:1;
    vuint32_t IFE18:1;
    vuint32_t IFE19:1;
    vuint32_t IFE20:1;
    vuint32_t IFE21:1;
    vuint32_t IFE22:1;
    vuint32_t IFE23:1;
    vuint32_t IFE24:1;
    vuint32_t IFE25:1;
    vuint32_t IFE26:1;
    vuint32_t IFE27:1;
    vuint32_t IFE28:1;
    vuint32_t IFE29:1;
    vuint32_t IFE30:1;
    vuint32_t IFE31:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
    vuint32_t _unused_4:28;
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
    vuint32_t _unused_4:28;
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration */
  vuint32_t R;
  struct {
    vuint32_t MUX_MODE:4;              /* Mux Mode Select field */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t CRPOINT_TRIM:2;          /* Crosspoint Trim */
    vuint32_t DSE:3;                   /* Drive strength field */
    vuint32_t PUS:2;                   /* Pull Up / Down Config Field */
    vuint32_t PUE:1;                   /* Pull Select Field */
    vuint32_t SRE:2;                   /* Slew Rate field */
    vuint32_t PKE:1;                   /* Pull Enable field */
    vuint32_t INV:1;                   /* Invert Data Output field */
    vuint32_t HYS:1;                   /* Hysteresis Enable field */
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t ODE:1;                   /* Open Drain Enable field */
    vuint32_t OBE:1;                   /* Output Buffer Enable field */
    vuint32_t DCYCLE_TRIM:2;           /* Dcycle Trim */
    vuint32_t DDR_ODT:3;               /* On die Termination. */
    vuint32_t DDR_SEL:2;               /* DDR Select */
    vuint32_t DDR_INPUT:1;             /* DDR Input */
    vuint32_t DDR_DO_TRIM:2;           /* DDR Trim */
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_IMCR_union_tag {   /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DAISY:3;                 /* DAISY bit */
    vuint32_t _unused_3:29;
  } B;
} SIUL2_IMCR_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
  vuint32_t R;
  struct {
    vuint32_t PDO_4n3:1;               /* Pad Data Out */
    vuint32_t _unused_1:7;
    vuint32_t PDO_4n2:1;               /* Pad Data Out */
    vuint32_t _unused_9:7;
    vuint32_t PDO_4n1:1;               /* Pad Data Out */
    vuint32_t _unused_17:7;
    vuint32_t PDO_4n:1;                /* Pad Data Out */
    vuint32_t _unused_25:7;
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
  vuint32_t R;
  struct {
    vuint32_t PDI_4n3:1;               /* Pad Data In */
    vuint32_t _unused_1:7;
    vuint32_t PDI_4n2:1;               /* Pad Data In */
    vuint32_t _unused_9:7;
    vuint32_t PDI_4n1:1;               /* Pad Data In */
    vuint32_t _unused_17:7;
    vuint32_t PDI_4n:1;                /* Pad Data In */
    vuint32_t _unused_25:7;
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO1_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO1_tag;

typedef union SIUL2_PGPDO0_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO0_tag;

typedef union SIUL2_PGPDO3_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO3_tag;

typedef union SIUL2_PGPDO2_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO2_tag;

typedef union SIUL2_PGPDO5_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO5_tag;

typedef union SIUL2_PGPDO4_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO4_tag;

typedef union SIUL2_PGPDO7_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO7_tag;

typedef union SIUL2_PGPDO6_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO6_tag;

typedef union SIUL2_PGPDO9_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO9_tag;

typedef union SIUL2_PGPDO8_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO8_tag;

typedef union SIUL2_PGPDO10_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO10_tag;

typedef union SIUL2_PGPDI1_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI1_tag;

typedef union SIUL2_PGPDI0_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI0_tag;

typedef union SIUL2_PGPDI3_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI3_tag;

typedef union SIUL2_PGPDI2_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI2_tag;

typedef union SIUL2_PGPDI5_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI5_tag;

typedef union SIUL2_PGPDI4_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI4_tag;

typedef union SIUL2_PGPDI7_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI7_tag;

typedef union SIUL2_PGPDI6_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI6_tag;

typedef union SIUL2_PGPDI9_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI9_tag;

typedef union SIUL2_PGPDI8_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI8_tag;

typedef union SIUL2_PGPDI10_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI10_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
    vuint32_t MASK:16;                 /* Mask Field */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* SIUL2 DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* SIUL2 DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* SIUL2 DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[380];
  SIUL2_MSCR_tag MSCR[310];            /* SIUL2 Multiplexed Signal Configuration */
  uint8_t SIUL2_reserved9[808];
  SIUL2_IMCR_tag IMCR[512];            /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[192];
  SIUL2_GPDO_tag GPDO[41];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved11[348];
  SIUL2_GPDI_tag GPDI[41];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved12[348];
  SIUL2_PGPDO1_tag PGPDO1;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO0_tag PGPDO0;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO3_tag PGPDO3;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO2_tag PGPDO2;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO5_tag PGPDO5;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO4_tag PGPDO4;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO7_tag PGPDO7;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO6_tag PGPDO6;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO9_tag PGPDO9;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO8_tag PGPDO8;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved13[2];
  SIUL2_PGPDO10_tag PGPDO10;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved14[40];
  SIUL2_PGPDI1_tag PGPDI1;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI0_tag PGPDI0;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI3_tag PGPDI3;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI2_tag PGPDI2;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI5_tag PGPDI5;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI4_tag PGPDI4;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI7_tag PGPDI7;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI6_tag PGPDI6;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI9_tag PGPDI9;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI8_tag PGPDI8;             /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved15[2];
  SIUL2_PGPDI10_tag PGPDI10;           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved16[40];
  SIUL2_MPGPDO_tag MPGPDO[11];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HALT:1;                  /* Halt */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t _unused_4:4;
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t _unused_15:1;
    vuint32_t PCSIS:8;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t BR:4;                    /* Baud Rate Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t DBR:1;                   /* Double Baud Rate */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:22;
    vuint32_t _unused_22:1;
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t FMSZ:5;                  /* Frame Size */
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[4];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[1]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t _unused_20:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_22:1;
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t _unused_29:1;
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:14;
    vuint32_t _unused_14:1;            /* Always write the reset value to this field. */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
  } B;
} SPI_RSER_tag;

typedef union SPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t PCS:8;                   /* PCS */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
  } B;
} SPI_PUSHR_PUSHR_tag;

typedef union SPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t _unused_16:16;
  } B;
} SPI_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_PUSHR_union_tag {
  SPI_PUSHR_PUSHR_tag PUSHR;           /* PUSH TX FIFO Register In Master Mode */
  SPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

typedef union SPI_CTARE_union_tag {    /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
    vuint32_t _unused_11:5;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t _unused_17:15;
  } B;
} SPI_CTARE_tag;

typedef union SPI_SREX_union_tag {     /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t _unused_9:2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t _unused_12:2;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t _unused_15:17;
  } B;
} SPI_SREX_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  uint8_t SPI_reserved1[16];
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_PUSHR_tag PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[5];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved2[44];
  SPI_RXFR_tag RXFR[5];                /* Receive FIFO Registers */
  uint8_t SPI_reserved3[140];
  SPI_CTARE_tag CTARE[4];              /* Clock and Transfer Attributes Register Extended */
  uint8_t SPI_reserved4[16];
  SPI_SREX_tag SREX;                   /* Status Register Extended */
};


/* ============================================================================
   =============================== Module: SRC ================================
   ============================================================================ */

typedef union SRC_BMR1_union_tag {     /* Boot Mode Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BOOT_CFG1:8;             /* BOOT_CFG Byte 0 */
    vuint32_t BOOT_CFG2:8;             /* BOOT_CFG Byte 1 */
    vuint32_t BOOT_CFG3:8;             /* BOOT_CFG Byte 2 */
    vuint32_t BOOT_CFG4:8;             /* BOOT_CFG Byte 3 */
  } B;
} SRC_BMR1_tag;

typedef union SRC_BMR2_union_tag {     /* Boot Mode Register 2 */
  vuint32_t R;
  struct {
    vuint32_t SEC_CONFIG:2;            /* Device Security Config */
    vuint32_t _unused_2:1;
    vuint32_t FIELD_RETURN:1;          /* FIELD_RETURN */
    vuint32_t BT_FUSE_SEL:1;           /* BT_FUSE_SEL */
    vuint32_t _unused_5:3;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:8;
    vuint32_t BMOD:2;                  /* BOOTMOD CAPTURED VALUE */
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:5;
  } B;
} SRC_BMR2_tag;

typedef union SRC_GPR1_BOOT_union_tag { /* General Purpose Register 1 For Boot */
  vuint32_t R;
  struct {
    vuint32_t PERSIST_BOOT_DISABLE_FAST_REBOOT:1; /* Indicates the state of Fast Reboot from DDR */
    vuint32_t _unused_1:31;
  } B;
} SRC_GPR1_BOOT_tag;

typedef union SRC_GPR1_union_tag {     /* General Purpose Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t ARM_PLL_SOURCE_SELECT:1; /* ARM PLL Source Selection */
    vuint32_t ENET_PLL_SOURCE_SELECT:1; /* ENET PLL Source Selection */
    vuint32_t DDR_PLL_SOURCE_SELECT:1; /* DDR PLL Source Selection */
    vuint32_t PERIPH_PLL_SOURCE_SELECT:1; /* PLL SOURCE SELECTION */
    vuint32_t VIDEO_PLL_SOURCE_SELECT:1; /* Video PLL Source Selection */
  } B;
} SRC_GPR1_tag;

typedef union SRC_GPR2_union_tag {     /* General Purpose Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FSNCF0:1;                /* FCCU SW NCF0 */
    vuint32_t FSNCF1:1;                /* FCCU SW NCF1 */
    vuint32_t FSNCF2:1;                /* FCCU SW NCF2 */
    vuint32_t FSNCF3:1;                /* FCCU SW NCF3 */
    vuint32_t FSNCF4:1;                /* FCCU SW NCF4 */
    vuint32_t _unused_5:27;
  } B;
} SRC_GPR2_tag;

typedef union SRC_GPR3_union_tag {     /* General Purpose Register 3 */
  vuint32_t R;
  struct {
    vuint32_t HPSMI_CLK_ENABLE:1;
    vuint32_t ENET_MODE:1;
    vuint32_t _unused_2:1;
    vuint32_t D32SS:1;
    vuint32_t PCCAS:1;                 /* PCIE_COMMON_CLOCK_ARCHITECTURE_SELECT */
    vuint32_t PCIE_RFCC_CLK:1;
    vuint32_t LVDS_BANDGAP_REF_ENABLE:1; /* LVDS_BANDGAP_REF_ENABLE When LFAST LVDS pads are not used it is recommended to Disable LVDS bandgap reference by writing 0 to this bit to reduce leakage. */
    vuint32_t _unused_7:25;
  } B;
} SRC_GPR3_tag;

typedef union SRC_GPR4_union_tag {     /* General Purpose Register 4 */
  vuint32_t R;
  struct {
    vuint32_t TSENS_ENABLE:1;          /* Temperature sensor enable */
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:30;
  } B;
} SRC_GPR4_tag;

typedef union SRC_GPR5_union_tag {     /* General Purpose Register 5 */
  vuint32_t R;
  struct {
    vuint32_t GPR_PCIE_APPS_PM_XMT_PME:1; /* GPR_PCIE_APPS_PM_XMT_PME */
    vuint32_t GPR_PCIE_DEVICE_TYPE:4;  /* GPR_PCIE_DEVICE_TYPE */
    vuint32_t GPR_PCIE_DIAG_CTRL_BUS:3; /* GPR_PCIE_DIAG_CTRL_BUS */
    vuint32_t GPR_PCIE_SYS_INT:1;      /* GPR_PCIE_SYS_INT */
    vuint32_t GPR_PCIE_APP_LTSSM_ENABLE:1; /* GPR_PCIE_APP_LTSSM_ENABLE */
    vuint32_t _unused_10:1;
    vuint32_t GPR_PCIE_APP_INIT_RST:1; /* GPR_PCIE_APP_INIT_RST */
    vuint32_t GPR_PCIE_APP_REQ_ENTR_L1:1; /* GPR_PCIE_APP_REQ_ENTR_L1 */
    vuint32_t GPR_PCIE_APP_READY_ENTR_L23:1; /* GPR_PCIE_APP_READY_ENTR_L23 */
    vuint32_t GPR_PCIE_APP_REQ_EXIT_L1:1; /* GPR_PCIE_APP_REQ_EXIT_L1 */
    vuint32_t GPR_PCIE_BUTTON_RST_N:1; /* GPR_PCIE_BUTTON_RST_N */
    vuint32_t GPR_PCIE_PERST_N:1;      /* GPR_PCIE_PERST_N */
    vuint32_t PCIE_APPS_PM_XMT_TURNOFF:1; /* PCIE_APPS_PM_XMT_TURNOFF */
    vuint32_t _unused_18:1;
    vuint32_t PCIE_PHY_LOS_BIAS:3;
    vuint32_t PCIE_PHY_LOS_LEVEL:5;
    vuint32_t PCIE_PHY_RX0_EQ:3;       /* Rx Equalizer Setting */
    vuint32_t _unused_30:2;
  } B;
} SRC_GPR5_tag;

typedef union SRC_GPR6_union_tag {     /* General Purpose Register 6 */
  vuint32_t R;
  struct {
    vuint32_t PCIE_PCS_TX_DEEMPH_GEN2_3P5DB:6; /* Tx De-emphasis at 3.5 dB */
    vuint32_t PCIE_PCS_TX_DEEMPH_GEN2_6DB:6; /* Tx De-emphasis at 6 dB */
    vuint32_t PCIE_PCS_TX_DEEMPH_GEN1:6; /* Tx De-emphasis at 3.5 dB */
    vuint32_t PCIE_PCS_TX_SWING_FULL:7; /* Tx Amplitude (Full Swing Mode) */
    vuint32_t PCIE_PCS_TX_SWING_LOW:7; /* Tx Amplitude (Low Swing Mode) */
  } B;
} SRC_GPR6_tag;

typedef union SRC_GPR8_union_tag {     /* General Purpose Register 8 */
  vuint32_t R;
  struct {
    vuint32_t QOS_2D_ACE:4;
    vuint32_t _unused_4:3;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:24;
  } B;
} SRC_GPR8_tag;

typedef union SRC_GPR10_union_tag {    /* General Purpose Register 10 */
  vuint32_t R;
  struct {
    vuint32_t CLUSTER0_CLOCK_GATING_ENABLE:1;
    vuint32_t CLUSTER1_CLOCK_GATING_ENABLE:1;
    vuint32_t _unused_2:6;
    vuint32_t JPEG_D_HARD_RST:1;
    vuint32_t _unused_9:21;
    vuint32_t PCIE_CFG_READY_CLR_MASK:1; /* PCIE_CFG_READY_CLR_MASK */
    vuint32_t PCIE_APP_LTSSM_EN_CLR_MASK:1; /* PCIE_APP_LTSSM_EN_CLR_MASK */
  } B;
} SRC_GPR10_tag;

typedef union SRC_GPR11_union_tag {    /* General Purpose Register 11 */
  vuint32_t R;
  struct {
    vuint32_t PCIE_PHY_MPLL_MULTIPLIER:7; /* MPLL Frequency Multiplier Control */
    vuint32_t _unused_7:4;
    vuint32_t PCIE_MSI_FUNC_NUM:3;     /* PCIE_MSI_FUNC_NUM */
    vuint32_t PCIE_MSI_TC:3;           /* PCIE_MSI_TC */
    vuint32_t PCIE_MSI_VECTOR:5;       /* PCIE_MSI_VECTOR */
    vuint32_t PCIE_CFG_READY:1;        /* PCIE_CFG_READY */
    vuint32_t _unused_23:9;
  } B;
} SRC_GPR11_tag;

typedef union SRC_GPR12_union_tag {    /* General Purpose Register 12 */
  vuint32_t R;
  struct {
    vuint32_t PCE_DEC200:1;            /* Parity check enable in read data of DEC200 encoder */
    vuint32_t PCE_FDMA:1;              /* Parity check enable in read data of FastDMA */
    vuint32_t PCE_NIC:1;               /* Parity check enable in read address to NIC301 (master port M11) from DEC200_encoder/FastDMA */
    vuint32_t _unused_3:1;
    vuint32_t PEI_DEC200:1;            /* Parity error injection in read data of DEC200 encoder */
    vuint32_t PEI_FDMA:1;              /* Parity error injection in read data of FastDMA */
    vuint32_t PEI_NIC:1;               /* Parity error injection in read address to NIC301 (master port M11) from DEC200_Encoder/fastDMA */
    vuint32_t _unused_7:25;
  } B;
} SRC_GPR12_tag;

typedef union SRC_GPR13_union_tag {    /* General Purpose Register 13 */
  vuint32_t R;
  struct {
    vuint32_t SPIDEN:1;                /* SPIDEN */
    vuint32_t SPNIDEN:1;               /* SPNIDEN */
    vuint32_t WFE_SEL_CA53_COMPLEX:1;  /* WFE_SEL_CA53_COMPLEX */
    vuint32_t CM4_WFE:1;
    vuint32_t _unused_4:28;
  } B;
} SRC_GPR13_tag;

typedef union SRC_GPR14_union_tag {    /* General Purpose Register 14 */
  vuint32_t R;
  struct {
    vuint32_t VSEL_QuadSPI:3;          /* VSEL_QuadSPI */
    vuint32_t VSEL_VIU0:3;             /* VSEL_VIU0 */
    vuint32_t VSEL_VIU1:3;             /* VSEL_VIU1 */
    vuint32_t VSEL_GPIO0:3;            /* VSEL_GPIO0 */
    vuint32_t VSEL_GPIO1:3;            /* VSEL_GPIO1 */
    vuint32_t VSEL_GPIO2:3;            /* VSEL_GPIO2 */
    vuint32_t _unused_18:3;
    vuint32_t VSEL_ETHERNET:3;         /* VSEL_ETHERNET */
    vuint32_t VSEL_DCU:3;              /* VSEL_DCU */
    vuint32_t _unused_27:5;
  } B;
} SRC_GPR14_tag;

typedef union SRC_GPR15_union_tag {    /* General Purpose Register 15 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t CCI_QOS_OVERRIDE:5;      /* CCI_QOS_OVERRIDE */
    vuint32_t _unused_8:24;
  } B;
} SRC_GPR15_tag;

typedef union SRC_GPR16_union_tag {    /* General Purpose Register 16 */
  vuint32_t R;
  struct {
    vuint32_t CA53_SYSTEM_ERROR_INTERRUPT_REQUEST_EN:4;
    vuint32_t _unused_4:1;
    vuint32_t CA53_0_BROADCASTINNER:1; /* CA53_0_BROADCASTINNER */
    vuint32_t CA53_0_BROADCASTOUTER:1; /* CA53_0_BROADCASTOUTER */
    vuint32_t _unused_7:1;
    vuint32_t CA53_1_BROADCASTINNER:1; /* BROADCASTINNER of Cortex-A53CA */
    vuint32_t CA53_1_BROADCASTOUTER:1; /* CA53_1_BROADCASTOUTER */
    vuint32_t _unused_10:12;
    vuint32_t _unused_22:3;
    vuint32_t CA53_0_SYSBARDISABLE:1;  /* SYSBARDISABLE of core 0 of cluster 0 */
    vuint32_t CA53_1_SYSBARDISABLE:1;  /* SYSBARDISABLE of core 1 of cluster 0 */
    vuint32_t CA53_2_SYSBARDISABLE:1;  /* SYSBARDISABLE of core 0 of cluster 1 */
    vuint32_t CA53_3_SYSBARDISABLE:1;  /* SYSBARDISABLE of core 1 of cluster 1 */
    vuint32_t _unused_29:2;
    vuint32_t FCCU_NMI_DIS:1;          /* FCCU NMI Disable for Cortex-M4 */
  } B;
} SRC_GPR16_tag;

typedef union SRC_GPR18_union_tag {    /* General Purpose Register 18 */
  vuint32_t R;
  struct {
    vuint32_t CORE_WARM_RESET_STATUS:4; /* Warm Reset Status Of Cortex-A53 core */
    vuint32_t _unused_4:28;
  } B;
} SRC_GPR18_tag;

typedef union SRC_GPR19_union_tag {    /* General Purpose Register 19 */
  vuint32_t R;
  struct {
    vuint32_t CNTVALUEB_CLUSTER0_LOW_BITS:32; /* Lower 32 bits of CNTVALUEB of Cortex-A53 Cluster0 */
  } B;
} SRC_GPR19_tag;

typedef union SRC_GPR20_union_tag {    /* General Purpose Register 20 */
  vuint32_t R;
  struct {
    vuint32_t CNTVALUEB_CLUSTER0_HIGH_BITS:32; /* Upper 32 bits of CNTVALUEB of Cortex-A53 Cluster0 */
  } B;
} SRC_GPR20_tag;

typedef union SRC_GPR21_union_tag {    /* General Purpose Register 21 */
  vuint32_t R;
  struct {
    vuint32_t CNTVALUEB_CLUSTER1_LOW_BITS:32; /* Lower 32 bits of CNTVALUEB of Cortex-A53 Cluster1 */
  } B;
} SRC_GPR21_tag;

typedef union SRC_GPR22_union_tag {    /* General Purpose Register 22 */
  vuint32_t R;
  struct {
    vuint32_t CNTVALUEB_CLUSTER1_HIGH_BITS:32; /* Upper 32 bits of CNTVALUEB of Cortex-A53 Cluster1 */
  } B;
} SRC_GPR22_tag;

typedef union SRC_GPR23_union_tag {    /* DDR_MEMORY_ACCESS_SECURE */
  vuint32_t R;
  struct {
    vuint32_t DDR_MEM_BLK_RET_SEC:32;
  } B;
} SRC_GPR23_tag;

typedef union SRC_GPR24_union_tag {    /* DDR_MEMORY_ACCESS_NON_SECURE */
  vuint32_t R;
  struct {
    vuint32_t DDR_MEM_BLK_RET_NON_SEC:32;
  } B;
} SRC_GPR24_tag;

typedef union SRC_GPR25_union_tag {    /* SRAM_MEMORY_ACCESS_SECURE */
  vuint32_t R;
  struct {
    vuint32_t SRAM_MEM_BLK_RST_RET_SEC:32;
  } B;
} SRC_GPR25_tag;

typedef union SRC_GPR26_union_tag {    /* SRAM_MEMORY_ACCESS_NON_SECURE */
  vuint32_t R;
  struct {
    vuint32_t SRAM_MEM_BLK_RST_RET_NON_SEC:32;
  } B;
} SRC_GPR26_tag;

typedef union SRC_GPR27_union_tag {    /* SELFTEST CONFIGURATION REGISTER */
  vuint32_t R;
  struct {
    vuint32_t STCU_UF_RST_DIS:1;       /* Disable destructive reset assertion due to STCU unrecoverable fault at RGM */
    vuint32_t EXT_RST_ASSERT_DIS:1;    /* Disable assertion of reset pin during online self-test */
    vuint32_t RST_AFT_MBISTONLY_SLFTST:1; /* Enable reset Assertion after MBIST Only Selftest This bit should always be programmed before running any selftest. */
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:4;
    vuint32_t _unused_8:8;
    vuint32_t _unused_16:16;
  } B;
} SRC_GPR27_tag;

typedef union SRC_PCIE_CONFIG_1_union_tag { /* PCIe Configuration1 register */
  vuint32_t R;
  struct {
    vuint32_t PCIE_PM_STATUS:1;        /* PCIE_RC_PMCSR[PME_Status] bit of the PMCSR. */
    vuint32_t PCIE_SMLH_LINK_UP:1;     /* PHY Link up/down indicator */
    vuint32_t PCIE_RADM_MSG_REQ_ID:16; /* The requester ID of the received Message. */
    vuint32_t _unused_18:1;
    vuint32_t PCIE_CFG_MSI_EN:1;       /* PCIe config MSI enable */
    vuint32_t PCIE_PM_CURNT_STATE:3;
    vuint32_t PCIE_RDLH_LINK_UP:1;     /* Data link layer up/down indicator */
    vuint32_t _unused_24:1;
    vuint32_t PCIE_PHY_MAC_RXSTATUS:3;
    vuint32_t PCIE_WAKE:1;             /* Wake Up. */
    vuint32_t _unused_29:3;
  } B;
} SRC_PCIE_CONFIG_1_tag;

typedef union SRC_DDR_SELF_REF_CTRL_union_tag { /* DDR Self Refresh Control register */
  vuint32_t R;
  struct {
    vuint32_t DDR0_SLF_REF_CLR:1;      /* DDR0 self refresh clear */
    vuint32_t DDR1_SLF_REF_CLR:1;      /* DDR1 self refresh clear */
    vuint32_t DDR0_EN_SLF_REF_RST:1;   /* DDR0 enable self refresh on reset */
    vuint32_t DDR1_EN_SLF_REF_RST:1;   /* DDR1 enable self refresh on reset */
    vuint32_t SRAM_BLK_PRSRV_RST:1;    /* SRAM block preserve on reset */
    vuint32_t _unused_5:27;
  } B;
} SRC_DDR_SELF_REF_CTRL_tag;

typedef union SRC_PCIE_CONFIG_0_union_tag { /* PCIe Configuration0 register */
  vuint32_t R;
  struct {
    vuint32_t PCIE_LNK_REQ_RST_CLR:1;  /* PCIe link request reset clear */
    vuint32_t _unused_1:1;
    vuint32_t PCIE_PHY_TX0_OFST:5;     /* PCIe PHY Tx0 term offset */
    vuint32_t PCIE_APP_UNLK_MSG:1;     /* PCIe app unlock message */
    vuint32_t PCIE_PHY_TX_VBOOST_LVL:3; /* Transmitter Voltage Boost Level */
    vuint32_t PCIE_PCS_CMN_CLK:1;      /* PCIe PCS common clocks */
    vuint32_t PCIE_PHY_RTUNE_REQ:1;    /* Termination Resistor Tune Request */
    vuint32_t PCIE_PIPE0_TX_DEEMPH:1;  /* PIPE Transmitter De-emphasis */
    vuint32_t _unused_14:1;
    vuint32_t PCIE_MSTR_RESP_ERR_MAP:2; /* Master Response Error Map */
    vuint32_t PCIE_SLV_RESP_ERR_MAP:6; /* Slave Response Error Map. */
    vuint32_t PCIE_MSI_REQ:1;
    vuint32_t _unused_24:8;
  } B;
} SRC_PCIE_CONFIG_0_tag;

typedef union SRC_SOC_MISC_CONFIG2_union_tag { /* SOC_MISC_CONFIG REGISTER 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t ECC_PCIE:1;              /* Disable ECC - PCIE */
    vuint32_t ECC_KRAM:1;              /* Disable ECC - KRAM */
    vuint32_t ECC_IPUS:1;              /* Disable ECC - IPUS */
    vuint32_t ECC_FASTDMA:1;           /* Disable ECC - FastDMA */
    vuint32_t ECC_ENET:1;              /* Disable ECC - ENET */
    vuint32_t ECC_DCU:1;               /* Disable ECC - DCU */
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} SRC_SOC_MISC_CONFIG2_tag;

struct SRC_tag {
  SRC_BMR1_tag BMR1;                   /* Boot Mode Register 1 */
  SRC_BMR2_tag BMR2;                   /* Boot Mode Register 2 */
  SRC_GPR1_BOOT_tag GPR1_BOOT;         /* General Purpose Register 1 For Boot */
  uint8_t SRC_reserved0[244];
  SRC_GPR1_tag GPR1;                   /* General Purpose Register 1 */
  SRC_GPR2_tag GPR2;                   /* General Purpose Register 2 */
  SRC_GPR3_tag GPR3;                   /* General Purpose Register 3 */
  SRC_GPR4_tag GPR4;                   /* General Purpose Register 4 */
  SRC_GPR5_tag GPR5;                   /* General Purpose Register 5 */
  SRC_GPR6_tag GPR6;                   /* General Purpose Register 6 */
  uint8_t SRC_reserved1[4];
  SRC_GPR8_tag GPR8;                   /* General Purpose Register 8 */
  uint8_t SRC_reserved2[4];
  SRC_GPR10_tag GPR10;                 /* General Purpose Register 10 */
  SRC_GPR11_tag GPR11;                 /* General Purpose Register 11 */
  SRC_GPR12_tag GPR12;                 /* General Purpose Register 12 */
  SRC_GPR13_tag GPR13;                 /* General Purpose Register 13 */
  SRC_GPR14_tag GPR14;                 /* General Purpose Register 14 */
  SRC_GPR15_tag GPR15;                 /* General Purpose Register 15 */
  SRC_GPR16_tag GPR16;                 /* General Purpose Register 16 */
  uint8_t SRC_reserved3[4];
  SRC_GPR18_tag GPR18;                 /* General Purpose Register 18 */
  SRC_GPR19_tag GPR19;                 /* General Purpose Register 19 */
  SRC_GPR20_tag GPR20;                 /* General Purpose Register 20 */
  SRC_GPR21_tag GPR21;                 /* General Purpose Register 21 */
  SRC_GPR22_tag GPR22;                 /* General Purpose Register 22 */
  SRC_GPR23_tag GPR23;                 /* DDR_MEMORY_ACCESS_SECURE */
  SRC_GPR24_tag GPR24;                 /* DDR_MEMORY_ACCESS_NON_SECURE */
  SRC_GPR25_tag GPR25;                 /* SRAM_MEMORY_ACCESS_SECURE */
  SRC_GPR26_tag GPR26;                 /* SRAM_MEMORY_ACCESS_NON_SECURE */
  SRC_GPR27_tag GPR27;                 /* SELFTEST CONFIGURATION REGISTER */
  uint8_t SRC_reserved4[20];
  SRC_PCIE_CONFIG_1_tag PCIE_CONFIG_1; /* PCIe Configuration1 register */
  SRC_DDR_SELF_REF_CTRL_tag DDR_SELF_REF_CTRL; /* DDR Self Refresh Control register */
  SRC_PCIE_CONFIG_0_tag PCIE_CONFIG_0; /* PCIe Configuration0 register */
  uint8_t SRC_reserved5[12];
  SRC_SOC_MISC_CONFIG2_tag SOC_MISC_CONFIG2; /* SOC_MISC_CONFIG REGISTER 2 */
};


/* ============================================================================
   =============================== Module: SSE ================================
   ============================================================================ */

typedef union SSE_CFG_union_tag {      /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t WDENSRC:1;               /* Watchdog restart source */
    vuint32_t IN02_SEL:1;              /* IN0- IN2 select */
    vuint32_t IN3_SEL:1;               /* IN3 Select */
    vuint32_t CMP_OPT:1;               /* Compare Option */
    vuint32_t WD_STK:1;                /* Watchdog output sticky */
    vuint32_t WD_EN:1;                 /* Watchdog Enable */
    vuint32_t PAR_EN:2;                /* Parity Checking Enable */
    vuint32_t EWD_EN:1;                /* Early Watchdog Window Service */
    vuint32_t _unused_9:23;
  } B;
} SSE_CFG_tag;

typedef union SSE_IR_union_tag {       /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t IN_VAL:16;               /* Input value to be compared */
    vuint32_t _unused_16:16;
  } B;
} SSE_IR_tag;

typedef union SSE_CR_union_tag {       /* Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CR_VAL:16;               /* Value to be compared with Input register */
    vuint32_t _unused_16:16;
  } B;
} SSE_CR_tag;

typedef union SSE_LUT_LSB_union_tag {  /* First Look Up Table Register */
  vuint32_t R;
  struct {
    vuint32_t LSB_VAL:32;              /* Value of the first look up table */
  } B;
} SSE_LUT_LSB_tag;

typedef union SSE_LUT_MSB_union_tag {  /* Second Look Up Table Register */
  vuint32_t R;
  struct {
    vuint32_t MSB_VAL:32;              /* Value of the second look up table */
  } B;
} SSE_LUT_MSB_tag;

typedef union SSE_WD_WIN_union_tag {   /* Watchdog Window Value */
  vuint32_t R;
  struct {
    vuint32_t WD_WIN:32;               /* Watchdog window */
  } B;
} SSE_WD_WIN_tag;

typedef union SSE_WD_TO_union_tag {    /* Watchdog Timeout */
  vuint32_t R;
  struct {
    vuint32_t WD_TO_VAL:32;            /* Timeout value for the watchdog */
  } B;
} SSE_WD_TO_tag;

typedef union SSE_INT_EN_union_tag {   /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t OUT2_IE:1;               /* OUT2 Interrupt Enable */
    vuint32_t OUT3_IE:2;               /* OUT3 Interrupt Enable */
    vuint32_t _unused_3:29;
  } B;
} SSE_INT_EN_tag;

typedef union SSE_STATE_union_tag {    /* State Register */
  vuint32_t R;
  struct {
    vuint32_t ST_ENC:4;                /* Encoded state values */
    vuint32_t ST_UNENC:2;              /* Unencoded State Values */
    vuint32_t WD_ERR:1;                /* Watchdog Error */
    vuint32_t PAR_ERR:1;               /* Parity Error */
    vuint32_t OUT2_ST:1;               /* OUT2 Status */
    vuint32_t _unused_9:23;
  } B;
} SSE_STATE_tag;

struct SSE_tag {
  SSE_CFG_tag CFG;                     /* Configuration Register */
  uint32_t SSE_reserved0[3];
  SSE_IR_tag IR;                       /* Input Register */
  uint32_t SSE_reserved1[3];
  SSE_CR_tag CR;                       /* Compare Register */
  uint32_t SSE_reserved2[3];
  SSE_LUT_LSB_tag LUT_LSB;             /* First Look Up Table Register */
  uint32_t SSE_reserved3[3];
  SSE_LUT_MSB_tag LUT_MSB;             /* Second Look Up Table Register */
  uint32_t SSE_reserved4[15];
  SSE_WD_WIN_tag WD_WIN;               /* Watchdog Window Value */
  uint32_t SSE_reserved5[3];
  SSE_WD_TO_tag WD_TO;                 /* Watchdog Timeout */
  uint32_t SSE_reserved6[3];
  SSE_INT_EN_tag INT_EN;               /* Interrupt Enable Register */
  uint32_t SSE_reserved7[3];
  SSE_STATE_tag STATE;                 /* State Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t RUNSW:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:6;
    vuint32_t LBSWPLLEN:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:20;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CLK_CFG:3;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:2;
    vuint32_t WRP:1;
    vuint32_t _unused_9:4;
    vuint32_t LB_DELAY:8;
    vuint32_t PTR:10;
    vuint32_t _unused_31:1;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;             /* Reserved */
    vuint32_t _unused_5:3;
    vuint32_t RFSF:1;
    vuint32_t UFSF:1;
    vuint32_t _unused_10:6;
    vuint32_t INVPSW:1;
    vuint32_t ENGESW:1;
    vuint32_t _unused_18:1;
    vuint32_t WDTOSW:1;
    vuint32_t LOCKESW:1;
    vuint32_t _unused_21:3;
    vuint32_t _unused_24:1;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_26:6;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t INVPUFM:1;
    vuint32_t ENGEUFM:1;
    vuint32_t _unused_2:1;
    vuint32_t WDTOUFM:1;
    vuint32_t LOCKEUFM:1;
    vuint32_t _unused_5:27;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBSSW0_union_tag { /* STCU2 On-Line LBIST Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t LBSSW0:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW4:1;
    vuint32_t LBSSW5:1;
    vuint32_t LBSSW6:1;
    vuint32_t LBSSW7:1;
    vuint32_t LBSSW8:1;
    vuint32_t LBSSW9:1;
    vuint32_t LBSSW10:1;
    vuint32_t LBSSW11:1;
    vuint32_t LBSSW12:1;
    vuint32_t LBSSW13:1;
    vuint32_t LBSSW14:1;
    vuint32_t LBSSW15:1;
    vuint32_t LBSSW16:1;
    vuint32_t LBSSW17:1;
    vuint32_t LBSSW18:1;
    vuint32_t LBSSW19:1;
    vuint32_t LBSSW20:1;
    vuint32_t LBSSW21:1;
    vuint32_t LBSSW22:1;
    vuint32_t LBSSW23:1;
    vuint32_t LBSSW24:1;
    vuint32_t LBSSW25:1;
    vuint32_t LBSSW26:1;
    vuint32_t _unused_27:5;
  } B;
} STCU2_LBSSW0_tag;

typedef union STCU2_LBESW0_union_tag { /* STCU2 On-Line LBIST End Flag Register 0 */
  vuint32_t R;
  struct {
    vuint32_t LBESW0:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW3:1;
    vuint32_t LBESW4:1;
    vuint32_t LBESW5:1;
    vuint32_t LBESW6:1;
    vuint32_t LBESW7:1;
    vuint32_t LBESW8:1;
    vuint32_t LBESW9:1;
    vuint32_t LBESW10:1;
    vuint32_t LBESW11:1;
    vuint32_t LBESW12:1;
    vuint32_t LBESW13:1;
    vuint32_t LBESW14:1;
    vuint32_t LBESW15:1;
    vuint32_t LBESW16:1;
    vuint32_t LBESW17:1;
    vuint32_t LBESW18:1;
    vuint32_t LBESW19:1;
    vuint32_t LBESW20:1;
    vuint32_t LBESW21:1;
    vuint32_t LBESW22:1;
    vuint32_t LBESW23:1;
    vuint32_t LBESW24:1;
    vuint32_t LBESW25:1;
    vuint32_t LBESW26:1;
    vuint32_t _unused_27:5;
  } B;
} STCU2_LBESW0_tag;

typedef union STCU2_LBUFM0_union_tag { /* STCU2 LBIST Unrecoverable FM Register 0 */
  vuint32_t R;
  struct {
    vuint32_t LBUFM0:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM4:1;
    vuint32_t LBUFM5:1;
    vuint32_t LBUFM6:1;
    vuint32_t LBUFM7:1;
    vuint32_t LBUFM8:1;
    vuint32_t LBUFM9:1;
    vuint32_t LBUFM10:1;
    vuint32_t LBUFM11:1;
    vuint32_t LBUFM12:1;
    vuint32_t LBUFM13:1;
    vuint32_t LBUFM14:1;
    vuint32_t LBUFM15:1;
    vuint32_t LBUFM16:1;
    vuint32_t LBUFM17:1;
    vuint32_t LBUFM18:1;
    vuint32_t LBUFM19:1;
    vuint32_t LBUFM20:1;
    vuint32_t LBUFM21:1;
    vuint32_t LBUFM22:1;
    vuint32_t LBUFM23:1;
    vuint32_t LBUFM24:1;
    vuint32_t LBUFM25:1;
    vuint32_t LBUFM26:1;
    vuint32_t _unused_27:5;
  } B;
} STCU2_LBUFM0_tag;

typedef union STCU2_MBSSW0_union_tag { /* STCU2 On-Line MBIST Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW0:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW31:1;
  } B;
} STCU2_MBSSW0_tag;

typedef union STCU2_MBSSW1_union_tag { /* STCU2 On-Line MBIST Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW32:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW63:1;
  } B;
} STCU2_MBSSW1_tag;

typedef union STCU2_MBSSW2_union_tag { /* STCU2 On-Line MBIST Status High Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW64:1;
    vuint32_t MBSSW65:1;
    vuint32_t MBSSW66:1;
    vuint32_t MBSSW67:1;
    vuint32_t MBSSW68:1;
    vuint32_t MBSSW69:1;
    vuint32_t MBSSW70:1;
    vuint32_t MBSSW71:1;
    vuint32_t MBSSW72:1;
    vuint32_t MBSSW73:1;
    vuint32_t MBSSW74:1;
    vuint32_t MBSSW75:1;
    vuint32_t MBSSW76:1;
    vuint32_t MBSSW77:1;
    vuint32_t _unused_14:18;
  } B;
} STCU2_MBSSW2_tag;

typedef union STCU2_MBESW0_union_tag { /* STCU2 On-Line MBIST End Flag Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBESW0:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW31:1;
  } B;
} STCU2_MBESW0_tag;

typedef union STCU2_MBESW1_union_tag { /* STCU2 On-Line MBIST End Flag Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBESW32:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW63:1;
  } B;
} STCU2_MBESW1_tag;

typedef union STCU2_MBESW2_union_tag { /* STCU2 On-Line MBIST End Flag Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBESW64:1;
    vuint32_t MBESW65:1;
    vuint32_t MBESW66:1;
    vuint32_t MBESW67:1;
    vuint32_t MBESW68:1;
    vuint32_t MBESW69:1;
    vuint32_t MBESW70:1;
    vuint32_t MBESW71:1;
    vuint32_t MBESW72:1;
    vuint32_t MBESW73:1;
    vuint32_t MBESW74:1;
    vuint32_t MBESW75:1;
    vuint32_t MBESW76:1;
    vuint32_t MBESW77:1;
    vuint32_t _unused_14:18;
  } B;
} STCU2_MBESW2_tag;

typedef union STCU2_MBUFM0_union_tag { /* STCU2 MBIST Unrecoverable FM Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBUFM0:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM31:1;
  } B;
} STCU2_MBUFM0_tag;

typedef union STCU2_MBUFM1_union_tag { /* STCU2 MBIST Unrecoverable FM Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBUFM32:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM63:1;
  } B;
} STCU2_MBUFM1_tag;

typedef union STCU2_MBUFM2_union_tag { /* STCU2 MBIST Unrecoverable FM Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBUFM64:1;
    vuint32_t MBUFM65:1;
    vuint32_t MBUFM66:1;
    vuint32_t MBUFM67:1;
    vuint32_t MBUFM68:1;
    vuint32_t MBUFM69:1;
    vuint32_t MBUFM70:1;
    vuint32_t MBUFM71:1;
    vuint32_t MBUFM72:1;
    vuint32_t MBUFM73:1;
    vuint32_t MBUFM74:1;
    vuint32_t MBUFM75:1;
    vuint32_t MBUFM76:1;
    vuint32_t MBUFM77:1;
    vuint32_t _unused_14:18;
  } B;
} STCU2_MBUFM2_tag;

typedef union STCU2_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CWS:6;
    vuint32_t PFT:1;
    vuint32_t _unused_7:1;
    vuint32_t SCEN_ON:4;
    vuint32_t SCEN_OFF:4;
    vuint32_t SHS:3;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:1;
    vuint32_t PTR:10;
    vuint32_t CSM:1;
  } B;
} STCU2_LB_CTRL_tag;

typedef union STCU2_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t PCS:26;
    vuint32_t _unused_26:6;
  } B;
} STCU2_LB_PCS_tag;

typedef union STCU2_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISRELSW_tag;

typedef union STCU2_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISREHSW_tag;

typedef union STCU2_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRLSW_tag;

typedef union STCU2_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_CTRL_tag CTRL;              /* STCU2 LBIST Control Register */
  STCU2_LB_PCS_tag PCS;                /* STCU2 LBIST PC Stop Register */
  uint8_t LB_reserved0[24];
  STCU2_LB_MISRELSW_tag MISRELSW;      /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREHSW_tag MISREHSW;      /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRLSW_tag MISRRLSW;      /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRHSW_tag MISRRHSW;      /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved1[16];
} STCU2_LB_tag;

typedef union STCU2_ALGOSEL_union_tag { /* STCU2 Algorithm Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t MCMSIN:1;                /* March C- Single */
    vuint32_t MCMEX:1;                 /* March C minus 8x */
    vuint32_t MCPS:1;                  /* March C+ Single */
    vuint32_t MCPEX:1;                 /* March C+ 8x */
    vuint32_t MLRS:1;                  /* March LR single */
    vuint32_t MLREX:1;                 /* March LR 8x */
    vuint32_t MRCHMSS:1;               /* March MSS1 */
    vuint32_t BBREAD:1;                /* Back to back reads */
    vuint32_t WRCHK:1;                 /* Write checkerboard */
    vuint32_t _unused_10:1;
    vuint32_t WRINVCHK:1;              /* Write Inverted Checkerboard */
    vuint32_t _unused_12:1;
    vuint32_t BSCCHK:1;                /* Basic Check */
    vuint32_t _unused_14:16;
    vuint32_t _unused_30:1;
    vuint32_t MEMINIT:1;               /* Memory Initialisation */
  } B;
} STCU2_ALGOSEL_tag;

typedef union STCU2_STGGR_union_tag {  /* STCU2 MBIST Stagger Register */
  vuint32_t R;
  struct {
    vuint32_t STAG:32;
  } B;
} STCU2_STGGR_tag;

typedef union STCU2_BSTART_union_tag { /* STCU2 BIST Start Register */
  vuint32_t R;
  struct {
    vuint32_t BSTART:3;                /* Program BISTs */
    vuint32_t _unused_3:12;
    vuint32_t BRST:1;                  /* BISTS Reset */
    vuint32_t _unused_16:7;
    vuint32_t KSTAT:1;                 /* Keep Status */
    vuint32_t _unused_24:7;
    vuint32_t CLKEN:1;
  } B;
} STCU2_BSTART_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:20;
    vuint32_t BSEL:1;
    vuint32_t PTR:10;
    vuint32_t CSM:1;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  uint8_t STCU2_reserved0[4];
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  uint8_t STCU2_reserved1[4];
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  uint8_t STCU2_reserved2[12];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  uint8_t STCU2_reserved3[16];
  STCU2_LBSSW0_tag LBSSW0;             /* STCU2 On-Line LBIST Status Register 0 */
  uint8_t STCU2_reserved4[4];
  STCU2_LBESW0_tag LBESW0;             /* STCU2 On-Line LBIST End Flag Register 0 */
  uint8_t STCU2_reserved5[12];
  STCU2_LBUFM0_tag LBUFM0;             /* STCU2 LBIST Unrecoverable FM Register 0 */
  uint8_t STCU2_reserved6[132];
  STCU2_MBSSW0_tag MBSSW0;             /* STCU2 On-Line MBIST Status Register 0 */
  STCU2_MBSSW1_tag MBSSW1;             /* STCU2 On-Line MBIST Status Register 1 */
  STCU2_MBSSW2_tag MBSSW2;             /* STCU2 On-Line MBIST Status High Register 2 */
  uint8_t STCU2_reserved7[52];
  STCU2_MBESW0_tag MBESW0;             /* STCU2 On-Line MBIST End Flag Register 0 */
  STCU2_MBESW1_tag MBESW1;             /* STCU2 On-Line MBIST End Flag Register 1 */
  STCU2_MBESW2_tag MBESW2;             /* STCU2 On-Line MBIST End Flag Register 2 */
  uint8_t STCU2_reserved8[52];
  STCU2_MBUFM0_tag MBUFM0;             /* STCU2 MBIST Unrecoverable FM Register 0 */
  STCU2_MBUFM1_tag MBUFM1;             /* STCU2 MBIST Unrecoverable FM Register 1 */
  STCU2_MBUFM2_tag MBUFM2;             /* STCU2 MBIST Unrecoverable FM Register 2 */
  uint8_t STCU2_reserved9[152];
  STCU2_LB_tag LB[27];
  uint8_t STCU2_reserved10[2368];
  STCU2_ALGOSEL_tag ALGOSEL;           /* STCU2 Algorithm Select Register */
  uint8_t STCU2_reserved11[8];
  STCU2_STGGR_tag STGGR;               /* STCU2 MBIST Stagger Register */
  STCU2_BSTART_tag BSTART;             /* STCU2 BIST Start Register */
  STCU2_MB_CTRL_tag MB_CTRL[78];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t _unused_2:6;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_16:16;
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CEN:1;                   /* Channel Enable */
    vuint32_t _unused_1:31;
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;                   /* Watchdog Enabled */
    vuint32_t FRZ:1;                   /* Debug Mode Control */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t SLK:1;                   /* Soft Lock */
    vuint32_t HLK:1;                   /* Hard Lock */
    vuint32_t ITR:1;                   /* Interrupt Then Reset Request */
    vuint32_t WND:1;                   /* Window Mode */
    vuint32_t RIA:1;                   /* Reset on Invalid Access */
    vuint32_t SMD:2;                   /* Service Mode */
    vuint32_t _unused_11:13;
    vuint32_t MAP7:1;
    vuint32_t MAP6:1;
    vuint32_t MAP5:1;
    vuint32_t MAP4:1;
    vuint32_t MAP3:1;
    vuint32_t MAP2:1;
    vuint32_t MAP1:1;
    vuint32_t MAP0:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t WSC:16;                  /* Watchdog Service Code */
    vuint32_t _unused_16:16;
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Watchdog Count */
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t SK:16;                   /* Service Key */
    vuint32_t _unused_16:16;
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: TMU ================================
   ============================================================================ */

typedef union TMU_MR_union_tag {       /* Mode Register */
  vuint32_t R;
  struct {
    vuint32_t MSITE:16;
    vuint32_t _unused_16:10;
    vuint32_t ALPF:2;
    vuint32_t _unused_28:2;
    vuint32_t _unused_30:1;
    vuint32_t ME:1;
  } B;
} TMU_MR_tag;

typedef union TMU_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:28;
    vuint32_t ORH:1;
    vuint32_t ORL:1;
    vuint32_t MIE:1;
    vuint32_t _unused_31:1;
  } B;
} TMU_SR_tag;

typedef union TMU_MTMIR_union_tag {    /* Monitor Temperature Measurement Interval Register */
  vuint32_t R;
  struct {
    vuint32_t TMI:4;                   /* Temperature monitoring interval in seconds */
    vuint32_t _unused_4:28;
  } B;
} TMU_MTMIR_tag;

typedef union TMU_IER_union_tag {      /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t ATCTEIE:1;
    vuint32_t ATTEIE:1;
    vuint32_t ITTEIE:1;
  } B;
} TMU_IER_tag;

typedef union TMU_IDR_union_tag {      /* Interrupt Detect Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t ATCTE:1;
    vuint32_t ATTE:1;
    vuint32_t ITTE:1;
  } B;
} TMU_IDR_tag;

typedef union TMU_MHTCR_union_tag {    /* Monitor High Temperature Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t V:1;
  } B;
} TMU_MHTCR_tag;

typedef union TMU_MLTCR_union_tag {    /* Monitor Low Temperature Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t V:1;
  } B;
} TMU_MLTCR_tag;

typedef union TMU_MHTITR_union_tag {   /* Monitor High Temperature Immediate Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t EN:1;
  } B;
} TMU_MHTITR_tag;

typedef union TMU_MHTATR_union_tag {   /* Monitor High Temperature Average Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t EN:1;
  } B;
} TMU_MHTATR_tag;

typedef union TMU_MHTACTR_union_tag {  /* Monitor High Temperature Average Critical Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t EN:1;
  } B;
} TMU_MHTACTR_tag;

typedef union TMU_TCFGR_union_tag {    /* Temperature Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t Data0:4;
    vuint32_t _unused_4:12;
    vuint32_t Data1:3;
    vuint32_t _unused_19:13;
  } B;
} TMU_TCFGR_tag;

typedef union TMU_SCFGR_union_tag {    /* Sensor Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SENSOR:7;
    vuint32_t _unused_7:25;
  } B;
} TMU_SCFGR_tag;

typedef union TMU_RITSR_union_tag {    /* Report Immediate Temperature Site Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t V:1;
  } B;
} TMU_RITSR_tag;

typedef union TMU_RATSR_union_tag {    /* Report Average Temperature Site Register */
  vuint32_t R;
  struct {
    vuint32_t TEMP:8;
    vuint32_t _unused_8:23;
    vuint32_t V:1;
  } B;
} TMU_RATSR_tag;

typedef union TMU_EUMR_union_tag {     /* Engineering Use Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:21;
    vuint32_t BG_CAL:2;                /* Bandgap Calibration */
    vuint32_t _unused_23:9;
  } B;
} TMU_EUMR_tag;

struct TMU_tag {
  TMU_MR_tag MR;                       /* Mode Register */
  TMU_SR_tag SR;                       /* Status Register */
  TMU_MTMIR_tag MTMIR;                 /* Monitor Temperature Measurement Interval Register */
  uint8_t TMU_reserved0[20];
  TMU_IER_tag IER;                     /* Interrupt Enable Register */
  TMU_IDR_tag IDR;                     /* Interrupt Detect Register */
  uint8_t TMU_reserved1[24];
  TMU_MHTCR_tag MHTCR;                 /* Monitor High Temperature Capture Register */
  TMU_MLTCR_tag MLTCR;                 /* Monitor Low Temperature Capture Register */
  uint8_t TMU_reserved2[8];
  TMU_MHTITR_tag MHTITR;               /* Monitor High Temperature Immediate Threshold Register */
  TMU_MHTATR_tag MHTATR;               /* Monitor High Temperature Average Threshold Register */
  TMU_MHTACTR_tag MHTACTR;             /* Monitor High Temperature Average Critical Threshold Register */
  uint8_t TMU_reserved3[36];
  TMU_TCFGR_tag TCFGR;                 /* Temperature Configuration Register */
  TMU_SCFGR_tag SCFGR;                 /* Sensor Configuration Register */
  uint8_t TMU_reserved4[120];
  TMU_RITSR_tag RITSR;                 /* Report Immediate Temperature Site Register */
  TMU_RATSR_tag RATSR;                 /* Report Average Temperature Site Register */
  uint8_t TMU_reserved5[3576];
  TMU_EUMR_tag EUMR;                   /* Engineering Use Mode Register */
};


/* ============================================================================
   =============================== Module: VIULite ============================
   ============================================================================ */

typedef union VIULite_SCR_union_tag {  /* Status And Control Register */
  vuint32_t R;
  struct {
    vuint32_t SOFT_RESET:1;
    vuint32_t LENDIAN:1;
    vuint32_t ECC_EN:1;
    vuint32_t _unused_3:1;
    vuint32_t HSYNC_POL:1;
    vuint32_t VSYNC_POL:1;
    vuint32_t PCLK_POL:1;
    vuint32_t _unused_7:1;
    vuint32_t INPUT_WIDTH:3;
    vuint32_t CPP:2;
    vuint32_t ITU_MODE:1;
    vuint32_t _unused_14:13;
    vuint32_t DMA_ACT:1;
    vuint32_t FIELD_NO:1;
    vuint32_t HSYNC:1;
    vuint32_t VSYNC:1;
    vuint32_t _unused_31:1;
  } B;
} VIULite_SCR_tag;

typedef union VIULite_INTR_union_tag { /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t FIELD_EN:1;
    vuint32_t VSYNC_EN:1;
    vuint32_t HSYNC_EN:1;
    vuint32_t VSTART_EN:1;
    vuint32_t DMA_END_EN:1;
    vuint32_t ERROR_EN:1;
    vuint32_t LINE_END_EN:1;
    vuint32_t FRAME_END_EN:1;
    vuint32_t _unused_8:8;
    vuint32_t FIELD_IRQ:1;
    vuint32_t VSYNC_IRQ:1;
    vuint32_t HSYNC_IRQ:1;
    vuint32_t VSTART_IRQ:1;
    vuint32_t DMA_END_IRQ:1;
    vuint32_t ERROR_IRQ:1;
    vuint32_t LINE_END_IRQ:1;
    vuint32_t FRAME_END_IRQ:1;
    vuint32_t _unused_24:4;
    vuint32_t ERROR_CODE:4;
  } B;
} VIULite_INTR_tag;

typedef union VIULite_DINVSZ_union_tag { /* Detected Input Video Pixel and Line Count */
  vuint32_t R;
  struct {
    vuint32_t DETECTED_PIX_ELC:16;
    vuint32_t DETECTED_LINEC:16;
  } B;
} VIULite_DINVSZ_tag;

typedef union VIULite_DINVFL_union_tag { /* Detected Input Video Frame Length */
  vuint32_t R;
  struct {
    vuint32_t DETECTED_FRAME_WIDTH:16;
    vuint32_t DETECTED_FRAME_HEIGHT:16;
  } B;
} VIULite_DINVFL_tag;

typedef union VIULite_DMA_SIZE_union_tag { /* DMA Size Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_SIZE:16;             /* DMA size register */
    vuint32_t _unused_16:16;
  } B;
} VIULite_DMA_SIZE_tag;

typedef union VIULite_DMA_ADDR_union_tag { /* Base Address Of Every Field/Frame Of Picture In Memory */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} VIULite_DMA_ADDR_tag;

typedef union VIULite_DMA_INC_union_tag { /* Horizontal DMA Increment */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t INC:13;
    vuint32_t _unused_16:16;
  } B;
} VIULite_DMA_INC_tag;

typedef union VIULite_INVSZ_union_tag { /* Input Video Pixel and Line Count */
  vuint32_t R;
  struct {
    vuint32_t PIXELC:16;
    vuint32_t LINEC:16;
  } B;
} VIULite_INVSZ_tag;

typedef union VIULite_ALPHA_union_tag { /* Programable Alpha Value */
  vuint32_t R;
  struct {
    vuint32_t ALPHA:8;
    vuint32_t _unused_8:24;
  } B;
} VIULite_ALPHA_tag;

typedef union VIULite_ACT_ORG_union_tag { /* Active Image Original Coordinate */
  vuint32_t R;
  struct {
    vuint32_t ACT_ORG_X:16;
    vuint32_t ACT_ORG_Y:16;
  } B;
} VIULite_ACT_ORG_tag;

typedef union VIULite_ACT_SIZE_union_tag { /* Active Image Size */
  vuint32_t R;
  struct {
    vuint32_t ACT_IMG_WIDTH:16;
    vuint32_t ACT_IMG_HEIGHT:16;
  } B;
} VIULite_ACT_SIZE_tag;

struct VIULite_tag {
  VIULite_SCR_tag SCR;                 /* Status And Control Register */
  VIULite_INTR_tag INTR;               /* Interrupt Register */
  VIULite_DINVSZ_tag DINVSZ;           /* Detected Input Video Pixel and Line Count */
  VIULite_DINVFL_tag DINVFL;           /* Detected Input Video Frame Length */
  VIULite_DMA_SIZE_tag DMA_SIZE;       /* DMA Size Register */
  VIULite_DMA_ADDR_tag DMA_ADDR;       /* Base Address Of Every Field/Frame Of Picture In Memory */
  VIULite_DMA_INC_tag DMA_INC;         /* Horizontal DMA Increment */
  VIULite_INVSZ_tag INVSZ;             /* Input Video Pixel and Line Count */
  uint8_t VIULite_reserved0[4];
  VIULite_ALPHA_tag ALPHA;             /* Programable Alpha Value */
  VIULite_ACT_ORG_tag ACT_ORG;         /* Active Image Original Coordinate */
  VIULite_ACT_SIZE_tag ACT_SIZE;       /* Active Image Size */
};


/* ============================================================================
   =============================== Module: VSEQ_CTRL_BLK ======================
   ============================================================================ */

typedef union VSEQ_CTRL_BLK_CLKRST_union_tag { /* Clock and Reset control register */
  vuint32_t R;
  struct {
    vuint32_t SEQ_INT_RESET:1;         /* Sequencer internal logic reset */
    vuint32_t CM0p_RESET:1;            /* Sequencer core reset */
    vuint32_t _unused_2:15;
    vuint32_t CM0p_CLK_EN:1;           /* Sequencer core clock enable */
    vuint32_t _unused_18:14;
  } B;
} VSEQ_CTRL_BLK_CLKRST_tag;

typedef union VSEQ_CTRL_BLK_MSGCTRL_union_tag { /* Messaging control and status register */
  vuint32_t R;
  struct {
    vuint32_t OUTBOUND_MSG_RDY:1;      /* Sequencer outbound message ready (IRQ to Host) */
    vuint32_t OUTBOUND_MSG_ACKED:1;    /* Sequencer outbound message interrupt acknowledge (IRQ to Cortex-M0+) */
    vuint32_t _unused_2:14;
    vuint32_t INBOUND_MSG_RDY:1;       /* Sequencer inbound message ready (IRQ to Cortex-M0+) */
    vuint32_t INBOUND_MSG_ACKED:1;     /* Sequencer inbound message interrupt acknowledge (IRQ to Host) */
    vuint32_t _unused_18:14;
  } B;
} VSEQ_CTRL_BLK_MSGCTRL_tag;

typedef union VSEQ_CTRL_BLK_OUTMSG_ADDR_union_tag { /* Sequencer outbound message addres/offset */
  vuint32_t R;
  struct {
    vuint32_t OUTBOUND_MSG_ADDR:32;    /* Sequencer core to Host CPU outbound message address/offset */
  } B;
} VSEQ_CTRL_BLK_OUTMSG_ADDR_tag;

typedef union VSEQ_CTRL_BLK_OUTMSG_LEN_union_tag { /* Sequencer outbound message length */
  vuint32_t R;
  struct {
    vuint32_t OUTBOUND_MSG_LEN:12;     /* Sequencer outbound message length */
    vuint32_t _unused_12:20;
  } B;
} VSEQ_CTRL_BLK_OUTMSG_LEN_tag;

typedef union VSEQ_CTRL_BLK_INMSG_ADDR_union_tag { /* Sequencer inbound message address/offset */
  vuint32_t R;
  struct {
    vuint32_t INBOUND_MSG_ADDR:32;     /* Sequencer Inbound message address/offset */
  } B;
} VSEQ_CTRL_BLK_INMSG_ADDR_tag;

typedef union VSEQ_CTRL_BLK_INMSG_LEN_union_tag { /* Sequencer inbound message length */
  vuint32_t R;
  struct {
    vuint32_t INBOUND_MSG_LEN:12;      /* Sequencer Inbound message address offset */
    vuint32_t _unused_12:20;
  } B;
} VSEQ_CTRL_BLK_INMSG_LEN_tag;

typedef union VSEQ_CTRL_BLK_ERRSTAT_union_tag { /* Internal error status register */
  vuint32_t R;
  struct {
    vuint32_t OUTBOUND_MSG_CFG_ERR:1;  /* Outbound message configuration error */
    vuint32_t INBOUND_MSG_CFG_ERR:1;   /* Inbound message configuration error */
    vuint32_t _unused_2:14;
    vuint32_t SEQ_MEM_PERR:1;          /* CRAM/PRAM Parity error status bit */
    vuint32_t _unused_17:15;
  } B;
} VSEQ_CTRL_BLK_ERRSTAT_tag;

typedef union VSEQ_CTRL_BLK_SEQ_CORE_IRQ_EN_union_tag { /* Sequencer (Cortex-M0+) interrupts enable register */
  vuint32_t R;
  struct {
    vuint32_t SEQ_INT_ERR_IRQ_EN:1;    /* Sequencer internal error interrupt enable */
    vuint32_t IDMA_DONE_IRQ_EN:1;      /* Sequencer Internal-DMA Transfer Done interrupt enable */
    vuint32_t INMSG_RDY_IRQ_EN:1;      /* Inbound Message Ready Interrupt enable */
    vuint32_t OUTMSG_ACK_IRQ_EN:1;     /* Outbound Message Acknowledged Interrupt enable */
    vuint32_t IPUS_EVT_DONE_IRQ_EN:1;  /* IPUS Event Counter DONE interrupt enable */
    vuint32_t IPUV_EVT_DONE_IRQ_EN:1;  /* IPUV Event Counter DONE interrupt enable */
    vuint32_t OTHR_EVT_DONE_IRQ_EN:1;  /* OTHER Event Counter DONE interrupt enable */
    vuint32_t SW_EVT_DONE_IRQ_EN:1;    /* Software Event Done interrupt enable */
    vuint32_t FDMA_ERR_IRQ_EN:1;       /* FastDMA Error interrupt enable */
    vuint32_t _unused_9:23;
  } B;
} VSEQ_CTRL_BLK_SEQ_CORE_IRQ_EN_tag;

typedef union VSEQ_CTRL_BLK_HOST_IRQ_EN_union_tag { /* Host interrupts enable register */
  vuint32_t R;
  struct {
    vuint32_t SEQ_INT_ERR_IRQ_EN:1;    /* Sequencer internal error interrupt enable */
    vuint32_t IDMA_DONE_IRQ_EN:1;      /* Sequencer Internal-DMA Transfer Done Interrupt enable */
    vuint32_t OUTMSG_RDY_IRQ_EN:1;     /* Outbound Message Ready Interrupt enable */
    vuint32_t INMSG_ACK_IRQ_EN:1;      /* Inbound Message Acknowledged Interrupt enable */
    vuint32_t IPUS_EVT_DONE_IRQ_EN:1;  /* IPUS Event Counter DONE interrupt enable */
    vuint32_t IPUV_EVT_DONE_IRQ_EN:1;  /* IPUV Event Counter DONE interrupt enable */
    vuint32_t OTHR_EVT_DONE_IRQ_EN:1;  /* OTHER Event Counter DONE interrupt enable */
    vuint32_t _unused_7:1;
    vuint32_t SEQ_MEM_PERR_IRQ_EN:1;   /* Parity Error interrupt enable */
    vuint32_t _unused_9:7;
    vuint32_t SW_EVT_TRIG_EN:8;        /* Software Events Trigger (interrupt) enable */
    vuint32_t _unused_24:8;
  } B;
} VSEQ_CTRL_BLK_HOST_IRQ_EN_tag;

typedef union VSEQ_CTRL_BLK_PTYCTRL_union_tag { /* AHB Master priority control register */
  vuint32_t R;
  struct {
    vuint32_t XBAR_PTY:1;              /* Crossbar AHB-master priority control */
    vuint32_t _unused_1:31;
  } B;
} VSEQ_CTRL_BLK_PTYCTRL_tag;

struct VSEQ_CTRL_BLK_tag {
  VSEQ_CTRL_BLK_CLKRST_tag CLKRST;     /* Clock and Reset control register */
  VSEQ_CTRL_BLK_MSGCTRL_tag MSGCTRL;   /* Messaging control and status register */
  VSEQ_CTRL_BLK_OUTMSG_ADDR_tag OUTMSG_ADDR; /* Sequencer outbound message addres/offset */
  VSEQ_CTRL_BLK_OUTMSG_LEN_tag OUTMSG_LEN; /* Sequencer outbound message length */
  VSEQ_CTRL_BLK_INMSG_ADDR_tag INMSG_ADDR; /* Sequencer inbound message address/offset */
  VSEQ_CTRL_BLK_INMSG_LEN_tag INMSG_LEN; /* Sequencer inbound message length */
  VSEQ_CTRL_BLK_ERRSTAT_tag ERRSTAT;   /* Internal error status register */
  VSEQ_CTRL_BLK_SEQ_CORE_IRQ_EN_tag SEQ_CORE_IRQ_EN; /* Sequencer (Cortex-M0+) interrupts enable register */
  VSEQ_CTRL_BLK_HOST_IRQ_EN_tag HOST_IRQ_EN; /* Host interrupts enable register */
  VSEQ_CTRL_BLK_PTYCTRL_tag PTYCTRL;   /* AHB Master priority control register */
};


/* ============================================================================
   =============================== Module: VSEQ_EVT_CTRL ======================
   ============================================================================ */

typedef union VSEQ_EVT_CTRL_DONE_ENGN_TYPE_union_tag { /* Done Event Status of various types of Engines */
  vuint32_t R;
  struct {
    vuint32_t DONE_IPUS_ENGN:1;        /* Done status of IPUS engines */
    vuint32_t DONE_IPUV_ENGN:1;        /* Done status of IPUV engines */
    vuint32_t DONE_OTHR_ENGN:1;        /* Done status of Other/Misc. engines */
    vuint32_t _unused_3:29;
  } B;
} VSEQ_EVT_CTRL_DONE_ENGN_TYPE_tag;

typedef union VSEQ_EVT_CTRL_IPUS_CNTR_MAX_VAL_union_tag { /* Maximum value of IPUS Event counters */
  vuint32_t R;
  struct {
    vuint32_t IPUS_CNTR_MAX_VAL:4;     /* Maximum value of IPUS Event counters */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUS_CNTR_MAX_VAL_tag;

typedef union VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_ENC_union_tag { /* 'Clear event' command Register for binary encoded IPUS Event counter */
  vuint32_t R;
  struct {
    vuint32_t IPUS_CNTR_CLREVT_ENC:6;  /* 'Clear event' command for binary encoded IPUS Event counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_union_tag { /* 'Clear event' command Register for bit-selected IPUS Event counters */
  vuint32_t R;
  struct {
    vuint32_t IPUS_CNTR_CLREVT:8;      /* 'Clear event' command for bit-selected IPUS Event counter(s) */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_tag;

typedef union VSEQ_EVT_CTRL_IPUS_CNTR_NXTEVT_union_tag { /* 'Next event' or Done-event status reported by FF1 logic */
  vuint32_t R;
  struct {
    vuint32_t IPUS_CNTR_NXTEVT:6;      /* 'Next event' or Done-event status reported by FF1 logic */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUS_CNTR_NXTEVT_tag;

typedef union VSEQ_EVT_CTRL_IPUS_CNTR_ALLEVT_union_tag { /* Done-event status reported by each IPUS Event Counter */
  vuint32_t R;
  struct {
    vuint32_t IPUS_CNTR_ALLEVT:8;      /* Done-event status reported by each IPUS Event Counter */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_CNTR_ALLEVT_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_ENC_union_tag { /* Trigger command Register for binary encoded IPUS Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_TRIG_ENC:6;    /* Trigger command for binary encoded IPUS Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_union_tag { /* Trigger command Register for bit-selected IPUS Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_TRIG:8;        /* Trigger command for bit-selected IPUS Free-Engine counters */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_FREE_ENC_union_tag { /* Free-up command Register for binary encoded IPUS Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_FREE_ENC:6;    /* Free-up command for binary encoded IPUS Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_FREE_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_FREE_union_tag { /* Free-up command Register for bit-selected IPUS Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_FREE:8;        /* Free-up command for bit-selected IPUS Free-Engine counters */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_FREE_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_USBL_union_tag { /* Register to indicate IPUS Engines usable by current task */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_USBL:8;        /* IPUS Engines usable by current task */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_USBL_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_FF1_union_tag { /* Available Free IPUS Engine and Engine with a Free buffer indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_FF1_AVL:6;     /* Available Free IPUS Engine indicator */
    vuint32_t _unused_6:10;
    vuint32_t IPUS_ENGN_FF1_BUF_AVL:6; /* Available IPUS Engine with atleast one Free buffer */
    vuint32_t _unused_22:10;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_FF1_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_AVL_union_tag { /* All available Free IPUS Engines indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_AVL:8;         /* All available Free IPUS Engines indicator */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_AVL_tag;

typedef union VSEQ_EVT_CTRL_IPUS_ENGN_BUF_AVL_union_tag { /* All available IPUS Engines with atleast one Free Buffer indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUS_ENGN_BUF_AVL:8;     /* All available IPUS Engines with atleast one Free Buffer indicator */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_IPUS_ENGN_BUF_AVL_tag;

typedef union VSEQ_EVT_CTRL_IPUV_CNTR_MAX_VAL_union_tag { /* Maximum value of IPUV Event counters */
  vuint32_t R;
  struct {
    vuint32_t IPUV_CNTR_MAX_VAL:4;     /* Maximum value of IPUV Event counters */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_CNTR_MAX_VAL_tag;

typedef union VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_ENC_union_tag { /* 'Clear event' command Register for binary encoded IPUV Event counter */
  vuint32_t R;
  struct {
    vuint32_t IPUV_CNTR_CLREVT_ENC:6;  /* 'Clear event' command for binary encoded IPUV Event counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_union_tag { /* 'Clear event' command Register for bit-selected IPUV Event counters */
  vuint32_t R;
  struct {
    vuint32_t IPUV_CNTR_CLREVT:4;      /* 'Clear event' command for bit-selected IPUV Event counter(s) */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_tag;

typedef union VSEQ_EVT_CTRL_IPUV_CNTR_NXTEVT_union_tag { /* 'Next event' or Done-event status reported by FF1 logic */
  vuint32_t R;
  struct {
    vuint32_t IPUV_CNTR_NXTEVT:6;      /* 'Next event' or Done-event status reported by FF1 logic */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUV_CNTR_NXTEVT_tag;

typedef union VSEQ_EVT_CTRL_IPUV_CNTR_ALLEVT_union_tag { /* Done-event status reported by each IPUV Event Counter */
  vuint32_t R;
  struct {
    vuint32_t IPUV_CNTR_ALLEVT:4;      /* Done-event status reported by each IPUV Event Counter */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_CNTR_ALLEVT_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_ENC_union_tag { /* Trigger command Register for binary encoded IPUV Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_TRIG_ENC:6;    /* Trigger command for binary encoded IPUV Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_union_tag { /* Trigger command Register for bit-selected IPUV Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_TRIG:4;        /* Trigger command for bit-selected IPUV Free-Engine counters */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_FREE_ENC_union_tag { /* Free-up command Register for binary encoded IPUV Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_FREE_ENC:6;    /* Free-up command for binary encoded IPUV Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_FREE_ENC_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_FREE_union_tag { /* Free-up command Register for bit-selected IPUV Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_FREE:4;        /* Free-up command for bit-selected IPUV Free-Engine counters */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_FREE_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_USBL_union_tag { /* Register to indicate IPUV Engines usable by current task */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_USBL:4;        /* IPUV Engines usable by current task */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_USBL_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_FF1_union_tag { /* Available Free IPUV Engine and Engine with a Free buffer indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_FF1_AVL:6;     /* Available Free IPUV Engine indicator */
    vuint32_t _unused_6:10;
    vuint32_t IPUV_ENGN_FF1_BUF_AVL:6; /* Available IPUV Engine with atleast one Free buffer */
    vuint32_t _unused_22:10;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_FF1_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_AVL_union_tag { /* All available Free IPUV Engines indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_AVL:4;         /* All available Free IPUV Engines indicator */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_AVL_tag;

typedef union VSEQ_EVT_CTRL_IPUV_ENGN_BUF_AVL_union_tag { /* All available IPUV Engines with atleast one Free Buffer indicator */
  vuint32_t R;
  struct {
    vuint32_t IPUV_ENGN_BUF_AVL:4;     /* All available IPUV Engines with atleast one Free Buffer indicator */
    vuint32_t _unused_4:28;
  } B;
} VSEQ_EVT_CTRL_IPUV_ENGN_BUF_AVL_tag;

typedef union VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_ENC_union_tag { /* 'Clear event' command Register for binary encoded Other/Misc Event counter */
  vuint32_t R;
  struct {
    vuint32_t OTHR_CNTR_CLREVT_ENC:6;  /* 'Clear event' command for binary encoded Other/Misc Event counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_ENC_tag;

typedef union VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_union_tag { /* 'Clear event' command Register for bit-selected Other/Misc Event counters */
  vuint32_t R;
  struct {
    vuint32_t OTHR_CNTR_CLREVT:26;     /* 'Clear event' command for bit-selected Other/Misc Event counter(s) */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_tag;

typedef union VSEQ_EVT_CTRL_OTHR_CNTR_ALLEVT_union_tag { /* Done-event status reported by each Other/Misc Event Counter */
  vuint32_t R;
  struct {
    vuint32_t OTHR_CNTR_ALLEVT:26;     /* Done-event status reported by each Other/Misc Event Counter */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_CNTR_ALLEVT_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_ENC_union_tag { /* Trigger command Register for binary encoded Other/Misc Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_TRIG_ENC:6;    /* Trigger command for binary encoded Other/Misc Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_ENC_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_union_tag { /* Trigger command Register for bit-selected Other/Misc Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_TRIG:26;       /* Trigger command for bit-selected Other/Misc Free-Engine counters */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_FREE_ENC_union_tag { /* Free-up command Register for binary encoded Other/Misc Free-Engine counter */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_FREE_ENC:6;    /* Free-up command for binary encoded Other/Misc Free-Engine counter */
    vuint32_t _unused_6:26;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_FREE_ENC_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_FREE_union_tag { /* Free-up command Register for bit-selected Other/Misc Free-Engine counters */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_FREE:26;       /* Free-up command for bit-selected Other/Misc Free-Engine counters */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_FREE_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_AVL_union_tag { /* All available Free Other/Misc Engines indicator */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_AVL:26;        /* All available Free Other/Misc Engines indicator */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_AVL_tag;

typedef union VSEQ_EVT_CTRL_OTHR_ENGN_BUF_AVL_union_tag { /* All available Other/Misc Engines with atleast one Free Buffer indicator */
  vuint32_t R;
  struct {
    vuint32_t OTHR_ENGN_BUF_AVL:26;    /* All available Other/Misc Engines with atleast one Free Buffer indicator */
    vuint32_t _unused_26:6;
  } B;
} VSEQ_EVT_CTRL_OTHR_ENGN_BUF_AVL_tag;

typedef union VSEQ_EVT_CTRL_OTHR0_CNTR_MAX_VAL_union_tag { /* Maximum value of Event Counter for Other Engine-0 */
  vuint32_t R;
  struct {
    vuint32_t OTHR0_CNTR_MAX_VAL:5;    /* Maximum value of Event counter for Other Engine-0 */
    vuint32_t _unused_5:27;
  } B;
} VSEQ_EVT_CTRL_OTHR0_CNTR_MAX_VAL_tag;

typedef union VSEQ_EVT_CTRL_SW_EVT_TRIG_union_tag { /* Software Defined Event Triggers (Interrupts) assert control */
  vuint32_t R;
  struct {
    vuint32_t SW_EVT_TRIG:8;           /* Software Defined Event Trigger (Interrupt) assert control */
    vuint32_t _unused_8:24;
  } B;
} VSEQ_EVT_CTRL_SW_EVT_TRIG_tag;

typedef union VSEQ_EVT_CTRL_SW_EVT_CLR_DONE_union_tag { /* Software Defined Event Triggers (Interrupts) to Host CPU */
  vuint32_t R;
  struct {
    vuint32_t SW_EVT_CLR:8;            /* Software Defined Event Trigger (Interrupt) deassert control */
    vuint32_t _unused_8:8;
    vuint32_t SW_EVT_DONE:1;           /* Software Defined Event Trigger (Interrupt) Done/Acknowledge Status bit */
    vuint32_t _unused_17:15;
  } B;
} VSEQ_EVT_CTRL_SW_EVT_CLR_DONE_tag;

struct VSEQ_EVT_CTRL_tag {
  VSEQ_EVT_CTRL_DONE_ENGN_TYPE_tag DONE_ENGN_TYPE; /* Done Event Status of various types of Engines */
  VSEQ_EVT_CTRL_IPUS_CNTR_MAX_VAL_tag IPUS_CNTR_MAX_VAL; /* Maximum value of IPUS Event counters */
  VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_ENC_tag IPUS_CNTR_CLREVT_ENC; /* 'Clear event' command Register for binary encoded IPUS Event counter */
  VSEQ_EVT_CTRL_IPUS_CNTR_CLREVT_tag IPUS_CNTR_CLREVT; /* 'Clear event' command Register for bit-selected IPUS Event counters */
  VSEQ_EVT_CTRL_IPUS_CNTR_NXTEVT_tag IPUS_CNTR_NXTEVT; /* 'Next event' or Done-event status reported by FF1 logic */
  VSEQ_EVT_CTRL_IPUS_CNTR_ALLEVT_tag IPUS_CNTR_ALLEVT; /* Done-event status reported by each IPUS Event Counter */
  VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_ENC_tag IPUS_ENGN_TRIG_ENC; /* Trigger command Register for binary encoded IPUS Free-Engine counter */
  VSEQ_EVT_CTRL_IPUS_ENGN_TRIG_tag IPUS_ENGN_TRIG; /* Trigger command Register for bit-selected IPUS Free-Engine counters */
  VSEQ_EVT_CTRL_IPUS_ENGN_FREE_ENC_tag IPUS_ENGN_FREE_ENC; /* Free-up command Register for binary encoded IPUS Free-Engine counter */
  VSEQ_EVT_CTRL_IPUS_ENGN_FREE_tag IPUS_ENGN_FREE; /* Free-up command Register for bit-selected IPUS Free-Engine counters */
  VSEQ_EVT_CTRL_IPUS_ENGN_USBL_tag IPUS_ENGN_USBL; /* Register to indicate IPUS Engines usable by current task */
  VSEQ_EVT_CTRL_IPUS_ENGN_FF1_tag IPUS_ENGN_FF1; /* Available Free IPUS Engine and Engine with a Free buffer indicator */
  VSEQ_EVT_CTRL_IPUS_ENGN_AVL_tag IPUS_ENGN_AVL; /* All available Free IPUS Engines indicator */
  VSEQ_EVT_CTRL_IPUS_ENGN_BUF_AVL_tag IPUS_ENGN_BUF_AVL; /* All available IPUS Engines with atleast one Free Buffer indicator */
  VSEQ_EVT_CTRL_IPUV_CNTR_MAX_VAL_tag IPUV_CNTR_MAX_VAL; /* Maximum value of IPUV Event counters */
  VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_ENC_tag IPUV_CNTR_CLREVT_ENC; /* 'Clear event' command Register for binary encoded IPUV Event counter */
  VSEQ_EVT_CTRL_IPUV_CNTR_CLREVT_tag IPUV_CNTR_CLREVT; /* 'Clear event' command Register for bit-selected IPUV Event counters */
  VSEQ_EVT_CTRL_IPUV_CNTR_NXTEVT_tag IPUV_CNTR_NXTEVT; /* 'Next event' or Done-event status reported by FF1 logic */
  VSEQ_EVT_CTRL_IPUV_CNTR_ALLEVT_tag IPUV_CNTR_ALLEVT; /* Done-event status reported by each IPUV Event Counter */
  VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_ENC_tag IPUV_ENGN_TRIG_ENC; /* Trigger command Register for binary encoded IPUV Free-Engine counter */
  VSEQ_EVT_CTRL_IPUV_ENGN_TRIG_tag IPUV_ENGN_TRIG; /* Trigger command Register for bit-selected IPUV Free-Engine counters */
  VSEQ_EVT_CTRL_IPUV_ENGN_FREE_ENC_tag IPUV_ENGN_FREE_ENC; /* Free-up command Register for binary encoded IPUV Free-Engine counter */
  VSEQ_EVT_CTRL_IPUV_ENGN_FREE_tag IPUV_ENGN_FREE; /* Free-up command Register for bit-selected IPUV Free-Engine counters */
  VSEQ_EVT_CTRL_IPUV_ENGN_USBL_tag IPUV_ENGN_USBL; /* Register to indicate IPUV Engines usable by current task */
  VSEQ_EVT_CTRL_IPUV_ENGN_FF1_tag IPUV_ENGN_FF1; /* Available Free IPUV Engine and Engine with a Free buffer indicator */
  VSEQ_EVT_CTRL_IPUV_ENGN_AVL_tag IPUV_ENGN_AVL; /* All available Free IPUV Engines indicator */
  VSEQ_EVT_CTRL_IPUV_ENGN_BUF_AVL_tag IPUV_ENGN_BUF_AVL; /* All available IPUV Engines with atleast one Free Buffer indicator */
  VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_ENC_tag OTHR_CNTR_CLREVT_ENC; /* 'Clear event' command Register for binary encoded Other/Misc Event counter */
  VSEQ_EVT_CTRL_OTHR_CNTR_CLREVT_tag OTHR_CNTR_CLREVT; /* 'Clear event' command Register for bit-selected Other/Misc Event counters */
  VSEQ_EVT_CTRL_OTHR_CNTR_ALLEVT_tag OTHR_CNTR_ALLEVT; /* Done-event status reported by each Other/Misc Event Counter */
  VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_ENC_tag OTHR_ENGN_TRIG_ENC; /* Trigger command Register for binary encoded Other/Misc Free-Engine counter */
  VSEQ_EVT_CTRL_OTHR_ENGN_TRIG_tag OTHR_ENGN_TRIG; /* Trigger command Register for bit-selected Other/Misc Free-Engine counters */
  VSEQ_EVT_CTRL_OTHR_ENGN_FREE_ENC_tag OTHR_ENGN_FREE_ENC; /* Free-up command Register for binary encoded Other/Misc Free-Engine counter */
  VSEQ_EVT_CTRL_OTHR_ENGN_FREE_tag OTHR_ENGN_FREE; /* Free-up command Register for bit-selected Other/Misc Free-Engine counters */
  uint8_t VSEQ_EVT_CTRL_reserved0[4];
  VSEQ_EVT_CTRL_OTHR_ENGN_AVL_tag OTHR_ENGN_AVL; /* All available Free Other/Misc Engines indicator */
  VSEQ_EVT_CTRL_OTHR_ENGN_BUF_AVL_tag OTHR_ENGN_BUF_AVL; /* All available Other/Misc Engines with atleast one Free Buffer indicator */
  VSEQ_EVT_CTRL_OTHR0_CNTR_MAX_VAL_tag OTHR0_CNTR_MAX_VAL; /* Maximum value of Event Counter for Other Engine-0 */
  VSEQ_EVT_CTRL_SW_EVT_TRIG_tag SW_EVT_TRIG; /* Software Defined Event Triggers (Interrupts) assert control */
  VSEQ_EVT_CTRL_SW_EVT_CLR_DONE_tag SW_EVT_CLR_DONE; /* Software Defined Event Triggers (Interrupts) to Host CPU */
};


/* ============================================================================
   =============================== Module: VSEQ_INT_DMA =======================
   ============================================================================ */

typedef union VSEQ_INT_DMA_KRAM_ADDR_union_tag { /* Kernel-RAM Address as Start Address for DMA Transfer */
  vuint32_t R;
  struct {
    vuint32_t KRAM_ADDR:14;            /* Kernel-RAM Address as Start Address for DMA Transfer */
    vuint32_t _unused_14:18;
  } B;
} VSEQ_INT_DMA_KRAM_ADDR_tag;

typedef union VSEQ_INT_DMA_TARGET_IPUx_ENGN_union_tag { /* Target IPUx Engine to be programmed with Kernel code via DMA */
  vuint32_t R;
  struct {
    vuint32_t TARGET_IPUS_ENGN:6;      /* Target IPUS Engine to be programmed Kernel Code via DMA */
    vuint32_t _unused_6:10;
    vuint32_t TARGET_IPUV_ENGN:6;      /* Target IPUV Engine to be programmed Kernel Code via DMA */
    vuint32_t _unused_22:10;
  } B;
} VSEQ_INT_DMA_TARGET_IPUx_ENGN_tag;

typedef union VSEQ_INT_DMA_TRANSFER_LEN_union_tag { /* DMA Transfer Length or Byte Count */
  vuint32_t R;
  struct {
    vuint32_t TRANSFER_LEN:15;         /* DMA Transfer length or Byte Count to be transferred */
    vuint32_t _unused_15:17;
  } B;
} VSEQ_INT_DMA_TRANSFER_LEN_tag;

typedef union VSEQ_INT_DMA_CTRL_STAT_union_tag { /* DMA Control and Status register */
  vuint32_t R;
  struct {
    vuint32_t START:1;                 /* Start DMA Transfer from Kernel RAM to selected IPUx Engine's IMEM */
    vuint32_t _unused_1:15;
    vuint32_t DMA_DONE:1;              /* DMA Transfer complete */
    vuint32_t BUSY:1;                  /* DMA Transfer in progress indicator */
    vuint32_t DMA_CFG_ERR:1;           /* DMA Configuration Error */
    vuint32_t BED:1;                   /* Bus Transfer error during DMA Destination access */
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:11;
  } B;
} VSEQ_INT_DMA_CTRL_STAT_tag;

struct VSEQ_INT_DMA_tag {
  VSEQ_INT_DMA_KRAM_ADDR_tag KRAM_ADDR; /* Kernel-RAM Address as Start Address for DMA Transfer */
  VSEQ_INT_DMA_TARGET_IPUx_ENGN_tag TARGET_IPUx_ENGN; /* Target IPUx Engine to be programmed with Kernel code via DMA */
  VSEQ_INT_DMA_TRANSFER_LEN_tag TRANSFER_LEN; /* DMA Transfer Length or Byte Count */
  VSEQ_INT_DMA_CTRL_STAT_tag CTRL_STAT; /* DMA Control and Status register */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:6;
    vuint32_t _unused_6:2;
    vuint32_t _unused_8:6;
    vuint32_t _unused_14:2;
    vuint32_t _unused_16:6;
    vuint32_t NOVF1:1;
    vuint32_t NIF1:1;
    vuint32_t _unused_24:6;
    vuint32_t NOVF0:1;
    vuint32_t NIF0:1;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t NFE1:1;
    vuint32_t NFEE1:1;
    vuint32_t NREE1:1;
    vuint32_t _unused_19:1;
    vuint32_t NWRE1:1;
    vuint32_t NDSS1:2;
    vuint32_t NLOCK1:1;
    vuint32_t NFE0:1;
    vuint32_t NFEE0:1;
    vuint32_t NREE0:1;
    vuint32_t _unused_27:1;
    vuint32_t NWRE0:1;
    vuint32_t NDSS0:2;
    vuint32_t NLOCK0:1;
  } B;
} WKPU_NCR_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

typedef union XBIC_MCR_union_tag {     /* XBIC Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t ME7:1;
    vuint32_t ME6:1;
    vuint32_t ME5:1;
    vuint32_t ME4:1;
    vuint32_t ME3:1;
    vuint32_t ME2:1;
    vuint32_t ME1:1;
    vuint32_t ME0:1;
    vuint32_t SE7:1;
    vuint32_t SE6:1;
    vuint32_t SE5:1;
    vuint32_t SE4:1;
    vuint32_t SE3:1;
    vuint32_t SE2:1;
    vuint32_t SE1:1;
    vuint32_t SE0:1;
  } B;
} XBIC_MCR_tag;

typedef union XBIC_EIR_union_tag {     /* XBIC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t SYN:8;
    vuint32_t MST:4;
    vuint32_t SLV:3;
    vuint32_t _unused_15:16;
    vuint32_t EIE:1;
  } B;
} XBIC_EIR_tag;

typedef union XBIC_ESR_union_tag {     /* XBIC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYN:8;
    vuint32_t MST:4;
    vuint32_t SLV:3;
    vuint32_t DPME7:1;
    vuint32_t DPME6:1;
    vuint32_t DPME5:1;
    vuint32_t DPME4:1;
    vuint32_t DPME3:1;
    vuint32_t DPME2:1;
    vuint32_t DPME1:1;
    vuint32_t DPME0:1;
    vuint32_t DPSE7:1;
    vuint32_t DPSE6:1;
    vuint32_t DPSE5:1;
    vuint32_t DPSE4:1;
    vuint32_t DPSE3:1;
    vuint32_t DPSE2:1;
    vuint32_t DPSE1:1;
    vuint32_t DPSE0:1;
    vuint32_t VLD:1;
  } B;
} XBIC_ESR_tag;

typedef union XBIC_EAR_union_tag {     /* XBIC Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} XBIC_EAR_tag;

struct XBIC_tag {
  XBIC_MCR_tag MCR;                    /* XBIC Module Control Register */
  XBIC_EIR_tag EIR;                    /* XBIC Error Injection Register */
  XBIC_ESR_tag ESR;                    /* XBIC Error Status Register */
  XBIC_EAR_tag EAR;                    /* XBIC Error Address Register */
};


/* ============================================================================
   =============================== Module: XRDC ===============================
   ============================================================================ */

typedef union XRDC_CR_union_tag {      /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t GVLD:1;
    vuint32_t HRL:4;
    vuint32_t _unused_5:2;
    vuint32_t MRF:1;
    vuint32_t VAW:1;
    vuint32_t _unused_9:21;
    vuint32_t LK1:1;
    vuint32_t _unused_31:1;
  } B;
} XRDC_CR_tag;

typedef union XRDC_HWCFG0_union_tag {  /* Hardware Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t NDID:8;
    vuint32_t NMSTR:8;
    vuint32_t NMRC:8;
    vuint32_t NPAC:4;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:3;
  } B;
} XRDC_HWCFG0_tag;

typedef union XRDC_HWCFG1_union_tag {  /* Hardware Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t _unused_4:28;
  } B;
} XRDC_HWCFG1_tag;

typedef union XRDC_HWCFG2_union_tag {  /* Hardware Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t PIDP0:1;
    vuint32_t PIDP1:1;
    vuint32_t PIDP2:1;
    vuint32_t PIDP3:1;
    vuint32_t PIDP4:1;
    vuint32_t PIDP5:1;
    vuint32_t PIDP6:1;
    vuint32_t PIDP7:1;
    vuint32_t PIDP8:1;
    vuint32_t PIDP9:1;
    vuint32_t PIDP10:1;
    vuint32_t PIDP11:1;
    vuint32_t PIDP12:1;
    vuint32_t PIDP13:1;
    vuint32_t PIDP14:1;
    vuint32_t PIDP15:1;
    vuint32_t PIDP16:1;
    vuint32_t PIDP17:1;
    vuint32_t PIDP18:1;
    vuint32_t PIDP19:1;
    vuint32_t PIDP20:1;
    vuint32_t PIDP21:1;
    vuint32_t PIDP22:1;
    vuint32_t PIDP23:1;
    vuint32_t PIDP24:1;
    vuint32_t PIDP25:1;
    vuint32_t PIDP26:1;
    vuint32_t PIDP27:1;
    vuint32_t PIDP28:1;
    vuint32_t PIDP29:1;
    vuint32_t PIDP30:1;
    vuint32_t PIDP31:1;
  } B;
} XRDC_HWCFG2_tag;

typedef union XRDC_MDACFG_union_tag {  /* Master Domain Assignment Configuration Register */
  vuint8_t R;
  struct {
    vuint8_t NMDAR:4;
    vuint8_t _unused_4:3;
    vuint8_t NCM:1;
  } B;
} XRDC_MDACFG_tag;

typedef union XRDC_MRCFG_union_tag {   /* Memory Region Configuration Register */
  vuint8_t R;
  struct {
    vuint8_t NMGD:5;
    vuint8_t _unused_5:3;
  } B;
} XRDC_MRCFG_tag;

typedef union XRDC_DERRLOC_union_tag { /* Domain Error Location Register */
  vuint32_t R;
  struct {
    vuint32_t MRCINST:16;
    vuint32_t PACINST:4;
    vuint32_t _unused_20:12;
  } B;
} XRDC_DERRLOC_tag;

typedef union XRDC_CHANNEL_DERR_W0_union_tag { /* Domain Error Word0 Register */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;
  } B;
} XRDC_CHANNEL_DERR_W0_tag;

typedef union XRDC_CHANNEL_DERR_W1_union_tag { /* Domain Error Word1 Register */
  vuint32_t R;
  struct {
    vuint32_t EDID:4;
    vuint32_t _unused_4:4;
    vuint32_t EATR:3;
    vuint32_t ERW:1;
    vuint32_t _unused_12:12;
    vuint32_t EPORT:3;
    vuint32_t _unused_27:3;
    vuint32_t EST:2;
  } B;
} XRDC_CHANNEL_DERR_W1_tag;

typedef union XRDC_CHANNEL_DERR_W2_union_tag { /* Domain Error Word2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} XRDC_CHANNEL_DERR_W2_tag;

typedef union XRDC_CHANNEL_DERR_W3_union_tag { /* Domain Error Word3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:30;
    vuint32_t RECR:2;
  } B;
} XRDC_CHANNEL_DERR_W3_tag;

typedef struct XRDC_CHANNEL_struct_tag {
  XRDC_CHANNEL_DERR_W0_tag DERR_W0;    /* Domain Error Word0 Register */
  XRDC_CHANNEL_DERR_W1_tag DERR_W1;    /* Domain Error Word1 Register */
  XRDC_CHANNEL_DERR_W2_tag DERR_W2;    /* Domain Error Word2 Register */
  XRDC_CHANNEL_DERR_W3_tag DERR_W3;    /* Domain Error Word3 Register */
} XRDC_CHANNEL_tag;

typedef union XRDC_PID_union_tag {     /* Process Identifier */
  vuint32_t R;
  struct {
    vuint32_t PID:6;
    vuint32_t _unused_6:10;
    vuint32_t LMNUM:6;                 /* Locked Master NUMber */
    vuint32_t _unused_22:2;
    vuint32_t ELK22H:1;                /* Enable (LK2 = 2) special Handling */
    vuint32_t _unused_25:3;
    vuint32_t TSM:1;
    vuint32_t LK2:2;
    vuint32_t _unused_31:1;
  } B;
} XRDC_PID_tag;

typedef union XRDC_PDAC_W0_union_tag { /* Peripheral Domain Access Control W0 */
  vuint32_t R;
  struct {
    vuint32_t D0ACP:3;
    vuint32_t D1ACP:3;
    vuint32_t D2ACP:3;
    vuint32_t D3ACP:3;
    vuint32_t D4ACP:3;
    vuint32_t D5ACP:3;
    vuint32_t D6ACP:3;
    vuint32_t D7ACP:3;
    vuint32_t SNUM:4;
    vuint32_t _unused_28:2;
    vuint32_t SE:1;
    vuint32_t _unused_31:1;
  } B;
} XRDC_PDAC_W0_tag;

typedef union XRDC_PDAC_W1_union_tag { /* Peripheral Domain Access Control W1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t LK2:2;
    vuint32_t VLD:1;
  } B;
} XRDC_PDAC_W1_tag;

typedef struct XRDC_PDAC_struct_tag {
  XRDC_PDAC_W0_tag W0;                 /* Peripheral Domain Access Control W0 */
  XRDC_PDAC_W1_tag W1;                 /* Peripheral Domain Access Control W1 */
} XRDC_PDAC_tag;

typedef union XRDC_MRGD_W0_union_tag { /* Memory Region Descriptor W0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t SRTADDR:27;
  } B;
} XRDC_MRGD_W0_tag;

typedef union XRDC_MRGD_W1_union_tag { /* Memory Region Descriptor W1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t ENDADDR:27;
  } B;
} XRDC_MRGD_W1_tag;

typedef union XRDC_MRGD_W2_union_tag { /* Memory Region Descriptor W2 */
  vuint32_t R;
  struct {
    vuint32_t D0ACP:3;
    vuint32_t D1ACP:3;
    vuint32_t D2ACP:3;
    vuint32_t D3ACP:3;
    vuint32_t D4ACP:3;
    vuint32_t D5ACP:3;
    vuint32_t D6ACP:3;
    vuint32_t D7ACP:3;
    vuint32_t SNUM:4;
    vuint32_t _unused_28:2;
    vuint32_t SE:1;
    vuint32_t _unused_31:1;
  } B;
} XRDC_MRGD_W2_tag;

typedef union XRDC_MRGD_W3_union_tag { /* Memory Region Descriptor W3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t LK2:2;
    vuint32_t VLD:1;
  } B;
} XRDC_MRGD_W3_tag;

typedef struct XRDC_MRGD_struct_tag {
  XRDC_MRGD_W0_tag W0;                 /* Memory Region Descriptor W0 */
  XRDC_MRGD_W1_tag W1;                 /* Memory Region Descriptor W1 */
  XRDC_MRGD_W2_tag W2;                 /* Memory Region Descriptor W2 */
  XRDC_MRGD_W3_tag W3;                 /* Memory Region Descriptor W3 */
  uint8_t MRGD_reserved0[16];
} XRDC_MRGD_tag;

struct XRDC_tag {
  XRDC_CR_tag CR;                      /* Control Register */
  uint8_t XRDC_reserved0[236];
  XRDC_HWCFG0_tag HWCFG0;              /* Hardware Configuration Register 0 */
  XRDC_HWCFG1_tag HWCFG1;              /* Hardware Configuration Register 1 */
  XRDC_HWCFG2_tag HWCFG2;              /* Hardware Configuration Register 2 */
  uint8_t XRDC_reserved1[4];
  XRDC_MDACFG_tag MDACFG[64];          /* Master Domain Assignment Configuration Register */
  XRDC_MRCFG_tag MRCFG[16];            /* Memory Region Configuration Register */
  uint8_t XRDC_reserved2[176];
  XRDC_DERRLOC_tag DERRLOC[16];        /* Domain Error Location Register */
  uint8_t XRDC_reserved3[448];
  XRDC_CHANNEL_tag CHANNEL[20];
  uint8_t XRDC_reserved4[448];
  XRDC_PID_tag PID[64];                /* Process Identifier */
  uint8_t XRDC_reserved5[2048];
  XRDC_PDAC_tag PDAC[512];
  XRDC_MRGD_tag MRGD[256];
};


/* ============================================================================
   =============================== Module: uSDHC ==============================
   ============================================================================ */

typedef union uSDHC_S_ADDR_union_tag { /* DMA System Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t DS_ADDR:30;
  } B;
} uSDHC_S_ADDR_tag;

typedef union uSDHC_BLK_ATT_union_tag { /* Block Attributes */
  vuint32_t R;
  struct {
    vuint32_t BLKSIZE:13;
    vuint32_t _unused_13:3;
    vuint32_t BLKCNT:16;
  } B;
} uSDHC_BLK_ATT_tag;

typedef union uSDHC_CMD_ARG_union_tag { /* Command Argument */
  vuint32_t R;
  struct {
    vuint32_t CMDARG:32;
  } B;
} uSDHC_CMD_ARG_tag;

typedef union uSDHC_CMD_XFR_TYP_union_tag { /* Command Transfer Type */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t RSPTYP:2;
    vuint32_t _unused_18:1;
    vuint32_t CCCEN:1;
    vuint32_t CICEN:1;
    vuint32_t DPSEL:1;
    vuint32_t CMDTYP:2;
    vuint32_t CMDINX:6;
    vuint32_t _unused_30:2;
  } B;
} uSDHC_CMD_XFR_TYP_tag;

typedef union uSDHC_CMD_RSP0_union_tag { /* Command Response0 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP0:32;
  } B;
} uSDHC_CMD_RSP0_tag;

typedef union uSDHC_CMD_RSP1_union_tag { /* Command Response1 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP1:32;
  } B;
} uSDHC_CMD_RSP1_tag;

typedef union uSDHC_CMD_RSP2_union_tag { /* Command Response2 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP2:32;
  } B;
} uSDHC_CMD_RSP2_tag;

typedef union uSDHC_CMD_RSP3_union_tag { /* Command Response3 */
  vuint32_t R;
  struct {
    vuint32_t CMDRSP3:32;
  } B;
} uSDHC_CMD_RSP3_tag;

typedef union uSDHC_DATA_BUFF_ACC_PORT_union_tag { /* Data Buffer Access Port */
  vuint32_t R;
  struct {
    vuint32_t DATCONT:32;
  } B;
} uSDHC_DATA_BUFF_ACC_PORT_tag;

typedef union uSDHC_PRES_STATE_union_tag { /* Present State */
  vuint32_t R;
  struct {
    vuint32_t CIHB:1;
    vuint32_t CDIHB:1;
    vuint32_t DLA:1;
    vuint32_t SDSTB:1;
    vuint32_t BUSOFF:1;
    vuint32_t HCKOFF:1;
    vuint32_t PEROFF:1;
    vuint32_t SDOFF:1;
    vuint32_t WTA:1;
    vuint32_t RTA:1;
    vuint32_t BWEN:1;
    vuint32_t BREN:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:2;
    vuint32_t _unused_15:1;
    vuint32_t CINST:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:1;
    vuint32_t WPSPL:1;
    vuint32_t _unused_20:3;
    vuint32_t CLSL:1;
    vuint32_t DLSL:8;
  } B;
} uSDHC_PRES_STATE_tag;

typedef union uSDHC_PROT_CTRL_union_tag { /* Protocol Control */
  vuint32_t R;
  struct {
    vuint32_t LCTL:1;
    vuint32_t DTW:2;
    vuint32_t D3CD:1;
    vuint32_t EMODE:2;
    vuint32_t CDTL:1;
    vuint32_t CDSS:1;
    vuint32_t DMASEL:2;
    vuint32_t _unused_10:6;
    vuint32_t SABGREQ:1;
    vuint32_t CREQ:1;
    vuint32_t RWCTL:1;
    vuint32_t IABG:1;
    vuint32_t RD_DONE_NO_8CLK:1;
    vuint32_t RD_WAIT_POINT:3;
    vuint32_t WECINT:1;
    vuint32_t WECINS:1;
    vuint32_t WECRM:1;
    vuint32_t _unused_27:3;
    vuint32_t NON_EXACT_BLK_RD:1;
    vuint32_t RD_NO8CLK_EN:1;
  } B;
} uSDHC_PROT_CTRL_tag;

typedef union uSDHC_SYS_CTRL_union_tag { /* System Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t DVS:4;
    vuint32_t SDCLKFS:8;
    vuint32_t DTOCV:4;
    vuint32_t _unused_20:2;
    vuint32_t _unused_22:1;
    vuint32_t IPP_RST_N:1;
    vuint32_t RSTA:1;
    vuint32_t RSTC:1;
    vuint32_t RSTD:1;
    vuint32_t INITA:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:3;
  } B;
} uSDHC_SYS_CTRL_tag;

typedef union uSDHC_INT_STATUS_union_tag { /* Interrupt Status */
  vuint32_t R;
  struct {
    vuint32_t CC:1;
    vuint32_t TC:1;
    vuint32_t BGE:1;
    vuint32_t DINT:1;
    vuint32_t BWR:1;
    vuint32_t BRR:1;
    vuint32_t CINS:1;
    vuint32_t CRM:1;
    vuint32_t CINT:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_15:1;
    vuint32_t CTOE:1;
    vuint32_t CCE:1;
    vuint32_t CEBE:1;
    vuint32_t CIE:1;
    vuint32_t DTOE:1;
    vuint32_t DCE:1;
    vuint32_t DEBE:1;
    vuint32_t _unused_23:1;
    vuint32_t AC12E:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t DMAE:1;
    vuint32_t _unused_29:3;
  } B;
} uSDHC_INT_STATUS_tag;

typedef union uSDHC_INT_STATUS_EN_union_tag { /* Interrupt Status Enable */
  vuint32_t R;
  struct {
    vuint32_t CCSEN:1;
    vuint32_t TCSEN:1;
    vuint32_t BGESEN:1;
    vuint32_t DINTSEN:1;
    vuint32_t BWRSEN:1;
    vuint32_t BRRSEN:1;
    vuint32_t CINSSEN:1;
    vuint32_t CRMSEN:1;
    vuint32_t CINTSEN:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_15:1;
    vuint32_t CTOESEN:1;
    vuint32_t CCESEN:1;
    vuint32_t CEBESEN:1;
    vuint32_t CIESEN:1;
    vuint32_t DTOESEN:1;
    vuint32_t DCESEN:1;
    vuint32_t DEBESEN:1;
    vuint32_t _unused_23:1;
    vuint32_t AC12ESEN:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t DMAESEN:1;
    vuint32_t _unused_29:3;
  } B;
} uSDHC_INT_STATUS_EN_tag;

typedef union uSDHC_INT_SIGNAL_EN_union_tag { /* Interrupt Signal Enable */
  vuint32_t R;
  struct {
    vuint32_t CCIEN:1;
    vuint32_t TCIEN:1;
    vuint32_t BGEIEN:1;
    vuint32_t DINTIEN:1;
    vuint32_t BWRIEN:1;
    vuint32_t BRRIEN:1;
    vuint32_t CINSIEN:1;
    vuint32_t CRMIEN:1;
    vuint32_t CINTIEN:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_15:1;
    vuint32_t CTOEIEN:1;
    vuint32_t CCEIEN:1;
    vuint32_t CEBEIEN:1;
    vuint32_t CIEIEN:1;
    vuint32_t DTOEIEN:1;
    vuint32_t DCEIEN:1;
    vuint32_t DEBEIEN:1;
    vuint32_t _unused_23:1;
    vuint32_t AC12EIEN:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t DMAEIEN:1;
    vuint32_t _unused_29:3;
  } B;
} uSDHC_INT_SIGNAL_EN_tag;

typedef union uSDHC_AUTOCMD12_ERR_STATUS_union_tag { /* Auto CMD12 Error Status */
  vuint32_t R;
  struct {
    vuint32_t AC12NE:1;
    vuint32_t AC12TOE:1;
    vuint32_t AC12EBE:1;
    vuint32_t AC12CE:1;
    vuint32_t AC12IE:1;
    vuint32_t _unused_5:2;
    vuint32_t CNIBAC12E:1;
    vuint32_t _unused_8:14;
    vuint32_t EXECUTE_TUNING:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:8;
  } B;
} uSDHC_AUTOCMD12_ERR_STATUS_tag;

typedef union uSDHC_HOST_CTRL_CAP_union_tag { /* Host Controller Capabilities */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:5;
    vuint32_t _unused_8:4;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:2;
    vuint32_t MBL:3;
    vuint32_t _unused_19:1;
    vuint32_t ADMAS:1;
    vuint32_t HSS:1;
    vuint32_t DMAS:1;
    vuint32_t SRS:1;
    vuint32_t VS33:1;
    vuint32_t VS30:1;
    vuint32_t VS18:1;
    vuint32_t _unused_27:5;
  } B;
} uSDHC_HOST_CTRL_CAP_tag;

typedef union uSDHC_WTMK_LVL_union_tag { /* Watermark Level */
  vuint32_t R;
  struct {
    vuint32_t RD_WML:8;
    vuint32_t RD_BRST_LEN:5;
    vuint32_t _unused_13:3;
    vuint32_t WR_WML:8;
    vuint32_t WR_BRST_LEN:5;
    vuint32_t _unused_29:3;
  } B;
} uSDHC_WTMK_LVL_tag;

typedef union uSDHC_MIX_CTRL_union_tag { /* Mixer Control */
  vuint32_t R;
  struct {
    vuint32_t DMAEN:1;
    vuint32_t BCEN:1;
    vuint32_t AC12EN:1;
    vuint32_t DDR_EN:1;
    vuint32_t DTDSEL:1;
    vuint32_t MSBSEL:1;
    vuint32_t _unused_6:1;
    vuint32_t AC23EN:1;
    vuint32_t _unused_8:14;
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:3;
    vuint32_t AC12_RD_POINT:1;
    vuint32_t CMD_DMY_WAIT_CFG:1;
    vuint32_t CMD_DMY_EN:1;
  } B;
} uSDHC_MIX_CTRL_tag;

typedef union uSDHC_FORCE_EVENT_union_tag { /* Force Event */
  vuint32_t R;
  struct {
    vuint32_t FEVTAC12NE:1;
    vuint32_t FEVTAC12TOE:1;
    vuint32_t FEVTAC12CE:1;
    vuint32_t FEVTAC12EBE:1;
    vuint32_t FEVTAC12IE:1;
    vuint32_t _unused_5:2;
    vuint32_t FEVTCNIBAC12E:1;
    vuint32_t _unused_8:8;
    vuint32_t FEVTCTOE:1;
    vuint32_t FEVTCCE:1;
    vuint32_t FEVTCEBE:1;
    vuint32_t FEVTCIE:1;
    vuint32_t FEVTDTOE:1;
    vuint32_t FEVTDCE:1;
    vuint32_t FEVTDEBE:1;
    vuint32_t _unused_23:1;
    vuint32_t FEVTAC12E:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t FEVTDMAE:1;
    vuint32_t _unused_29:2;
    vuint32_t FEVTCINT:1;
  } B;
} uSDHC_FORCE_EVENT_tag;

typedef union uSDHC_ADMA_ERR_STATUS_union_tag { /* ADMA Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t ADMAES:2;
    vuint32_t ADMALME:1;
    vuint32_t ADMADCE:1;
    vuint32_t _unused_4:28;
  } B;
} uSDHC_ADMA_ERR_STATUS_tag;

typedef union uSDHC_ADMA_SYS_ADDR_union_tag { /* ADMA System Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t ADS_ADDR:30;
  } B;
} uSDHC_ADMA_SYS_ADDR_tag;

typedef union uSDHC_VEND_SPEC_union_tag { /* Vendor Specific Register */
  vuint32_t R;
  struct {
    vuint32_t EXT_DMA_EN:1;
    vuint32_t VSELECT:1;
    vuint32_t CONFLICT_CHK_EN:1;
    vuint32_t AC12_WR_CHKBUSY_EN:1;
    vuint32_t DAT3_CD_POL:1;
    vuint32_t CD_POL:1;
    vuint32_t WP_POL:1;
    vuint32_t CLKONJ_IN_ABORT:1;
    vuint32_t FRC_SDCLK_ON:1;
    vuint32_t AC12_ISNOT_ABORT:1;
    vuint32_t _unused_10:1;
    vuint32_t BUS_CLK_SOFT_EN:1;
    vuint32_t HCLK_SOFT_EN:1;
    vuint32_t IPG_PERCLK_SOFT_EN:1;
    vuint32_t CARD_CLK_SOFT_EN:1;
    vuint32_t CRC_CHK_DIS:1;
    vuint32_t INT_ST_VAL:8;
    vuint32_t DBG_SEL:4;
    vuint32_t CMD_OE_PRE_EN:1;
    vuint32_t AC12_RD_CHKBUSY_EN:1;
    vuint32_t _unused_30:2;
  } B;
} uSDHC_VEND_SPEC_tag;

typedef union uSDHC_MMC_BOOT_union_tag { /* MMC Boot Register */
  vuint32_t R;
  struct {
    vuint32_t DTOCV_ACK:4;
    vuint32_t BOOT_ACK:1;
    vuint32_t BOOT_MODE:1;
    vuint32_t BOOT_EN:1;
    vuint32_t AUTO_SABG_EN:1;
    vuint32_t DISABLE_TIME_OUT:1;
    vuint32_t _unused_9:7;
    vuint32_t BOOT_BLK_CNT:16;
  } B;
} uSDHC_MMC_BOOT_tag;

typedef union uSDHC_VEND_SPEC2_union_tag { /* Vendor Specific 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t CARD_INT_D3_TEST:1;
    vuint32_t _unused_4:3;
    vuint32_t CARD_INT_AUTO_CLR_DIS:1;
    vuint32_t _unused_8:24;
  } B;
} uSDHC_VEND_SPEC2_tag;

typedef union uSDHC_HOST_CTRL_VER_union_tag { /* Host Controller Version */
  vuint32_t R;
  struct {
    vuint32_t SVN:8;
    vuint32_t VVN:8;
    vuint32_t _unused_16:16;
  } B;
} uSDHC_HOST_CTRL_VER_tag;

struct uSDHC_tag {
  uSDHC_S_ADDR_tag S_ADDR;             /* DMA System Address */
  uSDHC_BLK_ATT_tag BLK_ATT;           /* Block Attributes */
  uSDHC_CMD_ARG_tag CMD_ARG;           /* Command Argument */
  uSDHC_CMD_XFR_TYP_tag CMD_XFR_TYP;   /* Command Transfer Type */
  uSDHC_CMD_RSP0_tag CMD_RSP0;         /* Command Response0 */
  uSDHC_CMD_RSP1_tag CMD_RSP1;         /* Command Response1 */
  uSDHC_CMD_RSP2_tag CMD_RSP2;         /* Command Response2 */
  uSDHC_CMD_RSP3_tag CMD_RSP3;         /* Command Response3 */
  uSDHC_DATA_BUFF_ACC_PORT_tag DATA_BUFF_ACC_PORT; /* Data Buffer Access Port */
  uSDHC_PRES_STATE_tag PRES_STATE;     /* Present State */
  uSDHC_PROT_CTRL_tag PROT_CTRL;       /* Protocol Control */
  uSDHC_SYS_CTRL_tag SYS_CTRL;         /* System Control */
  uSDHC_INT_STATUS_tag INT_STATUS;     /* Interrupt Status */
  uSDHC_INT_STATUS_EN_tag INT_STATUS_EN; /* Interrupt Status Enable */
  uSDHC_INT_SIGNAL_EN_tag INT_SIGNAL_EN; /* Interrupt Signal Enable */
  uSDHC_AUTOCMD12_ERR_STATUS_tag AUTOCMD12_ERR_STATUS; /* Auto CMD12 Error Status */
  uSDHC_HOST_CTRL_CAP_tag HOST_CTRL_CAP; /* Host Controller Capabilities */
  uSDHC_WTMK_LVL_tag WTMK_LVL;         /* Watermark Level */
  uSDHC_MIX_CTRL_tag MIX_CTRL;         /* Mixer Control */
  uint8_t uSDHC_reserved0[4];
  uSDHC_FORCE_EVENT_tag FORCE_EVENT;   /* Force Event */
  uSDHC_ADMA_ERR_STATUS_tag ADMA_ERR_STATUS; /* ADMA Error Status Register */
  uSDHC_ADMA_SYS_ADDR_tag ADMA_SYS_ADDR; /* ADMA System Address */
  uint8_t uSDHC_reserved1[100];
  uSDHC_VEND_SPEC_tag VEND_SPEC;       /* Vendor Specific Register */
  uSDHC_MMC_BOOT_tag MMC_BOOT;         /* MMC Boot Register */
  uSDHC_VEND_SPEC2_tag VEND_SPEC2;     /* Vendor Specific 2 Register */
  uint8_t uSDHC_reserved2[48];
  uSDHC_HOST_CTRL_VER_tag HOST_CTRL_VER; /* Host Controller Version */
};

/**************************************************************************/ 
/*                           Module: CM4                                  */ 
/**************************************************************************/ 

struct CMX_tag { 
    uint8_t CM4_reserved0[57348]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t INTLINESNUM:4; 
           vuint32_t:28; 
        } B; 
    } ICTR;				/*0000E004*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t DISMCYCINT:1; 
           vuint32_t DISDEFWBUF:1; 
           vuint32_t DISFOLD:1; 
           vuint32_t:5; 
           vuint32_t DISFPCA:1; 
           vuint32_t DISOOFP:1; 
           vuint32_t:22; 
        } B; 
    } ACTLR;				/*0000E008*/ 
 
    uint8_t CM4_reserved1[4]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ENABLE:1; 
           vuint32_t TICKINT:1; 
           vuint32_t CLKSOURCE:1; 
           vuint32_t:13; 
           vuint32_t COUNTFLAG:1; 
           vuint32_t:15; 
        } B; 
    } STCSR;				/*0000E010*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t RELOAD:24; 
           vuint32_t:8; 
        } B; 
    } STRVR;				/*0000E014*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t CURRENT:24; 
           vuint32_t:8; 
        } B; 
    } STCVR;				/*0000E018*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t TENMS:24; 
           vuint32_t:6;
           vuint32_t SKEW:1;
           vuint32_t NOREF:1;
        } B; 
    } STCR;				/*0000E01C*/ 
 
    uint8_t CM4_reserved2[224]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t SETENA:32; 
        } B; 
    } NVIC_ISER[8];				/*0000E100*/ 
 
    uint8_t CM4_reserved3[96]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t CLRENA:32; 
        } B; 
    } NVIC_ICER[8];				/*0000E180*/ 
 
    uint8_t CM4_reserved4[96]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t SETPEND:32; 
        } B; 
    } NVIC_ISPR[8];				/*0000E200*/ 
  
    uint8_t CM4_reserved5[96]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t CLRPEND:32; 
        } B; 
    } NVIC_ICPR[8];				/*0000E280*/ 
 
    uint8_t CM4_reserved6[96]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ACTIVE:32; 
        } B; 
    } NVIC_IABR[8];				/*0000E300*/ 
 
    uint8_t CM4_reserved7[224]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t PRI_N0:8; 
           vuint32_t PRI_N1:8; 
           vuint32_t PRI_N2:8; 
           vuint32_t PRI_N3:8; 
        } B; 
    } NVIC_IPR[60];				/*0000E400*/ 
  
    uint8_t CM4_reserved8[2064]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t REVISION:4; 
           vuint32_t PARTNO:12; 
           vuint32_t:4; 
           vuint32_t VARIANT:4; 
           vuint32_t IMPLEMENTER:8; 
        } B; 
    } CPUID;				/*0000ED00*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t VECTACTIVE:9; 
           vuint32_t:2; 
           vuint32_t RETTOBASE:1; 
           vuint32_t VECTPENDING:10; 
           vuint32_t ISRPENDING:1;
           vuint32_t:2; 
           vuint32_t PENDSTCLR:1; 
           vuint32_t PENDSTSET:1; 
           vuint32_t PENDSVCLR:1; 
           vuint32_t PENDSVSET:1; 
           vuint32_t:2; 
           vuint32_t NMIPENDSET:1; 
        } B; 
    } ICSR;				/*0000ED04*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:7; 
           vuint32_t TBLOFF:25; 
        } B; 
    } VTOR;				/*0000ED08*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t VECTRESET:1; 
           vuint32_t VECTCLRACTIVE:1; 
           vuint32_t SYSRESETREQ:1; 
           vuint32_t:5; 
           vuint32_t PRIGROUP:3; 
           vuint32_t:4; 
           vuint32_t ENDIANNESS:1; 
           vuint32_t VECTKEYSTAT:16;  
        } B; 
    } AIRCR;				/*0000ED0C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
        	 vuint32_t:1;
           vuint32_t SLEEPONEXIT:1; 
           vuint32_t SLEEPDEEP:1;
           vuint32_t:1;	 
           vuint32_t SEVONPEND:1; 
           vuint32_t:27; 
        } B; 
    } SCR;				/*0000ED10*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t NONBASETHRDENA:1; 
           vuint32_t USERSETMPEND:1; 
           vuint32_t:1; 
           vuint32_t UNALIGN_TRP:1; 
           vuint32_t DIV_0_TRP:1; 
           vuint32_t:3; 
           vuint32_t BFHFNMIGN:1; 
           vuint32_t STKALIGN:1; 
           vuint32_t:22; 
        } B; 
    } CCR;				/*0000ED14*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t PRI_4:8; 
           vuint32_t PRI_5:8; 
           vuint32_t PRI_6:8; 
           vuint32_t:8; 
        } B; 
    } SHPR1;				/*0000ED18*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:24;  
           vuint32_t PRI_11:8; 
        } B; 
    } SHPR2;				/*0000ED1C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:16; 
           vuint32_t PRI_14:8; 
           vuint32_t PRI_15:8; 
        } B; 
    } SHPR3;				/*0000ED20*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t MEMFAULTACT:1; 
           vuint32_t BUSFAULTACT:1; 
           vuint32_t:1; 
           vuint32_t USGFAULTACT:1; 
           vuint32_t:3; 
           vuint32_t SVCALLACT:1; 
           vuint32_t MONITORACT:1; 
           vuint32_t:1; 
           vuint32_t PENDSVACT:1; 
           vuint32_t SYSTICKACT:1; 
           vuint32_t USGFAULTPENDED:1; 
           vuint32_t MEMFAULTPENDED:1; 
           vuint32_t BUSFAULTPENDED:1; 
           vuint32_t SVCALLPENDED:1; 
           vuint32_t MEMFAULTENA:1; 
           vuint32_t BUSFAULTENA:1; 
           vuint32_t USGFAULTENA:1; 
           vuint32_t:13; 
        } B; 
    } SHCSR;				/*0000ED24*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t MMFSR:8; 
           vuint32_t BFSR:8; 
           vuint32_t UFSR:16; 
        } B; 
    } CFSR;				/*0000ED28*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:1; 
           vuint32_t VECTTBL:1; 
           vuint32_t:28; 
           vuint32_t FORCED:1; 
           vuint32_t DEBUGEVT:1; 
        } B; 
    } HFSR;				/*0000ED2C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t HALTED:1; 
           vuint32_t BKPT:1; 
           vuint32_t DWTTRAP:1; 
           vuint32_t VCATCH:1; 
           vuint32_t EXTERNAL:1; 
           vuint32_t:27; 
        } B; 
    } DFSR;				/*0000ED30*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ADDRESS:32; 
        } B; 
    } MMFAR;				/*0000ED34*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ADDRESS:32; 
        } B; 
    } BFAR;				/*0000ED38*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t IMPDEF:32; 
        } B; 
    } AFSR;				/*0000ED3C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t STATE0:4; 
           vuint32_t STATE1:4; 
           vuint32_t STATE2:4; 
           vuint32_t STATE3:4;
           vuint32_t:16; 
        } B; 
    } ID_PFR0;				/*0000ED40*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:8; 
           vuint32_t M_PROFILE_PROGRAMMERS_MODEL:4; 
           vuint32_t:20; 
        } B; 
    } ID_PFR1;				/*0000ED44*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:20; 
           vuint32_t DEBUG_MODEL_M_PROFILE:4; 
           vuint32_t:8; 
        } B; 
    } ID_DFR0;				/*0000ED48*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ID_AFR0_0:4; 
           vuint32_t ID_AFR0_4:4; 
           vuint32_t ID_AFR0_8:4; 
           vuint32_t ID_AFR0_12:4; 
           vuint32_t:16; 
        } B; 
    } ID_AFR0;				/*0000ED4C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:4; 
           vuint32_t PMSA_SUPPORT:4; 
           vuint32_t OUTERMOST_SHAREABILITY:4; 
           vuint32_t SHAREABILITY_LEVELS:4; 
           vuint32_t:4;
           vuint32_t AUXILIARY_REGISTERS:4; 
           vuint32_t:8; 
        } B; 
    } ID_MMFR0;				/*0000ED50*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } ID_MMFR1;				/*0000ED54*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:24; 
           vuint32_t WFI_STALL:4;
           vuint32_t:4; 
        } B; 
    } ID_MMFR2;				/*0000ED58*/ 
 
    union { 
        vuint32_t R; 
        struct { 
        	 vuint32_t:32;
        } B; 
    } ID_MMFR3;				/*0000ED5C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:4; 
           vuint32_t BITCOUNT_INSTRS:4; 
           vuint32_t BITFIELD_INSTRS:4; 
           vuint32_t CMPBRANCH_INSTRS:4; 
           vuint32_t COPROC_INSTRS:4; 
           vuint32_t DEBUG_INSTRS:4; 
           vuint32_t DIVIDE_INSTRS:4; 
           vuint32_t:4; 
        } B; 
    } ID_ISAR0;				/*0000ED60*/ 
 
    union { 
        vuint32_t R; 
        struct {  
           vuint32_t:12; 
           vuint32_t EXTEND_INSTRS:4; 
           vuint32_t IFTHEN_INSTRS:4; 
           vuint32_t IMMEDIATE_INSTRS:4; 
           vuint32_t INTERWORK_INSTRS:4; 
           vuint32_t:4; 	
        } B; 
    } ID_ISAR1;				/*0000ED64*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t LOADSTORE_INSTRS:4; 
           vuint32_t MEMHINT_INSTRS:4; 
           vuint32_t MULTIACCESSINT_INSTRS:4; 
           vuint32_t MULT_INSTRS:4; 
           vuint32_t MULTS_INSTRS:4; 
           vuint32_t MULTU_INSTRS:4; 
           vuint32_t:4; 
           vuint32_t REVERSAL_INSTRS:4; 
        } B; 
    } ID_ISAR2;				/*0000ED68*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t SATURATE_INSTRS:4; 
           vuint32_t SIMD_INSTRS:4; 
           vuint32_t SVC_INSTRS:4; 
           vuint32_t SYNCHPRIM_INSTRS:4; 
           vuint32_t TABBRANCH_INSTRS:4; 
           vuint32_t THUMBCOPY_INSTRS:4; 
           vuint32_t TRUENOP_INSTRS:4; 
           vuint32_t:4; 
        } B; 
    } ID_ISAR3;				/*0000ED6C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t UNPRIV_INSTRS:4; 
           vuint32_t WITHSHIFTS_INSTRS:4; 
           vuint32_t WRITEBACK_INSTRS:4; 
           vuint32_t:4; 
           vuint32_t BARRIER_INSTRS:4; 
           vuint32_t SYNCHPRIM_INSTRS_FRAC:4; 
           vuint32_t PSR_M_INSTRS:4; 
           vuint32_t:4; 
        } B; 
    } ID_ISAR4;				/*0000ED70*/ 
 
    uint8_t CM4_reserved10[124]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t C_DEBUGEN:1; 
           vuint32_t C_HALT:1; 
           vuint32_t C_STEP:1; 
           vuint32_t C_MASKINTS:1; 
           vuint32_t:1; 
           vuint32_t C_SNAPSTALL:1; 
           vuint32_t:10; 
           vuint32_t S_REGRDY:1; 
           vuint32_t S_HALT:1; 
           vuint32_t S_SLEEP:1; 
           vuint32_t S_LOCKUP:1; 
           vuint32_t:4;
           vuint32_t S_RETIRE_ST:1; 
           vuint32_t S_RESET_ST:1;
	         vuint32_t:6; 
	} B; 
    } DHCSR;				/*0000EDF0*/ 

    union { 
        vuint32_t R; 
        struct { 
           vuint32_t REGSEL:5; 
           vuint32_t:11; 
           vuint32_t REGWnR:1; 
           vuint32_t:15; 
        } B; 
    } DCRSR;				/*0000EDF4*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t DBGTMP:32; 
        } B; 
    } DCRDR;				/*0000EDF8*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t VC_CORERESET:1; 
           vuint32_t:3; 
           vuint32_t VC_MMERR:1; 
           vuint32_t VC_NOCPERR:1; 
           vuint32_t VC_CHKERR:1; 
           vuint32_t VC_STATERR:1; 
           vuint32_t VC_BUSERR:1; 
           vuint32_t VC_INTERR:1; 
           vuint32_t VC_HARDERR:1; 
           vuint32_t:5; 
           vuint32_t MON_EN:1; 
           vuint32_t MON_PEND:1; 
           vuint32_t MON_STEP:1; 
           vuint32_t MON_REQ:1; 
           vuint32_t:4; 
           vuint32_t TRCENA:1; 
           vuint32_t:7; 
        } B; 
    } DEMCR;				/*0000EDFC*/ 
 
    uint8_t CM4_reserved11[256]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t INTID:9; 
           vuint32_t:23; 
        } B; 
    } STIR;				/*0000EF00*/ 
 
    uint8_t CM4_reserved12[204]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID4;				/*0000EFD0*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID5;				/*0000EFD4*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID6;				/*0000EFD8*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID7;				/*0000EFDC*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID0;				/*0000EFE0*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID1;				/*0000EFE4*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID2;				/*0000EFE8*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t:32; 
        } B; 
    } PID3;				/*0000EFEC*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t DUMMY_NOBIT:32; 
        } B; 
    } CID[4];				/*0000EFF0*/ 
 
}; 

/**************************************************************************/ 
/*                           Module: GIC                            */ 
/**************************************************************************/ 
/*        Header translated using script version 0.14 (14 Mar 2012)       */ 
/*                 on Thu Mar 15 10:06:07 2012 by B40068.                 */ 
/*           Report header file issues to b12242@freescale.com.           */ 
struct GIC_tag { 
    uint8_t GIC_reserved0[256]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ENABLES:1; 
           vuint32_t ENABLENS:1; 
           vuint32_t ACKCTL:1; 
           vuint32_t FIQEN:1; 
           vuint32_t SBPR:1; 
           vuint32_t:27; 
        } B; 
    } ICCICR;				/*00000100*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t PRIORITY:8; 
           vuint32_t:24; 
        } B; 
    } ICCPMR;				/*00000104*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t BINARY_POINT:3; 
           vuint32_t:29; 
        } B; 
    } ICCBPR;				/*00000108*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t ACKINTID:10; 
           vuint32_t CPUID:3; 
           vuint32_t:19; 
        } B; 
    } ICCIAR;				/*0000010C*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t EOIINTID:10; 
           vuint32_t CPUID:3; 
           vuint32_t:19; 
        } B; 
    } ICCEOIR;				/*00000110*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t PRIORITY:8; 
           vuint32_t:24; 
        } B; 
    } ICCRPR;				/*00000114*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t PENDINTID:10; 
           vuint32_t CPUID:3; 
           vuint32_t:19; 
        } B; 
    } ICCHPIR;				/*00000118*/ 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t BINARY_POINT:3; 
           vuint32_t:29; 
        } B; 
    } ICCABPR;				/*0000011C*/ 
 
    uint8_t GIC_reserved1[220]; 
 
    union { 
        vuint32_t R; 
        struct { 
           vuint32_t IMPLEMENTER:12; 
           vuint32_t REVISION:4; 
           vuint32_t ARCH_VER:4; 
           vuint32_t PRODUCTID:12; 
        } B; 
    } ICCIIDR;				/*000001FC*/ 
 
}; 

#define CM4_0 (*(volatile struct CMX_tag *) 0xE0000000UL) 
/******************* Reused from Vybrid*****************************/
#define GIC    (*(volatile struct GIC_tag *)        0x7D000000) 
/**************************End Reuse from Vybrid ********************/

#define AXBS (*(volatile struct AXBS_tag *) 0x40000000UL)
#define BCTRL (*(volatile struct BCTRL_tag *) 0x400EA000UL)
#define BIST (*(volatile struct BIST_tag *) 0x400EC000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0x40055000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0x400BE000UL)
#define CMU_0 (*(volatile struct CMU_tag *) 0x400C4000UL)
#define CMU_1 (*(volatile struct CMU_tag *) 0x400C4020UL)
#define CMU_10 (*(volatile struct CMU_tag *) 0x400C4140UL)
#define CMU_11 (*(volatile struct CMU_tag *) 0x400C4160UL)
#define CMU_12 (*(volatile struct CMU_tag *) 0x400C4180UL)
#define CMU_13 (*(volatile struct CMU_tag *) 0x400C41A0UL)
#define CMU_2 (*(volatile struct CMU_tag *) 0x400C4040UL)
#define CMU_3 (*(volatile struct CMU_tag *) 0x400C4060UL)
#define CMU_4 (*(volatile struct CMU_tag *) 0x400C4080UL)
#define CMU_5 (*(volatile struct CMU_tag *) 0x400C40A0UL)
#define CMU_6 (*(volatile struct CMU_tag *) 0x400C40C0UL)
#define CMU_7 (*(volatile struct CMU_tag *) 0x400C40E0UL)
#define CMU_8 (*(volatile struct CMU_tag *) 0x400C4100UL)
#define CMU_9 (*(volatile struct CMU_tag *) 0x400C4120UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0x4005B000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0x400CC000UL)
#define CSE3 (*(volatile struct CSE3_tag *) 0x40001000UL)
#define DCU (*(volatile struct DCU_tag *) 0x40028000UL)
#define DEC200 (*(volatile struct DEC200_tag *) 0x40026000UL)
#define DFS_0 (*(volatile struct DFS_tag *) 0x4003C040UL)
#define DFS_1 (*(volatile struct DFS_tag *) 0x4003C140UL)
#define DFS_2 (*(volatile struct DFS_tag *) 0x4003C1C0UL)
#define DMA (*(volatile struct DMA_tag *) 0x40002000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0x40031000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0x400A1000UL)
#define EIM (*(volatile struct EIM_tag *) 0x40088000UL)
#define ENET (*(volatile struct ENET_tag *) 0x40032000UL)
#define ERM (*(volatile struct ERM_tag *) 0x40080000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0x400B0000UL)
#define FDMA (*(volatile struct FDMA_tag *) 0x7C040000UL)
#define FR (*(volatile struct FR_tag *) 0x40034000UL)
#define FTM_0 (*(volatile struct FTM_tag *) 0x4004F000UL)
#define FTM_1 (*(volatile struct FTM_tag *) 0x400B6000UL)
#define FXOSC (*(volatile struct FXOSC_tag *) 0x4003C280UL)
#define H264_DEC (*(volatile struct H264_DEC_tag *) 0x400D8000UL)
#define H264_ENC (*(volatile struct H264_ENC_tag *) 0x400DC000UL)
#define HPSMI (*(volatile struct HPSMI_tag *) 0x40068000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0x40051000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0x400B8000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0x400BA000UL)
#define IPUS_0 (*(volatile struct IPUS_tag *) 0x7C042000UL)
#define IPUS_1 (*(volatile struct IPUS_tag *) 0x7C043000UL)
#define IPUS_2 (*(volatile struct IPUS_tag *) 0x7C044000UL)
#define IPUS_3 (*(volatile struct IPUS_tag *) 0x7C045000UL)
#define IPUS_4 (*(volatile struct IPUS_tag *) 0x7C046000UL)
#define IPUS_5 (*(volatile struct IPUS_tag *) 0x7C047000UL)
#define IPUS_6 (*(volatile struct IPUS_tag *) 0x7C048000UL)
#define IPUS_7 (*(volatile struct IPUS_tag *) 0x7C049000UL)
#define IPUV_0 (*(volatile struct IPUV_tag *) 0x7C062000UL)
#define IPUV_1 (*(volatile struct IPUV_tag *) 0x7C063000UL)
#define IPUV_2 (*(volatile struct IPUV_tag *) 0x7C064000UL)
#define IPUV_3 (*(volatile struct IPUV_tag *) 0x7C065000UL)
#define jpeg (*(volatile struct JPEG_tag *) 0x400D4000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0x40078000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0x40053000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0x400BC000UL)
#define LMEM_0 (*(volatile struct LMEM_tag *) 0x1E800000UL)
#define LMEM_1 (*(volatile struct LMEM_tag *) 0x3E000000UL)
#define MCM (*(volatile struct MCM_tag *) 0xE0080000UL)
#define MCT (*(volatile struct MCT_tag *) 0x400E8000UL)
#define MC_CGM_0 (*(volatile struct MC_CGM_0_tag *) 0x4003C000UL)
#define MC_CGM_1 (*(volatile struct MC_CGM_1_tag *) 0x4003F000UL)
#define MC_CGM_2 (*(volatile struct MC_CGM_2_tag *) 0x40042000UL)
#define MC_CGM_3 (*(volatile struct MC_CGM_3_tag *) 0x40045000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0x4004A000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0x40048000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0x400E0000UL)
#define MEW_AXI_0 (*(volatile struct MEW_AXI_tag *) 0x40037000UL)
#define MEW_AXI_1 (*(volatile struct MEW_AXI_tag *) 0x400A3000UL)
#define MEW_WPT_0 (*(volatile struct MEW_WPT_tag *) 0x4008F000UL)
#define MEW_WPT_1 (*(volatile struct MEW_WPT_tag *) 0x40090000UL)
#define MIPICSI2_0 (*(volatile struct MIPICSI2_tag *) 0x40030000UL)
#define MIPICSI2_1 (*(volatile struct MIPICSI2_tag *) 0x400A0000UL)
#define MMDC_0 (*(volatile struct MMDC_tag *) 0x40036000UL)
#define MMDC_1 (*(volatile struct MMDC_tag *) 0x400A2000UL)
#define MSCM (*(volatile struct MSCM_tag *) 0x40081000UL)
#define OCOTP (*(volatile struct OCOTP_tag *) 0x4005F000UL)
#define OTFAD (*(volatile struct OTFAD_tag *) 0x400A6000UL)
#define PCIE_EP (*(volatile struct PCIE_EP_tag *) 0x72FFC000UL)
#define PCIE_PL (*(volatile struct PCIE_PL_tag *) 0x72FFC000UL)
#define PCIE_RC (*(volatile struct PCIE_RC_tag *) 0x72FFC000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0x4003A000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0x400AA000UL)
#define PLLDIG_0 (*(volatile struct PLLDIG_tag *) 0x4003C000UL)
#define PLLDIG_1 (*(volatile struct PLLDIG_tag *) 0x4003C080UL)
#define PLLDIG_2 (*(volatile struct PLLDIG_tag *) 0x4003C100UL)
#define PLLDIG_3 (*(volatile struct PLLDIG_tag *) 0x4003C180UL)
#define PLLDIG_4 (*(volatile struct PLLDIG_tag *) 0x4003C200UL)
#define PMC (*(volatile struct PMC_tag *) 0x400C8000UL)
#define QuadSPI (*(volatile struct QuadSPI_tag *) 0x400A6000UL)
#define SAR_ADC (*(volatile struct SAR_ADC_tag *) 0x4004D000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0x40082000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0x40074000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0x4006C000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0x40057000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0x400C0000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0x40059000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0x400C2000UL)
#define SRC (*(volatile struct SRC_tag *) 0x4007C000UL)
#define SSE (*(volatile struct SSE_tag *) 0x40079000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0x400E4000UL)
#define STM_0 (*(volatile struct STM_tag *) 0x4000D000UL)
#define STM_1 (*(volatile struct STM_tag *) 0x40087000UL)
#define SWT0 (*(volatile struct SWT_tag *) 0x4000A000UL)
#define SWT1 (*(volatile struct SWT_tag *) 0x4000B000UL)
#define SWT2 (*(volatile struct SWT_tag *) 0x40084000UL)
#define SWT3 (*(volatile struct SWT_tag *) 0x40085000UL)
#define SWT4 (*(volatile struct SWT_tag *) 0x40086000UL)
#define TMU (*(volatile struct TMU_tag *) 0x400CE000UL)
#define VIULite_0 (*(volatile struct VIULite_tag *) 0x40064000UL)
#define VIULite_1 (*(volatile struct VIULite_tag *) 0x400D0000UL)
#define VSEQ_CTRL_BLK (*(volatile struct VSEQ_CTRL_BLK_tag *) 0x7C021000UL)
#define VSEQ_EVT_CTRL (*(volatile struct VSEQ_EVT_CTRL_tag *) 0x7C022000UL)
#define VSEQ_INT_DMA (*(volatile struct VSEQ_INT_DMA_tag *) 0x7C024000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0x40063000UL)
#define XBIC (*(volatile struct XBIC_tag *) 0x40092000UL)
#define XRDC (*(volatile struct XRDC_tag *) 0x40004000UL)
#define uSDHC (*(volatile struct uSDHC_tag *) 0x4005D000UL)

/* AXBS */
#define AXBS_PRS0            AXBS.PORT[0].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS0            AXBS.PORT[0].CRS.R            /* Control Register */
#define AXBS_PRS1            AXBS.PORT[1].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS1            AXBS.PORT[1].CRS.R            /* Control Register */
#define AXBS_PRS2            AXBS.PORT[2].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS2            AXBS.PORT[2].CRS.R            /* Control Register */
#define AXBS_PRS3            AXBS.PORT[3].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS3            AXBS.PORT[3].CRS.R            /* Control Register */
#define AXBS_PRS4            AXBS.PORT[4].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS4            AXBS.PORT[4].CRS.R            /* Control Register */
#define AXBS_PRS5            AXBS.PORT[5].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS5            AXBS.PORT[5].CRS.R            /* Control Register */
#define AXBS_PRS6            AXBS.PORT[6].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS6            AXBS.PORT[6].CRS.R            /* Control Register */
#define AXBS_PRS7            AXBS.PORT[7].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS7            AXBS.PORT[7].CRS.R            /* Control Register */
#define AXBS_MGPCR0          AXBS.MGPCR[0].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR1          AXBS.MGPCR[1].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR2          AXBS.MGPCR[2].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR3          AXBS.MGPCR[3].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR4          AXBS.MGPCR[4].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR5          AXBS.MGPCR[5].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR6          AXBS.MGPCR[6].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR7          AXBS.MGPCR[7].MGPCR.R         /* Master General Purpose Control Register */

/* BCTRL */
#define BCTRL_BISTALL        BCTRL.BISTALL.R               /* BIST All register */
#define BCTRL_BSEL           BCTRL.BSEL.R                  /* BIST Select Register */
#define BCTRL_BIST_STAT      BCTRL.BIST_STAT.R             /* BIST Status register */

/* BIST */
#define BIST_MSR1            BIST.MSR[0].R                 /* Memory selection register */
#define BIST_MSR2            BIST.MSR[1].R                 /* Memory selection register */
#define BIST_MSR3            BIST.MSR[2].R                 /* Memory selection register */
#define BIST_MSR4            BIST.MSR[3].R                 /* Memory selection register */
#define BIST_MSR5            BIST.MSR[4].R                 /* Memory selection register */
#define BIST_MSR6            BIST.MSR[5].R                 /* Memory selection register */
#define BIST_MSR7            BIST.MSR[6].R                 /* Memory selection register */
#define BIST_MSR8            BIST.MSR[7].R                 /* Memory selection register */
#define BIST_BSTART          BIST.BSTART.R                 /* BIST start register */
#define BIST_BRST            BIST.BRST.R                   /* BIST reset register */
#define BIST_BSTAT           BIST.BSTAT.R                  /* BIST status register */
#define BIST_BFPM1           BIST.BFPM[0].R                /* BIST Fail Per Memory register */
#define BIST_BFPM2           BIST.BFPM[1].R                /* BIST Fail Per Memory register */
#define BIST_BFPM3           BIST.BFPM[2].R                /* BIST Fail Per Memory register */
#define BIST_BFPM4           BIST.BFPM[3].R                /* BIST Fail Per Memory register */
#define BIST_BFPM5           BIST.BFPM[4].R                /* BIST Fail Per Memory register */
#define BIST_BFPM6           BIST.BFPM[5].R                /* BIST Fail Per Memory register */
#define BIST_BFPM7           BIST.BFPM[6].R                /* BIST Fail Per Memory register */
#define BIST_BFPM8           BIST.BFPM[7].R                /* BIST Fail Per Memory register */
#define BIST_ROM_SEL         BIST.ROM_SEL.R                /* ROM Selection register */
#define BIST_ROM_STAT        BIST.ROM_STAT.R               /* ROM General Status register */
#define BIST_ADDR_DBG        BIST.ADDR_DBG.R               /* Address Debug register */
#define BIST_DBG1            BIST.DBG[0].R                 /* Data Debug register */
#define BIST_DBG2            BIST.DBG[1].R                 /* Data Debug register */
#define BIST_DBG3            BIST.DBG[2].R                 /* Data Debug register */
#define BIST_DBG4            BIST.DBG[3].R                 /* Data Debug register */
#define BIST_DBG5            BIST.DBG[4].R                 /* Data Debug register */
#define BIST_DBG6            BIST.DBG[5].R                 /* Data Debug register */
#define BIST_DBG7            BIST.DBG[6].R                 /* Data Debug register */
#define BIST_DBG8            BIST.DBG[7].R                 /* Data Debug register */
#define BIST_DBG9            BIST.DBG[8].R                 /* Data Debug register */
#define BIST_DBG10           BIST.DBG[9].R                 /* Data Debug register */
#define BIST_DBG11           BIST.DBG[10].R                /* Data Debug register */
#define BIST_DBG12           BIST.DBG[11].R                /* Data Debug register */
#define BIST_DBG13           BIST.DBG[12].R                /* Data Debug register */
#define BIST_DBG14           BIST.DBG[13].R                /* Data Debug register */
#define BIST_DBG15           BIST.DBG[14].R                /* Data Debug register */
#define BIST_DBG16           BIST.DBG[15].R                /* Data Debug register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CBT            CAN_1.CBT.R                   /* CAN Bit Timing Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */
#define CAN_1_FDCTRL         CAN_1.FDCTRL.R                /* CAN FD Control Register */
#define CAN_1_FDCBT          CAN_1.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_1_FDCRC          CAN_1.FDCRC.R                 /* CAN FD CRC Register */

/* CMU */
#define CMU_0_CSR            CMU_0.CSR.R                   /* CMU Control Status Register */
#define CMU_0_FDR            CMU_0.FDR.R                   /* CMU Frequency Display Register */
#define CMU_0_HFREFR         CMU_0.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_0_LFREFR         CMU_0.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_0_ISR            CMU_0.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_0_MDR            CMU_0.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_1_CSR            CMU_1.CSR.R                   /* CMU Control Status Register */
#define CMU_1_FDR            CMU_1.FDR.R                   /* CMU Frequency Display Register */
#define CMU_1_HFREFR         CMU_1.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_1_LFREFR         CMU_1.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_1_ISR            CMU_1.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_1_MDR            CMU_1.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_10_CSR           CMU_10.CSR.R                  /* CMU Control Status Register */
#define CMU_10_FDR           CMU_10.FDR.R                  /* CMU Frequency Display Register */
#define CMU_10_HFREFR        CMU_10.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_10_LFREFR        CMU_10.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_10_ISR           CMU_10.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_10_MDR           CMU_10.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_11_CSR           CMU_11.CSR.R                  /* CMU Control Status Register */
#define CMU_11_FDR           CMU_11.FDR.R                  /* CMU Frequency Display Register */
#define CMU_11_HFREFR        CMU_11.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_11_LFREFR        CMU_11.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_11_ISR           CMU_11.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_11_MDR           CMU_11.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_12_CSR           CMU_12.CSR.R                  /* CMU Control Status Register */
#define CMU_12_FDR           CMU_12.FDR.R                  /* CMU Frequency Display Register */
#define CMU_12_HFREFR        CMU_12.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_12_LFREFR        CMU_12.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_12_ISR           CMU_12.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_12_MDR           CMU_12.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_13_CSR           CMU_13.CSR.R                  /* CMU Control Status Register */
#define CMU_13_FDR           CMU_13.FDR.R                  /* CMU Frequency Display Register */
#define CMU_13_HFREFR        CMU_13.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_13_LFREFR        CMU_13.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_13_ISR           CMU_13.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_13_MDR           CMU_13.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_2_CSR            CMU_2.CSR.R                   /* CMU Control Status Register */
#define CMU_2_FDR            CMU_2.FDR.R                   /* CMU Frequency Display Register */
#define CMU_2_HFREFR         CMU_2.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_2_LFREFR         CMU_2.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_2_ISR            CMU_2.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_2_MDR            CMU_2.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_3_CSR            CMU_3.CSR.R                   /* CMU Control Status Register */
#define CMU_3_FDR            CMU_3.FDR.R                   /* CMU Frequency Display Register */
#define CMU_3_HFREFR         CMU_3.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_3_LFREFR         CMU_3.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_3_ISR            CMU_3.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_3_MDR            CMU_3.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_4_CSR            CMU_4.CSR.R                   /* CMU Control Status Register */
#define CMU_4_FDR            CMU_4.FDR.R                   /* CMU Frequency Display Register */
#define CMU_4_HFREFR         CMU_4.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_4_LFREFR         CMU_4.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_4_ISR            CMU_4.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_4_MDR            CMU_4.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_5_CSR            CMU_5.CSR.R                   /* CMU Control Status Register */
#define CMU_5_FDR            CMU_5.FDR.R                   /* CMU Frequency Display Register */
#define CMU_5_HFREFR         CMU_5.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_5_LFREFR         CMU_5.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_5_ISR            CMU_5.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_5_MDR            CMU_5.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_6_CSR            CMU_6.CSR.R                   /* CMU Control Status Register */
#define CMU_6_FDR            CMU_6.FDR.R                   /* CMU Frequency Display Register */
#define CMU_6_HFREFR         CMU_6.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_6_LFREFR         CMU_6.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_6_ISR            CMU_6.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_6_MDR            CMU_6.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_7_CSR            CMU_7.CSR.R                   /* CMU Control Status Register */
#define CMU_7_FDR            CMU_7.FDR.R                   /* CMU Frequency Display Register */
#define CMU_7_HFREFR         CMU_7.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_7_LFREFR         CMU_7.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_7_ISR            CMU_7.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_7_MDR            CMU_7.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_8_CSR            CMU_8.CSR.R                   /* CMU Control Status Register */
#define CMU_8_FDR            CMU_8.FDR.R                   /* CMU Frequency Display Register */
#define CMU_8_HFREFR         CMU_8.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_8_LFREFR         CMU_8.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_8_ISR            CMU_8.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_8_MDR            CMU_8.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_9_CSR            CMU_9.CSR.R                   /* CMU Control Status Register */
#define CMU_9_FDR            CMU_9.FDR.R                   /* CMU Frequency Display Register */
#define CMU_9_HFREFR         CMU_9.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_9_LFREFR         CMU_9.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_9_ISR            CMU_9.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_9_MDR            CMU_9.MDR.R                   /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG1           CRC_0.CFG1.R                  /* Configuration Register */
#define CRC_0_INP1           CRC_0.INP1.R                  /* Input Register */
#define CRC_0_CSTAT1         CRC_0.CSTAT1.R                /* Current Status Register */
#define CRC_0_OUTP1          CRC_0.OUTP1.R                 /* Output Register */
#define CRC_0_CFG2           CRC_0.MODE.CFG2.R             /* Configuration Register */
#define CRC_0_INP2           CRC_0.INP2.R                  /* Input Register */
#define CRC_0_CSTAT2         CRC_0.CSTAT2.R                /* Current Status Register */
#define CRC_0_OUTP2          CRC_0.OUTP2.R                 /* Output Register */
#define CRC_0_CFG3           CRC_0.CFG3.R                  /* Configuration Register */
#define CRC_0_INP3           CRC_0.INP3.R                  /* Input Register */
#define CRC_0_CSTAT3         CRC_0.CSTAT3.R                /* Current Status Register */
#define CRC_0_OUTP3          CRC_0.OUTP3.R                 /* Output Register */

#define CRC_1_CFG1           CRC_1.CFG1.R                  /* Configuration Register */
#define CRC_1_INP1           CRC_1.INP1.R                  /* Input Register */
#define CRC_1_CSTAT1         CRC_1.CSTAT1.R                /* Current Status Register */
#define CRC_1_OUTP1          CRC_1.OUTP1.R                 /* Output Register */
#define CRC_1_CFG2           CRC_1.MODE.CFG2.R             /* Configuration Register */
#define CRC_1_INP2           CRC_1.INP2.R                  /* Input Register */
#define CRC_1_CSTAT2         CRC_1.CSTAT2.R                /* Current Status Register */
#define CRC_1_OUTP2          CRC_1.OUTP2.R                 /* Output Register */
#define CRC_1_CFG3           CRC_1.CFG3.R                  /* Configuration Register */
#define CRC_1_INP3           CRC_1.INP3.R                  /* Input Register */
#define CRC_1_CSTAT3         CRC_1.CSTAT3.R                /* Current Status Register */
#define CRC_1_OUTP3          CRC_1.OUTP3.R                 /* Output Register */

/* CSE3 */
#define CSE3_CR              CSE3.CR.R                     /* Control Register */
#define CSE3_SR              CSE3.SR.R                     /* Status Register */
#define CSE3_IR              CSE3.IR.R                     /* Interrupt Register */
#define CSE3_ECR             CSE3.ECR.R                    /* Error Code Register */
#define CSE3_TRNG            CSE3.TRNG.R                   /* TRNG Control Register */
#define CSE3_CMD             CSE3.CMD.R                    /* Command Register */
#define CSE3_P1              CSE3.P[0].R                   /* Command Parameter Register */
#define CSE3_P2              CSE3.P[1].R                   /* Command Parameter Register */
#define CSE3_P3              CSE3.P[2].R                   /* Command Parameter Register */
#define CSE3_P4              CSE3.P[3].R                   /* Command Parameter Register */
#define CSE3_P5              CSE3.P[4].R                   /* Command Parameter Register */
#define CSE3_KIA0            CSE3.KIA[0].R                 /* Key Image Address Register */
#define CSE3_KIA1            CSE3.KIA[1].R                 /* Key Image Address Register */
#define CSE3_OTP             CSE3.OTP.R                    /* OTP Status Register */
#define CSE3_PC              CSE3.PC.R                     /* Publish Count Register */
#define CSE3_SRA0            CSE3.SRA0.R                   /* Secure RAM Address Register */
#define CSE3_SRS0            CSE3.SRS0.R                   /* Secure RAM Size Register */

/* DCU */
#define DCU_CTRLDESCCURSOR1  DCU.CTRLDESCCURSOR1.R         /* Control Descriptor Cursor 1 Register */
#define DCU_CTRLDESCCURSOR2  DCU.CTRLDESCCURSOR2.R         /* Control Descriptor Cursor 2 Register */
#define DCU_CTRLDESCCURSOR3  DCU.CTRLDESCCURSOR3.R         /* Control Descriptor Cursor 3 Register */
#define DCU_MODE             DCU.MODE.R                    /* Mode Register */
#define DCU_BGND             DCU.BGND.R                    /* Background Register */
#define DCU_DISP_SIZE        DCU.DISP_SIZE.R               /* Display Size Register */
#define DCU_HSYN_PARA        DCU.HSYN_PARA.R               /* Horizontal Sync Parameter Register */
#define DCU_VSYN_PARA        DCU.VSYN_PARA.R               /* Vertical Sync Parameter Register */
#define DCU_SYNPOL           DCU.SYNPOL.R                  /* Synchronize Polarity Register */
#define DCU_THRESHOLD        DCU.THRESHOLD.R               /* Threshold Register */
#define DCU_INT_STATUS       DCU.INT_STATUS.R              /* Interrupt Status Register */
#define DCU_INT_MASK         DCU.INT_MASK.R                /* Interrupt Mask Register */
#define DCU_COLBAR_1         DCU.COLBAR_1.R                /* COLBAR_1 Register */
#define DCU_COLBAR_2         DCU.COLBAR_2.R                /* COLBAR_2 Register */
#define DCU_COLBAR_3         DCU.COLBAR_3.R                /* COLBAR_3 Register */
#define DCU_COLBAR_4         DCU.COLBAR_4.R                /* COLBAR_4 Register */
#define DCU_COLBAR_5         DCU.COLBAR_5.R                /* COLBAR_5 Register */
#define DCU_COLBAR_6         DCU.COLBAR_6.R                /* COLBAR_6 Register */
#define DCU_COLBAR_7         DCU.COLBAR_7.R                /* COLBAR_7 Register */
#define DCU_COLBAR_8         DCU.COLBAR_8.R                /* COLBAR_8 Register */
#define DCU_DIV_RATIO        DCU.DIV_RATIO.R               /* Divide Ratio Register */
#define DCU_SIGN_CALC_1      DCU.SIGN_CALC_1.R             /* Sign Calculation 1 Register */
#define DCU_SIGN_CALC_2      DCU.SIGN_CALC_2.R             /* Sign Calculation 2 Register */
#define DCU_CRC_VAL          DCU.CRC_VAL.R                 /* CRC Value Register */
#define DCU_PARR_ERR_STATUS1 DCU.PARR_ERR_STATUS1.R        /* Parameter Error Status 1 Register */
#define DCU_PARR_ERR_STATUS3 DCU.PARR_ERR_STATUS3.R        /* Parameter Error Status 3 Register */
#define DCU_MASK_PARR_ERR_STATUS1 DCU.MASK_PARR_ERR_STATUS1.R /* Mask Parameter Error Status 1 Register */
#define DCU_MASK_PARR_ERR_STATUS3 DCU.MASK_PARR_ERR_STATUS3.R /* Mask Parameter Error Status 3 Register */
#define DCU_THRESHOLD_INP_BUF_1 DCU.THRESHOLD_INP_BUF_1.R  /* Threshold Input 1 Register */
#define DCU_LUMA_COMP        DCU.LUMA_COMP.R               /* LUMA Component Register */
#define DCU_CHROMA_RED       DCU.CHROMA_RED.R              /* Red Chroma Components Register */
#define DCU_CHROMA_GREEN     DCU.CHROMA_GREEN.R            /* Green Chroma Components Register */
#define DCU_CHROMA_BLUE      DCU.CHROMA_BLUE.R             /* Blue Chroma Components Register */
#define DCU_CRC_POS          DCU.CRC_POS.R                 /* CRC Position Register */
#define DCU_LYR_INTPOL_EN    DCU.LYR_INTPOL_EN.R           /* Layer Interpolation Enable Register */
#define DCU_LYR_LUMA_COMP    DCU.LYR_LUMA_COMP.R           /* Layer Luminance Component Register */
#define DCU_LYR_CHRM_RED     DCU.LYR_CHRM_RED.R            /* Layer Chroma Red Register */
#define DCU_LYR_CHRM_GRN     DCU.LYR_CHRM_GRN.R            /* Layer Chroma Green Register */
#define DCU_LYR_CHRM_BLUE    DCU.LYR_CHRM_BLUE.R           /* Layer Chroma Blue Register */
#define DCU_UPDATE_MODE      DCU.UPDATE_MODE.R             /* Update Mode Register */
#define DCU_UNDERRUN         DCU.UNDERRUN.R                /* Underrun Register */
#define DCU_FRM_CRC_CTRL     DCU.FRM_CRC_CTRL.R            /* Frame CRC Control */
#define DCU_FRM_CRC_VAL      DCU.FRM_CRC_VAL.R             /* Frame CRC Value */
#define DCU_TX_ESCAL_LVL     DCU.TX_ESCAL_LVL.R            /* QoS Level */
#define DCU_GPR              DCU.GPR.R                     /* Global Protection Register */
#define DCU_SLR_L0           DCU.SLR_L0.R                  /* Soft Lock Bit Layer 0 Register */
#define DCU_SLR_L1           DCU.SLR_L1.R                  /* Soft Lock Bit Layer 1 Register */
#define DCU_SLR_DISP_SIZE    DCU.SLR_DISP_SIZE.R           /* Soft Lock Display Size Register */
#define DCU_SLR_HVSYNC_PARA  DCU.SLR_HVSYNC_PARA.R         /* Soft Lock Hsync/Vsync Parameter Reg