/*========================================================================*
*                          Copyright 2018 NXP.
* This software is owned or controlled by NXP and may only be used strictly
* in accordance with the applicable license terms. By expressly accepting
* such terms or by downloading, installing, activating and/or otherwise
* using the software, you are agreeing that you have read, and that you
* agree to comply with and are bound by, such license terms. If you do not
* agree to be bound by the applicable license terms, then you may not retain,
* install, activate or otherwise use the software.
*
 **************************************************************************/
/*
 * main implementation: use this 'C' sample to create your own application
 *
 */

#include "S32V234.h"  /* include peripheral declarations */
#include "init.h"
#include "linflex_serial.h"

int main(void)
{
	//Init Peripheral Clocks
	mode_init();
	pll_init();     // setup clocks for UART 

	LinFlex0_Init();

	// print "M4" on the terminal
	sci_0_putchar(0x4D);
	sci_0_putchar(0x34);
	sci_0_putchar(0xA);
	sci_0_putchar(0xD);

#define COUNTER_LIMIT 100

	int counter = 0;

	for(;;) {
		counter++;

		if(counter > COUNTER_LIMIT) {
			counter = 0;
		}
	}
    
	return 0;
}
