/*========================================================================*
*                          Copyright 2018 NXP.
* This software is owned or controlled by NXP and may only be used strictly
* in accordance with the applicable license terms. By expressly accepting
* such terms or by downloading, installing, activating and/or otherwise
* using the software, you are agreeing that you have read, and that you
* agree to comply with and are bound by, such license terms. If you do not
* agree to be bound by the applicable license terms, then you may not retain,
* install, activate or otherwise use the software.
*
 **************************************************************************/

/*
 * init.c
 *
 *  Created on: 13 Jan 2018
 *      Author: justi
 */


#include "init.h"
#include "S32V234.h"

#define NOT_USED_CLOCK


void mode_enter(uint16_t mode)
{
	INTERNAL_MC_ME.MCTL.R = (mode << 28 | 0x00005AF0);
	INTERNAL_MC_ME.MCTL.R = (mode << 28 | 0x0000A50F);
  // wait while mode entry is in process
  while(INTERNAL_MC_ME.GS.B.S_MTRANS == 1);
  // check if the mode has been entered
  while(INTERNAL_MC_ME.GS.B.S_CURRENT_MODE != mode);
}


void mode_init(void)
{
  // mode settings
  peripherals_clock_enable(); // Sets all peripherals to PC7

  INTERNAL_MC_ME.ME.R |= 0xFF;         // enable all the modes
  INTERNAL_MC_ME.RUN_PC[7].R = 0x000000FF;	// enable all peripherals to be active during all modes except of RESET

  // FIRC is sysclk for DRUN and RUN0
  INTERNAL_MC_ME.DRUN_MC.B.SYSCLK = 0x0000;	// system clk is FIRC

  // re-enter DRUN mode to update settings
  mode_enter(DRUN_M);

  // XOSC settings
  INTERNAL_FXOSC.CTL.B.EOCV   = 0xA0;    	// XOSC end of count value - 2ms delay
  INTERNAL_FXOSC.CTL.B.OSCBYP = 0x0;		// bypass off
  INTERNAL_FXOSC.CTL.B.GM_SEL = 0x7;		// crystal overdrive protection 1x
  //FXOSC.CTL.R = 0x00A00070;

  // switch XOSC as sysclk in DRUN
  INTERNAL_MC_ME.DRUN_MC.B.FXOSCON = 1;	//switch on external oscilator
  mode_enter(DRUN_M);
  while(INTERNAL_MC_ME.GS.B.S_FXOSC == 0);	//wait until the external oscilator is stabilized
  INTERNAL_MC_ME.DRUN_MC.B.SYSCLK = 0x0001;	//system clk is XOSC
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK1 =1; //xosc as system clock1
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK2 =1; //xosc as system clock2
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK3 =1; //xosc as system clock3

  mode_enter(DRUN_M);

  INTERNAL_MC_ME.CCTL0.B.DRUN =1;
  INTERNAL_MC_ME.CCTL0.B.RUN0 =1;
  INTERNAL_MC_ME.CCTL0.B.RUN1 =1;
  INTERNAL_MC_ME.CCTL0.B.RUN2 =1;
  INTERNAL_MC_ME.CCTL0.B.RUN3 =1;
  INTERNAL_MC_ME.CADDR0.R = 0x3e800000;
  mode_enter(DRUN_M);
}

void pll_init(void)
{

  ////////////////////////////////////////////////////////
  ///////////////////////// ARM PLL///////////////////////
  ////////////////////////////////////////////////////////
  // PHI 0 output f = 1000 MHz, PHI1 output f = 1000 MHz//
  ////////////////////////////////////////////////////////
	INTERNAL_DFS_0.CTRL.R = 0x2; // Assert DLL Reset
	INTERNAL_DFS_0.PORTRESET.R = 0xf; // Assert Port Reset

  // at first set SRC register to select input clk for PLL block: (0 FIRC selected, 1 XOSC selected)
	INTERNAL_SRC.GPR1.B.ARM_PLL_SOURCE_SELECT = 1;// XOSC selected as input to ARM_PLL - Already set by BootROM, but Whatevs
  *(vuint32_t *) 0x4003c03c = 0x2b;  //cal2            these are not in RM
  *(vuint32_t *) 0x4003c038 = 0x44000000;  //cal1      these are not in RM

  // configure PLLDIG registers
  INTERNAL_PLLDIG_0.PLLDV.B.RFDPHI1 = 1;
  INTERNAL_PLLDIG_0.PLLDV.B.RFDPHI = 1;
  INTERNAL_PLLDIG_0.PLLDV.B.PREDIV = 1;	// input clock predivider, divided by 1
  INTERNAL_PLLDIG_0.PLLDV.B.MFD = 25;	// Loop multiplication factor divider - 40 * 25 = 1000
  //*((vuint32_t*)(0x4003c028)) = 0x02011019;

  INTERNAL_PLLDIG_0.PLLFD.B.SMDEN = 1;		// sigma-delta modulation enabled
  INTERNAL_PLLDIG_0.PLLFD.B.MFN = 0;		// numerator for fractional loop division factor
  //*((vuint32_t*)(0x4003c030)) = 0x70000000;

  mode_enter(DRUN_M);
  INTERNAL_MC_ME.DRUN_MC.B.ARMPLLON= 1;  //switch on ARM PLL
  mode_enter(DRUN_M);

  // DFS settings (DFS0 base adress = 0x4003c40)
  INTERNAL_DFS_0.DLLPRG1.R = 0x00005445;
  //DFS_0.DLLPRG2.R =0x0000; // NOT LISTED In THE RM - Remove!!

  // Only enable CLKOUT for
  // This may not be writable
  // DFS_0.CLKOUTEN.B.CLKOUTEN = 0; // All disabled

//  DFS_0.DVPORT[0].B.MFN = 0;
//  DFS_0.DVPORT[0].B.MFI = 2;  // Straight up Divide by 2 to get DFS 0 = 133MHZ

  //
  // fdfsclkoutn = fdfsclkinn / (DFS_DVPORTn[MFI] + (DFS_DVPORTn[MFN] / 256))
  //
  INTERNAL_DFS_0.DVPORT[0].B.MFN = 194;
  INTERNAL_DFS_0.DVPORT[0].B.MFI = 3;        //    DFS0_DVPORT1: MFN = 194, MFI = 3, fdfs1out = 266

#if 0 // We Prefer not to generate the 600MHz clock for the GPU if it's not used
  INTERNAL_DFS_0.DVPORT[1].B.MFN = 170;
  INTERNAL_DFS_0.DVPORT[1].B.MFI = 1;

  INTERNAL_DFS_0.DVPORT[2].B.MFN = 170;
  INTERNAL_DFS_0.DVPORT[2].B.MFI = 1;
#endif

  INTERNAL_DFS_0.CTRL.R &= 0xfffffffD;		//    DFS0_CTRL reset is not asserted

  //DFS_0.PORTRESET.R &= 0xfffffff8; // dfS out 0, 1 & 2
  INTERNAL_DFS_0.PORTRESET.R &= 0xfffffffe; // ONLY Port 0 out of reset

  //while(DFS_0.PORTSR.R != 0x7);	//DFS0_PORTSR port status register - wait until DVPORT 1-3 are locked
  while(INTERNAL_DFS_0.PORTSR.R != 0x1); // Only poll PORT 0

  // note: PLL_DFS1 is selected in DRUN_MC in bitfield SYSCLK
  //all other selectors are set in DRUN Secondary Clock Configuration Register (DFS2, DFS3, ARM PLL)
  //MC_ME.DRUN_SEC_CC_I.R = 0x00002220;	// system clock selection, ARMPLL outputs selected as input clock in all 4 blocks

  //
  // we have disabled DFS2 and DFS3 so SYS CLOCK 2 & 3 must be from a different source ( FXOSC )
  //
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK1 = 2; // ARM PLL as system clock1
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK2 = 1; // FXOSC as system clock 2 ( DFS2 disabled )
  INTERNAL_MC_ME.DRUN_SEC_CC_I.B.SYSCLK3 = 1; // FXOSC as system clock 3 ( DFS3 disabled )

//  // MC_CGM 0 SC Dividers
//  MC_CGM_0.SC_DC1.B.DE  = 1;
//  MC_CGM_0.SC_DC1.B.DIV = 1; // DIVIDE By 2 to produce SYS6_CLK = 133MHz

  INTERNAL_MC_ME.DRUN_MC.B.ARMPLLON = 1;
  mode_enter(DRUN_M);
  while(INTERNAL_MC_ME.GS.B.S_ARMPLL != 1);

  // switch ARM_PLL as sysclk
  INTERNAL_MC_ME.DRUN_MC.B.SYSCLK = 0x0002;	// system clk is ARM_PLL
  mode_enter(DRUN_M);
  while(INTERNAL_MC_ME.GS.B.S_SYSCLK != 2);


   //////////////////////////////////////////////////////
   ///////////////////////// PERIPH PLL//////////////////
   //////////////////////////////////////////////////////
   // PHI 0 output f = 400 MHz, PHI1 output f = 100 MHz//
   //////////////////////////////////////////////////////
   // at first set SRC register to select input clk for PLL block: (0 FIRC selected, 1 XOSC selected)
  INTERNAL_SRC.GPR1.B.PERIPH_PLL_SOURCE_SELECT = 1;// XOSC selected as input to PERIPH_PLL
   // configure PLLDIG registers
  INTERNAL_PLLDIG_1.PLLDV.B.RFDPHI1 = 12;
  INTERNAL_PLLDIG_1.PLLDV.B.RFDPHI = 3;
  INTERNAL_PLLDIG_1.PLLDV.B.PREDIV = 1;	// input clock predivider, divided by 1
  INTERNAL_PLLDIG_1.PLLDV.B.MFD = 30;	// Loop multiplication factor divider
   //  *((vuint32_t*)(0x4003c0A8)) = 0x1803101E;

  INTERNAL_PLLDIG_1.PLLFD.B.SMDEN = 1;		// sigma-delta modulation enabled
  INTERNAL_PLLDIG_1.PLLFD.B.MFN = 0;		// numerator for fractional loop division factor
   //*((vuint32_t*)(0x4003c0b0)) = 0x70000000;

   // switch on PERIPH_PLL
  INTERNAL_MC_ME.DRUN_MC.B.PERIPHPLLON = 1;
   mode_enter(DRUN_M);
   while(INTERNAL_MC_ME.GS.B.S_PERIPHPLL != 1);


   // MC_CGM 0 AUX registers
   INTERNAL_MC_CGM_0.AC3_DC0.B.DE = 0;		    // need to switch to 0 to avoid clock glitch
   INTERNAL_MC_CGM_0.AC3_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is LIN_CLK = 133 MHz
   INTERNAL_MC_CGM_0.AC3_SC.B.SELCTL = 8;	    // AC3 clock source selection - SYS6_CLK 133 MHz
   INTERNAL_MC_CGM_0.AC3_DC0.B.DE = 1;			//divider enable(1)/disable(0)


   INTERNAL_MC_CGM_0.AC5_DC0.B.DE = 0;			//divider enable(1)/disable(0)
   INTERNAL_MC_CGM_0.AC5_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is PERI_CLK = 80 MHz
   INTERNAL_MC_CGM_0.AC5_DC1.B.DE = 0;			//divider enable(1)/disable(0)
   INTERNAL_MC_CGM_0.AC5_DC1.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is FRAY_PLL_CLK = 80 MHz
   INTERNAL_MC_CGM_0.AC5_SC.B.SELCTL = 3;	    // AC5 clock source selection - PERIPH_PLL_PHI0/5
   INTERNAL_MC_CGM_0.AC5_DC0.B.DE = 1;			//divider enable(1)/disable(0)
   INTERNAL_MC_CGM_0.AC5_DC1.B.DE = 1;			//divider enable(1)/disable(0)


#ifndef NOT_USED_CLOCK  // Not used these
   INTERNAL_MC_CGM_0.AC6_DC0.B.DE = 0;			//divider enable(1)/disable(0)
   INTERNAL_MC_CGM_0.AC6_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is CAN_CLK = 80 MHz
   INTERNAL_MC_CGM_0.AC6_SC.B.SELCTL = 3;	// AC6 clock source selection - PERIPH_PLL_PHI0/5
   INTERNAL_MC_CGM_0.AC6_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    // MC_CGM 2 AUX registers
   INTERNAL_MC_CGM_2.AC0_DC0.B.DE = 0;			//divider enable(1)/disable(0)
   INTERNAL_MC_CGM_2.AC0_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is DIGRF_PLL_CLK = 26 MHz
   INTERNAL_MC_CGM_2.AC0_SC.B.SELCTL = 7;	// AC0 clock source selection - external pad clock source 26 MHz
   INTERNAL_MC_CGM_2.AC0_DC0.B.DE = 1;			//divider enable(1)/disable(0)
#endif

    mode_enter(DRUN_M);


#ifndef NOT_USED_CLOCK
    // All other clocks are disabled here for not being used
    //////////////////////////////////////////////////////
    ///////////////////////// ENET PLL////////////////////
    //////////////////////////////////////////////////////
    // PHI 0 output f = 500 MHz, PHI1 output f = 1000 MHz//
    //////////////////////////////////////////////////////

    // at first set SRC register to select input clk for PLL block: (0 FIRC selected, 1 XOSC selected)
    SRC.GPR1.B.ENET_PLL_SOURCE_SELECT = 1;// XOSC selected as input to ENET_PLL

    // configure PLLDIG registers
    PLLDIG_2.PLLDV.B.RFDPHI1 = 1;
    PLLDIG_2.PLLDV.B.RFDPHI = 2;
    PLLDIG_2.PLLDV.B.PREDIV = 1;	// input clock predivider, divided by 1
    PLLDIG_2.PLLDV.B.MFD = 25;	// Loop multiplication factor divider
       // *((vuint32_t*)(0x4003c128)) = 0x02021019;

    PLLDIG_2.PLLFD.B.SMDEN = 1;		// sigma-delta modulation enabled
    PLLDIG_2.PLLFD.B.MFN = 0;	// numerator for fractional loop division factor
     //   *((vuint32_t*)(0x4003c130)) = 0x70000000;

    // switch on ENET_PLL
    MC_ME.DRUN_MC.B.ENETPLLON= 1;		//switch on ENET PLL
    mode_enter(DRUN_M);

//was commented out
    DFS_1.DLLPRG1.R =0x00005445;
    DFS_1.DLLPRG2.R =0x0000;

    // DFS settings
    DFS_1.DVPORT[0].B.MFN = 219;
    DFS_1.DVPORT[0].B.MFI = 2;
    //*((vuint32_t*)(0x4003c15c)) = 0x000002DB;     	//    DFS2_DVPORT1: MFN = 219, MFI = 2, fdfs1out = 350
    DFS_1.DVPORT[1].B.MFN = 219;
    DFS_1.DVPORT[1].B.MFI = 2;
    //*((vuint32_t*)(0x4003c160)) = 0x000002DB;       	//    DFS2_DVPORT2: MFN = 219, MFI = 2, fdfs2out = 350
    DFS_1.DVPORT[2].B.MFN = 32;
    DFS_1.DVPORT[2].B.MFI = 3;
    //*((vuint32_t*)(0x4003c164)) = 0x00000320; 		//    DFS2_DVPORT3: MFN = 32, MFI = 3, fdfs3out = 320
    DFS_1.DVPORT[3].B.MFN = 156;
    DFS_1.DVPORT[3].B.MFI = 9;
    //*((vuint32_t*)(0x4003c168)) = 0x0000099C;		//    DFS2_DVPORT4: MFN = 156, MFI = 9 fdfs4out = 104
    DFS_1.CTRL.R &= (~2);		//    DFS0_CTRL reset is not asserted
    //*((vuint32_t*)(0x4003c158)) &= (~2);		//    DFS2_CTRL reset is not asserted
    DFS_1.PORTRESET.R &= (~15);		//    DFS0_PORTRESET bits 0 - 3 are out of reset
    //*((vuint32_t*)(0x4003c154)) &= (~15);		//    DFS2_PORTRESET bits 0 - 3 are out of reset

       while(DFS_1.PORTSR.R != 0xF);	//DFS0_PORTSR port status register - wait until DVPORT 1-4 are locked

 // MC_CGM 0 AUX registers
    MC_CGM_0.AC7_DC1.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC7_DC1.B.DIV = 3;			//divided by 4 (1 + DIV) - resultant output clk is ENET_TIME_CLK = 125 MHz
    MC_CGM_0.AC7_SC.B.SELCTL = 4;	// AC7 clock source selection - ENET_PLL_PHI0
    MC_CGM_0.AC7_DC1.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC12_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC12_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is H264_DEC_CLK = 350 MHz
    MC_CGM_0.AC12_SC.B.SELCTL = 4;	// AC12 clock source selection - ENET_PLL_DFS1
    MC_CGM_0.AC12_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC13_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC13_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is H264_ENC_CLK = 350 MHz
    MC_CGM_0.AC13_SC.B.SELCTL = 4;	// AC13 clock source selection - ENET_PLL_DFS2
    MC_CGM_0.AC13_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC14_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC14_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is QSPI_CLK = 320 MHz
    MC_CGM_0.AC14_SC.B.SELCTL = 4;	// AC14 clock source selection - ENET_PLL_DFS3
    MC_CGM_0.AC14_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC15_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC15_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is H264_DEC_CLK = 104 MHz
    MC_CGM_0.AC15_SC.B.SELCTL = 4;	// AC15 clock source selection - ENET_PLL_DFS4
    MC_CGM_0.AC15_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_2.AC2_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_2.AC2_DC0.B.DIV = 3;			//divided by 4 (1 + DIV) - resultant output clk is ENET_CLK = 125 MHz
    MC_CGM_2.AC2_SC.B.SELCTL = 4;	// AC2 clock source selection - ENET_PLL_PHI0
    MC_CGM_2.AC2_DC0.B.DE = 1;

 MC_ME.DRUN_MC.B.ENETPLLON  = 1;

    mode_enter(DRUN_M);
        while(MC_ME.GS.B.S_ENETPLL != 1);

    ///////////////////////////////////////////////////////
    ///////////////////////// DDR PLL//////////////////////
    ///////////////////////////////////////////////////////
    // PHI 0 output f = 533 MHz, PHI1 output f = 1066 MHz//
    ///////////////////////////////////////////////////////
    // at first set SRC register to select input clk for PLL block: (0 FIRC selected, 1 XOSC selected)
    SRC.GPR1.B.DDR_PLL_SOURCE_SELECT = 1;// XOSC selected as input to DDR_PLL

      // configure PLLDIG registers
    PLLDIG_3.PLLDV.B.RFDPHI1 = 1;
    PLLDIG_3.PLLDV.B.RFDPHI = 2;
    PLLDIG_3.PLLDV.B.PREDIV = 1;	// input clock predivider, divided by 1
    PLLDIG_3.PLLDV.B.MFD = 26;	// Loop multiplication factor divider
       //*((vuint32_t*)(0x4003C1A8)) = 0x0202101A;

    PLLDIG_3.PLLFD.B.SMDEN = 1;		// sigma-delta modulation enabled
    PLLDIG_3.PLLFD.B.MFN = 13312;	// numerator for fractional loop division factor
       //*((vuint32_t*)(0x4003c1b0)) = 0x70003400;         //nesedi uplne presne - frekvence je 1053 MHz a ne 1066

    // switch on DDR_PLL
    MC_ME.DRUN_MC.B.DDRPLLON = 1;
    mode_enter(DRUN_M);

    DFS_2.DLLPRG1.R =0x00005445;
    DFS_2.DLLPRG2.R =0x0000;

    // DFS settings
    DFS_2.DVPORT[0].B.MFN = 33;
    DFS_2.DVPORT[0].B.MFI = 2;
   // *((vuint32_t*)(0x4003C1DC)) = 0x00000221;     	//    DFS3_DVPORT1: MFN = 33, MFI = 2, fdfs1out = 500
    DFS_2.DVPORT[1].B.MFN = 33;
    DFS_2.DVPORT[1].B.MFI = 2;
    //*((vuint32_t*)(0x4003c1e0)) = 0x00000221;       	//    DFS3_DVPORT2: MFN = 33, MFI = 2, fdfs2out = 500
    DFS_2.DVPORT[0].B.MFN = 11;
    DFS_2.DVPORT[0].B.MFI = 3;
   // *((vuint32_t*)(0x4003c1e4)) = 0x0000030b; 		//    DFS3_DVPORT3: MFN1 = 11, MFI1 = 3, fdfs3out = 350
    DFS_2.CTRL.R &= (~2);		//    DFS0_CTRL reset is not asserted
    //*((vuint32_t*)(0x4003c1d8)) &= (~2);	//    DFS3_CTRL reset is not asserted
    DFS_2.PORTRESET.R &= (~7);		//    DFS0_PORTRESET bits 0 - 2 are out of reset
    //*((vuint32_t*)(0x4003c1d4)) &= (~7);	//    DFS3_PORTRESET bits 0 - 3 are out of reset
    MC_ME.DRUN_MC.B.DDRPLLON = 1;
    mode_enter(DRUN_M);
    mode_enter(DRUN_M);
    for(i=0;i<100000;i++);
    while(MC_ME.GS.B.S_DDRPLL != 1)

       while(DFS_2.PORTSR.R != 0x7);	//DFS0_PORTSR port status register - wait until DVPORT 1-3 are locked, port 4 is not

	// MC_CGM 0 AUX registers
    MC_CGM_0.AC0_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC0_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is ISP_CLK = 500 MHz
    MC_CGM_0.AC0_SC.B.SELCTL = 5;	// AC0 clock source selection - DDR_PLL_DFS1
    MC_CGM_0.AC0_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC1_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC1_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is APEX_APU_CLK = 500 MHz
    MC_CGM_0.AC1_SC.B.SELCTL = 5;	// AC1 clock source selection - DDR_PLL_DFS2
    MC_CGM_0.AC1_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC2_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC2_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is MJEPEG_CLK = 500 MHz
    MC_CGM_0.AC2_SC.B.SELCTL = 5;	// AC2 clock source selection - DDR_PLL_DFS3
    MC_CGM_0.AC2_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC8_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC8_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is DDR_CLK = 533 MHz
    MC_CGM_0.AC8_DC1.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC8_DC1.B.DIV = 3;			//divided by 4 (1 + DIV) - resultant output clk is DDR4_CLK = 133,25 MHz
    MC_CGM_0.AC8_SC.B.SELCTL = 5;	// AC8 clock source selection - DDR_PLL_PHI0
    MC_CGM_0.AC8_DC0.B.DE = 1;			//divider enable(1)/disable(0)
    MC_CGM_0.AC8_DC1.B.DE = 1;			//divider enable(1)/disable(0)

    MC_ME.DRUN_MC.B.DDRPLLON = 1;
    mode_enter(DRUN_M);
    mode_enter(DRUN_M);
    for(i=0;i<100000;i++);
    while(MC_ME.GS.B.S_DDRPLL != 1)

 for(i=0;i<100000;i++);
    i=5;

    ////////////////////////////////////////////////////
    ///////////////////////// VIDEO PLL/////////////////
    ////////////////////////////////////////////////////
    //////////// PHI 0 output f = 600 MHz///////////////
    ////////////////////////////////////////////////////

    // at first set SRC register to select input clk for PLL block: (0 FIRC selected, 1 XOSC selected)
    SRC.GPR1.B.VIDEO_PLL_SOURCE_SELECT = 1;// XOSC selected as input to VIDEO_PLL

//PLLDIG_4.PLLCAL3.R=0x14000000; // validation team using it but this register is not in RM!
    *((vuint32_t*)(0x4003c218)) = 0x14000000;
    // configure PLLDIG registers
    PLLDIG_4.PLLDV.B.RFDPHI1 = 0;	// PHI1 output NA
    PLLDIG_4.PLLDV.B.RFDPHI = 2;
    PLLDIG_4.PLLDV.B.PREDIV = 1;	// input clock predivider, divided by 1
    PLLDIG_4.PLLDV.B.MFD = 30;	// Loop multiplication factor divider
       //*((vuint32_t*)(0x4003c228)) = 0x0002101e;

  //     PLLDIG_4.PLLFD.B.SMDEN = 1;		// sigma-delta modulation enabled
  //     PLLDIG_4.PLLFD.B.MFN = 0;	//FRCDIV value - numerator for fractional loop division factor
        *((vuint32_t*)(0x4003c230)) = 0x70000000;

    // switch on VIDEO_PLL
    MC_ME.DRUN_MC.B.VIDEOPLLON = 1;		//switch on VIDEO_PLL
    mode_enter(DRUN_M);
    while(MC_ME.GS.B.S_VIDEOPLL != 1);

	// MC_CGM 0 AUX registers
    MC_CGM_0.AC9_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC9_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is DCU_AXI_CLK = 300 MHz
    MC_CGM_0.AC9_DC1.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC9_DC1.B.DIV = 1;			//divided by 2 (1 + DIV) - resultant output clk is DCU_PIX_CLK = 150 MHz
    MC_CGM_0.AC9_SC.B.SELCTL = 9;	// AC9 clock source selection - VIDEO_PLL/2
    MC_CGM_0.AC9_DC0.B.DE = 1;			//divider enable(1)/disable(0)
    MC_CGM_0.AC9_DC1.B.DE = 1;			//divider enable(1)/disable(0)

	// MC_CGM 2 AUX registers
    MC_CGM_2.AC4_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_2.AC4_DC0.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is TRACECLK = 300 MHz
    MC_CGM_2.AC4_SC.B.SELCTL = 9;	// AC4 clock source selection - VIDEO_PLL/2
    MC_CGM_2.AC4_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    mode_enter(DRUN_M);

	// remaining AUX registers

	// MC_CGM 0 AUX registers
    MC_CGM_0.AC4_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC4_DC0.B.DIV = 3;			//divided by 4 (1 + DIV) - resultant output clk is FLEXTIMER0_EXT_CLK = 20 MHz
    MC_CGM_0.AC4_SC.B.SELCTL = 0xA;	// AC4 clock source selection - PERI_CLK 80 MHz
    MC_CGM_0.AC4_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC10_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC10_DC0.B.DIV = 7;			//divided by 8 (1 + DIV) - resultant output clk is CLK_OUT = 20 MHz
    MC_CGM_0.AC10_DC1.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC10_DC1.B.DIV = 0;			//divided by 1 (1 + DIV) - resultant output clk is LBIST_FAST_CLK = 400 MHz
    MC_CGM_0.AC10_SC.B.SELCTL = 3;	// AC10 clock source selection - PERIPH_PLL_PHI0 400 MHz
    MC_CGM_0.AC10_DC0.B.DE = 1;			//divider enable(1)/disable(0)
    MC_CGM_0.AC10_DC1.B.DE = 1;			//divider enable(1)/disable(0)

    MC_CGM_0.AC11_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_0.AC11_DC0.B.DIV = 0;		//divided by 1 (1 + DIV) - resultant output clk is DDR_32KHZ_CLK = 32 kHz
    MC_CGM_0.AC11_SC.B.SELCTL = 1;	// AC11 clock source selection - XOSC_32KHz
    MC_CGM_0.AC11_DC0.B.DE = 1;			//divider enable(1)/disable(0)

	// MC_CGM 2 AUX registers
    MC_CGM_2.AC3_DC0.B.DE = 0;			//divider enable(1)/disable(0)
    MC_CGM_2.AC3_DC0.B.DIV = 3;			//divided by 4 (1 + DIV) - resultant output clk is FLEXTIMER1_EXT_CLK = 20 MHz
    MC_CGM_2.AC3_SC.B.SELCTL = 10;	// AC4 clock source selection - PERI_CLK 80 MHz
    MC_CGM_2.AC3_DC0.B.DE = 1;			//divider enable(1)/disable(0)

    mode_enter(DRUN_M);
#endif
}

//
// DOES ACTUALLY ENABLE PERIPHERAL CLOCKS
// ONLY ASSIGNS THEM TO PC7
//
void peripherals_clock_enable(void)
{
	INTERNAL_MC_ME.PCTL39.R  = 0x7; // DEC200
	INTERNAL_MC_ME.PCTL40.R  = 0x7; // 2D-ACE - DCU
	INTERNAL_MC_ME.PCTL48.R  = 0x7; // CSI0
	INTERNAL_MC_ME.PCTL49.R  = 0x7; // DMAMUX0
	INTERNAL_MC_ME.PCTL50.R  = 0x7; // ENET
	INTERNAL_MC_ME.PCTL52.R  = 0x7; // FlexRay
  INTERNAL_MC_ME.PCTL54.R  = 0x7; // MMDC0
  INTERNAL_MC_ME.PCTL58.R  = 0x7; // PIT0
  INTERNAL_MC_ME.PCTL77.R  = 0x7; // SARADC0
  INTERNAL_MC_ME.PCTL79.R  = 0x7; // FlexTimer0
  INTERNAL_MC_ME.PCTL81.R  = 0x7; // I2C0
  INTERNAL_MC_ME.PCTL83.R  = 0x7; // LinFlex0
  INTERNAL_MC_ME.PCTL85.R  = 0x7; // CANFD0
  INTERNAL_MC_ME.PCTL87.R  = 0x7; // SPI0
  INTERNAL_MC_ME.PCTL89.R  = 0x7; // SPI2
  INTERNAL_MC_ME.PCTL91.R  = 0x7; // CRC0
  INTERNAL_MC_ME.PCTL93.R  = 0x7; // SDHC
  INTERNAL_MC_ME.PCTL100.R = 0x7; // VIU0
  INTERNAL_MC_ME.PCTL104.R = 0x7; // HPSMI
  INTERNAL_MC_ME.PCTL116.R = 0x7; // SPI1
  INTERNAL_MC_ME.PCTL120.R = 0x7; // LFAST
  INTERNAL_MC_ME.PCTL160.R = 0x7; // CSI1
  INTERNAL_MC_ME.PCTL161.R = 0x7; // DMAMUX1
  INTERNAL_MC_ME.PCTL162.R = 0x7; // MMDC1
  INTERNAL_MC_ME.PCTL166.R = 0x7; // QSPI0
  INTERNAL_MC_ME.PCTL170.R = 0x7; // PIT1
  INTERNAL_MC_ME.PCTL182.R = 0x7; // FlexTimer1
  INTERNAL_MC_ME.PCTL184.R = 0x7; // I2C1
  INTERNAL_MC_ME.PCTL186.R = 0x7; // I2C2
  INTERNAL_MC_ME.PCTL188.R = 0x7; // LINFLEX1
  INTERNAL_MC_ME.PCTL190.R = 0x7; // CANFD1
  INTERNAL_MC_ME.PCTL192.R = 0x7; // SPI1
  INTERNAL_MC_ME.PCTL194.R = 0x7; // SPI3
  INTERNAL_MC_ME.PCTL204.R = 0x7; // CRC
  INTERNAL_MC_ME.PCTL206.R = 0x7; // TSENSE
  INTERNAL_MC_ME.PCTL208.R = 0x7; // VIU1
  INTERNAL_MC_ME.PCTL212.R = 0x7; // JPEG
  INTERNAL_MC_ME.PCTL216.R = 0x7; // H264_DEC
  INTERNAL_MC_ME.PCTL220.R = 0x7; //H264_ENC
  INTERNAL_MC_ME.PCTL236.R = 0x7; //MBIST
}

#ifndef NOT_USED_CLOCK
void enable_clkout()
{
	MC_CGM_0.AC10_SC.B.SELCTL = 2;  // arm pll phi0
	MC_CGM_0.AC10_DC0.B.DE = 1;
	MC_CGM_0.AC10_DC0.B.DIV = 15;	//div by 10

	SIUL2.MSCR[39].R = 0x00000000;
	SIUL2.MSCR[39].B.MUX_MODE = 2;
	SIUL2.MSCR[39].B.OBE = 1;
	SIUL2.MSCR[39].B.DSE = 1;
}
#endif
