/*========================================================================*
*                          Copyright 2018 NXP.
*
* This software is owned or controlled by NXP and may only be used strictly
* in accordance with the applicable license terms. By expressly accepting
* such terms or by downloading, installing, activating and/or otherwise
* using the software, you are agreeing that you have read, and that you
* agree to comply with and are bound by, such license terms. If you do not
* agree to be bound by the applicable license terms, then you may not retain,
* install, activate or otherwise use the software.
*
 **************************************************************************/

/*
 * File:		init.h
 * Purpose:		MCU and Perph Init Routines
 *
 */


#ifndef INIT_H_
#define INIT_H_

#ifdef __cplusplus
extern "C"
{
#endif //End ifdef __cplusplus


#include "typedefs.h"

#define RESET_M 0
#define TEST_M 1
#define DRUN_M 3
#define RUN0_M 4
#define RUN1_M 5
#define RUN2_M 6
#define RUN3_M 7
/********************************************************************/

void pll_init(void);
void mode_init(void);
void mode_enter(uint16_t mode);
void peripherals_clock_enable(void);
/********************************************************************/

#ifdef __cplusplus
};
#endif //End ifdef __cplusplus

#endif /* INIT_H_ */

