/*****************************************************************************
 *
 * NXP Confidential Proprietary
 *
 * Copyright (c) 2018 NXP Semiconductor;
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/


.globl Reset_Handler
.globl _exit
.globl interrupt_enable
.globl m4_hard_fault_handler
.extern sys_init_test
.extern m4_hard_fault_routine 
.extern nvic_init
.extern __StackTop

#ifdef START_FROM_FLASH
 .extern    __SRAM_START_ADDRESS__
 .extern    __RAM_SIZE__
#endif

.thumb
.syntax unified
///////////////////////////////////////////////
// Initialize the GPRs
///////////////////////////////////////////////
Reset_Handler:
    mov     r0,#0                   
    mov     r1,#0
    mov     r2,#0
    mov     r3,#0
    mov     r4,#0
    mov     r5,#0
    mov     r6,#0
    mov     r7,#0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7
  
// set stack   
    ldr r0, =__StackTop
    mov sp, r0
    
// Disable Watchdog
    movw     r0,#0xA010   // swt0_sr (0x4000a010)
    movt     r0,#0x4000
	movw     r1,#0xC520
	str      r1, [r0]
	movw     r1,#0xD928
	str      r1, [r0]
	movw     r0,#0xA000   // swto_cr (0x4000A000)
	movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0xFF00
	str      r1, [r0]

    movw     r0,#0x6010   //swt4_sr (0x40086010UL)
    movt     r0,#0x4008
	movw     r1,#0xC520   //key
	str      r1, [r0]
	movw     r1,#0xD928
	str      r1, [r0]
	movw     r0,#0x6000   //swt4_cr (0x40086000UL)
	movt     r0,#0x4008
	movw     r1,#0x0000  //swt disable
	movt     r1,#0xFF00
	str      r1, [r0]


// TCM data memory init

    movw     r0,#0x3000   // mm.l $40003000 $00000040
    movt     r0,#0x4000
	movw     r1,#0x0040
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3004   // mm.l $40003004 $03030000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0303
	str      r1, [r0]

    movw     r0,#0x3008   // mm.l $40003008 $00400000
    movt     r0,#0x4000

    ldr r1, =__TCM_DATA_SIZE__
	str      r1, [r0]

    movw     r0,#0x300C   // mm.l $4000300C $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3010   // mm.l $40003010 $3e800000
    movt     r0,#0x4000

    ldr r1, =__TCM_DATA_START_ADDRESS__
	str      r1, [r0]

    movw     r0,#0x3014   // mm.l $40003014 $00010008
    movt     r0,#0x4000
	movw     r1,#0x0008
	movt     r1,#0x0001
	str      r1, [r0]

    movw     r0,#0x3018   // mm.l $40003018 $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x301C   // mm.l $4000301C $00010089
    movt     r0,#0x4000
	movw     r1,#0x0001
	movt     r1,#0x0001
	str      r1, [r0]

.sram_loop_tcm:
    movw     r0,#0x301C
    movt     r0,#0x4000
	ldr	r3, [r0]
	and	r3, r3, #128
	cmp	r3, #128
	bne	.sram_loop_tcm
    
#ifdef START_FROM_FLASH

// ECC init of SRAM with use eDMA TCD0

    movw     r0,#0x3000   // mm.l $40003000 $00000040
    movt     r0,#0x4000
	movw     r1,#0x0040
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3004   // mm.l $40003004 $03030000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0303
	str      r1, [r0]

    movw     r0,#0x3008   // mm.l $40003008 $00400000
    movt     r0,#0x4000

    ldr r1, =__RAM_SIZE__
	str      r1, [r0]

    movw     r0,#0x300C   // mm.l $4000300C $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3010   // mm.l $40003010 $3e800000
    movt     r0,#0x4000

    ldr r1, =__SRAM_START_ADDRESS__
	str      r1, [r0]

    movw     r0,#0x3014   // mm.l $40003014 $00010008
    movt     r0,#0x4000
	movw     r1,#0x0008
	movt     r1,#0x0001
	str      r1, [r0]

    movw     r0,#0x3018   // mm.l $40003018 $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x301C   // mm.l $4000301C $00010089
    movt     r0,#0x4000
	movw     r1,#0x0001
	movt     r1,#0x0001
	str      r1, [r0]

.sram_loop:
    movw     r0,#0x301C
    movt     r0,#0x4000
	ldr	r3, [r0]
	and	r3, r3, #128
	cmp	r3, #128
	bne	.sram_loop

#endif
    
    bl init_data
#if defined (__VFP_FP__) && !defined(__SOFTFP__)    
    bl init_FPU
#endif /* #if defined (__VFP_FP__) && !defined(__SOFTFP__)*/    

#ifndef __START
#define __START _start
#endif
    bl __START

__done:
_exit:
    b   __done

interrupt_enable:
    cpsie i
    bx    lr

m4_hard_fault_handler:
    mov r0, sp
    push {lr}
    bl m4_hard_fault_routine
    pop {pc}
     
     
